/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.network.ByteBufferWriter;
import zombie.core.opengl.Shader;
import zombie.core.raknet.UdpConnection;
import zombie.core.skinnedmodel.model.WorldItemModelDrawer;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.inventory.InventoryItem;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;

public class IsoCarBatteryCharger
extends IsoObject {
    protected InventoryItem item;
    protected InventoryItem battery;
    protected boolean activated;
    protected float lastUpdate = -1.0f;
    protected float chargeRate = 0.16666667f;
    protected IsoSprite chargerSprite;
    protected IsoSprite batterySprite;
    protected long sound = 0L;

    public IsoCarBatteryCharger(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoCarBatteryCharger(InventoryItem inventoryItem, IsoCell isoCell, IsoGridSquare isoGridSquare) {
        super(isoCell, isoGridSquare, (IsoSprite)null);
        if (inventoryItem == null) {
            throw new NullPointerException("item is null");
        }
        this.item = inventoryItem;
    }

    @Override
    public String getObjectName() {
        return "IsoCarBatteryCharger";
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        super.load(byteBuffer, n, bl);
        if (byteBuffer.get() == 1) {
            try {
                this.item = InventoryItem.loadItem(byteBuffer, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (byteBuffer.get() == 1) {
            try {
                this.battery = InventoryItem.loadItem(byteBuffer, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.activated = byteBuffer.get() == 1;
        this.lastUpdate = byteBuffer.getFloat();
        this.chargeRate = byteBuffer.getFloat();
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        if (this.item == null) {
            assert (false);
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.item.saveWithSize(byteBuffer, false);
        }
        if (this.battery == null) {
            byteBuffer.put((byte)0);
        } else {
            byteBuffer.put((byte)1);
            this.battery.saveWithSize(byteBuffer, false);
        }
        byteBuffer.put(this.activated ? (byte)1 : 0);
        byteBuffer.putFloat(this.lastUpdate);
        byteBuffer.putFloat(this.chargeRate);
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.getCell().addToProcessIsoObject(this);
    }

    @Override
    public void removeFromWorld() {
        this.stopChargingSound();
        super.removeFromWorld();
    }

    @Override
    public void update() {
        float f;
        boolean bl;
        super.update();
        if (!(this.battery instanceof DrainableComboItem)) {
            this.battery = null;
        }
        if (this.battery == null) {
            this.lastUpdate = -1.0f;
            this.activated = false;
            this.stopChargingSound();
            return;
        }
        boolean bl2 = bl = this.square != null && (this.square.haveElectricity() || IsoWorld.instance.isHydroPowerOn() && this.square.getRoom() != null);
        if (!bl) {
            this.activated = false;
        }
        if (!this.activated) {
            this.lastUpdate = -1.0f;
            this.stopChargingSound();
            return;
        }
        this.startChargingSound();
        DrainableComboItem drainableComboItem = (DrainableComboItem)this.battery;
        if (drainableComboItem.getUsedDelta() >= 1.0f) {
            return;
        }
        float f2 = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.lastUpdate < 0.0f) {
            this.lastUpdate = f2;
        }
        if (this.lastUpdate > f2) {
            this.lastUpdate = f2;
        }
        if ((f = f2 - this.lastUpdate) > 0.0f) {
            drainableComboItem.setUsedDelta(Math.min(1.0f, drainableComboItem.getUsedDelta() + this.chargeRate * f));
            this.lastUpdate = f2;
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        this.chargerSprite = this.configureSprite(this.item, this.chargerSprite);
        if (this.chargerSprite.CurrentAnim == null || this.chargerSprite.CurrentAnim.Frames.isEmpty()) {
            return;
        }
        Texture texture = this.chargerSprite.CurrentAnim.Frames.get(0).getTexture(this.dir);
        if (texture == null) {
            return;
        }
        float f4 = (float)texture.getWidthOrig() * this.chargerSprite.def.getScaleX() / 2.0f;
        float f5 = (float)texture.getHeightOrig() * this.chargerSprite.def.getScaleY() * 3.0f / 4.0f;
        this.offsetY = 0.0f;
        this.offsetX = 0.0f;
        this.setAlpha(IsoCamera.frameState.playerIndex, 1.0f);
        float f6 = 0.5f;
        float f7 = 0.5f;
        float f8 = 0.0f;
        this.sx = 0.0f;
        this.item.setWorldZRotation(315);
        if (!WorldItemModelDrawer.renderMain(this.getItem(), this.getSquare(), this.getX() + f6, this.getY() + f7, this.getZ() + f8, -1.0f)) {
            this.chargerSprite.render(this, f + f6, f2 + f7, f3 + f8, this.dir, this.offsetX + f4 + (float)(8 * Core.TileScale), this.offsetY + f5 + (float)(4 * Core.TileScale), colorInfo, true);
        }
        if (this.battery != null) {
            this.batterySprite = this.configureSprite(this.battery, this.batterySprite);
            if (this.batterySprite != null && this.batterySprite.CurrentAnim != null && !this.batterySprite.CurrentAnim.Frames.isEmpty()) {
                this.sx = 0.0f;
                this.getBattery().setWorldZRotation(90);
                if (!WorldItemModelDrawer.renderMain(this.getBattery(), this.getSquare(), this.getX() + 0.75f, this.getY() + 0.75f, this.getZ() + f8, -1.0f)) {
                    this.batterySprite.render(this, f + f6, f2 + f7, f3 + f8, this.dir, this.offsetX + f4 - 8.0f + (float)Core.TileScale, this.offsetY + f5 - (float)(4 * Core.TileScale), colorInfo, true);
                }
            }
        }
    }

    @Override
    public void renderObjectPicker(float f, float f2, float f3, ColorInfo colorInfo) {
    }

    private IsoSprite configureSprite(InventoryItem inventoryItem, IsoSprite isoSprite) {
        Texture texture;
        String string = inventoryItem.getWorldTexture();
        try {
            texture = Texture.getSharedTexture(string);
            if (texture == null) {
                string = inventoryItem.getTex().getName();
            }
        }
        catch (Exception exception) {
            string = "media/inventory/world/WItem_Sack.png";
        }
        texture = Texture.getSharedTexture(string);
        boolean bl = false;
        if (isoSprite == null) {
            isoSprite = IsoSprite.CreateSprite(IsoSpriteManager.instance);
        }
        if (isoSprite.CurrentAnim == null) {
            isoSprite.LoadFramesNoDirPageSimple(string);
            isoSprite.CurrentAnim.name = string;
            bl = true;
        } else if (!string.equals(isoSprite.CurrentAnim.name)) {
            isoSprite.ReplaceCurrentAnimFrames(string);
            isoSprite.CurrentAnim.name = string;
            bl = true;
        }
        if (bl) {
            if (inventoryItem.getScriptItem() == null) {
                isoSprite.def.scaleAspect(texture.getWidthOrig(), texture.getHeightOrig(), 16 * Core.TileScale, 16 * Core.TileScale);
            } else if (this.battery != null && this.battery.getScriptItem() != null) {
                float f = this.battery.getScriptItem().ScaleWorldIcon * ((float)Core.TileScale / 2.0f);
                isoSprite.def.setScale(f, f);
            }
        }
        return isoSprite;
    }

    @Override
    public void syncIsoObjectSend(ByteBufferWriter byteBufferWriter) {
        byte by = (byte)this.getObjectIndex();
        byteBufferWriter.putInt(this.square.getX());
        byteBufferWriter.putInt(this.square.getY());
        byteBufferWriter.putInt(this.square.getZ());
        byteBufferWriter.putByte(by);
        byteBufferWriter.putByte((byte)1);
        byteBufferWriter.putByte((byte)0);
        if (this.battery == null) {
            byteBufferWriter.putByte((byte)0);
        } else {
            byteBufferWriter.putByte((byte)1);
            try {
                this.battery.saveWithSize(byteBufferWriter.bb, false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        byteBufferWriter.putBoolean(this.activated);
        byteBufferWriter.putFloat(this.chargeRate);
    }

    @Override
    public void syncIsoObject(boolean bl, byte by, UdpConnection udpConnection, ByteBuffer byteBuffer) {
        block8: {
            block9: {
                block7: {
                    if (!GameClient.bClient || bl) break block7;
                    ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(GameClient.connection);
                    break block8;
                }
                if (!GameServer.bServer || bl) break block9;
                for (UdpConnection udpConnection2 : GameServer.udpEngine.connections) {
                    ByteBufferWriter byteBufferWriter = udpConnection2.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection2);
                }
                break block8;
            }
            if (!bl) break block8;
            if (byteBuffer.get() == 1) {
                try {
                    this.battery = InventoryItem.loadItem(byteBuffer, 195);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.battery = null;
            }
            this.activated = byteBuffer.get() == 1;
            this.chargeRate = byteBuffer.getFloat();
            if (GameServer.bServer) {
                for (UdpConnection udpConnection3 : GameServer.udpEngine.connections) {
                    if (udpConnection == null || udpConnection3 == udpConnection) continue;
                    ByteBufferWriter byteBufferWriter = udpConnection3.startPacket();
                    PacketTypes.PacketType.SyncIsoObject.doPacket(byteBufferWriter);
                    this.syncIsoObjectSend(byteBufferWriter);
                    PacketTypes.PacketType.SyncIsoObject.send(udpConnection3);
                }
            }
        }
    }

    public void sync() {
        this.syncIsoObject(false, (byte)0, null, null);
    }

    public InventoryItem getItem() {
        return this.item;
    }

    public InventoryItem getBattery() {
        return this.battery;
    }

    public void setBattery(InventoryItem inventoryItem) {
        if (inventoryItem != null) {
            if (!(inventoryItem instanceof DrainableComboItem)) {
                throw new IllegalArgumentException("battery isn't DrainableComboItem");
            }
            if (this.battery != null) {
                throw new IllegalStateException("battery already inserted");
            }
        }
        this.battery = inventoryItem;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean bl) {
        this.activated = bl;
    }

    public float getChargeRate() {
        return this.chargeRate;
    }

    public void setChargeRate(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("chargeRate <= 0.0f");
        }
        this.chargeRate = f;
    }

    private void startChargingSound() {
        if (GameServer.bServer) {
            return;
        }
        if (this.getObjectIndex() == -1) {
            return;
        }
        if (this.sound == -1L) {
            return;
        }
        if (this.emitter == null) {
            this.emitter = IsoWorld.instance.getFreeEmitter((float)this.square.x + 0.5f, (float)this.square.y + 0.5f, this.square.z);
            IsoWorld.instance.takeOwnershipOfEmitter(this.emitter);
        }
        if (!this.emitter.isPlaying(this.sound)) {
            this.sound = this.emitter.playSound("CarBatteryChargerRunning");
            if (this.sound == 0L) {
                this.sound = -1L;
            }
        }
        this.emitter.tick();
    }

    private void stopChargingSound() {
        if (GameServer.bServer) {
            return;
        }
        if (this.emitter == null) {
            return;
        }
        this.emitter.stopOrTriggerSound(this.sound);
        this.sound = 0L;
        IsoWorld.instance.returnOwnershipOfEmitter(this.emitter);
        this.emitter = null;
    }
}

