/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import zombie.GameTime;
import zombie.core.Rand;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoPhysicsObject;
import zombie.iso.IsoWorld;
import zombie.iso.Vector2;
import zombie.iso.sprite.IsoSpriteInstance;

public class IsoBloodDrop
extends IsoPhysicsObject {
    public float tintb = 1.0f;
    public float tintg = 1.0f;
    public float tintr = 1.0f;
    public float time = 0.0f;
    float sx = 0.0f;
    float sy = 0.0f;
    float lsx = 0.0f;
    float lsy = 0.0f;
    static Vector2 temp = new Vector2();

    public IsoBloodDrop(IsoCell isoCell) {
        super(isoCell);
    }

    @Override
    public boolean Serialize() {
        return false;
    }

    @Override
    public String getObjectName() {
        return "ZombieGiblets";
    }

    @Override
    public void collideGround() {
        float f = this.x - (float)((int)this.x);
        float f2 = this.y - (float)((int)this.y);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)this.x, (int)this.y, (int)this.z);
        if (isoGridSquare != null) {
            IsoObject isoObject = isoGridSquare.getFloor();
            isoObject.addChild(this);
            this.setCollidable(false);
            IsoWorld.instance.CurrentCell.getRemoveList().add(this);
        }
    }

    @Override
    public void collideWall() {
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)this.x, (int)this.y, (int)this.z);
        if (isoGridSquare != null) {
            IsoObject isoObject = null;
            if (this.isCollidedN()) {
                isoObject = isoGridSquare.getWall(true);
            } else if (this.isCollidedS()) {
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)this.x, (int)this.y + 1, (int)this.z);
                if (isoGridSquare != null) {
                    isoObject = isoGridSquare.getWall(true);
                }
            } else if (this.isCollidedW()) {
                isoObject = isoGridSquare.getWall(false);
            } else if (this.isCollidedE() && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)this.x + 1, (int)this.y, (int)this.z)) != null) {
                isoObject = isoGridSquare.getWall(false);
            }
            if (isoObject != null) {
                isoObject.addChild(this);
                this.setCollidable(false);
                IsoWorld.instance.CurrentCell.getRemoveList().add(this);
            }
        }
    }

    @Override
    public void update() {
        super.update();
        this.time += GameTime.instance.getMultipliedSecondsSinceLastUpdate();
        if (this.velX == 0.0f && this.velY == 0.0f && this.getZ() == (float)((int)this.getZ())) {
            this.setCollidable(false);
            IsoWorld.instance.CurrentCell.getRemoveList().add(this);
        }
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        this.setTargetAlpha(0.3f);
        this.sprite.render(this, f, f2, f3, this.dir, this.offsetX, this.offsetY, colorInfo, true);
    }

    public IsoBloodDrop(IsoCell isoCell, float f, float f2, float f3, float f4, float f5) {
        super(isoCell);
        this.velX = f4 * 2.0f;
        this.velY = f5 * 2.0f;
        this.terminalVelocity = -0.1f;
        this.velZ += ((float)Rand.Next(10000) / 10000.0f - 0.5f) * 0.05f;
        float f6 = (float)Rand.Next(9000) / 10000.0f;
        this.velX *= (f6 += 0.1f);
        this.velY *= f6;
        this.velZ += f6 * 0.05f;
        if (Rand.Next(7) == 0) {
            this.velX *= 2.0f;
            this.velY *= 2.0f;
        }
        this.velX *= 0.8f;
        this.velY *= 0.8f;
        IsoBloodDrop.temp.x = this.velX;
        IsoBloodDrop.temp.y = this.velY;
        temp.rotate(((float)Rand.Next(1000) / 1000.0f - 0.5f) * 0.07f);
        if (Rand.Next(3) == 0) {
            temp.rotate(((float)Rand.Next(1000) / 1000.0f - 0.5f) * 0.1f);
        }
        if (Rand.Next(5) == 0) {
            temp.rotate(((float)Rand.Next(1000) / 1000.0f - 0.5f) * 0.2f);
        }
        if (Rand.Next(8) == 0) {
            temp.rotate(((float)Rand.Next(1000) / 1000.0f - 0.5f) * 0.3f);
        }
        if (Rand.Next(10) == 0) {
            temp.rotate(((float)Rand.Next(1000) / 1000.0f - 0.5f) * 0.4f);
        }
        this.velX = IsoBloodDrop.temp.x;
        this.velY = IsoBloodDrop.temp.y;
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.nx = f;
        this.ny = f2;
        this.setAlpha(0.5f);
        this.def = IsoSpriteInstance.get(this.sprite);
        this.def.alpha = 0.4f;
        this.sprite.def.alpha = 0.4f;
        this.offsetX = -26.0f;
        this.offsetY = -242.0f;
        this.offsetX += 8.0f;
        this.offsetY += 9.0f;
        this.sprite.LoadFramesNoDirPageSimple("BloodSplat");
    }
}

