/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.Lua.LuaEventManager;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.ai.states.ThumpState;
import zombie.audio.parameters.ParameterMeleeHitSurface;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.math.PZMath;
import zombie.core.opengl.Shader;
import zombie.core.textures.ColorInfo;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.HandWeapon;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.RenderEffectType;
import zombie.iso.objects.interfaces.BarricadeAble;
import zombie.iso.objects.interfaces.Thumpable;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.util.Type;

public class IsoBarricade
extends IsoObject
implements Thumpable {
    public static final int MAX_PLANKS = 4;
    public static final int PLANK_HEALTH = 1000;
    private int[] plankHealth = new int[4];
    public static final int METAL_HEALTH = 5000;
    public static final int METAL_HEALTH_DAMAGED = 2500;
    private int metalHealth;
    public static final int METAL_BAR_HEALTH = 3000;
    private int metalBarHealth;

    public IsoBarricade(IsoCell isoCell) {
        super(isoCell);
    }

    public IsoBarricade(IsoCell isoCell, IsoGridSquare isoGridSquare, IsoDirections isoDirections) {
        this.square = isoGridSquare;
        this.dir = isoDirections;
    }

    @Override
    public String getObjectName() {
        return "Barricade";
    }

    public void addPlank(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        int n;
        if (!this.canAddPlank()) {
            return;
        }
        int n2 = 1000;
        if (inventoryItem != null) {
            n2 = (int)((float)inventoryItem.getCondition() / (float)inventoryItem.getConditionMax() * 1000.0f);
        }
        if (isoGameCharacter != null) {
            n2 = (int)((float)n2 * isoGameCharacter.getBarricadeStrengthMod());
        }
        for (n = 0; n < 4; ++n) {
            if (this.plankHealth[n] > 0) continue;
            this.plankHealth[n] = n2;
            break;
        }
        this.chooseSprite();
        if (!GameServer.bServer) {
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                LosUtil.cachecleared[n] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
        if (this.square != null) {
            this.square.RecalcProperties();
        }
    }

    public InventoryItem removePlank(IsoGameCharacter isoGameCharacter) {
        int n;
        if (this.getNumPlanks() <= 0) {
            return null;
        }
        InventoryItem inventoryItem = null;
        for (n = 3; n >= 0; --n) {
            if (this.plankHealth[n] <= 0) continue;
            float f = Math.min((float)this.plankHealth[n] / 1000.0f, 1.0f);
            inventoryItem = InventoryItemFactory.CreateItem("Base.Plank");
            inventoryItem.setCondition((int)Math.max((float)inventoryItem.getConditionMax() * f, 1.0f));
            this.plankHealth[n] = 0;
            break;
        }
        if (this.getNumPlanks() <= 0) {
            if (this.square != null) {
                if (GameServer.bServer) {
                    this.square.transmitRemoveItemFromSquare(this);
                } else {
                    this.square.RemoveTileObject(this);
                }
            }
        } else {
            this.chooseSprite();
            if (!GameServer.bServer) {
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    LosUtil.cachecleared[n] = true;
                }
                IsoGridSquare.setRecalcLightTime(-1);
                GameTime.instance.lightSourceUpdate = 100.0f;
            }
            if (this.square != null) {
                this.square.RecalcProperties();
            }
        }
        return inventoryItem;
    }

    public int getNumPlanks() {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.plankHealth[i] <= 0) continue;
            ++n;
        }
        return n;
    }

    public boolean canAddPlank() {
        return !this.isMetal() && this.getNumPlanks() < 4 && !this.isMetalBar();
    }

    public void addMetalBar(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        if (this.getNumPlanks() > 0) {
            return;
        }
        if (this.metalHealth > 0) {
            return;
        }
        if (this.metalBarHealth > 0) {
            return;
        }
        this.metalBarHealth = 3000;
        if (inventoryItem != null) {
            this.metalBarHealth = (int)((float)inventoryItem.getCondition() / (float)inventoryItem.getConditionMax() * 5000.0f);
        }
        if (isoGameCharacter != null) {
            this.metalBarHealth = (int)((float)this.metalBarHealth * isoGameCharacter.getMetalBarricadeStrengthMod());
        }
        this.chooseSprite();
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
        if (this.square != null) {
            this.square.RecalcProperties();
        }
    }

    public InventoryItem removeMetalBar(IsoGameCharacter isoGameCharacter) {
        if (this.metalBarHealth <= 0) {
            return null;
        }
        float f = Math.min((float)this.metalBarHealth / 3000.0f, 1.0f);
        this.metalBarHealth = 0;
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.MetalBar");
        inventoryItem.setCondition((int)Math.max((float)inventoryItem.getConditionMax() * f, 1.0f));
        if (this.square != null) {
            if (GameServer.bServer) {
                this.square.transmitRemoveItemFromSquare(this);
            } else {
                this.square.RemoveTileObject(this);
            }
        }
        return inventoryItem;
    }

    public void addMetal(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        if (this.getNumPlanks() > 0) {
            return;
        }
        if (this.metalHealth > 0) {
            return;
        }
        this.metalHealth = 5000;
        if (inventoryItem != null) {
            this.metalHealth = (int)((float)inventoryItem.getCondition() / (float)inventoryItem.getConditionMax() * 5000.0f);
        }
        if (isoGameCharacter != null) {
            this.metalHealth = (int)((float)this.metalHealth * isoGameCharacter.getMetalBarricadeStrengthMod());
        }
        this.chooseSprite();
        if (!GameServer.bServer) {
            for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
                LosUtil.cachecleared[i] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
        if (this.square != null) {
            this.square.RecalcProperties();
        }
    }

    public boolean isMetalBar() {
        return this.metalBarHealth > 0;
    }

    public InventoryItem removeMetal(IsoGameCharacter isoGameCharacter) {
        if (this.metalHealth <= 0) {
            return null;
        }
        float f = Math.min((float)this.metalHealth / 5000.0f, 1.0f);
        this.metalHealth = 0;
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem("Base.SheetMetal");
        inventoryItem.setCondition((int)Math.max((float)inventoryItem.getConditionMax() * f, 1.0f));
        if (this.square != null) {
            if (GameServer.bServer) {
                this.square.transmitRemoveItemFromSquare(this);
            } else {
                this.square.RemoveTileObject(this);
            }
        }
        return inventoryItem;
    }

    public boolean isMetal() {
        return this.metalHealth > 0;
    }

    public boolean isBlockVision() {
        return this.isMetal() || this.getNumPlanks() > 2;
    }

    private void chooseSprite() {
        IsoSpriteManager isoSpriteManager = IsoSpriteManager.instance;
        if (this.metalHealth > 0) {
            int n = this.metalHealth <= 2500 ? 2 : 0;
            String string = "constructedobjects_01";
            switch (this.dir) {
                case W: {
                    this.sprite = isoSpriteManager.getSprite(string + "_" + (24 + n));
                    break;
                }
                case N: {
                    this.sprite = isoSpriteManager.getSprite(string + "_" + (25 + n));
                    break;
                }
                case E: {
                    this.sprite = isoSpriteManager.getSprite(string + "_" + (28 + n));
                    break;
                }
                case S: {
                    this.sprite = isoSpriteManager.getSprite(string + "_" + (29 + n));
                    break;
                }
                default: {
                    this.sprite.LoadFramesNoDirPageSimple("media/ui/missing-tile.png");
                }
            }
            return;
        }
        if (this.metalBarHealth > 0) {
            String string = "constructedobjects_01";
            switch (this.dir) {
                case W: {
                    this.sprite = isoSpriteManager.getSprite(string + "_55");
                    break;
                }
                case N: {
                    this.sprite = isoSpriteManager.getSprite(string + "_53");
                    break;
                }
                case E: {
                    this.sprite = isoSpriteManager.getSprite(string + "_52");
                    break;
                }
                case S: {
                    this.sprite = isoSpriteManager.getSprite(string + "_54");
                    break;
                }
                default: {
                    this.sprite.LoadFramesNoDirPageSimple("media/ui/missing-tile.png");
                }
            }
            return;
        }
        int n = this.getNumPlanks();
        if (n <= 0) {
            this.sprite = isoSpriteManager.getSprite("media/ui/missing-tile.png");
            return;
        }
        String string = "carpentry_01";
        switch (this.dir) {
            case W: {
                this.sprite = isoSpriteManager.getSprite(string + "_" + (8 + (n - 1) * 2));
                break;
            }
            case N: {
                this.sprite = isoSpriteManager.getSprite(string + "_" + (9 + (n - 1) * 2));
                break;
            }
            case E: {
                this.sprite = isoSpriteManager.getSprite(string + "_" + (0 + (n - 1) * 2));
                break;
            }
            case S: {
                this.sprite = isoSpriteManager.getSprite(string + "_" + (1 + (n - 1) * 2));
                break;
            }
            default: {
                this.sprite.LoadFramesNoDirPageSimple("media/ui/missing-tile.png");
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.metalHealth <= 0 && this.getNumPlanks() <= 0 && this.metalBarHealth <= 0;
    }

    @Override
    public boolean TestCollide(IsoMovingObject isoMovingObject, IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        return false;
    }

    @Override
    public IsoObject.VisionResult TestVision(IsoGridSquare isoGridSquare, IsoGridSquare isoGridSquare2) {
        if (this.metalHealth <= 0 && this.getNumPlanks() <= 2) {
            return IsoObject.VisionResult.NoEffect;
        }
        if (isoGridSquare == this.square) {
            if (this.dir == IsoDirections.N && isoGridSquare2.getY() < isoGridSquare.getY()) {
                return IsoObject.VisionResult.Blocked;
            }
            if (this.dir == IsoDirections.S && isoGridSquare2.getY() > isoGridSquare.getY()) {
                return IsoObject.VisionResult.Blocked;
            }
            if (this.dir == IsoDirections.W && isoGridSquare2.getX() < isoGridSquare.getX()) {
                return IsoObject.VisionResult.Blocked;
            }
            if (this.dir == IsoDirections.E && isoGridSquare2.getX() > isoGridSquare.getX()) {
                return IsoObject.VisionResult.Blocked;
            }
        } else if (isoGridSquare2 == this.square && isoGridSquare != this.square) {
            return this.TestVision(isoGridSquare2, isoGridSquare);
        }
        return IsoObject.VisionResult.NoEffect;
    }

    @Override
    public void Thump(IsoMovingObject isoMovingObject) {
        if (this.isDestroyed()) {
            return;
        }
        if (isoMovingObject instanceof IsoZombie) {
            int n = this.getNumPlanks();
            boolean bl = this.metalHealth > 2500;
            int n2 = ThumpState.getFastForwardDamageMultiplier();
            this.Damage(((IsoZombie)isoMovingObject).strength * n2);
            if (n != this.getNumPlanks()) {
                ((IsoGameCharacter)isoMovingObject).getEmitter().playSound("BreakBarricadePlank");
                if (GameServer.bServer) {
                    GameServer.PlayWorldSoundServer("BreakBarricadePlank", false, isoMovingObject.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
                }
            }
            if (this.isDestroyed()) {
                if (this.getSquare().getBuilding() != null) {
                    this.getSquare().getBuilding().forceAwake();
                }
                this.square.transmitRemoveItemFromSquare(this);
                if (!GameServer.bServer) {
                    this.square.RemoveTileObject(this);
                }
            } else if ((n != this.getNumPlanks() || bl && this.metalHealth < 2500) && GameServer.bServer) {
                this.sendObjectChange("state");
            }
            if (!this.isDestroyed()) {
                this.setRenderEffect(RenderEffectType.Hit_Door, true);
            }
            WorldSoundManager.instance.addSound(isoMovingObject, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, true, 4.0f, 15.0f);
        }
    }

    @Override
    public Thumpable getThumpableFor(IsoGameCharacter isoGameCharacter) {
        if (this.isDestroyed()) {
            return null;
        }
        return this;
    }

    @Override
    public Vector2 getFacingPosition(Vector2 vector22) {
        if (this.square == null) {
            return vector22.set(0.0f, 0.0f);
        }
        if (this.dir == IsoDirections.N) {
            return vector22.set(this.getX() + 0.5f, this.getY());
        }
        if (this.dir == IsoDirections.S) {
            return vector22.set(this.getX() + 0.5f, this.getY() + 1.0f);
        }
        if (this.dir == IsoDirections.W) {
            return vector22.set(this.getX(), this.getY() + 0.5f);
        }
        if (this.dir == IsoDirections.E) {
            return vector22.set(this.getX() + 1.0f, this.getY() + 0.5f);
        }
        return vector22.set(this.getX(), this.getY() + 0.5f);
    }

    @Override
    public void WeaponHit(IsoGameCharacter isoGameCharacter, HandWeapon handWeapon) {
        String string;
        if (this.isDestroyed()) {
            return;
        }
        IsoPlayer isoPlayer = Type.tryCastTo(isoGameCharacter, IsoPlayer.class);
        if (GameClient.bClient) {
            if (isoPlayer != null) {
                GameClient.instance.sendWeaponHit(isoPlayer, handWeapon, this);
            }
            return;
        }
        LuaEventManager.triggerEvent("OnWeaponHitThumpable", isoGameCharacter, handWeapon, this);
        String string2 = string = this.isMetal() || this.isMetalBar() ? "HitBarricadeMetal" : "HitBarricadePlank";
        if (isoPlayer != null) {
            isoPlayer.setMeleeHitSurface(this.isMetal() || this.isMetalBar() ? ParameterMeleeHitSurface.Material.Metal : ParameterMeleeHitSurface.Material.Wood);
        }
        SoundManager.instance.PlayWorldSound(string, false, this.getSquare(), 1.0f, 20.0f, 2.0f, false);
        if (GameServer.bServer) {
            GameServer.PlayWorldSoundServer(string, false, this.getSquare(), 1.0f, 20.0f, 2.0f, false);
        }
        if (handWeapon != null) {
            this.Damage(handWeapon.getDoorDamage() * 5);
        } else {
            this.Damage(100);
        }
        WorldSoundManager.instance.addSound(isoGameCharacter, this.square.getX(), this.square.getY(), this.square.getZ(), 20, 20, false, 0.0f, 15.0f);
        if (this.isDestroyed()) {
            if (isoGameCharacter != null) {
                String string3 = string == "HitBarricadeMetal" ? "BreakBarricadeMetal" : "BreakBarricadePlank";
                isoGameCharacter.getEmitter().playSound(string3);
                if (GameServer.bServer) {
                    GameServer.PlayWorldSoundServer(string3, false, isoGameCharacter.getCurrentSquare(), 0.2f, 20.0f, 1.1f, true);
                }
            }
            this.square.transmitRemoveItemFromSquare(this);
            if (!GameServer.bServer) {
                this.square.RemoveTileObject(this);
            }
        }
        if (!this.isDestroyed()) {
            this.setRenderEffect(RenderEffectType.Hit_Door, true);
        }
    }

    public void DamageBarricade(int n) {
        this.Damage(n);
    }

    public void Damage(int n) {
        if ("Tutorial".equals(Core.GameMode)) {
            return;
        }
        if (this.metalHealth > 0) {
            this.metalHealth -= n;
            if (this.metalHealth <= 0) {
                this.metalHealth = 0;
                this.chooseSprite();
            }
            return;
        }
        if (this.metalBarHealth > 0) {
            this.metalBarHealth -= n;
            if (this.metalBarHealth <= 0) {
                this.metalBarHealth = 0;
                this.chooseSprite();
            }
            return;
        }
        for (int i = 3; i >= 0; --i) {
            if (this.plankHealth[i] <= 0) continue;
            int n2 = i;
            this.plankHealth[n2] = this.plankHealth[n2] - n;
            if (this.plankHealth[i] > 0) break;
            this.plankHealth[i] = 0;
            this.chooseSprite();
            break;
        }
    }

    @Override
    public float getThumpCondition() {
        if (this.metalHealth > 0) {
            return (float)PZMath.clamp(this.metalHealth, 0, 5000) / 5000.0f;
        }
        if (this.metalBarHealth > 0) {
            return (float)PZMath.clamp(this.metalBarHealth, 0, 3000) / 3000.0f;
        }
        for (int i = 3; i >= 0; --i) {
            if (this.plankHealth[i] <= 0) continue;
            return (float)PZMath.clamp(this.plankHealth[i], 0, 1000) / 1000.0f;
        }
        return 0.0f;
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        byte by = byteBuffer.get();
        this.dir = IsoDirections.fromIndex(by);
        int n2 = byteBuffer.get();
        for (int i = 0; i < n2; ++i) {
            short s = byteBuffer.getShort();
            if (i >= 4) continue;
            this.plankHealth[i] = s;
        }
        this.metalHealth = byteBuffer.getShort();
        if (n >= 90) {
            this.metalBarHealth = byteBuffer.getShort();
        }
        this.chooseSprite();
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.put((byte)1);
        byteBuffer.put(IsoObject.factoryGetClassID(this.getObjectName()));
        byteBuffer.put((byte)this.dir.index());
        byteBuffer.put((byte)4);
        for (int i = 0; i < 4; ++i) {
            byteBuffer.putShort((short)this.plankHealth[i]);
        }
        byteBuffer.putShort((short)this.metalHealth);
        byteBuffer.putShort((short)this.metalBarHealth);
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            for (int i = 0; i < 4; ++i) {
                byteBuffer.putShort((short)this.plankHealth[i]);
            }
            byteBuffer.putShort((short)this.metalHealth);
            byteBuffer.putShort((short)this.metalBarHealth);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("state".equals(string)) {
            int n;
            for (n = 0; n < 4; ++n) {
                this.plankHealth[n] = byteBuffer.getShort();
            }
            this.metalHealth = byteBuffer.getShort();
            this.metalBarHealth = byteBuffer.getShort();
            this.chooseSprite();
            if (this.square != null) {
                this.square.RecalcProperties();
            }
            for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                LosUtil.cachecleared[n] = true;
            }
            IsoGridSquare.setRecalcLightTime(-1);
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
    }

    public BarricadeAble getBarricadedObject() {
        block5: {
            ArrayList<IsoObject> arrayList;
            block4: {
                int n = this.getSpecialObjectIndex();
                if (n == -1) {
                    return null;
                }
                arrayList = this.getSquare().getSpecialObjects();
                if (this.getDir() != IsoDirections.W && this.getDir() != IsoDirections.N) break block4;
                boolean bl = this.getDir() == IsoDirections.N;
                for (int i = n - 1; i >= 0; --i) {
                    IsoObject isoObject = arrayList.get(i);
                    if (!(isoObject instanceof BarricadeAble) || bl != ((BarricadeAble)((Object)isoObject)).getNorth()) continue;
                    return (BarricadeAble)((Object)isoObject);
                }
                break block5;
            }
            if (this.getDir() != IsoDirections.E && this.getDir() != IsoDirections.S) break block5;
            boolean bl = this.getDir() == IsoDirections.S;
            int n = this.getSquare().getX() + (this.getDir() == IsoDirections.E ? 1 : 0);
            int n2 = this.getSquare().getY() + (this.getDir() == IsoDirections.S ? 1 : 0);
            IsoGridSquare isoGridSquare = this.getCell().getGridSquare((double)n, (double)n2, this.getZ());
            if (isoGridSquare != null) {
                arrayList = isoGridSquare.getSpecialObjects();
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    IsoObject isoObject = arrayList.get(i);
                    if (!(isoObject instanceof BarricadeAble) || bl != ((BarricadeAble)((Object)isoObject)).getNorth()) continue;
                    return (BarricadeAble)((Object)isoObject);
                }
            }
        }
        return null;
    }

    @Override
    public void render(float f, float f2, float f3, ColorInfo colorInfo, boolean bl, boolean bl2, Shader shader) {
        int n = IsoCamera.frameState.playerIndex;
        BarricadeAble barricadeAble = this.getBarricadedObject();
        if (barricadeAble != null && this.square.lighting[n].targetDarkMulti() <= barricadeAble.getSquare().lighting[n].targetDarkMulti()) {
            colorInfo = barricadeAble.getSquare().lighting[n].lightInfo();
            this.setTargetAlpha(n, ((IsoObject)((Object)barricadeAble)).getTargetAlpha(n));
        }
        super.render(f, f2, f3, colorInfo, bl, bl2, shader);
    }

    public static IsoBarricade GetBarricadeOnSquare(IsoGridSquare isoGridSquare, IsoDirections isoDirections) {
        if (isoGridSquare == null) {
            return null;
        }
        for (int i = 0; i < isoGridSquare.getSpecialObjects().size(); ++i) {
            IsoBarricade isoBarricade;
            IsoObject isoObject = isoGridSquare.getSpecialObjects().get(i);
            if (!(isoObject instanceof IsoBarricade) || (isoBarricade = (IsoBarricade)isoObject).getDir() != isoDirections) continue;
            return isoBarricade;
        }
        return null;
    }

    public static IsoBarricade GetBarricadeForCharacter(BarricadeAble barricadeAble, IsoGameCharacter isoGameCharacter) {
        if (barricadeAble == null || barricadeAble.getSquare() == null) {
            return null;
        }
        if (isoGameCharacter != null && (barricadeAble.getNorth() ? isoGameCharacter.getY() < (float)barricadeAble.getSquare().getY() : isoGameCharacter.getX() < (float)barricadeAble.getSquare().getX())) {
            return IsoBarricade.GetBarricadeOnSquare(barricadeAble.getOppositeSquare(), barricadeAble.getNorth() ? IsoDirections.S : IsoDirections.E);
        }
        return IsoBarricade.GetBarricadeOnSquare(barricadeAble.getSquare(), barricadeAble.getNorth() ? IsoDirections.N : IsoDirections.W);
    }

    public static IsoBarricade GetBarricadeOppositeCharacter(BarricadeAble barricadeAble, IsoGameCharacter isoGameCharacter) {
        if (barricadeAble == null || barricadeAble.getSquare() == null) {
            return null;
        }
        if (isoGameCharacter != null && (barricadeAble.getNorth() ? isoGameCharacter.getY() < (float)barricadeAble.getSquare().getY() : isoGameCharacter.getX() < (float)barricadeAble.getSquare().getX())) {
            return IsoBarricade.GetBarricadeOnSquare(barricadeAble.getSquare(), barricadeAble.getNorth() ? IsoDirections.N : IsoDirections.W);
        }
        return IsoBarricade.GetBarricadeOnSquare(barricadeAble.getOppositeSquare(), barricadeAble.getNorth() ? IsoDirections.S : IsoDirections.E);
    }

    public static IsoBarricade AddBarricadeToObject(BarricadeAble barricadeAble, boolean bl) {
        int n;
        IsoGridSquare isoGridSquare = bl ? barricadeAble.getOppositeSquare() : barricadeAble.getSquare();
        IsoDirections isoDirections = null;
        if (barricadeAble.getNorth()) {
            isoDirections = bl ? IsoDirections.S : IsoDirections.N;
        } else {
            IsoDirections isoDirections2 = isoDirections = bl ? IsoDirections.E : IsoDirections.W;
        }
        if (isoGridSquare == null || isoDirections == null) {
            return null;
        }
        IsoBarricade isoBarricade = IsoBarricade.GetBarricadeOnSquare(isoGridSquare, isoDirections);
        if (isoBarricade != null) {
            return isoBarricade;
        }
        isoBarricade = new IsoBarricade(IsoWorld.instance.CurrentCell, isoGridSquare, isoDirections);
        int n2 = -1;
        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
            IsoObject isoObject = isoGridSquare.getObjects().get(n);
            if (!(isoObject instanceof IsoCurtain)) continue;
            IsoCurtain isoCurtain = (IsoCurtain)isoObject;
            if (isoCurtain.getType() == IsoObjectType.curtainW && isoDirections == IsoDirections.W) {
                n2 = n;
            } else if (isoCurtain.getType() == IsoObjectType.curtainN && isoDirections == IsoDirections.N) {
                n2 = n;
            } else if (isoCurtain.getType() == IsoObjectType.curtainE && isoDirections == IsoDirections.E) {
                n2 = n;
            } else if (isoCurtain.getType() == IsoObjectType.curtainS && isoDirections == IsoDirections.S) {
                n2 = n;
            }
            if (n2 != -1) break;
        }
        isoGridSquare.AddSpecialObject(isoBarricade, n2);
        for (n = 0; n < IsoPlayer.numPlayers; ++n) {
            LosUtil.cachecleared[n] = true;
        }
        IsoGridSquare.setRecalcLightTime(-1);
        GameTime.instance.lightSourceUpdate = 100.0f;
        return isoBarricade;
    }

    public static IsoBarricade AddBarricadeToObject(BarricadeAble barricadeAble, IsoGameCharacter isoGameCharacter) {
        if (barricadeAble == null || barricadeAble.getSquare() == null || isoGameCharacter == null) {
            return null;
        }
        if (barricadeAble.getNorth()) {
            boolean bl = isoGameCharacter.getY() < (float)barricadeAble.getSquare().getY();
            return IsoBarricade.AddBarricadeToObject(barricadeAble, bl);
        }
        boolean bl = isoGameCharacter.getX() < (float)barricadeAble.getSquare().getX();
        return IsoBarricade.AddBarricadeToObject(barricadeAble, bl);
    }
}

