/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.objects;

import java.io.IOException;
import java.nio.ByteBuffer;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.WorldSoundManager;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Clothing;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.interfaces.IClothingWasherDryerLogic;
import zombie.network.GameClient;
import zombie.network.GameServer;

public final class ClothingDryerLogic
implements IClothingWasherDryerLogic {
    private final IsoObject m_object;
    private boolean bActivated;
    private long soundInstance = -1L;
    private float lastUpdate = -1.0f;
    private boolean cycleFinished = false;
    private float startTime = 0.0f;
    private float cycleLengthMinutes = 90.0f;
    private boolean alreadyExecuted = false;

    public ClothingDryerLogic(IsoObject isoObject) {
        this.m_object = isoObject;
    }

    public IsoObject getObject() {
        return this.m_object;
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        this.bActivated = byteBuffer.get() == 1;
    }

    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        byteBuffer.put(this.isActivated() ? (byte)1 : 0);
    }

    @Override
    public void update() {
        if (this.getObject().getObjectIndex() == -1) {
            return;
        }
        if (this.getContainer() == null) {
            return;
        }
        if (!this.getContainer().isPowered()) {
            this.setActivated(false);
        }
        this.cycleFinished();
        this.updateSound();
        if (GameClient.bClient) {
            // empty if block
        }
        if (!this.isActivated()) {
            this.lastUpdate = -1.0f;
            return;
        }
        float f = (float)GameTime.getInstance().getWorldAgeHours();
        if (this.lastUpdate < 0.0f) {
            this.lastUpdate = f;
        } else if (this.lastUpdate > f) {
            this.lastUpdate = f;
        }
        float f2 = f - this.lastUpdate;
        int n = (int)(f2 * 60.0f);
        if (n < 1) {
            return;
        }
        this.lastUpdate = f;
        for (int i = 0; i < this.getContainer().getItems().size(); ++i) {
            InventoryItem inventoryItem;
            float f3;
            InventoryItem inventoryItem2 = this.getContainer().getItems().get(i);
            if (inventoryItem2 instanceof Clothing && (f3 = (inventoryItem = (Clothing)inventoryItem2).getWetness()) > 0.0f) {
                inventoryItem.setWetness(f3 -= (float)n);
                if (GameServer.bServer) {
                    // empty if block
                }
            }
            if (!inventoryItem2.isWet() || inventoryItem2.getItemWhenDry() == null) continue;
            inventoryItem2.setWetCooldown(inventoryItem2.getWetCooldown() - (float)(n * 250));
            if (!(inventoryItem2.getWetCooldown() <= 0.0f)) continue;
            inventoryItem = InventoryItemFactory.CreateItem(inventoryItem2.getItemWhenDry());
            this.getContainer().addItem(inventoryItem);
            this.getContainer().Remove(inventoryItem2);
            --i;
            inventoryItem2.setWet(false);
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(inventoryItem2);
        }
    }

    @Override
    public void saveChange(String string, KahluaTable kahluaTable, ByteBuffer byteBuffer) {
        if ("dryer.state".equals(string)) {
            byteBuffer.put(this.isActivated() ? (byte)1 : 0);
        }
    }

    @Override
    public void loadChange(String string, ByteBuffer byteBuffer) {
        if ("dryer.state".equals(string)) {
            this.setActivated(byteBuffer.get() == 1);
        }
    }

    @Override
    public ItemContainer getContainer() {
        return this.getObject().getContainerByType("clothingdryer");
    }

    private void updateSound() {
        if (this.isActivated()) {
            if (!GameServer.bServer) {
                if (this.getObject().emitter != null && this.getObject().emitter.isPlaying("ClothingDryerFinished")) {
                    this.getObject().emitter.stopOrTriggerSoundByName("ClothingDryerFinished");
                }
                if (this.soundInstance == -1L) {
                    this.getObject().emitter = IsoWorld.instance.getFreeEmitter(this.getObject().getX() + 0.5f, this.getObject().getY() + 0.5f, (int)this.getObject().getZ());
                    IsoWorld.instance.setEmitterOwner(this.getObject().emitter, this.getObject());
                    this.soundInstance = this.getObject().emitter.playSoundLoopedImpl("ClothingDryerRunning");
                }
            }
            if (!GameClient.bClient) {
                WorldSoundManager.instance.addSoundRepeating(this, this.getObject().square.x, this.getObject().square.y, this.getObject().square.z, 10, 10, false);
            }
        } else if (this.soundInstance != -1L) {
            this.getObject().emitter.stopOrTriggerSound(this.soundInstance);
            this.soundInstance = -1L;
            if (this.cycleFinished) {
                this.cycleFinished = false;
                this.getObject().emitter.playSoundImpl("ClothingDryerFinished", this.getObject());
            }
        }
    }

    private boolean cycleFinished() {
        if (this.isActivated()) {
            float f;
            int n;
            if (!this.alreadyExecuted) {
                this.startTime = (float)GameTime.getInstance().getWorldAgeHours();
                this.alreadyExecuted = true;
            }
            if ((float)(n = (int)((f = (float)GameTime.getInstance().getWorldAgeHours() - this.startTime) * 60.0f)) < this.cycleLengthMinutes) {
                return false;
            }
            this.cycleFinished = true;
            this.setActivated(false);
        }
        return true;
    }

    @Override
    public boolean isItemAllowedInContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        if (this.isActivated()) {
            return false;
        }
        return this.getContainer() == itemContainer;
    }

    @Override
    public boolean isRemoveItemAllowedFromContainer(ItemContainer itemContainer, InventoryItem inventoryItem) {
        if (!this.getContainer().isEmpty() && this.isActivated()) {
            return false;
        }
        return this.getContainer() == itemContainer;
    }

    @Override
    public boolean isActivated() {
        return this.bActivated;
    }

    @Override
    public void setActivated(boolean bl) {
        Thread thread;
        boolean bl2 = bl != this.bActivated;
        this.bActivated = bl;
        this.alreadyExecuted = false;
        if (bl2 && ((thread = Thread.currentThread()) == GameWindow.GameThread || thread == GameServer.MainThread)) {
            IsoGenerator.updateGenerator(this.getObject().getSquare());
        }
    }

    @Override
    public void switchModeOn() {
    }

    @Override
    public void switchModeOff() {
        this.setActivated(false);
        this.updateSound();
        this.cycleFinished = false;
    }
}

