/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.jobs;

import java.util.concurrent.ConcurrentLinkedQueue;
import zombie.core.Core;
import zombie.core.raknet.UdpConnection;
import zombie.iso.areas.isoregion.jobs.JobApplyChanges;
import zombie.iso.areas.isoregion.jobs.JobChunkUpdate;
import zombie.iso.areas.isoregion.jobs.JobDebugResetAllData;
import zombie.iso.areas.isoregion.jobs.JobServerSendFullData;
import zombie.iso.areas.isoregion.jobs.JobSquareUpdate;
import zombie.iso.areas.isoregion.jobs.RegionJob;

public final class RegionJobManager {
    private static final ConcurrentLinkedQueue<JobSquareUpdate> poolSquareUpdate = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<JobChunkUpdate> poolChunkUpdate = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<JobApplyChanges> poolApplyChanges = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<JobServerSendFullData> poolServerSendFullData = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<JobDebugResetAllData> poolDebugResetAllData = new ConcurrentLinkedQueue();

    public static JobSquareUpdate allocSquareUpdate(int n, int n2, int n3, byte by) {
        JobSquareUpdate jobSquareUpdate = poolSquareUpdate.poll();
        if (jobSquareUpdate == null) {
            jobSquareUpdate = new JobSquareUpdate();
        }
        jobSquareUpdate.worldSquareX = n;
        jobSquareUpdate.worldSquareY = n2;
        jobSquareUpdate.worldSquareZ = n3;
        jobSquareUpdate.newSquareFlags = by;
        return jobSquareUpdate;
    }

    public static JobChunkUpdate allocChunkUpdate() {
        JobChunkUpdate jobChunkUpdate = poolChunkUpdate.poll();
        if (jobChunkUpdate == null) {
            jobChunkUpdate = new JobChunkUpdate();
        }
        return jobChunkUpdate;
    }

    public static JobApplyChanges allocApplyChanges(boolean bl) {
        JobApplyChanges jobApplyChanges = poolApplyChanges.poll();
        if (jobApplyChanges == null) {
            jobApplyChanges = new JobApplyChanges();
        }
        jobApplyChanges.saveToDisk = bl;
        return jobApplyChanges;
    }

    public static JobServerSendFullData allocServerSendFullData(UdpConnection udpConnection) {
        JobServerSendFullData jobServerSendFullData = poolServerSendFullData.poll();
        if (jobServerSendFullData == null) {
            jobServerSendFullData = new JobServerSendFullData();
        }
        jobServerSendFullData.targetConn = udpConnection;
        return jobServerSendFullData;
    }

    public static JobDebugResetAllData allocDebugResetAllData() {
        JobDebugResetAllData jobDebugResetAllData = poolDebugResetAllData.poll();
        if (jobDebugResetAllData == null) {
            jobDebugResetAllData = new JobDebugResetAllData();
        }
        return jobDebugResetAllData;
    }

    public static void release(RegionJob regionJob) {
        regionJob.reset();
        switch (regionJob.getJobType()) {
            case SquareUpdate: {
                poolSquareUpdate.add((JobSquareUpdate)regionJob);
                break;
            }
            case ApplyChanges: {
                poolApplyChanges.add((JobApplyChanges)regionJob);
                break;
            }
            case ChunkUpdate: {
                poolChunkUpdate.add((JobChunkUpdate)regionJob);
                break;
            }
            case ServerSendFullData: {
                poolServerSendFullData.add((JobServerSendFullData)regionJob);
                break;
            }
            case DebugResetAllData: {
                poolDebugResetAllData.add((JobDebugResetAllData)regionJob);
                break;
            }
            default: {
                if (!Core.bDebug) break;
                throw new RuntimeException("No pooling for this job type?");
            }
        }
    }
}

