/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import zombie.core.Colors;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataCell;
import zombie.iso.areas.isoregion.data.DataChunk;
import zombie.iso.areas.isoregion.regions.IsoChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoRegionManager;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;

public final class DataRoot {
    private final Map<Integer, DataCell> cellMap = new HashMap<Integer, DataCell>();
    public final SelectInfo select = new SelectInfo(this);
    private final SelectInfo selectInternal = new SelectInfo(this);
    public final IsoRegionManager regionManager;
    private final ArrayList<IsoWorldRegion> dirtyIsoWorldRegions = new ArrayList();
    private final ArrayList<DataChunk> dirtyChunks = new ArrayList();
    protected static int recalcs;
    protected static int floodFills;
    protected static int merges;
    private static final long[] t_start;
    private static final long[] t_end;
    private static final long[] t_time;

    public DataRoot() {
        this.regionManager = new IsoRegionManager(this);
    }

    public void getAllChunks(List<DataChunk> list) {
        for (Map.Entry<Integer, DataCell> entry : this.cellMap.entrySet()) {
            entry.getValue().getAllChunks(list);
        }
    }

    private DataCell getCell(int n) {
        return this.cellMap.get(n);
    }

    private DataCell addCell(int n, int n2, int n3) {
        DataCell dataCell = new DataCell(this, n, n2, n3);
        this.cellMap.put(n3, dataCell);
        return dataCell;
    }

    public DataChunk getDataChunk(int n, int n2) {
        int n3 = IsoRegions.hash(n / 30, n2 / 30);
        DataCell dataCell = this.cellMap.get(n3);
        if (dataCell != null) {
            int n4 = IsoRegions.hash(n, n2);
            return dataCell.getChunk(n4);
        }
        return null;
    }

    private void setDataChunk(DataChunk dataChunk) {
        int n = IsoRegions.hash(dataChunk.getChunkX() / 30, dataChunk.getChunkY() / 30);
        DataCell dataCell = this.cellMap.get(n);
        if (dataCell == null) {
            dataCell = this.addCell(dataChunk.getChunkX() / 30, dataChunk.getChunkY() / 30, n);
        }
        dataCell.setChunk(dataChunk);
    }

    public IsoWorldRegion getIsoWorldRegion(int n, int n2, int n3) {
        IsoChunkRegion isoChunkRegion;
        this.selectInternal.reset(n, n2, n3, false);
        if (this.selectInternal.chunk != null && (isoChunkRegion = this.selectInternal.chunk.getIsoChunkRegion(this.selectInternal.chunkSquareX, this.selectInternal.chunkSquareY, n3)) != null) {
            return isoChunkRegion.getIsoWorldRegion();
        }
        return null;
    }

    public byte getSquareFlags(int n, int n2, int n3) {
        this.selectInternal.reset(n, n2, n3, false);
        return this.selectInternal.square;
    }

    public IsoChunkRegion getIsoChunkRegion(int n, int n2, int n3) {
        this.selectInternal.reset(n, n2, n3, false);
        if (this.selectInternal.chunk != null) {
            return this.selectInternal.chunk.getIsoChunkRegion(this.selectInternal.chunkSquareX, this.selectInternal.chunkSquareY, n3);
        }
        return null;
    }

    public void resetAllData() {
        ArrayList<IsoWorldRegion> arrayList = new ArrayList<IsoWorldRegion>();
        for (Map.Entry<Integer, DataCell> object : this.cellMap.entrySet()) {
            DataCell dataCell = object.getValue();
            for (Map.Entry<Integer, DataChunk> entry : dataCell.dataChunks.entrySet()) {
                DataChunk dataChunk = entry.getValue();
                for (int i = 0; i < 8; ++i) {
                    for (IsoChunkRegion isoChunkRegion : dataChunk.getChunkRegions(i)) {
                        if (isoChunkRegion.getIsoWorldRegion() != null && !arrayList.contains(isoChunkRegion.getIsoWorldRegion())) {
                            arrayList.add(isoChunkRegion.getIsoWorldRegion());
                        }
                        isoChunkRegion.setIsoWorldRegion(null);
                        this.regionManager.releaseIsoChunkRegion(isoChunkRegion);
                    }
                }
            }
            dataCell.dataChunks.clear();
        }
        this.cellMap.clear();
        for (IsoWorldRegion isoWorldRegion : arrayList) {
            this.regionManager.releaseIsoWorldRegion(isoWorldRegion);
        }
    }

    public void EnqueueDirtyDataChunk(DataChunk dataChunk) {
        if (!this.dirtyChunks.contains(dataChunk)) {
            this.dirtyChunks.add(dataChunk);
        }
    }

    public void EnqueueDirtyIsoWorldRegion(IsoWorldRegion isoWorldRegion) {
        if (!this.dirtyIsoWorldRegions.contains(isoWorldRegion)) {
            this.dirtyIsoWorldRegions.add(isoWorldRegion);
        }
    }

    public void DequeueDirtyIsoWorldRegion(IsoWorldRegion isoWorldRegion) {
        this.dirtyIsoWorldRegions.remove(isoWorldRegion);
    }

    public void updateExistingSquare(int n, int n2, int n3, byte by) {
        this.select.reset(n, n2, n3, false);
        if (this.select.chunk != null) {
            byte by2 = -1;
            if (this.select.square != -1) {
                by2 = this.select.square;
            }
            if (by == by2) {
                return;
            }
            this.select.chunk.setOrAddSquare(this.select.chunkSquareX, this.select.chunkSquareY, this.select.z, by, true);
        } else {
            IsoRegions.warn("DataRoot.updateExistingSquare -> trying to change a square on a unknown chunk");
        }
    }

    public void processDirtyChunks() {
        if (this.dirtyChunks.size() > 0) {
            DataChunk dataChunk;
            int n;
            long l = System.nanoTime();
            recalcs = 0;
            floodFills = 0;
            merges = 0;
            DataRoot.t_start[0] = System.nanoTime();
            for (n = 0; n < this.dirtyChunks.size(); ++n) {
                dataChunk = this.dirtyChunks.get(n);
                dataChunk.recalculate();
                ++recalcs;
            }
            DataRoot.t_end[0] = System.nanoTime();
            DataRoot.t_start[1] = System.nanoTime();
            for (n = 0; n < this.dirtyChunks.size(); ++n) {
                dataChunk = this.dirtyChunks.get(n);
                DataChunk dataChunk2 = this.getDataChunk(dataChunk.getChunkX(), dataChunk.getChunkY() - 1);
                DataChunk dataChunk3 = this.getDataChunk(dataChunk.getChunkX() - 1, dataChunk.getChunkY());
                DataChunk dataChunk4 = this.getDataChunk(dataChunk.getChunkX(), dataChunk.getChunkY() + 1);
                DataChunk dataChunk5 = this.getDataChunk(dataChunk.getChunkX() + 1, dataChunk.getChunkY());
                dataChunk.link(dataChunk2, dataChunk3, dataChunk4, dataChunk5);
            }
            DataRoot.t_end[1] = System.nanoTime();
            DataRoot.t_start[2] = System.nanoTime();
            for (n = 0; n < this.dirtyChunks.size(); ++n) {
                dataChunk = this.dirtyChunks.get(n);
                dataChunk.interConnect();
            }
            DataRoot.t_end[2] = System.nanoTime();
            DataRoot.t_start[3] = System.nanoTime();
            for (n = 0; n < this.dirtyChunks.size(); ++n) {
                dataChunk = this.dirtyChunks.get(n);
                dataChunk.recalcRoofs();
                dataChunk.unsetDirtyAll();
            }
            DataRoot.t_end[3] = System.nanoTime();
            DataRoot.t_start[4] = System.nanoTime();
            if (this.dirtyIsoWorldRegions.size() > 0) {
                int n2;
                for (n2 = 0; n2 < this.dirtyIsoWorldRegions.size(); ++n2) {
                    IsoWorldRegion isoWorldRegion = this.dirtyIsoWorldRegions.get(n2);
                    isoWorldRegion.unlinkNeighbors();
                }
                for (n2 = 0; n2 < this.dirtyIsoWorldRegions.size(); ++n2) {
                    IsoWorldRegion isoWorldRegion = this.dirtyIsoWorldRegions.get(n2);
                    isoWorldRegion.linkNeighbors();
                }
                this.dirtyIsoWorldRegions.clear();
            }
            DataRoot.t_end[4] = System.nanoTime();
            this.dirtyChunks.clear();
            long l2 = System.nanoTime();
            long l3 = l2 - l;
            if (IsoRegions.PRINT_D) {
                DataRoot.t_time[0] = t_end[0] - t_start[0];
                DataRoot.t_time[1] = t_end[1] - t_start[1];
                DataRoot.t_time[2] = t_end[2] - t_start[2];
                DataRoot.t_time[3] = t_end[3] - t_start[3];
                DataRoot.t_time[4] = t_end[4] - t_start[4];
                IsoRegions.log("--- IsoRegion update: " + String.format("%.6f", (double)l3 / 1000000.0) + " ms, recalc: " + String.format("%.6f", (double)t_time[0] / 1000000.0) + " ms, link: " + String.format("%.6f", (double)t_time[1] / 1000000.0) + " ms, interconnect: " + String.format("%.6f", (double)t_time[2] / 1000000.0) + " ms, roofs: " + String.format("%.6f", (double)t_time[3] / 1000000.0) + " ms, worldRegion: " + String.format("%.6f", (double)t_time[4] / 1000000.0) + " ms, recalcs = " + recalcs + ", merges = " + merges + ", floodfills = " + floodFills, Colors.CornFlowerBlue);
            }
        }
    }

    static {
        t_start = new long[5];
        t_end = new long[5];
        t_time = new long[5];
    }

    public static final class SelectInfo {
        public int x;
        public int y;
        public int z;
        public int chunkSquareX;
        public int chunkSquareY;
        public int chunkx;
        public int chunky;
        public int cellx;
        public int celly;
        public int chunkID;
        public int cellID;
        public DataCell cell;
        public DataChunk chunk;
        public byte square;
        private final DataRoot root;

        private SelectInfo(DataRoot dataRoot) {
            this.root = dataRoot;
        }

        public void reset(int n, int n2, int n3, boolean bl) {
            this.reset(n, n2, n3, bl, bl);
        }

        public void reset(int n, int n2, int n3, boolean bl, boolean bl2) {
            this.x = n;
            this.y = n2;
            this.z = n3;
            this.chunkSquareX = n % 10;
            this.chunkSquareY = n2 % 10;
            this.chunkx = n / 10;
            this.chunky = n2 / 10;
            this.cellx = n / 300;
            this.celly = n2 / 300;
            this.chunkID = IsoRegions.hash(this.chunkx, this.chunky);
            this.cellID = IsoRegions.hash(this.cellx, this.celly);
            this.cell = null;
            this.chunk = null;
            this.square = (byte)-1;
            this.ensureSquare(bl2);
            if (this.chunk == null && bl) {
                this.ensureChunk(bl);
            }
        }

        private void ensureCell(boolean bl) {
            if (this.cell == null) {
                this.cell = this.root.getCell(this.cellID);
            }
            if (this.cell == null && bl) {
                this.cell = this.root.addCell(this.cellx, this.celly, this.cellID);
            }
        }

        private void ensureChunk(boolean bl) {
            this.ensureCell(bl);
            if (this.cell == null) {
                return;
            }
            if (this.chunk == null) {
                this.chunk = this.cell.getChunk(this.chunkID);
            }
            if (this.chunk == null && bl) {
                this.chunk = this.cell.addChunk(this.chunkx, this.chunky, this.chunkID);
            }
        }

        private void ensureSquare(boolean bl) {
            this.ensureCell(bl);
            if (this.cell == null) {
                return;
            }
            this.ensureChunk(bl);
            if (this.chunk == null) {
                return;
            }
            if (this.square == -1) {
                this.square = this.chunk.getSquare(this.chunkSquareX, this.chunkSquareY, this.z, true);
            }
            if (this.square == -1 && bl) {
                this.square = this.chunk.setOrAddSquare(this.chunkSquareX, this.chunkSquareY, this.z, (byte)0, true);
            }
        }
    }
}

