/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion.data;

import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import zombie.debug.DebugLog;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataCell;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.data.DataSquarePos;
import zombie.iso.areas.isoregion.regions.IsoChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;

public final class DataChunk {
    private final DataCell cell;
    private final int hashId;
    private final int chunkX;
    private final int chunkY;
    protected int highestZ = 0;
    protected long lastUpdateStamp = 0L;
    private final boolean[] activeZLayers = new boolean[8];
    private final boolean[] dirtyZLayers = new boolean[8];
    private byte[] squareFlags;
    private byte[] regionIDs;
    private final ArrayList<ArrayList<IsoChunkRegion>> chunkRegions = new ArrayList(8);
    private static byte selectedFlags;
    private static final ArrayDeque<DataSquarePos> tmpSquares;
    private static final HashSet<Integer> tmpLinkedChunks;
    private static final boolean[] exploredPositions;
    private static IsoChunkRegion lastCurRegion;
    private static IsoChunkRegion lastOtherRegionFullConnect;
    private static ArrayList<IsoChunkRegion> oldList;
    private static final ArrayDeque<IsoChunkRegion> chunkQueue;

    protected DataChunk(int n, int n2, DataCell dataCell, int n3) {
        this.cell = dataCell;
        this.hashId = n3 < 0 ? IsoRegions.hash(n, n2) : n3;
        this.chunkX = n;
        this.chunkY = n2;
        for (int i = 0; i < 8; ++i) {
            this.chunkRegions.add(new ArrayList());
        }
    }

    protected int getHashId() {
        return this.hashId;
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkY() {
        return this.chunkY;
    }

    protected ArrayList<IsoChunkRegion> getChunkRegions(int n) {
        return this.chunkRegions.get(n);
    }

    public long getLastUpdateStamp() {
        return this.lastUpdateStamp;
    }

    public void setLastUpdateStamp(long l) {
        this.lastUpdateStamp = l;
    }

    protected boolean isDirty(int n) {
        if (this.activeZLayers[n]) {
            return this.dirtyZLayers[n];
        }
        return false;
    }

    protected void setDirty(int n) {
        if (this.activeZLayers[n]) {
            this.dirtyZLayers[n] = true;
            this.cell.dataRoot.EnqueueDirtyDataChunk(this);
        }
    }

    public void setDirtyAllActive() {
        boolean bl = false;
        for (int i = 0; i < 8; ++i) {
            if (!this.activeZLayers[i]) continue;
            this.dirtyZLayers[i] = true;
            if (bl) continue;
            this.cell.dataRoot.EnqueueDirtyDataChunk(this);
            bl = true;
        }
    }

    protected void unsetDirtyAll() {
        for (int i = 0; i < 8; ++i) {
            this.dirtyZLayers[i] = false;
        }
    }

    private boolean validCoords(int n, int n2, int n3) {
        return n >= 0 && n < 10 && n2 >= 0 && n2 < 10 && n3 >= 0 && n3 < this.highestZ + 1;
    }

    private int getCoord1D(int n, int n2, int n3) {
        return n3 * 10 * 10 + n2 * 10 + n;
    }

    public byte getSquare(int n, int n2, int n3) {
        return this.getSquare(n, n2, n3, false);
    }

    public byte getSquare(int n, int n2, int n3, boolean bl) {
        if (this.squareFlags != null && (bl || this.validCoords(n, n2, n3))) {
            if (this.activeZLayers[n3]) {
                return this.squareFlags[this.getCoord1D(n, n2, n3)];
            }
            return -1;
        }
        return -1;
    }

    protected byte setOrAddSquare(int n, int n2, int n3, byte by) {
        return this.setOrAddSquare(n, n2, n3, by, false);
    }

    protected byte setOrAddSquare(int n, int n2, int n3, byte by, boolean bl) {
        if (bl || this.validCoords(n, n2, n3)) {
            this.ensureSquares(n3);
            int n4 = this.getCoord1D(n, n2, n3);
            if (this.squareFlags[n4] != by) {
                this.setDirty(n3);
            }
            this.squareFlags[n4] = by;
            return by;
        }
        return -1;
    }

    private void ensureSquares(int n) {
        if (n < 0 || n >= 8) {
            return;
        }
        if (!this.activeZLayers[n]) {
            this.ensureSquareArray(n);
            this.activeZLayers[n] = true;
            if (n > this.highestZ) {
                this.highestZ = n;
            }
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    int n2 = this.getCoord1D(j, i, n);
                    this.squareFlags[n2] = n == 0 ? 16 : 0;
                }
            }
        }
    }

    private void ensureSquareArray(int n) {
        int n2 = (n + 1) * 10 * 10;
        if (this.squareFlags == null || this.squareFlags.length < n2) {
            byte[] byArray = this.squareFlags;
            byte[] byArray2 = this.regionIDs;
            this.squareFlags = new byte[n2];
            this.regionIDs = new byte[n2];
            if (byArray != null) {
                for (int i = 0; i < byArray.length; ++i) {
                    this.squareFlags[i] = byArray[i];
                    this.regionIDs[i] = byArray2[i];
                }
            }
        }
    }

    public void save(ByteBuffer byteBuffer) {
        try {
            int n;
            int n2 = byteBuffer.position();
            byteBuffer.putInt(0);
            byteBuffer.putInt(this.highestZ);
            int n3 = (this.highestZ + 1) * 100;
            byteBuffer.putInt(n3);
            for (n = 0; n < n3; ++n) {
                byteBuffer.put(this.squareFlags[n]);
            }
            n = byteBuffer.position();
            byteBuffer.position(n2);
            byteBuffer.putInt(n - n2);
            byteBuffer.position(n);
        }
        catch (Exception exception) {
            DebugLog.log(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void load(ByteBuffer byteBuffer, int n, boolean bl) {
        try {
            int n2;
            if (bl) {
                byteBuffer.getInt();
            }
            for (n2 = this.highestZ = byteBuffer.getInt(); n2 >= 0; --n2) {
                this.ensureSquares(n2);
            }
            n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                this.squareFlags[i] = byteBuffer.get();
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception.getMessage());
            exception.printStackTrace();
        }
    }

    public void setSelectedFlags(int n, int n2, int n3) {
        selectedFlags = n3 >= 0 && n3 <= this.highestZ ? this.squareFlags[this.getCoord1D(n, n2, n3)] : (byte)-1;
    }

    public boolean selectedHasFlags(byte by) {
        return (selectedFlags & by) == by;
    }

    protected boolean squareHasFlags(int n, int n2, int n3, byte by) {
        return this.squareHasFlags(this.getCoord1D(n, n2, n3), by);
    }

    private boolean squareHasFlags(int n, byte by) {
        byte by2 = this.squareFlags[n];
        return (by2 & by) == by;
    }

    public byte squareGetFlags(int n, int n2, int n3) {
        return this.squareGetFlags(this.getCoord1D(n, n2, n3));
    }

    private byte squareGetFlags(int n) {
        return this.squareFlags[n];
    }

    protected void squareAddFlags(int n, int n2, int n3, byte by) {
        this.squareAddFlags(this.getCoord1D(n, n2, n3), by);
    }

    private void squareAddFlags(int n, byte by) {
        int n2 = n;
        this.squareFlags[n2] = (byte)(this.squareFlags[n2] | by);
    }

    protected void squareRemoveFlags(int n, int n2, int n3, byte by) {
        this.squareRemoveFlags(this.getCoord1D(n, n2, n3), by);
    }

    private void squareRemoveFlags(int n, byte by) {
        int n2 = n;
        this.squareFlags[n2] = (byte)(this.squareFlags[n2] ^ by);
    }

    protected boolean squareCanConnect(int n, int n2, int n3, byte by) {
        return this.squareCanConnect(this.getCoord1D(n, n2, n3), n3, by);
    }

    private boolean squareCanConnect(int n, int n2, byte by) {
        if (n2 >= 0 && n2 < this.highestZ + 1) {
            if (by == 0) {
                return !this.squareHasFlags(n, (byte)1);
            }
            if (by == 1) {
                return !this.squareHasFlags(n, (byte)2);
            }
            if (by == 2) {
                return true;
            }
            if (by == 3) {
                return true;
            }
            if (by == 4) {
                return !this.squareHasFlags(n, (byte)64);
            }
            if (by == 5) {
                return !this.squareHasFlags(n, (byte)16);
            }
        }
        return false;
    }

    public IsoChunkRegion getIsoChunkRegion(int n, int n2, int n3) {
        return this.getIsoChunkRegion(this.getCoord1D(n, n2, n3), n3);
    }

    private IsoChunkRegion getIsoChunkRegion(int n, int n2) {
        byte by;
        if (n2 >= 0 && n2 < this.highestZ + 1 && (by = this.regionIDs[n]) >= 0 && by < this.chunkRegions.get(n2).size()) {
            return this.chunkRegions.get(n2).get(by);
        }
        return null;
    }

    public void setRegion(int n, int n2, int n3, byte by) {
        this.regionIDs[this.getCoord1D((int)n, (int)n2, (int)n3)] = by;
    }

    protected void recalculate() {
        for (int i = 0; i <= this.highestZ; ++i) {
            if (!this.dirtyZLayers[i] || !this.activeZLayers[i]) continue;
            this.recalculate(i);
        }
    }

    private void recalculate(int n) {
        int n2;
        ArrayList<IsoChunkRegion> arrayList = this.chunkRegions.get(n);
        for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
            IsoChunkRegion isoChunkRegion = arrayList.get(n2);
            IsoWorldRegion isoWorldRegion = isoChunkRegion.unlinkFromIsoWorldRegion();
            if (isoWorldRegion != null && isoWorldRegion.size() <= 0) {
                this.cell.dataRoot.regionManager.releaseIsoWorldRegion(isoWorldRegion);
            }
            this.cell.dataRoot.regionManager.releaseIsoChunkRegion(isoChunkRegion);
            arrayList.remove(n2);
        }
        arrayList.clear();
        n2 = 100;
        Arrays.fill(this.regionIDs, n * n2, n * n2 + n2, (byte)-1);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (this.regionIDs[this.getCoord1D(j, i, n)] != -1) continue;
                IsoChunkRegion isoChunkRegion = this.floodFill(j, i, n);
            }
        }
    }

    private IsoChunkRegion floodFill(int n, int n2, int n3) {
        DataSquarePos dataSquarePos;
        IsoChunkRegion isoChunkRegion = this.cell.dataRoot.regionManager.allocIsoChunkRegion(n3);
        byte by = (byte)this.chunkRegions.get(n3).size();
        this.chunkRegions.get(n3).add(isoChunkRegion);
        this.clearExploredPositions();
        tmpSquares.clear();
        tmpLinkedChunks.clear();
        tmpSquares.add(DataSquarePos.alloc(n, n2, n3));
        while ((dataSquarePos = tmpSquares.poll()) != null) {
            int n4 = this.getCoord1D(dataSquarePos.x, dataSquarePos.y, dataSquarePos.z);
            this.setExploredPosition(n4, dataSquarePos.z);
            if (this.regionIDs[n4] != -1) continue;
            this.regionIDs[n4] = by;
            isoChunkRegion.addSquareCount();
            for (byte by2 = 0; by2 < 4; by2 = (byte)(by2 + 1)) {
                DataSquarePos dataSquarePos2 = this.getNeighbor(dataSquarePos, by2);
                if (dataSquarePos2 != null) {
                    int n5 = this.getCoord1D(dataSquarePos2.x, dataSquarePos2.y, dataSquarePos2.z);
                    if (this.isExploredPosition(n5, dataSquarePos2.z)) {
                        DataSquarePos.release(dataSquarePos2);
                        continue;
                    }
                    if (this.squareCanConnect(n4, dataSquarePos.z, by2) && this.squareCanConnect(n5, dataSquarePos2.z, IsoRegions.GetOppositeDir(by2))) {
                        if (this.regionIDs[n5] == -1) {
                            tmpSquares.add(dataSquarePos2);
                            this.setExploredPosition(n5, dataSquarePos2.z);
                            continue;
                        }
                    } else {
                        IsoChunkRegion isoChunkRegion2 = this.getIsoChunkRegion(n5, dataSquarePos2.z);
                        if (isoChunkRegion2 != null && isoChunkRegion2 != isoChunkRegion) {
                            if (!tmpLinkedChunks.contains(isoChunkRegion2.getID())) {
                                isoChunkRegion.addNeighbor(isoChunkRegion2);
                                isoChunkRegion2.addNeighbor(isoChunkRegion);
                                tmpLinkedChunks.add(isoChunkRegion2.getID());
                            }
                            this.setExploredPosition(n5, dataSquarePos2.z);
                            DataSquarePos.release(dataSquarePos2);
                            continue;
                        }
                    }
                    DataSquarePos.release(dataSquarePos2);
                    continue;
                }
                if (!this.squareCanConnect(n4, dataSquarePos.z, by2)) continue;
                isoChunkRegion.addChunkBorderSquaresCnt();
            }
        }
        return isoChunkRegion;
    }

    private boolean isExploredPosition(int n, int n2) {
        int n3 = n - n2 * 10 * 10;
        return exploredPositions[n3];
    }

    private void setExploredPosition(int n, int n2) {
        int n3 = n - n2 * 10 * 10;
        DataChunk.exploredPositions[n3] = true;
    }

    private void clearExploredPositions() {
        Arrays.fill(exploredPositions, false);
    }

    private DataSquarePos getNeighbor(DataSquarePos dataSquarePos, byte by) {
        int n = dataSquarePos.x;
        int n2 = dataSquarePos.y;
        if (by == 1) {
            n = dataSquarePos.x - 1;
        } else if (by == 3) {
            n = dataSquarePos.x + 1;
        }
        if (by == 0) {
            n2 = dataSquarePos.y - 1;
        } else if (by == 2) {
            n2 = dataSquarePos.y + 1;
        }
        if (n < 0 || n >= 10 || n2 < 0 || n2 >= 10) {
            return null;
        }
        return DataSquarePos.alloc(n, n2, dataSquarePos.z);
    }

    protected void link(DataChunk dataChunk, DataChunk dataChunk2, DataChunk dataChunk3, DataChunk dataChunk4) {
        for (int i = 0; i <= this.highestZ; ++i) {
            if (!this.dirtyZLayers[i] || !this.activeZLayers[i]) continue;
            this.linkRegionsOnSide(i, dataChunk, (byte)0);
            this.linkRegionsOnSide(i, dataChunk2, (byte)1);
            this.linkRegionsOnSide(i, dataChunk3, (byte)2);
            this.linkRegionsOnSide(i, dataChunk4, (byte)3);
        }
    }

    private void linkRegionsOnSide(int n, DataChunk dataChunk, byte by) {
        int n2;
        int n3;
        if (by == 0 || by == 2) {
            var4_4 = 0;
            n3 = 10;
            var6_6 = by == 0 ? 0 : 9;
            n2 = var6_6 + 1;
        } else {
            var4_4 = by == 1 ? 0 : 9;
            n3 = var4_4 + 1;
            var6_6 = 0;
            n2 = 10;
        }
        if (dataChunk != null && dataChunk.isDirty(n)) {
            dataChunk.resetEnclosedSide(n, IsoRegions.GetOppositeDir(by));
        }
        lastCurRegion = null;
        lastOtherRegionFullConnect = null;
        for (int i = var6_6; i < n2; ++i) {
            for (int j = var4_4; j < n3; ++j) {
                IsoChunkRegion isoChunkRegion;
                int n4;
                int n5;
                if (by == 0 || by == 2) {
                    n5 = j;
                    n4 = by == 0 ? 9 : 0;
                } else {
                    n5 = by == 1 ? 9 : 0;
                    n4 = i;
                }
                int n6 = this.getCoord1D(j, i, n);
                int n7 = this.getCoord1D(n5, n4, n);
                IsoChunkRegion isoChunkRegion2 = this.getIsoChunkRegion(n6, n);
                IsoChunkRegion isoChunkRegion3 = isoChunkRegion = dataChunk != null ? dataChunk.getIsoChunkRegion(n7, n) : null;
                if (isoChunkRegion2 == null) {
                    IsoRegions.warn("ds.getRegion()==null, shouldnt happen at this point.");
                    continue;
                }
                if (lastCurRegion != null && lastCurRegion != isoChunkRegion2) {
                    lastOtherRegionFullConnect = null;
                }
                if (lastCurRegion != null && lastCurRegion == isoChunkRegion2 && isoChunkRegion != null && lastOtherRegionFullConnect == isoChunkRegion) continue;
                if (dataChunk == null || isoChunkRegion == null) {
                    if (this.squareCanConnect(n6, n, by)) {
                        isoChunkRegion2.setEnclosed(by, false);
                    }
                } else if (this.squareCanConnect(n6, n, by) && dataChunk.squareCanConnect(n7, n, IsoRegions.GetOppositeDir(by))) {
                    isoChunkRegion2.addConnectedNeighbor(isoChunkRegion);
                    isoChunkRegion.addConnectedNeighbor(isoChunkRegion2);
                    isoChunkRegion2.addNeighbor(isoChunkRegion);
                    isoChunkRegion.addNeighbor(isoChunkRegion2);
                    if (!isoChunkRegion.getIsEnclosed()) {
                        isoChunkRegion.setEnclosed(IsoRegions.GetOppositeDir(by), true);
                    }
                    lastOtherRegionFullConnect = isoChunkRegion;
                } else {
                    isoChunkRegion2.addNeighbor(isoChunkRegion);
                    isoChunkRegion.addNeighbor(isoChunkRegion2);
                    if (!isoChunkRegion.getIsEnclosed()) {
                        isoChunkRegion.setEnclosed(IsoRegions.GetOppositeDir(by), true);
                    }
                    lastOtherRegionFullConnect = null;
                }
                lastCurRegion = isoChunkRegion2;
            }
        }
    }

    private void resetEnclosedSide(int n, byte by) {
        ArrayList<IsoChunkRegion> arrayList = this.chunkRegions.get(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoChunkRegion isoChunkRegion = arrayList.get(i);
            if (isoChunkRegion.getzLayer() != n) continue;
            isoChunkRegion.setEnclosed(by, true);
        }
    }

    protected void interConnect() {
        for (int i = 0; i <= this.highestZ; ++i) {
            if (!this.dirtyZLayers[i] || !this.activeZLayers[i]) continue;
            ArrayList<IsoChunkRegion> arrayList = this.chunkRegions.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                IsoWorldRegion isoWorldRegion;
                Object object;
                IsoChunkRegion isoChunkRegion = arrayList.get(j);
                if (isoChunkRegion.getzLayer() != i || isoChunkRegion.getIsoWorldRegion() != null) continue;
                if (isoChunkRegion.getConnectedNeighbors().size() == 0) {
                    object = this.cell.dataRoot.regionManager.allocIsoWorldRegion();
                    this.cell.dataRoot.EnqueueDirtyIsoWorldRegion((IsoWorldRegion)object);
                    ((IsoWorldRegion)object).addIsoChunkRegion(isoChunkRegion);
                    continue;
                }
                object = isoChunkRegion.getConnectedNeighborWithLargestIsoWorldRegion();
                if (object != null) {
                    IsoChunkRegion isoChunkRegion2;
                    isoWorldRegion = ((IsoChunkRegion)object).getIsoWorldRegion();
                    oldList.clear();
                    oldList = isoWorldRegion.swapIsoChunkRegions(oldList);
                    for (int k = 0; k < oldList.size(); ++k) {
                        isoChunkRegion2 = oldList.get(k);
                        isoChunkRegion2.setIsoWorldRegion(null);
                    }
                    this.cell.dataRoot.regionManager.releaseIsoWorldRegion(isoWorldRegion);
                    IsoWorldRegion isoWorldRegion2 = this.cell.dataRoot.regionManager.allocIsoWorldRegion();
                    this.cell.dataRoot.EnqueueDirtyIsoWorldRegion(isoWorldRegion2);
                    this.floodFillExpandWorldRegion(isoChunkRegion, isoWorldRegion2);
                    for (int k = 0; k < oldList.size(); ++k) {
                        isoChunkRegion2 = oldList.get(k);
                        if (isoChunkRegion2.getIsoWorldRegion() != null) continue;
                        IsoWorldRegion isoWorldRegion3 = this.cell.dataRoot.regionManager.allocIsoWorldRegion();
                        this.cell.dataRoot.EnqueueDirtyIsoWorldRegion(isoWorldRegion3);
                        this.floodFillExpandWorldRegion(isoChunkRegion2, isoWorldRegion3);
                    }
                    ++DataRoot.floodFills;
                    continue;
                }
                isoWorldRegion = this.cell.dataRoot.regionManager.allocIsoWorldRegion();
                this.cell.dataRoot.EnqueueDirtyIsoWorldRegion(isoWorldRegion);
                this.floodFillExpandWorldRegion(isoChunkRegion, isoWorldRegion);
                ++DataRoot.floodFills;
            }
        }
    }

    private void floodFillExpandWorldRegion(IsoChunkRegion isoChunkRegion, IsoWorldRegion isoWorldRegion) {
        IsoChunkRegion isoChunkRegion2;
        chunkQueue.add(isoChunkRegion);
        while ((isoChunkRegion2 = chunkQueue.poll()) != null) {
            isoWorldRegion.addIsoChunkRegion(isoChunkRegion2);
            if (isoChunkRegion2.getConnectedNeighbors().size() == 0) continue;
            for (int i = 0; i < isoChunkRegion2.getConnectedNeighbors().size(); ++i) {
                IsoChunkRegion isoChunkRegion3 = isoChunkRegion2.getConnectedNeighbors().get(i);
                if (chunkQueue.contains(isoChunkRegion3)) continue;
                if (isoChunkRegion3.getIsoWorldRegion() == null) {
                    chunkQueue.add(isoChunkRegion3);
                    continue;
                }
                if (isoChunkRegion3.getIsoWorldRegion() == isoWorldRegion) continue;
                isoWorldRegion.merge(isoChunkRegion3.getIsoWorldRegion());
            }
        }
    }

    protected void recalcRoofs() {
        int n;
        int n2;
        if (this.highestZ < 1) {
            return;
        }
        for (n2 = 0; n2 < this.chunkRegions.size(); ++n2) {
            for (n = 0; n < this.chunkRegions.get(n2).size(); ++n) {
                IsoChunkRegion isoChunkRegion = this.chunkRegions.get(n2).get(n);
                isoChunkRegion.resetRoofCnt();
            }
        }
        n2 = this.highestZ;
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                n = this.getSquare(j, i, n2);
                boolean bl = false;
                if (n > 0) {
                    bl = this.squareHasFlags(j, i, n2, (byte)16);
                }
                if (n2 < 1) continue;
                for (int k = n2 - 1; k >= 0; --k) {
                    n = this.getSquare(j, i, k);
                    if (n > 0) {
                        boolean bl2 = bl = bl || this.squareHasFlags(j, i, k, (byte)32);
                        if (bl) {
                            IsoChunkRegion isoChunkRegion = this.getIsoChunkRegion(j, i, k);
                            if (isoChunkRegion != null) {
                                isoChunkRegion.addRoof();
                                if (isoChunkRegion.getIsoWorldRegion() != null && !isoChunkRegion.getIsoWorldRegion().isEnclosed()) {
                                    bl = false;
                                }
                            } else {
                                bl = false;
                            }
                        }
                        if (bl) continue;
                        bl = this.squareHasFlags(j, i, k, (byte)16);
                        continue;
                    }
                    bl = false;
                }
            }
        }
    }

    static {
        tmpSquares = new ArrayDeque();
        tmpLinkedChunks = new HashSet();
        exploredPositions = new boolean[100];
        oldList = new ArrayList();
        chunkQueue = new ArrayDeque();
    }
}

