/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import zombie.MapCollisionData;
import zombie.ZomboidFileSystem;
import zombie.characters.IsoPlayer;
import zombie.config.BooleanConfigOption;
import zombie.config.ConfigFile;
import zombie.config.ConfigOption;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.SpriteRenderer;
import zombie.core.math.PZMath;
import zombie.core.utils.Bits;
import zombie.iso.BuildingDef;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.LotHeader;
import zombie.iso.RoomDef;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataChunk;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.regions.IsoChunkRegion;
import zombie.iso.areas.isoregion.regions.IsoWorldRegion;
import zombie.iso.objects.IsoThumpable;
import zombie.ui.TextManager;
import zombie.ui.UIElement;
import zombie.ui.UIFont;

public class IsoRegionsRenderer {
    private final List<DataChunk> tempChunkList = new ArrayList<DataChunk>();
    private final List<String> debugLines = new ArrayList<String>();
    private float xPos;
    private float yPos;
    private float offx;
    private float offy;
    private float zoom;
    private float draww;
    private float drawh;
    private boolean hasSelected = false;
    private boolean validSelection = false;
    private int selectedX;
    private int selectedY;
    private int selectedZ;
    private final HashSet<Integer> drawnCells = new HashSet();
    private boolean editSquareInRange = false;
    private int editSquareX;
    private int editSquareY;
    private final ArrayList<ConfigOption> editOptions = new ArrayList();
    private boolean EditingEnabled = false;
    private final BooleanDebugOption EditWallN = new BooleanDebugOption(this.editOptions, "Edit.WallN", false);
    private final BooleanDebugOption EditWallW = new BooleanDebugOption(this.editOptions, "Edit.WallW", false);
    private final BooleanDebugOption EditDoorN = new BooleanDebugOption(this.editOptions, "Edit.DoorN", false);
    private final BooleanDebugOption EditDoorW = new BooleanDebugOption(this.editOptions, "Edit.DoorW", false);
    private final BooleanDebugOption EditFloor = new BooleanDebugOption(this.editOptions, "Edit.Floor", false);
    private final ArrayList<ConfigOption> zLevelOptions = new ArrayList();
    private final BooleanDebugOption zLevelPlayer = new BooleanDebugOption(this.zLevelOptions, "zLevel.Player", true);
    private final BooleanDebugOption zLevel0 = new BooleanDebugOption(this.zLevelOptions, "zLevel.0", false, 0);
    private final BooleanDebugOption zLevel1 = new BooleanDebugOption(this.zLevelOptions, "zLevel.1", false, 1);
    private final BooleanDebugOption zLevel2 = new BooleanDebugOption(this.zLevelOptions, "zLevel.2", false, 2);
    private final BooleanDebugOption zLevel3 = new BooleanDebugOption(this.zLevelOptions, "zLevel.3", false, 3);
    private final BooleanDebugOption zLevel4 = new BooleanDebugOption(this.zLevelOptions, "zLevel.4", false, 4);
    private final BooleanDebugOption zLevel5 = new BooleanDebugOption(this.zLevelOptions, "zLevel.5", false, 5);
    private final BooleanDebugOption zLevel6 = new BooleanDebugOption(this.zLevelOptions, "zLevel.6", false, 6);
    private final BooleanDebugOption zLevel7 = new BooleanDebugOption(this.zLevelOptions, "zLevel.7", false, 7);
    private static final int VERSION = 1;
    private final ArrayList<ConfigOption> options = new ArrayList();
    private final BooleanDebugOption CellGrid = new BooleanDebugOption(this.options, "CellGrid", true);
    private final BooleanDebugOption MetaGridBuildings = new BooleanDebugOption(this.options, "MetaGrid.Buildings", true);
    private final BooleanDebugOption IsoRegionRender = new BooleanDebugOption(this.options, "IsoRegion.Render", true);
    private final BooleanDebugOption IsoRegionRenderChunks = new BooleanDebugOption(this.options, "IsoRegion.RenderChunks", false);
    private final BooleanDebugOption IsoRegionRenderChunksPlus = new BooleanDebugOption(this.options, "IsoRegion.RenderChunksPlus", false);

    public float worldToScreenX(float f) {
        f -= this.xPos;
        f *= this.zoom;
        f += this.offx;
        return f += this.draww / 2.0f;
    }

    public float worldToScreenY(float f) {
        f -= this.yPos;
        f *= this.zoom;
        f += this.offy;
        return f += this.drawh / 2.0f;
    }

    public float uiToWorldX(float f) {
        f -= this.draww / 2.0f;
        f /= this.zoom;
        return f += this.xPos;
    }

    public float uiToWorldY(float f) {
        f -= this.drawh / 2.0f;
        f /= this.zoom;
        return f += this.yPos;
    }

    public void renderStringUI(float f, float f2, String string, Color color) {
        this.renderStringUI(f, f2, string, color.r, color.g, color.b, color.a);
    }

    public void renderStringUI(float f, float f2, String string, double d, double d2, double d3, double d4) {
        float f3 = this.offx + f;
        float f4 = this.offy + f2;
        SpriteRenderer.instance.render(null, f3 - 2.0f, f4 - 2.0f, TextManager.instance.MeasureStringX(UIFont.Small, string) + 4, TextManager.instance.font.getLineHeight() + 4, 0.0f, 0.0f, 0.0f, 0.75f, null);
        TextManager.instance.DrawString(f3, f4, string, d, d2, d3, d4);
    }

    public void renderString(float f, float f2, String string, double d, double d2, double d3, double d4) {
        float f3 = this.worldToScreenX(f);
        float f4 = this.worldToScreenY(f2);
        SpriteRenderer.instance.render(null, f3 - 2.0f, f4 - 2.0f, TextManager.instance.MeasureStringX(UIFont.Small, string) + 4, TextManager.instance.font.getLineHeight() + 4, 0.0f, 0.0f, 0.0f, 0.75f, null);
        TextManager.instance.DrawString(f3, f4, string, d, d2, d3, d4);
    }

    public void renderRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.worldToScreenX(f);
        float f10 = this.worldToScreenY(f2);
        float f11 = this.worldToScreenX(f + f3);
        float f12 = this.worldToScreenY(f2 + f4);
        f3 = f11 - f9;
        f4 = f12 - f10;
        if (f9 >= this.offx + this.draww || f11 < this.offx || f10 >= this.offy + this.drawh || f12 < this.offy) {
            return;
        }
        SpriteRenderer.instance.render(null, f9, f10, f3, f4, f5, f6, f7, f8, null);
    }

    public void renderLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        float f9 = this.worldToScreenX(f);
        float f10 = this.worldToScreenY(f2);
        float f11 = this.worldToScreenX(f3);
        float f12 = this.worldToScreenY(f4);
        if (f9 >= (float)Core.getInstance().getScreenWidth() && f11 >= (float)Core.getInstance().getScreenWidth() || f10 >= (float)Core.getInstance().getScreenHeight() && f12 >= (float)Core.getInstance().getScreenHeight() || f9 < 0.0f && f11 < 0.0f || f10 < 0.0f && f12 < 0.0f) {
            return;
        }
        SpriteRenderer.instance.renderline(null, (int)f9, (int)f10, (int)f11, (int)f12, f5, f6, f7, f8);
    }

    public void outlineRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.renderLine(f, f2, f + f3, f2, f5, f6, f7, f8);
        this.renderLine(f + f3, f2, f + f3, f2 + f4, f5, f6, f7, f8);
        this.renderLine(f, f2 + f4, f + f3, f2 + f4, f5, f6, f7, f8);
        this.renderLine(f, f2, f, f2 + f4, f5, f6, f7, f8);
    }

    public void renderCellInfo(int n, int n2, int n3, int n4, float f) {
        float f2 = this.worldToScreenX(n * 300) + 4.0f;
        float f3 = this.worldToScreenY(n2 * 300) + 4.0f;
        String string = n3 + " / " + n4;
        if (f > 0.0f) {
            string = string + String.format(" %.2f", Float.valueOf(f));
        }
        SpriteRenderer.instance.render(null, f2 - 2.0f, f3 - 2.0f, TextManager.instance.MeasureStringX(UIFont.Small, string) + 4, TextManager.instance.font.getLineHeight() + 4, 0.0f, 0.0f, 0.0f, 0.75f, null);
        TextManager.instance.DrawString(f2, f3, string, 1.0, 1.0, 1.0, 1.0);
    }

    public void renderZombie(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f / this.zoom + 0.5f;
        this.renderRect(f - f6 / 2.0f, f2 - f6 / 2.0f, f6, f6, f3, f4, f5, 1.0f);
    }

    public void renderSquare(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = 1.0f;
        this.renderRect(f, f2, f7, f7, f3, f4, f5, f6);
    }

    public void renderEntity(float f, float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = f / this.zoom + 0.5f;
        this.renderRect(f2 - f8 / 2.0f, f3 - f8 / 2.0f, f8, f8, f4, f5, f6, f7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(UIElement uIElement, float f, float f2, float f3) {
        Object object = MapCollisionData.instance.renderLock;
        synchronized (object) {
            this._render(uIElement, f, f2, f3);
        }
    }

    private void debugLine(String string) {
        this.debugLines.add(string);
    }

    public void recalcSurroundings() {
        IsoRegions.forceRecalcSurroundingChunks();
    }

    public boolean hasChunkRegion(int n, int n2) {
        int n3 = this.getZLevel();
        DataRoot dataRoot = IsoRegions.getDataRoot();
        return dataRoot.getIsoChunkRegion(n, n2, n3) != null;
    }

    public IsoChunkRegion getChunkRegion(int n, int n2) {
        int n3 = this.getZLevel();
        DataRoot dataRoot = IsoRegions.getDataRoot();
        return dataRoot.getIsoChunkRegion(n, n2, n3);
    }

    public void setSelected(int n, int n2) {
        this.setSelectedWorld((int)this.uiToWorldX(n), (int)this.uiToWorldY(n2));
    }

    public void setSelectedWorld(int n, int n2) {
        this.selectedZ = this.getZLevel();
        this.hasSelected = true;
        this.selectedX = n;
        this.selectedY = n2;
    }

    public void unsetSelected() {
        this.hasSelected = false;
    }

    public boolean isHasSelected() {
        return this.hasSelected;
    }

    private void _render(UIElement uIElement, float f, float f2, float f3) {
        float f4;
        int n;
        int n2;
        DataRoot dataRoot;
        this.debugLines.clear();
        this.drawnCells.clear();
        this.draww = uIElement.getWidth().intValue();
        this.drawh = uIElement.getHeight().intValue();
        this.xPos = f2;
        this.yPos = f3;
        this.offx = uIElement.getAbsoluteX().intValue();
        this.offy = uIElement.getAbsoluteY().intValue();
        this.zoom = f;
        this.debugLine("Zoom: " + f);
        this.debugLine("zLevel: " + this.getZLevel());
        IsoMetaGrid isoMetaGrid = IsoWorld.instance.MetaGrid;
        IsoMetaCell[][] isoMetaCellArray = isoMetaGrid.Grid;
        int n3 = (int)(this.uiToWorldX(0.0f) / 300.0f) - isoMetaGrid.minX;
        int n4 = (int)(this.uiToWorldY(0.0f) / 300.0f) - isoMetaGrid.minY;
        int n5 = (int)(this.uiToWorldX(this.draww) / 300.0f) + 1 - isoMetaGrid.minX;
        int n6 = (int)(this.uiToWorldY(this.drawh) / 300.0f) + 1 - isoMetaGrid.minY;
        n3 = PZMath.clamp(n3, 0, isoMetaGrid.getWidth() - 1);
        n4 = PZMath.clamp(n4, 0, isoMetaGrid.getHeight() - 1);
        n5 = PZMath.clamp(n5, 0, isoMetaGrid.getWidth() - 1);
        n6 = PZMath.clamp(n6, 0, isoMetaGrid.getHeight() - 1);
        float f5 = Math.max(1.0f - f / 2.0f, 0.1f);
        IsoChunkRegion isoChunkRegion = null;
        IsoWorldRegion isoWorldRegion = null;
        this.validSelection = false;
        if (this.IsoRegionRender.getValue()) {
            IsoPlayer isoPlayer = IsoPlayer.getInstance();
            dataRoot = IsoRegions.getDataRoot();
            this.tempChunkList.clear();
            dataRoot.getAllChunks(this.tempChunkList);
            this.debugLine("DataChunks: " + this.tempChunkList.size());
            this.debugLine("IsoChunkRegions: " + dataRoot.regionManager.getChunkRegionCount());
            this.debugLine("IsoWorldRegions: " + dataRoot.regionManager.getWorldRegionCount());
            if (this.hasSelected) {
                isoChunkRegion = dataRoot.getIsoChunkRegion(this.selectedX, this.selectedY, this.selectedZ);
                isoWorldRegion = dataRoot.getIsoWorldRegion(this.selectedX, this.selectedY, this.selectedZ);
                if (!(isoWorldRegion == null || isoWorldRegion.isEnclosed() || this.IsoRegionRenderChunks.getValue() && this.IsoRegionRenderChunksPlus.getValue())) {
                    isoWorldRegion = null;
                    isoChunkRegion = null;
                }
                if (isoChunkRegion != null) {
                    this.validSelection = true;
                }
            }
            for (int i = 0; i < this.tempChunkList.size(); ++i) {
                DataChunk dataChunk = this.tempChunkList.get(i);
                n2 = dataChunk.getChunkX() * 10;
                n = dataChunk.getChunkY() * 10;
                if (!(f > 0.1f)) continue;
                float f6 = this.worldToScreenX(n2);
                float f7 = this.worldToScreenY(n);
                float f8 = this.worldToScreenX(n2 + 10);
                f4 = this.worldToScreenY(n + 10);
                if (f6 >= this.offx + this.draww || f8 < this.offx || f7 >= this.offy + this.drawh || f4 < this.offy) continue;
                this.renderRect(n2, n, 10.0f, 10.0f, 0.0f, f5, 0.0f, 1.0f);
            }
        }
        if (this.MetaGridBuildings.getValue()) {
            float f9 = PZMath.clamp(0.3f * (f / 5.0f), 0.15f, 0.3f);
            for (int i = n3; i < n5; ++i) {
                for (int j = n4; j < n6; ++j) {
                    LotHeader lotHeader = isoMetaCellArray[i][j].info;
                    if (lotHeader == null) continue;
                    for (n = 0; n < lotHeader.Buildings.size(); ++n) {
                        BuildingDef buildingDef = lotHeader.Buildings.get(n);
                        for (int k = 0; k < buildingDef.rooms.size(); ++k) {
                            if (buildingDef.rooms.get((int)k).level > 0) continue;
                            ArrayList<RoomDef.RoomRect> arrayList = buildingDef.rooms.get(k).getRects();
                            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                                RoomDef.RoomRect roomRect = arrayList.get(i2);
                                if (buildingDef.bAlarmed) {
                                    this.renderRect(roomRect.getX(), roomRect.getY(), roomRect.getW(), roomRect.getH(), 0.8f * f9, 0.8f * f9, 0.5f * f9, 1.0f);
                                    continue;
                                }
                                this.renderRect(roomRect.getX(), roomRect.getY(), roomRect.getW(), roomRect.getH(), 0.5f * f9, 0.5f * f9, 0.8f * f9, 1.0f);
                            }
                        }
                    }
                }
            }
        }
        if (this.IsoRegionRender.getValue()) {
            int n7 = this.getZLevel();
            dataRoot = IsoRegions.getDataRoot();
            this.tempChunkList.clear();
            dataRoot.getAllChunks(this.tempChunkList);
            float f10 = 1.0f;
            for (int i = 0; i < this.tempChunkList.size(); ++i) {
                int n8;
                int n9;
                int n10;
                DataChunk dataChunk = this.tempChunkList.get(i);
                n2 = dataChunk.getChunkX() * 10;
                n = dataChunk.getChunkY() * 10;
                if (f <= 0.1f) {
                    n10 = n2 / 300;
                    n9 = n / 300;
                    n8 = IsoRegions.hash(n10, n9);
                    if (this.drawnCells.contains(n8)) continue;
                    this.drawnCells.add(n8);
                    this.renderRect(n10 * 300, n9 * 300, 300.0f, 300.0f, 0.0f, f5, 0.0f, 1.0f);
                    continue;
                }
                if (f < 1.0f) continue;
                f4 = this.worldToScreenX(n2);
                float f11 = this.worldToScreenY(n);
                float f12 = this.worldToScreenX(n2 + 10);
                float f13 = this.worldToScreenY(n + 10);
                if (f4 >= this.offx + this.draww || f12 < this.offx || f11 >= this.offy + this.drawh || f13 < this.offy) continue;
                for (n10 = 0; n10 < 10; ++n10) {
                    for (n9 = 0; n9 < 10; ++n9) {
                        for (int j = n8 = n7 > 0 ? n7 - 1 : n7; j <= n7; ++j) {
                            IsoWorldRegion isoWorldRegion2;
                            float f14 = j < n7 ? 0.25f : 1.0f;
                            byte by = dataChunk.getSquare(n10, n9, j);
                            if (by < 0) continue;
                            IsoChunkRegion isoChunkRegion2 = dataChunk.getIsoChunkRegion(n10, n9, j);
                            if (isoChunkRegion2 != null) {
                                if (f > 6.0f && this.IsoRegionRenderChunks.getValue() && this.IsoRegionRenderChunksPlus.getValue()) {
                                    var21_46 = isoChunkRegion2.getColor();
                                    f10 = 1.0f;
                                    if (isoChunkRegion != null && isoChunkRegion2 != isoChunkRegion) {
                                        f10 = 0.25f;
                                    }
                                    this.renderSquare(n2 + n10, n + n9, var21_46.r, var21_46.g, var21_46.b, f10 * f14);
                                } else {
                                    isoWorldRegion2 = isoChunkRegion2.getIsoWorldRegion();
                                    if (isoWorldRegion2 != null && isoWorldRegion2.isEnclosed()) {
                                        f10 = 1.0f;
                                        if (this.IsoRegionRenderChunks.getValue()) {
                                            var21_46 = isoChunkRegion2.getColor();
                                            if (isoChunkRegion != null && isoChunkRegion2 != isoChunkRegion) {
                                                f10 = 0.25f;
                                            }
                                        } else {
                                            var21_46 = isoWorldRegion2.getColor();
                                            if (isoWorldRegion != null && isoWorldRegion2 != isoWorldRegion) {
                                                f10 = 0.25f;
                                            }
                                        }
                                        this.renderSquare(n2 + n10, n + n9, var21_46.r, var21_46.g, var21_46.b, f10 * f14);
                                    }
                                }
                            }
                            if (j > 0 && j == n7) {
                                boolean bl;
                                isoChunkRegion2 = dataChunk.getIsoChunkRegion(n10, n9, j);
                                isoWorldRegion2 = isoChunkRegion2 != null ? isoChunkRegion2.getIsoWorldRegion() : null;
                                boolean bl2 = bl = isoChunkRegion2 == null || isoWorldRegion2 == null || !isoWorldRegion2.isEnclosed();
                                if (bl && Bits.hasFlags(by, 16)) {
                                    this.renderSquare(n2 + n10, n + n9, 0.5f, 0.5f, 0.5f, 1.0f);
                                }
                            }
                            if (Bits.hasFlags(by, 1) || Bits.hasFlags(by, 4)) {
                                this.renderRect(n2 + n10, n + n9, 1.0f, 0.1f, 1.0f, 1.0f, 1.0f, 1.0f * f14);
                            }
                            if (!Bits.hasFlags(by, 2) && !Bits.hasFlags(by, 8)) continue;
                            this.renderRect(n2 + n10, n + n9, 0.1f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f * f14);
                        }
                    }
                }
            }
        }
        if (this.CellGrid.getValue()) {
            int n11;
            float f15 = 1.0f;
            if (f < 0.1f) {
                f15 = Math.max(f / 0.1f, 0.25f);
            }
            for (n11 = n4; n11 <= n6; ++n11) {
                this.renderLine(isoMetaGrid.minX * 300, (isoMetaGrid.minY + n11) * 300, (isoMetaGrid.maxX + 1) * 300, (isoMetaGrid.minY + n11) * 300, 1.0f, 1.0f, 1.0f, 0.15f * f15);
                if (f > 1.0f) {
                    for (int i = 1; i < 30; ++i) {
                        this.renderLine(isoMetaGrid.minX * 300, (isoMetaGrid.minY + n11) * 300 + i * 10, (isoMetaGrid.maxX + 1) * 300, (isoMetaGrid.minY + n11) * 300 + i * 10, 1.0f, 1.0f, 1.0f, 0.0325f);
                    }
                    continue;
                }
                if (!(f > 0.15f)) continue;
                this.renderLine(isoMetaGrid.minX * 300, (isoMetaGrid.minY + n11) * 300 + 100, (isoMetaGrid.maxX + 1) * 300, (isoMetaGrid.minY + n11) * 300 + 100, 1.0f, 1.0f, 1.0f, 0.075f);
                this.renderLine(isoMetaGrid.minX * 300, (isoMetaGrid.minY + n11) * 300 + 200, (isoMetaGrid.maxX + 1) * 300, (isoMetaGrid.minY + n11) * 300 + 200, 1.0f, 1.0f, 1.0f, 0.075f);
            }
            for (n11 = n3; n11 <= n5; ++n11) {
                this.renderLine((isoMetaGrid.minX + n11) * 300, isoMetaGrid.minY * 300, (isoMetaGrid.minX + n11) * 300, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.15f * f15);
                if (f > 1.0f) {
                    for (int i = 1; i < 30; ++i) {
                        this.renderLine((isoMetaGrid.minX + n11) * 300 + i * 10, isoMetaGrid.minY * 300, (isoMetaGrid.minX + n11) * 300 + i * 10, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.0325f);
                    }
                    continue;
                }
                if (!(f > 0.15f)) continue;
                this.renderLine((isoMetaGrid.minX + n11) * 300 + 100, isoMetaGrid.minY * 300, (isoMetaGrid.minX + n11) * 300 + 100, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.075f);
                this.renderLine((isoMetaGrid.minX + n11) * 300 + 200, isoMetaGrid.minY * 300, (isoMetaGrid.minX + n11) * 300 + 200, (isoMetaGrid.maxY + 1) * 300, 1.0f, 1.0f, 1.0f, 0.075f);
            }
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            this.renderZombie(isoPlayer.x, isoPlayer.y, 0.0f, 0.5f, 0.0f);
        }
        if (this.isEditingEnabled()) {
            float f16;
            float f17 = this.editSquareInRange ? 0.0f : 1.0f;
            float f18 = f16 = this.editSquareInRange ? 1.0f : 0.0f;
            if (this.EditWallN.getValue() || this.EditDoorN.getValue()) {
                this.renderRect(this.editSquareX, this.editSquareY, 1.0f, 0.25f, f17, f16, 0.0f, 0.5f);
                this.renderRect(this.editSquareX, this.editSquareY, 1.0f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, this.editSquareY, 0.05f, 0.25f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, (float)this.editSquareY + 0.2f, 1.0f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect((float)this.editSquareX + 0.95f, this.editSquareY, 0.05f, 0.25f, f17, f16, 0.0f, 1.0f);
            } else if (this.EditWallW.getValue() || this.EditDoorW.getValue()) {
                this.renderRect(this.editSquareX, this.editSquareY, 0.25f, 1.0f, f17, f16, 0.0f, 0.5f);
                this.renderRect(this.editSquareX, this.editSquareY, 0.25f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, this.editSquareY, 0.05f, 1.0f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, (float)this.editSquareY + 0.95f, 0.25f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect((float)this.editSquareX + 0.2f, this.editSquareY, 0.05f, 1.0f, f17, f16, 0.0f, 1.0f);
            } else {
                this.renderRect(this.editSquareX, this.editSquareY, 1.0f, 1.0f, f17, f16, 0.0f, 0.5f);
                this.renderRect(this.editSquareX, this.editSquareY, 1.0f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, this.editSquareY, 0.05f, 1.0f, f17, f16, 0.0f, 1.0f);
                this.renderRect(this.editSquareX, (float)this.editSquareY + 0.95f, 1.0f, 0.05f, f17, f16, 0.0f, 1.0f);
                this.renderRect((float)this.editSquareX + 0.95f, this.editSquareY, 0.05f, 1.0f, f17, f16, 0.0f, 1.0f);
            }
        }
        if (isoChunkRegion != null) {
            this.debugLine("- ChunkRegion -");
            this.debugLine("ID: " + isoChunkRegion.getID());
            this.debugLine("Squares: " + isoChunkRegion.getSquareSize());
            this.debugLine("Roofs: " + isoChunkRegion.getRoofCnt());
            this.debugLine("Neighbors: " + isoChunkRegion.getNeighborCount());
            this.debugLine("ConnectedNeighbors: " + isoChunkRegion.getConnectedNeighbors().size());
            this.debugLine("FullyEnclosed: " + isoChunkRegion.getIsEnclosed());
        }
        if (isoWorldRegion != null) {
            this.debugLine("- WorldRegion -");
            this.debugLine("ID: " + isoWorldRegion.getID());
            this.debugLine("Squares: " + isoWorldRegion.getSquareSize());
            this.debugLine("Roofs: " + isoWorldRegion.getRoofCnt());
            this.debugLine("IsFullyRoofed: " + isoWorldRegion.isFullyRoofed());
            this.debugLine("RoofPercentage: " + isoWorldRegion.getRoofedPercentage());
            this.debugLine("IsEnclosed: " + isoWorldRegion.isEnclosed());
            this.debugLine("Neighbors: " + isoWorldRegion.getNeighbors().size());
            this.debugLine("ChunkRegionCount: " + isoWorldRegion.size());
        }
        int n12 = 15;
        for (int i = 0; i < this.debugLines.size(); ++i) {
            this.renderStringUI(10.0f, n12, this.debugLines.get(i), Colors.CornFlowerBlue);
            n12 += 18;
        }
    }

    public void setEditSquareCoord(int n, int n2) {
        this.editSquareX = n;
        this.editSquareY = n2;
        this.editSquareInRange = false;
        if (this.editCoordInRange(n, n2)) {
            this.editSquareInRange = true;
        }
    }

    private boolean editCoordInRange(int n, int n2) {
        IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare(n, n2, 0);
        return isoGridSquare != null;
    }

    public void editSquare(int n, int n2) {
        if (this.isEditingEnabled()) {
            int n3 = this.getZLevel();
            IsoGridSquare isoGridSquare = IsoWorld.instance.getCell().getGridSquare(n, n2, n3);
            DataRoot dataRoot = IsoRegions.getDataRoot();
            byte by = dataRoot.getSquareFlags(n, n2, n3);
            if (this.editCoordInRange(n, n2)) {
                if (isoGridSquare == null && (isoGridSquare = IsoWorld.instance.getCell().createNewGridSquare(n, n2, n3, true)) == null) {
                    return;
                }
                this.editSquareInRange = true;
                block12: for (int i = 0; i < this.editOptions.size(); ++i) {
                    BooleanDebugOption booleanDebugOption = (BooleanDebugOption)this.editOptions.get(i);
                    if (!booleanDebugOption.getValue()) continue;
                    switch (booleanDebugOption.getName()) {
                        case "Edit.WallW": 
                        case "Edit.WallN": {
                            IsoThumpable isoThumpable;
                            if (booleanDebugOption.getName().equals("Edit.WallN")) {
                                if (by > 0 && Bits.hasFlags(by, 1)) {
                                    return;
                                }
                                isoThumpable = new IsoThumpable(IsoWorld.instance.getCell(), isoGridSquare, "walls_exterior_wooden_01_25", true, null);
                            } else {
                                if (by > 0 && Bits.hasFlags(by, 2)) {
                                    return;
                                }
                                isoThumpable = new IsoThumpable(IsoWorld.instance.getCell(), isoGridSquare, "walls_exterior_wooden_01_24", true, null);
                            }
                            isoThumpable.setMaxHealth(100);
                            isoThumpable.setName("Wall Debug");
                            isoThumpable.setBreakSound("BreakObject");
                            isoGridSquare.AddSpecialObject(isoThumpable);
                            isoGridSquare.RecalcAllWithNeighbours(true);
                            isoThumpable.transmitCompleteItemToServer();
                            if (isoGridSquare.getZone() == null) continue block12;
                            isoGridSquare.getZone().setHaveConstruction(true);
                            continue block12;
                        }
                        case "Edit.DoorW": 
                        case "Edit.DoorN": {
                            IsoThumpable isoThumpable;
                            if (booleanDebugOption.getName().equals("Edit.DoorN")) {
                                if (by > 0 && Bits.hasFlags(by, 1)) {
                                    return;
                                }
                                isoThumpable = new IsoThumpable(IsoWorld.instance.getCell(), isoGridSquare, "walls_exterior_wooden_01_35", true, null);
                            } else {
                                if (by > 0 && Bits.hasFlags(by, 2)) {
                                    return;
                                }
                                isoThumpable = new IsoThumpable(IsoWorld.instance.getCell(), isoGridSquare, "walls_exterior_wooden_01_34", true, null);
                            }
                            isoThumpable.setMaxHealth(100);
                            isoThumpable.setName("Door Frame Debug");
                            isoThumpable.setBreakSound("BreakObject");
                            isoGridSquare.AddSpecialObject(isoThumpable);
                            isoGridSquare.RecalcAllWithNeighbours(true);
                            isoThumpable.transmitCompleteItemToServer();
                            if (isoGridSquare.getZone() == null) continue block12;
                            isoGridSquare.getZone().setHaveConstruction(true);
                            continue block12;
                        }
                        case "Edit.Floor": {
                            if (by > 0 && Bits.hasFlags(by, 16)) {
                                return;
                            }
                            if (n3 == 0) {
                                return;
                            }
                            isoGridSquare.addFloor("carpentry_02_56");
                            if (isoGridSquare.getZone() == null) continue block12;
                            isoGridSquare.getZone().setHaveConstruction(true);
                        }
                    }
                }
            } else {
                this.editSquareInRange = false;
            }
        }
    }

    public boolean isEditingEnabled() {
        return this.EditingEnabled;
    }

    public void editRotate() {
        if (this.EditWallN.getValue()) {
            this.EditWallN.setValue(false);
            this.EditWallW.setValue(true);
        } else if (this.EditWallW.getValue()) {
            this.EditWallW.setValue(false);
            this.EditWallN.setValue(true);
        }
        if (this.EditDoorN.getValue()) {
            this.EditDoorN.setValue(false);
            this.EditDoorW.setValue(true);
        } else if (this.EditDoorW.getValue()) {
            this.EditDoorW.setValue(false);
            this.EditDoorN.setValue(true);
        }
    }

    public ConfigOption getEditOptionByName(String string) {
        for (int i = 0; i < this.editOptions.size(); ++i) {
            ConfigOption configOption = this.editOptions.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getEditOptionCount() {
        return this.editOptions.size();
    }

    public ConfigOption getEditOptionByIndex(int n) {
        return this.editOptions.get(n);
    }

    public void setEditOption(int n, boolean bl) {
        for (int i = 0; i < this.editOptions.size(); ++i) {
            BooleanDebugOption booleanDebugOption = (BooleanDebugOption)this.editOptions.get(i);
            if (i != n) {
                booleanDebugOption.setValue(false);
                continue;
            }
            booleanDebugOption.setValue(bl);
            this.EditingEnabled = bl;
        }
    }

    public int getZLevel() {
        if (this.zLevelPlayer.getValue()) {
            return (int)IsoPlayer.getInstance().getZ();
        }
        for (int i = 0; i < this.zLevelOptions.size(); ++i) {
            BooleanDebugOption booleanDebugOption = (BooleanDebugOption)this.zLevelOptions.get(i);
            if (!booleanDebugOption.getValue()) continue;
            return booleanDebugOption.zLevel;
        }
        return 0;
    }

    public ConfigOption getZLevelOptionByName(String string) {
        for (int i = 0; i < this.zLevelOptions.size(); ++i) {
            ConfigOption configOption = this.zLevelOptions.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getZLevelOptionCount() {
        return this.zLevelOptions.size();
    }

    public ConfigOption getZLevelOptionByIndex(int n) {
        return this.zLevelOptions.get(n);
    }

    public void setZLevelOption(int n, boolean bl) {
        for (int i = 0; i < this.zLevelOptions.size(); ++i) {
            BooleanDebugOption booleanDebugOption = (BooleanDebugOption)this.zLevelOptions.get(i);
            if (i != n) {
                booleanDebugOption.setValue(false);
                continue;
            }
            booleanDebugOption.setValue(bl);
        }
        if (!bl) {
            this.zLevelPlayer.setValue(true);
        }
    }

    public ConfigOption getOptionByName(String string) {
        for (int i = 0; i < this.options.size(); ++i) {
            ConfigOption configOption = this.options.get(i);
            if (!configOption.getName().equals(string)) continue;
            return configOption;
        }
        return null;
    }

    public int getOptionCount() {
        return this.options.size();
    }

    public ConfigOption getOptionByIndex(int n) {
        return this.options.get(n);
    }

    public void setBoolean(String string, boolean bl) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            ((BooleanConfigOption)configOption).setValue(bl);
        }
    }

    public boolean getBoolean(String string) {
        ConfigOption configOption = this.getOptionByName(string);
        if (configOption instanceof BooleanConfigOption) {
            return ((BooleanConfigOption)configOption).getValue();
        }
        return false;
    }

    public void save() {
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "isoregions-options.ini";
        ConfigFile configFile = new ConfigFile();
        configFile.write(string, 1, this.options);
    }

    public void load() {
        ConfigFile configFile = new ConfigFile();
        String string = ZomboidFileSystem.instance.getCacheDir() + File.separator + "isoregions-options.ini";
        if (configFile.read(string)) {
            for (int i = 0; i < configFile.getOptions().size(); ++i) {
                ConfigOption configOption = configFile.getOptions().get(i);
                ConfigOption configOption2 = this.getOptionByName(configOption.getName());
                if (configOption2 == null) continue;
                configOption2.parse(configOption.getValueAsString());
            }
        }
    }

    public static class BooleanDebugOption
    extends BooleanConfigOption {
        private int index;
        private int zLevel = 0;

        public BooleanDebugOption(ArrayList<ConfigOption> arrayList, String string, boolean bl, int n) {
            super(string, bl);
            this.index = arrayList.size();
            this.zLevel = n;
            arrayList.add(this);
        }

        public BooleanDebugOption(ArrayList<ConfigOption> arrayList, String string, boolean bl) {
            super(string, bl);
            this.index = arrayList.size();
            arrayList.add(this);
        }

        public int getIndex() {
            return this.index;
        }
    }
}

