/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas.isoregion;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import zombie.GameWindow;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.ThreadGroups;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.debug.DebugType;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoWorld;
import zombie.iso.areas.isoregion.IsoRegionException;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.areas.isoregion.data.DataChunk;
import zombie.iso.areas.isoregion.data.DataRoot;
import zombie.iso.areas.isoregion.jobs.JobApplyChanges;
import zombie.iso.areas.isoregion.jobs.JobChunkUpdate;
import zombie.iso.areas.isoregion.jobs.JobServerSendFullData;
import zombie.iso.areas.isoregion.jobs.JobSquareUpdate;
import zombie.iso.areas.isoregion.jobs.RegionJob;
import zombie.iso.areas.isoregion.jobs.RegionJobManager;
import zombie.iso.areas.isoregion.jobs.RegionJobType;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;

public final class IsoRegionWorker {
    private Thread thread;
    private boolean bFinished;
    protected static final AtomicBoolean isRequestingBufferSwap = new AtomicBoolean(false);
    private static IsoRegionWorker instance;
    private DataRoot rootBuffer = new DataRoot();
    private List<Integer> discoveredChunks = new ArrayList<Integer>();
    private final List<Integer> threadDiscoveredChunks = new ArrayList<Integer>();
    private int lastThreadDiscoveredChunksSize = 0;
    private final ConcurrentLinkedQueue<RegionJob> jobQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<JobChunkUpdate> jobOutgoingQueue = new ConcurrentLinkedQueue();
    private final List<RegionJob> jobBatchedProcessing = new ArrayList<RegionJob>();
    private final ConcurrentLinkedQueue<RegionJob> finishedJobQueue = new ConcurrentLinkedQueue();
    private static final ByteBuffer byteBuffer;

    protected IsoRegionWorker() {
        instance = this;
    }

    protected void create() {
        if (this.thread != null) {
            return;
        }
        this.bFinished = false;
        this.thread = new Thread(ThreadGroups.Workers, () -> {
            while (!this.bFinished) {
                try {
                    this.thread_main_loop();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.thread.setPriority(5);
        this.thread.setDaemon(true);
        this.thread.setName("IsoRegionWorker");
        this.thread.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        this.thread.start();
    }

    protected void stop() {
        if (this.thread == null) {
            return;
        }
        if (this.thread != null) {
            this.bFinished = true;
            while (this.thread.isAlive()) {
            }
            this.thread = null;
        }
        if (this.jobQueue.size() > 0) {
            DebugLog.IsoRegion.warn("IsoRegionWorker -> JobQueue has items remaining");
        }
        if (this.jobBatchedProcessing.size() > 0) {
            DebugLog.IsoRegion.warn("IsoRegionWorker -> JobBatchedProcessing has items remaining");
        }
        this.jobQueue.clear();
        this.jobOutgoingQueue.clear();
        this.jobBatchedProcessing.clear();
        this.finishedJobQueue.clear();
        this.rootBuffer = null;
        this.discoveredChunks = null;
    }

    protected void EnqueueJob(RegionJob regionJob) {
        this.jobQueue.add(regionJob);
    }

    protected void ApplyChunkChanges() {
        this.ApplyChunkChanges(true);
    }

    protected void ApplyChunkChanges(boolean bl) {
        JobApplyChanges jobApplyChanges = RegionJobManager.allocApplyChanges(bl);
        this.jobQueue.add(jobApplyChanges);
    }

    private void thread_main_loop() throws InterruptedException, IsoRegionException {
        IsoRegions.PRINT_D = DebugLog.isEnabled(DebugType.IsoRegion);
        RegionJob regionJob = this.jobQueue.poll();
        while (regionJob != null) {
            switch (regionJob.getJobType()) {
                case ServerSendFullData: {
                    if (!GameServer.bServer) break;
                    UdpConnection udpConnection = ((JobServerSendFullData)regionJob).getTargetConn();
                    if (udpConnection == null) {
                        if (Core.bDebug) {
                            throw new IsoRegionException("IsoRegion: Server send full data target connection == null");
                        }
                        IsoRegions.warn("IsoRegion: Server send full data target connection == null");
                        break;
                    }
                    IsoRegions.log("IsoRegion: Server Send Full Data to " + udpConnection.idStr);
                    ArrayList<DataChunk> arrayList = new ArrayList<DataChunk>();
                    this.rootBuffer.getAllChunks(arrayList);
                    JobChunkUpdate jobChunkUpdate = RegionJobManager.allocChunkUpdate();
                    jobChunkUpdate.setTargetConn(udpConnection);
                    for (DataChunk dataChunk : arrayList) {
                        if (!jobChunkUpdate.canAddChunk()) {
                            this.jobOutgoingQueue.add(jobChunkUpdate);
                            jobChunkUpdate = RegionJobManager.allocChunkUpdate();
                            jobChunkUpdate.setTargetConn(udpConnection);
                        }
                        jobChunkUpdate.addChunkFromDataChunk(dataChunk);
                    }
                    if (jobChunkUpdate.getChunkCount() > 0) {
                        this.jobOutgoingQueue.add(jobChunkUpdate);
                    } else {
                        RegionJobManager.release(jobChunkUpdate);
                    }
                    this.finishedJobQueue.add(regionJob);
                    break;
                }
                case DebugResetAllData: {
                    IsoRegions.log("IsoRegion: Debug Reset All Data");
                    for (int i = 0; i < 2; ++i) {
                        this.rootBuffer.resetAllData();
                        if (i != 0) continue;
                        isRequestingBufferSwap.set(true);
                        while (isRequestingBufferSwap.get() && !this.bFinished) {
                            Thread.sleep(5L);
                        }
                    }
                    this.finishedJobQueue.add(regionJob);
                    break;
                }
                case SquareUpdate: 
                case ChunkUpdate: 
                case ApplyChanges: {
                    IsoRegions.log("IsoRegion: Queueing " + regionJob.getJobType() + " for batched processing.");
                    this.jobBatchedProcessing.add(regionJob);
                    if (regionJob.getJobType() != RegionJobType.ApplyChanges) break;
                    this.thread_run_batched_jobs();
                    this.jobBatchedProcessing.clear();
                    break;
                }
                default: {
                    this.finishedJobQueue.add(regionJob);
                }
            }
            regionJob = this.jobQueue.poll();
        }
        Thread.sleep(20L);
    }

    private void thread_run_batched_jobs() throws InterruptedException {
        IsoRegions.log("IsoRegion: Apply changes -> Batched processing " + this.jobBatchedProcessing.size() + " jobs.");
        for (int i = 0; i < 2; ++i) {
            block8: for (int j = 0; j < this.jobBatchedProcessing.size(); ++j) {
                RegionJob regionJob = this.jobBatchedProcessing.get(j);
                switch (regionJob.getJobType()) {
                    case SquareUpdate: {
                        RegionJob regionJob2 = (JobSquareUpdate)regionJob;
                        this.rootBuffer.updateExistingSquare(((JobSquareUpdate)regionJob2).getWorldSquareX(), ((JobSquareUpdate)regionJob2).getWorldSquareY(), ((JobSquareUpdate)regionJob2).getWorldSquareZ(), ((JobSquareUpdate)regionJob2).getNewSquareFlags());
                        continue block8;
                    }
                    case ChunkUpdate: {
                        RegionJob regionJob2 = (JobChunkUpdate)regionJob;
                        ((JobChunkUpdate)regionJob2).readChunksPacket(this.rootBuffer, this.threadDiscoveredChunks);
                        continue block8;
                    }
                    case ApplyChanges: {
                        this.rootBuffer.processDirtyChunks();
                        if (i == 0) {
                            isRequestingBufferSwap.set(true);
                            while (isRequestingBufferSwap.get()) {
                                Thread.sleep(5L);
                            }
                            continue block8;
                        }
                        RegionJob regionJob2 = (JobApplyChanges)regionJob;
                        if (!GameClient.bClient && ((JobApplyChanges)regionJob2).isSaveToDisk()) {
                            Object object;
                            for (int k = this.jobBatchedProcessing.size() - 1; k >= 0; --k) {
                                Object object2;
                                object = this.jobBatchedProcessing.get(k);
                                if (((RegionJob)object).getJobType() != RegionJobType.ChunkUpdate && ((RegionJob)object).getJobType() != RegionJobType.SquareUpdate) continue;
                                if (((RegionJob)object).getJobType() == RegionJobType.SquareUpdate) {
                                    JobSquareUpdate jobSquareUpdate = (JobSquareUpdate)object;
                                    this.rootBuffer.select.reset(jobSquareUpdate.getWorldSquareX(), jobSquareUpdate.getWorldSquareY(), jobSquareUpdate.getWorldSquareZ(), true, false);
                                    object2 = RegionJobManager.allocChunkUpdate();
                                    ((JobChunkUpdate)object2).addChunkFromDataChunk(this.rootBuffer.select.chunk);
                                } else {
                                    this.jobBatchedProcessing.remove(k);
                                    object2 = (JobChunkUpdate)object;
                                }
                                ((JobChunkUpdate)object2).saveChunksToDisk();
                                if (!GameServer.bServer) continue;
                                this.jobOutgoingQueue.add((JobChunkUpdate)object2);
                            }
                            if (this.threadDiscoveredChunks.size() > 0 && this.threadDiscoveredChunks.size() > this.lastThreadDiscoveredChunksSize && !Core.getInstance().isNoSave()) {
                                IsoRegions.log("IsoRegion: Apply changes -> Saving header file to disk.");
                                File file = IsoRegions.getHeaderFile();
                                try {
                                    object = new DataOutputStream(new FileOutputStream(file));
                                    ((DataOutputStream)object).writeInt(195);
                                    ((DataOutputStream)object).writeInt(this.threadDiscoveredChunks.size());
                                    for (Integer n : this.threadDiscoveredChunks) {
                                        ((DataOutputStream)object).writeInt(n);
                                    }
                                    ((DataOutputStream)object).flush();
                                    ((FilterOutputStream)object).close();
                                    this.lastThreadDiscoveredChunksSize = this.threadDiscoveredChunks.size();
                                }
                                catch (Exception exception) {
                                    DebugLog.log(exception.getMessage());
                                    exception.printStackTrace();
                                }
                            }
                        }
                        this.finishedJobQueue.addAll(this.jobBatchedProcessing);
                    }
                }
            }
        }
    }

    protected DataRoot getRootBuffer() {
        return this.rootBuffer;
    }

    protected void setRootBuffer(DataRoot dataRoot) {
        this.rootBuffer = dataRoot;
    }

    protected void load() {
        IsoRegions.log("IsoRegion: Load save map.");
        if (!GameClient.bClient) {
            this.loadSaveMap();
        } else {
            GameClient.sendIsoRegionDataRequest();
        }
    }

    protected void update() {
        RegionJob regionJob = this.finishedJobQueue.poll();
        while (regionJob != null) {
            RegionJobManager.release(regionJob);
            regionJob = this.finishedJobQueue.poll();
        }
        regionJob = this.jobOutgoingQueue.poll();
        while (regionJob != null) {
            if (GameServer.bServer) {
                IsoRegions.log("IsoRegion: sending changed datachunks packet.");
                try {
                    for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                        UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                        if (((JobChunkUpdate)regionJob).getTargetConn() != null && ((JobChunkUpdate)regionJob).getTargetConn() != udpConnection) continue;
                        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                        PacketTypes.PacketType.IsoRegionServerPacket.doPacket(byteBufferWriter);
                        ByteBuffer byteBuffer = byteBufferWriter.bb;
                        byteBuffer.putLong(System.nanoTime());
                        ((JobChunkUpdate)regionJob).saveChunksToNetBuffer(byteBuffer);
                        PacketTypes.PacketType.IsoRegionServerPacket.send(udpConnection);
                    }
                }
                catch (Exception exception) {
                    DebugLog.log(exception.getMessage());
                    exception.printStackTrace();
                }
            }
            RegionJobManager.release(regionJob);
            regionJob = this.jobOutgoingQueue.poll();
        }
    }

    protected void readServerUpdatePacket(ByteBuffer byteBuffer) {
        if (GameClient.bClient) {
            IsoRegions.log("IsoRegion: Receiving changed datachunk packet from server");
            try {
                JobChunkUpdate jobChunkUpdate = RegionJobManager.allocChunkUpdate();
                long l = byteBuffer.getLong();
                jobChunkUpdate.readChunksFromNetBuffer(byteBuffer, l);
                this.EnqueueJob(jobChunkUpdate);
                this.ApplyChunkChanges();
            }
            catch (Exception exception) {
                DebugLog.log(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void readClientRequestFullUpdatePacket(ByteBuffer byteBuffer, UdpConnection udpConnection) {
        if (GameServer.bServer && udpConnection != null) {
            IsoRegions.log("IsoRegion: Receiving request full data packet from client");
            try {
                JobServerSendFullData jobServerSendFullData = RegionJobManager.allocServerSendFullData(udpConnection);
                this.EnqueueJob(jobServerSendFullData);
            }
            catch (Exception exception) {
                DebugLog.log(exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void addDebugResetJob() {
        if (!GameServer.bServer && !GameClient.bClient) {
            this.EnqueueJob(RegionJobManager.allocDebugResetAllData());
        }
    }

    protected void addSquareChangedJob(int n, int n2, int n3, boolean bl, byte by) {
        int n4 = n / 10;
        int n5 = n2 / 10;
        int n6 = IsoRegions.hash(n4, n5);
        if (this.discoveredChunks.contains(n6)) {
            IsoRegions.log("Update square only, plus any unprocessed chunks in a 7x7 grid.", Colors.Magenta);
            JobSquareUpdate jobSquareUpdate = RegionJobManager.allocSquareUpdate(n, n2, n3, by);
            this.EnqueueJob(jobSquareUpdate);
            this.readSurroundingChunks(n4, n5, 7, false);
            this.ApplyChunkChanges();
        } else {
            if (bl) {
                return;
            }
            IsoRegions.log("Adding new chunk, plus any unprocessed chunks in a 7x7 grid.", Colors.Magenta);
            this.readSurroundingChunks(n4, n5, 7, true);
        }
    }

    protected void readSurroundingChunks(int n, int n2, int n3, boolean bl) {
        this.readSurroundingChunks(n, n2, n3, bl, false);
    }

    protected void readSurroundingChunks(int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4 = 1;
        if (n3 > 0 && n3 <= IsoChunkMap.ChunkGridWidth && (n4 = n3 / 2) + n4 >= IsoChunkMap.ChunkGridWidth) {
            --n4;
        }
        int n5 = n - n4;
        int n6 = n2 - n4;
        int n7 = n + n4;
        int n8 = n2 + n4;
        JobChunkUpdate jobChunkUpdate = RegionJobManager.allocChunkUpdate();
        boolean bl3 = false;
        for (int i = n5; i <= n7; ++i) {
            for (int j = n6; j <= n8; ++j) {
                IsoChunk isoChunk;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(i, j) : IsoWorld.instance.getCell().getChunk(i, j);
                if (isoChunk == null) continue;
                int n9 = IsoRegions.hash(isoChunk.wx, isoChunk.wy);
                if (!bl2 && this.discoveredChunks.contains(n9)) continue;
                this.discoveredChunks.add(n9);
                if (!jobChunkUpdate.canAddChunk()) {
                    this.EnqueueJob(jobChunkUpdate);
                    jobChunkUpdate = RegionJobManager.allocChunkUpdate();
                }
                jobChunkUpdate.addChunkFromIsoChunk(isoChunk);
                bl3 = true;
            }
        }
        if (jobChunkUpdate.getChunkCount() > 0) {
            this.EnqueueJob(jobChunkUpdate);
        } else {
            RegionJobManager.release(jobChunkUpdate);
        }
        if (bl3 && bl) {
            this.ApplyChunkChanges();
        }
    }

    private void loadSaveMap() {
        try {
            int n;
            Object object;
            boolean bl = false;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            File file = IsoRegions.getHeaderFile();
            if (file.exists()) {
                object = new DataInputStream(new FileInputStream(file));
                bl = true;
                int n2 = ((DataInputStream)object).readInt();
                int n3 = ((DataInputStream)object).readInt();
                for (n = 0; n < n3; ++n) {
                    int n4 = ((DataInputStream)object).readInt();
                    arrayList.add(n4);
                }
                ((FilterInputStream)object).close();
            }
            object = IsoRegions.getDirectory();
            File[] fileArray = ((File)object).listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.startsWith("datachunk_") && string.endsWith(".bin");
                }
            });
            JobChunkUpdate jobChunkUpdate = RegionJobManager.allocChunkUpdate();
            ByteBuffer byteBuffer = IsoRegionWorker.byteBuffer;
            n = 0;
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    try (FileInputStream fileInputStream = new FileInputStream(file2);){
                        byteBuffer.clear();
                        int n5 = fileInputStream.read(byteBuffer.array());
                        byteBuffer.limit(n5);
                        byteBuffer.mark();
                        int n6 = byteBuffer.getInt();
                        int n7 = byteBuffer.getInt();
                        int n8 = byteBuffer.getInt();
                        int n9 = byteBuffer.getInt();
                        byteBuffer.reset();
                        int n10 = IsoRegions.hash(n8, n9);
                        if (!this.discoveredChunks.contains(n10)) {
                            this.discoveredChunks.add(n10);
                        }
                        if (arrayList.contains(n10)) {
                            arrayList.remove(arrayList.indexOf(n10));
                        } else {
                            IsoRegions.warn("IsoRegion: A chunk save has been found that was not in header known chunks list.");
                        }
                        if (!jobChunkUpdate.canAddChunk()) {
                            this.EnqueueJob(jobChunkUpdate);
                            jobChunkUpdate = RegionJobManager.allocChunkUpdate();
                        }
                        jobChunkUpdate.addChunkFromFile(byteBuffer);
                        n = 1;
                    }
                }
            }
            if (jobChunkUpdate.getChunkCount() > 0) {
                this.EnqueueJob(jobChunkUpdate);
            } else {
                RegionJobManager.release(jobChunkUpdate);
            }
            if (n != 0) {
                this.ApplyChunkChanges(false);
            }
            if (bl && arrayList.size() > 0) {
                IsoRegions.warn("IsoRegion: " + arrayList.size() + " previously discovered chunks have not been loaded.");
                throw new IsoRegionException("IsoRegion: " + arrayList.size() + " previously discovered chunks have not been loaded.");
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception.getMessage());
            exception.printStackTrace();
        }
    }

    static {
        byteBuffer = ByteBuffer.allocate(1024);
    }
}

