/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Calendar;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Translator;
import zombie.debug.DebugLog;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.areas.IsoRoom;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.ServerOptions;
import zombie.network.chat.ChatServer;
import zombie.network.packets.SyncSafehousePacket;

public class SafeHouse {
    private int x = 0;
    private int y = 0;
    private int w = 0;
    private int h = 0;
    private static int diffError = 2;
    private String owner = null;
    private ArrayList<String> players = new ArrayList();
    private long lastVisited = 0L;
    private String title = "Safehouse";
    private int playerConnected = 0;
    private int openTimer = 0;
    private final String id;
    public ArrayList<String> playersRespawn = new ArrayList();
    private static final ArrayList<SafeHouse> safehouseList = new ArrayList();
    private static final ArrayList<IsoPlayer> tempPlayers = new ArrayList();

    public static void init() {
        safehouseList.clear();
    }

    public static SafeHouse addSafeHouse(int n, int n2, int n3, int n4, String string, boolean bl) {
        SafeHouse safeHouse = new SafeHouse(n, n2, n3, n4, string);
        safeHouse.setOwner(string);
        safeHouse.setLastVisited(Calendar.getInstance().getTimeInMillis());
        safeHouse.addPlayer(string);
        safehouseList.add(safeHouse);
        if (GameServer.bServer) {
            DebugLog.log("safehouse: added " + n + "," + n2 + "," + n3 + "," + n4 + " owner=" + string);
        }
        if (GameClient.bClient && !bl) {
            GameClient.sendSafehouse(safeHouse, false);
        }
        SafeHouse.updateSafehousePlayersConnected();
        if (GameClient.bClient) {
            LuaEventManager.triggerEvent("OnSafehousesChanged");
        }
        return safeHouse;
    }

    public static SafeHouse addSafeHouse(IsoGridSquare isoGridSquare, IsoPlayer isoPlayer) {
        String string = SafeHouse.canBeSafehouse(isoGridSquare, isoPlayer);
        if (string != null && !"".equals(string)) {
            return null;
        }
        return SafeHouse.addSafeHouse(isoGridSquare.getBuilding().def.getX() - diffError, isoGridSquare.getBuilding().def.getY() - diffError, isoGridSquare.getBuilding().def.getW() + diffError * 2, isoGridSquare.getBuilding().def.getH() + diffError * 2, isoPlayer.getUsername(), false);
    }

    public static SafeHouse hasSafehouse(String string) {
        for (int i = 0; i < safehouseList.size(); ++i) {
            SafeHouse safeHouse = safehouseList.get(i);
            if (!safeHouse.getPlayers().contains(string) && !safeHouse.getOwner().equals(string)) continue;
            return safeHouse;
        }
        return null;
    }

    public static SafeHouse hasSafehouse(IsoPlayer isoPlayer) {
        return SafeHouse.hasSafehouse(isoPlayer.getUsername());
    }

    public static void updateSafehousePlayersConnected() {
        SafeHouse safeHouse = null;
        for (int i = 0; i < safehouseList.size(); ++i) {
            safeHouse = safehouseList.get(i);
            safeHouse.setPlayerConnected(0);
            if (GameClient.bClient) {
                for (IsoPlayer isoPlayer : GameClient.IDToPlayerMap.values()) {
                    if (!safeHouse.getPlayers().contains(isoPlayer.getUsername()) && !safeHouse.getOwner().equals(isoPlayer.getUsername())) continue;
                    safeHouse.setPlayerConnected(safeHouse.getPlayerConnected() + 1);
                }
                continue;
            }
            if (!GameServer.bServer) continue;
            for (IsoPlayer isoPlayer : GameServer.IDToPlayerMap.values()) {
                if (!safeHouse.getPlayers().contains(isoPlayer.getUsername()) && !safeHouse.getOwner().equals(isoPlayer.getUsername())) continue;
                safeHouse.setPlayerConnected(safeHouse.getPlayerConnected() + 1);
            }
        }
    }

    public void updatePlayersConnected() {
        block3: {
            block2: {
                this.setPlayerConnected(0);
                if (!GameClient.bClient) break block2;
                for (IsoPlayer isoPlayer : GameClient.IDToPlayerMap.values()) {
                    if (!this.getPlayers().contains(isoPlayer.getUsername()) && !this.getOwner().equals(isoPlayer.getUsername())) continue;
                    this.setPlayerConnected(this.getPlayerConnected() + 1);
                }
                break block3;
            }
            if (!GameServer.bServer) break block3;
            for (IsoPlayer isoPlayer : GameServer.IDToPlayerMap.values()) {
                if (!this.getPlayers().contains(isoPlayer.getUsername()) && !this.getOwner().equals(isoPlayer.getUsername())) continue;
                this.setPlayerConnected(this.getPlayerConnected() + 1);
            }
        }
    }

    public static SafeHouse getSafeHouse(IsoGridSquare isoGridSquare) {
        return SafeHouse.isSafeHouse(isoGridSquare, null, false);
    }

    public static SafeHouse getSafeHouse(int n, int n2, int n3, int n4) {
        SafeHouse safeHouse = null;
        for (int i = 0; i < safehouseList.size(); ++i) {
            safeHouse = safehouseList.get(i);
            if (n != safeHouse.getX() || n3 != safeHouse.getW() || n2 != safeHouse.getY() || n4 != safeHouse.getH()) continue;
            return safeHouse;
        }
        return null;
    }

    public static SafeHouse isSafeHouse(IsoGridSquare isoGridSquare, String string, boolean bl) {
        Object object;
        if (isoGridSquare == null) {
            return null;
        }
        if (GameClient.bClient && (object = GameClient.instance.getPlayerFromUsername(string)) != null && !((IsoPlayer)object).accessLevel.equals("")) {
            return null;
        }
        object = null;
        boolean bl2 = false;
        for (int i = 0; i < safehouseList.size(); ++i) {
            object = safehouseList.get(i);
            if (isoGridSquare.getX() < ((SafeHouse)object).getX() || isoGridSquare.getX() >= ((SafeHouse)object).getX2() || isoGridSquare.getY() < ((SafeHouse)object).getY() || isoGridSquare.getY() >= ((SafeHouse)object).getY2()) continue;
            bl2 = true;
            break;
        }
        if (bl2 && bl && ServerOptions.instance.DisableSafehouseWhenPlayerConnected.getValue() && (((SafeHouse)object).getPlayerConnected() > 0 || ((SafeHouse)object).getOpenTimer() > 0)) {
            return null;
        }
        if (bl2 && (string != null && object != null && !((SafeHouse)object).getPlayers().contains(string) && !((SafeHouse)object).getOwner().equals(string) || string == null)) {
            return object;
        }
        return null;
    }

    public static void clearSafehouseList() {
        safehouseList.clear();
    }

    public boolean playerAllowed(IsoPlayer isoPlayer) {
        return this.players.contains(isoPlayer.getUsername()) || this.owner.equals(isoPlayer.getUsername()) || !isoPlayer.accessLevel.equals("");
    }

    public boolean playerAllowed(String string) {
        return this.players.contains(string) || this.owner.equals(string);
    }

    public void addPlayer(String string) {
        if (!this.players.contains(string)) {
            this.players.add(string);
            SafeHouse.updateSafehousePlayersConnected();
        }
    }

    public void removePlayer(String string) {
        if (this.players.contains(string)) {
            this.players.remove(string);
            this.playersRespawn.remove(string);
            if (GameClient.bClient) {
                GameClient.sendSafehouse(this, false);
            }
        }
    }

    public void syncSafehouse() {
        if (GameClient.bClient) {
            GameClient.sendSafehouse(this, false);
        }
    }

    public void removeSafeHouse(IsoPlayer isoPlayer) {
        this.removeSafeHouse(isoPlayer, false);
    }

    public void removeSafeHouse(IsoPlayer isoPlayer, boolean bl) {
        if (isoPlayer != null && !isoPlayer.getUsername().equals(this.getOwner()) && (isoPlayer.accessLevel.equals("admin") || isoPlayer.accessLevel.equals("moderator")) && !bl) {
            return;
        }
        if (GameClient.bClient) {
            GameClient.sendSafehouse(this, true);
        }
        if (GameServer.bServer) {
            SyncSafehousePacket syncSafehousePacket = new SyncSafehousePacket();
            syncSafehousePacket.set(this, true);
            GameServer.sendSafehouse(syncSafehousePacket, null);
        }
        SafeHouse.getSafehouseList().remove(this);
        DebugLog.log("safehouse: removed " + this.x + "," + this.y + "," + this.w + "," + this.h + " owner=" + this.getOwner());
        if (GameClient.bClient) {
            LuaEventManager.triggerEvent("OnSafehousesChanged");
        }
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getX());
        byteBuffer.putInt(this.getY());
        byteBuffer.putInt(this.getW());
        byteBuffer.putInt(this.getH());
        GameWindow.WriteString(byteBuffer, this.getOwner());
        byteBuffer.putInt(this.getPlayers().size());
        for (String string : this.getPlayers()) {
            GameWindow.WriteString(byteBuffer, string);
        }
        byteBuffer.putLong(this.getLastVisited());
        GameWindow.WriteString(byteBuffer, this.getTitle());
        byteBuffer.putInt(this.playersRespawn.size());
        for (int i = 0; i < this.playersRespawn.size(); ++i) {
            GameWindow.WriteString(byteBuffer, this.playersRespawn.get(i));
        }
    }

    public static SafeHouse load(ByteBuffer byteBuffer, int n) {
        int n2;
        SafeHouse safeHouse = new SafeHouse(byteBuffer.getInt(), byteBuffer.getInt(), byteBuffer.getInt(), byteBuffer.getInt(), GameWindow.ReadString(byteBuffer));
        int n3 = byteBuffer.getInt();
        for (n2 = 0; n2 < n3; ++n2) {
            safeHouse.addPlayer(GameWindow.ReadString(byteBuffer));
        }
        safeHouse.setLastVisited(byteBuffer.getLong());
        if (n >= 101) {
            safeHouse.setTitle(GameWindow.ReadString(byteBuffer));
        }
        if (ChatServer.isInited()) {
            ChatServer.getInstance().createSafehouseChat(safeHouse.getId());
        }
        safehouseList.add(safeHouse);
        if (n >= 177) {
            n2 = byteBuffer.getInt();
            for (int i = 0; i < n2; ++i) {
                safeHouse.playersRespawn.add(GameWindow.ReadString(byteBuffer));
            }
        }
        return safeHouse;
    }

    /*
     * WARNING - void declaration
     */
    public static String canBeSafehouse(IsoGridSquare isoGridSquare, IsoPlayer isoPlayer) {
        void var11_20;
        Serializable serializable;
        Object object;
        Object object2;
        if (!GameClient.bClient && !GameServer.bServer) {
            return null;
        }
        if (!ServerOptions.instance.PlayerSafehouse.getValue() && !ServerOptions.instance.AdminSafehouse.getValue()) {
            return null;
        }
        Object object3 = "";
        if (ServerOptions.instance.PlayerSafehouse.getValue() && SafeHouse.hasSafehouse(isoPlayer) != null) {
            object3 = (String)object3 + Translator.getText("IGUI_Safehouse_AlreadyHaveSafehouse") + System.lineSeparator();
        }
        int n = ServerOptions.instance.SafehouseDaySurvivedToClaim.getValue();
        if (!ServerOptions.instance.PlayerSafehouse.getValue() && ServerOptions.instance.AdminSafehouse.getValue() && GameClient.bClient) {
            if (!isoPlayer.accessLevel.equals("admin") && !isoPlayer.accessLevel.equals("moderator")) {
                return null;
            }
            n = 0;
        }
        if (n > 0 && isoPlayer.getHoursSurvived() < (double)(n * 24)) {
            object3 = (String)object3 + Translator.getText("IGUI_Safehouse_DaysSurvivedToClaim", n) + System.lineSeparator();
        }
        if (GameClient.bClient) {
            KahluaTableIterator kahluaTableIterator = GameClient.instance.getServerSpawnRegions().iterator();
            IsoGridSquare isoGridSquare2 = null;
            while (kahluaTableIterator.advance()) {
                KahluaTable kahluaTable = (KahluaTable)kahluaTableIterator.getValue();
                KahluaTableIterator kahluaTableIterator2 = ((KahluaTableImpl)kahluaTable.rawget("points")).iterator();
                while (kahluaTableIterator2.advance()) {
                    KahluaTable kahluaTable2 = (KahluaTable)kahluaTableIterator2.getValue();
                    object2 = kahluaTable2.iterator();
                    while (object2.advance()) {
                        object = (KahluaTable)object2.getValue();
                        Double object4 = (Double)object.rawget("worldX");
                        serializable = (Double)object.rawget("worldY");
                        Double d = (Double)object.rawget("posX");
                        Double d2 = (Double)object.rawget("posY");
                        isoGridSquare2 = IsoWorld.instance.getCell().getGridSquare(d + object4 * 300.0, d2 + (Double)serializable * 300.0, 0.0);
                        if (isoGridSquare2 == null || isoGridSquare2.getBuilding() == null || isoGridSquare2.getBuilding().getDef() == null) continue;
                        BuildingDef buildingDef = isoGridSquare2.getBuilding().getDef();
                        if (isoGridSquare.getX() < buildingDef.getX() || isoGridSquare.getX() >= buildingDef.getX2() || isoGridSquare.getY() < buildingDef.getY() || isoGridSquare.getY() >= buildingDef.getY2()) continue;
                        return Translator.getText("IGUI_Safehouse_IsSpawnPoint");
                    }
                }
            }
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        object2 = isoGridSquare.getBuilding().getDef();
        if (isoGridSquare.getBuilding().Rooms != null) {
            for (IsoRoom isoRoom : isoGridSquare.getBuilding().Rooms) {
                if (isoRoom.getName().equals("kitchen")) {
                    bl3 = true;
                }
                if (isoRoom.getName().equals("bedroom") || isoRoom.getName().equals("livingroom")) {
                    bl4 = true;
                }
                if (!isoRoom.getName().equals("bathroom")) continue;
                bl5 = true;
            }
        }
        object = IsoWorld.instance.getCell();
        boolean bl6 = false;
        while (var11_20 < ((IsoCell)object).getObjectList().size()) {
            serializable = ((IsoCell)object).getObjectList().get((int)var11_20);
            if (serializable != isoPlayer && serializable instanceof IsoGameCharacter && ((IsoMovingObject)serializable).getX() >= (float)(((BuildingDef)object2).getX() - diffError) && ((IsoMovingObject)serializable).getX() < (float)(((BuildingDef)object2).getX2() + diffError) && ((IsoMovingObject)serializable).getY() >= (float)(((BuildingDef)object2).getY() - diffError) && ((IsoMovingObject)serializable).getY() < (float)(((BuildingDef)object2).getY2() + diffError)) {
                bl = false;
                break;
            }
            ++var11_20;
        }
        if (isoPlayer.getX() >= (float)(((BuildingDef)object2).getX() - diffError) && isoPlayer.getX() < (float)(((BuildingDef)object2).getX2() + diffError) && isoPlayer.getY() >= (float)(((BuildingDef)object2).getY() - diffError) && isoPlayer.getY() < (float)(((BuildingDef)object2).getY2() + diffError) && isoPlayer.getCurrentSquare() != null && !isoPlayer.getCurrentSquare().Is(IsoFlagType.exterior)) {
            bl2 = true;
        }
        if (!bl || !bl2) {
            object3 = (String)object3 + Translator.getText("IGUI_Safehouse_SomeoneInside") + System.lineSeparator();
        }
        if (!bl4 && !ServerOptions.instance.SafehouseAllowNonResidential.getValue()) {
            object3 = (String)object3 + Translator.getText("IGUI_Safehouse_NotHouse") + System.lineSeparator();
        }
        return object3;
    }

    public void kickOutOfSafehouse(IsoPlayer isoPlayer) {
        if (isoPlayer.isAccessLevel("None")) {
            GameClient.sendKickOutOfSafehouse(isoPlayer);
        }
    }

    public void checkTrespass(IsoPlayer isoPlayer) {
        SafeHouse safeHouse;
        if (GameServer.bServer && !ServerOptions.instance.SafehouseAllowTrepass.getValue() && isoPlayer.getVehicle() == null && !isoPlayer.isAccessLevel("admin") && (safeHouse = SafeHouse.isSafeHouse(isoPlayer.getCurrentSquare(), isoPlayer.getUsername(), true)) != null) {
            GameServer.sendTeleport(isoPlayer, this.x - 1, this.y - 1, 0.0f);
            if (isoPlayer.isAsleep()) {
                isoPlayer.setAsleep(false);
                isoPlayer.setAsleepTime(0.0f);
                GameServer.sendWakeUpPlayer(isoPlayer, null);
            }
        }
    }

    public SafeHouse alreadyHaveSafehouse(String string) {
        if (ServerOptions.instance.PlayerSafehouse.getValue()) {
            return SafeHouse.hasSafehouse(string);
        }
        return null;
    }

    public SafeHouse alreadyHaveSafehouse(IsoPlayer isoPlayer) {
        if (ServerOptions.instance.PlayerSafehouse.getValue()) {
            return SafeHouse.hasSafehouse(isoPlayer);
        }
        return null;
    }

    public static boolean allowSafeHouse(IsoPlayer isoPlayer) {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = bl = !(!GameClient.bClient && !GameServer.bServer || !ServerOptions.instance.PlayerSafehouse.getValue() && !ServerOptions.instance.AdminSafehouse.getValue());
        if (bl) {
            if (ServerOptions.instance.PlayerSafehouse.getValue()) {
                boolean bl4 = bl2 = SafeHouse.hasSafehouse(isoPlayer) == null;
            }
            if (bl2 && ServerOptions.instance.SafehouseDaySurvivedToClaim.getValue() > 0 && isoPlayer.getHoursSurvived() / 24.0 < (double)ServerOptions.instance.SafehouseDaySurvivedToClaim.getValue()) {
                bl2 = false;
            }
            if (ServerOptions.instance.AdminSafehouse.getValue() && GameClient.bClient) {
                bl2 = isoPlayer.accessLevel.equals("admin") || isoPlayer.accessLevel.equals("moderator");
            }
        }
        return bl2;
    }

    public void updateSafehouse(IsoPlayer isoPlayer) {
        this.updatePlayersConnected();
        if (isoPlayer != null && (this.getPlayers().contains(isoPlayer.getUsername()) || this.getOwner().equals(isoPlayer.getUsername()))) {
            this.setLastVisited(System.currentTimeMillis());
        } else if (ServerOptions.instance.SafeHouseRemovalTime.getValue() > 0 && System.currentTimeMillis() - this.getLastVisited() > 3600000L * (long)ServerOptions.instance.SafeHouseRemovalTime.getValue()) {
            boolean bl = false;
            ArrayList<IsoPlayer> arrayList = GameServer.getPlayers(tempPlayers);
            for (int i = 0; i < arrayList.size(); ++i) {
                IsoPlayer isoPlayer2 = arrayList.get(i);
                if (!this.containsLocation(isoPlayer2.x, isoPlayer2.y) || !this.getPlayers().contains(isoPlayer2.getUsername()) && !this.getOwner().equals(isoPlayer2.getUsername())) continue;
                bl = true;
                break;
            }
            if (bl) {
                this.setLastVisited(System.currentTimeMillis());
                return;
            }
            this.removeSafeHouse(isoPlayer, true);
        }
    }

    public SafeHouse(int n, int n2, int n3, int n4, String string) {
        this.x = n;
        this.y = n2;
        this.w = n3;
        this.h = n4;
        this.players.add(string);
        this.owner = string;
        this.id = n + "," + n2 + " at " + Calendar.getInstance().getTimeInMillis();
    }

    public String getId() {
        return this.id;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int n) {
        this.w = n;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int n) {
        this.h = n;
    }

    public int getX2() {
        return this.x + this.w;
    }

    public int getY2() {
        return this.y + this.h;
    }

    public boolean containsLocation(float f, float f2) {
        return f >= (float)this.getX() && f < (float)this.getX2() && f2 >= (float)this.getY() && f2 < (float)this.getY2();
    }

    public ArrayList<String> getPlayers() {
        return this.players;
    }

    public void setPlayers(ArrayList<String> arrayList) {
        this.players = arrayList;
    }

    public static ArrayList<SafeHouse> getSafehouseList() {
        return safehouseList;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
        if (this.players.contains(string)) {
            this.players.remove(string);
        }
    }

    public boolean isOwner(IsoPlayer isoPlayer) {
        return this.getOwner().equals(isoPlayer.getUsername());
    }

    public long getLastVisited() {
        return this.lastVisited;
    }

    public void setLastVisited(long l) {
        this.lastVisited = l;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getPlayerConnected() {
        return this.playerConnected;
    }

    public void setPlayerConnected(int n) {
        this.playerConnected = n;
    }

    public int getOpenTimer() {
        return this.openTimer;
    }

    public void setOpenTimer(int n) {
        this.openTimer = n;
    }

    public void setRespawnInSafehouse(boolean bl, String string) {
        if (bl) {
            this.playersRespawn.add(string);
        } else {
            this.playersRespawn.remove(string);
        }
        if (GameClient.bClient) {
            GameClient.sendSafehouse(this, false);
        }
    }

    public boolean isRespawnInSafehouse(String string) {
        return this.playersRespawn.contains(string);
    }

    public static boolean isPlayerAllowedOnSquare(IsoPlayer isoPlayer, IsoGridSquare isoGridSquare) {
        if (!ServerOptions.instance.SafehouseAllowTrepass.getValue()) {
            return SafeHouse.isSafeHouse(isoGridSquare, isoPlayer.getUsername(), true) == null;
        }
        return true;
    }
}

