/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.network.GameClient;

public final class NonPvpZone {
    private int x;
    private int y;
    private int x2;
    private int y2;
    private int size;
    private String title;
    public static final ArrayList<NonPvpZone> nonPvpZoneList = new ArrayList();

    public NonPvpZone() {
    }

    public NonPvpZone(String string, int n, int n2, int n3, int n4) {
        int n5;
        if (n > n3) {
            n5 = n3;
            n3 = n;
            n = n5;
        }
        if (n2 > n4) {
            n5 = n4;
            n4 = n2;
            n2 = n5;
        }
        this.setX(n);
        this.setX2(n3);
        this.setY(n2);
        this.setY2(n4);
        this.title = string;
        this.size = Math.abs(n - n3 + (n2 - n4));
    }

    public static NonPvpZone addNonPvpZone(String string, int n, int n2, int n3, int n4) {
        NonPvpZone nonPvpZone = new NonPvpZone(string, n, n2, n3, n4);
        nonPvpZoneList.add(nonPvpZone);
        nonPvpZone.syncNonPvpZone(false);
        return nonPvpZone;
    }

    public static void removeNonPvpZone(String string) {
        NonPvpZone nonPvpZone = NonPvpZone.getZoneByTitle(string);
        if (nonPvpZone != null) {
            nonPvpZoneList.remove(nonPvpZone);
            nonPvpZone.syncNonPvpZone(true);
        }
    }

    public static NonPvpZone getZoneByTitle(String string) {
        for (int i = 0; i < nonPvpZoneList.size(); ++i) {
            NonPvpZone nonPvpZone = nonPvpZoneList.get(i);
            if (!nonPvpZone.getTitle().equals(string)) continue;
            return nonPvpZone;
        }
        return null;
    }

    public static NonPvpZone getNonPvpZone(int n, int n2) {
        for (int i = 0; i < nonPvpZoneList.size(); ++i) {
            NonPvpZone nonPvpZone = nonPvpZoneList.get(i);
            if (n < nonPvpZone.getX() || n >= nonPvpZone.getX2() || n2 < nonPvpZone.getY() || n2 >= nonPvpZone.getY2()) continue;
            return nonPvpZone;
        }
        return null;
    }

    public static ArrayList<NonPvpZone> getAllZones() {
        return nonPvpZoneList;
    }

    public void syncNonPvpZone(boolean bl) {
        if (GameClient.bClient) {
            GameClient.sendNonPvpZone(this, bl);
        }
    }

    public void save(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.getX());
        byteBuffer.putInt(this.getY());
        byteBuffer.putInt(this.getX2());
        byteBuffer.putInt(this.getY2());
        byteBuffer.putInt(this.getSize());
        GameWindow.WriteString(byteBuffer, this.getTitle());
    }

    public void load(ByteBuffer byteBuffer, int n) {
        this.setX(byteBuffer.getInt());
        this.setY(byteBuffer.getInt());
        this.setX2(byteBuffer.getInt());
        this.setY2(byteBuffer.getInt());
        this.setSize(byteBuffer.getInt());
        this.setTitle(GameWindow.ReadString(byteBuffer));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int n) {
        this.x = n;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int n) {
        this.y = n;
    }

    public int getX2() {
        return this.x2;
    }

    public void setX2(int n) {
        this.x2 = n;
    }

    public int getY2() {
        return this.y2;
    }

    public void setY2(int n) {
        this.y2 = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        this.size = n;
    }
}

