/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso.areas;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.core.Rand;
import zombie.core.opengl.RenderSettings;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemType;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.LotHeader;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.areas.BuildingScore;
import zombie.iso.areas.IsoArea;
import zombie.iso.areas.IsoRoom;
import zombie.iso.areas.IsoRoomExit;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoWindow;

public final class IsoBuilding
extends IsoArea {
    public Rectangle bounds;
    public final Vector<IsoRoomExit> Exits = new Vector();
    public boolean IsResidence = true;
    public final ArrayList<ItemContainer> container = new ArrayList();
    public final Vector<IsoRoom> Rooms = new Vector();
    public final Vector<IsoWindow> Windows = new Vector();
    public int ID = 0;
    public static int IDMax = 0;
    public int safety = 0;
    public int transparentWalls = 0;
    private boolean isToxic = false;
    public static float PoorBuildingScore = 10.0f;
    public static float GoodBuildingScore = 100.0f;
    public int scoreUpdate = -1;
    public BuildingDef def;
    public boolean bSeenInside = false;
    public ArrayList<IsoLightSource> lights = new ArrayList();
    static ArrayList<IsoRoom> tempo = new ArrayList();
    static ArrayList<ItemContainer> tempContainer = new ArrayList();
    static ArrayList<String> RandomContainerChoices = new ArrayList();
    static ArrayList<IsoWindow> windowchoices = new ArrayList();

    public int getRoomsNumber() {
        return this.Rooms.size();
    }

    public IsoBuilding() {
        this.ID = IDMax++;
        this.scoreUpdate = -120 + Rand.Next(120);
    }

    public int getID() {
        return this.ID;
    }

    public void TriggerAlarm() {
    }

    public IsoBuilding(IsoCell isoCell) {
        this.ID = IDMax++;
        this.scoreUpdate = -120 + Rand.Next(120);
    }

    public boolean ContainsAllItems(Stack<String> stack) {
        return false;
    }

    public float ScoreBuildingPersonSpecific(SurvivorDesc survivorDesc, boolean bl) {
        float f;
        float f2 = 0.0f;
        f2 += (float)(this.Rooms.size() * 5);
        f2 += (float)(this.Exits.size() * 15);
        f2 -= (float)(this.transparentWalls * 10);
        for (int i = 0; i < this.container.size(); ++i) {
            ItemContainer itemContainer = this.container.get(i);
            f2 += (float)(itemContainer.Items.size() * 3);
        }
        if (!IsoWorld.instance.CurrentCell.getBuildingScores().containsKey(this.ID)) {
            BuildingScore buildingScore = new BuildingScore(this);
            buildingScore.building = this;
            IsoWorld.instance.CurrentCell.getBuildingScores().put(this.ID, buildingScore);
            this.ScoreBuildingGeneral(buildingScore);
        }
        BuildingScore buildingScore = IsoWorld.instance.CurrentCell.getBuildingScores().get(this.ID);
        f2 += (buildingScore.defense + buildingScore.food + (float)buildingScore.size + buildingScore.weapons + buildingScore.wood) * 10.0f;
        int n = -10000;
        int n2 = -10000;
        if (!this.Exits.isEmpty()) {
            IsoRoomExit isoRoomExit = this.Exits.get(0);
            n = isoRoomExit.x;
            n2 = isoRoomExit.y;
        }
        if ((f = IsoUtils.DistanceManhatten(survivorDesc.getInstance().getX(), survivorDesc.getInstance().getY(), n, n2)) > 0.0f) {
            f2 = bl ? (f2 *= f * 0.5f) : (f2 /= f * 0.5f);
        }
        return f2;
    }

    public BuildingDef getDef() {
        return this.def;
    }

    public void update() {
        if (this.Exits.isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.Rooms.size(); ++i) {
            IsoRoom isoRoom = this.Rooms.get(i);
            if (isoRoom.layer != 0) continue;
            for (int j = 0; j < isoRoom.TileList.size(); ++j) {
                ++n2;
                IsoGridSquare isoGridSquare = isoRoom.TileList.get(j);
            }
        }
        if (n2 == 0) {
            ++n2;
        }
        n = (int)((float)n / (float)n2);
        --this.scoreUpdate;
        if (this.scoreUpdate <= 0) {
            this.scoreUpdate += 120;
            BuildingScore buildingScore = null;
            if (IsoWorld.instance.CurrentCell.getBuildingScores().containsKey(this.ID)) {
                buildingScore = IsoWorld.instance.CurrentCell.getBuildingScores().get(this.ID);
            } else {
                buildingScore = new BuildingScore(this);
                buildingScore.building = this;
            }
            buildingScore = this.ScoreBuildingGeneral(buildingScore);
            buildingScore.defense += (float)(n * 10);
            this.safety = n;
            IsoWorld.instance.CurrentCell.getBuildingScores().put(this.ID, buildingScore);
        }
    }

    public void AddRoom(IsoRoom isoRoom) {
        this.Rooms.add(isoRoom);
        if (this.bounds == null) {
            this.bounds = (Rectangle)isoRoom.bounds.clone();
        }
        if (isoRoom != null && isoRoom.bounds != null) {
            this.bounds.add(isoRoom.bounds);
        }
    }

    public void CalculateExits() {
        for (IsoRoom isoRoom : this.Rooms) {
            for (IsoRoomExit isoRoomExit : isoRoom.Exits) {
                if (isoRoomExit.To.From != null || isoRoom.layer != 0) continue;
                this.Exits.add(isoRoomExit);
            }
        }
    }

    public void CalculateWindows() {
        for (IsoRoom isoRoom : this.Rooms) {
            for (IsoGridSquare isoGridSquare : isoRoom.TileList) {
                IsoObject isoObject;
                int n;
                IsoGridSquare isoGridSquare2 = isoGridSquare.getCell().getGridSquare(isoGridSquare.getX(), isoGridSquare.getY() + 1, isoGridSquare.getZ());
                IsoGridSquare isoGridSquare3 = isoGridSquare.getCell().getGridSquare(isoGridSquare.getX() + 1, isoGridSquare.getY(), isoGridSquare.getZ());
                if (isoGridSquare.getProperties().Is(IsoFlagType.collideN) && isoGridSquare.getProperties().Is(IsoFlagType.transparentN)) {
                    ++isoRoom.transparentWalls;
                    ++this.transparentWalls;
                }
                if (isoGridSquare.getProperties().Is(IsoFlagType.collideW) && isoGridSquare.getProperties().Is(IsoFlagType.transparentW)) {
                    ++isoRoom.transparentWalls;
                    ++this.transparentWalls;
                }
                if (isoGridSquare2 != null) {
                    int n2 = n = isoGridSquare2.getRoom() != null ? 1 : 0;
                    if (isoGridSquare2.getRoom() != null && isoGridSquare2.getRoom().building != isoRoom.building) {
                        n = 0;
                    }
                    if (isoGridSquare2.getProperties().Is(IsoFlagType.collideN) && isoGridSquare2.getProperties().Is(IsoFlagType.transparentN) && n == 0) {
                        ++isoRoom.transparentWalls;
                        ++this.transparentWalls;
                    }
                }
                if (isoGridSquare3 != null) {
                    int n3 = n = isoGridSquare3.getRoom() != null ? 1 : 0;
                    if (isoGridSquare3.getRoom() != null && isoGridSquare3.getRoom().building != isoRoom.building) {
                        n = 0;
                    }
                    if (isoGridSquare3.getProperties().Is(IsoFlagType.collideW) && isoGridSquare3.getProperties().Is(IsoFlagType.transparentW) && n == 0) {
                        ++isoRoom.transparentWalls;
                        ++this.transparentWalls;
                    }
                }
                for (n = 0; n < isoGridSquare.getSpecialObjects().size(); ++n) {
                    isoObject = isoGridSquare.getSpecialObjects().get(n);
                    if (!(isoObject instanceof IsoWindow)) continue;
                    this.Windows.add((IsoWindow)isoObject);
                }
                if (isoGridSquare2 != null) {
                    for (n = 0; n < isoGridSquare2.getSpecialObjects().size(); ++n) {
                        isoObject = isoGridSquare2.getSpecialObjects().get(n);
                        if (!(isoObject instanceof IsoWindow)) continue;
                        this.Windows.add((IsoWindow)isoObject);
                    }
                }
                if (isoGridSquare3 == null) continue;
                for (n = 0; n < isoGridSquare3.getSpecialObjects().size(); ++n) {
                    isoObject = isoGridSquare3.getSpecialObjects().get(n);
                    if (!(isoObject instanceof IsoWindow)) continue;
                    this.Windows.add((IsoWindow)isoObject);
                }
            }
        }
    }

    public void FillContainers() {
        boolean bl = false;
        for (IsoRoom isoRoom : this.Rooms) {
            Object object;
            if (isoRoom.RoomDef != null && isoRoom.RoomDef.contains("tutorial")) {
                bl = true;
            }
            if (!isoRoom.TileList.isEmpty() && ((IsoGridSquare)(object = isoRoom.TileList.get(0))).getX() < 74 && ((IsoGridSquare)object).getY() < 32) {
                bl = true;
            }
            if (isoRoom.RoomDef.contains("shop")) {
                this.IsResidence = false;
            }
            object = isoRoom.TileList.iterator();
            while (object.hasNext()) {
                IsoGridSquare isoGridSquare = (IsoGridSquare)object.next();
                for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                    IsoObject isoObject = isoGridSquare.getObjects().get(i);
                    if (isoObject.hasWater()) {
                        isoRoom.getWaterSources().add(isoObject);
                    }
                    if (isoObject.container == null) continue;
                    this.container.add(isoObject.container);
                    isoRoom.Containers.add(isoObject.container);
                }
                if (!isoGridSquare.getProperties().Is(IsoFlagType.bed)) continue;
                isoRoom.Beds.add(isoGridSquare);
            }
        }
    }

    public ItemContainer getContainerWith(ItemType itemType) {
        for (IsoRoom isoRoom : this.Rooms) {
            for (ItemContainer itemContainer : isoRoom.Containers) {
                if (!itemContainer.HasType(itemType)) continue;
                return itemContainer;
            }
        }
        return null;
    }

    public IsoRoom getRandomRoom() {
        if (this.Rooms.size() == 0) {
            return null;
        }
        IsoRoom isoRoom = this.Rooms.get(Rand.Next(this.Rooms.size()));
        return isoRoom;
    }

    private BuildingScore ScoreBuildingGeneral(BuildingScore buildingScore) {
        buildingScore.food = 0.0f;
        buildingScore.defense = 0.0f;
        buildingScore.weapons = 0.0f;
        buildingScore.wood = 0.0f;
        buildingScore.building = this;
        buildingScore.size = 0;
        buildingScore.defense += (float)((this.Exits.size() - 1) * 140);
        buildingScore.defense -= (float)(this.transparentWalls * 40);
        buildingScore.size = this.Rooms.size() * 10;
        buildingScore.size += this.container.size() * 10;
        return buildingScore;
    }

    public IsoGridSquare getFreeTile() {
        IsoRoom isoRoom;
        IsoGridSquare isoGridSquare = null;
        while ((isoGridSquare = (isoRoom = this.Rooms.get(Rand.Next(this.Rooms.size()))).getFreeTile()) == null) {
        }
        return isoGridSquare;
    }

    public boolean hasWater() {
        Iterator<IsoRoom> iterator = this.Rooms.iterator();
        while (iterator != null && iterator.hasNext()) {
            IsoRoom isoRoom = iterator.next();
            if (isoRoom.WaterSources.isEmpty()) continue;
            IsoObject isoObject = null;
            for (int i = 0; i < isoRoom.WaterSources.size(); ++i) {
                if (!isoRoom.WaterSources.get(i).hasWater()) continue;
                isoObject = isoRoom.WaterSources.get(i);
                break;
            }
            if (isoObject == null) continue;
            return true;
        }
        return false;
    }

    public void CreateFrom(BuildingDef buildingDef, LotHeader lotHeader) {
        for (int i = 0; i < buildingDef.rooms.size(); ++i) {
            IsoRoom isoRoom = lotHeader.getRoom(buildingDef.rooms.get((int)i).ID);
            isoRoom.building = this;
            this.Rooms.add(isoRoom);
        }
    }

    public void setAllExplored(boolean bl) {
        this.def.bAlarmed = false;
        for (int i = 0; i < this.Rooms.size(); ++i) {
            IsoRoom isoRoom = this.Rooms.get(i);
            isoRoom.def.setExplored(bl);
            for (int j = isoRoom.def.getX(); j <= isoRoom.def.getX2(); ++j) {
                for (int k = isoRoom.def.getY(); k <= isoRoom.def.getY2(); ++k) {
                    IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, k, isoRoom.def.level);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.setHourSeenToCurrent();
                }
            }
        }
    }

    public boolean isAllExplored() {
        for (int i = 0; i < this.Rooms.size(); ++i) {
            IsoRoom isoRoom = this.Rooms.get(i);
            if (isoRoom.def.bExplored) continue;
            return false;
        }
        return true;
    }

    public void addWindow(IsoWindow isoWindow, boolean bl, IsoGridSquare isoGridSquare, IsoBuilding isoBuilding) {
        this.Windows.add(isoWindow);
        IsoGridSquare isoGridSquare2 = null;
        isoGridSquare2 = bl ? isoWindow.square : isoGridSquare;
        if (isoGridSquare2 == null) {
            return;
        }
        if (isoGridSquare2.getRoom() != null) {
            return;
        }
        float f = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        float f2 = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        float f3 = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        int n = 7;
        IsoLightSource isoLightSource = new IsoLightSource(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ(), f, f2, f3, n, isoBuilding);
        this.lights.add(isoLightSource);
        IsoWorld.instance.CurrentCell.getLamppostPositions().add(isoLightSource);
    }

    public void addWindow(IsoWindow isoWindow, boolean bl) {
        this.addWindow(isoWindow, bl, isoWindow.square, null);
    }

    public void addDoor(IsoDoor isoDoor, boolean bl, IsoGridSquare isoGridSquare, IsoBuilding isoBuilding) {
        IsoGridSquare isoGridSquare2 = null;
        isoGridSquare2 = bl ? isoDoor.square : isoGridSquare;
        if (isoGridSquare2 == null) {
            return;
        }
        if (isoGridSquare2.getRoom() != null) {
            return;
        }
        float f = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        float f2 = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        float f3 = RenderSettings.getInstance().getAmbientForPlayer(IsoPlayer.getPlayerIndex()) * 0.7f;
        int n = 7;
        IsoLightSource isoLightSource = new IsoLightSource(isoGridSquare2.getX(), isoGridSquare2.getY(), isoGridSquare2.getZ(), f, f2, f3, n, isoBuilding);
        this.lights.add(isoLightSource);
        IsoWorld.instance.CurrentCell.getLamppostPositions().add(isoLightSource);
    }

    public void addDoor(IsoDoor isoDoor, boolean bl) {
        this.addDoor(isoDoor, bl, isoDoor.square, null);
    }

    public boolean isResidential() {
        return this.containsRoom("bedroom");
    }

    public boolean containsRoom(String string) {
        for (int i = 0; i < this.Rooms.size(); ++i) {
            if (!string.equals(this.Rooms.get(i).getName())) continue;
            return true;
        }
        return false;
    }

    public IsoRoom getRandomRoom(String string) {
        tempo.clear();
        for (int i = 0; i < this.Rooms.size(); ++i) {
            if (!string.equals(this.Rooms.get(i).getName())) continue;
            tempo.add(this.Rooms.get(i));
        }
        if (tempo.isEmpty()) {
            return null;
        }
        return tempo.get(Rand.Next(tempo.size()));
    }

    public ItemContainer getRandomContainer(String string) {
        int n;
        RandomContainerChoices.clear();
        String[] stringArray = null;
        if (string != null) {
            stringArray = string.split(",");
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                RandomContainerChoices.add(stringArray[n]);
            }
        }
        tempContainer.clear();
        for (n = 0; n < this.Rooms.size(); ++n) {
            IsoRoom isoRoom = this.Rooms.get(n);
            for (int i = 0; i < isoRoom.Containers.size(); ++i) {
                ItemContainer itemContainer = isoRoom.Containers.get(i);
                if (string != null && !RandomContainerChoices.contains(itemContainer.getType())) continue;
                tempContainer.add(itemContainer);
            }
        }
        if (tempContainer.isEmpty()) {
            return null;
        }
        return tempContainer.get(Rand.Next(tempContainer.size()));
    }

    public IsoWindow getRandomFirstFloorWindow() {
        windowchoices.clear();
        windowchoices.addAll(this.Windows);
        for (int i = 0; i < windowchoices.size(); ++i) {
            if (!(windowchoices.get(i).getZ() > 0.0f)) continue;
            windowchoices.remove(i);
        }
        if (!windowchoices.isEmpty()) {
            return windowchoices.get(Rand.Next(windowchoices.size()));
        }
        return null;
    }

    public boolean isToxic() {
        return this.isToxic;
    }

    public void setToxic(boolean bl) {
        this.isToxic = bl;
    }

    public void forceAwake() {
        for (int i = this.def.getX(); i <= this.def.getX2(); ++i) {
            for (int j = this.def.getY(); j <= this.def.getY2(); ++j) {
                for (int k = 0; k <= 4; ++k) {
                    IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(i, j, k);
                    if (isoGridSquare == null) continue;
                    for (int i2 = 0; i2 < isoGridSquare.getMovingObjects().size(); ++i2) {
                        if (!(isoGridSquare.getMovingObjects().get(i2) instanceof IsoGameCharacter)) continue;
                        ((IsoGameCharacter)isoGridSquare.getMovingObjects().get(i2)).forceAwake();
                    }
                }
            }
        }
    }
}

