/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.awt.Dimension;
import java.awt.Point;
import zombie.core.math.PZMath;

public final class Vector2
implements Cloneable {
    public float x;
    public float y;

    public Vector2() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2(Vector2 vector22) {
        this.x = vector22.x;
        this.y = vector22.y;
    }

    public Vector2(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public static Vector2 fromAwtPoint(Point point) {
        return new Vector2(point.x, point.y);
    }

    public static Vector2 fromLengthDirection(float f, float f2) {
        Vector2 vector22 = new Vector2();
        vector22.setLengthAndDirection(f2, f);
        return vector22;
    }

    public static float dot(float f, float f2, float f3, float f4) {
        return f * f3 + f2 * f4;
    }

    public static Vector2 addScaled(Vector2 vector22, Vector2 vector23, float f, Vector2 vector24) {
        vector24.set(vector22.x + vector23.x * f, vector22.y + vector23.y * f);
        return vector24;
    }

    public void rotate(float f) {
        double d = (double)this.x * Math.cos(f) - (double)this.y * Math.sin(f);
        double d2 = (double)this.x * Math.sin(f) + (double)this.y * Math.cos(f);
        this.x = (float)d;
        this.y = (float)d2;
    }

    public Vector2 add(Vector2 vector22) {
        this.x += vector22.x;
        this.y += vector22.y;
        return this;
    }

    public Vector2 aimAt(Vector2 vector22) {
        this.setLengthAndDirection(this.angleTo(vector22), this.getLength());
        return this;
    }

    public float angleTo(Vector2 vector22) {
        return (float)Math.atan2(vector22.y - this.y, vector22.x - this.x);
    }

    public float angleBetween(Vector2 vector22) {
        float f = this.dot(vector22) / (this.getLength() * vector22.getLength());
        if (f < -1.0f) {
            f = -1.0f;
        }
        if (f > 1.0f) {
            f = 1.0f;
        }
        return (float)Math.acos(f);
    }

    public Vector2 clone() {
        return new Vector2(this);
    }

    public float distanceTo(Vector2 vector22) {
        return (float)Math.sqrt(Math.pow(vector22.x - this.x, 2.0) + Math.pow(vector22.y - this.y, 2.0));
    }

    public float dot(Vector2 vector22) {
        return this.x * vector22.x + this.y * vector22.y;
    }

    public boolean equals(Object object) {
        if (object instanceof Vector2) {
            Vector2 vector22 = (Vector2)object;
            return vector22.x == this.x && vector22.y == this.y;
        }
        return false;
    }

    public float getDirection() {
        float f = (float)Math.atan2(this.y, this.x);
        float f2 = PZMath.wrap(f, (float)(-Math.PI), (float)Math.PI);
        return f2;
    }

    public static float getDirection(float f, float f2) {
        float f3 = (float)Math.atan2(f2, f);
        float f4 = PZMath.wrap(f3, (float)(-Math.PI), (float)Math.PI);
        return f4;
    }

    @Deprecated
    public float getDirectionNeg() {
        return (float)Math.atan2(this.x, this.y);
    }

    public Vector2 setDirection(float f) {
        this.setLengthAndDirection(f, this.getLength());
        return this;
    }

    public float getLength() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public float getLengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public Vector2 setLength(float f) {
        this.normalize();
        this.x *= f;
        this.y *= f;
        return this;
    }

    public float normalize() {
        float f = this.getLength();
        if (f == 0.0f) {
            this.x = 0.0f;
            this.y = 0.0f;
        } else {
            this.x /= f;
            this.y /= f;
        }
        return f;
    }

    public Vector2 set(Vector2 vector22) {
        this.x = vector22.x;
        this.y = vector22.y;
        return this;
    }

    public Vector2 set(float f, float f2) {
        this.x = f;
        this.y = f2;
        return this;
    }

    public Vector2 setLengthAndDirection(float f, float f2) {
        this.x = (float)(Math.cos(f) * (double)f2);
        this.y = (float)(Math.sin(f) * (double)f2);
        return this;
    }

    public Dimension toAwtDimension() {
        return new Dimension((int)this.x, (int)this.y);
    }

    public Point toAwtPoint() {
        return new Point((int)this.x, (int)this.y);
    }

    public String toString() {
        return String.format("Vector2 (X: %f, Y: %f) (L: %f, D:%f)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.getLength()), Float.valueOf(this.getDirection()));
    }

    public float getX() {
        return this.x;
    }

    public void setX(float f) {
        this.x = f;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float f) {
        this.y = f;
    }

    public void tangent() {
        double d = (double)this.x * Math.cos(Math.toRadians(90.0)) - (double)this.y * Math.sin(Math.toRadians(90.0));
        double d2 = (double)this.x * Math.sin(Math.toRadians(90.0)) + (double)this.y * Math.cos(Math.toRadians(90.0));
        this.x = (float)d;
        this.y = (float)d2;
    }

    public void scale(float f) {
        Vector2.scale(this, f);
    }

    public static Vector2 scale(Vector2 vector22, float f) {
        vector22.x *= f;
        vector22.y *= f;
        return vector22;
    }
}

