/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;

public class SearchMode {
    private static SearchMode instance;
    private float fadeTime = 1.0f;
    private PlayerSearchMode[] plrModes = new PlayerSearchMode[4];

    public static SearchMode getInstance() {
        if (instance == null) {
            instance = new SearchMode();
        }
        return instance;
    }

    private SearchMode() {
        for (int i = 0; i < this.plrModes.length; ++i) {
            this.plrModes[i] = new PlayerSearchMode(i, this);
            this.plrModes[i].blur.setTargets(1.0f, 1.0f);
            this.plrModes[i].desat.setTargets(0.85f, 0.85f);
            this.plrModes[i].radius.setTargets(4.0f, 4.0f);
            this.plrModes[i].darkness.setTargets(0.0f, 0.0f);
            this.plrModes[i].gradientWidth.setTargets(4.0f, 4.0f);
        }
    }

    public PlayerSearchMode getSearchModeForPlayer(int n) {
        return this.plrModes[n];
    }

    public float getFadeTime() {
        return this.fadeTime;
    }

    public void setFadeTime(float f) {
        this.fadeTime = f;
    }

    public boolean isOverride(int n) {
        return this.plrModes[n].override;
    }

    public void setOverride(int n, boolean bl) {
        this.plrModes[n].override = bl;
    }

    public SearchModeFloat getRadius(int n) {
        return this.plrModes[n].radius;
    }

    public SearchModeFloat getGradientWidth(int n) {
        return this.plrModes[n].gradientWidth;
    }

    public SearchModeFloat getBlur(int n) {
        return this.plrModes[n].blur;
    }

    public SearchModeFloat getDesat(int n) {
        return this.plrModes[n].desat;
    }

    public SearchModeFloat getDarkness(int n) {
        return this.plrModes[n].darkness;
    }

    public boolean isEnabled(int n) {
        return this.plrModes[n].enabled;
    }

    public void setEnabled(int n, boolean bl) {
        PlayerSearchMode playerSearchMode = this.plrModes[n];
        if (bl && !playerSearchMode.enabled) {
            playerSearchMode.enabled = true;
            this.FadeIn(n);
        } else if (!bl && playerSearchMode.enabled) {
            playerSearchMode.enabled = false;
            this.FadeOut(n);
        }
    }

    private void FadeIn(int n) {
        PlayerSearchMode playerSearchMode = this.plrModes[n];
        playerSearchMode.timer = Math.max(playerSearchMode.timer, 0.0f);
        playerSearchMode.doFadeIn = true;
        playerSearchMode.doFadeOut = false;
    }

    private void FadeOut(int n) {
        PlayerSearchMode playerSearchMode = this.plrModes[n];
        playerSearchMode.timer = Math.min(playerSearchMode.timer, this.fadeTime);
        playerSearchMode.doFadeIn = false;
        playerSearchMode.doFadeOut = true;
    }

    public void update() {
        for (int i = 0; i < this.plrModes.length; ++i) {
            PlayerSearchMode playerSearchMode = this.plrModes[i];
            playerSearchMode.update();
        }
    }

    public static void reset() {
        instance = null;
    }

    public static class PlayerSearchMode {
        private final int plrIndex;
        private final SearchMode parent;
        private boolean override = false;
        private boolean enabled = false;
        private final SearchModeFloat radius = new SearchModeFloat(0.0f, 50.0f, 1.0f);
        private final SearchModeFloat gradientWidth = new SearchModeFloat(0.0f, 20.0f, 1.0f);
        private final SearchModeFloat blur = new SearchModeFloat(0.0f, 1.0f, 0.01f);
        private final SearchModeFloat desat = new SearchModeFloat(0.0f, 1.0f, 0.01f);
        private final SearchModeFloat darkness = new SearchModeFloat(0.0f, 1.0f, 0.01f);
        private float timer;
        private boolean doFadeOut;
        private boolean doFadeIn;

        public PlayerSearchMode(int n, SearchMode searchMode) {
            this.plrIndex = n;
            this.parent = searchMode;
        }

        public boolean isShaderEnabled() {
            return this.enabled || this.doFadeIn || this.doFadeOut;
        }

        private boolean isPlayerExterior() {
            IsoPlayer isoPlayer = IsoPlayer.players[this.plrIndex];
            return isoPlayer != null && isoPlayer.getCurrentSquare() != null && !isoPlayer.getCurrentSquare().isInARoom();
        }

        public float getShaderBlur() {
            return this.isPlayerExterior() ? this.blur.getExterior() : this.blur.getInterior();
        }

        public float getShaderDesat() {
            return this.isPlayerExterior() ? this.desat.getExterior() : this.desat.getInterior();
        }

        public float getShaderRadius() {
            return this.isPlayerExterior() ? this.radius.getExterior() : this.radius.getInterior();
        }

        public float getShaderGradientWidth() {
            return this.isPlayerExterior() ? this.gradientWidth.getExterior() : this.gradientWidth.getInterior();
        }

        public float getShaderDarkness() {
            return this.isPlayerExterior() ? this.darkness.getExterior() : this.darkness.getInterior();
        }

        public SearchModeFloat getBlur() {
            return this.blur;
        }

        public SearchModeFloat getDesat() {
            return this.desat;
        }

        public SearchModeFloat getRadius() {
            return this.radius;
        }

        public SearchModeFloat getGradientWidth() {
            return this.gradientWidth;
        }

        public SearchModeFloat getDarkness() {
            return this.darkness;
        }

        private void update() {
            if (this.override) {
                return;
            }
            if (this.doFadeIn) {
                this.timer += GameTime.getInstance().getTimeDelta();
                this.timer = PZMath.clamp(this.timer, 0.0f, this.parent.fadeTime);
                float f = PZMath.clamp(this.timer / this.parent.fadeTime, 0.0f, 1.0f);
                this.blur.update(f);
                this.desat.update(f);
                this.radius.update(f);
                this.darkness.update(f);
                this.gradientWidth.equalise();
                if (this.timer >= this.parent.fadeTime) {
                    this.doFadeIn = false;
                }
                return;
            }
            if (this.doFadeOut) {
                this.timer -= GameTime.getInstance().getTimeDelta();
                this.timer = PZMath.clamp(this.timer, 0.0f, this.parent.fadeTime);
                float f = PZMath.clamp(this.timer / this.parent.fadeTime, 0.0f, 1.0f);
                this.blur.update(f);
                this.desat.update(f);
                this.radius.update(f);
                this.darkness.update(f);
                this.gradientWidth.equalise();
                if (this.timer <= 0.0f) {
                    this.doFadeOut = false;
                }
                return;
            }
            if (this.enabled) {
                this.blur.equalise();
                this.desat.equalise();
                this.radius.equalise();
                this.darkness.equalise();
                this.gradientWidth.equalise();
            } else {
                this.blur.reset();
                this.desat.reset();
                this.radius.reset();
                this.darkness.reset();
                this.gradientWidth.equalise();
            }
        }
    }

    public static class SearchModeFloat {
        private final float min;
        private final float max;
        private final float stepsize;
        private float exterior;
        private float targetExterior;
        private float interior;
        private float targetInterior;

        private SearchModeFloat(float f, float f2, float f3) {
            this.min = f;
            this.max = f2;
            this.stepsize = f3;
        }

        public void set(float f, float f2, float f3, float f4) {
            this.setExterior(f);
            this.setTargetExterior(f2);
            this.setInterior(f3);
            this.setTargetInterior(f4);
        }

        public void setTargets(float f, float f2) {
            this.setTargetExterior(f);
            this.setTargetInterior(f2);
        }

        public float getExterior() {
            return this.exterior;
        }

        public void setExterior(float f) {
            this.exterior = f;
        }

        public float getTargetExterior() {
            return this.targetExterior;
        }

        public void setTargetExterior(float f) {
            this.targetExterior = f;
        }

        public float getInterior() {
            return this.interior;
        }

        public void setInterior(float f) {
            this.interior = f;
        }

        public float getTargetInterior() {
            return this.targetInterior;
        }

        public void setTargetInterior(float f) {
            this.targetInterior = f;
        }

        public void update(float f) {
            this.exterior = f * this.targetExterior;
            this.interior = f * this.targetInterior;
        }

        public void equalise() {
            this.exterior = !PZMath.equal(this.exterior, this.targetExterior, 0.001f) ? PZMath.lerp(this.exterior, this.targetExterior, 0.01f) : this.targetExterior;
            this.interior = !PZMath.equal(this.interior, this.targetInterior, 0.001f) ? PZMath.lerp(this.interior, this.targetInterior, 0.01f) : this.targetInterior;
        }

        public void reset() {
            this.exterior = 0.0f;
            this.interior = 0.0f;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public float getStepsize() {
            return this.stepsize;
        }
    }
}

