/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.joml.Vector2f;
import zombie.iso.BuildingDef;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.MetaObject;
import zombie.iso.areas.IsoRoom;
import zombie.network.GameServer;
import zombie.network.ServerMap;
import zombie.util.list.PZArrayUtil;

public final class RoomDef {
    private static final ArrayList<IsoGridSquare> squareChoices = new ArrayList();
    public boolean bExplored = false;
    public boolean bDoneSpawn = false;
    public int IndoorZombies = 0;
    public int spawnCount = -1;
    public boolean bLightsActive = false;
    public String name;
    public int level;
    public BuildingDef building;
    public int ID = -1;
    public final ArrayList<RoomRect> rects = new ArrayList(1);
    public final ArrayList<MetaObject> objects = new ArrayList(0);
    public int x = 100000;
    public int y = 100000;
    public int x2 = -10000;
    public int y2 = -10000;
    public int area;
    private final HashMap<String, Integer> proceduralSpawnedContainer = new HashMap();
    private boolean roofFixed = false;
    public long metaID;

    public RoomDef(int n, String string) {
        this.ID = n;
        this.name = string;
    }

    public int getID() {
        return this.ID;
    }

    public boolean isExplored() {
        return this.bExplored;
    }

    public boolean isInside(int n, int n2, int n3) {
        int n4 = this.building.x;
        int n5 = this.building.y;
        for (int i = 0; i < this.rects.size(); ++i) {
            int n6 = this.rects.get((int)i).x;
            int n7 = this.rects.get((int)i).y;
            int n8 = this.rects.get(i).getX2();
            int n9 = this.rects.get(i).getY2();
            if (n < n6 || n2 < n7 || n >= n8 || n2 >= n9 || n3 != this.level) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            if (n + n3 <= roomRect.getX() || n >= roomRect.getX2() || n2 + n4 <= roomRect.getY() || n2 >= roomRect.getY2()) continue;
            return true;
        }
        return false;
    }

    public float getAreaOverlapping(IsoChunk isoChunk) {
        return this.getAreaOverlapping(isoChunk.wx * 10, isoChunk.wy * 10, 10, 10);
    }

    public float getAreaOverlapping(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            n5 += roomRect.w * roomRect.h;
            int n7 = Math.max(n, roomRect.x);
            int n8 = Math.max(n2, roomRect.y);
            int n9 = Math.min(n + n3, roomRect.x + roomRect.w);
            int n10 = Math.min(n2 + n4, roomRect.y + roomRect.h);
            if (n9 < n7 || n10 < n8) continue;
            n6 += (n9 - n7) * (n10 - n8);
        }
        if (n6 <= 0) {
            return 0.0f;
        }
        return (float)n6 / (float)n5;
    }

    public void forEachChunk(BiConsumer<RoomDef, IsoChunk> biConsumer) {
        HashSet<IsoChunk> hashSet = new HashSet<IsoChunk>();
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            int n = roomRect.x / 10;
            int n2 = roomRect.y / 10;
            int n3 = (roomRect.x + roomRect.w) / 10;
            int n4 = (roomRect.y + roomRect.h) / 10;
            if ((roomRect.x + roomRect.w) % 10 == 0) {
                --n3;
            }
            if ((roomRect.y + roomRect.h) % 10 == 0) {
                --n4;
            }
            for (int j = n2; j <= n4; ++j) {
                for (int k = n; k <= n3; ++k) {
                    IsoChunk isoChunk2;
                    IsoChunk isoChunk3 = isoChunk2 = GameServer.bServer ? ServerMap.instance.getChunk(k, j) : IsoWorld.instance.CurrentCell.getChunk(k, j);
                    if (isoChunk2 == null) continue;
                    hashSet.add(isoChunk2);
                }
            }
        }
        hashSet.forEach(isoChunk -> biConsumer.accept(this, (IsoChunk)isoChunk));
        hashSet.clear();
    }

    public IsoRoom getIsoRoom() {
        return IsoWorld.instance.MetaGrid.getMetaGridFromTile((int)this.x, (int)this.y).info.getRoom(this.ID);
    }

    public ArrayList<MetaObject> getObjects() {
        return this.objects;
    }

    public ArrayList<MetaObject> getMetaObjects() {
        return this.objects;
    }

    public void refreshSquares() {
        this.getIsoRoom().refreshSquares();
    }

    public BuildingDef getBuilding() {
        return this.building;
    }

    public void setBuilding(BuildingDef buildingDef) {
        this.building = buildingDef;
    }

    public String getName() {
        return this.name;
    }

    public ArrayList<RoomRect> getRects() {
        return this.rects;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public int getW() {
        return this.x2 - this.x;
    }

    public int getH() {
        return this.y2 - this.y;
    }

    public int getZ() {
        return this.level;
    }

    public void CalculateBounds() {
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            if (roomRect.x < this.x) {
                this.x = roomRect.x;
            }
            if (roomRect.y < this.y) {
                this.y = roomRect.y;
            }
            if (roomRect.x + roomRect.w > this.x2) {
                this.x2 = roomRect.x + roomRect.w;
            }
            if (roomRect.y + roomRect.h > this.y2) {
                this.y2 = roomRect.y + roomRect.h;
            }
            this.area += roomRect.w * roomRect.h;
        }
    }

    public long calculateMetaID(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            if (roomRect.x > n3 || roomRect.y >= n4) continue;
            n3 = roomRect.x;
            n4 = roomRect.y;
        }
        return (long)this.level << 32 | (long)(n4 -= n2 * 300) << 16 | (long)(n3 -= n * 300);
    }

    public int getArea() {
        return this.area;
    }

    public void setExplored(boolean bl) {
        this.bExplored = bl;
    }

    public IsoGridSquare getFreeSquare() {
        return this.getRandomSquare(isoGridSquare -> isoGridSquare.isFree(false));
    }

    public IsoGridSquare getRandomSquare(Predicate<IsoGridSquare> predicate) {
        squareChoices.clear();
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            for (int j = roomRect.getX(); j < roomRect.getX2(); ++j) {
                for (int k = roomRect.getY(); k < roomRect.getY2(); ++k) {
                    IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(j, k, this.getZ());
                    if ((isoGridSquare == null || predicate == null || !predicate.test(isoGridSquare)) && predicate != null) continue;
                    squareChoices.add(isoGridSquare);
                }
            }
        }
        return PZArrayUtil.pickRandom(squareChoices);
    }

    public boolean isEmptyOutside() {
        return "emptyoutside".equalsIgnoreCase(this.name);
    }

    public HashMap<String, Integer> getProceduralSpawnedContainer() {
        return this.proceduralSpawnedContainer;
    }

    public boolean isRoofFixed() {
        return this.roofFixed;
    }

    public void setRoofFixed(boolean bl) {
        this.roofFixed = bl;
    }

    public float getClosestPoint(float f, float f2, Vector2f vector2f) {
        float f3 = Float.MAX_VALUE;
        Vector2f vector2f2 = new Vector2f();
        for (int i = 0; i < this.rects.size(); ++i) {
            RoomRect roomRect = this.rects.get(i);
            float f4 = roomRect.getClosestPoint(f, f2, vector2f2);
            if (!(f4 < f3)) continue;
            f3 = f4;
            vector2f.set(vector2f2);
        }
        return f3;
    }

    public void Dispose() {
        this.building = null;
        this.rects.clear();
        this.objects.clear();
        this.proceduralSpawnedContainer.clear();
    }

    public static class RoomRect {
        public int x;
        public int y;
        public int w;
        public int h;

        public RoomRect(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.w = n3;
            this.h = n4;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getX2() {
            return this.x + this.w;
        }

        public int getY2() {
            return this.y + this.h;
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public float getClosestPoint(float f, float f2, Vector2f vector2f) {
            float f3 = Float.MAX_VALUE;
            f3 = this.getClosestPointOnEdge((float)this.x + 0.5f, (float)this.y + 0.5f, (float)(this.x + this.w) - 0.5f, (float)this.y + 0.5f, f, f2, f3, vector2f);
            f3 = this.getClosestPointOnEdge((float)(this.x + this.w) - 0.5f, (float)this.y + 0.5f, (float)(this.x + this.w) - 0.5f, (float)(this.y + this.h) - 0.5f, f, f2, f3, vector2f);
            f3 = this.getClosestPointOnEdge((float)(this.x + this.w) - 0.5f, (float)(this.y + this.h) - 0.5f, (float)this.x + 0.5f, (float)(this.y + this.h) - 0.5f, f, f2, f3, vector2f);
            f3 = this.getClosestPointOnEdge((float)this.x + 0.5f, (float)(this.y + this.h) - 0.5f, (float)this.x + 0.5f, (float)this.y + 0.5f, f, f2, f3, vector2f);
            return f3;
        }

        private float getClosestPointOnEdge(float f, float f2, float f3, float f4, float f5, float f6, float f7, Vector2f vector2f) {
            double d = (double)((f5 - f) * (f3 - f) + (f6 - f2) * (f4 - f2)) / (Math.pow(f3 - f, 2.0) + Math.pow(f4 - f2, 2.0));
            double d2 = (double)f + d * (double)(f3 - f);
            double d3 = (double)f2 + d * (double)(f4 - f2);
            if (d <= 0.0) {
                d2 = f;
                d3 = f2;
            } else if (d >= 1.0) {
                d2 = f3;
                d3 = f4;
            }
            double d4 = ((double)f5 - d2) * ((double)f5 - d2) + ((double)f6 - d3) * ((double)f6 - d3);
            if (d4 < (double)f7) {
                if (f == f3) {
                    d3 = (float)((int)d3) + 0.5f;
                } else {
                    d2 = (float)((int)d2) + 0.5f;
                }
                vector2f.set(d2, d3);
                return (float)d4;
            }
            return f7;
        }
    }
}

