/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.joml.Vector3f;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.math.PZMath;
import zombie.input.GameKeyboard;
import zombie.input.JoypadManager;
import zombie.input.Mouse;
import zombie.iso.IsoCamera;
import zombie.iso.IsoUtils;
import zombie.iso.Vector2;
import zombie.iso.sprite.IsoSprite;
import zombie.network.GameServer;
import zombie.ui.UIManager;
import zombie.vehicles.BaseVehicle;

public final class PlayerCamera {
    public final int playerIndex;
    public float OffX;
    public float OffY;
    public float TOffX;
    public float TOffY;
    public float lastOffX;
    public float lastOffY;
    public float RightClickTargetX;
    public float RightClickTargetY;
    public float RightClickX;
    public float RightClickY;
    private float RightClickX_f;
    private float RightClickY_f;
    public float DeferedX;
    public float DeferedY;
    public float zoom;
    public int OffscreenWidth;
    public int OffscreenHeight;
    private static final Vector2 offVec = new Vector2();
    private static float PAN_SPEED = 1.0f;
    private long panTime = -1L;
    private final Vector3f m_lastVehicleForwardDirection = new Vector3f();

    public PlayerCamera(int n) {
        this.playerIndex = n;
    }

    public void center() {
        float f = this.OffX;
        float f2 = this.OffY;
        if (IsoCamera.CamCharacter != null) {
            IsoGameCharacter isoGameCharacter = IsoCamera.CamCharacter;
            f = IsoUtils.XToScreen(isoGameCharacter.x + this.DeferedX, isoGameCharacter.y + this.DeferedY, isoGameCharacter.z, 0);
            f2 = IsoUtils.YToScreen(isoGameCharacter.x + this.DeferedX, isoGameCharacter.y + this.DeferedY, isoGameCharacter.z, 0);
            f -= (float)(IsoCamera.getOffscreenWidth(this.playerIndex) / 2);
            f2 -= (float)(IsoCamera.getOffscreenHeight(this.playerIndex) / 2);
            f2 -= isoGameCharacter.getOffsetY() * 1.5f;
            f += (float)IsoCamera.PLAYER_OFFSET_X;
            f2 += (float)IsoCamera.PLAYER_OFFSET_Y;
        }
        this.OffX = this.TOffX = f;
        this.OffY = this.TOffY = f2;
    }

    public void update() {
        BaseVehicle baseVehicle;
        this.center();
        float f = (this.TOffX - this.OffX) / 15.0f;
        float f2 = (this.TOffY - this.OffY) / 15.0f;
        this.OffX += f;
        this.OffY += f2;
        if (this.lastOffX == 0.0f && this.lastOffY == 0.0f) {
            this.lastOffX = this.OffX;
            this.lastOffY = this.OffY;
        }
        long l = System.currentTimeMillis();
        PAN_SPEED = 110.0f;
        float f3 = this.panTime < 0L ? 1.0f : (float)(l - this.panTime) / 1000.0f * PAN_SPEED;
        f3 = 1.0f / f3;
        this.panTime = l;
        IsoPlayer isoPlayer = IsoPlayer.players[this.playerIndex];
        boolean bl = GameWindow.ActivatedJoyPad != null && isoPlayer != null && isoPlayer.JoypadBind != -1;
        BaseVehicle baseVehicle2 = baseVehicle = isoPlayer == null ? null : isoPlayer.getVehicle();
        if (baseVehicle != null && baseVehicle.getCurrentSpeedKmHour() <= 1.0f) {
            baseVehicle.getForwardVector(this.m_lastVehicleForwardDirection);
        }
        if (Core.getInstance().getOptionPanCameraWhileDriving() && baseVehicle != null && baseVehicle.getCurrentSpeedKmHour() > 1.0f) {
            float f4 = Core.getInstance().getZoom(this.playerIndex);
            float f5 = baseVehicle.getCurrentSpeedKmHour() * BaseVehicle.getFakeSpeedModifier() / 10.0f;
            f5 *= f4;
            Vector3f vector3f = baseVehicle.getForwardVector((Vector3f)BaseVehicle.TL_vector3f_pool.get().alloc());
            float f6 = this.m_lastVehicleForwardDirection.angle(vector3f) * 57.295776f;
            if (f6 > 1.0f) {
                float f7 = f6 / 180.0f / (float)PerformanceSettings.getLockFPS();
                f7 = PZMath.max(f7, 0.1f);
                this.m_lastVehicleForwardDirection.lerp(vector3f, f7, vector3f);
                this.m_lastVehicleForwardDirection.set(vector3f);
            }
            this.RightClickTargetX = (int)IsoUtils.XToScreen(vector3f.x * f5, vector3f.z * f5, isoPlayer.z, 0);
            this.RightClickTargetY = (int)IsoUtils.YToScreen(vector3f.x * f5, vector3f.z * f5, isoPlayer.z, 0);
            BaseVehicle.TL_vector3f_pool.get().release(vector3f);
            boolean bl2 = false;
            boolean bl3 = false;
            int n = IsoCamera.getOffscreenWidth(this.playerIndex);
            int n2 = IsoCamera.getOffscreenHeight(this.playerIndex);
            float f8 = (float)bl2 + (float)n / 2.0f;
            float f9 = (float)bl3 + (float)n2 / 2.0f;
            float f10 = 150.0f * f4;
            this.RightClickTargetX = (float)((int)PZMath.clamp(f8 + this.RightClickTargetX, f10, (float)n - f10)) - f8;
            this.RightClickTargetY = (float)((int)PZMath.clamp(f9 + this.RightClickTargetY, f10, (float)n2 - f10)) - f9;
            if (Math.abs(f5) < 5.0f) {
                float f11 = 1.0f - Math.abs(f5) / 5.0f;
                this.returnToCenter(1.0f / (16.0f * f3 / f11));
            } else {
                f3 /= 0.5f * f4;
                float f12 = IsoUtils.XToScreenExact(isoPlayer.x, isoPlayer.y, isoPlayer.z, 0);
                float f13 = IsoUtils.YToScreenExact(isoPlayer.x, isoPlayer.y, isoPlayer.z, 0);
                if (f12 < f10 / 2.0f || f12 > (float)n - f10 / 2.0f || f13 < f10 / 2.0f || f13 > (float)n2 - f10 / 2.0f) {
                    f3 /= 4.0f;
                }
                this.RightClickX_f = PZMath.step(this.RightClickX_f, this.RightClickTargetX, 1.875f * (float)PZMath.sign(this.RightClickTargetX - this.RightClickX_f) / f3);
                this.RightClickY_f = PZMath.step(this.RightClickY_f, this.RightClickTargetY, 1.875f * (float)PZMath.sign(this.RightClickTargetY - this.RightClickY_f) / f3);
                this.RightClickX = (int)this.RightClickX_f;
                this.RightClickY = (int)this.RightClickY_f;
            }
        } else if (bl && isoPlayer != null) {
            if ((isoPlayer.IsAiming() || isoPlayer.isLookingWhileInVehicle()) && JoypadManager.instance.isRBPressed(isoPlayer.JoypadBind) && !isoPlayer.bJoypadIgnoreAimUntilCentered) {
                this.RightClickTargetX = JoypadManager.instance.getAimingAxisX(isoPlayer.JoypadBind) * 1500.0f;
                this.RightClickTargetY = JoypadManager.instance.getAimingAxisY(isoPlayer.JoypadBind) * 1500.0f;
                this.RightClickX_f = PZMath.step(this.RightClickX_f, this.RightClickTargetX, (this.RightClickTargetX - this.RightClickX_f) / (80.0f * (f3 /= 0.5f * Core.getInstance().getZoom(this.playerIndex))));
                this.RightClickY_f = PZMath.step(this.RightClickY_f, this.RightClickTargetY, (this.RightClickTargetY - this.RightClickY_f) / (80.0f * f3));
                this.RightClickX = (int)this.RightClickX_f;
                this.RightClickY = (int)this.RightClickY_f;
                isoPlayer.dirtyRecalcGridStackTime = 2.0f;
            } else {
                this.returnToCenter(1.0f / (16.0f * f3));
            }
        } else if (this.playerIndex == 0 && isoPlayer != null && !isoPlayer.isBlockMovement() && GameKeyboard.isKeyDown(Core.getInstance().getKey("PanCamera"))) {
            float f14;
            int n = IsoCamera.getScreenWidth(this.playerIndex);
            int n3 = IsoCamera.getScreenHeight(this.playerIndex);
            int n4 = IsoCamera.getScreenLeft(this.playerIndex);
            int n5 = IsoCamera.getScreenTop(this.playerIndex);
            float f15 = (float)Mouse.getXA() - ((float)n4 + (float)n / 2.0f);
            float f16 = (float)Mouse.getYA() - ((float)n5 + (float)n3 / 2.0f);
            if (n > n3) {
                f14 = (float)n3 / (float)n;
                f15 *= f14;
            } else {
                f14 = (float)n / (float)n3;
                f16 *= f14;
            }
            offVec.set(f15, f16);
            offVec.setLength(Math.min(offVec.getLength(), (float)Math.min(n, n3) / 2.0f));
            f15 = PlayerCamera.offVec.x / (f14 *= (float)n / 1366.0f);
            f16 = PlayerCamera.offVec.y / f14;
            this.RightClickTargetX = f15 * 2.0f;
            this.RightClickTargetY = f16 * 2.0f;
            this.RightClickX_f = PZMath.step(this.RightClickX_f, this.RightClickTargetX, (this.RightClickTargetX - this.RightClickX_f) / (80.0f * (f3 /= 0.5f * Core.getInstance().getZoom(this.playerIndex))));
            this.RightClickY_f = PZMath.step(this.RightClickY_f, this.RightClickTargetY, (this.RightClickTargetY - this.RightClickY_f) / (80.0f * f3));
            this.RightClickX = (int)this.RightClickX_f;
            this.RightClickY = (int)this.RightClickY_f;
            isoPlayer.dirtyRecalcGridStackTime = 2.0f;
            IsoSprite.globalOffsetX = -1.0f;
        } else if (this.playerIndex == 0 && Core.getInstance().getOptionPanCameraWhileAiming()) {
            boolean bl4;
            boolean bl5 = !GameServer.bServer;
            boolean bl6 = !UIManager.isMouseOverInventory() && isoPlayer != null && isoPlayer.isAiming();
            boolean bl7 = bl4 = !bl && isoPlayer != null && !isoPlayer.isDead();
            if (bl5 && bl6 && bl4) {
                float f17;
                int n = IsoCamera.getScreenWidth(this.playerIndex);
                int n6 = IsoCamera.getScreenHeight(this.playerIndex);
                int n7 = IsoCamera.getScreenLeft(this.playerIndex);
                int n8 = IsoCamera.getScreenTop(this.playerIndex);
                float f18 = (float)Mouse.getXA() - ((float)n7 + (float)n / 2.0f);
                float f19 = (float)Mouse.getYA() - ((float)n8 + (float)n6 / 2.0f);
                if (n > n6) {
                    f17 = (float)n6 / (float)n;
                    f18 *= f17;
                } else {
                    f17 = (float)n / (float)n6;
                    f19 *= f17;
                }
                f17 *= (float)n / 1366.0f;
                float f20 = (float)Math.min(n, n6) / 6.0f;
                float f21 = (float)Math.min(n, n6) / 2.0f - f20;
                offVec.set(f18, f19);
                if (offVec.getLength() < f21) {
                    f19 = 0.0f;
                    f18 = 0.0f;
                } else {
                    offVec.setLength(Math.min(offVec.getLength(), (float)Math.min(n, n6) / 2.0f) - f21);
                    f18 = PlayerCamera.offVec.x / f17;
                    f19 = PlayerCamera.offVec.y / f17;
                }
                this.RightClickTargetX = f18 * 7.0f;
                this.RightClickTargetY = f19 * 7.0f;
                this.RightClickX_f = PZMath.step(this.RightClickX_f, this.RightClickTargetX, (this.RightClickTargetX - this.RightClickX_f) / (80.0f * (f3 /= 0.5f * Core.getInstance().getZoom(this.playerIndex))));
                this.RightClickY_f = PZMath.step(this.RightClickY_f, this.RightClickTargetY, (this.RightClickTargetY - this.RightClickY_f) / (80.0f * f3));
                this.RightClickX = (int)this.RightClickX_f;
                this.RightClickY = (int)this.RightClickY_f;
                isoPlayer.dirtyRecalcGridStackTime = 2.0f;
            } else {
                this.returnToCenter(1.0f / (16.0f * f3));
            }
            IsoSprite.globalOffsetX = -1.0f;
        } else {
            this.returnToCenter(1.0f / (16.0f * f3));
        }
        this.zoom = Core.getInstance().getZoom(this.playerIndex);
    }

    private void returnToCenter(float f) {
        this.RightClickTargetX = 0.0f;
        this.RightClickTargetY = 0.0f;
        if (this.RightClickTargetX != this.RightClickX || this.RightClickTargetY != this.RightClickY) {
            this.RightClickX_f = PZMath.step(this.RightClickX_f, this.RightClickTargetX, (this.RightClickTargetX - this.RightClickX_f) * f);
            this.RightClickY_f = PZMath.step(this.RightClickY_f, this.RightClickTargetY, (this.RightClickTargetY - this.RightClickY_f) * f);
            this.RightClickX = (int)this.RightClickX_f;
            this.RightClickY = (int)this.RightClickY_f;
            if (Math.abs(this.RightClickTargetX - this.RightClickX_f) < 0.001f) {
                this.RightClickX_f = this.RightClickX = (float)((int)this.RightClickTargetX);
            }
            if (Math.abs(this.RightClickTargetY - this.RightClickY_f) < 0.001f) {
                this.RightClickY_f = this.RightClickY = (float)((int)this.RightClickTargetY);
            }
            IsoPlayer isoPlayer = IsoPlayer.players[this.playerIndex];
            isoPlayer.dirtyRecalcGridStackTime = 2.0f;
        }
    }

    public float getOffX() {
        return (int)(this.OffX + this.RightClickX);
    }

    public float getOffY() {
        return (int)(this.OffY + this.RightClickY);
    }

    public float getTOffX() {
        float f = this.TOffX - this.OffX;
        return (int)(this.OffX + this.RightClickX - f);
    }

    public float getTOffY() {
        float f = this.TOffY - this.OffY;
        return (int)(this.OffY + this.RightClickY - f);
    }

    public float getLastOffX() {
        return (int)(this.lastOffX + this.RightClickX);
    }

    public float getLastOffY() {
        return (int)(this.lastOffY + this.RightClickY);
    }

    public float XToIso(float f, float f2, float f3) {
        f = (int)f;
        f2 = (int)f2;
        float f4 = f + this.getOffX();
        float f5 = f2 + this.getOffY();
        float f6 = (f4 + 2.0f * f5) / (64.0f * (float)Core.TileScale);
        return f6 += 3.0f * f3;
    }

    public float YToIso(float f, float f2, float f3) {
        f = (int)f;
        f2 = (int)f2;
        float f4 = f + this.getOffX();
        float f5 = f2 + this.getOffY();
        float f6 = (f4 - 2.0f * f5) / (-64.0f * (float)Core.TileScale);
        return f6 += 3.0f * f3;
    }

    public float YToScreenExact(float f, float f2, float f3, int n) {
        float f4 = IsoUtils.YToScreen(f, f2, f3, n);
        return f4 -= this.getOffY();
    }

    public float XToScreenExact(float f, float f2, float f3, int n) {
        float f4 = IsoUtils.XToScreen(f, f2, f3, n);
        return f4 -= this.getOffX();
    }

    public void copyFrom(PlayerCamera playerCamera) {
        this.OffX = playerCamera.OffX;
        this.OffY = playerCamera.OffY;
        this.TOffX = playerCamera.TOffX;
        this.TOffY = playerCamera.TOffY;
        this.lastOffX = playerCamera.lastOffX;
        this.lastOffY = playerCamera.lastOffY;
        this.RightClickTargetX = playerCamera.RightClickTargetX;
        this.RightClickTargetY = playerCamera.RightClickTargetY;
        this.RightClickX = playerCamera.RightClickX;
        this.RightClickY = playerCamera.RightClickY;
        this.DeferedX = playerCamera.DeferedX;
        this.DeferedY = playerCamera.DeferedY;
        this.zoom = playerCamera.zoom;
        this.OffscreenWidth = playerCamera.OffscreenWidth;
        this.OffscreenHeight = playerCamera.OffscreenHeight;
    }

    public void initFromIsoCamera(int n) {
        this.copyFrom(IsoCamera.cameras[n]);
        this.zoom = Core.getInstance().getZoom(n);
        this.OffscreenWidth = IsoCamera.getOffscreenWidth(n);
        this.OffscreenHeight = IsoCamera.getOffscreenHeight(n);
    }
}

