/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.Lua.LuaEventManager;
import zombie.SystemDisabler;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.core.raknet.UdpEngine;
import zombie.debug.DebugLog;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoLightSwitch;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;
import zombie.network.WorldItemTypes;

public final class ObjectsSyncRequests {
    public static final short ClientSendChunkHashes = 1;
    public static final short ServerSendGridSquareHashes = 2;
    public static final short ClientSendGridSquareRequest = 3;
    public static final short ServerSendGridSquareObjectsHashes = 4;
    public static final short ClientSendObjectRequests = 5;
    public static final short ServerSendObject = 6;
    public ArrayList<SyncIsoChunk> requestsSyncIsoChunk;
    public ArrayList<SyncIsoGridSquare> requestsSyncIsoGridSquare;
    public ArrayList<SyncIsoObject> requestsSyncIsoObject;
    public long timeout = 1000L;

    public ObjectsSyncRequests(boolean bl) {
        if (bl) {
            this.requestsSyncIsoChunk = new ArrayList();
            this.requestsSyncIsoGridSquare = new ArrayList();
            this.requestsSyncIsoObject = new ArrayList();
        } else {
            this.requestsSyncIsoGridSquare = new ArrayList();
        }
    }

    static int getObjectInsertIndex(long[] lArray, long[] lArray2, long l) {
        int n;
        if (l == lArray2[0]) {
            return 0;
        }
        for (n = 0; n < lArray.length; ++n) {
            if (lArray[n] != l) continue;
            return -1;
        }
        n = 0;
        for (int i = 0; i < lArray2.length; ++i) {
            if (n < lArray.length && lArray2[i] == lArray[n]) {
                ++n;
            }
            if (lArray2[i] != l) continue;
            return n;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequestSyncIsoChunk(IsoChunk isoChunk) {
        if (GameClient.bClient && !SystemDisabler.doWorldSyncEnable) {
            return;
        }
        SyncIsoChunk syncIsoChunk = new SyncIsoChunk();
        syncIsoChunk.x = isoChunk.wx;
        syncIsoChunk.y = isoChunk.wy;
        syncIsoChunk.hashCodeObjects = isoChunk.getHashCodeObjects();
        syncIsoChunk.reqTime = 0L;
        syncIsoChunk.reqCount = 0;
        ArrayList<SyncIsoChunk> arrayList = this.requestsSyncIsoChunk;
        synchronized (arrayList) {
            this.requestsSyncIsoChunk.add(syncIsoChunk);
        }
    }

    public void putRequestSyncItemContainer(ItemContainer itemContainer) {
        if (itemContainer == null || itemContainer.parent == null || itemContainer.parent.square == null) {
            return;
        }
        this.putRequestSyncIsoGridSquare(itemContainer.parent.square);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequestSyncIsoGridSquare(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return;
        }
        SyncIsoGridSquare syncIsoGridSquare = new SyncIsoGridSquare();
        syncIsoGridSquare.x = isoGridSquare.x;
        syncIsoGridSquare.y = isoGridSquare.y;
        syncIsoGridSquare.z = isoGridSquare.z;
        syncIsoGridSquare.reqTime = 0L;
        syncIsoGridSquare.reqCount = 0;
        ArrayList<SyncIsoGridSquare> arrayList = this.requestsSyncIsoGridSquare;
        synchronized (arrayList) {
            if (!this.requestsSyncIsoGridSquare.contains(isoGridSquare)) {
                this.requestsSyncIsoGridSquare.add(syncIsoGridSquare);
            } else {
                DebugLog.log("Warning: [putRequestSyncIsoGridSquare] Tryed to add dublicate object.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequests(UdpConnection udpConnection) {
        int n;
        Object object;
        int n2;
        int n3;
        int n4;
        ByteBuffer byteBuffer;
        ByteBufferWriter byteBufferWriter;
        if (!SystemDisabler.doWorldSyncEnable) {
            return;
        }
        if (this.requestsSyncIsoChunk != null && this.requestsSyncIsoChunk.size() != 0) {
            byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)1);
            byteBuffer = byteBufferWriter.bb;
            n4 = byteBuffer.position();
            byteBufferWriter.putShort((short)0);
            n3 = 0;
            ArrayList<SyncIsoChunk> arrayList = this.requestsSyncIsoChunk;
            synchronized (arrayList) {
                for (n2 = this.requestsSyncIsoChunk.size() - 1; n2 >= 0; --n2) {
                    object = this.requestsSyncIsoChunk.get(n2);
                    if (((SyncIsoChunk)object).reqCount > 3) {
                        this.requestsSyncIsoChunk.remove(n2);
                        continue;
                    }
                    if (((SyncIsoChunk)object).reqTime == 0L) {
                        ((SyncIsoChunk)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoChunk)object).x);
                        byteBuffer.putInt(((SyncIsoChunk)object).y);
                        byteBuffer.putLong(((SyncIsoChunk)object).hashCodeObjects);
                        ++((SyncIsoChunk)object).reqCount;
                    }
                    if (System.currentTimeMillis() - ((SyncIsoChunk)object).reqTime >= this.timeout) {
                        ((SyncIsoChunk)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoChunk)object).x);
                        byteBuffer.putInt(((SyncIsoChunk)object).y);
                        byteBuffer.putLong(((SyncIsoChunk)object).hashCodeObjects);
                        ++((SyncIsoChunk)object).reqCount;
                    }
                    if (n3 >= 5) break;
                }
            }
            if (n3 == 0) {
                GameClient.connection.cancelPacket();
                return;
            }
            n = byteBuffer.position();
            byteBuffer.position(n4);
            byteBuffer.putShort((short)n3);
            byteBuffer.position(n);
            PacketTypes.PacketType.SyncObjects.send(GameClient.connection);
        }
        if (this.requestsSyncIsoGridSquare != null && this.requestsSyncIsoGridSquare.size() != 0) {
            byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)3);
            byteBuffer = byteBufferWriter.bb;
            n4 = byteBuffer.position();
            byteBufferWriter.putShort((short)0);
            n3 = 0;
            ArrayList<SyncIsoGridSquare> arrayList = this.requestsSyncIsoGridSquare;
            synchronized (arrayList) {
                for (n2 = 0; n2 < this.requestsSyncIsoGridSquare.size(); ++n2) {
                    object = this.requestsSyncIsoGridSquare.get(n2);
                    if (((SyncIsoGridSquare)object).reqCount > 3) {
                        this.requestsSyncIsoGridSquare.remove(n2);
                        --n2;
                        continue;
                    }
                    if (((SyncIsoGridSquare)object).reqTime == 0L) {
                        ((SyncIsoGridSquare)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoGridSquare)object).x);
                        byteBuffer.putInt(((SyncIsoGridSquare)object).y);
                        byteBuffer.put((byte)((SyncIsoGridSquare)object).z);
                        ++((SyncIsoGridSquare)object).reqCount;
                    }
                    if (System.currentTimeMillis() - ((SyncIsoGridSquare)object).reqTime >= this.timeout) {
                        ((SyncIsoGridSquare)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoGridSquare)object).x);
                        byteBuffer.putInt(((SyncIsoGridSquare)object).y);
                        byteBuffer.put((byte)((SyncIsoGridSquare)object).z);
                        ++((SyncIsoGridSquare)object).reqCount;
                    }
                    if (n3 >= 100) break;
                }
            }
            if (n3 == 0) {
                GameClient.connection.cancelPacket();
                return;
            }
            n = byteBuffer.position();
            byteBuffer.position(n4);
            byteBuffer.putShort((short)n3);
            byteBuffer.position(n);
            PacketTypes.PacketType.SyncObjects.send(GameClient.connection);
        }
        if (this.requestsSyncIsoObject != null && this.requestsSyncIsoObject.size() != 0) {
            byteBufferWriter = udpConnection.startPacket();
            PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
            byteBufferWriter.putShort((short)5);
            byteBuffer = byteBufferWriter.bb;
            n4 = byteBuffer.position();
            byteBufferWriter.putShort((short)0);
            n3 = 0;
            ArrayList<SyncIsoObject> arrayList = this.requestsSyncIsoObject;
            synchronized (arrayList) {
                for (n2 = 0; n2 < this.requestsSyncIsoObject.size(); ++n2) {
                    object = this.requestsSyncIsoObject.get(n2);
                    if (((SyncIsoObject)object).reqCount > 3) {
                        this.requestsSyncIsoObject.remove(n2);
                        --n2;
                        continue;
                    }
                    if (((SyncIsoObject)object).reqTime == 0L) {
                        ((SyncIsoObject)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoObject)object).x);
                        byteBuffer.putInt(((SyncIsoObject)object).y);
                        byteBuffer.put((byte)((SyncIsoObject)object).z);
                        byteBuffer.putLong(((SyncIsoObject)object).hash);
                        ++((SyncIsoObject)object).reqCount;
                    }
                    if (System.currentTimeMillis() - ((SyncIsoObject)object).reqTime >= this.timeout) {
                        ((SyncIsoObject)object).reqTime = System.currentTimeMillis();
                        ++n3;
                        byteBuffer.putInt(((SyncIsoObject)object).x);
                        byteBuffer.putInt(((SyncIsoObject)object).y);
                        byteBuffer.put((byte)((SyncIsoObject)object).z);
                        byteBuffer.putLong(((SyncIsoObject)object).hash);
                        ++((SyncIsoObject)object).reqCount;
                    }
                    if (n3 >= 100) break;
                }
            }
            if (n3 == 0) {
                GameClient.connection.cancelPacket();
                return;
            }
            int n5 = byteBuffer.position();
            byteBuffer.position(n4);
            byteBuffer.putShort((short)n3);
            byteBuffer.position(n5);
            PacketTypes.PacketType.SyncObjects.send(GameClient.connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSyncIsoChunk(int n, int n2) {
        ArrayList<SyncIsoChunk> arrayList = this.requestsSyncIsoChunk;
        synchronized (arrayList) {
            for (int i = 0; i < this.requestsSyncIsoChunk.size(); ++i) {
                SyncIsoChunk syncIsoChunk = this.requestsSyncIsoChunk.get(i);
                if (syncIsoChunk.x != n || syncIsoChunk.y != n2) continue;
                this.requestsSyncIsoChunk.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSyncIsoGridSquare(int n, int n2, int n3) {
        ArrayList<SyncIsoGridSquare> arrayList = this.requestsSyncIsoGridSquare;
        synchronized (arrayList) {
            for (int i = 0; i < this.requestsSyncIsoGridSquare.size(); ++i) {
                SyncIsoGridSquare syncIsoGridSquare = this.requestsSyncIsoGridSquare.get(i);
                if (syncIsoGridSquare.x != n || syncIsoGridSquare.y != n2 || syncIsoGridSquare.z != n3) continue;
                this.requestsSyncIsoGridSquare.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSyncIsoObject(int n, int n2, int n3, long l) {
        ArrayList<SyncIsoObject> arrayList = this.requestsSyncIsoObject;
        synchronized (arrayList) {
            for (int i = 0; i < this.requestsSyncIsoObject.size(); ++i) {
                SyncIsoObject syncIsoObject = this.requestsSyncIsoObject.get(i);
                if (syncIsoObject.x != n || syncIsoObject.y != n2 || syncIsoObject.z != n3 || syncIsoObject.hash != l) continue;
                this.requestsSyncIsoObject.remove(i);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveGridSquareHashes(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            short s = byteBuffer.getShort();
            short s2 = byteBuffer.getShort();
            long l = byteBuffer.getLong();
            int n2 = byteBuffer.getShort();
            for (int j = 0; j < n2; ++j) {
                int n3;
                int n4 = byteBuffer.get() + s * 10;
                int n5 = byteBuffer.get() + s2 * 10;
                byte by = byteBuffer.get();
                int n6 = byteBuffer.getInt();
                IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, by);
                if (isoGridSquare == null || (n3 = isoGridSquare.getHashCodeObjectsInt()) == n6) continue;
                SyncIsoGridSquare syncIsoGridSquare = new SyncIsoGridSquare();
                syncIsoGridSquare.x = n4;
                syncIsoGridSquare.y = n5;
                syncIsoGridSquare.z = by;
                syncIsoGridSquare.reqTime = 0L;
                syncIsoGridSquare.reqCount = 0;
                ArrayList<SyncIsoGridSquare> arrayList = this.requestsSyncIsoGridSquare;
                synchronized (arrayList) {
                    this.requestsSyncIsoGridSquare.add(syncIsoGridSquare);
                    continue;
                }
            }
            this.receiveSyncIsoChunk(s, s2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveGridSquareObjectHashes(ByteBuffer byteBuffer) {
        int n = byteBuffer.getShort();
        for (int i = 0; i < n; ++i) {
            int n2 = byteBuffer.getInt();
            int n3 = byteBuffer.getInt();
            byte by = byteBuffer.get();
            this.receiveSyncIsoGridSquare(n2, n3, by);
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n2, n3, by);
            if (isoGridSquare == null) {
                return;
            }
            int n4 = byteBuffer.get();
            int n5 = byteBuffer.getInt() - 3;
            long[] lArray = new long[n4];
            for (int j = 0; j < n4; ++j) {
                lArray[j] = byteBuffer.getLong();
            }
            try {
                int n6;
                boolean[] blArray = new boolean[isoGridSquare.getObjects().size()];
                boolean[] blArray2 = new boolean[n4];
                for (n6 = 0; n6 < n4; ++n6) {
                    blArray2[n6] = true;
                }
                for (n6 = 0; n6 < isoGridSquare.getObjects().size(); ++n6) {
                    blArray[n6] = false;
                    long l = isoGridSquare.getObjects().get(n6).customHashCode();
                    boolean bl = false;
                    for (int j = 0; j < n4; ++j) {
                        if (lArray[j] != l) continue;
                        bl = true;
                        blArray2[j] = false;
                        break;
                    }
                    if (bl) continue;
                    blArray[n6] = true;
                }
                for (n6 = isoGridSquare.getObjects().size() - 1; n6 >= 0; --n6) {
                    if (!blArray[n6]) continue;
                    isoGridSquare.getObjects().get(n6).removeFromWorld();
                    isoGridSquare.getObjects().get(n6).removeFromSquare();
                }
                for (n6 = 0; n6 < n4; ++n6) {
                    if (!blArray2[n6]) continue;
                    SyncIsoObject syncIsoObject = new SyncIsoObject();
                    syncIsoObject.x = n2;
                    syncIsoObject.y = n3;
                    syncIsoObject.z = by;
                    syncIsoObject.hash = lArray[n6];
                    syncIsoObject.reqTime = 0L;
                    syncIsoObject.reqCount = 0;
                    ArrayList<SyncIsoObject> arrayList = this.requestsSyncIsoObject;
                    synchronized (arrayList) {
                        this.requestsSyncIsoObject.add(syncIsoObject);
                        continue;
                    }
                }
            }
            catch (Throwable throwable) {
                DebugLog.log("ERROR: receiveGridSquareObjects " + throwable.getMessage());
            }
            isoGridSquare.RecalcAllWithNeighbours(true);
            IsoWorld.instance.CurrentCell.checkHaveRoof(isoGridSquare.getX(), isoGridSquare.getY());
            byteBuffer.position(n5);
        }
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    public void receiveObject(ByteBuffer byteBuffer) {
        int n;
        int n2 = byteBuffer.getInt();
        int n3 = byteBuffer.getInt();
        byte by = byteBuffer.get();
        long l = byteBuffer.getLong();
        this.receiveSyncIsoObject(n2, n3, by, l);
        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(n2, n3, by);
        if (isoGridSquare == null) {
            return;
        }
        int n4 = byteBuffer.get();
        long[] lArray = new long[n4];
        for (int i = 0; i < n4; ++i) {
            lArray[i] = byteBuffer.getLong();
        }
        long[] lArray2 = new long[isoGridSquare.getObjects().size()];
        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
            lArray2[n] = isoGridSquare.getObjects().get(n).customHashCode();
        }
        n = isoGridSquare.getObjects().size();
        int n5 = ObjectsSyncRequests.getObjectInsertIndex(lArray2, lArray, l);
        if (n5 == -1) {
            DebugLog.log("ERROR: ObjectsSyncRequest.receiveObject OBJECT EXIST (" + n2 + ", " + n3 + ", " + by + ") hash=" + l);
            return;
        }
        IsoObject isoObject = WorldItemTypes.createFromBuffer(byteBuffer);
        if (isoObject != null) {
            isoObject.loadFromRemoteBuffer(byteBuffer, false);
            isoGridSquare.getObjects().add(n5, isoObject);
            if (isoObject instanceof IsoLightSwitch) {
                ((IsoLightSwitch)isoObject).addLightSourceFromSprite();
            }
            isoObject.addToWorld();
        }
        isoGridSquare.RecalcAllWithNeighbours(true);
        IsoWorld.instance.CurrentCell.checkHaveRoof(isoGridSquare.getX(), isoGridSquare.getY());
        LuaEventManager.triggerEvent("OnContainerUpdate");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serverSendRequests(UdpEngine udpEngine) {
        for (int i = 0; i < udpEngine.connections.size(); ++i) {
            this.serverSendRequests(udpEngine.connections.get(i));
        }
        ArrayList<SyncIsoGridSquare> arrayList = this.requestsSyncIsoGridSquare;
        synchronized (arrayList) {
            for (int i = 0; i < this.requestsSyncIsoGridSquare.size(); ++i) {
                this.requestsSyncIsoGridSquare.remove(0);
            }
        }
    }

    public void serverSendRequests(UdpConnection udpConnection) {
        int n;
        if (this.requestsSyncIsoGridSquare.size() == 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncObjects.doPacket(byteBufferWriter);
        byteBufferWriter.putShort((short)4);
        int n2 = byteBufferWriter.bb.position();
        byteBufferWriter.putShort((short)0);
        int n3 = 0;
        for (n = 0; n < this.requestsSyncIsoGridSquare.size(); ++n) {
            int n4;
            IsoGridSquare isoGridSquare;
            SyncIsoGridSquare syncIsoGridSquare = this.requestsSyncIsoGridSquare.get(n);
            if (!udpConnection.RelevantTo(syncIsoGridSquare.x, syncIsoGridSquare.y, 100.0f) || (isoGridSquare = ServerMap.instance.getGridSquare(syncIsoGridSquare.x, syncIsoGridSquare.y, syncIsoGridSquare.z)) == null) continue;
            ++n3;
            byteBufferWriter.putInt(isoGridSquare.x);
            byteBufferWriter.putInt(isoGridSquare.y);
            byteBufferWriter.putByte((byte)isoGridSquare.z);
            byteBufferWriter.putByte((byte)isoGridSquare.getObjects().size());
            byteBufferWriter.putInt(0);
            int n5 = byteBufferWriter.bb.position();
            for (n4 = 0; n4 < isoGridSquare.getObjects().size(); ++n4) {
                byteBufferWriter.putLong(isoGridSquare.getObjects().get(n4).customHashCode());
            }
            n4 = byteBufferWriter.bb.position();
            byteBufferWriter.bb.position(n5 - 4);
            byteBufferWriter.putInt(n4);
            byteBufferWriter.bb.position(n4);
        }
        n = byteBufferWriter.bb.position();
        byteBufferWriter.bb.position(n2);
        byteBufferWriter.putShort((short)n3);
        byteBufferWriter.bb.position(n);
        PacketTypes.PacketType.SyncObjects.send(GameClient.connection);
    }

    private class SyncIsoChunk {
        int x;
        int y;
        long hashCodeObjects;
        long reqTime;
        int reqCount;

        private SyncIsoChunk() {
        }
    }

    private class SyncIsoGridSquare {
        int x;
        int y;
        int z;
        long reqTime;
        int reqCount;

        private SyncIsoGridSquare() {
        }

        public int hashCode() {
            return this.x + this.y + this.z;
        }
    }

    private class SyncIsoObject {
        int x;
        int y;
        int z;
        long hash;
        long reqTime;
        int reqCount;

        private SyncIsoObject() {
        }

        public int hashCode() {
            return (int)((long)(this.x + this.y + this.z) + this.hash);
        }
    }
}

