/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.debug.LineDrawer;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.SpriteDetails.IsoFlagType;

public class NearestWalls {
    private static final int CPW = 10;
    private static final int CPWx4 = 40;
    private static final int LEVELS = 8;
    private static int CHANGE_COUNT = 0;
    private static int renderX;
    private static int renderY;
    private static int renderZ;

    public static void chunkLoaded(IsoChunk isoChunk) {
        if (++CHANGE_COUNT < 0) {
            CHANGE_COUNT = 0;
        }
        isoChunk.nearestWalls.changeCount = -1;
    }

    private static void calcDistanceOnThisChunkOnly(IsoChunk isoChunk) {
        byte[] byArray = isoChunk.nearestWalls.distanceSelf;
        for (int i = 0; i < 8; ++i) {
            int n;
            IsoGridSquare isoGridSquare;
            int n2;
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < 10; ++n5) {
                n4 = -1;
                for (n3 = 0; n3 < 10; ++n3) {
                    isoChunk.nearestWalls.closest[n3 + n5 * 10 + i * 10 * 10] = -1;
                    n2 = n3 * 4 + n5 * 40 + i * 10 * 40;
                    byArray[n2 + 0] = (byte)(n4 == -1 ? -1 : (byte)(n3 - n4));
                    byArray[n2 + 1] = -1;
                    isoGridSquare = isoChunk.getGridSquare(n3, n5, i);
                    if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.WallW) && !isoGridSquare.Is(IsoFlagType.DoorWallW) && !isoGridSquare.Is(IsoFlagType.WallNW) && !isoGridSquare.Is(IsoFlagType.WindowW)) continue;
                    n4 = (byte)n3;
                    byArray[n2 + 0] = 0;
                    for (n = n3 - 1; n >= 0 && byArray[(n2 = n * 4 + n5 * 40 + i * 10 * 40) + 1] == -1; --n) {
                        byArray[n2 + 1] = (byte)(n4 - n);
                    }
                }
            }
            for (n5 = 0; n5 < 10; ++n5) {
                n4 = -1;
                for (n3 = 0; n3 < 10; ++n3) {
                    n2 = n5 * 4 + n3 * 40 + i * 10 * 40;
                    byArray[n2 + 2] = (byte)(n4 == -1 ? -1 : (byte)(n3 - n4));
                    byArray[n2 + 3] = -1;
                    isoGridSquare = isoChunk.getGridSquare(n5, n3, i);
                    if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.WallN) && !isoGridSquare.Is(IsoFlagType.DoorWallN) && !isoGridSquare.Is(IsoFlagType.WallNW) && !isoGridSquare.Is(IsoFlagType.WindowN)) continue;
                    n4 = (byte)n3;
                    byArray[n2 + 2] = 0;
                    for (n = n3 - 1; n >= 0 && byArray[(n2 = n5 * 4 + n * 40 + i * 10 * 40) + 3] == -1; --n) {
                        byArray[n2 + 3] = (byte)(n4 - n);
                    }
                }
            }
        }
    }

    private static int getIndex(IsoChunk isoChunk, int n, int n2, int n3) {
        return (n - isoChunk.wx * 10) * 4 + (n2 - isoChunk.wy * 10) * 40 + n3 * 10 * 40;
    }

    private static int getNearestWallOnSameChunk(IsoChunk isoChunk, int n, int n2, int n3, int n4) {
        ChunkData chunkData = isoChunk.nearestWalls;
        if (chunkData.changeCount != CHANGE_COUNT) {
            NearestWalls.calcDistanceOnThisChunkOnly(isoChunk);
            chunkData.changeCount = CHANGE_COUNT;
        }
        int n5 = NearestWalls.getIndex(isoChunk, n, n2, n3);
        return chunkData.distanceSelf[n5 + n4];
    }

    private static boolean hasWall(IsoChunk isoChunk, int n, int n2, int n3, int n4) {
        return NearestWalls.getNearestWallOnSameChunk(isoChunk, n, n2, n3, n4) == 0;
    }

    private static int getNearestWallWest(IsoChunk isoChunk, int n, int n2, int n3) {
        IsoChunk isoChunk2;
        int n4 = 0;
        int n5 = -1;
        int n6 = 0;
        int n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk, n, n2, n3, n4);
        if (n7 != -1) {
            return n - n7;
        }
        for (int i = 1; i <= 3 && (isoChunk2 = IsoWorld.instance.CurrentCell.getChunk(isoChunk.wx + i * n5, isoChunk.wy + i * n6)) != null; ++i) {
            int n8 = (isoChunk2.wx + 1) * 10 - 1;
            int n9 = n2;
            n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk2, n8, n9, n3, n4);
            if (n7 == -1) continue;
            return n8 - n7;
        }
        return -1;
    }

    private static int getNearestWallEast(IsoChunk isoChunk, int n, int n2, int n3) {
        IsoChunk isoChunk2;
        int n4 = 1;
        int n5 = 1;
        int n6 = 0;
        int n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk, n, n2, n3, n4);
        if (n7 != -1) {
            return n + n7;
        }
        for (int i = 1; i <= 3 && (isoChunk2 = IsoWorld.instance.CurrentCell.getChunk(isoChunk.wx + i * n5, isoChunk.wy + i * n6)) != null; ++i) {
            int n8 = isoChunk2.wx * 10;
            int n9 = n2;
            int n10 = n7 = NearestWalls.hasWall(isoChunk2, n8, n9, n3, 0) ? 0 : NearestWalls.getNearestWallOnSameChunk(isoChunk2, n8, n9, n3, n4);
            if (n7 == -1) continue;
            return n8 + n7;
        }
        return -1;
    }

    private static int getNearestWallNorth(IsoChunk isoChunk, int n, int n2, int n3) {
        IsoChunk isoChunk2;
        int n4 = 2;
        int n5 = 0;
        int n6 = -1;
        int n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk, n, n2, n3, n4);
        if (n7 != -1) {
            return n2 - n7;
        }
        for (int i = 1; i <= 3 && (isoChunk2 = IsoWorld.instance.CurrentCell.getChunk(isoChunk.wx + i * n5, isoChunk.wy + i * n6)) != null; ++i) {
            int n8 = n;
            int n9 = (isoChunk2.wy + 1) * 10 - 1;
            n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk2, n8, n9, n3, n4);
            if (n7 == -1) continue;
            return n9 - n7;
        }
        return -1;
    }

    private static int getNearestWallSouth(IsoChunk isoChunk, int n, int n2, int n3) {
        IsoChunk isoChunk2;
        int n4 = 3;
        int n5 = 0;
        int n6 = 1;
        int n7 = NearestWalls.getNearestWallOnSameChunk(isoChunk, n, n2, n3, n4);
        if (n7 != -1) {
            return n2 + n7;
        }
        for (int i = 1; i <= 3 && (isoChunk2 = IsoWorld.instance.CurrentCell.getChunk(isoChunk.wx + i * n5, isoChunk.wy + i * n6)) != null; ++i) {
            int n8 = n;
            int n9 = isoChunk2.wy * 10;
            int n10 = n7 = NearestWalls.hasWall(isoChunk2, n8, n9, n3, 2) ? 0 : NearestWalls.getNearestWallOnSameChunk(isoChunk2, n8, n9, n3, n4);
            if (n7 == -1) continue;
            return n9 + n7;
        }
        return -1;
    }

    public static void render(int n, int n2, int n3) {
        int n4;
        int n5;
        IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(n, n2, n3);
        if (isoChunk == null) {
            return;
        }
        if (renderX != n || renderY != n2 || renderZ != n3) {
            renderX = n;
            renderY = n2;
            renderZ = n3;
            System.out.println("ClosestWallDistance=" + NearestWalls.ClosestWallDistance(isoChunk, n, n2, n3));
        }
        if ((n5 = NearestWalls.getNearestWallWest(isoChunk, n, n2, n3)) != -1) {
            NearestWalls.DrawIsoLine(n5, (float)n2 + 0.5f, (float)n + 0.5f, (float)n2 + 0.5f, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            NearestWalls.DrawIsoLine(n5, n2, n5, n2 + 1, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
        }
        if ((n5 = NearestWalls.getNearestWallEast(isoChunk, n, n2, n3)) != -1) {
            NearestWalls.DrawIsoLine(n5, (float)n2 + 0.5f, (float)n + 0.5f, (float)n2 + 0.5f, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            NearestWalls.DrawIsoLine(n5, n2, n5, n2 + 1, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
        }
        if ((n4 = NearestWalls.getNearestWallNorth(isoChunk, n, n2, n3)) != -1) {
            NearestWalls.DrawIsoLine((float)n + 0.5f, n4, (float)n + 0.5f, (float)n2 + 0.5f, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            NearestWalls.DrawIsoLine(n, n4, n + 1, n4, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
        }
        if ((n4 = NearestWalls.getNearestWallSouth(isoChunk, n, n2, n3)) != -1) {
            NearestWalls.DrawIsoLine((float)n + 0.5f, n4, (float)n + 0.5f, (float)n2 + 0.5f, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
            NearestWalls.DrawIsoLine(n, n4, n + 1, n4, n3, 1.0f, 1.0f, 1.0f, 1.0f, 1);
        }
    }

    private static void DrawIsoLine(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, int n) {
        float f10 = IsoUtils.XToScreenExact(f, f2, f5, 0);
        float f11 = IsoUtils.YToScreenExact(f, f2, f5, 0);
        float f12 = IsoUtils.XToScreenExact(f3, f4, f5, 0);
        float f13 = IsoUtils.YToScreenExact(f3, f4, f5, 0);
        LineDrawer.drawLine(f10, f11, f12, f13, f6, f7, f8, f9, n);
    }

    public static int ClosestWallDistance(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null || isoGridSquare.chunk == null) {
            return 127;
        }
        return NearestWalls.ClosestWallDistance(isoGridSquare.chunk, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
    }

    public static int ClosestWallDistance(IsoChunk isoChunk, int n, int n2, int n3) {
        int n4;
        byte by;
        if (isoChunk == null) {
            return 127;
        }
        ChunkData chunkData = isoChunk.nearestWalls;
        byte[] byArray = chunkData.closest;
        if (chunkData.changeCount != CHANGE_COUNT) {
            NearestWalls.calcDistanceOnThisChunkOnly(isoChunk);
            chunkData.changeCount = CHANGE_COUNT;
        }
        if ((by = byArray[n4 = n - isoChunk.wx * 10 + (n2 - isoChunk.wy * 10) * 10 + n3 * 10 * 10]) != -1) {
            return by;
        }
        int n5 = NearestWalls.getNearestWallWest(isoChunk, n, n2, n3);
        int n6 = NearestWalls.getNearestWallEast(isoChunk, n, n2, n3);
        int n7 = NearestWalls.getNearestWallNorth(isoChunk, n, n2, n3);
        int n8 = NearestWalls.getNearestWallSouth(isoChunk, n, n2, n3);
        if (n5 == -1 && n6 == -1 && n7 == -1 && n8 == -1) {
            byArray[n4] = 127;
            return 127;
        }
        int n9 = -1;
        if (n5 != -1 && n6 != -1) {
            n9 = n6 - n5;
        }
        int n10 = -1;
        if (n7 != -1 && n8 != -1) {
            n10 = n8 - n7;
        }
        if (n9 != -1 && n10 != -1) {
            byArray[n4] = (byte)Math.min(n9, n10);
            return byArray[n4];
        }
        if (n9 != -1) {
            byArray[n4] = (byte)n9;
            return byArray[n4];
        }
        if (n10 != -1) {
            byArray[n4] = (byte)n10;
            return byArray[n4];
        }
        IsoGridSquare isoGridSquare = isoChunk.getGridSquare(n - isoChunk.wx * 10, n2 - isoChunk.wy * 10, n3);
        if (isoGridSquare != null && isoGridSquare.isOutside()) {
            n5 = n5 == -1 ? 127 : n - n5;
            n6 = n6 == -1 ? 127 : n6 - n - 1;
            n7 = n7 == -1 ? 127 : n2 - n7;
            n8 = n8 == -1 ? 127 : n8 - n2 - 1;
            byArray[n4] = (byte)Math.min(n5, Math.min(n6, Math.min(n7, n8)));
            return byArray[n4];
        }
        byArray[n4] = 127;
        return 127;
    }

    public static final class ChunkData {
        int changeCount = -1;
        final byte[] distanceSelf = new byte[3200];
        final byte[] closest = new byte[800];
    }
}

