/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.lwjglx.opengl.Display;
import zombie.GameWindow;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.ThreadGroups;
import zombie.iso.IsoWorld;
import zombie.iso.LightingJNI;
import zombie.network.GameServer;
import zombie.ui.FPSGraph;

public final class LightingThread {
    public static final LightingThread instance = new LightingThread();
    public Thread lightingThread;
    public boolean bFinished = false;
    public volatile boolean Interrupted = false;
    public static boolean DebugLockTime = false;

    public void stop() {
        if (!PerformanceSettings.LightingThread) {
            LightingJNI.stop();
            return;
        }
        this.bFinished = true;
        while (this.lightingThread.isAlive()) {
        }
        LightingJNI.stop();
        this.lightingThread = null;
    }

    public void create() {
        if (GameServer.bServer) {
            return;
        }
        if (!PerformanceSettings.LightingThread) {
            return;
        }
        this.bFinished = false;
        this.lightingThread = new Thread(ThreadGroups.Workers, () -> {
            while (!this.bFinished) {
                if (IsoWorld.instance.CurrentCell == null) {
                    return;
                }
                try {
                    Display.sync(PerformanceSettings.LightingFPS);
                    LightingJNI.DoLightingUpdateNew(System.nanoTime());
                    while (LightingJNI.WaitingForMain() && !this.bFinished) {
                        Thread.sleep(13L);
                    }
                    if (!Core.bDebug || FPSGraph.instance == null) continue;
                    FPSGraph.instance.addLighting(System.currentTimeMillis());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        this.lightingThread.setPriority(5);
        this.lightingThread.setDaemon(true);
        this.lightingThread.setName("Lighting Thread");
        this.lightingThread.setUncaughtExceptionHandler(GameWindow::uncaughtException);
        this.lightingThread.start();
    }

    public void GameLoadingUpdate() {
    }

    public void update() {
        if (IsoWorld.instance == null || IsoWorld.instance.CurrentCell == null) {
            return;
        }
        if (LightingJNI.init) {
            LightingJNI.update();
        }
    }

    public void scrollLeft(int n) {
        if (LightingJNI.init) {
            LightingJNI.scrollLeft(n);
        }
    }

    public void scrollRight(int n) {
        if (LightingJNI.init) {
            LightingJNI.scrollRight(n);
        }
    }

    public void scrollUp(int n) {
        if (LightingJNI.init) {
            LightingJNI.scrollUp(n);
        }
    }

    public void scrollDown(int n) {
        if (LightingJNI.init) {
            LightingJNI.scrollDown(n);
        }
    }
}

