/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.Stack;
import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.Moodles.MoodleType;
import zombie.core.PerformanceSettings;
import zombie.core.opengl.RenderSettings;
import zombie.core.skinnedmodel.DeadBodyAtlas;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunk;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLightSource;
import zombie.iso.IsoObject;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.objects.IsoBarricade;
import zombie.iso.objects.IsoCurtain;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoWindow;
import zombie.iso.weather.ClimateManager;
import zombie.meta.Meta;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehicleLight;
import zombie.vehicles.VehiclePart;

public final class LightingJNI {
    public static final int ROOM_SPAWN_DIST = 50;
    public static boolean init = false;
    public static final int[][] ForcedVis = new int[][]{{-1, 0, -1, -1, 0, -1, 1, -1, 1, 0, -2, -2, -1, -2, 0, -2, 1, -2, 2, -2}, {-1, 1, -1, 0, -1, -1, 0, -1, 1, -1, -2, 0, -2, -1, -2, -2, -1, -2, 0, -2}, {0, 1, -1, 1, -1, 0, -1, -1, 0, -1, -2, 2, -2, 1, -2, 0, -2, -1, -2, -2}, {1, 1, 0, 1, -1, 1, -1, 0, -1, -1, 0, 2, -1, 2, -2, 2, -2, 1, -2, 0}, {1, 0, 1, 1, 0, 1, -1, 1, -1, 0, 2, 2, 1, 2, 0, 2, -1, 2, -2, 2}, {-1, 1, 0, 1, 1, 1, 1, 0, 1, -1, 2, 0, 2, 1, 2, 2, 1, 2, 0, 2}, {0, 1, 1, 1, 1, 0, 1, -1, 0, -1, 2, -2, 2, -1, 2, 0, 2, 1, 2, 2}, {-1, -1, 0, -1, 1, -1, 1, 0, 1, 1, 0, -2, 1, -2, 2, -2, 2, -1, 2, 0}};
    private static final ArrayList<IsoGameCharacter.TorchInfo> torches = new ArrayList();
    private static final ArrayList<IsoGameCharacter.TorchInfo> activeTorches = new ArrayList();
    private static final ArrayList<IsoLightSource> JNILights = new ArrayList();
    private static final int[] updateCounter = new int[4];
    private static boolean bWasElecShut = false;
    private static boolean bWasNight = false;
    private static final Vector2 tempVector2 = new Vector2();
    private static final int MAX_PLAYERS = 256;
    private static final int MAX_LIGHTS_PER_PLAYER = 4;
    private static final int MAX_LIGHTS_PER_VEHICLE = 10;
    private static final ArrayList<InventoryItem> tempItems = new ArrayList();

    public static void init() {
        if (init) {
            return;
        }
        String string = "";
        if ("1".equals(System.getProperty("zomboid.debuglibs.lighting"))) {
            DebugLog.log("***** Loading debug version of Lighting");
            string = "d";
        }
        try {
            if (System.getProperty("os.name").contains("OS X")) {
                System.loadLibrary("Lighting");
            } else if (System.getProperty("os.name").startsWith("Win")) {
                if (System.getProperty("sun.arch.data.model").equals("64")) {
                    System.loadLibrary("Lighting64" + string);
                } else {
                    System.loadLibrary("Lighting32" + string);
                }
            } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                System.loadLibrary("Lighting64");
            } else {
                System.loadLibrary("Lighting32");
            }
            for (int i = 0; i < 4; ++i) {
                LightingJNI.updateCounter[i] = -1;
            }
            LightingJNI.configure(0.005f);
            init = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(1);
        }
    }

    private static int getTorchIndexById(int n) {
        for (int i = 0; i < torches.size(); ++i) {
            IsoGameCharacter.TorchInfo torchInfo = torches.get(i);
            if (torchInfo.id != n) continue;
            return i;
        }
        return -1;
    }

    private static void checkTorch(IsoPlayer isoPlayer, InventoryItem inventoryItem, int n) {
        IsoGameCharacter.TorchInfo torchInfo;
        int n2 = LightingJNI.getTorchIndexById(n);
        if (n2 == -1) {
            torchInfo = IsoGameCharacter.TorchInfo.alloc();
            torches.add(torchInfo);
        } else {
            torchInfo = torches.get(n2);
        }
        torchInfo.set(isoPlayer, inventoryItem);
        if (torchInfo.id == 0) {
            torchInfo.id = n;
        }
        LightingJNI.updateTorch(torchInfo.id, torchInfo.x, torchInfo.y, torchInfo.z, torchInfo.angleX, torchInfo.angleY, torchInfo.dist, torchInfo.strength, torchInfo.bCone, torchInfo.dot, torchInfo.focusing);
        activeTorches.add(torchInfo);
    }

    private static int checkPlayerTorches(IsoPlayer isoPlayer, int n) {
        ArrayList<InventoryItem> arrayList = tempItems;
        arrayList.clear();
        isoPlayer.getActiveLightItems(arrayList);
        int n2 = Math.min(arrayList.size(), 4);
        for (int i = 0; i < n2; ++i) {
            LightingJNI.checkTorch(isoPlayer, arrayList.get(i), n * 4 + i + 1);
        }
        return n2;
    }

    private static void clearPlayerTorches(int n, int n2) {
        for (int i = n2; i < 4; ++i) {
            int n3 = n * 4 + i + 1;
            int n4 = LightingJNI.getTorchIndexById(n3);
            if (n4 == -1) continue;
            IsoGameCharacter.TorchInfo torchInfo = torches.get(n4);
            LightingJNI.removeTorch(torchInfo.id);
            torchInfo.id = 0;
            IsoGameCharacter.TorchInfo.release(torchInfo);
            torches.remove(n4);
            break;
        }
    }

    private static void checkTorch(VehiclePart vehiclePart, int n) {
        VehicleLight vehicleLight = vehiclePart.getLight();
        if (vehicleLight != null && vehicleLight.getActive()) {
            IsoGameCharacter.TorchInfo torchInfo = null;
            for (int i = 0; i < torches.size(); ++i) {
                torchInfo = torches.get(i);
                if (torchInfo.id == n) break;
                torchInfo = null;
            }
            if (torchInfo == null) {
                torchInfo = IsoGameCharacter.TorchInfo.alloc();
                torches.add(torchInfo);
            }
            torchInfo.set(vehiclePart);
            if (torchInfo.id == 0) {
                torchInfo.id = n;
            }
            LightingJNI.updateTorch(torchInfo.id, torchInfo.x, torchInfo.y, torchInfo.z, torchInfo.angleX, torchInfo.angleY, torchInfo.dist, torchInfo.strength, torchInfo.bCone, torchInfo.dot, torchInfo.focusing);
            activeTorches.add(torchInfo);
        } else {
            for (int i = 0; i < torches.size(); ++i) {
                IsoGameCharacter.TorchInfo torchInfo = torches.get(i);
                if (torchInfo.id != n) continue;
                LightingJNI.removeTorch(torchInfo.id);
                torchInfo.id = 0;
                IsoGameCharacter.TorchInfo.release(torchInfo);
                torches.remove(i--);
            }
        }
    }

    private static void checkLights() {
        int n;
        int n2;
        int n3;
        IsoLightSource isoLightSource;
        int n4;
        if (IsoWorld.instance.CurrentCell == null) {
            return;
        }
        if (GameClient.bClient) {
            IsoGenerator.updateSurroundingNow();
        }
        boolean bl = IsoWorld.instance.isHydroPowerOn();
        Stack<IsoLightSource> stack = IsoWorld.instance.CurrentCell.getLamppostPositions();
        for (n4 = 0; n4 < stack.size(); ++n4) {
            isoLightSource = (IsoLightSource)stack.get(n4);
            IsoChunk isoChunk = IsoWorld.instance.CurrentCell.getChunkForGridSquare(isoLightSource.x, isoLightSource.y, isoLightSource.z);
            if (isoChunk != null && isoLightSource.chunk != null && isoLightSource.chunk != isoChunk) {
                isoLightSource.life = 0;
            }
            if (isoLightSource.life == 0 || !isoLightSource.isInBounds()) {
                stack.remove(n4);
                if (isoLightSource.ID != 0) {
                    n3 = isoLightSource.ID;
                    isoLightSource.ID = 0;
                    JNILights.remove(isoLightSource);
                    LightingJNI.removeLight(n3);
                    GameTime.instance.lightSourceUpdate = 100.0f;
                }
                --n4;
                continue;
            }
            if (isoLightSource.bHydroPowered) {
                if (isoLightSource.switches.isEmpty()) {
                    assert (false);
                    n3 = bl ? 1 : 0;
                    if (n3 == 0) {
                        var6_19 = IsoWorld.instance.CurrentCell.getGridSquare(isoLightSource.x, isoLightSource.y, isoLightSource.z);
                        int n5 = n3 = var6_19 != null && ((IsoGridSquare)var6_19).haveElectricity() ? 1 : 0;
                    }
                    if (isoLightSource.bActive != n3) {
                        isoLightSource.bActive = n3;
                        GameTime.instance.lightSourceUpdate = 100.0f;
                    }
                } else {
                    var6_19 = isoLightSource.switches.get(0);
                    n3 = ((IsoLightSwitch)var6_19).canSwitchLight() ? 1 : 0;
                    if (((IsoLightSwitch)var6_19).bStreetLight && GameTime.getInstance().getNight() < 0.5f) {
                        n3 = 0;
                    }
                    if (isoLightSource.bActive && n3 == 0) {
                        isoLightSource.bActive = false;
                        GameTime.instance.lightSourceUpdate = 100.0f;
                    } else if (!isoLightSource.bActive && n3 != 0 && ((IsoLightSwitch)var6_19).isActivated()) {
                        isoLightSource.bActive = true;
                        GameTime.instance.lightSourceUpdate = 100.0f;
                    }
                }
            }
            if (isoLightSource.ID == 0) {
                ++IsoLightSource.NextID;
                isoLightSource.ID = isoLightSource.ID;
                if (isoLightSource.life != -1) {
                    LightingJNI.addTempLight(isoLightSource.ID, isoLightSource.x, isoLightSource.y, isoLightSource.z, isoLightSource.radius, isoLightSource.r, isoLightSource.g, isoLightSource.b, (int)((float)(isoLightSource.life * PerformanceSettings.getLockFPS()) / 30.0f));
                    stack.remove(n4--);
                    continue;
                }
                isoLightSource.rJNI = isoLightSource.r;
                isoLightSource.gJNI = isoLightSource.g;
                isoLightSource.bJNI = isoLightSource.b;
                isoLightSource.bActiveJNI = isoLightSource.bActive;
                JNILights.add(isoLightSource);
                LightingJNI.addLight(isoLightSource.ID, isoLightSource.x, isoLightSource.y, isoLightSource.z, isoLightSource.radius, isoLightSource.r, isoLightSource.g, isoLightSource.b, isoLightSource.localToBuilding == null ? -1 : isoLightSource.localToBuilding.ID, isoLightSource.bActive);
                continue;
            }
            if (isoLightSource.r != isoLightSource.rJNI || isoLightSource.g != isoLightSource.gJNI || isoLightSource.b != isoLightSource.bJNI) {
                isoLightSource.rJNI = isoLightSource.r;
                isoLightSource.gJNI = isoLightSource.g;
                isoLightSource.bJNI = isoLightSource.b;
                LightingJNI.setLightColor(isoLightSource.ID, isoLightSource.r, isoLightSource.g, isoLightSource.b);
            }
            if (isoLightSource.bActiveJNI == isoLightSource.bActive) continue;
            isoLightSource.bActiveJNI = isoLightSource.bActive;
            LightingJNI.setLightActive(isoLightSource.ID, isoLightSource.bActive);
        }
        for (n4 = 0; n4 < JNILights.size(); ++n4) {
            isoLightSource = JNILights.get(n4);
            if (stack.contains(isoLightSource)) continue;
            int n6 = isoLightSource.ID;
            isoLightSource.ID = 0;
            JNILights.remove(n4--);
            LightingJNI.removeLight(n6);
        }
        ArrayList<IsoRoomLight> arrayList = IsoWorld.instance.CurrentCell.roomLights;
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            IsoRoomLight isoRoomLight = arrayList.get(n2);
            if (isoRoomLight.isInBounds()) {
                isoRoomLight.bActive = isoRoomLight.room.def.bLightsActive;
                if (!bl) {
                    n3 = 0;
                    for (int i = 0; n3 == 0 && i < isoRoomLight.room.lightSwitches.size(); ++i) {
                        IsoLightSwitch isoLightSwitch = isoRoomLight.room.lightSwitches.get(i);
                        if (isoLightSwitch.square == null || !isoLightSwitch.square.haveElectricity()) continue;
                        n3 = 1;
                    }
                    if (n3 == 0 && isoRoomLight.bActive) {
                        isoRoomLight.bActive = false;
                        if (isoRoomLight.bActiveJNI) {
                            IsoGridSquare.RecalcLightTime = -1;
                            GameTime.instance.lightSourceUpdate = 100.0f;
                        }
                    } else if (n3 != 0 && isoRoomLight.bActive && !isoRoomLight.bActiveJNI) {
                        IsoGridSquare.RecalcLightTime = -1;
                        GameTime.instance.lightSourceUpdate = 100.0f;
                    }
                }
                if (isoRoomLight.ID == 0) {
                    isoRoomLight.ID = 100000 + IsoRoomLight.NextID++;
                    LightingJNI.addRoomLight(isoRoomLight.ID, isoRoomLight.room.building.ID, isoRoomLight.room.def.ID, isoRoomLight.x, isoRoomLight.y, isoRoomLight.z, isoRoomLight.width, isoRoomLight.height, isoRoomLight.bActive);
                    isoRoomLight.bActiveJNI = isoRoomLight.bActive;
                    GameTime.instance.lightSourceUpdate = 100.0f;
                    continue;
                }
                if (isoRoomLight.bActiveJNI == isoRoomLight.bActive) continue;
                LightingJNI.setRoomLightActive(isoRoomLight.ID, isoRoomLight.bActive);
                isoRoomLight.bActiveJNI = isoRoomLight.bActive;
                GameTime.instance.lightSourceUpdate = 100.0f;
                continue;
            }
            arrayList.remove(n2--);
            if (isoRoomLight.ID == 0) continue;
            n3 = isoRoomLight.ID;
            isoRoomLight.ID = 0;
            LightingJNI.removeRoomLight(n3);
            GameTime.instance.lightSourceUpdate = 100.0f;
        }
        activeTorches.clear();
        if (GameClient.bClient) {
            ArrayList<IsoPlayer> arrayList2 = GameClient.instance.getPlayers();
            for (int i = 0; i < arrayList2.size(); ++i) {
                IsoPlayer isoPlayer = arrayList2.get(i);
                LightingJNI.checkPlayerTorches(isoPlayer, isoPlayer.OnlineID + 1);
            }
        } else {
            for (n2 = 0; n2 < IsoPlayer.numPlayers; ++n2) {
                IsoPlayer isoPlayer = IsoPlayer.players[n2];
                if (isoPlayer == null || isoPlayer.isDead() || isoPlayer.getVehicle() != null) {
                    LightingJNI.clearPlayerTorches(n2, 0);
                    continue;
                }
                n3 = LightingJNI.checkPlayerTorches(isoPlayer, n2);
                LightingJNI.clearPlayerTorches(n2, n3);
            }
        }
        for (n = 0; n < IsoWorld.instance.CurrentCell.getVehicles().size(); ++n) {
            BaseVehicle baseVehicle = IsoWorld.instance.CurrentCell.getVehicles().get(n);
            if (baseVehicle.VehicleID == -1) continue;
            for (int i = 0; i < baseVehicle.getLightCount(); ++i) {
                VehiclePart vehiclePart = baseVehicle.getLightByIndex(i);
                LightingJNI.checkTorch(vehiclePart, 1024 + baseVehicle.VehicleID * 10 + i);
            }
        }
        for (n = 0; n < torches.size(); ++n) {
            IsoGameCharacter.TorchInfo torchInfo = torches.get(n);
            if (activeTorches.contains(torchInfo)) continue;
            LightingJNI.removeTorch(torchInfo.id);
            torchInfo.id = 0;
            IsoGameCharacter.TorchInfo.release(torchInfo);
            torches.remove(n--);
        }
    }

    public static float calculateVisionCone(IsoGameCharacter isoGameCharacter) {
        float f;
        if (isoGameCharacter.getVehicle() == null) {
            f = -0.2f;
            if ((f -= isoGameCharacter.getStats().fatigue - 0.6f) > -0.2f) {
                f = -0.2f;
            }
            if (isoGameCharacter.getStats().fatigue >= 1.0f) {
                f -= 0.2f;
            }
            if (isoGameCharacter.getMoodles().getMoodleLevel(MoodleType.Panic) == 4) {
                f -= 0.2f;
            }
            f = isoGameCharacter.isInARoom() ? (f -= 0.2f * (1.0f - ClimateManager.getInstance().getDayLightStrength())) : (f -= 0.7f * (1.0f - ClimateManager.getInstance().getDayLightStrength()));
            if (f < -0.9f) {
                f = -0.9f;
            }
            if (isoGameCharacter.Traits.EagleEyed.isSet()) {
                f += 0.2f * ClimateManager.getInstance().getDayLightStrength();
            }
            if (isoGameCharacter.Traits.NightVision.isSet()) {
                f += 0.2f * (1.0f - ClimateManager.getInstance().getDayLightStrength());
            }
            if (f > 0.0f) {
                f = 0.0f;
            }
        } else {
            if (isoGameCharacter.getVehicle().getHeadlightsOn() && isoGameCharacter.getVehicle().getHeadlightCanEmmitLight()) {
                f = 0.8f - 3.0f * (1.0f - ClimateManager.getInstance().getDayLightStrength());
                if (f < -0.8f) {
                    f = -0.8f;
                }
            } else {
                f = 0.8f - 3.0f * (1.0f - ClimateManager.getInstance().getDayLightStrength());
                if (f < -0.95f) {
                    f = -0.95f;
                }
            }
            if (isoGameCharacter.Traits.NightVision.isSet()) {
                f += 0.2f * (1.0f - ClimateManager.getInstance().getDayLightStrength());
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
        }
        return f;
    }

    public static void updatePlayer(int n) {
        IsoPlayer isoPlayer = IsoPlayer.players[n];
        if (isoPlayer != null) {
            float f = isoPlayer.getStats().fatigue - 0.6f;
            if (f < 0.0f) {
                f = 0.0f;
            }
            f *= 2.5f;
            if (isoPlayer.Traits.HardOfHearing.isSet() && f < 0.7f) {
                f = 0.7f;
            }
            float f2 = 2.0f;
            if (isoPlayer.Traits.KeenHearing.isSet()) {
                f2 += 3.0f;
            }
            float f3 = LightingJNI.calculateVisionCone(isoPlayer);
            Vector2 vector22 = isoPlayer.getLookVector(tempVector2);
            BaseVehicle baseVehicle = isoPlayer.getVehicle();
            if (baseVehicle != null && !isoPlayer.isAiming() && !isoPlayer.isLookingWhileInVehicle() && baseVehicle.isDriver(isoPlayer) && baseVehicle.getCurrentSpeedKmHour() < -1.0f) {
                vector22.rotate((float)Math.PI);
            }
            LightingJNI.playerSet(isoPlayer.x, isoPlayer.y, isoPlayer.z, vector22.x, vector22.y, false, isoPlayer.ReanimatedCorpse != null, isoPlayer.isGhostMode(), isoPlayer.Traits.ShortSighted.isSet(), f, f2, f3);
        }
    }

    public static void updateChunk(IsoChunk isoChunk) {
        LightingJNI.chunkBeginUpdate(isoChunk.wx, isoChunk.wy);
        for (int i = 0; i < IsoCell.MaxHeight; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoGridSquare isoGridSquare = isoChunk.getGridSquare(k, j, i);
                    if (isoGridSquare != null) {
                        LightingJNI.squareBeginUpdate(k, j, i);
                        int n = isoGridSquare.visionMatrix;
                        boolean bl = isoGridSquare.Has(IsoObjectType.stairsTN) || isoGridSquare.Has(IsoObjectType.stairsMN) || isoGridSquare.Has(IsoObjectType.stairsTW) || isoGridSquare.Has(IsoObjectType.stairsMW);
                        LightingJNI.squareSet(isoGridSquare.w != null, isoGridSquare.n != null, isoGridSquare.e != null, isoGridSquare.s != null, bl, n, isoGridSquare.getRoom() != null ? isoGridSquare.getBuilding().ID : -1, isoGridSquare.getRoomID());
                        for (int i2 = 0; i2 < isoGridSquare.getSpecialObjects().size(); ++i2) {
                            IsoBarricade isoBarricade;
                            IsoObject isoObject;
                            boolean bl2;
                            IsoObject isoObject2;
                            IsoObject isoObject3 = isoGridSquare.getSpecialObjects().get(i2);
                            if (isoObject3 instanceof IsoCurtain) {
                                isoObject2 = (IsoCurtain)isoObject3;
                                bl2 = false;
                                if (isoObject2.getType() == IsoObjectType.curtainW) {
                                    bl2 |= 4;
                                } else if (isoObject2.getType() == IsoObjectType.curtainN) {
                                    bl2 |= 8;
                                } else if (isoObject2.getType() == IsoObjectType.curtainE) {
                                    bl2 |= 0x10;
                                } else if (isoObject2.getType() == IsoObjectType.curtainS) {
                                    bl2 |= 0x20;
                                }
                                LightingJNI.squareAddCurtain(bl2 ? 1 : 0, ((IsoCurtain)isoObject2).open);
                                continue;
                            }
                            if (isoObject3 instanceof IsoDoor) {
                                isoObject2 = (IsoDoor)isoObject3;
                                boolean bl3 = bl2 = ((IsoDoor)isoObject2).sprite != null && ((IsoDoor)isoObject2).sprite.getProperties().Is("doorTrans");
                                bl2 = ((IsoDoor)isoObject2).open ? true : bl2 && (((IsoDoor)isoObject2).HasCurtains() == null || ((IsoDoor)isoObject2).isCurtainOpen());
                                isoObject = ((IsoDoor)isoObject2).getBarricadeOnSameSquare();
                                isoBarricade = ((IsoDoor)isoObject2).getBarricadeOnOppositeSquare();
                                if (isoObject != null && ((IsoBarricade)isoObject).isBlockVision()) {
                                    bl2 = false;
                                }
                                if (isoBarricade != null && isoBarricade.isBlockVision()) {
                                    bl2 = false;
                                }
                                if (((IsoDoor)isoObject2).IsOpen() && IsoDoor.getGarageDoorIndex(isoObject2) != -1) {
                                    bl2 = true;
                                }
                                LightingJNI.squareAddDoor(((IsoDoor)isoObject2).north, ((IsoDoor)isoObject2).open, bl2);
                                continue;
                            }
                            if (isoObject3 instanceof IsoThumpable) {
                                isoObject2 = (IsoThumpable)isoObject3;
                                bl2 = isoObject2.getSprite().getProperties().Is("doorTrans");
                                if (((IsoThumpable)isoObject2).isDoor.booleanValue() && ((IsoThumpable)isoObject2).open) {
                                    bl2 = true;
                                }
                                LightingJNI.squareAddThumpable(((IsoThumpable)isoObject2).north, ((IsoThumpable)isoObject2).open, ((IsoThumpable)isoObject2).isDoor, bl2);
                                isoObject = (IsoThumpable)isoObject3;
                                boolean bl4 = false;
                                IsoBarricade isoBarricade2 = ((IsoThumpable)isoObject).getBarricadeOnSameSquare();
                                IsoBarricade isoBarricade3 = ((IsoThumpable)isoObject).getBarricadeOnOppositeSquare();
                                if (isoBarricade2 != null) {
                                    bl4 |= isoBarricade2.isBlockVision();
                                }
                                if (isoBarricade3 != null) {
                                    bl4 |= isoBarricade3.isBlockVision();
                                }
                                LightingJNI.squareAddWindow(((IsoThumpable)isoObject).north, ((IsoThumpable)isoObject).open, bl4);
                                continue;
                            }
                            if (!(isoObject3 instanceof IsoWindow)) continue;
                            isoObject2 = (IsoWindow)isoObject3;
                            bl2 = false;
                            isoObject = ((IsoWindow)isoObject2).getBarricadeOnSameSquare();
                            isoBarricade = ((IsoWindow)isoObject2).getBarricadeOnOppositeSquare();
                            if (isoObject != null) {
                                bl2 |= ((IsoBarricade)isoObject).isBlockVision();
                            }
                            if (isoBarricade != null) {
                                bl2 |= isoBarricade.isBlockVision();
                            }
                            LightingJNI.squareAddWindow(((IsoWindow)isoObject2).north, ((IsoWindow)isoObject2).open, bl2);
                        }
                        LightingJNI.squareEndUpdate();
                        continue;
                    }
                    LightingJNI.squareSetNull(k, j, i);
                }
            }
        }
        LightingJNI.chunkEndUpdate();
    }

    public static void update() {
        boolean bl;
        if (IsoWorld.instance == null || IsoWorld.instance.CurrentCell == null) {
            return;
        }
        LightingJNI.checkLights();
        GameTime gameTime = GameTime.getInstance();
        RenderSettings renderSettings = RenderSettings.getInstance();
        boolean bl2 = IsoWorld.instance.isHydroPowerOn();
        boolean bl3 = bl = GameTime.getInstance().getNight() < 0.5f;
        if (bl2 != bWasElecShut || bl != bWasNight) {
            bWasElecShut = bl2;
            bWasNight = bl;
            IsoGridSquare.RecalcLightTime = -1;
            gameTime.lightSourceUpdate = 100.0f;
        }
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoChunkMap isoChunkMap = IsoWorld.instance.CurrentCell.ChunkMap[i];
            if (isoChunkMap == null || isoChunkMap.ignore) continue;
            RenderSettings.PlayerRenderSettings playerRenderSettings = renderSettings.getPlayerSettings(i);
            LightingJNI.stateBeginUpdate(i, isoChunkMap.getWorldXMin(), isoChunkMap.getWorldYMin(), IsoChunkMap.ChunkGridWidth, IsoChunkMap.ChunkGridWidth);
            LightingJNI.updatePlayer(i);
            LightingJNI.stateEndFrame(playerRenderSettings.getRmod(), playerRenderSettings.getGmod(), playerRenderSettings.getBmod(), playerRenderSettings.getAmbient(), playerRenderSettings.getNight(), playerRenderSettings.getViewDistance(), gameTime.getViewDistMax(), LosUtil.cachecleared[i], gameTime.lightSourceUpdate);
            if (LosUtil.cachecleared[i]) {
                LosUtil.cachecleared[i] = false;
                IsoWorld.instance.CurrentCell.invalidatePeekedRoom(i);
            }
            for (int j = 0; j < IsoChunkMap.ChunkGridWidth; ++j) {
                for (int k = 0; k < IsoChunkMap.ChunkGridWidth; ++k) {
                    IsoChunk isoChunk = isoChunkMap.getChunk(k, j);
                    if (isoChunk != null && isoChunk.lightCheck[i]) {
                        LightingJNI.updateChunk(isoChunk);
                        isoChunk.lightCheck[i] = false;
                    }
                    if (isoChunk == null) continue;
                    isoChunk.bLightingNeverDone[i] = !LightingJNI.chunkLightingDone(isoChunk.wx, isoChunk.wy);
                }
            }
            LightingJNI.stateEndUpdate();
            LightingJNI.updateCounter[i] = LightingJNI.stateUpdateCounter(i);
            if (!(gameTime.lightSourceUpdate > 0.0f) || IsoPlayer.players[i] == null) continue;
            IsoPlayer.players[i].dirtyRecalcGridStackTime = 20.0f;
        }
        DeadBodyAtlas.instance.lightingUpdate(updateCounter[0], gameTime.lightSourceUpdate > 0.0f);
        gameTime.lightSourceUpdate = 0.0f;
    }

    public static void getTorches(ArrayList<IsoGameCharacter.TorchInfo> arrayList) {
        arrayList.addAll(torches);
    }

    public static void stop() {
        torches.clear();
        JNILights.clear();
        LightingJNI.destroy();
        for (int i = 0; i < updateCounter.length; ++i) {
            LightingJNI.updateCounter[i] = -1;
        }
        bWasElecShut = false;
        bWasNight = false;
        IsoLightSource.NextID = 1;
        IsoRoomLight.NextID = 1;
    }

    public static native void configure(float var0);

    public static native void scrollLeft(int var0);

    public static native void scrollRight(int var0);

    public static native void scrollUp(int var0);

    public static native void scrollDown(int var0);

    public static native void stateBeginUpdate(int var0, int var1, int var2, int var3, int var4);

    public static native void stateEndFrame(float var0, float var1, float var2, float var3, float var4, float var5, float var6, boolean var7, float var8);

    public static native void stateEndUpdate();

    public static native int stateUpdateCounter(int var0);

    public static native void teleport(int var0, int var1, int var2);

    public static native void DoLightingUpdateNew(long var0);

    public static native boolean WaitingForMain();

    public static native void playerSet(float var0, float var1, float var2, float var3, float var4, boolean var5, boolean var6, boolean var7, boolean var8, float var9, float var10, float var11);

    public static native boolean chunkLightingDone(int var0, int var1);

    public static native void chunkBeginUpdate(int var0, int var1);

    public static native void chunkEndUpdate();

    public static native void squareSetNull(int var0, int var1, int var2);

    public static native void squareBeginUpdate(int var0, int var1, int var2);

    public static native void squareSet(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4, int var5, int var6, int var7);

    public static native void squareAddCurtain(int var0, boolean var1);

    public static native void squareAddDoor(boolean var0, boolean var1, boolean var2);

    public static native void squareAddThumpable(boolean var0, boolean var1, boolean var2, boolean var3);

    public static native void squareAddWindow(boolean var0, boolean var1, boolean var2);

    public static native void squareEndUpdate();

    public static native int getVertLight(int var0, int var1, int var2, int var3, int var4);

    public static native float getLightInfo(int var0, int var1, int var2, int var3, int var4);

    public static native float getDarkMulti(int var0, int var1, int var2, int var3);

    public static native float getTargetDarkMulti(int var0, int var1, int var2, int var3);

    public static native boolean getSeen(int var0, int var1, int var2, int var3);

    public static native boolean getCanSee(int var0, int var1, int var2, int var3);

    public static native boolean getCouldSee(int var0, int var1, int var2, int var3);

    public static native boolean getSquareLighting(int var0, int var1, int var2, int var3, int[] var4);

    public static native void addLight(int var0, int var1, int var2, int var3, int var4, float var5, float var6, float var7, int var8, boolean var9);

    public static native void addTempLight(int var0, int var1, int var2, int var3, int var4, float var5, float var6, float var7, int var8);

    public static native void removeLight(int var0);

    public static native void setLightActive(int var0, boolean var1);

    public static native void setLightColor(int var0, float var1, float var2, float var3);

    public static native void addRoomLight(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public static native void removeRoomLight(int var0);

    public static native void setRoomLightActive(int var0, boolean var1);

    public static native void updateTorch(int var0, float var1, float var2, float var3, float var4, float var5, float var6, float var7, boolean var8, float var9, int var10);

    public static native void removeTorch(int var0);

    public static native void destroy();

    public static final class JNILighting
    implements IsoGridSquare.ILighting {
        private static final int RESULT_LIGHTS_PER_SQUARE = 5;
        private static final int[] lightInts = new int[43];
        private static final byte VIS_SEEN = 1;
        private static final byte VIS_CAN_SEE = 2;
        private static final byte VIS_COULD_SEE = 4;
        private int playerIndex;
        private final IsoGridSquare square;
        private ColorInfo lightInfo = new ColorInfo();
        private byte vis;
        private float cacheDarkMulti;
        private float cacheTargetDarkMulti;
        private int[] cacheVertLight;
        private int updateTick = -1;
        private int lightsCount;
        private IsoGridSquare.ResultLight[] lights;

        public JNILighting(int n, IsoGridSquare isoGridSquare) {
            this.playerIndex = n;
            this.square = isoGridSquare;
            this.cacheDarkMulti = 0.0f;
            this.cacheTargetDarkMulti = 0.0f;
            this.cacheVertLight = new int[8];
            for (int i = 0; i < 8; ++i) {
                this.cacheVertLight[i] = 0;
            }
        }

        @Override
        public int lightverts(int n) {
            return this.cacheVertLight[n];
        }

        @Override
        public float lampostTotalR() {
            return 0.0f;
        }

        @Override
        public float lampostTotalG() {
            return 0.0f;
        }

        @Override
        public float lampostTotalB() {
            return 0.0f;
        }

        @Override
        public boolean bSeen() {
            this.update();
            return (this.vis & 1) != 0;
        }

        @Override
        public boolean bCanSee() {
            this.update();
            return (this.vis & 2) != 0;
        }

        @Override
        public boolean bCouldSee() {
            this.update();
            return (this.vis & 4) != 0;
        }

        @Override
        public float darkMulti() {
            return this.cacheDarkMulti;
        }

        @Override
        public float targetDarkMulti() {
            return this.cacheTargetDarkMulti;
        }

        @Override
        public ColorInfo lightInfo() {
            this.update();
            return this.lightInfo;
        }

        @Override
        public void lightverts(int n, int n2) {
            throw new IllegalStateException();
        }

        @Override
        public void lampostTotalR(float f) {
            throw new IllegalStateException();
        }

        @Override
        public void lampostTotalG(float f) {
            throw new IllegalStateException();
        }

        @Override
        public void lampostTotalB(float f) {
            throw new IllegalStateException();
        }

        @Override
        public void bSeen(boolean bl) {
            throw new IllegalStateException();
        }

        @Override
        public void bCanSee(boolean bl) {
            throw new IllegalStateException();
        }

        @Override
        public void bCouldSee(boolean bl) {
            throw new IllegalStateException();
        }

        @Override
        public void darkMulti(float f) {
            throw new IllegalStateException();
        }

        @Override
        public void targetDarkMulti(float f) {
            throw new IllegalStateException();
        }

        @Override
        public int resultLightCount() {
            return this.lightsCount;
        }

        @Override
        public IsoGridSquare.ResultLight getResultLight(int n) {
            return this.lights[n];
        }

        @Override
        public void reset() {
            this.updateTick = -1;
        }

        private void update() {
            if (updateCounter[this.playerIndex] == -1) {
                return;
            }
            if (this.updateTick != updateCounter[this.playerIndex] && LightingJNI.getSquareLighting(this.playerIndex, this.square.x, this.square.y, this.square.z, lightInts)) {
                int n;
                int n2;
                IsoPlayer isoPlayer = IsoPlayer.players[this.playerIndex];
                boolean bl = (this.vis & 1) != 0;
                int n3 = 0;
                this.vis = (byte)(lightInts[n3++] & 7);
                this.lightInfo.r = (float)(lightInts[n3] & 0xFF) / 255.0f;
                this.lightInfo.g = (float)(lightInts[n3] >> 8 & 0xFF) / 255.0f;
                this.lightInfo.b = (float)(lightInts[n3++] >> 16 & 0xFF) / 255.0f;
                this.cacheDarkMulti = (float)lightInts[n3++] / 100000.0f;
                this.cacheTargetDarkMulti = (float)lightInts[n3++] / 100000.0f;
                float f = 1.0f;
                float f2 = 1.0f;
                if (isoPlayer != null) {
                    n2 = this.square.z - (int)isoPlayer.z;
                    if (n2 == -1) {
                        f = 1.0f;
                        f2 = 0.85f;
                    } else if (n2 < -1) {
                        f = 0.85f;
                        f2 = 0.85f;
                    }
                    if ((this.vis & 2) == 0 && (this.vis & 4) != 0) {
                        n = (int)isoPlayer.x;
                        int n4 = (int)isoPlayer.y;
                        int n5 = this.square.x - n;
                        int n6 = this.square.y - n4;
                        if (isoPlayer.dir != IsoDirections.Max && Math.abs(n5) <= 2 && Math.abs(n6) <= 2) {
                            int[] nArray = ForcedVis[isoPlayer.dir.index()];
                            for (int i = 0; i < nArray.length; i += 2) {
                                if (n5 != nArray[i] || n6 != nArray[i + 1]) continue;
                                this.vis = (byte)(this.vis | 2);
                                break;
                            }
                        }
                    }
                }
                for (n2 = 0; n2 < 4; ++n2) {
                    n = lightInts[n3++];
                    float f3 = (float)(n & 0xFF) * f2;
                    float f4 = (float)((n & 0xFF00) >> 8) * f2;
                    float f5 = (float)((n & 0xFF0000) >> 16) * f2;
                    this.cacheVertLight[n2] = (int)f3 << 0 | (int)f4 << 8 | (int)f5 << 16 | 0xFF000000;
                }
                for (n2 = 4; n2 < 8; ++n2) {
                    n = lightInts[n3++];
                    float f6 = (float)(n & 0xFF) * f;
                    float f7 = (float)((n & 0xFF00) >> 8) * f;
                    float f8 = (float)((n & 0xFF0000) >> 16) * f;
                    this.cacheVertLight[n2] = (int)f6 << 0 | (int)f7 << 8 | (int)f8 << 16 | 0xFF000000;
                }
                this.lightsCount = lightInts[n3++];
                for (n2 = 0; n2 < this.lightsCount; ++n2) {
                    if (this.lights == null) {
                        this.lights = new IsoGridSquare.ResultLight[5];
                    }
                    if (this.lights[n2] == null) {
                        this.lights[n2] = new IsoGridSquare.ResultLight();
                    }
                    this.lights[n2].id = lightInts[n3++];
                    this.lights[n2].x = lightInts[n3++];
                    this.lights[n2].y = lightInts[n3++];
                    this.lights[n2].z = lightInts[n3++];
                    this.lights[n2].radius = lightInts[n3++];
                    n = lightInts[n3++];
                    this.lights[n2].r = (float)(n & 0xFF) / 255.0f;
                    this.lights[n2].g = (float)(n >> 8 & 0xFF) / 255.0f;
                    this.lights[n2].b = (float)(n >> 16 & 0xFF) / 255.0f;
                    this.lights[n2].flags = n >> 24 & 0xFF;
                }
                this.updateTick = updateCounter[this.playerIndex];
                if ((this.vis & 1) != 0) {
                    if (bl && this.square.getRoom() != null && this.square.getRoom().def != null && !this.square.getRoom().def.bExplored) {
                        n2 = 1;
                    }
                    this.square.checkRoomSeen(this.playerIndex);
                    if (!bl) {
                        assert (!GameServer.bServer);
                        if (!GameClient.bClient) {
                            Meta.instance.dealWithSquareSeen(this.square);
                        }
                    }
                }
            }
        }
    }
}

