/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import org.joml.Matrix3f;
import org.joml.Vector2f;
import org.joml.Vector4f;
import zombie.debug.DebugLog;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.SpriteDetails.IsoFlagType;

public final class IsoWaterFlow {
    private static final ArrayList<Vector4f> points = new ArrayList();
    private static final ArrayList<Matrix3f> zones = new ArrayList();

    public static void addFlow(float f, float f2, float f3, float f4) {
        int n = (360 - (int)f3 - 45) % 360;
        if (n < 0) {
            n += 360;
        }
        f3 = (float)Math.toRadians(n);
        points.add(new Vector4f(f, f2, f3, f4));
    }

    public static void addZone(float f, float f2, float f3, float f4, float f5, float f6) {
        if (f > f3 || f2 > f4 || (double)f5 > 1.0) {
            DebugLog.log("ERROR IsoWaterFlow: Invalid waterzone (" + f + ", " + f2 + ", " + f3 + ", " + f4 + ")");
        }
        zones.add(new Matrix3f(f, f2, f3, f4, f5, f6, 0.0f, 0.0f, 0.0f));
    }

    public static int getShore(int n, int n2) {
        for (int i = 0; i < zones.size(); ++i) {
            Matrix3f matrix3f = zones.get(i);
            if (!(matrix3f.m00 <= (float)n) || !(matrix3f.m02 >= (float)n) || !(matrix3f.m01 <= (float)n2) || !(matrix3f.m10 >= (float)n2)) continue;
            return (int)matrix3f.m11;
        }
        return 1;
    }

    public static Vector2f getFlow(IsoGridSquare isoGridSquare, int n, int n2, Vector2f vector2f) {
        double d;
        Vector4f vector4f;
        int n3;
        float f = 0.0f;
        float f2 = 0.0f;
        Vector4f vector4f2 = null;
        float f3 = Float.MAX_VALUE;
        Vector4f vector4f3 = null;
        float f4 = Float.MAX_VALUE;
        Vector4f vector4f4 = null;
        float f5 = Float.MAX_VALUE;
        if (points.size() == 0) {
            return vector2f.set(0.0f, 0.0f);
        }
        for (n3 = 0; n3 < points.size(); ++n3) {
            vector4f = points.get(n3);
            d = Math.pow(vector4f.x - (float)(isoGridSquare.x + n), 2.0) + Math.pow(vector4f.y - (float)(isoGridSquare.y + n2), 2.0);
            if (!(d < (double)f3)) continue;
            f3 = (float)d;
            vector4f2 = vector4f;
        }
        for (n3 = 0; n3 < points.size(); ++n3) {
            vector4f = points.get(n3);
            d = Math.pow(vector4f.x - (float)(isoGridSquare.x + n), 2.0) + Math.pow(vector4f.y - (float)(isoGridSquare.y + n2), 2.0);
            if (!(d < (double)f4) || vector4f == vector4f2) continue;
            f4 = (float)d;
            vector4f3 = vector4f;
        }
        if ((f3 = Math.max((float)Math.sqrt(f3), 0.1f)) > (f4 = Math.max((float)Math.sqrt(f4), 0.1f)) * 10.0f) {
            f = vector4f2.z;
            f2 = vector4f2.w;
        } else {
            for (n3 = 0; n3 < points.size(); ++n3) {
                vector4f = points.get(n3);
                d = Math.pow(vector4f.x - (float)(isoGridSquare.x + n), 2.0) + Math.pow(vector4f.y - (float)(isoGridSquare.y + n2), 2.0);
                if (!(d < (double)f5) || vector4f == vector4f2 || vector4f == vector4f3) continue;
                f5 = (float)d;
                vector4f4 = vector4f;
            }
            f5 = Math.max((float)Math.sqrt(f5), 0.1f);
            float f6 = vector4f3.z * (1.0f - f4 / (f4 + f5)) + vector4f4.z * (1.0f - f5 / (f4 + f5));
            float f7 = vector4f3.w * (1.0f - f4 / (f4 + f5)) + vector4f4.w * (1.0f - f5 / (f4 + f5));
            float f8 = f4 * (1.0f - f4 / (f4 + f5)) + f5 * (1.0f - f5 / (f4 + f5));
            f = vector4f2.z * (1.0f - f3 / (f3 + f8)) + f6 * (1.0f - f8 / (f3 + f8));
            f2 = vector4f2.w * (1.0f - f3 / (f3 + f8)) + f7 * (1.0f - f8 / (f3 + f8));
        }
        float f9 = 1.0f;
        IsoCell isoCell = isoGridSquare.getCell();
        for (int i = -5; i < 5; ++i) {
            for (int j = -5; j < 5; ++j) {
                IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(isoGridSquare.x + n + i, isoGridSquare.y + n2 + j, 0);
                if (isoGridSquare2 != null && isoGridSquare2.getProperties().Is(IsoFlagType.water)) continue;
                f9 = (float)Math.min((double)f9, Math.max(0.0, Math.sqrt(i * i + j * j)) / 4.0);
            }
        }
        return vector2f.set(f, f2 *= f9);
    }

    public static void Reset() {
        points.clear();
        zones.clear();
    }
}

