/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import zombie.GameTime;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.textures.Texture;
import zombie.interfaces.ITexture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoWaterGeometry;
import zombie.iso.PlayerCamera;
import zombie.iso.WaterShader;
import zombie.iso.weather.ClimateManager;

public final class IsoWater {
    public Shader Effect;
    private float WaterTime;
    private float WaterWindAngle;
    private float WaterWindIntensity;
    private float WaterRainIntensity;
    private Vector2f WaterParamWindINT;
    private Texture texBottom;
    private int apiId;
    private static IsoWater instance;
    private static boolean isShaderEnable;
    private final RenderData[][] renderData = new RenderData[3][4];
    private final RenderData[][] renderDataShore = new RenderData[3][4];
    static final int BYTES_PER_FLOAT = 4;
    static final int FLOATS_PER_VERTEX = 7;
    static final int BYTES_PER_VERTEX = 28;
    static final int VERTICES_PER_SQUARE = 4;
    private final Vector4f shaderOffset = new Vector4f();

    public static synchronized IsoWater getInstance() {
        if (instance == null) {
            instance = new IsoWater();
        }
        return instance;
    }

    public boolean getShaderEnable() {
        return isShaderEnable;
    }

    public IsoWater() {
        this.texBottom = Texture.getSharedTexture("media/textures/river_bottom.png");
        RenderThread.invokeOnRenderContext(() -> {
            if (GL.getCapabilities().OpenGL30) {
                this.apiId = 1;
            }
            if (GL.getCapabilities().GL_ARB_framebuffer_object) {
                this.apiId = 2;
            }
            if (GL.getCapabilities().GL_EXT_framebuffer_object) {
                this.apiId = 3;
            }
        });
        for (int i = 0; i < this.renderData.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.renderData[i][j] = new RenderData();
                this.renderDataShore[i][j] = new RenderData();
            }
        }
        this.applyWaterQuality();
        this.WaterParamWindINT = new Vector2f(0.0f);
    }

    public void applyWaterQuality() {
        if (PerformanceSettings.WaterQuality == 2) {
            isShaderEnable = false;
        }
        if (PerformanceSettings.WaterQuality == 1) {
            isShaderEnable = true;
            RenderThread.invokeOnRenderContext(() -> {
                ARBShaderObjects.glUseProgramObjectARB((int)0);
                this.Effect = new WaterShader("water");
                ARBShaderObjects.glUseProgramObjectARB((int)0);
            });
        }
        if (PerformanceSettings.WaterQuality == 0) {
            isShaderEnable = true;
            RenderThread.invokeOnRenderContext(() -> {
                this.Effect = new WaterShader("water_hq");
                this.Effect.Start();
                this.Effect.End();
            });
        }
    }

    public void render(ArrayList<IsoGridSquare> arrayList, boolean bl) {
        if (!this.getShaderEnable()) {
            return;
        }
        int n = IsoCamera.frameState.playerIndex;
        int n2 = SpriteRenderer.instance.getMainStateIndex();
        RenderData renderData = this.renderData[n2][n];
        RenderData renderData2 = this.renderDataShore[n2][n];
        if (bl) {
            if (renderData2.numSquares > 0) {
                SpriteRenderer.instance.drawWater(this.Effect, n, this.apiId, true);
            }
            return;
        }
        renderData.clear();
        renderData2.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoWaterGeometry isoWaterGeometry;
            IsoGridSquare isoGridSquare = arrayList.get(i);
            if (isoGridSquare.chunk != null && isoGridSquare.chunk.bLightingNeverDone[n] || (isoWaterGeometry = isoGridSquare.getWater()) == null) continue;
            if (isoWaterGeometry.bShore) {
                renderData2.addSquare(isoWaterGeometry);
                continue;
            }
            if (!isoWaterGeometry.hasWater) continue;
            renderData.addSquare(isoWaterGeometry);
        }
        if (renderData.numSquares == 0) {
            return;
        }
        SpriteRenderer.instance.drawWater(this.Effect, n, this.apiId, false);
    }

    public void waterProjection() {
        int n = SpriteRenderer.instance.getRenderingPlayerIndex();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        GL11.glOrtho((double)playerCamera.getOffX(), (double)(playerCamera.getOffX() + (float)playerCamera.OffscreenWidth), (double)(playerCamera.getOffY() + (float)playerCamera.OffscreenHeight), (double)playerCamera.getOffY(), (double)-1.0, (double)1.0);
    }

    public void waterGeometry(boolean bl) {
        int n;
        long l = System.nanoTime();
        int n2 = SpriteRenderer.instance.getRenderStateIndex();
        int n3 = SpriteRenderer.instance.getRenderingPlayerIndex();
        RenderData renderData = bl ? this.renderDataShore[n2][n3] : this.renderData[n2][n3];
        int n4 = 0;
        for (int i = renderData.numSquares; i > 0; i -= n) {
            n = this.renderSome(n4, i, bl);
            n4 += n;
        }
        long l2 = System.nanoTime();
        SpriteRenderer.ringBuffer.restoreVBOs = true;
    }

    private int renderSome(int n, int n2, boolean bl) {
        int n3;
        IsoPuddles.VBOs.next();
        FloatBuffer floatBuffer = IsoPuddles.VBOs.vertices;
        ShortBuffer shortBuffer = IsoPuddles.VBOs.indices;
        GL13.glActiveTexture((int)33985);
        GL13.glClientActiveTexture((int)33985);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)28, (long)8L);
        GL11.glEnableClientState((int)32888);
        GL13.glActiveTexture((int)33984);
        GL13.glClientActiveTexture((int)33984);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)28, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)28, (long)24L);
        GL11.glVertexPointer((int)2, (int)5126, (int)28, (long)16L);
        int n4 = SpriteRenderer.instance.getRenderStateIndex();
        int n5 = SpriteRenderer.instance.getRenderingPlayerIndex();
        RenderData renderData = bl ? this.renderDataShore[n4][n5] : this.renderData[n4][n5];
        int n6 = Math.min(n2 * 4, IsoPuddles.VBOs.bufferSizeVertices);
        floatBuffer.put(renderData.data, n * 4 * 7, n6 * 7);
        int n7 = 0;
        int n8 = 0;
        for (n3 = 0; n3 < n6 / 4; ++n3) {
            shortBuffer.put((short)n7);
            shortBuffer.put((short)(n7 + 1));
            shortBuffer.put((short)(n7 + 2));
            shortBuffer.put((short)n7);
            shortBuffer.put((short)(n7 + 2));
            shortBuffer.put((short)(n7 + 3));
            n7 += 4;
            n8 += 6;
        }
        IsoPuddles.VBOs.unmap();
        n3 = 0;
        int n9 = n7;
        int n10 = 0;
        int n11 = n8;
        GL12.glDrawRangeElements((int)4, (int)n3, (int)(n3 + n9), (int)(n11 - n10), (int)5123, (long)(n10 * 2));
        return n6 / 4;
    }

    public ITexture getTextureBottom() {
        return this.texBottom;
    }

    public float getShaderTime() {
        return this.WaterTime;
    }

    public float getRainIntensity() {
        return this.WaterRainIntensity;
    }

    public void update(ClimateManager climateManager) {
        this.WaterWindAngle = climateManager.getCorrectedWindAngleIntensity();
        this.WaterWindIntensity = climateManager.getWindIntensity() * 5.0f;
        this.WaterRainIntensity = climateManager.getRainIntensity();
        float f = GameTime.getInstance().getMultiplier();
        this.WaterTime += 0.0166f * f;
        this.WaterParamWindINT.add((float)Math.sin(this.WaterWindAngle * 6.0f) * this.WaterWindIntensity * 0.05f * (f / 1.6f), (float)Math.cos(this.WaterWindAngle * 6.0f) * this.WaterWindIntensity * 0.15f * (f / 1.6f));
    }

    public float getWaterWindX() {
        return this.WaterParamWindINT.x;
    }

    public float getWaterWindY() {
        return this.WaterParamWindINT.y;
    }

    public float getWaterWindSpeed() {
        return this.WaterWindIntensity * 2.0f;
    }

    public Vector4f getShaderOffset() {
        int n = SpriteRenderer.instance.getRenderingPlayerIndex();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        return this.shaderOffset.set(playerCamera.getOffX() - (float)IsoCamera.getOffscreenLeft(n) * playerCamera.zoom, playerCamera.getOffY() + (float)IsoCamera.getOffscreenTop(n) * playerCamera.zoom, playerCamera.OffscreenWidth, playerCamera.OffscreenHeight);
    }

    public void FBOStart() {
        int n = IsoCamera.frameState.playerIndex;
    }

    public void FBOEnd() {
        int n = IsoCamera.frameState.playerIndex;
    }

    static {
        isShaderEnable = false;
    }

    private static final class RenderData {
        int numSquares;
        int capacity = 512;
        float[] data;

        private RenderData() {
        }

        void clear() {
            this.numSquares = 0;
        }

        void addSquare(IsoWaterGeometry isoWaterGeometry) {
            int n = IsoCamera.frameState.playerIndex;
            int n2 = 4;
            if (this.data == null) {
                this.data = new float[this.capacity * n2 * 7];
            }
            if (this.numSquares + 1 > this.capacity) {
                this.capacity += 128;
                this.data = Arrays.copyOf(this.data, this.capacity * n2 * 7);
            }
            int n3 = this.numSquares * n2 * 7;
            for (int i = 0; i < 4; ++i) {
                this.data[n3++] = isoWaterGeometry.depth[i];
                this.data[n3++] = isoWaterGeometry.flow[i];
                this.data[n3++] = isoWaterGeometry.speed[i];
                this.data[n3++] = isoWaterGeometry.IsExternal;
                this.data[n3++] = isoWaterGeometry.x[i];
                this.data[n3++] = isoWaterGeometry.y[i];
                if (isoWaterGeometry.square != null) {
                    int n4 = isoWaterGeometry.square.getVertLight((4 - i) % 4, n);
                    this.data[n3++] = Float.intBitsToFloat(n4);
                    continue;
                }
                ++n3;
            }
            ++this.numSquares;
        }
    }
}

