/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.core.Core;
import zombie.core.logger.ExceptionLogger;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoUtils;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.popman.ObjectPool;

public final class IsoPuddlesGeometry {
    final float[] x = new float[4];
    final float[] y = new float[4];
    final float[] pdne = new float[4];
    final float[] pdnw = new float[4];
    final float[] pda = new float[4];
    final float[] pnon = new float[4];
    final int[] color = new int[4];
    IsoGridSquare square = null;
    boolean bRecalc = true;
    private boolean interiorCalc = false;
    public static final ObjectPool<IsoPuddlesGeometry> pool = new ObjectPool<IsoPuddlesGeometry>(IsoPuddlesGeometry::new);

    public IsoPuddlesGeometry init(IsoGridSquare isoGridSquare) {
        this.interiorCalc = false;
        this.x[0] = IsoUtils.XToScreen(isoGridSquare.x - isoGridSquare.z * 3, isoGridSquare.y - isoGridSquare.z * 3, isoGridSquare.z, isoGridSquare.z);
        this.y[0] = IsoUtils.YToScreen(isoGridSquare.x - isoGridSquare.z * 3, isoGridSquare.y - isoGridSquare.z * 3, isoGridSquare.z, isoGridSquare.z);
        this.x[1] = IsoUtils.XToScreen(isoGridSquare.x - isoGridSquare.z * 3, isoGridSquare.y - isoGridSquare.z * 3 + 1, 0.0f, 0);
        this.y[1] = IsoUtils.YToScreen(isoGridSquare.x - isoGridSquare.z * 3, isoGridSquare.y - isoGridSquare.z * 3 + 1, 0.0f, 0);
        this.x[2] = IsoUtils.XToScreen(isoGridSquare.x - isoGridSquare.z * 3 + 1, isoGridSquare.y - isoGridSquare.z * 3 + 1, 0.0f, 0);
        this.y[2] = IsoUtils.YToScreen(isoGridSquare.x - isoGridSquare.z * 3 + 1, isoGridSquare.y - isoGridSquare.z * 3 + 1, 0.0f, 0);
        this.x[3] = IsoUtils.XToScreen(isoGridSquare.x - isoGridSquare.z * 3 + 1, isoGridSquare.y - isoGridSquare.z * 3, 0.0f, 0);
        this.y[3] = IsoUtils.YToScreen(isoGridSquare.x - isoGridSquare.z * 3 + 1, isoGridSquare.y - isoGridSquare.z * 3, 0.0f, 0);
        this.square = isoGridSquare;
        if (isoGridSquare.getProperties().Is(IsoFlagType.water) || !isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
            for (int i = 0; i < 4; ++i) {
                this.pdne[i] = 0.0f;
                this.pdnw[i] = 0.0f;
                this.pda[i] = 0.0f;
                this.pnon[i] = 0.0f;
            }
            return this;
        }
        for (int i = 0; i < 4; ++i) {
            this.pdne[i] = 0.0f;
            this.pdnw[i] = 0.0f;
            this.pda[i] = 1.0f;
            this.pnon[i] = 0.0f;
        }
        if (Core.getInstance().getPerfPuddles() > 1) {
            return this;
        }
        IsoCell isoCell = isoGridSquare.getCell();
        IsoGridSquare isoGridSquare2 = isoCell.getGridSquare(isoGridSquare.x - 1, isoGridSquare.y, isoGridSquare.z);
        IsoGridSquare isoGridSquare3 = isoCell.getGridSquare(isoGridSquare.x - 1, isoGridSquare.y - 1, isoGridSquare.z);
        IsoGridSquare isoGridSquare4 = isoCell.getGridSquare(isoGridSquare.x, isoGridSquare.y - 1, isoGridSquare.z);
        IsoGridSquare isoGridSquare5 = isoCell.getGridSquare(isoGridSquare.x - 1, isoGridSquare.y + 1, isoGridSquare.z);
        IsoGridSquare isoGridSquare6 = isoCell.getGridSquare(isoGridSquare.x, isoGridSquare.y + 1, isoGridSquare.z);
        IsoGridSquare isoGridSquare7 = isoCell.getGridSquare(isoGridSquare.x + 1, isoGridSquare.y + 1, isoGridSquare.z);
        IsoGridSquare isoGridSquare8 = isoCell.getGridSquare(isoGridSquare.x + 1, isoGridSquare.y, isoGridSquare.z);
        IsoGridSquare isoGridSquare9 = isoCell.getGridSquare(isoGridSquare.x + 1, isoGridSquare.y - 1, isoGridSquare.z);
        if (isoGridSquare4 == null || isoGridSquare3 == null || isoGridSquare2 == null || isoGridSquare5 == null || isoGridSquare6 == null || isoGridSquare7 == null || isoGridSquare8 == null || isoGridSquare9 == null) {
            return this;
        }
        this.setFlags(0, isoGridSquare2.getPuddlesDir() | isoGridSquare3.getPuddlesDir() | isoGridSquare4.getPuddlesDir());
        this.setFlags(1, isoGridSquare2.getPuddlesDir() | isoGridSquare5.getPuddlesDir() | isoGridSquare6.getPuddlesDir());
        this.setFlags(2, isoGridSquare6.getPuddlesDir() | isoGridSquare7.getPuddlesDir() | isoGridSquare8.getPuddlesDir());
        this.setFlags(3, isoGridSquare8.getPuddlesDir() | isoGridSquare9.getPuddlesDir() | isoGridSquare4.getPuddlesDir());
        return this;
    }

    private void setFlags(int n, int n2) {
        this.pdne[n] = 0.0f;
        this.pdnw[n] = 0.0f;
        this.pda[n] = 0.0f;
        this.pnon[n] = 0.0f;
        if ((n2 & IsoGridSquare.PuddlesDirection.PUDDLES_DIR_NE) != 0) {
            this.pdne[n] = 1.0f;
        }
        if ((n2 & IsoGridSquare.PuddlesDirection.PUDDLES_DIR_NW) != 0) {
            this.pdnw[n] = 1.0f;
        }
        if ((n2 & IsoGridSquare.PuddlesDirection.PUDDLES_DIR_ALL) != 0) {
            this.pda[n] = 1.0f;
        }
    }

    public void recalcIfNeeded() {
        if (this.bRecalc) {
            this.bRecalc = false;
            try {
                this.init(this.square);
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        }
    }

    public boolean shouldRender() {
        int n;
        this.recalcIfNeeded();
        for (n = 0; n < 4; ++n) {
            if (!(this.pdne[n] + this.pdnw[n] + this.pda[n] + this.pnon[n] > 0.0f)) continue;
            return true;
        }
        if (this.square.getProperties().Is(IsoFlagType.water)) {
            return false;
        }
        if (IsoPuddles.leakingPuddlesInTheRoom && !this.interiorCalc && this.square != null) {
            int n2;
            for (n = 0; n < 4; ++n) {
                this.pdne[n] = 0.0f;
                this.pdnw[n] = 0.0f;
                this.pda[n] = 0.0f;
                this.pnon[n] = 1.0f;
            }
            IsoGridSquare isoGridSquare = this.square.getAdjacentSquare(IsoDirections.W);
            IsoGridSquare isoGridSquare2 = this.square.getAdjacentSquare(IsoDirections.NW);
            IsoGridSquare isoGridSquare3 = this.square.getAdjacentSquare(IsoDirections.N);
            IsoGridSquare isoGridSquare4 = this.square.getAdjacentSquare(IsoDirections.SW);
            IsoGridSquare isoGridSquare5 = this.square.getAdjacentSquare(IsoDirections.S);
            IsoGridSquare isoGridSquare6 = this.square.getAdjacentSquare(IsoDirections.SE);
            IsoGridSquare isoGridSquare7 = this.square.getAdjacentSquare(IsoDirections.E);
            IsoGridSquare isoGridSquare8 = this.square.getAdjacentSquare(IsoDirections.NE);
            if (isoGridSquare == null || isoGridSquare3 == null || isoGridSquare5 == null || isoGridSquare7 == null || isoGridSquare2 == null || isoGridSquare8 == null || isoGridSquare4 == null || isoGridSquare6 == null || !isoGridSquare.getProperties().Is(IsoFlagType.exterior) && !isoGridSquare3.getProperties().Is(IsoFlagType.exterior) && !isoGridSquare5.getProperties().Is(IsoFlagType.exterior) && !isoGridSquare7.getProperties().Is(IsoFlagType.exterior)) {
                return false;
            }
            if (!this.square.getProperties().Is(IsoFlagType.collideW) && isoGridSquare.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[0] = 0.0f;
                this.pnon[1] = 0.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (!isoGridSquare5.getProperties().Is(IsoFlagType.collideN) && isoGridSquare5.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[1] = 0.0f;
                this.pnon[2] = 0.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (!isoGridSquare7.getProperties().Is(IsoFlagType.collideW) && isoGridSquare7.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[2] = 0.0f;
                this.pnon[3] = 0.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (!this.square.getProperties().Is(IsoFlagType.collideN) && isoGridSquare3.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[3] = 0.0f;
                this.pnon[0] = 0.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare3.getProperties().Is(IsoFlagType.collideW) || !isoGridSquare2.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[0] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare5.getProperties().Is(IsoFlagType.collideW) || !isoGridSquare4.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[1] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare4.getProperties().Is(IsoFlagType.collideN) || !isoGridSquare4.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[1] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare6.getProperties().Is(IsoFlagType.collideN) || !isoGridSquare6.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[2] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare6.getProperties().Is(IsoFlagType.collideW) || !isoGridSquare6.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[2] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare8.getProperties().Is(IsoFlagType.collideW) || !isoGridSquare8.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[3] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare7.getProperties().Is(IsoFlagType.collideN) || !isoGridSquare8.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[3] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            if (isoGridSquare.getProperties().Is(IsoFlagType.collideN) || !isoGridSquare2.getProperties().Is(IsoFlagType.exterior)) {
                this.pnon[0] = 1.0f;
                for (n2 = 0; n2 < 4; ++n2) {
                    this.pda[n2] = 1.0f;
                }
            }
            this.interiorCalc = true;
            for (n2 = 0; n2 < 4; ++n2) {
                if (!(this.pdne[n2] + this.pdnw[n2] + this.pda[n2] + this.pnon[n2] > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateLighting(int n) {
        this.setLightingAtVert(0, this.square.getVertLight(0, n));
        this.setLightingAtVert(1, this.square.getVertLight(3, n));
        this.setLightingAtVert(2, this.square.getVertLight(2, n));
        this.setLightingAtVert(3, this.square.getVertLight(1, n));
    }

    private void setLightingAtVert(int n, int n2) {
        this.color[n] = n2;
    }
}

