/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.List;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPuddles;
import zombie.iso.IsoUtils;
import zombie.popman.ObjectPool;

public final class IsoPuddlesCompute {
    private static final float Pi = 3.1415f;
    private static float puddlesDirNE;
    private static float puddlesDirNW;
    private static float puddlesDirAll;
    private static float puddlesDirNone;
    private static float puddlesSize;
    private static boolean hd_quality;
    private static final Vector2f add;
    private static final Vector3f add_xyy;
    private static final Vector3f add_xxy;
    private static final Vector3f add_xxx;
    private static final Vector3f add_xyx;
    private static final Vector3f add_yxy;
    private static final Vector3f add_yyx;
    private static final Vector3f add_yxx;
    private static final Vector3f HashVector31;
    private static final Vector3f HashVector32;
    private static final ObjectPool<Vector3f> pool_vector3f;
    private static final ArrayList<Vector3f> allocated_vector3f;
    private static final Vector2f temp_vector2f;

    private static Vector3f allocVector3f(float f, float f2, float f3) {
        Vector3f vector3f = pool_vector3f.alloc().set(f, f2, f3);
        allocated_vector3f.add(vector3f);
        return vector3f;
    }

    private static Vector3f allocVector3f(Vector3f vector3f) {
        return IsoPuddlesCompute.allocVector3f(vector3f.x, vector3f.y, vector3f.z);
    }

    private static Vector3f floor(Vector3f vector3f) {
        return IsoPuddlesCompute.allocVector3f((float)Math.floor(vector3f.x), (float)Math.floor(vector3f.y), (float)Math.floor(vector3f.z));
    }

    private static Vector3f fract(Vector3f vector3f) {
        return IsoPuddlesCompute.allocVector3f(IsoPuddlesCompute.fract(vector3f.x), IsoPuddlesCompute.fract(vector3f.y), IsoPuddlesCompute.fract(vector3f.z));
    }

    private static float fract(float f) {
        return (float)((double)f - Math.floor(f));
    }

    private static float mix(float f, float f2, float f3) {
        return f * (1.0f - f3) + f2 * f3;
    }

    private static float FuncHash(Vector3f vector3f) {
        Vector3f vector3f2 = IsoPuddlesCompute.allocVector3f(vector3f.dot(HashVector31), vector3f.dot(HashVector32), 0.0f);
        return IsoPuddlesCompute.fract((float)(Math.sin((double)vector3f2.x * 2.1 + 1.1) + Math.sin((double)vector3f2.y * 2.5 + 1.5)));
    }

    private static float FuncNoise(Vector3f vector3f) {
        Vector3f vector3f2 = IsoPuddlesCompute.floor(vector3f);
        Vector3f vector3f3 = IsoPuddlesCompute.fract(vector3f);
        Vector3f vector3f4 = IsoPuddlesCompute.allocVector3f(vector3f3.x * vector3f3.x * (4.5f - 3.5f * vector3f3.x), vector3f3.y * vector3f3.y * (4.5f - 3.5f * vector3f3.y), vector3f3.z * vector3f3.z * (4.5f - 3.5f * vector3f3.z));
        float f = IsoPuddlesCompute.mix(IsoPuddlesCompute.FuncHash(vector3f2), IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_xyy)), vector3f4.x);
        float f2 = IsoPuddlesCompute.mix(IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_yxy)), IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_xxy)), vector3f4.x);
        float f3 = IsoPuddlesCompute.mix(IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_yyx)), IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_xyx)), vector3f4.x);
        float f4 = IsoPuddlesCompute.mix(IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_yxx)), IsoPuddlesCompute.FuncHash(IsoPuddlesCompute.allocVector3f(vector3f2).add(add_xxx)), vector3f4.x);
        float f5 = IsoPuddlesCompute.mix(f, f2, vector3f4.y);
        float f6 = IsoPuddlesCompute.mix(f3, f4, vector3f4.y);
        return IsoPuddlesCompute.mix(f5, f6, vector3f4.z);
    }

    private static float PerlinNoise(Vector3f vector3f) {
        if (hd_quality) {
            vector3f.mul(0.5f);
            float f = 0.5f * IsoPuddlesCompute.FuncNoise(vector3f);
            vector3f.mul(3.0f);
            f = (float)((double)f + 0.25 * (double)IsoPuddlesCompute.FuncNoise(vector3f));
            vector3f.mul(3.0f);
            f = (float)((double)f + 0.125 * (double)IsoPuddlesCompute.FuncNoise(vector3f));
            f = (float)((double)f * Math.min(1.0, 2.0 * (double)IsoPuddlesCompute.FuncNoise(IsoPuddlesCompute.allocVector3f(vector3f).mul(0.02f)) * Math.min(1.0, 1.0 * (double)IsoPuddlesCompute.FuncNoise(IsoPuddlesCompute.allocVector3f(vector3f).mul(0.1f)))));
            return f;
        }
        return IsoPuddlesCompute.FuncNoise(vector3f) * 0.5f;
    }

    private static float getPuddles(Vector2f vector2f) {
        float f = puddlesDirNE;
        float f2 = puddlesDirNW;
        float f3 = puddlesDirAll;
        vector2f.mul(10.0f);
        float f4 = 1.02f * puddlesSize;
        f4 = (float)((double)f4 + (double)f * Math.sin(((double)vector2f.x * 1.0 + (double)vector2f.y * 2.0) * (double)3.1415f * 1.0) * Math.cos(((double)vector2f.x * 1.0 + (double)vector2f.y * 2.0) * (double)3.1415f * 1.0) * 2.0);
        f4 = (float)((double)f4 + (double)f2 * Math.sin(((double)vector2f.x * 1.0 - (double)vector2f.y * 2.0) * (double)3.1415f * 1.0) * Math.cos(((double)vector2f.x * 1.0 - (double)vector2f.y * 2.0) * (double)3.1415f * 1.0) * 2.0);
        f4 = (float)((double)f4 + (double)f3 * 0.3);
        float f5 = IsoPuddlesCompute.PerlinNoise(IsoPuddlesCompute.allocVector3f(vector2f.x * 1.0f, 0.0f, vector2f.y * 2.0f));
        float f6 = Math.min(0.7f, f4 * f5);
        f5 = Math.min(0.7f, IsoPuddlesCompute.PerlinNoise(IsoPuddlesCompute.allocVector3f(vector2f.x * 0.7f, 1.0f, vector2f.y * 0.7f)));
        return f6 + f5;
    }

    public static float computePuddle(IsoGridSquare isoGridSquare) {
        pool_vector3f.release((List<Vector3f>)allocated_vector3f);
        allocated_vector3f.clear();
        boolean bl = hd_quality = PerformanceSettings.PuddlesQuality == 0;
        if (!Core.getInstance().getUseShaders()) {
            return -0.1f;
        }
        if (Core.getInstance().getPerfPuddlesOnLoad() == 3 || Core.getInstance().getPerfPuddles() == 3) {
            return -0.1f;
        }
        if (Core.getInstance().getPerfPuddles() > 0 && isoGridSquare.z > 0) {
            return -0.1f;
        }
        IsoPuddles isoPuddles = IsoPuddles.getInstance();
        puddlesSize = isoPuddles.getPuddlesSize();
        if (puddlesSize <= 0.0f) {
            return -0.1f;
        }
        Vector4f vector4f = isoPuddles.getShaderOffsetMain();
        vector4f.x -= 90000.0f;
        vector4f.y -= 640000.0f;
        int n = (int)IsoCamera.frameState.OffX;
        int n2 = (int)IsoCamera.frameState.OffY;
        float f = IsoUtils.XToScreen((float)isoGridSquare.x + 0.5f - (float)isoGridSquare.z * 3.0f, (float)isoGridSquare.y + 0.5f - (float)isoGridSquare.z * 3.0f, 0.0f, 0) - (float)n;
        float f2 = IsoUtils.YToScreen((float)isoGridSquare.x + 0.5f - (float)isoGridSquare.z * 3.0f, (float)isoGridSquare.y + 0.5f - (float)isoGridSquare.z * 3.0f, 0.0f, 0) - (float)n2;
        f /= (float)IsoCamera.frameState.OffscreenWidth;
        f2 /= (float)IsoCamera.frameState.OffscreenHeight;
        if (Core.getInstance().getPerfPuddles() <= 1) {
            isoGridSquare.getPuddles().recalcIfNeeded();
            puddlesDirNE = (isoGridSquare.getPuddles().pdne[0] + isoGridSquare.getPuddles().pdne[2]) * 0.5f;
            puddlesDirNW = (isoGridSquare.getPuddles().pdnw[0] + isoGridSquare.getPuddles().pdnw[2]) * 0.5f;
            puddlesDirAll = (isoGridSquare.getPuddles().pda[0] + isoGridSquare.getPuddles().pda[2]) * 0.5f;
            puddlesDirNone = (isoGridSquare.getPuddles().pnon[0] + isoGridSquare.getPuddles().pnon[2]) * 0.5f;
        } else {
            puddlesDirNE = 0.0f;
            puddlesDirNW = 0.0f;
            puddlesDirAll = 1.0f;
            puddlesDirNone = 0.0f;
        }
        float f3 = f;
        float f4 = f2;
        Vector2f vector2f = temp_vector2f.set((f3 * vector4f.z + vector4f.x) * 8.0E-4f + (float)isoGridSquare.z * 7.0f, (f4 * vector4f.w + vector4f.y) * 8.0E-4f + (float)isoGridSquare.z * 7.0f);
        float f5 = (float)Math.pow(IsoPuddlesCompute.getPuddles(vector2f), 2.0);
        float f6 = (float)Math.min(Math.pow(f5, 0.3), 1.0) + f5;
        return f6 * puddlesSize - 0.34f;
    }

    static {
        hd_quality = true;
        add = new Vector2f(1.0f, 0.0f);
        add_xyy = new Vector3f(1.0f, 0.0f, 0.0f);
        add_xxy = new Vector3f(1.0f, 1.0f, 0.0f);
        add_xxx = new Vector3f(1.0f, 1.0f, 1.0f);
        add_xyx = new Vector3f(1.0f, 0.0f, 1.0f);
        add_yxy = new Vector3f(0.0f, 1.0f, 0.0f);
        add_yyx = new Vector3f(0.0f, 0.0f, 1.0f);
        add_yxx = new Vector3f(0.0f, 1.0f, 1.0f);
        HashVector31 = new Vector3f(17.1f, 31.7f, 32.6f);
        HashVector32 = new Vector3f(29.5f, 13.3f, 42.6f);
        pool_vector3f = new ObjectPool<Vector3f>(Vector3f::new);
        allocated_vector3f = new ArrayList();
        temp_vector2f = new Vector2f();
    }
}

