/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import org.joml.Vector2f;
import org.joml.Vector4f;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjglx.BufferUtils;
import zombie.GameTime;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.SpriteRenderer;
import zombie.core.opengl.RenderThread;
import zombie.core.opengl.Shader;
import zombie.core.opengl.SharedVertexBufferObjects;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.interfaces.ITexture;
import zombie.iso.IsoCamera;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoPuddlesGeometry;
import zombie.iso.PlayerCamera;
import zombie.iso.PuddlesShader;
import zombie.iso.weather.ClimateManager;
import zombie.network.GameServer;

public final class IsoPuddles {
    public Shader Effect;
    private float PuddlesWindAngle;
    private float PuddlesWindIntensity;
    private float PuddlesTime;
    private final Vector2f PuddlesParamWindINT;
    public static boolean leakingPuddlesInTheRoom = false;
    private Texture texHM;
    private int apiId;
    private static IsoPuddles instance;
    private static boolean isShaderEnable;
    static final int BYTES_PER_FLOAT = 4;
    static final int FLOATS_PER_VERTEX = 7;
    static final int BYTES_PER_VERTEX = 28;
    static final int VERTICES_PER_SQUARE = 4;
    public static final SharedVertexBufferObjects VBOs;
    private final RenderData[][] renderData = new RenderData[3][4];
    private final Vector4f shaderOffset = new Vector4f();
    private final Vector4f shaderOffsetMain = new Vector4f();
    private FloatBuffer floatBuffer = BufferUtils.createFloatBuffer(16);
    public static final int BOOL_MAX = 0;
    public static final int FLOAT_RAIN = 0;
    public static final int FLOAT_WETGROUND = 1;
    public static final int FLOAT_MUDDYPUDDLES = 2;
    public static final int FLOAT_PUDDLESSIZE = 3;
    public static final int FLOAT_RAININTENSITY = 4;
    public static final int FLOAT_MAX = 5;
    private PuddlesFloat rain;
    private PuddlesFloat wetGround;
    private PuddlesFloat muddyPuddles;
    private PuddlesFloat puddlesSize;
    private PuddlesFloat rainIntensity;
    private final PuddlesFloat[] climateFloats = new PuddlesFloat[5];

    public static synchronized IsoPuddles getInstance() {
        if (instance == null) {
            instance = new IsoPuddles();
        }
        return instance;
    }

    public boolean getShaderEnable() {
        return isShaderEnable;
    }

    public IsoPuddles() {
        if (GameServer.bServer) {
            Core.getInstance().setPerfPuddles(3);
            this.applyPuddlesQuality();
            this.PuddlesParamWindINT = new Vector2f(0.0f);
            this.setup();
            return;
        }
        this.texHM = Texture.getSharedTexture("media/textures/puddles_hm.png");
        RenderThread.invokeOnRenderContext(() -> {
            if (GL.getCapabilities().OpenGL30) {
                this.apiId = 1;
            }
            if (GL.getCapabilities().GL_ARB_framebuffer_object) {
                this.apiId = 2;
            }
            if (GL.getCapabilities().GL_EXT_framebuffer_object) {
                this.apiId = 3;
            }
        });
        this.applyPuddlesQuality();
        this.PuddlesParamWindINT = new Vector2f(0.0f);
        for (int i = 0; i < this.renderData.length; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.renderData[i][j] = new RenderData();
            }
        }
        this.setup();
    }

    public void applyPuddlesQuality() {
        boolean bl = leakingPuddlesInTheRoom = Core.getInstance().getPerfPuddles() == 0;
        if (Core.getInstance().getPerfPuddles() == 3) {
            isShaderEnable = false;
        } else {
            isShaderEnable = true;
            if (PerformanceSettings.PuddlesQuality == 2) {
                RenderThread.invokeOnRenderContext(() -> {
                    this.Effect = new PuddlesShader("puddles_lq");
                    this.Effect.Start();
                    this.Effect.End();
                });
            }
            if (PerformanceSettings.PuddlesQuality == 1) {
                RenderThread.invokeOnRenderContext(() -> {
                    this.Effect = new PuddlesShader("puddles_mq");
                    this.Effect.Start();
                    this.Effect.End();
                });
            }
            if (PerformanceSettings.PuddlesQuality == 0) {
                RenderThread.invokeOnRenderContext(() -> {
                    this.Effect = new PuddlesShader("puddles_hq");
                    this.Effect.Start();
                    this.Effect.End();
                });
            }
        }
    }

    public Vector4f getShaderOffset() {
        int n = SpriteRenderer.instance.getRenderingPlayerIndex();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        return this.shaderOffset.set(playerCamera.getOffX() - (float)IsoCamera.getOffscreenLeft(n) * playerCamera.zoom, playerCamera.getOffY() + (float)IsoCamera.getOffscreenTop(n) * playerCamera.zoom, playerCamera.OffscreenWidth, playerCamera.OffscreenHeight);
    }

    public Vector4f getShaderOffsetMain() {
        int n = IsoCamera.frameState.playerIndex;
        PlayerCamera playerCamera = IsoCamera.cameras[n];
        return this.shaderOffsetMain.set(playerCamera.getOffX() - (float)IsoCamera.getOffscreenLeft(n) * playerCamera.zoom, playerCamera.getOffY() + (float)IsoCamera.getOffscreenTop(n) * playerCamera.zoom, IsoCamera.getOffscreenWidth(n), IsoCamera.getOffscreenHeight(n));
    }

    public void render(ArrayList<IsoGridSquare> arrayList, int n) {
        if (!DebugOptions.instance.Weather.WaterPuddles.getValue()) {
            return;
        }
        int n2 = SpriteRenderer.instance.getMainStateIndex();
        int n3 = IsoCamera.frameState.playerIndex;
        RenderData renderData = this.renderData[n2][n3];
        if (n == 0) {
            renderData.clear();
        }
        if (arrayList.isEmpty()) {
            return;
        }
        if (!this.getShaderEnable()) {
            return;
        }
        if (!Core.getInstance().getUseShaders()) {
            return;
        }
        if (Core.getInstance().getPerfPuddles() == 3) {
            return;
        }
        if (n > 0 && Core.getInstance().getPerfPuddles() > 0) {
            return;
        }
        if ((double)this.wetGround.getFinalValue() == 0.0 && (double)this.puddlesSize.getFinalValue() == 0.0) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoPuddlesGeometry isoPuddlesGeometry = arrayList.get(i).getPuddles();
            if (isoPuddlesGeometry == null || !isoPuddlesGeometry.shouldRender()) continue;
            isoPuddlesGeometry.updateLighting(n3);
            renderData.addSquare(n, isoPuddlesGeometry);
        }
        if (renderData.squaresPerLevel[n] <= 0) {
            return;
        }
        SpriteRenderer.instance.drawPuddles(this.Effect, n3, this.apiId, n);
    }

    public void puddlesProjection() {
        int n = SpriteRenderer.instance.getRenderingPlayerIndex();
        PlayerCamera playerCamera = SpriteRenderer.instance.getRenderingPlayerCamera(n);
        GL11.glOrtho((double)playerCamera.getOffX(), (double)(playerCamera.getOffX() + (float)playerCamera.OffscreenWidth), (double)(playerCamera.getOffY() + (float)playerCamera.OffscreenHeight), (double)playerCamera.getOffY(), (double)-1.0, (double)1.0);
    }

    public void puddlesGeometry(int n) {
        int n2;
        int n3;
        int n4 = SpriteRenderer.instance.getRenderStateIndex();
        int n5 = SpriteRenderer.instance.getRenderingPlayerIndex();
        RenderData renderData = this.renderData[n4][n5];
        int n6 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            n6 += renderData.squaresPerLevel[n3];
        }
        for (n3 = renderData.squaresPerLevel[n]; n3 > 0; n3 -= n2) {
            n2 = this.renderSome(n6, n3);
            n6 += n2;
        }
        SpriteRenderer.ringBuffer.restoreVBOs = true;
    }

    private int renderSome(int n, int n2) {
        int n3;
        VBOs.next();
        FloatBuffer floatBuffer = IsoPuddles.VBOs.vertices;
        ShortBuffer shortBuffer = IsoPuddles.VBOs.indices;
        GL13.glActiveTexture((int)33985);
        GL13.glClientActiveTexture((int)33985);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)28, (long)8L);
        GL11.glEnableClientState((int)32888);
        GL13.glActiveTexture((int)33984);
        GL13.glClientActiveTexture((int)33984);
        GL11.glTexCoordPointer((int)2, (int)5126, (int)28, (long)0L);
        GL11.glColorPointer((int)4, (int)5121, (int)28, (long)24L);
        GL11.glVertexPointer((int)2, (int)5126, (int)28, (long)16L);
        int n4 = SpriteRenderer.instance.getRenderStateIndex();
        int n5 = SpriteRenderer.instance.getRenderingPlayerIndex();
        RenderData renderData = this.renderData[n4][n5];
        int n6 = Math.min(n2 * 4, IsoPuddles.VBOs.bufferSizeVertices);
        floatBuffer.put(renderData.data, n * 4 * 7, n6 * 7);
        int n7 = 0;
        int n8 = 0;
        for (n3 = 0; n3 < n6 / 4; ++n3) {
            shortBuffer.put((short)n7);
            shortBuffer.put((short)(n7 + 1));
            shortBuffer.put((short)(n7 + 2));
            shortBuffer.put((short)n7);
            shortBuffer.put((short)(n7 + 2));
            shortBuffer.put((short)(n7 + 3));
            n7 += 4;
            n8 += 6;
        }
        VBOs.unmap();
        n3 = 0;
        int n9 = n7;
        int n10 = 0;
        int n11 = n8;
        GL12.glDrawRangeElements((int)4, (int)n3, (int)(n3 + n9), (int)(n11 - n10), (int)5123, (long)(n10 * 2));
        return n6 / 4;
    }

    public void update(ClimateManager climateManager) {
        this.PuddlesWindAngle = climateManager.getCorrectedWindAngleIntensity();
        this.PuddlesWindIntensity = climateManager.getWindIntensity();
        this.rain.setFinalValue(climateManager.getRainIntensity());
        float f = GameTime.getInstance().getMultiplier() / 1.6f;
        float f2 = 2.0E-5f * f * climateManager.getTemperature();
        float f3 = 2.0E-5f * f;
        float f4 = 2.0E-4f * f;
        float f5 = this.rain.getFinalValue();
        f5 = f5 * f5 * 0.05f * f;
        this.rainIntensity.setFinalValue(this.rain.getFinalValue() * 2.0f);
        this.wetGround.addFinalValue(f5);
        this.muddyPuddles.addFinalValue(f5 * 2.0f);
        this.puddlesSize.addFinalValueForMax(f5 * 0.01f, 0.7f);
        if ((double)f5 == 0.0) {
            this.wetGround.addFinalValue(-f2);
            this.muddyPuddles.addFinalValue(-f4);
        }
        if ((double)this.wetGround.getFinalValue() == 0.0) {
            this.puddlesSize.addFinalValue(-f3);
        }
        this.PuddlesTime += 0.0166f * GameTime.getInstance().getMultiplier();
        this.PuddlesParamWindINT.add((float)Math.sin(this.PuddlesWindAngle * 6.0f) * this.PuddlesWindIntensity * 0.05f, (float)Math.cos(this.PuddlesWindAngle * 6.0f) * this.PuddlesWindIntensity * 0.05f);
    }

    public float getShaderTime() {
        return this.PuddlesTime;
    }

    public float getPuddlesSize() {
        return this.puddlesSize.getFinalValue();
    }

    public ITexture getHMTexture() {
        return this.texHM;
    }

    public FloatBuffer getPuddlesParams(int n) {
        this.floatBuffer.clear();
        this.floatBuffer.put(this.PuddlesParamWindINT.x);
        this.floatBuffer.put(this.muddyPuddles.getFinalValue());
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(this.PuddlesParamWindINT.y);
        this.floatBuffer.put(this.wetGround.getFinalValue());
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(this.PuddlesWindIntensity * 1.0f);
        this.floatBuffer.put(this.puddlesSize.getFinalValue());
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(n);
        this.floatBuffer.put(this.rainIntensity.getFinalValue());
        this.floatBuffer.put(0.0f);
        this.floatBuffer.put(0.0f);
        this.floatBuffer.flip();
        return this.floatBuffer;
    }

    public float getRainIntensity() {
        return this.rainIntensity.getFinalValue();
    }

    public int getFloatMax() {
        return 5;
    }

    public int getBoolMax() {
        return 0;
    }

    public PuddlesFloat getPuddlesFloat(int n) {
        if (n >= 0 && n < 5) {
            return this.climateFloats[n];
        }
        DebugLog.log("ERROR: Climate: cannot get float override id.");
        return null;
    }

    private PuddlesFloat initClimateFloat(int n, String string) {
        if (n >= 0 && n < 5) {
            return this.climateFloats[n].init(n, string);
        }
        DebugLog.log("ERROR: Climate: cannot get float override id.");
        return null;
    }

    private void setup() {
        for (int i = 0; i < this.climateFloats.length; ++i) {
            this.climateFloats[i] = new PuddlesFloat();
        }
        this.rain = this.initClimateFloat(0, "INPUT: RAIN");
        this.wetGround = this.initClimateFloat(1, "Wet Ground");
        this.muddyPuddles = this.initClimateFloat(2, "Muddy Puddles");
        this.puddlesSize = this.initClimateFloat(3, "Puddles Size");
        this.rainIntensity = this.initClimateFloat(4, "Rain Intensity");
    }

    static {
        isShaderEnable = false;
        VBOs = new SharedVertexBufferObjects(28);
    }

    private static final class RenderData {
        final int[] squaresPerLevel = new int[8];
        int numSquares;
        int capacity = 512;
        float[] data;

        RenderData() {
        }

        void clear() {
            this.numSquares = 0;
            Arrays.fill(this.squaresPerLevel, 0);
        }

        void addSquare(int n, IsoPuddlesGeometry isoPuddlesGeometry) {
            int n2 = 4;
            if (this.data == null) {
                this.data = new float[this.capacity * n2 * 7];
            }
            if (this.numSquares + 1 > this.capacity) {
                this.capacity += 128;
                this.data = Arrays.copyOf(this.data, this.capacity * n2 * 7);
            }
            int n3 = this.numSquares * n2 * 7;
            for (int i = 0; i < 4; ++i) {
                this.data[n3++] = isoPuddlesGeometry.pdne[i];
                this.data[n3++] = isoPuddlesGeometry.pdnw[i];
                this.data[n3++] = isoPuddlesGeometry.pda[i];
                this.data[n3++] = isoPuddlesGeometry.pnon[i];
                this.data[n3++] = isoPuddlesGeometry.x[i];
                this.data[n3++] = isoPuddlesGeometry.y[i];
                this.data[n3++] = Float.intBitsToFloat(isoPuddlesGeometry.color[i]);
            }
            ++this.numSquares;
            int n4 = n;
            this.squaresPerLevel[n4] = this.squaresPerLevel[n4] + 1;
        }
    }

    public static class PuddlesFloat {
        protected float finalValue;
        private boolean isAdminOverride = false;
        private float adminValue;
        private float min = 0.0f;
        private float max = 1.0f;
        private float delta = 0.01f;
        private int ID;
        private String name;

        public PuddlesFloat init(int n, String string) {
            this.ID = n;
            this.name = string;
            return this;
        }

        public int getID() {
            return this.ID;
        }

        public String getName() {
            return this.name;
        }

        public float getMin() {
            return this.min;
        }

        public float getMax() {
            return this.max;
        }

        public void setEnableAdmin(boolean bl) {
            this.isAdminOverride = bl;
        }

        public boolean isEnableAdmin() {
            return this.isAdminOverride;
        }

        public void setAdminValue(float f) {
            this.adminValue = Math.max(this.min, Math.min(this.max, f));
        }

        public float getAdminValue() {
            return this.adminValue;
        }

        public void setFinalValue(float f) {
            this.finalValue = Math.max(this.min, Math.min(this.max, f));
        }

        public void addFinalValue(float f) {
            this.finalValue = Math.max(this.min, Math.min(this.max, this.finalValue + f));
        }

        public void addFinalValueForMax(float f, float f2) {
            this.finalValue = Math.max(this.min, Math.min(f2, this.finalValue + f));
        }

        public float getFinalValue() {
            if (this.isAdminOverride) {
                return this.adminValue;
            }
            return this.finalValue;
        }

        public void interpolateFinalValue(float f) {
            this.finalValue = Math.abs(this.finalValue - f) < this.delta ? f : (f > this.finalValue ? (this.finalValue += this.delta) : (this.finalValue -= this.delta));
        }

        private void calculate() {
            if (this.isAdminOverride) {
                this.finalValue = this.adminValue;
                return;
            }
        }
    }
}

