/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.core.PerformanceSettings;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMovingObject;
import zombie.network.GameServer;

public class IsoPhysicsObject
extends IsoMovingObject {
    public float speedMod = 1.0f;
    public float velX = 0.0f;
    public float velY = 0.0f;
    public float velZ = 0.0f;
    public float terminalVelocity = -0.05f;

    public IsoPhysicsObject(IsoCell isoCell) {
        super(isoCell);
        this.solid = false;
        this.shootable = false;
    }

    public void collideGround() {
    }

    public void collideWall() {
    }

    @Override
    public void update() {
        IsoGridSquare isoGridSquare = this.getCurrentSquare();
        super.update();
        if (this.isCollidedThisFrame()) {
            if (this.isCollidedN() || this.isCollidedS()) {
                this.velY = -this.velY;
                this.velY *= 0.5f;
                this.collideWall();
            }
            if (this.isCollidedE() || this.isCollidedW()) {
                this.velX = -this.velX;
                this.velX *= 0.5f;
                this.collideWall();
            }
        }
        int n = GameServer.bServer ? 10 : PerformanceSettings.getLockFPS();
        float f = 30.0f / (float)n;
        float f2 = 0.1f * this.speedMod * f;
        f2 = 1.0f - f2;
        this.velX *= f2;
        this.velY *= f2;
        this.velZ -= 0.005f * f;
        if (this.velZ < this.terminalVelocity) {
            this.velZ = this.terminalVelocity;
        }
        this.setNx(this.getNx() + this.velX * this.speedMod * 0.3f * f);
        this.setNy(this.getNy() + this.velY * this.speedMod * 0.3f * f);
        float f3 = this.getZ();
        this.setZ(this.getZ() + this.velZ * 0.4f * f);
        if (this.getZ() < 0.0f) {
            this.setZ(0.0f);
            this.velZ = -this.velZ * 0.5f;
            this.collideGround();
        }
        if (this.getCurrentSquare() != null && (int)this.getZ() < (int)f3 && (isoGridSquare != null && isoGridSquare.TreatAsSolidFloor() || this.getCurrentSquare().TreatAsSolidFloor())) {
            this.setZ((int)f3);
            this.velZ = -this.velZ * 0.5f;
            this.collideGround();
        }
        if (Math.abs(this.velX) < 1.0E-4f) {
            this.velX = 0.0f;
        }
        if (Math.abs(this.velY) < 1.0E-4f) {
            this.velY = 0.0f;
        }
        if (this.velX + this.velY == 0.0f) {
            this.sprite.Animate = false;
        }
        this.sy = 0.0f;
        this.sx = 0.0f;
    }

    @Override
    public float getGlobalMovementMod(boolean bl) {
        return 1.0f;
    }
}

