/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.SystemDisabler;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.network.GameClient;
import zombie.network.PacketTypes;

public final class IsoObjectSyncRequests {
    public final ArrayList<SyncData> requests = new ArrayList();
    public long timeout = 1000L;

    public void putRequest(IsoGridSquare isoGridSquare, IsoObject isoObject) {
        if (GameClient.bClient) {
            this.putRequest(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, (byte)isoGridSquare.getObjects().indexOf(isoObject));
        }
    }

    public void putRequestLoad(IsoGridSquare isoGridSquare) {
        if (GameClient.bClient) {
            this.putRequest(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, (byte)isoGridSquare.getObjects().size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRequest(int n, int n2, int n3, byte by) {
        if (!SystemDisabler.doObjectStateSyncEnable) {
            return;
        }
        SyncData syncData = new SyncData();
        syncData.x = n;
        syncData.y = n2;
        syncData.z = n3;
        syncData.objIndex = by;
        syncData.reqTime = 0L;
        syncData.reqCount = 0;
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            this.requests.add(syncData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequests(UdpConnection udpConnection) {
        if (!SystemDisabler.doObjectStateSyncEnable) {
            return;
        }
        if (this.requests.size() == 0) {
            return;
        }
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.SyncIsoObjectReq.doPacket(byteBufferWriter);
        ByteBuffer byteBuffer = byteBufferWriter.bb;
        int n = byteBuffer.position();
        byteBufferWriter.putShort((short)0);
        int n2 = 0;
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            for (int i = 0; i < this.requests.size(); ++i) {
                SyncData syncData = this.requests.get(i);
                if (syncData.reqCount > 4) {
                    this.requests.remove(i);
                    --i;
                    continue;
                }
                if (syncData.reqTime == 0L) {
                    syncData.reqTime = System.currentTimeMillis();
                    ++n2;
                    byteBuffer.putInt(syncData.x);
                    byteBuffer.putInt(syncData.y);
                    byteBuffer.putInt(syncData.z);
                    byteBuffer.put(syncData.objIndex);
                    ++syncData.reqCount;
                }
                if (System.currentTimeMillis() - syncData.reqTime >= this.timeout) {
                    syncData.reqTime = System.currentTimeMillis();
                    ++n2;
                    byteBuffer.putInt(syncData.x);
                    byteBuffer.putInt(syncData.y);
                    byteBuffer.putInt(syncData.z);
                    byteBuffer.put(syncData.objIndex);
                    ++syncData.reqCount;
                }
                if (n2 >= 50) break;
            }
        }
        if (n2 == 0) {
            GameClient.connection.cancelPacket();
            return;
        }
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.putShort((short)n2);
        byteBuffer.position(n3);
        PacketTypes.PacketType.SyncIsoObjectReq.send(GameClient.connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveIsoSync(int n, int n2, int n3, byte by) {
        ArrayList<SyncData> arrayList = this.requests;
        synchronized (arrayList) {
            for (int i = 0; i < this.requests.size(); ++i) {
                SyncData syncData = this.requests.get(i);
                if (syncData.x != n || syncData.y != n2 || syncData.z != n3 || syncData.objIndex != by) continue;
                this.requests.remove(i);
            }
        }
    }

    private class SyncData {
        int x;
        int y;
        int z;
        byte objIndex;
        long reqTime;
        int reqCount;

        private SyncData() {
        }
    }
}

