/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.Set;
import zombie.Lua.LuaEventManager;
import zombie.core.math.PZMath;
import zombie.iso.BuildingDef;
import zombie.iso.IsoCamera;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoMetaGrid;
import zombie.iso.LotHeader;
import zombie.iso.RoomDef;
import zombie.iso.objects.IsoMannequin;

public final class IsoMetaCell {
    public final ArrayList<IsoMetaGrid.VehicleZone> vehicleZones = new ArrayList();
    public final IsoMetaChunk[] ChunkMap = new IsoMetaChunk[900];
    public LotHeader info = null;
    public final ArrayList<IsoMetaGrid.Trigger> triggers = new ArrayList();
    private int wx = 0;
    private int wy = 0;
    public final ArrayList<IsoMannequin.MannequinZone> mannequinZones = new ArrayList();
    public final ArrayList<IsoMetaGrid.RoomTone> roomTones = new ArrayList();

    public IsoMetaCell(int n, int n2) {
        this.wx = n;
        this.wy = n2;
        for (int i = 0; i < 900; ++i) {
            this.ChunkMap[i] = new IsoMetaChunk();
        }
    }

    public void addTrigger(BuildingDef buildingDef, int n, int n2, String string) {
        this.triggers.add(new IsoMetaGrid.Trigger(buildingDef, n, n2, string));
    }

    public void checkTriggers() {
        if (IsoCamera.CamCharacter == null) {
            return;
        }
        int n = (int)IsoCamera.CamCharacter.getX();
        int n2 = (int)IsoCamera.CamCharacter.getY();
        for (int i = 0; i < this.triggers.size(); ++i) {
            IsoMetaGrid.Trigger trigger = this.triggers.get(i);
            if (n < trigger.def.x - trigger.triggerRange || n > trigger.def.x2 + trigger.triggerRange || n2 < trigger.def.y - trigger.triggerRange || n2 > trigger.def.y2 + trigger.triggerRange) continue;
            if (!trigger.triggered) {
                LuaEventManager.triggerEvent("OnTriggerNPCEvent", trigger.type, trigger.data, trigger.def);
            }
            LuaEventManager.triggerEvent("OnMultiTriggerNPCEvent", trigger.type, trigger.data, trigger.def);
            trigger.triggered = true;
        }
    }

    public IsoMetaChunk getChunk(int n, int n2) {
        if (n2 >= 30 || n >= 30 || n < 0 || n2 < 0) {
            return null;
        }
        return this.ChunkMap[n2 * 30 + n];
    }

    public void addZone(IsoMetaGrid.Zone zone, int n, int n2) {
        int n3 = zone.x / 10;
        int n4 = zone.y / 10;
        int n5 = (zone.x + zone.w) / 10;
        if ((zone.x + zone.w) % 10 == 0) {
            --n5;
        }
        int n6 = (zone.y + zone.h) / 10;
        if ((zone.y + zone.h) % 10 == 0) {
            --n6;
        }
        n3 = PZMath.clamp(n3, n / 10, (n + 300) / 10);
        n4 = PZMath.clamp(n4, n2 / 10, (n2 + 300) / 10);
        n5 = PZMath.clamp(n5, n / 10, (n + 300) / 10 - 1);
        n6 = PZMath.clamp(n6, n2 / 10, (n2 + 300) / 10 - 1);
        for (int i = n4; i <= n6; ++i) {
            for (int j = n3; j <= n5; ++j) {
                int n7;
                if (!zone.intersects(j * 10, i * 10, zone.z, 10, 10) || this.ChunkMap[n7 = j - n / 10 + (i - n2 / 10) * 30] == null) continue;
                this.ChunkMap[n7].addZone(zone);
            }
        }
    }

    public void removeZone(IsoMetaGrid.Zone zone) {
        int n = (zone.x + zone.w) / 10;
        if ((zone.x + zone.w) % 10 == 0) {
            --n;
        }
        int n2 = (zone.y + zone.h) / 10;
        if ((zone.y + zone.h) % 10 == 0) {
            --n2;
        }
        int n3 = this.wx * 300;
        int n4 = this.wy * 300;
        for (int i = zone.y / 10; i <= n2; ++i) {
            for (int j = zone.x / 10; j <= n; ++j) {
                int n5;
                if (j < n3 / 10 || j >= (n3 + 300) / 10 || i < n4 / 10 || i >= (n4 + 300) / 10 || this.ChunkMap[n5 = j - n3 / 10 + (i - n4 / 10) * 30] == null) continue;
                this.ChunkMap[n5].removeZone(zone);
            }
        }
    }

    public void addRoom(RoomDef roomDef, int n, int n2) {
        int n3 = roomDef.x2 / 10;
        if (roomDef.x2 % 10 == 0) {
            --n3;
        }
        int n4 = roomDef.y2 / 10;
        if (roomDef.y2 % 10 == 0) {
            --n4;
        }
        for (int i = roomDef.y / 10; i <= n4; ++i) {
            for (int j = roomDef.x / 10; j <= n3; ++j) {
                int n5;
                if (j < n / 10 || j >= (n + 300) / 10 || i < n2 / 10 || i >= (n2 + 300) / 10 || this.ChunkMap[n5 = j - n / 10 + (i - n2 / 10) * 30] == null) continue;
                this.ChunkMap[n5].addRoom(roomDef);
            }
        }
    }

    public void getZonesUnique(Set<IsoMetaGrid.Zone> set) {
        for (int i = 0; i < this.ChunkMap.length; ++i) {
            IsoMetaChunk isoMetaChunk = this.ChunkMap[i];
            if (isoMetaChunk == null) continue;
            isoMetaChunk.getZonesUnique(set);
        }
    }

    public void getZonesIntersecting(int n, int n2, int n3, int n4, int n5, ArrayList<IsoMetaGrid.Zone> arrayList) {
        int n6 = (n + n4) / 10;
        if ((n + n4) % 10 == 0) {
            --n6;
        }
        int n7 = (n2 + n5) / 10;
        if ((n2 + n5) % 10 == 0) {
            --n7;
        }
        int n8 = this.wx * 300;
        int n9 = this.wy * 300;
        for (int i = n2 / 10; i <= n7; ++i) {
            for (int j = n / 10; j <= n6; ++j) {
                int n10;
                if (j < n8 / 10 || j >= (n8 + 300) / 10 || i < n9 / 10 || i >= (n9 + 300) / 10 || this.ChunkMap[n10 = j - n8 / 10 + (i - n9 / 10) * 30] == null) continue;
                this.ChunkMap[n10].getZonesIntersecting(n, n2, n3, n4, n5, arrayList);
            }
        }
    }

    public void getRoomsIntersecting(int n, int n2, int n3, int n4, ArrayList<RoomDef> arrayList) {
        int n5 = (n + n3) / 10;
        if ((n + n3) % 10 == 0) {
            --n5;
        }
        int n6 = (n2 + n4) / 10;
        if ((n2 + n4) % 10 == 0) {
            --n6;
        }
        int n7 = this.wx * 300;
        int n8 = this.wy * 300;
        for (int i = n2 / 10; i <= n6; ++i) {
            for (int j = n / 10; j <= n5; ++j) {
                int n9;
                if (j < n7 / 10 || j >= (n7 + 300) / 10 || i < n8 / 10 || i >= (n8 + 300) / 10 || this.ChunkMap[n9 = j - n7 / 10 + (i - n8 / 10) * 30] == null) continue;
                this.ChunkMap[n9].getRoomsIntersecting(n, n2, n3, n4, arrayList);
            }
        }
    }

    public void Dispose() {
        for (int i = 0; i < this.ChunkMap.length; ++i) {
            IsoMetaChunk isoMetaChunk = this.ChunkMap[i];
            if (isoMetaChunk == null) continue;
            isoMetaChunk.Dispose();
            this.ChunkMap[i] = null;
        }
        this.info = null;
        this.mannequinZones.clear();
        this.roomTones.clear();
    }
}

