/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.List;
import se.krka.kahlua.vm.KahluaTable;
import zombie.GameTime;
import zombie.characters.IsoPlayer;
import zombie.core.SpriteRenderer;
import zombie.core.textures.Texture;
import zombie.debug.LineDrawer;
import zombie.iso.IsoCamera;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.network.GameServer;
import zombie.util.Type;

public final class IsoMarkers {
    public static final IsoMarkers instance = new IsoMarkers();
    private static int NextIsoMarkerID = 0;
    private final List<IsoMarker> markers = new ArrayList<IsoMarker>();
    private final List<CircleIsoMarker> circlemarkers = new ArrayList<CircleIsoMarker>();
    private static int NextCircleIsoMarkerID = 0;

    private IsoMarkers() {
    }

    public void init() {
    }

    public void reset() {
        this.markers.clear();
        this.circlemarkers.clear();
    }

    public void update() {
        if (GameServer.bServer) {
            return;
        }
        this.updateIsoMarkers();
        this.updateCircleIsoMarkers();
    }

    private void updateIsoMarkers() {
        int n;
        if (IsoCamera.frameState.playerIndex != 0) {
            return;
        }
        if (this.markers.size() == 0) {
            return;
        }
        for (n = this.markers.size() - 1; n >= 0; --n) {
            if (!this.markers.get(n).isRemoved()) continue;
            if (this.markers.get(n).hasTempSquareObject()) {
                this.markers.get(n).removeTempSquareObjects();
            }
            this.markers.remove(n);
        }
        for (n = 0; n < this.markers.size(); ++n) {
            IsoMarker isoMarker = this.markers.get(n);
            if (isoMarker.alphaInc) {
                isoMarker.alpha += GameTime.getInstance().getMultiplier() * isoMarker.fadeSpeed;
                if (!(isoMarker.alpha > isoMarker.alphaMax)) continue;
                isoMarker.alphaInc = false;
                isoMarker.alpha = isoMarker.alphaMax;
                continue;
            }
            isoMarker.alpha -= GameTime.getInstance().getMultiplier() * isoMarker.fadeSpeed;
            if (!(isoMarker.alpha < isoMarker.alphaMin)) continue;
            isoMarker.alphaInc = true;
            isoMarker.alpha = 0.3f;
        }
    }

    public boolean removeIsoMarker(IsoMarker isoMarker) {
        return this.removeIsoMarker(isoMarker.getID());
    }

    public boolean removeIsoMarker(int n) {
        for (int i = this.markers.size() - 1; i >= 0; --i) {
            if (this.markers.get(i).getID() != n) continue;
            this.markers.get(i).remove();
            this.markers.remove(i);
            return true;
        }
        return false;
    }

    public IsoMarker getIsoMarker(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            if (this.markers.get(i).getID() != n) continue;
            return this.markers.get(i);
        }
        return null;
    }

    public IsoMarker addIsoMarker(String string, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, boolean bl2) {
        if (GameServer.bServer) {
            return null;
        }
        IsoMarker isoMarker = new IsoMarker();
        isoMarker.setSquare(isoGridSquare);
        isoMarker.init(string, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare, bl2);
        isoMarker.setR(f);
        isoMarker.setG(f2);
        isoMarker.setB(f3);
        isoMarker.setA(1.0f);
        isoMarker.setDoAlpha(bl);
        isoMarker.setFadeSpeed(0.006f);
        isoMarker.setAlpha(1.0f);
        isoMarker.setAlphaMin(0.3f);
        isoMarker.setAlphaMax(1.0f);
        this.markers.add(isoMarker);
        return isoMarker;
    }

    public IsoMarker addIsoMarker(KahluaTable kahluaTable, KahluaTable kahluaTable2, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, boolean bl2) {
        return this.addIsoMarker(kahluaTable, kahluaTable2, isoGridSquare, f, f2, f3, bl, bl2, 0.006f, 0.3f, 1.0f);
    }

    public IsoMarker addIsoMarker(KahluaTable kahluaTable, KahluaTable kahluaTable2, IsoGridSquare isoGridSquare, float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5, float f6) {
        if (GameServer.bServer) {
            return null;
        }
        IsoMarker isoMarker = new IsoMarker();
        isoMarker.init(kahluaTable, kahluaTable2, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare, bl2);
        isoMarker.setSquare(isoGridSquare);
        isoMarker.setR(f);
        isoMarker.setG(f2);
        isoMarker.setB(f3);
        isoMarker.setA(1.0f);
        isoMarker.setDoAlpha(bl);
        isoMarker.setFadeSpeed(f4);
        isoMarker.setAlpha(0.0f);
        isoMarker.setAlphaMin(f5);
        isoMarker.setAlphaMax(f6);
        this.markers.add(isoMarker);
        return isoMarker;
    }

    public void renderIsoMarkers(IsoCell.PerPlayerRender perPlayerRender, int n, int n2) {
        if (GameServer.bServer || this.markers.size() == 0) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            IsoMarker isoMarker = this.markers.get(i);
            if (isoMarker.z != (float)n || isoMarker.z != isoPlayer.getZ() || !isoMarker.active) continue;
            for (int j = 0; j < isoMarker.textures.size(); ++j) {
                Texture texture = isoMarker.textures.get(j);
                float f = IsoUtils.XToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffX() - (float)texture.getWidth() / 2.0f;
                float f2 = IsoUtils.YToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffY() - (float)texture.getHeight();
                SpriteRenderer.instance.render(texture, f, f2, texture.getWidth(), texture.getHeight(), isoMarker.r, isoMarker.g, isoMarker.b, isoMarker.alpha, null);
            }
        }
    }

    public void renderIsoMarkersDeferred(IsoCell.PerPlayerRender perPlayerRender, int n, int n2) {
        if (GameServer.bServer || this.markers.size() == 0) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            IsoMarker isoMarker = this.markers.get(i);
            if (isoMarker.z != (float)n || isoMarker.z != isoPlayer.getZ() || !isoMarker.active) continue;
            for (int j = 0; j < isoMarker.overlayTextures.size(); ++j) {
                Texture texture = isoMarker.overlayTextures.get(j);
                float f = IsoUtils.XToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffX() - (float)texture.getWidth() / 2.0f;
                float f2 = IsoUtils.YToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffY() - (float)texture.getHeight();
                SpriteRenderer.instance.render(texture, f, f2, texture.getWidth(), texture.getHeight(), isoMarker.r, isoMarker.g, isoMarker.b, isoMarker.alpha, null);
            }
        }
    }

    public void renderIsoMarkersOnSquare(IsoCell.PerPlayerRender perPlayerRender, int n, int n2) {
        if (GameServer.bServer || this.markers.size() == 0) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < this.markers.size(); ++i) {
            IsoMarker isoMarker = this.markers.get(i);
            if (isoMarker.z != (float)n || isoMarker.z != isoPlayer.getZ() || !isoMarker.active) continue;
            for (int j = 0; j < isoMarker.overlayTextures.size(); ++j) {
                Texture texture = isoMarker.overlayTextures.get(j);
                float f = IsoUtils.XToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffX() - (float)texture.getWidth() / 2.0f;
                float f2 = IsoUtils.YToScreen(isoMarker.x, isoMarker.y, isoMarker.z, 0) - IsoCamera.cameras[n2].getOffY() - (float)texture.getHeight();
                SpriteRenderer.instance.render(texture, f, f2, texture.getWidth(), texture.getHeight(), isoMarker.r, isoMarker.g, isoMarker.b, isoMarker.alpha, null);
            }
        }
    }

    private void updateCircleIsoMarkers() {
        int n;
        if (IsoCamera.frameState.playerIndex != 0) {
            return;
        }
        if (this.circlemarkers.size() == 0) {
            return;
        }
        for (n = this.circlemarkers.size() - 1; n >= 0; --n) {
            if (!this.circlemarkers.get(n).isRemoved()) continue;
            this.circlemarkers.remove(n);
        }
        for (n = 0; n < this.circlemarkers.size(); ++n) {
            CircleIsoMarker circleIsoMarker = this.circlemarkers.get(n);
            if (circleIsoMarker.alphaInc) {
                circleIsoMarker.alpha += GameTime.getInstance().getMultiplier() * circleIsoMarker.fadeSpeed;
                if (!(circleIsoMarker.alpha > circleIsoMarker.alphaMax)) continue;
                circleIsoMarker.alphaInc = false;
                circleIsoMarker.alpha = circleIsoMarker.alphaMax;
                continue;
            }
            circleIsoMarker.alpha -= GameTime.getInstance().getMultiplier() * circleIsoMarker.fadeSpeed;
            if (!(circleIsoMarker.alpha < circleIsoMarker.alphaMin)) continue;
            circleIsoMarker.alphaInc = true;
            circleIsoMarker.alpha = 0.3f;
        }
    }

    public boolean removeCircleIsoMarker(CircleIsoMarker circleIsoMarker) {
        return this.removeCircleIsoMarker(circleIsoMarker.getID());
    }

    public boolean removeCircleIsoMarker(int n) {
        for (int i = this.circlemarkers.size() - 1; i >= 0; --i) {
            if (this.circlemarkers.get(i).getID() != n) continue;
            this.circlemarkers.get(i).remove();
            this.circlemarkers.remove(i);
            return true;
        }
        return false;
    }

    public CircleIsoMarker getCircleIsoMarker(int n) {
        for (int i = 0; i < this.circlemarkers.size(); ++i) {
            if (this.circlemarkers.get(i).getID() != n) continue;
            return this.circlemarkers.get(i);
        }
        return null;
    }

    public CircleIsoMarker addCircleIsoMarker(IsoGridSquare isoGridSquare, float f, float f2, float f3, float f4) {
        if (GameServer.bServer) {
            return null;
        }
        CircleIsoMarker circleIsoMarker = new CircleIsoMarker();
        circleIsoMarker.init(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, isoGridSquare);
        circleIsoMarker.setSquare(isoGridSquare);
        circleIsoMarker.setR(f);
        circleIsoMarker.setG(f2);
        circleIsoMarker.setB(f3);
        circleIsoMarker.setA(f4);
        circleIsoMarker.setDoAlpha(false);
        circleIsoMarker.setFadeSpeed(0.006f);
        circleIsoMarker.setAlpha(1.0f);
        circleIsoMarker.setAlphaMin(1.0f);
        circleIsoMarker.setAlphaMax(1.0f);
        this.circlemarkers.add(circleIsoMarker);
        return circleIsoMarker;
    }

    public void renderCircleIsoMarkers(IsoCell.PerPlayerRender perPlayerRender, int n, int n2) {
        if (GameServer.bServer || this.circlemarkers.size() == 0) {
            return;
        }
        IsoPlayer isoPlayer = IsoPlayer.players[n2];
        if (isoPlayer == null) {
            return;
        }
        for (int i = 0; i < this.circlemarkers.size(); ++i) {
            CircleIsoMarker circleIsoMarker = this.circlemarkers.get(i);
            if (circleIsoMarker.z != (float)n || circleIsoMarker.z != isoPlayer.getZ() || !circleIsoMarker.active) continue;
            LineDrawer.DrawIsoCircle(circleIsoMarker.x, circleIsoMarker.y, circleIsoMarker.z, circleIsoMarker.size, 32, circleIsoMarker.r, circleIsoMarker.g, circleIsoMarker.b, circleIsoMarker.a);
        }
    }

    public void render() {
        this.update();
    }

    public static final class IsoMarker {
        private int ID;
        private ArrayList<Texture> textures = new ArrayList();
        private ArrayList<Texture> overlayTextures = new ArrayList();
        private ArrayList<IsoObject> tempObjects = new ArrayList();
        private IsoGridSquare square;
        private float x;
        private float y;
        private float z;
        private float r;
        private float g;
        private float b;
        private float a;
        private boolean doAlpha;
        private float fadeSpeed = 0.006f;
        private float alpha = 0.0f;
        private float alphaMax = 1.0f;
        private float alphaMin = 0.3f;
        private boolean alphaInc = true;
        private boolean active = true;
        private boolean isRemoved = false;

        public IsoMarker() {
            this.ID = NextIsoMarkerID++;
        }

        public int getID() {
            return this.ID;
        }

        public void remove() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public void init(KahluaTable kahluaTable, KahluaTable kahluaTable2, int n, int n2, int n3, IsoGridSquare isoGridSquare) {
            Texture texture;
            String string;
            int n4;
            int n5;
            this.square = isoGridSquare;
            if (kahluaTable != null) {
                n5 = kahluaTable.len();
                for (n4 = 1; n4 <= n5; ++n4) {
                    string = Type.tryCastTo(kahluaTable.rawget(n4), String.class);
                    texture = Texture.trygetTexture(string);
                    if (texture == null) continue;
                    this.textures.add(texture);
                    this.setPos(n, n2, n3);
                }
            }
            if (kahluaTable2 != null) {
                n5 = kahluaTable2.len();
                for (n4 = 1; n4 <= n5; ++n4) {
                    string = Type.tryCastTo(kahluaTable2.rawget(n4), String.class);
                    texture = Texture.trygetTexture(string);
                    if (texture == null) continue;
                    this.overlayTextures.add(texture);
                    this.setPos(n, n2, n3);
                }
            }
        }

        public void init(KahluaTable kahluaTable, KahluaTable kahluaTable2, int n, int n2, int n3, IsoGridSquare isoGridSquare, boolean bl) {
            this.square = isoGridSquare;
            if (bl) {
                if (kahluaTable != null) {
                    int n4 = kahluaTable.len();
                    for (int i = 1; i <= n4; ++i) {
                        String string = Type.tryCastTo(kahluaTable.rawget(i), String.class);
                        Texture texture = Texture.trygetTexture(string);
                        if (texture == null) continue;
                        IsoObject isoObject = new IsoObject(isoGridSquare.getCell(), isoGridSquare, texture.getName());
                        this.tempObjects.add(isoObject);
                        this.addTempSquareObject(isoObject);
                        this.setPos(n, n2, n3);
                    }
                }
            } else {
                this.init(kahluaTable, kahluaTable2, n, n2, n3, isoGridSquare);
            }
        }

        public void init(String string, int n, int n2, int n3, IsoGridSquare isoGridSquare, boolean bl) {
            this.square = isoGridSquare;
            if (bl && string != null) {
                IsoObject isoObject = IsoObject.getNew(isoGridSquare, string, string, false);
                this.tempObjects.add(isoObject);
                this.addTempSquareObject(isoObject);
                this.setPos(n, n2, n3);
            }
        }

        public boolean hasTempSquareObject() {
            return this.tempObjects.size() > 0;
        }

        public void addTempSquareObject(IsoObject isoObject) {
            this.square.localTemporaryObjects.add(isoObject);
        }

        public void removeTempSquareObjects() {
            this.square.localTemporaryObjects.clear();
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }

        public float getA() {
            return this.a;
        }

        public void setR(float f) {
            this.r = f;
        }

        public void setG(float f) {
            this.g = f;
        }

        public void setB(float f) {
            this.b = f;
        }

        public void setA(float f) {
            this.a = f;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getAlphaMax() {
            return this.alphaMax;
        }

        public void setAlphaMax(float f) {
            this.alphaMax = f;
        }

        public float getAlphaMin() {
            return this.alphaMin;
        }

        public void setAlphaMin(float f) {
            this.alphaMin = f;
        }

        public boolean isDoAlpha() {
            return this.doAlpha;
        }

        public void setDoAlpha(boolean bl) {
            this.doAlpha = bl;
        }

        public float getFadeSpeed() {
            return this.fadeSpeed;
        }

        public void setFadeSpeed(float f) {
            this.fadeSpeed = f;
        }

        public IsoGridSquare getSquare() {
            return this.square;
        }

        public void setSquare(IsoGridSquare isoGridSquare) {
            this.square = isoGridSquare;
        }

        public void setPos(int n, int n2, int n3) {
            this.x = (float)n + 0.5f;
            this.y = (float)n2 + 0.5f;
            this.z = n3;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }
    }

    public static final class CircleIsoMarker {
        private int ID = NextCircleIsoMarkerID++;
        private IsoGridSquare square;
        private float x;
        private float y;
        private float z;
        private float r;
        private float g;
        private float b;
        private float a;
        private float size;
        private boolean doAlpha;
        private float fadeSpeed = 0.006f;
        private float alpha = 0.0f;
        private float alphaMax = 1.0f;
        private float alphaMin = 0.3f;
        private boolean alphaInc = true;
        private boolean active = true;
        private boolean isRemoved = false;

        public int getID() {
            return this.ID;
        }

        public void remove() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }

        public void init(int n, int n2, int n3, IsoGridSquare isoGridSquare) {
            this.square = isoGridSquare;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float getZ() {
            return this.z;
        }

        public float getR() {
            return this.r;
        }

        public float getG() {
            return this.g;
        }

        public float getB() {
            return this.b;
        }

        public float getA() {
            return this.a;
        }

        public void setR(float f) {
            this.r = f;
        }

        public void setG(float f) {
            this.g = f;
        }

        public void setB(float f) {
            this.b = f;
        }

        public void setA(float f) {
            this.a = f;
        }

        public float getSize() {
            return this.size;
        }

        public void setSize(float f) {
            this.size = f;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getAlphaMax() {
            return this.alphaMax;
        }

        public void setAlphaMax(float f) {
            this.alphaMax = f;
        }

        public float getAlphaMin() {
            return this.alphaMin;
        }

        public void setAlphaMin(float f) {
            this.alphaMin = f;
        }

        public boolean isDoAlpha() {
            return this.doAlpha;
        }

        public void setDoAlpha(boolean bl) {
            this.doAlpha = bl;
        }

        public float getFadeSpeed() {
            return this.fadeSpeed;
        }

        public void setFadeSpeed(float f) {
            this.fadeSpeed = f;
        }

        public IsoGridSquare getSquare() {
            return this.square;
        }

        public void setSquare(IsoGridSquare isoGridSquare) {
            this.square = isoGridSquare;
        }

        public void setPos(int n, int n2, int n3) {
            this.x = n;
            this.y = n2;
            this.z = n3;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean bl) {
            this.active = bl;
        }
    }
}

