/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import zombie.GameTime;
import zombie.iso.IsoChunk;
import zombie.iso.sprite.IsoSprite;

public class IsoFloorBloodSplat {
    public static final float FADE_HOURS = 72.0f;
    public static HashMap<String, IsoSprite> SpriteMap = new HashMap();
    public static String[] FloorBloodTypes = new String[]{"blood_floor_small_01", "blood_floor_small_02", "blood_floor_small_03", "blood_floor_small_04", "blood_floor_small_05", "blood_floor_small_06", "blood_floor_small_07", "blood_floor_small_08", "blood_floor_med_01", "blood_floor_med_02", "blood_floor_med_03", "blood_floor_med_04", "blood_floor_med_05", "blood_floor_med_06", "blood_floor_med_07", "blood_floor_med_08", "blood_floor_large_01", "blood_floor_large_02", "blood_floor_large_03", "blood_floor_large_04", "blood_floor_large_05"};
    public float x;
    public float y;
    public float z;
    public int Type;
    public float worldAge;
    public int index;
    public int fade;
    IsoChunk chunk;

    public IsoFloorBloodSplat() {
    }

    public IsoFloorBloodSplat(float f, float f2, float f3, int n, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.Type = n;
        this.worldAge = f4;
    }

    public void save(ByteBuffer byteBuffer) {
        int n;
        int n2;
        int n3 = (int)(this.x / 10.0f * 255.0f);
        if (n3 < 0) {
            n3 = 0;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        if ((n2 = (int)(this.y / 10.0f * 255.0f)) < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if ((n = (int)(this.z / 8.0f * 255.0f)) < 0) {
            n = 0;
        }
        if (n > 255) {
            n = 255;
        }
        byteBuffer.put((byte)n3);
        byteBuffer.put((byte)n2);
        byteBuffer.put((byte)n);
        byteBuffer.put((byte)this.Type);
        byteBuffer.putFloat(this.worldAge);
        byteBuffer.put((byte)this.index);
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        if (n >= 65) {
            this.x = (float)(byteBuffer.get() & 0xFF) / 255.0f * 10.0f;
            this.y = (float)(byteBuffer.get() & 0xFF) / 255.0f * 10.0f;
            this.z = (float)(byteBuffer.get() & 0xFF) / 255.0f * 8.0f;
            this.Type = byteBuffer.get();
            this.worldAge = byteBuffer.getFloat();
            if (n >= 73) {
                this.index = byteBuffer.get();
            }
        } else {
            this.x = byteBuffer.getFloat();
            this.y = byteBuffer.getFloat();
            this.z = byteBuffer.getFloat();
            this.Type = byteBuffer.getInt();
            this.worldAge = (float)GameTime.getInstance().getWorldAgeHours();
        }
    }
}

