/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.list.array.TIntArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.invoke.StringConcatFactory;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import zombie.ChunkMapFilenames;
import zombie.FliesSound;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.LoadGridsquarePerformanceWorkaround;
import zombie.LootRespawn;
import zombie.Lua.LuaEventManager;
import zombie.Lua.MapObjects;
import zombie.MapCollisionData;
import zombie.ReanimatedPlayers;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.VirtualZombieManager;
import zombie.WorldSoundManager;
import zombie.ZombieSpawnRecorder;
import zombie.ZomboidFileSystem;
import zombie.audio.ObjectAmbientEmitters;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.IsoSurvivor;
import zombie.characters.IsoZombie;
import zombie.core.Core;
import zombie.core.PerformanceSettings;
import zombie.core.Rand;
import zombie.core.logger.ExceptionLogger;
import zombie.core.logger.LoggerManager;
import zombie.core.math.PZMath;
import zombie.core.network.ByteBufferWriter;
import zombie.core.physics.Bullet;
import zombie.core.physics.WorldSimulation;
import zombie.core.properties.PropertyContainer;
import zombie.core.raknet.UdpConnection;
import zombie.core.stash.StashSystem;
import zombie.core.utils.BoundedQueue;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.debug.DebugType;
import zombie.erosion.ErosionData;
import zombie.erosion.ErosionMain;
import zombie.globalObjects.SGlobalObjects;
import zombie.iso.CellLoader;
import zombie.iso.IsoCell;
import zombie.iso.IsoChunkMap;
import zombie.iso.IsoDirections;
import zombie.iso.IsoFloorBloodSplat;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoLot;
import zombie.iso.IsoMetaCell;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoMovingObject;
import zombie.iso.IsoObject;
import zombie.iso.IsoRoomLight;
import zombie.iso.IsoWorld;
import zombie.iso.LosUtil;
import zombie.iso.LotHeader;
import zombie.iso.NearestWalls;
import zombie.iso.RoomDef;
import zombie.iso.SpriteDetails.IsoFlagType;
import zombie.iso.SpriteDetails.IsoObjectType;
import zombie.iso.Vector2;
import zombie.iso.WorldReuserThread;
import zombie.iso.areas.IsoBuilding;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoDoor;
import zombie.iso.objects.IsoGenerator;
import zombie.iso.objects.IsoLightSwitch;
import zombie.iso.objects.IsoThumpable;
import zombie.iso.objects.IsoTree;
import zombie.iso.objects.IsoWindow;
import zombie.iso.objects.RainManager;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.network.ChunkChecksum;
import zombie.network.ClientChunkRequest;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.MPStatistics;
import zombie.network.PacketTypes;
import zombie.network.ServerMap;
import zombie.network.ServerOptions;
import zombie.popman.ZombiePopulationManager;
import zombie.randomizedWorld.randomizedBuilding.RandomizedBuildingBase;
import zombie.randomizedWorld.randomizedVehicleStory.RandomizedVehicleStoryBase;
import zombie.randomizedWorld.randomizedVehicleStory.VehicleStorySpawnData;
import zombie.randomizedWorld.randomizedZoneStory.RandomizedZoneStoryBase;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.VehicleScript;
import zombie.util.StringUtils;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.CollideWithObstaclesPoly;
import zombie.vehicles.PolygonalMap2;
import zombie.vehicles.VehicleType;
import zombie.vehicles.VehiclesDB2;

public final class IsoChunk {
    public static boolean bDoServerRequests = true;
    public int wx = 0;
    public int wy = 0;
    public final IsoGridSquare[][] squares;
    public FliesSound.ChunkData corpseData;
    public final NearestWalls.ChunkData nearestWalls = new NearestWalls.ChunkData();
    private ArrayList<IsoGameCharacter.Location> generatorsTouchingThisChunk;
    public int maxLevel = -1;
    public final ArrayList<WorldSoundManager.WorldSound> SoundList = new ArrayList();
    private int m_treeCount = 0;
    private int m_numberOfWaterTiles = 0;
    private IsoMetaGrid.Zone m_scavengeZone = null;
    private final TIntArrayList m_spawnedRooms = new TIntArrayList();
    public IsoChunk next;
    public final CollideWithObstaclesPoly.ChunkData collision = new CollideWithObstaclesPoly.ChunkData();
    public int m_adjacentChunkLoadedCounter = 0;
    public VehicleStorySpawnData m_vehicleStorySpawnData;
    public Object m_loadVehiclesObject = null;
    public final ObjectAmbientEmitters.ChunkData m_objectEmitterData = new ObjectAmbientEmitters.ChunkData();
    public JobType jobType = JobType.None;
    public LotHeader lotheader;
    public final BoundedQueue<IsoFloorBloodSplat> FloorBloodSplats = new BoundedQueue(1000);
    public final ArrayList<IsoFloorBloodSplat> FloorBloodSplatsFade = new ArrayList();
    private static final int MAX_BLOOD_SPLATS = 1000;
    private int nextSplatIndex;
    public static final byte[][] renderByIndex = new byte[][]{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 0}, {1, 0, 0, 1, 0, 1, 0, 0, 1, 0}, {1, 0, 1, 0, 1, 0, 1, 0, 1, 0}, {1, 1, 0, 1, 1, 0, 1, 1, 0, 0}, {1, 1, 0, 1, 1, 0, 1, 1, 0, 1}, {1, 1, 1, 1, 0, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 0}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}};
    public final ArrayList<IsoChunkMap> refs = new ArrayList();
    public boolean bLoaded;
    private boolean blam;
    private boolean addZombies;
    private boolean bFixed2x;
    public final boolean[] lightCheck = new boolean[4];
    public final boolean[] bLightingNeverDone = new boolean[4];
    public final ArrayList<IsoRoomLight> roomLights = new ArrayList();
    public final ArrayList<BaseVehicle> vehicles = new ArrayList();
    public int lootRespawnHour = -1;
    private long hashCodeObjects;
    public int ObjectsSyncCount = 0;
    private static int AddVehicles_ForTest_vtype = 0;
    private static int AddVehicles_ForTest_vskin = 0;
    private static int AddVehicles_ForTest_vrot = 0;
    private static final ArrayList<BaseVehicle> BaseVehicleCheckedVehicles = new ArrayList();
    protected boolean physicsCheck = false;
    private static final int MAX_SHAPES = 4;
    private final PhysicsShapes[] shapes = new PhysicsShapes[4];
    private static final byte[] bshapes = new byte[4];
    private static final ChunkGetter chunkGetter = new ChunkGetter();
    private boolean loadedPhysics = false;
    public final Object vehiclesForAddToWorldLock = new Object();
    public ArrayList<BaseVehicle> vehiclesForAddToWorld = null;
    public static final ConcurrentLinkedQueue<IsoChunk> loadGridSquare = new ConcurrentLinkedQueue();
    private static final int BLOCK_SIZE = 65536;
    private static ByteBuffer SliceBuffer = ByteBuffer.allocate(65536);
    private static ByteBuffer SliceBufferLoad = ByteBuffer.allocate(65536);
    public static final Object WriteLock = new Object();
    private static final ArrayList<RoomDef> tempRoomDefs = new ArrayList();
    private static final ArrayList<IsoBuilding> tempBuildings = new ArrayList();
    private static final ArrayList<ChunkLock> Locks = new ArrayList();
    private static final Stack<ChunkLock> FreeLocks = new Stack();
    private static final SanityCheck sanityCheck = new SanityCheck();
    private static final CRC32 crcLoad = new CRC32();
    private static final CRC32 crcSave = new CRC32();
    private static String prefix = "map_";
    private ErosionData.Chunk erosion;
    private static final HashMap<String, String> Fix2xMap = new HashMap();
    public int randomID;
    public long revision;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSounds() {
        ArrayList<WorldSoundManager.WorldSound> arrayList = WorldSoundManager.instance.SoundList;
        synchronized (arrayList) {
            int n = this.SoundList.size();
            for (int i = 0; i < n; ++i) {
                WorldSoundManager.WorldSound worldSound = this.SoundList.get(i);
                if (worldSound != null && worldSound.life > 0) continue;
                this.SoundList.remove(i);
                --i;
                --n;
            }
        }
    }

    public IsoChunk(IsoCell isoCell) {
        this.squares = new IsoGridSquare[8][100];
        for (int i = 0; i < 4; ++i) {
            this.lightCheck[i] = true;
            this.bLightingNeverDone[i] = true;
        }
        MPStatistics.increaseRelevantChunk();
    }

    @Deprecated
    public long getHashCodeObjects() {
        this.recalcHashCodeObjects();
        return this.hashCodeObjects;
    }

    @Deprecated
    public void recalcHashCodeObjects() {
        long l;
        this.hashCodeObjects = l = 0L;
    }

    @Deprecated
    public int hashCodeNoOverride() {
        return (int)this.hashCodeObjects;
    }

    public void addBloodSplat(float f, float f2, float f3, int n) {
        if (f < (float)(this.wx * 10) || f >= (float)((this.wx + 1) * 10)) {
            return;
        }
        if (f2 < (float)(this.wy * 10) || f2 >= (float)((this.wy + 1) * 10)) {
            return;
        }
        IsoGridSquare isoGridSquare = this.getGridSquare((int)(f - (float)(this.wx * 10)), (int)(f2 - (float)(this.wy * 10)), (int)f3);
        if (isoGridSquare != null && isoGridSquare.isSolidFloor()) {
            IsoFloorBloodSplat isoFloorBloodSplat = new IsoFloorBloodSplat(f - (float)(this.wx * 10), f2 - (float)(this.wy * 10), f3, n, (float)GameTime.getInstance().getWorldAgeHours());
            if (n < 8) {
                isoFloorBloodSplat.index = ++this.nextSplatIndex;
                if (this.nextSplatIndex >= 10) {
                    this.nextSplatIndex = 0;
                }
            }
            if (this.FloorBloodSplats.isFull()) {
                IsoFloorBloodSplat isoFloorBloodSplat2 = this.FloorBloodSplats.removeFirst();
                isoFloorBloodSplat2.fade = PerformanceSettings.getLockFPS() * 5;
                this.FloorBloodSplatsFade.add(isoFloorBloodSplat2);
            }
            this.FloorBloodSplats.add(isoFloorBloodSplat);
        }
    }

    public void AddCorpses(int n, int n2) {
        if (IsoWorld.getZombiesDisabled() || "Tutorial".equals(Core.GameMode)) {
            return;
        }
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(n, n2);
        if (isoMetaChunk != null) {
            float f = isoMetaChunk.getZombieIntensity();
            f *= 0.1f;
            int n3 = 0;
            if (f < 1.0f) {
                if ((float)Rand.Next(100) < f * 100.0f) {
                    n3 = 1;
                }
            } else {
                n3 = Rand.Next(0, (int)f);
            }
            if (n3 > 0) {
                int n4;
                int n5;
                IsoGridSquare isoGridSquare = null;
                int n6 = 0;
                do {
                    n5 = Rand.Next(10);
                    n4 = Rand.Next(10);
                    isoGridSquare = this.getGridSquare(n5, n4, 0);
                } while (++n6 < 100 && (isoGridSquare == null || !RandomizedBuildingBase.is2x2AreaClear(isoGridSquare)));
                if (n6 == 100) {
                    return;
                }
                if (isoGridSquare != null) {
                    n5 = 14;
                    if (Rand.Next(10) == 0) {
                        n5 = 50;
                    }
                    if (Rand.Next(40) == 0) {
                        n5 = 100;
                    }
                    for (n4 = 0; n4 < n5; n4 += 1) {
                        float f2 = (float)Rand.Next(3000) / 1000.0f;
                        float f3 = (float)Rand.Next(3000) / 1000.0f;
                        this.addBloodSplat((float)isoGridSquare.getX() + (f2 -= 1.5f), (float)isoGridSquare.getY() + (f3 -= 1.5f), isoGridSquare.getZ(), Rand.Next(20));
                    }
                    n4 = Rand.Next(15 - SandboxOptions.instance.TimeSinceApo.getValue()) == 0 ? 1 : 0;
                    VirtualZombieManager.instance.choices.clear();
                    VirtualZombieManager.instance.choices.add(isoGridSquare);
                    IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(Rand.Next(8), false);
                    isoZombie.setX(isoGridSquare.x);
                    isoZombie.setY(isoGridSquare.y);
                    isoZombie.setFakeDead(false);
                    isoZombie.setHealth(0.0f);
                    isoZombie.upKillCount = false;
                    if (!n4) {
                        isoZombie.dressInRandomOutfit();
                        for (int i = 0; i < 10; ++i) {
                            isoZombie.addHole(null);
                            isoZombie.addBlood(null, false, true, false);
                            isoZombie.addDirt(null, null, false);
                        }
                        isoZombie.DoCorpseInventory();
                    }
                    isoZombie.setSkeleton(n4 != 0);
                    if (n4) {
                        isoZombie.getHumanVisual().setSkinTextureIndex(2);
                    }
                    IsoDeadBody isoDeadBody = new IsoDeadBody(isoZombie, true);
                    if (!n4 && Rand.Next(3) == 0) {
                        VirtualZombieManager.instance.createEatingZombies(isoDeadBody, Rand.Next(1, 4));
                    } else if (!n4 && Rand.Next(10) == 0) {
                        isoDeadBody.setFakeDead(true);
                        if (Rand.Next(5) == 0) {
                            isoDeadBody.setCrawling(true);
                        }
                    }
                }
            }
        }
    }

    public void AddBlood(int n, int n2) {
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(n, n2);
        if (isoMetaChunk != null) {
            float f = isoMetaChunk.getZombieIntensity();
            f *= 0.1f;
            if (Rand.Next(40) == 0) {
                f += 10.0f;
            }
            int n3 = 0;
            if (f < 1.0f) {
                if ((float)Rand.Next(100) < f * 100.0f) {
                    n3 = 1;
                }
            } else {
                n3 = Rand.Next(0, (int)f);
            }
            if (n3 > 0) {
                VirtualZombieManager.instance.AddBloodToMap(n3, this);
            }
        }
    }

    private void checkVehiclePos(BaseVehicle baseVehicle, IsoChunk isoChunk) {
        this.fixVehiclePos(baseVehicle, isoChunk);
        IsoDirections isoDirections = baseVehicle.getDir();
        switch (isoDirections) {
            case E: 
            case W: {
                IsoGridSquare isoGridSquare;
                if (baseVehicle.x - (float)(isoChunk.wx * 10) < baseVehicle.getScript().getExtents().x) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(baseVehicle.x - baseVehicle.getScript().getExtents().x, baseVehicle.y, baseVehicle.z);
                    if (isoGridSquare == null) {
                        return;
                    }
                    this.fixVehiclePos(baseVehicle, isoGridSquare.chunk);
                }
                if (!(baseVehicle.x - (float)(isoChunk.wx * 10) > 10.0f - baseVehicle.getScript().getExtents().x)) break;
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(baseVehicle.x + baseVehicle.getScript().getExtents().x, baseVehicle.y, baseVehicle.z);
                if (isoGridSquare == null) {
                    return;
                }
                this.fixVehiclePos(baseVehicle, isoGridSquare.chunk);
                break;
            }
            case N: 
            case S: {
                IsoGridSquare isoGridSquare;
                if (baseVehicle.y - (float)(isoChunk.wy * 10) < baseVehicle.getScript().getExtents().z) {
                    isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(baseVehicle.x, baseVehicle.y - baseVehicle.getScript().getExtents().z, baseVehicle.z);
                    if (isoGridSquare == null) {
                        return;
                    }
                    this.fixVehiclePos(baseVehicle, isoGridSquare.chunk);
                }
                if (!(baseVehicle.y - (float)(isoChunk.wy * 10) > 10.0f - baseVehicle.getScript().getExtents().z)) break;
                isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(baseVehicle.x, baseVehicle.y + baseVehicle.getScript().getExtents().z, baseVehicle.z);
                if (isoGridSquare == null) {
                    return;
                }
                this.fixVehiclePos(baseVehicle, isoGridSquare.chunk);
            }
        }
    }

    private boolean fixVehiclePos(BaseVehicle baseVehicle, IsoChunk isoChunk) {
        BaseVehicle.MinMaxPosition minMaxPosition = baseVehicle.getMinMaxPosition();
        boolean bl = false;
        IsoDirections isoDirections = baseVehicle.getDir();
        block4: for (int i = 0; i < isoChunk.vehicles.size(); ++i) {
            BaseVehicle.MinMaxPosition minMaxPosition2 = isoChunk.vehicles.get(i).getMinMaxPosition();
            switch (isoDirections) {
                case E: 
                case W: {
                    float f = minMaxPosition2.minX - minMaxPosition.maxX;
                    if (f > 0.0f && minMaxPosition.minY < minMaxPosition2.maxY && minMaxPosition.maxY > minMaxPosition2.minY) {
                        baseVehicle.x -= f;
                        minMaxPosition.minX -= f;
                        minMaxPosition.maxX -= f;
                        bl = true;
                        continue block4;
                    }
                    f = minMaxPosition.minX - minMaxPosition2.maxX;
                    if (!(f > 0.0f) || !(minMaxPosition.minY < minMaxPosition2.maxY) || !(minMaxPosition.maxY > minMaxPosition2.minY)) continue block4;
                    baseVehicle.x += f;
                    minMaxPosition.minX += f;
                    minMaxPosition.maxX += f;
                    bl = true;
                    continue block4;
                }
                case N: 
                case S: {
                    float f = minMaxPosition2.minY - minMaxPosition.maxY;
                    if (f > 0.0f && minMaxPosition.minX < minMaxPosition2.maxX && minMaxPosition.maxX > minMaxPosition2.minX) {
                        baseVehicle.y -= f;
                        minMaxPosition.minY -= f;
                        minMaxPosition.maxY -= f;
                        bl = true;
                        continue block4;
                    }
                    f = minMaxPosition.minY - minMaxPosition2.maxY;
                    if (!(f > 0.0f) || !(minMaxPosition.minX < minMaxPosition2.maxX) || !(minMaxPosition.maxX > minMaxPosition2.minX)) continue block4;
                    baseVehicle.y += f;
                    minMaxPosition.minY += f;
                    minMaxPosition.maxY += f;
                    bl = true;
                }
            }
        }
        return bl;
    }

    private boolean isGoodVehiclePos(BaseVehicle baseVehicle, IsoChunk isoChunk) {
        int n = ((int)baseVehicle.x - 4) / 10 - 1;
        int n2 = ((int)baseVehicle.y - 4) / 10 - 1;
        int n3 = (int)Math.ceil((baseVehicle.x + 4.0f) / 10.0f) + 1;
        int n4 = (int)Math.ceil((baseVehicle.y + 4.0f) / 10.0f) + 1;
        for (int i = n2; i < n4; ++i) {
            for (int j = n; j < n3; ++j) {
                IsoChunk isoChunk2;
                IsoChunk isoChunk3 = isoChunk2 = GameServer.bServer ? ServerMap.instance.getChunk(j, i) : IsoWorld.instance.CurrentCell.getChunkForGridSquare(j * 10, i * 10, 0);
                if (isoChunk2 == null) continue;
                for (int k = 0; k < isoChunk2.vehicles.size(); ++k) {
                    BaseVehicle baseVehicle2 = isoChunk2.vehicles.get(k);
                    if ((int)baseVehicle2.z != (int)baseVehicle.z || !baseVehicle.testCollisionWithVehicle(baseVehicle2)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void AddVehicles_ForTest(IsoMetaGrid.Zone zone) {
        for (int i = zone.y - this.wy * 10 + 3; i < 0; i += 6) {
        }
        for (int i = zone.x - this.wx * 10 + 2; i < 0; i += 5) {
        }
        for (int i = i; i < 10 && this.wy * 10 + i < zone.y + zone.h; i += 6) {
            for (int j = i; j < 10 && this.wx * 10 + j < zone.x + zone.w; j += 5) {
                IsoGridSquare isoGridSquare = this.getGridSquare(j, i, 0);
                if (isoGridSquare == null) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone("Test");
                switch (AddVehicles_ForTest_vtype) {
                    case 0: {
                        baseVehicle.setScriptName("Base.CarNormal");
                        break;
                    }
                    case 1: {
                        baseVehicle.setScriptName("Base.SmallCar");
                        break;
                    }
                    case 2: {
                        baseVehicle.setScriptName("Base.SmallCar02");
                        break;
                    }
                    case 3: {
                        baseVehicle.setScriptName("Base.CarTaxi");
                        break;
                    }
                    case 4: {
                        baseVehicle.setScriptName("Base.CarTaxi2");
                        break;
                    }
                    case 5: {
                        baseVehicle.setScriptName("Base.PickUpTruck");
                        break;
                    }
                    case 6: {
                        baseVehicle.setScriptName("Base.PickUpVan");
                        break;
                    }
                    case 7: {
                        baseVehicle.setScriptName("Base.CarStationWagon");
                        break;
                    }
                    case 8: {
                        baseVehicle.setScriptName("Base.CarStationWagon2");
                        break;
                    }
                    case 9: {
                        baseVehicle.setScriptName("Base.VanSeats");
                        break;
                    }
                    case 10: {
                        baseVehicle.setScriptName("Base.Van");
                        break;
                    }
                    case 11: {
                        baseVehicle.setScriptName("Base.StepVan");
                        break;
                    }
                    case 12: {
                        baseVehicle.setScriptName("Base.PickUpTruck");
                        break;
                    }
                    case 13: {
                        baseVehicle.setScriptName("Base.PickUpVan");
                        break;
                    }
                    case 14: {
                        baseVehicle.setScriptName("Base.CarStationWagon");
                        break;
                    }
                    case 15: {
                        baseVehicle.setScriptName("Base.CarStationWagon2");
                        break;
                    }
                    case 16: {
                        baseVehicle.setScriptName("Base.VanSeats");
                        break;
                    }
                    case 17: {
                        baseVehicle.setScriptName("Base.Van");
                        break;
                    }
                    case 18: {
                        baseVehicle.setScriptName("Base.StepVan");
                        break;
                    }
                    case 19: {
                        baseVehicle.setScriptName("Base.SUV");
                        break;
                    }
                    case 20: {
                        baseVehicle.setScriptName("Base.OffRoad");
                        break;
                    }
                    case 21: {
                        baseVehicle.setScriptName("Base.ModernCar");
                        break;
                    }
                    case 22: {
                        baseVehicle.setScriptName("Base.ModernCar02");
                        break;
                    }
                    case 23: {
                        baseVehicle.setScriptName("Base.CarLuxury");
                        break;
                    }
                    case 24: {
                        baseVehicle.setScriptName("Base.SportsCar");
                        break;
                    }
                    case 25: {
                        baseVehicle.setScriptName("Base.PickUpVanLightsPolice");
                        break;
                    }
                    case 26: {
                        baseVehicle.setScriptName("Base.CarLightsPolice");
                        break;
                    }
                    case 27: {
                        baseVehicle.setScriptName("Base.PickUpVanLightsFire");
                        break;
                    }
                    case 28: {
                        baseVehicle.setScriptName("Base.PickUpTruckLightsFire");
                        break;
                    }
                    case 29: {
                        baseVehicle.setScriptName("Base.PickUpVanLights");
                        break;
                    }
                    case 30: {
                        baseVehicle.setScriptName("Base.PickUpTruckLights");
                        break;
                    }
                    case 31: {
                        baseVehicle.setScriptName("Base.CarLights");
                        break;
                    }
                    case 32: {
                        baseVehicle.setScriptName("Base.StepVanMail");
                        break;
                    }
                    case 33: {
                        baseVehicle.setScriptName("Base.VanSpiffo");
                        break;
                    }
                    case 34: {
                        baseVehicle.setScriptName("Base.VanAmbulance");
                        break;
                    }
                    case 35: {
                        baseVehicle.setScriptName("Base.VanRadio");
                        break;
                    }
                    case 36: {
                        baseVehicle.setScriptName("Base.PickupBurnt");
                        break;
                    }
                    case 37: {
                        baseVehicle.setScriptName("Base.CarNormalBurnt");
                        break;
                    }
                    case 38: {
                        baseVehicle.setScriptName("Base.TaxiBurnt");
                        break;
                    }
                    case 39: {
                        baseVehicle.setScriptName("Base.ModernCarBurnt");
                        break;
                    }
                    case 40: {
                        baseVehicle.setScriptName("Base.ModernCar02Burnt");
                        break;
                    }
                    case 41: {
                        baseVehicle.setScriptName("Base.SportsCarBurnt");
                        break;
                    }
                    case 42: {
                        baseVehicle.setScriptName("Base.SmallCarBurnt");
                        break;
                    }
                    case 43: {
                        baseVehicle.setScriptName("Base.SmallCar02Burnt");
                        break;
                    }
                    case 44: {
                        baseVehicle.setScriptName("Base.VanSeatsBurnt");
                        break;
                    }
                    case 45: {
                        baseVehicle.setScriptName("Base.VanBurnt");
                        break;
                    }
                    case 46: {
                        baseVehicle.setScriptName("Base.SUVBurnt");
                        break;
                    }
                    case 47: {
                        baseVehicle.setScriptName("Base.OffRoadBurnt");
                        break;
                    }
                    case 48: {
                        baseVehicle.setScriptName("Base.PickUpVanLightsBurnt");
                        break;
                    }
                    case 49: {
                        baseVehicle.setScriptName("Base.AmbulanceBurnt");
                        break;
                    }
                    case 50: {
                        baseVehicle.setScriptName("Base.VanRadioBurnt");
                        break;
                    }
                    case 51: {
                        baseVehicle.setScriptName("Base.PickupSpecialBurnt");
                        break;
                    }
                    case 52: {
                        baseVehicle.setScriptName("Base.NormalCarBurntPolice");
                        break;
                    }
                    case 53: {
                        baseVehicle.setScriptName("Base.LuxuryCarBurnt");
                        break;
                    }
                    case 54: {
                        baseVehicle.setScriptName("Base.PickUpVanBurnt");
                        break;
                    }
                    case 55: {
                        baseVehicle.setScriptName("Base.PickUpTruckMccoy");
                    }
                }
                baseVehicle.setDir(IsoDirections.W);
                double d = (double)(baseVehicle.getDir().toAngle() + (float)Math.PI) % (Math.PI * 2);
                baseVehicle.savedRot.setAngleAxis(d, 0.0, 1.0, 0.0);
                if (AddVehicles_ForTest_vrot == 1) {
                    baseVehicle.savedRot.setAngleAxis(1.5707963267948966, 0.0, 0.0, 1.0);
                }
                if (AddVehicles_ForTest_vrot == 2) {
                    baseVehicle.savedRot.setAngleAxis(Math.PI, 0.0, 0.0, 1.0);
                }
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                baseVehicle.setX(isoGridSquare.x);
                baseVehicle.setY((float)isoGridSquare.y + 3.0f - 3.0f);
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                baseVehicle.setScript();
                this.checkVehiclePos(baseVehicle, this);
                this.vehicles.add(baseVehicle);
                baseVehicle.setSkinIndex(AddVehicles_ForTest_vskin);
                if (++AddVehicles_ForTest_vrot < 2) continue;
                AddVehicles_ForTest_vrot = 0;
                if (++AddVehicles_ForTest_vskin < baseVehicle.getSkinCount()) continue;
                AddVehicles_ForTest_vtype = (AddVehicles_ForTest_vtype + 1) % 56;
                AddVehicles_ForTest_vskin = 0;
            }
        }
    }

    private void AddVehicles_OnZone(IsoMetaGrid.VehicleZone vehicleZone, String string) {
        IsoDirections isoDirections = IsoDirections.N;
        int n = 3;
        int n2 = 4;
        if (!(vehicleZone.w != n2 && vehicleZone.w != n2 + 1 && vehicleZone.w != n2 + 2 || vehicleZone.h > n && vehicleZone.h < n2 + 2)) {
            isoDirections = IsoDirections.W;
        }
        n2 = 5;
        if (vehicleZone.dir != IsoDirections.Max) {
            isoDirections = vehicleZone.dir;
        }
        if (isoDirections != IsoDirections.N && isoDirections != IsoDirections.S) {
            n2 = 3;
            n = 5;
        }
        int n3 = 10;
        for (float f = (float)(vehicleZone.y - this.wy * 10) + (float)n2 / 2.0f; f < 0.0f; f += (float)n2) {
        }
        for (float f = (float)(vehicleZone.x - this.wx * 10) + (float)n / 2.0f; f < 0.0f; f += (float)n) {
        }
        block16: for (float f = f; f < 10.0f && (float)(this.wy * 10) + f < (float)(vehicleZone.y + vehicleZone.h); f += (float)n2) {
            for (float f2 = f; f2 < 10.0f && (float)(this.wx * 10) + f2 < (float)(vehicleZone.x + vehicleZone.w); f2 += (float)n) {
                boolean bl;
                IsoGridSquare isoGridSquare = this.getGridSquare((int)f2, (int)f, 0);
                if (isoGridSquare == null) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    continue block16;
                }
                int n4 = vehicleType.spawnRate;
                switch (SandboxOptions.instance.CarSpawnRate.getValue()) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n4 = (int)Math.ceil((float)n4 / 10.0f);
                        break;
                    }
                    case 3: {
                        n4 = (int)Math.ceil((float)n4 / 1.5f);
                    }
                    case 4: {
                        break;
                    }
                    case 5: {
                        n4 *= 2;
                    }
                }
                if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
                    n4 = 100;
                }
                if (Rand.Next(100) > n4) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone(string);
                baseVehicle.setVehicleType(vehicleType.name);
                if (vehicleType.isSpecialCar) {
                    baseVehicle.setDoColor(false);
                }
                if (!this.RandomizeModel(baseVehicle, vehicleZone, string, vehicleType)) {
                    System.out.println("Problem with Vehicle spawning: " + string + " " + vehicleType);
                    return;
                }
                int n5 = 15;
                switch (SandboxOptions.instance.CarAlarm.getValue()) {
                    case 1: {
                        n5 = -1;
                        break;
                    }
                    case 2: {
                        n5 = 3;
                        break;
                    }
                    case 3: {
                        n5 = 8;
                        break;
                    }
                    case 5: {
                        n5 = 25;
                        break;
                    }
                    case 6: {
                        n5 = 50;
                    }
                }
                boolean bl2 = bl = baseVehicle.getScriptName().toLowerCase().contains("burnt") || baseVehicle.getScriptName().toLowerCase().contains("smashed");
                if (Rand.Next(100) < n5 && !bl) {
                    baseVehicle.setAlarmed(true);
                }
                if (vehicleZone.isFaceDirection()) {
                    baseVehicle.setDir(isoDirections);
                } else if (isoDirections == IsoDirections.N || isoDirections == IsoDirections.S) {
                    baseVehicle.setDir(Rand.Next(2) == 0 ? IsoDirections.N : IsoDirections.S);
                } else {
                    baseVehicle.setDir(Rand.Next(2) == 0 ? IsoDirections.W : IsoDirections.E);
                }
                float f3 = baseVehicle.getDir().toAngle() + (float)Math.PI;
                while ((double)f3 > Math.PI * 2) {
                    f3 = (float)((double)f3 - Math.PI * 2);
                }
                if (vehicleType.randomAngle) {
                    f3 = Rand.Next(0.0f, (float)Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f3, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                float f4 = baseVehicle.getScript().getExtents().z;
                float f5 = 0.5f;
                float f6 = (float)isoGridSquare.x + 0.5f;
                float f7 = (float)isoGridSquare.y + 0.5f;
                if (isoDirections == IsoDirections.N) {
                    f6 = (float)isoGridSquare.x + (float)n / 2.0f - (float)((int)((float)n / 2.0f));
                    f7 = (float)vehicleZone.y + f4 / 2.0f + f5;
                    if (f7 >= (float)(isoGridSquare.y + 1) && (int)f < n3 - 1 && this.getGridSquare((int)f2, (int)f + 1, 0) != null) {
                        isoGridSquare = this.getGridSquare((int)f2, (int)f + 1, 0);
                    }
                } else if (isoDirections == IsoDirections.S) {
                    f6 = (float)isoGridSquare.x + (float)n / 2.0f - (float)((int)((float)n / 2.0f));
                    f7 = (float)(vehicleZone.y + vehicleZone.h) - f4 / 2.0f - f5;
                    if (f7 < (float)isoGridSquare.y && (int)f > 0 && this.getGridSquare((int)f2, (int)f - 1, 0) != null) {
                        isoGridSquare = this.getGridSquare((int)f2, (int)f - 1, 0);
                    }
                } else if (isoDirections == IsoDirections.W) {
                    f6 = (float)vehicleZone.x + f4 / 2.0f + f5;
                    f7 = (float)isoGridSquare.y + (float)n2 / 2.0f - (float)((int)((float)n2 / 2.0f));
                    if (f6 >= (float)(isoGridSquare.x + 1) && (int)f2 < n3 - 1 && this.getGridSquare((int)f2 + 1, (int)f, 0) != null) {
                        isoGridSquare = this.getGridSquare((int)f2 + 1, (int)f, 0);
                    }
                } else if (isoDirections == IsoDirections.E) {
                    f6 = (float)(vehicleZone.x + vehicleZone.w) - f4 / 2.0f - f5;
                    f7 = (float)isoGridSquare.y + (float)n2 / 2.0f - (float)((int)((float)n2 / 2.0f));
                    if (f6 < (float)isoGridSquare.x && (int)f2 > 0 && this.getGridSquare((int)f2 - 1, (int)f, 0) != null) {
                        isoGridSquare = this.getGridSquare((int)f2 - 1, (int)f, 0);
                    }
                }
                if (f6 < (float)isoGridSquare.x + 0.005f) {
                    f6 = (float)isoGridSquare.x + 0.005f;
                }
                if (f6 > (float)(isoGridSquare.x + 1) - 0.005f) {
                    f6 = (float)(isoGridSquare.x + 1) - 0.005f;
                }
                if (f7 < (float)isoGridSquare.y + 0.005f) {
                    f7 = (float)isoGridSquare.y + 0.005f;
                }
                if (f7 > (float)(isoGridSquare.y + 1) - 0.005f) {
                    f7 = (float)(isoGridSquare.y + 1) - 0.005f;
                }
                baseVehicle.setX(f6);
                baseVehicle.setY(f7);
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                float f8 = 100.0f - Math.min(vehicleType.baseVehicleQuality * 120.0f, 100.0f);
                float f9 = baseVehicle.rust = (float)Rand.Next(100) < f8 ? 1.0f : 0.0f;
                if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) || GameClient.bClient) {
                    this.vehicles.add(baseVehicle);
                }
                if (vehicleType.chanceOfOverCar <= 0 || Rand.Next(100) > vehicleType.chanceOfOverCar) continue;
                this.spawnVehicleRandomAngle(isoGridSquare, vehicleZone, string);
            }
        }
    }

    private void AddVehicles_OnZonePolyline(IsoMetaGrid.VehicleZone vehicleZone, String string) {
        int n = 5;
        Vector2 vector22 = new Vector2();
        for (int i = 0; i < vehicleZone.points.size() - 2; i += 2) {
            int n2 = vehicleZone.points.getQuick(i);
            int n3 = vehicleZone.points.getQuick(i + 1);
            int n4 = vehicleZone.points.getQuick((i + 2) % vehicleZone.points.size());
            int n5 = vehicleZone.points.getQuick((i + 3) % vehicleZone.points.size());
            vector22.set(n4 - n2, n5 - n3);
            for (float f = (float)n / 2.0f; f < vector22.getLength(); f += (float)n) {
                float f2 = (float)n2 + vector22.x / vector22.getLength() * f;
                float f3 = (float)n3 + vector22.y / vector22.getLength() * f;
                if (!(f2 >= (float)(this.wx * 10)) || !(f3 >= (float)(this.wy * 10)) || !(f2 < (float)((this.wx + 1) * 10)) || !(f3 < (float)((this.wy + 1) * 10))) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    return;
                }
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone(string);
                baseVehicle.setVehicleType(vehicleType.name);
                if (vehicleType.isSpecialCar) {
                    baseVehicle.setDoColor(false);
                }
                if (!this.RandomizeModel(baseVehicle, vehicleZone, string, vehicleType)) {
                    System.out.println("Problem with Vehicle spawning: " + string + " " + vehicleType);
                    return;
                }
                int n6 = 15;
                switch (SandboxOptions.instance.CarAlarm.getValue()) {
                    case 1: {
                        n6 = -1;
                        break;
                    }
                    case 2: {
                        n6 = 3;
                        break;
                    }
                    case 3: {
                        n6 = 8;
                        break;
                    }
                    case 5: {
                        n6 = 25;
                        break;
                    }
                    case 6: {
                        n6 = 50;
                    }
                }
                if (Rand.Next(100) < n6) {
                    baseVehicle.setAlarmed(true);
                }
                float f4 = vector22.x;
                float f5 = vector22.y;
                vector22.normalize();
                baseVehicle.setDir(IsoDirections.fromAngle(vector22));
                float f6 = vector22.getDirectionNeg() + 0.0f;
                while ((double)f6 > Math.PI * 2) {
                    f6 = (float)((double)f6 - Math.PI * 2);
                }
                vector22.x = f4;
                vector22.y = f5;
                if (vehicleType.randomAngle) {
                    f6 = Rand.Next(0.0f, (float)Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f6, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                IsoGridSquare isoGridSquare = this.getGridSquare((int)f2 - this.wx * 10, (int)f3 - this.wy * 10, 0);
                if (f2 < (float)isoGridSquare.x + 0.005f) {
                    f2 = (float)isoGridSquare.x + 0.005f;
                }
                if (f2 > (float)(isoGridSquare.x + 1) - 0.005f) {
                    f2 = (float)(isoGridSquare.x + 1) - 0.005f;
                }
                if (f3 < (float)isoGridSquare.y + 0.005f) {
                    f3 = (float)isoGridSquare.y + 0.005f;
                }
                if (f3 > (float)(isoGridSquare.y + 1) - 0.005f) {
                    f3 = (float)(isoGridSquare.y + 1) - 0.005f;
                }
                baseVehicle.setX(f2);
                baseVehicle.setY(f3);
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                float f7 = 100.0f - Math.min(vehicleType.baseVehicleQuality * 120.0f, 100.0f);
                float f8 = baseVehicle.rust = (float)Rand.Next(100) < f7 ? 1.0f : 0.0f;
                if (!IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) && !GameClient.bClient) continue;
                this.vehicles.add(baseVehicle);
            }
        }
    }

    public static void removeFromCheckedVehicles(BaseVehicle baseVehicle) {
        BaseVehicleCheckedVehicles.remove(baseVehicle);
    }

    public static void addFromCheckedVehicles(BaseVehicle baseVehicle) {
        if (!BaseVehicleCheckedVehicles.contains(baseVehicle)) {
            BaseVehicleCheckedVehicles.add(baseVehicle);
        }
    }

    public static void Reset() {
        BaseVehicleCheckedVehicles.clear();
    }

    public static boolean doSpawnedVehiclesInInvalidPosition(BaseVehicle baseVehicle) {
        IsoGridSquare isoGridSquare;
        if (GameServer.bServer ? (isoGridSquare = ServerMap.instance.getGridSquare((int)baseVehicle.getX(), (int)baseVehicle.getY(), 0)) != null && isoGridSquare.roomID != -1 : !GameClient.bClient && (isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare((int)baseVehicle.getX(), (int)baseVehicle.getY(), 0)) != null && isoGridSquare.roomID != -1) {
            return false;
        }
        boolean bl = true;
        for (int i = 0; i < BaseVehicleCheckedVehicles.size(); ++i) {
            if (!BaseVehicleCheckedVehicles.get(i).testCollisionWithVehicle(baseVehicle)) continue;
            bl = false;
        }
        if (bl) {
            IsoChunk.addFromCheckedVehicles(baseVehicle);
        }
        return bl;
    }

    private void spawnVehicleRandomAngle(IsoGridSquare isoGridSquare, IsoMetaGrid.Zone zone, String string) {
        VehicleType vehicleType;
        boolean bl = true;
        int n = 3;
        int n2 = 4;
        if (!(zone.w != n2 && zone.w != n2 + 1 && zone.w != n2 + 2 || zone.h > n && zone.h < n2 + 2)) {
            bl = false;
        }
        n2 = 5;
        if (!bl) {
            n2 = 3;
            n = 5;
        }
        if ((vehicleType = VehicleType.getRandomVehicleType(string)) == null) {
            System.out.println("Can't find car: " + string);
            return;
        }
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.setZone(string);
        if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
            return;
        }
        if (bl) {
            baseVehicle.setDir(Rand.Next(2) == 0 ? IsoDirections.N : IsoDirections.S);
        } else {
            baseVehicle.setDir(Rand.Next(2) == 0 ? IsoDirections.W : IsoDirections.E);
        }
        float f = Rand.Next(0.0f, (float)Math.PI * 2);
        baseVehicle.savedRot.setAngleAxis(f, 0.0f, 1.0f, 0.0f);
        baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
        if (bl) {
            baseVehicle.setX((float)isoGridSquare.x + (float)n / 2.0f - (float)((int)((float)n / 2.0f)));
            baseVehicle.setY(isoGridSquare.y);
        } else {
            baseVehicle.setX(isoGridSquare.x);
            baseVehicle.setY((float)isoGridSquare.y + (float)n2 / 2.0f - (float)((int)((float)n2 / 2.0f)));
        }
        baseVehicle.setZ(isoGridSquare.z);
        baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
        if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) || GameClient.bClient) {
            this.vehicles.add(baseVehicle);
        }
    }

    public boolean RandomizeModel(BaseVehicle baseVehicle, IsoMetaGrid.Zone zone, String string, VehicleType vehicleType) {
        String string2;
        VehicleScript vehicleScript;
        if (vehicleType.vehiclesDefinition.isEmpty()) {
            System.out.println("no vehicle definition found for " + string);
            return false;
        }
        float f = Rand.Next(0.0f, 100.0f);
        float f2 = 0.0f;
        VehicleType.VehicleTypeDefinition vehicleTypeDefinition = null;
        for (int i = 0; i < vehicleType.vehiclesDefinition.size(); ++i) {
            vehicleTypeDefinition = vehicleType.vehiclesDefinition.get(i);
            if (f < (f2 += vehicleTypeDefinition.spawnChance)) break;
        }
        if ((vehicleScript = ScriptManager.instance.getVehicle(string2 = vehicleTypeDefinition.vehicleType)) == null) {
            DebugLog.log("no such vehicle script \"" + string2 + "\" in IsoChunk.RandomizeModel");
            return false;
        }
        int n = vehicleTypeDefinition.index;
        baseVehicle.setScriptName(string2);
        baseVehicle.setScript();
        try {
            if (n > -1) {
                baseVehicle.setSkinIndex(n);
            } else {
                baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount()));
            }
        }
        catch (Exception exception) {
            DebugLog.log("problem with " + baseVehicle.getScriptName());
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void AddVehicles_TrafficJam_W(IsoMetaGrid.Zone zone, String string) {
        for (int i = zone.y - this.wy * 10 + 1; i < 0; i += 3) {
        }
        for (int i = zone.x - this.wx * 10 + 3; i < 0; i += 6) {
        }
        block2: for (int i = i; i < 10 && this.wy * 10 + i < zone.y + zone.h; i += 3 + Rand.Next(1)) {
            for (int j = i; j < 10 && this.wx * 10 + j < zone.x + zone.w; j += 6 + Rand.Next(1)) {
                IsoGridSquare isoGridSquare = this.getGridSquare(j, i, 0);
                if (isoGridSquare == null) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    continue block2;
                }
                int n = 80;
                if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
                    n = 100;
                }
                if (Rand.Next(100) > n) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone("TrafficJam");
                baseVehicle.setVehicleType(vehicleType.name);
                if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                    return;
                }
                baseVehicle.setScript();
                baseVehicle.setX((float)isoGridSquare.x + Rand.Next(0.0f, 1.0f));
                baseVehicle.setY((float)isoGridSquare.y + Rand.Next(0.0f, 1.0f));
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                if (!this.isGoodVehiclePos(baseVehicle, this)) continue;
                baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount() - 1));
                baseVehicle.setDir(IsoDirections.W);
                float f = Math.abs(zone.x + zone.w - isoGridSquare.x);
                f /= 20.0f;
                f = Math.min(2.0f, f);
                float f2 = baseVehicle.getDir().toAngle() + (float)Math.PI - 0.25f + Rand.Next(0.0f, f);
                while ((double)f2 > Math.PI * 2) {
                    f2 = (float)((double)f2 - Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f2, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                if (!IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) && !GameClient.bClient) continue;
                this.vehicles.add(baseVehicle);
            }
        }
    }

    private void AddVehicles_TrafficJam_E(IsoMetaGrid.Zone zone, String string) {
        for (int i = zone.y - this.wy * 10 + 1; i < 0; i += 3) {
        }
        for (int i = zone.x - this.wx * 10 + 3; i < 0; i += 6) {
        }
        block2: for (int i = i; i < 10 && this.wy * 10 + i < zone.y + zone.h; i += 3 + Rand.Next(1)) {
            for (int j = i; j < 10 && this.wx * 10 + j < zone.x + zone.w; j += 6 + Rand.Next(1)) {
                IsoGridSquare isoGridSquare = this.getGridSquare(j, i, 0);
                if (isoGridSquare == null) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    continue block2;
                }
                int n = 80;
                if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
                    n = 100;
                }
                if (Rand.Next(100) > n) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone("TrafficJam");
                baseVehicle.setVehicleType(vehicleType.name);
                if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                    return;
                }
                baseVehicle.setScript();
                baseVehicle.setX((float)isoGridSquare.x + Rand.Next(0.0f, 1.0f));
                baseVehicle.setY((float)isoGridSquare.y + Rand.Next(0.0f, 1.0f));
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                if (!this.isGoodVehiclePos(baseVehicle, this)) continue;
                baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount() - 1));
                baseVehicle.setDir(IsoDirections.E);
                float f = Math.abs(zone.x + zone.w - isoGridSquare.x - zone.w);
                f /= 20.0f;
                f = Math.min(2.0f, f);
                float f2 = baseVehicle.getDir().toAngle() + (float)Math.PI - 0.25f + Rand.Next(0.0f, f);
                while ((double)f2 > Math.PI * 2) {
                    f2 = (float)((double)f2 - Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f2, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                if (!IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) && !GameClient.bClient) continue;
                this.vehicles.add(baseVehicle);
            }
        }
    }

    private void AddVehicles_TrafficJam_S(IsoMetaGrid.Zone zone, String string) {
        for (int i = zone.y - this.wy * 10 + 3; i < 0; i += 6) {
        }
        for (int i = zone.x - this.wx * 10 + 1; i < 0; i += 3) {
        }
        block2: for (int i = i; i < 10 && this.wy * 10 + i < zone.y + zone.h; i += 6 + Rand.Next(-1, 1)) {
            for (int j = i; j < 10 && this.wx * 10 + j < zone.x + zone.w; j += 3 + Rand.Next(1)) {
                IsoGridSquare isoGridSquare = this.getGridSquare(j, i, 0);
                if (isoGridSquare == null) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    continue block2;
                }
                int n = 80;
                if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
                    n = 100;
                }
                if (Rand.Next(100) > n) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone("TrafficJam");
                baseVehicle.setVehicleType(vehicleType.name);
                if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                    return;
                }
                baseVehicle.setScript();
                baseVehicle.setX((float)isoGridSquare.x + Rand.Next(0.0f, 1.0f));
                baseVehicle.setY((float)isoGridSquare.y + Rand.Next(0.0f, 1.0f));
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                if (!this.isGoodVehiclePos(baseVehicle, this)) continue;
                baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount() - 1));
                baseVehicle.setDir(IsoDirections.S);
                float f = Math.abs(zone.y + zone.h - isoGridSquare.y - zone.h);
                f /= 20.0f;
                f = Math.min(2.0f, f);
                float f2 = baseVehicle.getDir().toAngle() + (float)Math.PI - 0.25f + Rand.Next(0.0f, f);
                while ((double)f2 > Math.PI * 2) {
                    f2 = (float)((double)f2 - Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f2, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                if (!IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) && !GameClient.bClient) continue;
                this.vehicles.add(baseVehicle);
            }
        }
    }

    private void AddVehicles_TrafficJam_N(IsoMetaGrid.Zone zone, String string) {
        for (int i = zone.y - this.wy * 10 + 3; i < 0; i += 6) {
        }
        for (int i = zone.x - this.wx * 10 + 1; i < 0; i += 3) {
        }
        block2: for (int i = i; i < 10 && this.wy * 10 + i < zone.y + zone.h; i += 6 + Rand.Next(-1, 1)) {
            for (int j = i; j < 10 && this.wx * 10 + j < zone.x + zone.w; j += 3 + Rand.Next(1)) {
                IsoGridSquare isoGridSquare = this.getGridSquare(j, i, 0);
                if (isoGridSquare == null) continue;
                VehicleType vehicleType = VehicleType.getRandomVehicleType(string);
                if (vehicleType == null) {
                    System.out.println("Can't find car: " + string);
                    continue block2;
                }
                int n = 80;
                if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
                    n = 100;
                }
                if (Rand.Next(100) > n) continue;
                BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
                baseVehicle.setZone("TrafficJam");
                baseVehicle.setVehicleType(vehicleType.name);
                if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
                    return;
                }
                baseVehicle.setScript();
                baseVehicle.setX((float)isoGridSquare.x + Rand.Next(0.0f, 1.0f));
                baseVehicle.setY((float)isoGridSquare.y + Rand.Next(0.0f, 1.0f));
                baseVehicle.setZ(isoGridSquare.z);
                baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
                if (!this.isGoodVehiclePos(baseVehicle, this)) continue;
                baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount() - 1));
                baseVehicle.setDir(IsoDirections.N);
                float f = Math.abs(zone.y + zone.h - isoGridSquare.y);
                f /= 20.0f;
                f = Math.min(2.0f, f);
                float f2 = baseVehicle.getDir().toAngle() + (float)Math.PI - 0.25f + Rand.Next(0.0f, f);
                while ((double)f2 > Math.PI * 2) {
                    f2 = (float)((double)f2 - Math.PI * 2);
                }
                baseVehicle.savedRot.setAngleAxis(f2, 0.0f, 1.0f, 0.0f);
                baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
                if (!IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle) && !GameClient.bClient) continue;
                this.vehicles.add(baseVehicle);
            }
        }
    }

    private void AddVehicles_TrafficJam_Polyline(IsoMetaGrid.Zone zone, String string) {
        Vector2 vector22 = new Vector2();
        Vector2 vector23 = new Vector2();
        float f = 0.0f;
        float f2 = zone.getPolylineLength();
        for (int i = 0; i < zone.points.size() - 2; i += 2) {
            int n = zone.points.getQuick(i);
            int n2 = zone.points.getQuick(i + 1);
            int n3 = zone.points.getQuick(i + 2);
            int n4 = zone.points.getQuick(i + 3);
            vector22.set(n3 - n, n4 - n2);
            float f3 = vector22.getLength();
            vector23.set(vector22);
            vector23.tangent();
            vector23.normalize();
            float f4 = f;
            f += f3;
            for (float f5 = 3.0f; f5 <= f3 - 3.0f; f5 += (float)(6 + Rand.Next(-1, 1))) {
                float f6 = PZMath.clamp(f5 + Rand.Next(-1.0f, 1.0f), 3.0f, f3 - 3.0f);
                float f7 = Rand.Next(-1.0f, 1.0f);
                float f8 = (float)n + vector22.x / f3 * f6 + vector23.x * f7;
                float f9 = (float)n2 + vector22.y / f3 * f6 + vector23.y * f7;
                this.TryAddVehicle_TrafficJam(zone, string, f8, f9, vector22, f4 + f6, f2);
                float f10 = 2.0f;
                while (f10 + 1.5f <= (float)zone.polylineWidth / 2.0f) {
                    f7 = f10 + Rand.Next(-1.0f, 1.0f);
                    if (f7 + 1.5f <= (float)zone.polylineWidth / 2.0f) {
                        f6 = PZMath.clamp(f5 + Rand.Next(-2.0f, 2.0f), 3.0f, f3 - 3.0f);
                        f8 = (float)n + vector22.x / f3 * f6 + vector23.x * f7;
                        f9 = (float)n2 + vector22.y / f3 * f6 + vector23.y * f7;
                        this.TryAddVehicle_TrafficJam(zone, string, f8, f9, vector22, f4 + f6, f2);
                    }
                    if ((f7 = f10 + Rand.Next(-1.0f, 1.0f)) + 1.5f <= (float)zone.polylineWidth / 2.0f) {
                        f6 = PZMath.clamp(f5 + Rand.Next(-2.0f, 2.0f), 3.0f, f3 - 3.0f);
                        f8 = (float)n + vector22.x / f3 * f6 - vector23.x * f7;
                        f9 = (float)n2 + vector22.y / f3 * f6 - vector23.y * f7;
                        this.TryAddVehicle_TrafficJam(zone, string, f8, f9, vector22, f4 + f6, f2);
                    }
                    f10 += 2.0f;
                }
            }
        }
    }

    private void TryAddVehicle_TrafficJam(IsoMetaGrid.Zone zone, String string, float f, float f2, Vector2 vector22, float f3, float f4) {
        if (f < (float)(this.wx * 10) || f >= (float)((this.wx + 1) * 10) || f2 < (float)(this.wy * 10) || f2 >= (float)((this.wy + 1) * 10)) {
            return;
        }
        IsoGridSquare isoGridSquare = this.getGridSquare((int)f - this.wx * 10, (int)f2 - this.wy * 10, 0);
        if (isoGridSquare == null) {
            return;
        }
        VehicleType vehicleType = VehicleType.getRandomVehicleType(string + "W");
        if (vehicleType == null) {
            System.out.println("Can't find car: " + string);
            return;
        }
        int n = 80;
        if (SystemDisabler.doVehiclesEverywhere || DebugOptions.instance.VehicleSpawnEverywhere.getValue()) {
            n = 100;
        }
        if (Rand.Next(100) > n) {
            return;
        }
        BaseVehicle baseVehicle = new BaseVehicle(IsoWorld.instance.CurrentCell);
        baseVehicle.setZone("TrafficJam");
        baseVehicle.setVehicleType(vehicleType.name);
        if (!this.RandomizeModel(baseVehicle, zone, string, vehicleType)) {
            return;
        }
        baseVehicle.setScript();
        baseVehicle.setX(f);
        baseVehicle.setY(f2);
        baseVehicle.setZ(isoGridSquare.z);
        float f5 = vector22.x;
        float f6 = vector22.y;
        vector22.normalize();
        baseVehicle.setDir(IsoDirections.fromAngle(vector22));
        float f7 = vector22.getDirectionNeg();
        vector22.set(f5, f6);
        float f8 = 90.0f * (f3 / f4);
        f7 += Rand.Next(-f8, f8) * ((float)Math.PI / 180);
        while ((double)f7 > Math.PI * 2) {
            f7 = (float)((double)f7 - Math.PI * 2);
        }
        baseVehicle.savedRot.setAngleAxis(f7, 0.0f, 1.0f, 0.0f);
        baseVehicle.jniTransform.setRotation(baseVehicle.savedRot);
        baseVehicle.jniTransform.origin.set(baseVehicle.getX() - WorldSimulation.instance.offsetX, baseVehicle.getZ(), baseVehicle.getY() - WorldSimulation.instance.offsetY);
        if (this.isGoodVehiclePos(baseVehicle, this)) {
            baseVehicle.setSkinIndex(Rand.Next(baseVehicle.getSkinCount() - 1));
            if (IsoChunk.doSpawnedVehiclesInInvalidPosition(baseVehicle)) {
                this.vehicles.add(baseVehicle);
            }
        }
    }

    public void AddVehicles() {
        Object object;
        IsoMetaCell isoMetaCell;
        if (SandboxOptions.instance.CarSpawnRate.getValue() == 1) {
            return;
        }
        if (VehicleType.vehicles.isEmpty()) {
            VehicleType.init();
        }
        if (GameClient.bClient) {
            return;
        }
        if (!SandboxOptions.instance.EnableVehicles.getValue()) {
            return;
        }
        if (!GameServer.bServer) {
            WorldSimulation.instance.create();
        }
        ArrayList<IsoMetaGrid.VehicleZone> arrayList = (isoMetaCell = IsoWorld.instance.getMetaGrid().getCellData(this.wx / 30, this.wy / 30)) == null ? null : isoMetaCell.vehicleZones;
        for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
            IsoMetaGrid.VehicleZone vehicleZone = arrayList.get(i);
            if (vehicleZone.x + vehicleZone.w < this.wx * 10 || vehicleZone.y + vehicleZone.h < this.wy * 10 || vehicleZone.x >= (this.wx + 1) * 10 || vehicleZone.y >= (this.wy + 1) * 10) continue;
            object = vehicleZone.name;
            if (((String)object).isEmpty()) {
                object = vehicleZone.type;
            }
            if (SandboxOptions.instance.TrafficJam.getValue()) {
                if (vehicleZone.isPolyline()) {
                    if ("TrafficJam".equalsIgnoreCase((String)object)) {
                        this.AddVehicles_TrafficJam_Polyline(vehicleZone, (String)object);
                        continue;
                    }
                    if ("RTrafficJam".equalsIgnoreCase((String)object) && Rand.Next(100) < 10) {
                        this.AddVehicles_TrafficJam_Polyline(vehicleZone, ((String)object).replaceFirst("rtraffic", "traffic"));
                        continue;
                    }
                }
                if ("TrafficJamW".equalsIgnoreCase((String)object)) {
                    this.AddVehicles_TrafficJam_W(vehicleZone, (String)object);
                }
                if ("TrafficJamE".equalsIgnoreCase((String)object)) {
                    this.AddVehicles_TrafficJam_E(vehicleZone, (String)object);
                }
                if ("TrafficJamS".equalsIgnoreCase((String)object)) {
                    this.AddVehicles_TrafficJam_S(vehicleZone, (String)object);
                }
                if ("TrafficJamN".equalsIgnoreCase((String)object)) {
                    this.AddVehicles_TrafficJam_N(vehicleZone, (String)object);
                }
                if ("RTrafficJamW".equalsIgnoreCase((String)object) && Rand.Next(100) < 10) {
                    this.AddVehicles_TrafficJam_W(vehicleZone, ((String)object).replaceFirst("rtraffic", "traffic"));
                }
                if ("RTrafficJamE".equalsIgnoreCase((String)object) && Rand.Next(100) < 10) {
                    this.AddVehicles_TrafficJam_E(vehicleZone, ((String)object).replaceFirst("rtraffic", "traffic"));
                }
                if ("RTrafficJamS".equalsIgnoreCase((String)object) && Rand.Next(100) < 10) {
                    this.AddVehicles_TrafficJam_S(vehicleZone, ((String)object).replaceFirst("rtraffic", "traffic"));
                }
                if ("RTrafficJamN".equalsIgnoreCase((String)object) && Rand.Next(100) < 10) {
                    this.AddVehicles_TrafficJam_N(vehicleZone, ((String)object).replaceFirst("rtraffic", "traffic"));
                }
            }
            if (StringUtils.containsIgnoreCase((String)object, "TrafficJam")) continue;
            if ("TestVehicles".equals(object)) {
                this.AddVehicles_ForTest(vehicleZone);
                continue;
            }
            if (!VehicleType.hasTypeForZone((String)object)) continue;
            if (vehicleZone.isPolyline()) {
                this.AddVehicles_OnZonePolyline(vehicleZone, (String)object);
                continue;
            }
            this.AddVehicles_OnZone(vehicleZone, (String)object);
        }
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(this.wx, this.wy);
        if (isoMetaChunk == null) {
            return;
        }
        for (int i = 0; i < isoMetaChunk.numZones(); ++i) {
            object = isoMetaChunk.getZone(i);
            this.addRandomCarCrash((IsoMetaGrid.Zone)object, false);
        }
    }

    public void addSurvivorInHorde(boolean bl) {
        if (!bl && IsoWorld.getZombiesDisabled()) {
            return;
        }
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(this.wx, this.wy);
        if (isoMetaChunk == null) {
            return;
        }
        for (int i = 0; i < isoMetaChunk.numZones(); ++i) {
            IsoMetaGrid.Zone zone = isoMetaChunk.getZone(i);
            if (!this.canAddSurvivorInHorde(zone, bl)) continue;
            int n = 4;
            float f = (float)GameTime.getInstance().getWorldAgeHours() / 24.0f;
            n = (int)((float)n + (f += (float)((SandboxOptions.instance.TimeSinceApo.getValue() - 1) * 30)) * 0.03f);
            n = Math.max(15, n);
            if (!bl && !(Rand.Next(0.0f, 500.0f) < 0.4f * (float)n)) continue;
            this.addSurvivorInHorde(zone);
            if (bl) break;
        }
    }

    private boolean canAddSurvivorInHorde(IsoMetaGrid.Zone zone, boolean bl) {
        if (!bl && IsoWorld.instance.getTimeSinceLastSurvivorInHorde() > 0) {
            return false;
        }
        if (!bl && IsoWorld.getZombiesDisabled()) {
            return false;
        }
        if (!bl && zone.hourLastSeen != 0) {
            return false;
        }
        if (!bl && zone.haveConstruction) {
            return false;
        }
        return "Nav".equals(zone.getType());
    }

    private void addSurvivorInHorde(IsoMetaGrid.Zone zone) {
        ++zone.hourLastSeen;
        IsoWorld.instance.setTimeSinceLastSurvivorInHorde(5000);
        int n = Math.max(zone.x, this.wx * 10);
        int n2 = Math.max(zone.y, this.wy * 10);
        int n3 = Math.min(zone.x + zone.w, (this.wx + 1) * 10);
        int n4 = Math.min(zone.y + zone.h, (this.wy + 1) * 10);
        float f = (float)n + (float)(n3 - n) / 2.0f;
        float f2 = (float)n2 + (float)(n4 - n2) / 2.0f;
        VirtualZombieManager.instance.choices.clear();
        IsoGridSquare isoGridSquare = this.getGridSquare((int)f - this.wx * 10, (int)f2 - this.wy * 10, 0);
        if (isoGridSquare.getBuilding() != null) {
            return;
        }
        VirtualZombieManager.instance.choices.add(isoGridSquare);
        int n5 = Rand.Next(15, 20);
        for (int i = 0; i < n5; ++i) {
            IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(Rand.Next(8), false);
            if (isoZombie == null) continue;
            isoZombie.dressInRandomOutfit();
            ZombieSpawnRecorder.instance.record(isoZombie, "addSurvivorInHorde");
        }
        IsoZombie isoZombie = VirtualZombieManager.instance.createRealZombieAlways(Rand.Next(8), false);
        if (isoZombie != null) {
            ZombieSpawnRecorder.instance.record(isoZombie, "addSurvivorInHorde");
            isoZombie.setAsSurvivor();
        }
    }

    public boolean canAddRandomCarCrash(IsoMetaGrid.Zone zone, boolean bl) {
        if (!bl && zone.hourLastSeen != 0) {
            return false;
        }
        if (!bl && zone.haveConstruction) {
            return false;
        }
        if (!"Nav".equals(zone.getType())) {
            return false;
        }
        int n = Math.max(zone.x, this.wx * 10);
        int n2 = Math.max(zone.y, this.wy * 10);
        int n3 = Math.min(zone.x + zone.w, (this.wx + 1) * 10);
        int n4 = Math.min(zone.y + zone.h, (this.wy + 1) * 10);
        if (zone.w > 30 && zone.h < 13) {
            return n3 - n >= 10 && n4 - n2 >= 5;
        }
        if (zone.h > 30 && zone.w < 13) {
            return n3 - n >= 5 && n4 - n2 >= 10;
        }
        return false;
    }

    public void addRandomCarCrash(IsoMetaGrid.Zone zone, boolean bl) {
        if (!this.vehicles.isEmpty()) {
            return;
        }
        if (!"Nav".equals(zone.getType())) {
            return;
        }
        RandomizedVehicleStoryBase.doRandomStory(zone, this, false);
    }

    public static boolean FileExists(int n, int n2) {
        File file = ChunkMapFilenames.instance.getFilename(n, n2);
        if (file == null) {
            file = ZomboidFileSystem.instance.getFileInCurrentSave(prefix + n + "_" + n2 + ".bin");
        }
        long l = 0L;
        return file.exists();
    }

    private void checkPhysics() {
        if (!this.physicsCheck) {
            return;
        }
        WorldSimulation.instance.create();
        Bullet.beginUpdateChunk(this);
        int n = 0;
        if (n < 8) {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < 10; ++j) {
                    this.calcPhysics(j, i, n, this.shapes);
                    int n2 = 0;
                    for (int k = 0; k < 4; ++k) {
                        if (this.shapes[k] == null) continue;
                        IsoChunk.bshapes[n2++] = (byte)(this.shapes[k].ordinal() + 1);
                    }
                    Bullet.updateChunk(j, i, n, n2, bshapes);
                }
            }
        }
        Bullet.endUpdateChunk();
        this.physicsCheck = false;
    }

    private void calcPhysics(int n, int n2, int n3, PhysicsShapes[] physicsShapesArray) {
        Object object;
        Object object2;
        int n4;
        boolean bl;
        for (int i = 0; i < 4; ++i) {
            physicsShapesArray[i] = null;
        }
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        if (isoGridSquare == null) {
            return;
        }
        int n5 = 0;
        if (n3 == 0) {
            bl = false;
            for (n4 = 0; n4 < isoGridSquare.getObjects().size(); ++n4) {
                object2 = isoGridSquare.getObjects().get(n4);
                if (((IsoObject)object2).sprite == null || ((IsoObject)object2).sprite.name == null || !((IsoObject)object2).sprite.name.contains("lighting_outdoor_") && !((IsoObject)object2).sprite.name.equals("recreational_sports_01_21") && !((IsoObject)object2).sprite.name.equals("recreational_sports_01_19") && !((IsoObject)object2).sprite.name.equals("recreational_sports_01_32") || ((IsoObject)object2).getProperties().Is("MoveType") && "WallObject".equals(((IsoObject)object2).getProperties().Val("MoveType"))) continue;
                bl = true;
                break;
            }
            if (bl) {
                physicsShapesArray[n5++] = PhysicsShapes.Tree;
            }
        }
        bl = false;
        if (!isoGridSquare.getSpecialObjects().isEmpty()) {
            n4 = isoGridSquare.getSpecialObjects().size();
            for (int i = 0; i < n4; ++i) {
                object = isoGridSquare.getSpecialObjects().get(i);
                if (!(object instanceof IsoThumpable) || !((IsoThumpable)object).isBlockAllTheSquare()) continue;
                bl = true;
                break;
            }
        }
        PropertyContainer propertyContainer = isoGridSquare.getProperties();
        if (isoGridSquare.hasTypes.isSet(IsoObjectType.isMoveAbleObject)) {
            physicsShapesArray[n5++] = PhysicsShapes.Tree;
        }
        if (isoGridSquare.hasTypes.isSet(IsoObjectType.tree)) {
            object2 = isoGridSquare.getProperties().Val("tree");
            object = isoGridSquare.getProperties().Val("WindType");
            if (object2 == null) {
                physicsShapesArray[n5++] = PhysicsShapes.Tree;
            }
            if (!(object2 == null || ((String)object2).equals("1") || object != null && ((String)object).equals("2") && (((String)object2).equals("2") || ((String)object2).equals("1")))) {
                physicsShapesArray[n5++] = PhysicsShapes.Tree;
            }
        } else if (propertyContainer.Is(IsoFlagType.solid) || propertyContainer.Is(IsoFlagType.solidtrans) || propertyContainer.Is(IsoFlagType.blocksight) || isoGridSquare.HasStairs() || bl) {
            if (n5 == physicsShapesArray.length) {
                DebugLog.log(DebugType.General, "Error: Too many physics objects on gridsquare: " + isoGridSquare.x + ", " + isoGridSquare.y + ", " + isoGridSquare.z);
                return;
            }
            physicsShapesArray[n5++] = PhysicsShapes.Solid;
        } else if (n3 > 0 && (isoGridSquare.SolidFloorCached ? isoGridSquare.SolidFloor : isoGridSquare.TreatAsSolidFloor())) {
            if (n5 == physicsShapesArray.length) {
                DebugLog.log(DebugType.General, "Error: Too many physics objects on gridsquare: " + isoGridSquare.x + ", " + isoGridSquare.y + ", " + isoGridSquare.z);
                return;
            }
            physicsShapesArray[n5++] = PhysicsShapes.Floor;
        }
        if (isoGridSquare.getProperties().Is("CarSlowFactor")) {
            return;
        }
        if (propertyContainer.Is(IsoFlagType.collideW) || propertyContainer.Is(IsoFlagType.windowW) || isoGridSquare.getProperties().Is(IsoFlagType.DoorWallW) && !isoGridSquare.getProperties().Is("GarageDoor")) {
            if (n5 == physicsShapesArray.length) {
                DebugLog.log(DebugType.General, "Error: Too many physics objects on gridsquare: " + isoGridSquare.x + ", " + isoGridSquare.y + ", " + isoGridSquare.z);
                return;
            }
            physicsShapesArray[n5++] = PhysicsShapes.WallW;
        }
        if (propertyContainer.Is(IsoFlagType.collideN) || propertyContainer.Is(IsoFlagType.windowN) || isoGridSquare.getProperties().Is(IsoFlagType.DoorWallN) && !isoGridSquare.getProperties().Is("GarageDoor")) {
            if (n5 == physicsShapesArray.length) {
                DebugLog.log(DebugType.General, "Error: Too many physics objects on gridsquare: " + isoGridSquare.x + ", " + isoGridSquare.y + ", " + isoGridSquare.z);
                return;
            }
            physicsShapesArray[n5++] = PhysicsShapes.WallN;
        }
        if (isoGridSquare.Is("PhysicsShape")) {
            if (n5 == physicsShapesArray.length) {
                DebugLog.log(DebugType.General, "Error: Too many physics objects on gridsquare: " + isoGridSquare.x + ", " + isoGridSquare.y + ", " + isoGridSquare.z);
                return;
            }
            object2 = isoGridSquare.getProperties().Val("PhysicsShape");
            if ("Solid".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.Solid;
            } else if ("WallN".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.WallN;
            } else if ("WallW".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.WallW;
            } else if ("WallS".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.WallS;
            } else if ("WallE".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.WallE;
            } else if ("Tree".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.Tree;
            } else if ("Floor".equals(object2)) {
                physicsShapesArray[n5++] = PhysicsShapes.Floor;
            }
        }
    }

    public boolean LoadBrandNew(int n, int n2) {
        this.wx = n;
        this.wy = n2;
        if (!CellLoader.LoadCellBinaryChunk(IsoWorld.instance.CurrentCell, n, n2, this)) {
            return false;
        }
        if (!(Core.GameMode.equals("Tutorial") || Core.GameMode.equals("LastStand") || GameClient.bClient)) {
            this.addZombies = true;
        }
        return true;
    }

    public boolean LoadOrCreate(int n, int n2, ByteBuffer byteBuffer) {
        this.wx = n;
        this.wy = n2;
        if (byteBuffer != null && !this.blam) {
            return this.LoadFromBuffer(n, n2, byteBuffer);
        }
        File file = ChunkMapFilenames.instance.getFilename(n, n2);
        if (file == null) {
            file = ZomboidFileSystem.instance.getFileInCurrentSave(prefix + n + "_" + n2 + ".bin");
        }
        if (file.exists() && !this.blam) {
            try {
                this.LoadFromDisk();
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception, "Error loading chunk " + n + "," + n2);
                if (GameServer.bServer) {
                    LoggerManager.getLogger("map").write("Error loading chunk " + n + "," + n2);
                    LoggerManager.getLogger("map").write(exception);
                }
                this.BackupBlam(n, n2, exception);
                return false;
            }
        } else {
            return this.LoadBrandNew(n, n2);
        }
        if (GameClient.bClient) {
            GameClient.instance.worldObjectsSyncReq.putRequestSyncIsoChunk(this);
        }
        return true;
    }

    public boolean LoadFromBuffer(int n, int n2, ByteBuffer byteBuffer) {
        this.wx = n;
        this.wy = n2;
        if (!this.blam) {
            try {
                this.LoadFromDiskOrBuffer(byteBuffer);
                return true;
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                if (GameServer.bServer) {
                    LoggerManager.getLogger("map").write("Error loading chunk " + n + "," + n2);
                    LoggerManager.getLogger("map").write(exception);
                }
                this.BackupBlam(n, n2, exception);
                return false;
            }
        }
        return this.LoadBrandNew(n, n2);
    }

    private void ensureSurroundNotNull(int n, int n2, int n3) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoGridSquare isoGridSquare;
                if (i == 0 && j == 0 || n + i < 0 || n + i >= 10 || n2 + j < 0 || n2 + j >= 10 || (isoGridSquare = this.getGridSquare(n + i, n2 + j, n3)) != null) continue;
                isoGridSquare = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + n + i, this.wy * 10 + n2 + j, n3);
                this.setSquare(n + i, n2 + j, n3, isoGridSquare);
            }
        }
    }

    public void loadInWorldStreamerThread() {
        IsoGridSquare isoGridSquare;
        int n;
        int n2;
        int n3;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (n3 = 0; n3 <= this.maxLevel; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 10; ++n) {
                    isoGridSquare = this.getGridSquare(n, n2, n3);
                    if (isoGridSquare == null && n3 == 0) {
                        isoGridSquare = IsoGridSquare.getNew(IsoWorld.instance.CurrentCell, null, this.wx * 10 + n, this.wy * 10 + n2, n3);
                        this.setSquare(n, n2, n3, isoGridSquare);
                    }
                    if (n3 == 0 && isoGridSquare.getFloor() == null) {
                        DebugLog.log("ERROR: added floor at " + isoGridSquare.x + "," + isoGridSquare.y + "," + isoGridSquare.z + " because there wasn't one");
                        IsoObject isoObject = IsoObject.getNew();
                        isoObject.sprite = IsoSprite.getSprite(IsoSpriteManager.instance, "carpentry_02_58", 0);
                        isoObject.square = isoGridSquare;
                        isoGridSquare.Objects.add(0, isoObject);
                    }
                    if (isoGridSquare == null) continue;
                    if (n3 > 0 && !isoGridSquare.getObjects().isEmpty()) {
                        this.ensureSurroundNotNull(n, n2, n3);
                        for (int i = n3 - 1; i > 0; --i) {
                            IsoGridSquare isoGridSquare2 = this.getGridSquare(n, n2, i);
                            if (isoGridSquare2 != null) continue;
                            isoGridSquare2 = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + n, this.wy * 10 + n2, i);
                            this.setSquare(n, n2, i, isoGridSquare2);
                            this.ensureSurroundNotNull(n, n2, i);
                        }
                    }
                    isoGridSquare.RecalcProperties();
                }
            }
        }
        assert (IsoChunk.chunkGetter.chunk == null);
        IsoChunk.chunkGetter.chunk = this;
        for (n3 = 0; n3 < 10; ++n3) {
            block5: for (n2 = 0; n2 < 10; ++n2) {
                for (n = this.maxLevel; n > 0; --n) {
                    isoGridSquare = this.getGridSquare(n2, n3, n);
                    if (isoGridSquare == null || !isoGridSquare.Is(IsoFlagType.solidfloor)) continue;
                    --n;
                    while (n >= 0) {
                        isoGridSquare = this.getGridSquare(n2, n3, n);
                        if (isoGridSquare != null && !isoGridSquare.haveRoof) {
                            isoGridSquare.haveRoof = true;
                            isoGridSquare.getProperties().UnSet(IsoFlagType.exterior);
                        }
                        --n;
                    }
                    continue block5;
                }
            }
        }
        for (n3 = 0; n3 <= this.maxLevel; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 10; ++n) {
                    isoGridSquare = this.getGridSquare(n, n2, n3);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.RecalcAllWithNeighbours(true, chunkGetter);
                }
            }
        }
        IsoChunk.chunkGetter.chunk = null;
        for (n3 = 0; n3 <= this.maxLevel; ++n3) {
            for (n2 = 0; n2 < 10; ++n2) {
                for (n = 0; n < 10; ++n) {
                    isoGridSquare = this.getGridSquare(n, n2, n3);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.propertiesDirty = true;
                }
            }
        }
    }

    private void RecalcAllWithNeighbour(IsoGridSquare isoGridSquare, IsoDirections isoDirections, int n) {
        IsoGridSquare isoGridSquare2;
        int n2 = 0;
        int n3 = 0;
        if (isoDirections == IsoDirections.W || isoDirections == IsoDirections.NW || isoDirections == IsoDirections.SW) {
            n2 = -1;
        } else if (isoDirections == IsoDirections.E || isoDirections == IsoDirections.NE || isoDirections == IsoDirections.SE) {
            n2 = 1;
        }
        if (isoDirections == IsoDirections.N || isoDirections == IsoDirections.NW || isoDirections == IsoDirections.NE) {
            n3 = -1;
        } else if (isoDirections == IsoDirections.S || isoDirections == IsoDirections.SW || isoDirections == IsoDirections.SE) {
            n3 = 1;
        }
        int n4 = isoGridSquare.getX() + n2;
        int n5 = isoGridSquare.getY() + n3;
        int n6 = isoGridSquare.getZ() + n;
        IsoGridSquare isoGridSquare3 = isoGridSquare2 = n == 0 ? isoGridSquare.nav[isoDirections.index()] : IsoWorld.instance.CurrentCell.getGridSquare(n4, n5, n6);
        if (isoGridSquare2 != null) {
            isoGridSquare.ReCalculateCollide(isoGridSquare2);
            isoGridSquare2.ReCalculateCollide(isoGridSquare);
            isoGridSquare.ReCalculatePathFind(isoGridSquare2);
            isoGridSquare2.ReCalculatePathFind(isoGridSquare);
            isoGridSquare.ReCalculateVisionBlocked(isoGridSquare2);
            isoGridSquare2.ReCalculateVisionBlocked(isoGridSquare);
        }
        if (n == 0) {
            switch (isoDirections) {
                case W: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.w = null;
                        break;
                    }
                    isoGridSquare.w = isoGridSquare.testPathFindAdjacent(null, -1, 0, 0) ? null : isoGridSquare2;
                    isoGridSquare2.e = isoGridSquare2.testPathFindAdjacent(null, 1, 0, 0) ? null : isoGridSquare;
                    break;
                }
                case N: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.n = null;
                        break;
                    }
                    isoGridSquare.n = isoGridSquare.testPathFindAdjacent(null, 0, -1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.s = isoGridSquare2.testPathFindAdjacent(null, 0, 1, 0) ? null : isoGridSquare;
                    break;
                }
                case E: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.e = null;
                        break;
                    }
                    isoGridSquare.e = isoGridSquare.testPathFindAdjacent(null, 1, 0, 0) ? null : isoGridSquare2;
                    isoGridSquare2.w = isoGridSquare2.testPathFindAdjacent(null, -1, 0, 0) ? null : isoGridSquare;
                    break;
                }
                case S: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.s = null;
                        break;
                    }
                    isoGridSquare.s = isoGridSquare.testPathFindAdjacent(null, 0, 1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.n = isoGridSquare2.testPathFindAdjacent(null, 0, -1, 0) ? null : isoGridSquare;
                    break;
                }
                case NW: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.nw = null;
                        break;
                    }
                    isoGridSquare.nw = isoGridSquare.testPathFindAdjacent(null, -1, -1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.se = isoGridSquare2.testPathFindAdjacent(null, 1, 1, 0) ? null : isoGridSquare;
                    break;
                }
                case NE: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.ne = null;
                        break;
                    }
                    isoGridSquare.ne = isoGridSquare.testPathFindAdjacent(null, 1, -1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.sw = isoGridSquare2.testPathFindAdjacent(null, -1, 1, 0) ? null : isoGridSquare;
                    break;
                }
                case SE: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.se = null;
                        break;
                    }
                    isoGridSquare.se = isoGridSquare.testPathFindAdjacent(null, 1, 1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.nw = isoGridSquare2.testPathFindAdjacent(null, -1, -1, 0) ? null : isoGridSquare;
                    break;
                }
                case SW: {
                    if (isoGridSquare2 == null) {
                        isoGridSquare.sw = null;
                        break;
                    }
                    isoGridSquare.sw = isoGridSquare.testPathFindAdjacent(null, -1, 1, 0) ? null : isoGridSquare2;
                    isoGridSquare2.ne = isoGridSquare2.testPathFindAdjacent(null, 1, -1, 0) ? null : isoGridSquare;
                }
            }
        }
    }

    private void EnsureSurroundNotNullX(int n, int n2, int n3) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = n - 1; i <= n + 1; ++i) {
            IsoGridSquare isoGridSquare;
            if (i < 0 || i >= 10 || (isoGridSquare = this.getGridSquare(i, n2, n3)) != null) continue;
            isoGridSquare = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + i, this.wy * 10 + n2, n3);
            isoCell.ConnectNewSquare(isoGridSquare, false);
        }
    }

    private void EnsureSurroundNotNullY(int n, int n2, int n3) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = n2 - 1; i <= n2 + 1; ++i) {
            IsoGridSquare isoGridSquare;
            if (i < 0 || i >= 10 || (isoGridSquare = this.getGridSquare(n, i, n3)) != null) continue;
            isoGridSquare = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + n, this.wy * 10 + i, n3);
            isoCell.ConnectNewSquare(isoGridSquare, false);
        }
    }

    private void EnsureSurroundNotNull(int n, int n2, int n3) {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        IsoGridSquare isoGridSquare = this.getGridSquare(n, n2, n3);
        if (isoGridSquare != null) {
            return;
        }
        isoGridSquare = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + n, this.wy * 10 + n2, n3);
        isoCell.ConnectNewSquare(isoGridSquare, false);
    }

    public void loadInMainThread() {
        IsoGridSquare isoGridSquare;
        int n;
        int n2;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        IsoChunk isoChunk = isoCell.getChunk(this.wx - 1, this.wy);
        IsoChunk isoChunk2 = isoCell.getChunk(this.wx, this.wy - 1);
        IsoChunk isoChunk3 = isoCell.getChunk(this.wx + 1, this.wy);
        IsoChunk isoChunk4 = isoCell.getChunk(this.wx, this.wy + 1);
        IsoChunk isoChunk5 = isoCell.getChunk(this.wx - 1, this.wy - 1);
        IsoChunk isoChunk6 = isoCell.getChunk(this.wx + 1, this.wy - 1);
        IsoChunk isoChunk7 = isoCell.getChunk(this.wx + 1, this.wy + 1);
        IsoChunk isoChunk8 = isoCell.getChunk(this.wx - 1, this.wy + 1);
        for (n2 = 1; n2 < 8; ++n2) {
            for (n = 0; n < 10; ++n) {
                if (isoChunk2 != null && (isoGridSquare = isoChunk2.getGridSquare(n, 9, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                    this.EnsureSurroundNotNullX(n, 0, n2);
                }
                if (isoChunk4 == null || (isoGridSquare = isoChunk4.getGridSquare(n, 0, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
                this.EnsureSurroundNotNullX(n, 9, n2);
            }
            for (n = 0; n < 10; ++n) {
                if (isoChunk != null && (isoGridSquare = isoChunk.getGridSquare(9, n, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                    this.EnsureSurroundNotNullY(0, n, n2);
                }
                if (isoChunk3 == null || (isoGridSquare = isoChunk3.getGridSquare(0, n, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
                this.EnsureSurroundNotNullY(9, n, n2);
            }
            if (isoChunk5 != null && (isoGridSquare = isoChunk5.getGridSquare(9, 9, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                this.EnsureSurroundNotNull(0, 0, n2);
            }
            if (isoChunk6 != null && (isoGridSquare = isoChunk6.getGridSquare(0, 9, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                this.EnsureSurroundNotNull(9, 0, n2);
            }
            if (isoChunk7 != null && (isoGridSquare = isoChunk7.getGridSquare(0, 0, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                this.EnsureSurroundNotNull(9, 9, n2);
            }
            if (isoChunk8 == null || (isoGridSquare = isoChunk8.getGridSquare(9, 0, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
            this.EnsureSurroundNotNull(0, 9, n2);
        }
        for (n2 = 1; n2 < 8; ++n2) {
            for (n = 0; n < 10; ++n) {
                if (isoChunk2 != null && (isoGridSquare = this.getGridSquare(n, 0, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                    isoChunk2.EnsureSurroundNotNullX(n, 9, n2);
                }
                if (isoChunk4 == null || (isoGridSquare = this.getGridSquare(n, 9, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
                isoChunk4.EnsureSurroundNotNullX(n, 0, n2);
            }
            for (n = 0; n < 10; ++n) {
                if (isoChunk != null && (isoGridSquare = this.getGridSquare(0, n, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                    isoChunk.EnsureSurroundNotNullY(9, n, n2);
                }
                if (isoChunk3 == null || (isoGridSquare = this.getGridSquare(9, n, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
                isoChunk3.EnsureSurroundNotNullY(0, n, n2);
            }
            if (isoChunk5 != null && (isoGridSquare = this.getGridSquare(0, 0, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                isoChunk5.EnsureSurroundNotNull(9, 9, n2);
            }
            if (isoChunk6 != null && (isoGridSquare = this.getGridSquare(9, 0, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                isoChunk6.EnsureSurroundNotNull(0, 9, n2);
            }
            if (isoChunk7 != null && (isoGridSquare = this.getGridSquare(9, 9, n2)) != null && !isoGridSquare.getObjects().isEmpty()) {
                isoChunk7.EnsureSurroundNotNull(0, 0, n2);
            }
            if (isoChunk8 == null || (isoGridSquare = this.getGridSquare(0, 9, n2)) == null || isoGridSquare.getObjects().isEmpty()) continue;
            isoChunk8.EnsureSurroundNotNull(9, 0, n2);
        }
        for (n2 = 0; n2 <= this.maxLevel; ++n2) {
            for (n = 0; n < 10; ++n) {
                for (int i = 0; i < 10; ++i) {
                    Object object;
                    isoGridSquare = this.getGridSquare(i, n, n2);
                    if (isoGridSquare == null) continue;
                    if (i == 0 || i == 9 || n == 0 || n == 9) {
                        IsoWorld.instance.CurrentCell.DoGridNav(isoGridSquare, IsoGridSquare.cellGetSquare);
                        for (int j = -1; j <= 1; ++j) {
                            if (i == 0) {
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.W, j);
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.NW, j);
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.SW, j);
                            } else if (i == 9) {
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.E, j);
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.NE, j);
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.SE, j);
                            }
                            if (n == 0) {
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.N, j);
                                if (i != 0) {
                                    this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.NW, j);
                                }
                                if (i == 9) continue;
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.NE, j);
                                continue;
                            }
                            if (n != 9) continue;
                            this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.S, j);
                            if (i != 0) {
                                this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.SW, j);
                            }
                            if (i == 9) continue;
                            this.RecalcAllWithNeighbour(isoGridSquare, IsoDirections.SE, j);
                        }
                        object = isoGridSquare.nav[IsoDirections.N.index()];
                        IsoGridSquare isoGridSquare2 = isoGridSquare.nav[IsoDirections.S.index()];
                        IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.W.index()];
                        IsoGridSquare isoGridSquare4 = isoGridSquare.nav[IsoDirections.E.index()];
                        if (object != null && isoGridSquare3 != null && (i == 0 || n == 0)) {
                            this.RecalcAllWithNeighbour((IsoGridSquare)object, IsoDirections.W, 0);
                        }
                        if (object != null && isoGridSquare4 != null && (i == 9 || n == 0)) {
                            this.RecalcAllWithNeighbour((IsoGridSquare)object, IsoDirections.E, 0);
                        }
                        if (isoGridSquare2 != null && isoGridSquare3 != null && (i == 0 || n == 9)) {
                            this.RecalcAllWithNeighbour(isoGridSquare2, IsoDirections.W, 0);
                        }
                        if (isoGridSquare2 != null && isoGridSquare4 != null && (i == 9 || n == 9)) {
                            this.RecalcAllWithNeighbour(isoGridSquare2, IsoDirections.E, 0);
                        }
                    }
                    if ((object = isoGridSquare.getRoom()) == null) continue;
                    ((IsoRoom)object).addSquare(isoGridSquare);
                }
            }
        }
        this.fixObjectAmbientEmittersOnAdjacentChunks(isoChunk3, isoChunk4);
        for (n2 = 0; n2 < 4; ++n2) {
            if (isoChunk != null) {
                isoChunk.lightCheck[n2] = true;
            }
            if (isoChunk2 != null) {
                isoChunk2.lightCheck[n2] = true;
            }
            if (isoChunk3 != null) {
                isoChunk3.lightCheck[n2] = true;
            }
            if (isoChunk4 != null) {
                isoChunk4.lightCheck[n2] = true;
            }
            if (isoChunk5 != null) {
                isoChunk5.lightCheck[n2] = true;
            }
            if (isoChunk6 != null) {
                isoChunk6.lightCheck[n2] = true;
            }
            if (isoChunk7 != null) {
                isoChunk7.lightCheck[n2] = true;
            }
            if (isoChunk8 == null) continue;
            isoChunk8.lightCheck[n2] = true;
        }
        for (n2 = 0; n2 < IsoPlayer.numPlayers; ++n2) {
            LosUtil.cachecleared[n2] = true;
        }
        IsoLightSwitch.chunkLoaded(this);
    }

    private void fixObjectAmbientEmittersOnAdjacentChunks(IsoChunk isoChunk, IsoChunk isoChunk2) {
        if (GameServer.bServer) {
            return;
        }
        if (isoChunk == null && isoChunk2 == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            IsoGridSquare isoGridSquare;
            int n;
            if (isoChunk != null) {
                for (n = 0; n < 10; ++n) {
                    isoGridSquare = isoChunk.getGridSquare(0, n, i);
                    this.fixObjectAmbientEmittersOnSquare(isoGridSquare, false);
                }
            }
            if (isoChunk2 == null) continue;
            for (n = 0; n < 10; ++n) {
                isoGridSquare = isoChunk2.getGridSquare(n, 0, i);
                this.fixObjectAmbientEmittersOnSquare(isoGridSquare, true);
            }
        }
    }

    private void fixObjectAmbientEmittersOnSquare(IsoGridSquare isoGridSquare, boolean bl) {
        IsoWindow isoWindow;
        if (isoGridSquare == null || isoGridSquare.getSpecialObjects().isEmpty()) {
            return;
        }
        IsoObject isoObject = isoGridSquare.getDoor(bl);
        if (isoObject instanceof IsoDoor && ((IsoDoor)isoObject).isExterior() && !isoObject.hasObjectAmbientEmitter()) {
            isoObject.addObjectAmbientEmitter(new ObjectAmbientEmitters.DoorLogic().init(isoObject));
        }
        if ((isoWindow = isoGridSquare.getWindow(bl)) != null && isoWindow.isExterior() && !isoWindow.hasObjectAmbientEmitter()) {
            isoWindow.addObjectAmbientEmitter(new ObjectAmbientEmitters.WindowLogic().init(isoWindow));
        }
    }

    @Deprecated
    public void recalcNeighboursNow() {
        IsoGridSquare isoGridSquare;
        int n;
        int n2;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 10; ++n) {
                for (int i = 0; i < 8; ++i) {
                    isoGridSquare = this.getGridSquare(n2, n, i);
                    if (isoGridSquare == null) continue;
                    if (i > 0 && !isoGridSquare.getObjects().isEmpty()) {
                        isoGridSquare.EnsureSurroundNotNull();
                        for (int j = i - 1; j > 0; --j) {
                            IsoGridSquare isoGridSquare2 = this.getGridSquare(n2, n, j);
                            if (isoGridSquare2 != null) continue;
                            isoGridSquare2 = IsoGridSquare.getNew(isoCell, null, this.wx * 10 + n2, this.wy * 10 + n, j);
                            isoCell.ConnectNewSquare(isoGridSquare2, false);
                        }
                    }
                    isoGridSquare.RecalcProperties();
                }
            }
        }
        for (n2 = 1; n2 < 8; ++n2) {
            IsoGridSquare isoGridSquare3;
            for (n = -1; n < 11; ++n) {
                isoGridSquare3 = isoCell.getGridSquare(this.wx * 10 + n, this.wy * 10 - 1, n2);
                if (isoGridSquare3 != null && !isoGridSquare3.getObjects().isEmpty()) {
                    isoGridSquare3.EnsureSurroundNotNull();
                }
                if ((isoGridSquare3 = isoCell.getGridSquare(this.wx * 10 + n, this.wy * 10 + 10, n2)) == null || isoGridSquare3.getObjects().isEmpty()) continue;
                isoGridSquare3.EnsureSurroundNotNull();
            }
            for (n = 0; n < 10; ++n) {
                isoGridSquare3 = isoCell.getGridSquare(this.wx * 10 - 1, this.wy * 10 + n, n2);
                if (isoGridSquare3 != null && !isoGridSquare3.getObjects().isEmpty()) {
                    isoGridSquare3.EnsureSurroundNotNull();
                }
                if ((isoGridSquare3 = isoCell.getGridSquare(this.wx * 10 + 10, this.wy * 10 + n, n2)) == null || isoGridSquare3.getObjects().isEmpty()) continue;
                isoGridSquare3.EnsureSurroundNotNull();
            }
        }
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 10; ++n) {
                for (int i = 0; i < 8; ++i) {
                    isoGridSquare = this.getGridSquare(n2, n, i);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.RecalcAllWithNeighbours(true);
                    IsoRoom isoRoom = isoGridSquare.getRoom();
                    if (isoRoom == null) continue;
                    isoRoom.addSquare(isoGridSquare);
                }
            }
        }
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < 10; ++n) {
                for (int i = 0; i < 8; ++i) {
                    isoGridSquare = this.getGridSquare(n2, n, i);
                    if (isoGridSquare == null) continue;
                    isoGridSquare.propertiesDirty = true;
                }
            }
        }
        IsoLightSwitch.chunkLoaded(this);
    }

    public void updateBuildings() {
    }

    public static void updatePlayerInBullet() {
        ArrayList<IsoPlayer> arrayList = GameServer.getPlayers();
        Bullet.updatePlayerList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        if (!GameServer.bServer) {
            this.checkPhysics();
        }
        if (!this.loadedPhysics) {
            this.loadedPhysics = true;
            for (int i = 0; i < this.vehicles.size(); ++i) {
                this.vehicles.get((int)i).chunk = this;
            }
        }
        if (this.vehiclesForAddToWorld != null) {
            Object object = this.vehiclesForAddToWorldLock;
            synchronized (object) {
                for (int i = 0; i < this.vehiclesForAddToWorld.size(); ++i) {
                    this.vehiclesForAddToWorld.get(i).addToWorld();
                }
                this.vehiclesForAddToWorld.clear();
                this.vehiclesForAddToWorld = null;
            }
        }
        this.updateVehicleStory();
    }

    public void updateVehicleStory() {
        if (!this.bLoaded || this.m_vehicleStorySpawnData == null) {
            return;
        }
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(this.wx, this.wy);
        if (isoMetaChunk == null) {
            return;
        }
        VehicleStorySpawnData vehicleStorySpawnData = this.m_vehicleStorySpawnData;
        for (int i = 0; i < isoMetaChunk.numZones(); ++i) {
            IsoMetaGrid.Zone zone = isoMetaChunk.getZone(i);
            if (!vehicleStorySpawnData.isValid(zone, this)) continue;
            vehicleStorySpawnData.m_story.randomizeVehicleStory(zone, this);
            ++zone.hourLastSeen;
            break;
        }
    }

    public void setSquare(int n, int n2, int n3, IsoGridSquare isoGridSquare) {
        assert (isoGridSquare == null || isoGridSquare.x - this.wx * 10 == n && isoGridSquare.y - this.wy * 10 == n2 && isoGridSquare.z == n3);
        this.squares[n3][n2 * 10 + n] = isoGridSquare;
        if (isoGridSquare != null) {
            isoGridSquare.chunk = this;
            if (isoGridSquare.z > this.maxLevel) {
                this.maxLevel = isoGridSquare.z;
            }
        }
    }

    public IsoGridSquare getGridSquare(int n, int n2, int n3) {
        if (n < 0 || n >= 10 || n2 < 0 || n2 >= 10 || n3 >= 8 || n3 < 0) {
            return null;
        }
        return this.squares[n3][n2 * 10 + n];
    }

    public IsoRoom getRoom(int n) {
        return this.lotheader.getRoom(n);
    }

    public void removeFromWorld() {
        int n;
        loadGridSquare.remove(this);
        if (GameClient.bClient && GameClient.instance.bConnected) {
            try {
                GameClient.instance.sendAddedRemovedItems(true);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
            }
        }
        try {
            MapCollisionData.instance.removeChunkFromWorld(this);
            ZombiePopulationManager.instance.removeChunkFromWorld(this);
            PolygonalMap2.instance.removeChunkFromWorld(this);
            this.collision.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int n2 = 100;
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < n2; ++i) {
                IsoObject isoObject;
                int n3;
                IsoGridSquare isoGridSquare = this.squares[n][i];
                if (isoGridSquare == null) continue;
                RainManager.RemoveAllOn(isoGridSquare);
                isoGridSquare.clearWater();
                isoGridSquare.clearPuddles();
                if (isoGridSquare.getRoom() != null) {
                    isoGridSquare.getRoom().removeSquare(isoGridSquare);
                }
                if (isoGridSquare.zone != null) {
                    isoGridSquare.zone.removeSquare(isoGridSquare);
                }
                ArrayList<IsoMovingObject> arrayList = isoGridSquare.getMovingObjects();
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    isoObject = arrayList.get(n3);
                    if (isoObject instanceof IsoSurvivor) {
                        IsoWorld.instance.CurrentCell.getSurvivorList().remove(isoObject);
                        ((IsoMovingObject)isoObject).Despawn();
                    }
                    ((IsoMovingObject)isoObject).removeFromWorld();
                    ((IsoMovingObject)isoObject).last = null;
                    ((IsoMovingObject)isoObject).current = null;
                    if (arrayList.contains(isoObject)) continue;
                    --n3;
                }
                arrayList.clear();
                for (n3 = 0; n3 < isoGridSquare.getObjects().size(); ++n3) {
                    isoObject = isoGridSquare.getObjects().get(n3);
                    isoObject.removeFromWorld();
                }
                for (n3 = 0; n3 < isoGridSquare.getStaticMovingObjects().size(); ++n3) {
                    isoObject = isoGridSquare.getStaticMovingObjects().get(n3);
                    ((IsoMovingObject)isoObject).removeFromWorld();
                }
                this.disconnectFromAdjacentChunks(isoGridSquare);
                isoGridSquare.softClear();
                isoGridSquare.chunk = null;
            }
        }
        for (n = 0; n < this.vehicles.size(); ++n) {
            BaseVehicle baseVehicle = this.vehicles.get(n);
            if (!IsoWorld.instance.CurrentCell.getVehicles().contains(baseVehicle) && !IsoWorld.instance.CurrentCell.addVehicles.contains(baseVehicle)) continue;
            DebugLog.log("IsoChunk.removeFromWorld: vehicle wasn't removed from world id=" + baseVehicle.VehicleID);
            baseVehicle.removeFromWorld();
        }
    }

    private void disconnectFromAdjacentChunks(IsoGridSquare isoGridSquare) {
        int n = isoGridSquare.x % 10;
        int n2 = isoGridSquare.y % 10;
        if (n != 0 && n != 9 && n2 != 0 && n2 != 9) {
            return;
        }
        int n3 = IsoDirections.N.index();
        int n4 = IsoDirections.S.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].s = null;
        }
        n3 = IsoDirections.NW.index();
        n4 = IsoDirections.SE.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].se = null;
        }
        n3 = IsoDirections.W.index();
        n4 = IsoDirections.E.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].e = null;
        }
        n3 = IsoDirections.SW.index();
        n4 = IsoDirections.NE.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].ne = null;
        }
        n3 = IsoDirections.S.index();
        n4 = IsoDirections.N.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].n = null;
        }
        n3 = IsoDirections.SE.index();
        n4 = IsoDirections.NW.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].nw = null;
        }
        n3 = IsoDirections.E.index();
        n4 = IsoDirections.W.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].w = null;
        }
        n3 = IsoDirections.NE.index();
        n4 = IsoDirections.SW.index();
        if (isoGridSquare.nav[n3] != null && isoGridSquare.nav[n3].chunk != isoGridSquare.chunk) {
            isoGridSquare.nav[n3].nav[n4] = null;
            isoGridSquare.nav[n3].sw = null;
        }
    }

    public void doReuseGridsquares() {
        int n = 100;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < n; ++j) {
                IsoGridSquare isoGridSquare = this.squares[i][j];
                if (isoGridSquare == null) continue;
                LuaEventManager.triggerEvent("ReuseGridsquare", isoGridSquare);
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    IsoObject isoObject = isoGridSquare.getObjects().get(k);
                    if (isoObject instanceof IsoTree) {
                        isoObject.reset();
                        CellLoader.isoTreeCache.add((IsoTree)isoObject);
                        continue;
                    }
                    if (isoObject instanceof IsoObject && isoObject.getObjectName().equals("IsoObject")) {
                        isoObject.reset();
                        CellLoader.isoObjectCache.add(isoObject);
                        continue;
                    }
                    isoObject.reuseGridSquare();
                }
                isoGridSquare.discard();
                this.squares[i][j] = null;
            }
        }
        this.resetForStore();
        assert (!IsoChunkMap.chunkStore.contains(this));
        IsoChunkMap.chunkStore.add(this);
    }

    private static int bufferSize(int n) {
        return (n + 65536 - 1) / 65536 * 65536;
    }

    private static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(IsoChunk.bufferSize(n));
        }
        return byteBuffer;
    }

    private static ByteBuffer ensureCapacity(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return ByteBuffer.allocate(65536);
        }
        if (byteBuffer.capacity() - byteBuffer.position() < 65536) {
            ByteBuffer byteBuffer2 = IsoChunk.ensureCapacity(null, byteBuffer.position() + 65536);
            return byteBuffer2.put(byteBuffer.array(), 0, byteBuffer.position());
        }
        return byteBuffer;
    }

    public void LoadFromDisk() throws IOException {
        this.LoadFromDiskOrBuffer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void LoadFromDiskOrBuffer(ByteBuffer byteBuffer) throws IOException {
        sanityCheck.beginLoad(this);
        try {
            byte by;
            int n;
            int n2;
            int n3;
            int n4;
            ByteBuffer byteBuffer2 = byteBuffer == null ? (SliceBufferLoad = IsoChunk.SafeRead(prefix, this.wx, this.wy, SliceBufferLoad)) : byteBuffer;
            int n5 = this.wx * 10;
            int n6 = this.wy * 10;
            String string = ChunkMapFilenames.instance.getHeader(n5 /= 300, n6 /= 300);
            if (IsoLot.InfoHeaders.containsKey(string)) {
                this.lotheader = IsoLot.InfoHeaders.get(string);
            }
            IsoCell.wx = this.wx;
            IsoCell.wy = this.wy;
            boolean bl = byteBuffer2.get() == 1;
            int n7 = byteBuffer2.getInt();
            if (bl) {
                DebugLog.log("WorldVersion = " + n7 + ", debug = " + bl);
            }
            if (n7 > 195) {
                throw new RuntimeException("unknown world version " + n7 + " while reading chunk " + this.wx + "," + this.wy);
            }
            boolean bl2 = this.bFixed2x = n7 >= 85;
            if (n7 >= 61) {
                n4 = byteBuffer2.getInt();
                sanityCheck.checkLength(n4, byteBuffer2.limit());
                long l = byteBuffer2.getLong();
                crcLoad.reset();
                crcLoad.update(byteBuffer2.array(), 17, byteBuffer2.limit() - 1 - 4 - 4 - 8);
                sanityCheck.checkCRC(l, crcLoad.getValue());
            }
            n4 = 0;
            if (GameClient.bClient || GameServer.bServer) {
                n4 = ServerOptions.getInstance().BloodSplatLifespanDays.getValue();
            }
            float f = (float)GameTime.getInstance().getWorldAgeHours();
            int n8 = byteBuffer2.getInt();
            for (int i = 0; i < n8; ++i) {
                IsoFloorBloodSplat isoFloorBloodSplat = new IsoFloorBloodSplat();
                isoFloorBloodSplat.load(byteBuffer2, n7);
                if (isoFloorBloodSplat.worldAge > f) {
                    isoFloorBloodSplat.worldAge = f;
                }
                if (n4 > 0 && f - isoFloorBloodSplat.worldAge >= (float)(n4 * 24)) continue;
                if (n7 < 73 && isoFloorBloodSplat.Type < 8) {
                    isoFloorBloodSplat.index = ++this.nextSplatIndex;
                }
                if (isoFloorBloodSplat.Type < 8) {
                    this.nextSplatIndex = isoFloorBloodSplat.index % 10;
                }
                this.FloorBloodSplats.add(isoFloorBloodSplat);
            }
            IsoMetaGrid isoMetaGrid = IsoWorld.instance.getMetaGrid();
            byte by2 = 0;
            for (n3 = 0; n3 < 10; ++n3) {
                for (n2 = 0; n2 < 10; ++n2) {
                    by2 = byteBuffer2.get();
                    for (n = 0; n < 8; ++n) {
                        IsoGridSquare isoGridSquare = null;
                        by = 0;
                        if ((by2 & 1 << n) != 0) {
                            by = 1;
                        }
                        if (by == 1) {
                            if (isoGridSquare == null) {
                                isoGridSquare = IsoGridSquare.loadGridSquareCache != null ? IsoGridSquare.getNew(IsoGridSquare.loadGridSquareCache, IsoWorld.instance.CurrentCell, null, n3 + this.wx * 10, n2 + this.wy * 10, n) : IsoGridSquare.getNew(IsoWorld.instance.CurrentCell, null, n3 + this.wx * 10, n2 + this.wy * 10, n);
                            }
                            isoGridSquare.chunk = this;
                            if (this.lotheader != null) {
                                RoomDef roomDef = isoMetaGrid.getRoomAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
                                int n9 = roomDef != null ? roomDef.ID : -1;
                                isoGridSquare.setRoomID(n9);
                                roomDef = isoMetaGrid.getEmptyOutsideAt(isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
                                if (roomDef != null) {
                                    IsoRoom isoRoom = this.getRoom(roomDef.ID);
                                    isoGridSquare.roofHideBuilding = isoRoom == null ? null : isoRoom.building;
                                }
                            }
                            isoGridSquare.ResetIsoWorldRegion();
                            this.setSquare(n3, n2, n, isoGridSquare);
                        }
                        if (by != 1 || isoGridSquare == null) continue;
                        isoGridSquare.load(byteBuffer2, n7, bl);
                        isoGridSquare.FixStackableObjects();
                        if (this.jobType != JobType.SoftReset) continue;
                        if (!isoGridSquare.getStaticMovingObjects().isEmpty()) {
                            isoGridSquare.getStaticMovingObjects().clear();
                        }
                        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
                            IsoObject isoObject = isoGridSquare.getObjects().get(i);
                            isoObject.softReset();
                            if (isoObject.getObjectIndex() != -1) continue;
                            --i;
                        }
                        isoGridSquare.setOverlayDone(false);
                    }
                }
            }
            if (n7 >= 45) {
                this.getErosionData().load(byteBuffer2, n7);
                this.getErosionData().set(this);
            }
            if (n7 >= 127) {
                n3 = byteBuffer2.getShort();
                if (n3 > 0 && this.generatorsTouchingThisChunk == null) {
                    this.generatorsTouchingThisChunk = new ArrayList();
                }
                if (this.generatorsTouchingThisChunk != null) {
                    this.generatorsTouchingThisChunk.clear();
                }
                for (n2 = 0; n2 < n3; ++n2) {
                    n = byteBuffer2.getInt();
                    int n10 = byteBuffer2.getInt();
                    by = byteBuffer2.get();
                    IsoGameCharacter.Location location = new IsoGameCharacter.Location(n, n10, by);
                    this.generatorsTouchingThisChunk.add(location);
                }
            }
            this.vehicles.clear();
            if (!GameClient.bClient) {
                if (n7 >= 91) {
                    n3 = byteBuffer2.getShort();
                    for (n2 = 0; n2 < n3; ++n2) {
                        IsoGridSquare isoGridSquare;
                        n = byteBuffer2.get();
                        byte by3 = byteBuffer2.get();
                        by = byteBuffer2.get();
                        IsoObject isoObject = IsoObject.factoryFromFileInput(IsoWorld.instance.CurrentCell, byteBuffer2);
                        if (isoObject == null || !(isoObject instanceof BaseVehicle)) continue;
                        isoObject.square = isoGridSquare = this.getGridSquare(n, by3, by);
                        ((IsoMovingObject)isoObject).current = isoGridSquare;
                        try {
                            isoObject.load(byteBuffer2, n7, bl);
                            this.vehicles.add((BaseVehicle)isoObject);
                            IsoChunk.addFromCheckedVehicles((BaseVehicle)isoObject);
                            if (this.jobType != JobType.SoftReset) continue;
                            isoObject.softReset();
                            continue;
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception);
                        }
                    }
                }
                if (n7 >= 125) {
                    this.lootRespawnHour = byteBuffer2.getInt();
                }
                if (n7 >= 160) {
                    n3 = byteBuffer2.get();
                    for (n2 = 0; n2 < n3; ++n2) {
                        n = byteBuffer2.getInt();
                        this.addSpawnedRoom(n);
                    }
                }
            }
        }
        finally {
            sanityCheck.endLoad(this);
            this.bFixed2x = true;
        }
        if (this.getGridSquare(0, 0, 0) == null && this.getGridSquare(9, 9, 0) == null) {
            throw new RuntimeException("black chunk " + this.wx + "," + this.wy);
        }
    }

    public void doLoadGridsquare() {
        int n;
        if (this.jobType == JobType.SoftReset) {
            this.m_spawnedRooms.clear();
        }
        if (!GameServer.bServer) {
            this.loadInMainThread();
        }
        if (this.addZombies && !VehiclesDB2.instance.isChunkSeen(this.wx, this.wy)) {
            try {
                this.AddVehicles();
            }
            catch (Throwable throwable) {
                ExceptionLogger.logException(throwable);
            }
        }
        this.AddZombieZoneStory();
        VehiclesDB2.instance.setChunkSeen(this.wx, this.wy);
        if (this.addZombies) {
            if (IsoWorld.instance.getTimeSinceLastSurvivorInHorde() > 0) {
                IsoWorld.instance.setTimeSinceLastSurvivorInHorde(IsoWorld.instance.getTimeSinceLastSurvivorInHorde() - 1);
            }
            this.addSurvivorInHorde(false);
        }
        this.update();
        if (!GameServer.bServer) {
            FliesSound.instance.chunkLoaded(this);
            NearestWalls.chunkLoaded(this);
        }
        if (this.addZombies) {
            int n2 = 5 + SandboxOptions.instance.TimeSinceApo.getValue();
            if (Rand.Next(n2 = Math.min(20, n2)) == 0) {
                this.AddCorpses(this.wx, this.wy);
            }
            if (Rand.Next(n2 * 2) == 0) {
                this.AddBlood(this.wx, this.wy);
            }
        }
        LoadGridsquarePerformanceWorkaround.init(this.wx, this.wy);
        tempBuildings.clear();
        if (!GameClient.bClient) {
            for (int i = 0; i < this.vehicles.size(); ++i) {
                BaseVehicle baseVehicle = this.vehicles.get(i);
                if (!baseVehicle.addedToWorld && VehiclesDB2.instance.isVehicleLoaded(baseVehicle)) {
                    baseVehicle.removeFromSquare();
                    this.vehicles.remove(i);
                    --i;
                    continue;
                }
                if (!baseVehicle.addedToWorld) {
                    baseVehicle.addToWorld();
                }
                if (baseVehicle.sqlID != -1) continue;
                assert (false);
                if (baseVehicle.square == null) {
                    float f = 5.0E-4f;
                    int n3 = this.wx * 10;
                    n = this.wy * 10;
                    int n4 = n3 + 10;
                    int n5 = n + 10;
                    float f2 = PZMath.clamp(baseVehicle.x, (float)n3 + f, (float)n4 - f);
                    float f3 = PZMath.clamp(baseVehicle.y, (float)n + f, (float)n5 - f);
                    baseVehicle.square = this.getGridSquare((int)f2 - this.wx * 10, (int)f3 - this.wy * 10, 0);
                }
                VehiclesDB2.instance.addVehicle(baseVehicle);
            }
        }
        this.m_treeCount = 0;
        this.m_scavengeZone = null;
        this.m_numberOfWaterTiles = 0;
        for (int i = 0; i <= this.maxLevel; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoObject isoObject;
                    IsoGridSquare isoGridSquare = this.getGridSquare(j, k, i);
                    if (isoGridSquare != null && !isoGridSquare.getObjects().isEmpty()) {
                        for (n = 0; n < isoGridSquare.getObjects().size(); ++n) {
                            isoObject = isoGridSquare.getObjects().get(n);
                            isoObject.addToWorld();
                            if (i != 0 || isoObject.getSprite() == null || !isoObject.getSprite().getProperties().Is(IsoFlagType.water)) continue;
                            ++this.m_numberOfWaterTiles;
                        }
                        if (isoGridSquare.HasTree()) {
                            ++this.m_treeCount;
                        }
                        if (this.jobType != JobType.SoftReset) {
                            ErosionMain.LoadGridsquare(isoGridSquare);
                        }
                        if (this.addZombies) {
                            MapObjects.newGridSquare(isoGridSquare);
                        }
                        MapObjects.loadGridSquare(isoGridSquare);
                        LuaEventManager.triggerEvent("LoadGridsquare", isoGridSquare);
                        LoadGridsquarePerformanceWorkaround.LoadGridsquare(isoGridSquare);
                    }
                    if (isoGridSquare != null && !isoGridSquare.getStaticMovingObjects().isEmpty()) {
                        for (n = 0; n < isoGridSquare.getStaticMovingObjects().size(); ++n) {
                            isoObject = isoGridSquare.getStaticMovingObjects().get(n);
                            isoObject.addToWorld();
                        }
                    }
                    if (isoGridSquare == null || isoGridSquare.getBuilding() == null || tempBuildings.contains(isoGridSquare.getBuilding())) continue;
                    tempBuildings.add(isoGridSquare.getBuilding());
                }
            }
        }
        if (this.jobType != JobType.SoftReset) {
            ErosionMain.ChunkLoaded(this);
        }
        if (this.jobType != JobType.SoftReset) {
            SGlobalObjects.chunkLoaded(this.wx, this.wy);
        }
        ReanimatedPlayers.instance.addReanimatedPlayersToChunk(this);
        if (this.jobType != JobType.SoftReset) {
            MapCollisionData.instance.addChunkToWorld(this);
            ZombiePopulationManager.instance.addChunkToWorld(this);
            PolygonalMap2.instance.addChunkToWorld(this);
            IsoGenerator.chunkLoaded(this);
            LootRespawn.chunkLoaded(this);
        }
        if (!GameServer.bServer) {
            ArrayList<IsoRoomLight> arrayList = IsoWorld.instance.CurrentCell.roomLights;
            for (int i = 0; i < this.roomLights.size(); ++i) {
                IsoRoomLight isoRoomLight = this.roomLights.get(i);
                if (arrayList.contains(isoRoomLight)) continue;
                arrayList.add(isoRoomLight);
            }
        }
        this.roomLights.clear();
        if (this.jobType != JobType.SoftReset) {
            this.randomizeBuildingsEtc();
        }
        this.checkAdjacentChunks();
        try {
            if (GameServer.bServer && this.jobType != JobType.SoftReset) {
                for (int i = 0; i < GameServer.udpEngine.connections.size(); ++i) {
                    UdpConnection udpConnection = GameServer.udpEngine.connections.get(i);
                    if (udpConnection.chunkObjectState.isEmpty()) continue;
                    for (int j = 0; j < udpConnection.chunkObjectState.size(); j += 2) {
                        short s = udpConnection.chunkObjectState.get(j);
                        n = udpConnection.chunkObjectState.get(j + 1);
                        if (s != this.wx || n != this.wy) continue;
                        udpConnection.chunkObjectState.remove(j, 2);
                        j -= 2;
                        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
                        PacketTypes.PacketType.ChunkObjectState.doPacket(byteBufferWriter);
                        byteBufferWriter.putShort((short)this.wx);
                        byteBufferWriter.putShort((short)this.wy);
                        try {
                            if (this.saveObjectState(byteBufferWriter.bb)) {
                                PacketTypes.PacketType.ChunkObjectState.send(udpConnection);
                                continue;
                            }
                            udpConnection.cancelPacket();
                            continue;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            udpConnection.cancelPacket();
                        }
                    }
                }
            }
            if (GameClient.bClient) {
                ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
                PacketTypes.PacketType.ChunkObjectState.doPacket(byteBufferWriter);
                byteBufferWriter.putShort((short)this.wx);
                byteBufferWriter.putShort((short)this.wy);
                PacketTypes.PacketType.ChunkObjectState.send(GameClient.connection);
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
    }

    private void randomizeBuildingsEtc() {
        Object object;
        int n;
        tempRoomDefs.clear();
        IsoWorld.instance.MetaGrid.getRoomsIntersecting(this.wx * 10 - 1, this.wy * 10 - 1, 11, 11, tempRoomDefs);
        for (n = 0; n < tempRoomDefs.size(); ++n) {
            IsoBuilding isoBuilding;
            object = tempRoomDefs.get(n).getIsoRoom();
            if (object == null || tempBuildings.contains(isoBuilding = ((IsoRoom)object).getBuilding())) continue;
            tempBuildings.add(isoBuilding);
        }
        for (n = 0; n < tempBuildings.size(); ++n) {
            object = tempBuildings.get(n);
            if (!GameClient.bClient && ((IsoBuilding)object).def != null && ((IsoBuilding)object).def.isFullyStreamedIn()) {
                StashSystem.doBuildingStash(((IsoBuilding)object).def);
            }
            RandomizedBuildingBase.ChunkLoaded((IsoBuilding)object);
        }
        if (!GameClient.bClient && !tempBuildings.isEmpty()) {
            for (n = 0; n < tempBuildings.size(); ++n) {
                object = tempBuildings.get(n);
                for (int i = 0; i < ((IsoBuilding)object).Rooms.size(); ++i) {
                    IsoRoom isoRoom = ((IsoBuilding)object).Rooms.get(i);
                    if (!isoRoom.def.bDoneSpawn || this.isSpawnedRoom(isoRoom.def.ID) || !isoRoom.def.intersects(this.wx * 10, this.wy * 10, 10, 10)) continue;
                    this.addSpawnedRoom(isoRoom.def.ID);
                    VirtualZombieManager.instance.addIndoorZombiesToChunk(this, isoRoom);
                }
            }
        }
    }

    private void checkAdjacentChunks() {
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoChunk isoChunk;
                if (j == 0 && i == 0 || (isoChunk = isoCell.getChunk(this.wx + j, this.wy + i)) == null) continue;
                ++isoChunk.m_adjacentChunkLoadedCounter;
            }
        }
    }

    private void AddZombieZoneStory() {
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaChunk(this.wx, this.wy);
        if (isoMetaChunk == null) {
            return;
        }
        for (int i = 0; i < isoMetaChunk.numZones(); ++i) {
            IsoMetaGrid.Zone zone = isoMetaChunk.getZone(i);
            RandomizedZoneStoryBase.isValidForStory(zone, false);
        }
    }

    public void setCache() {
        IsoWorld.instance.CurrentCell.setCacheChunk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChunkLock acquireLock(int n, int n2) {
        ArrayList<ChunkLock> arrayList = Locks;
        synchronized (arrayList) {
            for (int i = 0; i < Locks.size(); ++i) {
                if (IsoChunk.Locks.get((int)i).wx != n || IsoChunk.Locks.get((int)i).wy != n2) continue;
                return Locks.get(i).ref();
            }
            ChunkLock chunkLock = FreeLocks.isEmpty() ? new ChunkLock(n, n2) : FreeLocks.pop().set(n, n2);
            Locks.add(chunkLock);
            return chunkLock.ref();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseLock(ChunkLock chunkLock) {
        ArrayList<ChunkLock> arrayList = Locks;
        synchronized (arrayList) {
            if (chunkLock.deref() == 0) {
                Locks.remove(chunkLock);
                FreeLocks.push(chunkLock);
            }
        }
    }

    public void setCacheIncludingNull() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoGridSquare isoGridSquare = this.getGridSquare(j, k, i);
                    IsoWorld.instance.CurrentCell.setCacheGridSquare(this.wx * 10 + j, this.wy * 10 + k, i, isoGridSquare);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Save(boolean bl) throws IOException {
        if (Core.getInstance().isNoSave() || GameClient.bClient) {
            if (!bl && !GameServer.bServer && this.jobType != JobType.Convert) {
                WorldReuserThread.instance.addReuseChunk(this);
            }
            return;
        }
        Object object = WriteLock;
        synchronized (object) {
            sanityCheck.beginSave(this);
            try {
                File file = ChunkMapFilenames.instance.getDir(Core.GameSaveWorld);
                if (!file.exists()) {
                    file.mkdir();
                }
                SliceBuffer = this.Save(SliceBuffer, crcSave);
                if (GameClient.bClient || GameServer.bServer) {
                    long l = ChunkChecksum.getChecksumIfExists(this.wx, this.wy);
                    crcSave.reset();
                    crcSave.update(SliceBuffer.array(), 0, SliceBuffer.position());
                    if (l != crcSave.getValue()) {
                        ChunkChecksum.setChecksum(this.wx, this.wy, crcSave.getValue());
                        IsoChunk.SafeWrite(prefix, this.wx, this.wy, SliceBuffer);
                    }
                } else {
                    IsoChunk.SafeWrite(prefix, this.wx, this.wy, SliceBuffer);
                }
                if (!bl && !GameServer.bServer) {
                    if (this.jobType != JobType.Convert) {
                        WorldReuserThread.instance.addReuseChunk(this);
                    } else {
                        this.doReuseGridsquares();
                    }
                }
            }
            finally {
                sanityCheck.endSave(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void SafeWrite(String string, int n, int n2, ByteBuffer byteBuffer) throws IOException {
        ChunkLock chunkLock = IsoChunk.acquireLock(n, n2);
        chunkLock.lockForWriting();
        try {
            File file = ChunkMapFilenames.instance.getFilename(n, n2);
            sanityCheck.beginSaveFile(file.getAbsolutePath());
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
                fileOutputStream.getChannel().truncate(0L);
                fileOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
            }
            finally {
                sanityCheck.endSaveFile();
            }
        }
        finally {
            chunkLock.unlockForWriting();
            IsoChunk.releaseLock(chunkLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer SafeRead(String string, int n, int n2, ByteBuffer byteBuffer) throws IOException {
        ChunkLock chunkLock = IsoChunk.acquireLock(n, n2);
        chunkLock.lockForReading();
        try {
            File file = ChunkMapFilenames.instance.getFilename(n, n2);
            if (file == null) {
                file = ZomboidFileSystem.instance.getFileInCurrentSave(string + n + "_" + n2 + ".bin");
            }
            sanityCheck.beginLoadFile(file.getAbsolutePath());
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                byteBuffer = IsoChunk.ensureCapacity(byteBuffer, (int)file.length());
                byteBuffer.clear();
                int n3 = fileInputStream.read(byteBuffer.array());
                byteBuffer.limit(PZMath.max(n3, 0));
            }
            finally {
                sanityCheck.endLoadFile(file.getAbsolutePath());
            }
        }
        finally {
            chunkLock.unlockForReading();
            IsoChunk.releaseLock(chunkLock);
        }
        return byteBuffer;
    }

    public void SaveLoadedChunk(ClientChunkRequest.Chunk chunk, CRC32 cRC32) throws IOException {
        chunk.bb = this.Save(chunk.bb, cRC32);
    }

    public static boolean IsDebugSave() {
        if (!Core.bDebug) {
            return false;
        }
        return false;
    }

    public ByteBuffer Save(ByteBuffer byteBuffer, CRC32 cRC32) throws IOException {
        int n;
        int n2;
        byteBuffer.rewind();
        byteBuffer = IsoChunk.ensureCapacity(byteBuffer);
        byteBuffer.clear();
        byteBuffer.put(IsoChunk.IsDebugSave() ? (byte)1 : 0);
        byteBuffer.putInt(195);
        byteBuffer.putInt(0);
        byteBuffer.putLong(0L);
        int n3 = Math.min(1000, this.FloorBloodSplats.size());
        int n4 = this.FloorBloodSplats.size() - n3;
        byteBuffer.putInt(n3);
        for (n2 = n4; n2 < this.FloorBloodSplats.size(); ++n2) {
            IsoFloorBloodSplat isoFloorBloodSplat = this.FloorBloodSplats.get(n2);
            isoFloorBloodSplat.save(byteBuffer);
        }
        n2 = byteBuffer.position();
        byte by = 0;
        int n5 = 0;
        int n6 = 0;
        for (n = 0; n < 10; ++n) {
            for (int i = 0; i < 10; ++i) {
                by = 0;
                n5 = byteBuffer.position();
                byteBuffer.put(by);
                block5: for (int j = 0; j < 8; ++j) {
                    IsoGridSquare isoGridSquare = this.getGridSquare(n, i, j);
                    byteBuffer = IsoChunk.ensureCapacity(byteBuffer);
                    if (isoGridSquare == null || !isoGridSquare.shouldSave()) continue;
                    by = (byte)(by | 1 << j);
                    int n7 = byteBuffer.position();
                    while (true) {
                        try {
                            isoGridSquare.save(byteBuffer, null, IsoChunk.IsDebugSave());
                            continue block5;
                        }
                        catch (BufferOverflowException bufferOverflowException) {
                            DebugLog.log("IsoChunk.Save: BufferOverflowException, growing ByteBuffer");
                            byteBuffer = IsoChunk.ensureCapacity(byteBuffer);
                            byteBuffer.position(n7);
                            continue;
                        }
                        break;
                    }
                }
                n6 = byteBuffer.position();
                byteBuffer.position(n5);
                byteBuffer.put(by);
                byteBuffer.position(n6);
            }
        }
        byteBuffer = IsoChunk.ensureCapacity(byteBuffer);
        this.getErosionData().save(byteBuffer);
        if (this.generatorsTouchingThisChunk == null) {
            byteBuffer.putShort((short)0);
        } else {
            byteBuffer.putShort((short)this.generatorsTouchingThisChunk.size());
            for (n = 0; n < this.generatorsTouchingThisChunk.size(); ++n) {
                IsoGameCharacter.Location location = this.generatorsTouchingThisChunk.get(n);
                byteBuffer.putInt(location.x);
                byteBuffer.putInt(location.y);
                byteBuffer.put((byte)location.z);
            }
        }
        byteBuffer.putShort((short)0);
        if (!(GameServer.bServer && !GameServer.bSoftReset || GameClient.bClient || GameWindow.bLoadedAsClient)) {
            VehiclesDB2.instance.unloadChunk(this);
        }
        if (GameClient.bClient) {
            n = ServerOptions.instance.HoursForLootRespawn.getValue();
            this.lootRespawnHour = n <= 0 || GameTime.getInstance().getWorldAgeHours() < (double)n ? -1 : 7 + (int)(GameTime.getInstance().getWorldAgeHours() / (double)n) * n;
        }
        byteBuffer.putInt(this.lootRespawnHour);
        assert (this.m_spawnedRooms.size() <= 127);
        byteBuffer.put((byte)this.m_spawnedRooms.size());
        for (n = 0; n < this.m_spawnedRooms.size(); ++n) {
            byteBuffer.putInt(this.m_spawnedRooms.get(n));
        }
        n = byteBuffer.position();
        cRC32.reset();
        cRC32.update(byteBuffer.array(), 17, n - 1 - 4 - 4 - 8);
        byteBuffer.position(5);
        byteBuffer.putInt(n);
        byteBuffer.putLong(cRC32.getValue());
        byteBuffer.position(n);
        return byteBuffer;
    }

    public boolean saveObjectState(ByteBuffer byteBuffer) throws IOException {
        boolean bl = true;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    IsoGridSquare isoGridSquare = this.getGridSquare(k, j, i);
                    if (isoGridSquare == null) continue;
                    int n = isoGridSquare.getObjects().size();
                    IsoObject[] isoObjectArray = isoGridSquare.getObjects().getElements();
                    for (int i2 = 0; i2 < n; ++i2) {
                        IsoObject isoObject = isoObjectArray[i2];
                        int n2 = byteBuffer.position();
                        byteBuffer.position(n2 + 2 + 2 + 4 + 2);
                        int n3 = byteBuffer.position();
                        isoObject.saveState(byteBuffer);
                        int n4 = byteBuffer.position();
                        if (n4 > n3) {
                            byteBuffer.position(n2);
                            byteBuffer.putShort((short)(k + j * 10 + i * 10 * 10));
                            byteBuffer.putShort((short)i2);
                            byteBuffer.putInt(isoObject.getObjectName().hashCode());
                            byteBuffer.putShort((short)(n4 - n3));
                            byteBuffer.position(n4);
                            bl = false;
                            continue;
                        }
                        byteBuffer.position(n2);
                    }
                }
            }
        }
        if (bl) {
            return false;
        }
        byteBuffer.putShort((short)-1);
        return true;
    }

    public void loadObjectState(ByteBuffer byteBuffer) throws IOException {
        short s = byteBuffer.getShort();
        while (s != -1) {
            int n = s % 10;
            int n2 = s / 100;
            int n3 = (s - n2 * 10 * 10) / 10;
            short s2 = byteBuffer.getShort();
            int n4 = byteBuffer.getInt();
            short s3 = byteBuffer.getShort();
            int n5 = byteBuffer.position();
            IsoGridSquare isoGridSquare = this.getGridSquare(n, n3, n2);
            if (isoGridSquare != null && s2 >= 0 && s2 < isoGridSquare.getObjects().size()) {
                IsoObject isoObject = isoGridSquare.getObjects().get(s2);
                if (n4 == isoObject.getObjectName().hashCode()) {
                    isoObject.loadState(byteBuffer);
                    assert (byteBuffer.position() == n5 + s3);
                } else {
                    byteBuffer.position(n5 + s3);
                }
            } else {
                byteBuffer.position(n5 + s3);
            }
            s = byteBuffer.getShort();
        }
    }

    public void Blam(int n, int n2) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 10; ++j) {
                for (int k = 0; k < 10; ++k) {
                    this.setSquare(j, k, i, null);
                }
            }
        }
        this.blam = true;
    }

    private void BackupBlam(int n, int n2, Exception exception) {
        Object object;
        File file;
        File file2 = ZomboidFileSystem.instance.getFileInCurrentSave("blam");
        file2.mkdirs();
        try {
            file = new File(file2 + File.separator + "map_" + n + "_" + n2 + "_error.txt");
            object = new FileOutputStream(file);
            PrintStream printStream = new PrintStream((OutputStream)object);
            exception.printStackTrace(printStream);
            printStream.close();
        }
        catch (Exception exception2) {
            exception2.printStackTrace();
        }
        file = ZomboidFileSystem.instance.getFileInCurrentSave("map_" + n + "_" + n2 + ".bin");
        if (!file.exists()) {
            return;
        }
        object = new File(file2.getPath() + File.separator + "map_" + n + "_" + n2 + ".bin");
        try {
            IsoChunk.copyFile(file, (File)object);
        }
        catch (Exception exception3) {
            exception3.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        if (!file2.exists()) {
            file2.createNewFile();
        }
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            fileChannel = new FileInputStream(file).getChannel();
            abstractInterruptibleChannel = new FileOutputStream(file2).getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferFrom(fileChannel, 0L, fileChannel.size());
        }
        finally {
            if (fileChannel != null) {
                fileChannel.close();
            }
            if (abstractInterruptibleChannel != null) {
                abstractInterruptibleChannel.close();
            }
        }
    }

    public ErosionData.Chunk getErosionData() {
        if (this.erosion == null) {
            this.erosion = new ErosionData.Chunk();
        }
        return this.erosion;
    }

    private static int newtiledefinitions(int n, int n2) {
        int n3 = 1;
        return n3 * 100 * 1000 + 10000 + n * 1000 + n2;
    }

    public static int Fix2x(IsoGridSquare isoGridSquare, int n) {
        if (isoGridSquare == null || isoGridSquare.chunk == null) {
            return n;
        }
        if (isoGridSquare.chunk.bFixed2x) {
            return n;
        }
        HashMap<String, IsoSprite> hashMap = IsoSpriteManager.instance.NamedMap;
        if (n >= IsoChunk.newtiledefinitions(140, 48) && n <= IsoChunk.newtiledefinitions(140, 51)) {
            return -1;
        }
        if (n >= IsoChunk.newtiledefinitions(8, 14) && n <= IsoChunk.newtiledefinitions(8, 71) && n % 8 >= 6) {
            return -1;
        }
        if (n == IsoChunk.newtiledefinitions(92, 2)) {
            return n + 20;
        }
        if (n == IsoChunk.newtiledefinitions(92, 20)) {
            return n + 1;
        }
        if (n == IsoChunk.newtiledefinitions(92, 21)) {
            return n - 1;
        }
        if (n >= IsoChunk.newtiledefinitions(92, 26) && n <= IsoChunk.newtiledefinitions(92, 29)) {
            return n + 6;
        }
        if (n == IsoChunk.newtiledefinitions(11, 16)) {
            return IsoChunk.newtiledefinitions(11, 45);
        }
        if (n == IsoChunk.newtiledefinitions(11, 17)) {
            return IsoChunk.newtiledefinitions(11, 43);
        }
        if (n == IsoChunk.newtiledefinitions(11, 18)) {
            return IsoChunk.newtiledefinitions(11, 41);
        }
        if (n == IsoChunk.newtiledefinitions(11, 19)) {
            return IsoChunk.newtiledefinitions(11, 47);
        }
        if (n == IsoChunk.newtiledefinitions(11, 24)) {
            return IsoChunk.newtiledefinitions(11, 26);
        }
        if (n == IsoChunk.newtiledefinitions(11, 25)) {
            return IsoChunk.newtiledefinitions(11, 27);
        }
        if (n == IsoChunk.newtiledefinitions(27, 42)) {
            return n + 1;
        }
        if (n == IsoChunk.newtiledefinitions(27, 43)) {
            return n - 1;
        }
        if (n == IsoChunk.newtiledefinitions(27, 44)) {
            return n + 3;
        }
        if (n == IsoChunk.newtiledefinitions(27, 47)) {
            return n - 2;
        }
        if (n == IsoChunk.newtiledefinitions(27, 45)) {
            return n + 1;
        }
        if (n == IsoChunk.newtiledefinitions(27, 46)) {
            return n - 2;
        }
        if (n == IsoChunk.newtiledefinitions(34, 4)) {
            return n + 1;
        }
        if (n == IsoChunk.newtiledefinitions(34, 5)) {
            return n - 1;
        }
        if (n >= IsoChunk.newtiledefinitions(14, 0) && n <= IsoChunk.newtiledefinitions(14, 7)) {
            return -1;
        }
        if (n >= IsoChunk.newtiledefinitions(14, 8) && n <= IsoChunk.newtiledefinitions(14, 12)) {
            return n + 72;
        }
        if (n == IsoChunk.newtiledefinitions(14, 13)) {
            return n + 71;
        }
        if (n >= IsoChunk.newtiledefinitions(14, 16) && n <= IsoChunk.newtiledefinitions(14, 17)) {
            return n + 72;
        }
        if (n == IsoChunk.newtiledefinitions(14, 18)) {
            return n + 73;
        }
        if (n == IsoChunk.newtiledefinitions(14, 19)) {
            return n + 66;
        }
        if (n == IsoChunk.newtiledefinitions(14, 20)) {
            return -1;
        }
        if (n == IsoChunk.newtiledefinitions(14, 21)) {
            return IsoChunk.newtiledefinitions(14, 89);
        }
        if (n == IsoChunk.newtiledefinitions(21, 0)) {
            return IsoChunk.newtiledefinitions(125, 16);
        }
        if (n == IsoChunk.newtiledefinitions(21, 1)) {
            return IsoChunk.newtiledefinitions(125, 32);
        }
        if (n == IsoChunk.newtiledefinitions(21, 2)) {
            return IsoChunk.newtiledefinitions(125, 48);
        }
        if (n == IsoChunk.newtiledefinitions(26, 0)) {
            return IsoChunk.newtiledefinitions(26, 6);
        }
        if (n == IsoChunk.newtiledefinitions(26, 6)) {
            return IsoChunk.newtiledefinitions(26, 0);
        }
        if (n == IsoChunk.newtiledefinitions(26, 1)) {
            return IsoChunk.newtiledefinitions(26, 7);
        }
        if (n == IsoChunk.newtiledefinitions(26, 7)) {
            return IsoChunk.newtiledefinitions(26, 1);
        }
        if (n == IsoChunk.newtiledefinitions(26, 8)) {
            return IsoChunk.newtiledefinitions(26, 14);
        }
        if (n == IsoChunk.newtiledefinitions(26, 14)) {
            return IsoChunk.newtiledefinitions(26, 8);
        }
        if (n == IsoChunk.newtiledefinitions(26, 9)) {
            return IsoChunk.newtiledefinitions(26, 15);
        }
        if (n == IsoChunk.newtiledefinitions(26, 15)) {
            return IsoChunk.newtiledefinitions(26, 9);
        }
        if (n == IsoChunk.newtiledefinitions(26, 16)) {
            return IsoChunk.newtiledefinitions(26, 22);
        }
        if (n == IsoChunk.newtiledefinitions(26, 22)) {
            return IsoChunk.newtiledefinitions(26, 16);
        }
        if (n == IsoChunk.newtiledefinitions(26, 17)) {
            return IsoChunk.newtiledefinitions(26, 23);
        }
        if (n == IsoChunk.newtiledefinitions(26, 23)) {
            return IsoChunk.newtiledefinitions(26, 17);
        }
        if (n >= IsoChunk.newtiledefinitions(148, 0) && n <= IsoChunk.newtiledefinitions(148, 16)) {
            int n2 = n - IsoChunk.newtiledefinitions(148, 0);
            return IsoChunk.newtiledefinitions(160, n2);
        }
        if (n >= IsoChunk.newtiledefinitions(42, 44) && n <= IsoChunk.newtiledefinitions(42, 47) || n >= IsoChunk.newtiledefinitions(42, 52) && n <= IsoChunk.newtiledefinitions(42, 55)) {
            return -1;
        }
        if (n == IsoChunk.newtiledefinitions(43, 24)) {
            return n + 4;
        }
        if (n == IsoChunk.newtiledefinitions(43, 26)) {
            return n + 2;
        }
        if (n == IsoChunk.newtiledefinitions(43, 33)) {
            return n - 4;
        }
        if (n == IsoChunk.newtiledefinitions(44, 0)) {
            return IsoChunk.newtiledefinitions(44, 1);
        }
        if (n == IsoChunk.newtiledefinitions(44, 1)) {
            return IsoChunk.newtiledefinitions(44, 0);
        }
        if (n == IsoChunk.newtiledefinitions(44, 2)) {
            return IsoChunk.newtiledefinitions(44, 7);
        }
        if (n == IsoChunk.newtiledefinitions(44, 3)) {
            return IsoChunk.newtiledefinitions(44, 6);
        }
        if (n == IsoChunk.newtiledefinitions(44, 4)) {
            return IsoChunk.newtiledefinitions(44, 5);
        }
        if (n == IsoChunk.newtiledefinitions(44, 5)) {
            return IsoChunk.newtiledefinitions(44, 4);
        }
        if (n == IsoChunk.newtiledefinitions(44, 6)) {
            return IsoChunk.newtiledefinitions(44, 3);
        }
        if (n == IsoChunk.newtiledefinitions(44, 7)) {
            return IsoChunk.newtiledefinitions(44, 2);
        }
        if (n == IsoChunk.newtiledefinitions(44, 16)) {
            return IsoChunk.newtiledefinitions(44, 45);
        }
        if (n == IsoChunk.newtiledefinitions(44, 17)) {
            return IsoChunk.newtiledefinitions(44, 44);
        }
        if (n == IsoChunk.newtiledefinitions(44, 18)) {
            return IsoChunk.newtiledefinitions(44, 46);
        }
        if (n >= IsoChunk.newtiledefinitions(44, 19) && n <= IsoChunk.newtiledefinitions(44, 22)) {
            return n + 33;
        }
        if (n == IsoChunk.newtiledefinitions(44, 23)) {
            return IsoChunk.newtiledefinitions(44, 47);
        }
        if (n == IsoChunk.newtiledefinitions(46, 8)) {
            return IsoChunk.newtiledefinitions(46, 5);
        }
        if (n == IsoChunk.newtiledefinitions(46, 14)) {
            return IsoChunk.newtiledefinitions(46, 10);
        }
        if (n == IsoChunk.newtiledefinitions(46, 15)) {
            return IsoChunk.newtiledefinitions(46, 11);
        }
        if (n == IsoChunk.newtiledefinitions(46, 22)) {
            return IsoChunk.newtiledefinitions(46, 14);
        }
        if (n == IsoChunk.newtiledefinitions(46, 23)) {
            return IsoChunk.newtiledefinitions(46, 15);
        }
        if (n == IsoChunk.newtiledefinitions(46, 54)) {
            return IsoChunk.newtiledefinitions(46, 55);
        }
        if (n == IsoChunk.newtiledefinitions(46, 55)) {
            return IsoChunk.newtiledefinitions(46, 54);
        }
        if (n == IsoChunk.newtiledefinitions(106, 32)) {
            return IsoChunk.newtiledefinitions(106, 34);
        }
        if (n == IsoChunk.newtiledefinitions(106, 34)) {
            return IsoChunk.newtiledefinitions(106, 32);
        }
        if (n == IsoChunk.newtiledefinitions(47, 0) || n == IsoChunk.newtiledefinitions(47, 4)) {
            return n + 1;
        }
        if (n == IsoChunk.newtiledefinitions(47, 1) || n == IsoChunk.newtiledefinitions(47, 5)) {
            return n - 1;
        }
        if (n >= IsoChunk.newtiledefinitions(47, 8) && n <= IsoChunk.newtiledefinitions(47, 13)) {
            return n + 8;
        }
        if (n >= IsoChunk.newtiledefinitions(47, 22) && n <= IsoChunk.newtiledefinitions(47, 23)) {
            return n - 12;
        }
        if (n >= IsoChunk.newtiledefinitions(47, 44) && n <= IsoChunk.newtiledefinitions(47, 47)) {
            return n + 4;
        }
        if (n >= IsoChunk.newtiledefinitions(47, 48) && n <= IsoChunk.newtiledefinitions(47, 51)) {
            return n - 4;
        }
        if (n == IsoChunk.newtiledefinitions(48, 56)) {
            return IsoChunk.newtiledefinitions(48, 58);
        }
        if (n == IsoChunk.newtiledefinitions(48, 58)) {
            return IsoChunk.newtiledefinitions(48, 56);
        }
        if (n == IsoChunk.newtiledefinitions(52, 57)) {
            return IsoChunk.newtiledefinitions(52, 58);
        }
        if (n == IsoChunk.newtiledefinitions(52, 58)) {
            return IsoChunk.newtiledefinitions(52, 59);
        }
        if (n == IsoChunk.newtiledefinitions(52, 45)) {
            return IsoChunk.newtiledefinitions(52, 44);
        }
        if (n == IsoChunk.newtiledefinitions(52, 46)) {
            return IsoChunk.newtiledefinitions(52, 45);
        }
        if (n == IsoChunk.newtiledefinitions(54, 13)) {
            return IsoChunk.newtiledefinitions(54, 18);
        }
        if (n == IsoChunk.newtiledefinitions(54, 15)) {
            return IsoChunk.newtiledefinitions(54, 19);
        }
        if (n == IsoChunk.newtiledefinitions(54, 21)) {
            return IsoChunk.newtiledefinitions(54, 16);
        }
        if (n == IsoChunk.newtiledefinitions(54, 22)) {
            return IsoChunk.newtiledefinitions(54, 13);
        }
        if (n == IsoChunk.newtiledefinitions(54, 23)) {
            return IsoChunk.newtiledefinitions(54, 17);
        }
        if (n >= IsoChunk.newtiledefinitions(67, 0) && n <= IsoChunk.newtiledefinitions(67, 16)) {
            int n3 = 64 + Rand.Next(16);
            return hashMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"f_bushes_1_\u0001"}, (int)n3)).ID;
        }
        if (n == IsoChunk.newtiledefinitions(68, 6)) {
            return -1;
        }
        if (n >= IsoChunk.newtiledefinitions(68, 16) && n <= IsoChunk.newtiledefinitions(68, 17)) {
            return hashMap.get((Object)"d_plants_1_53").ID;
        }
        if (n >= IsoChunk.newtiledefinitions(68, 18) && n <= IsoChunk.newtiledefinitions(68, 23)) {
            int n4 = Rand.Next(4) * 16 + Rand.Next(8);
            return hashMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"d_plants_1_\u0001"}, (int)n4)).ID;
        }
        if (n >= IsoChunk.newtiledefinitions(79, 24) && n <= IsoChunk.newtiledefinitions(79, 41)) {
            return IsoChunk.newtiledefinitions(81, n - IsoChunk.newtiledefinitions(79, 24));
        }
        return n;
    }

    public static String Fix2x(String string) {
        int n;
        Object object;
        if (Fix2xMap.isEmpty()) {
            object = Fix2xMap;
            for (n = 48; n <= 51; ++n) {
                ((HashMap)object).put("blends_streetoverlays_01_" + n, "");
            }
            ((HashMap)object).put("fencing_01_14", "");
            ((HashMap)object).put("fencing_01_15", "");
            ((HashMap)object).put("fencing_01_22", "");
            ((HashMap)object).put("fencing_01_23", "");
            ((HashMap)object).put("fencing_01_30", "");
            ((HashMap)object).put("fencing_01_31", "");
            ((HashMap)object).put("fencing_01_38", "");
            ((HashMap)object).put("fencing_01_39", "");
            ((HashMap)object).put("fencing_01_46", "");
            ((HashMap)object).put("fencing_01_47", "");
            ((HashMap)object).put("fencing_01_62", "");
            ((HashMap)object).put("fencing_01_63", "");
            ((HashMap)object).put("fencing_01_70", "");
            ((HashMap)object).put("fencing_01_71", "");
            ((HashMap)object).put("fixtures_bathroom_02_2", "fixtures_bathroom_02_22");
            ((HashMap)object).put("fixtures_bathroom_02_20", "fixtures_bathroom_02_21");
            ((HashMap)object).put("fixtures_bathroom_02_21", "fixtures_bathroom_02_20");
            for (n = 26; n <= 29; ++n) {
                ((HashMap)object).put("fixtures_bathroom_02_" + n, "fixtures_bathroom_02_" + (n + 6));
            }
            ((HashMap)object).put("fixtures_counters_01_16", "fixtures_counters_01_45");
            ((HashMap)object).put("fixtures_counters_01_17", "fixtures_counters_01_43");
            ((HashMap)object).put("fixtures_counters_01_18", "fixtures_counters_01_41");
            ((HashMap)object).put("fixtures_counters_01_19", "fixtures_counters_01_47");
            ((HashMap)object).put("fixtures_counters_01_24", "fixtures_counters_01_26");
            ((HashMap)object).put("fixtures_counters_01_25", "fixtures_counters_01_27");
            for (n = 0; n <= 7; ++n) {
                ((HashMap)object).put("fixtures_railings_01_" + n, "");
            }
            for (n = 8; n <= 12; ++n) {
                ((HashMap)object).put("fixtures_railings_01_" + n, "fixtures_railings_01_" + (n + 72));
            }
            ((HashMap)object).put("fixtures_railings_01_13", "fixtures_railings_01_84");
            for (n = 16; n <= 17; ++n) {
                ((HashMap)object).put("fixtures_railings_01_" + n, "fixtures_railings_01_" + (n + 72));
            }
            ((HashMap)object).put("fixtures_railings_01_18", "fixtures_railings_01_91");
            ((HashMap)object).put("fixtures_railings_01_19", "fixtures_railings_01_85");
            ((HashMap)object).put("fixtures_railings_01_20", "");
            ((HashMap)object).put("fixtures_railings_01_21", "fixtures_railings_01_89");
            ((HashMap)object).put("floors_exterior_natural_01_0", "blends_natural_01_16");
            ((HashMap)object).put("floors_exterior_natural_01_1", "blends_natural_01_32");
            ((HashMap)object).put("floors_exterior_natural_01_2", "blends_natural_01_48");
            ((HashMap)object).put("floors_rugs_01_0", "floors_rugs_01_6");
            ((HashMap)object).put("floors_rugs_01_6", "floors_rugs_01_0");
            ((HashMap)object).put("floors_rugs_01_1", "floors_rugs_01_7");
            ((HashMap)object).put("floors_rugs_01_7", "floors_rugs_01_1");
            ((HashMap)object).put("floors_rugs_01_8", "floors_rugs_01_14");
            ((HashMap)object).put("floors_rugs_01_14", "floors_rugs_01_8");
            ((HashMap)object).put("floors_rugs_01_9", "floors_rugs_01_15");
            ((HashMap)object).put("floors_rugs_01_15", "floors_rugs_01_9");
            ((HashMap)object).put("floors_rugs_01_16", "floors_rugs_01_22");
            ((HashMap)object).put("floors_rugs_01_22", "floors_rugs_01_16");
            ((HashMap)object).put("floors_rugs_01_17", "floors_rugs_01_23");
            ((HashMap)object).put("floors_rugs_01_23", "floors_rugs_01_17");
            ((HashMap)object).put("furniture_bedding_01_42", "furniture_bedding_01_43");
            ((HashMap)object).put("furniture_bedding_01_43", "furniture_bedding_01_42");
            ((HashMap)object).put("furniture_bedding_01_44", "furniture_bedding_01_47");
            ((HashMap)object).put("furniture_bedding_01_47", "furniture_bedding_01_45");
            ((HashMap)object).put("furniture_bedding_01_45", "furniture_bedding_01_46");
            ((HashMap)object).put("furniture_bedding_01_46", "furniture_bedding_01_44");
            ((HashMap)object).put("furniture_tables_low_01_4", "furniture_tables_low_01_5");
            ((HashMap)object).put("furniture_tables_low_01_5", "furniture_tables_low_01_4");
            for (n = 0; n <= 5; ++n) {
                ((HashMap)object).put("location_business_machinery_" + n, "location_business_machinery_01_" + n);
                ((HashMap)object).put("location_business_machinery_" + (n + 8), "location_business_machinery_01_" + (n + 8));
                ((HashMap)object).put("location_ business_machinery_" + n, "location_business_machinery_01_" + n);
                ((HashMap)object).put("location_ business_machinery_" + (n + 8), "location_business_machinery_01_" + (n + 8));
            }
            for (n = 44; n <= 47; ++n) {
                ((HashMap)object).put("location_hospitality_sunstarmotel_01_" + n, "");
            }
            for (n = 52; n <= 55; ++n) {
                ((HashMap)object).put("location_hospitality_sunstarmotel_01_" + n, "");
            }
            ((HashMap)object).put("location_hospitality_sunstarmotel_02_24", "location_hospitality_sunstarmotel_02_28");
            ((HashMap)object).put("location_hospitality_sunstarmotel_02_26", "location_hospitality_sunstarmotel_02_28");
            ((HashMap)object).put("location_hospitality_sunstarmotel_02_33", "location_hospitality_sunstarmotel_02_29");
            ((HashMap)object).put("location_restaurant_bar_01_0", "location_restaurant_bar_01_1");
            ((HashMap)object).put("location_restaurant_bar_01_1", "location_restaurant_bar_01_0");
            ((HashMap)object).put("location_restaurant_bar_01_2", "location_restaurant_bar_01_7");
            ((HashMap)object).put("location_restaurant_bar_01_3", "location_restaurant_bar_01_6");
            ((HashMap)object).put("location_restaurant_bar_01_4", "location_restaurant_bar_01_5");
            ((HashMap)object).put("location_restaurant_bar_01_5", "location_restaurant_bar_01_4");
            ((HashMap)object).put("location_restaurant_bar_01_6", "location_restaurant_bar_01_3");
            ((HashMap)object).put("location_restaurant_bar_01_7", "location_restaurant_bar_01_2");
            ((HashMap)object).put("location_restaurant_bar_01_16", "location_restaurant_bar_01_45");
            ((HashMap)object).put("location_restaurant_bar_01_17", "location_restaurant_bar_01_44");
            ((HashMap)object).put("location_restaurant_bar_01_18", "location_restaurant_bar_01_46");
            for (n = 19; n <= 22; ++n) {
                ((HashMap)object).put("location_restaurant_bar_01_" + n, "location_restaurant_bar_01_" + (n + 33));
            }
            ((HashMap)object).put("location_restaurant_bar_01_23", "location_restaurant_bar_01_47");
            ((HashMap)object).put("location_restaurant_pie_01_8", "location_restaurant_pie_01_5");
            ((HashMap)object).put("location_restaurant_pie_01_14", "location_restaurant_pie_01_10");
            ((HashMap)object).put("location_restaurant_pie_01_15", "location_restaurant_pie_01_11");
            ((HashMap)object).put("location_restaurant_pie_01_22", "location_restaurant_pie_01_14");
            ((HashMap)object).put("location_restaurant_pie_01_23", "location_restaurant_pie_01_15");
            ((HashMap)object).put("location_restaurant_pie_01_54", "location_restaurant_pie_01_55");
            ((HashMap)object).put("location_restaurant_pie_01_55", "location_restaurant_pie_01_54");
            ((HashMap)object).put("location_pizzawhirled_01_32", "location_pizzawhirled_01_34");
            ((HashMap)object).put("location_pizzawhirled_01_34", "location_pizzawhirled_01_32");
            ((HashMap)object).put("location_restaurant_seahorse_01_0", "location_restaurant_seahorse_01_1");
            ((HashMap)object).put("location_restaurant_seahorse_01_1", "location_restaurant_seahorse_01_0");
            ((HashMap)object).put("location_restaurant_seahorse_01_4", "location_restaurant_seahorse_01_5");
            ((HashMap)object).put("location_restaurant_seahorse_01_5", "location_restaurant_seahorse_01_4");
            for (n = 8; n <= 13; ++n) {
                ((HashMap)object).put("location_restaurant_seahorse_01_" + n, "location_restaurant_seahorse_01_" + (n + 8));
            }
            for (n = 22; n <= 23; ++n) {
                ((HashMap)object).put("location_restaurant_seahorse_01_" + n, "location_restaurant_seahorse_01_" + (n - 12));
            }
            for (n = 44; n <= 47; ++n) {
                ((HashMap)object).put("location_restaurant_seahorse_01_" + n, "location_restaurant_seahorse_01_" + (n + 4));
            }
            for (n = 48; n <= 51; ++n) {
                ((HashMap)object).put("location_restaurant_seahorse_01_" + n, "location_restaurant_seahorse_01_" + (n - 4));
            }
            ((HashMap)object).put("location_restaurant_spiffos_01_56", "location_restaurant_spiffos_01_58");
            ((HashMap)object).put("location_restaurant_spiffos_01_58", "location_restaurant_spiffos_01_56");
            ((HashMap)object).put("location_shop_fossoil_01_45", "location_shop_fossoil_01_44");
            ((HashMap)object).put("location_shop_fossoil_01_46", "location_shop_fossoil_01_45");
            ((HashMap)object).put("location_shop_fossoil_01_57", "location_shop_fossoil_01_58");
            ((HashMap)object).put("location_shop_fossoil_01_58", "location_shop_fossoil_01_59");
            ((HashMap)object).put("location_shop_greenes_01_13", "location_shop_greenes_01_18");
            ((HashMap)object).put("location_shop_greenes_01_15", "location_shop_greenes_01_19");
            ((HashMap)object).put("location_shop_greenes_01_21", "location_shop_greenes_01_16");
            ((HashMap)object).put("location_shop_greenes_01_22", "location_shop_greenes_01_13");
            ((HashMap)object).put("location_shop_greenes_01_23", "location_shop_greenes_01_17");
            ((HashMap)object).put("location_shop_greenes_01_67", "location_shop_greenes_01_70");
            ((HashMap)object).put("location_shop_greenes_01_68", "location_shop_greenes_01_67");
            ((HashMap)object).put("location_shop_greenes_01_70", "location_shop_greenes_01_71");
            ((HashMap)object).put("location_shop_greenes_01_75", "location_shop_greenes_01_78");
            ((HashMap)object).put("location_shop_greenes_01_76", "location_shop_greenes_01_75");
            ((HashMap)object).put("location_shop_greenes_01_78", "location_shop_greenes_01_79");
            for (n = 0; n <= 16; ++n) {
                ((HashMap)object).put("vegetation_foliage_01_" + n, "randBush");
            }
            ((HashMap)object).put("vegetation_groundcover_01_0", "blends_grassoverlays_01_16");
            ((HashMap)object).put("vegetation_groundcover_01_1", "blends_grassoverlays_01_8");
            ((HashMap)object).put("vegetation_groundcover_01_2", "blends_grassoverlays_01_0");
            ((HashMap)object).put("vegetation_groundcover_01_3", "blends_grassoverlays_01_64");
            ((HashMap)object).put("vegetation_groundcover_01_4", "blends_grassoverlays_01_56");
            ((HashMap)object).put("vegetation_groundcover_01_5", "blends_grassoverlays_01_48");
            ((HashMap)object).put("vegetation_groundcover_01_6", "");
            ((HashMap)object).put("vegetation_groundcover_01_44", "blends_grassoverlays_01_40");
            ((HashMap)object).put("vegetation_groundcover_01_45", "blends_grassoverlays_01_32");
            ((HashMap)object).put("vegetation_groundcover_01_46", "blends_grassoverlays_01_24");
            ((HashMap)object).put("vegetation_groundcover_01_16", "d_plants_1_53");
            ((HashMap)object).put("vegetation_groundcover_01_17", "d_plants_1_53");
            for (n = 18; n <= 23; ++n) {
                ((HashMap)object).put("vegetation_groundcover_01_" + n, "randPlant");
            }
            for (n = 20; n <= 23; ++n) {
                ((HashMap)object).put("walls_exterior_house_01_" + n, "walls_exterior_house_01_" + (n + 12));
                ((HashMap)object).put("walls_exterior_house_01_" + (n + 8), "walls_exterior_house_01_" + (n + 8 + 12));
            }
            for (n = 24; n <= 41; ++n) {
                ((HashMap)object).put("walls_exterior_roofs_01_" + n, "walls_exterior_roofs_03_" + n);
            }
        }
        if ((object = Fix2xMap.get(string)) == null) {
            return string;
        }
        if ("randBush".equals(object)) {
            n = 64 + Rand.Next(16);
            return "f_bushes_1_" + n;
        }
        if ("randPlant".equals(object)) {
            n = Rand.Next(4) * 16 + Rand.Next(8);
            return "d_plants_1_" + n;
        }
        return object;
    }

    public void addGeneratorPos(int n, int n2, int n3) {
        if (this.generatorsTouchingThisChunk == null) {
            this.generatorsTouchingThisChunk = new ArrayList();
        }
        for (int i = 0; i < this.generatorsTouchingThisChunk.size(); ++i) {
            IsoGameCharacter.Location location = this.generatorsTouchingThisChunk.get(i);
            if (location.x != n || location.y != n2 || location.z != n3) continue;
            return;
        }
        IsoGameCharacter.Location location = new IsoGameCharacter.Location(n, n2, n3);
        this.generatorsTouchingThisChunk.add(location);
    }

    public void removeGeneratorPos(int n, int n2, int n3) {
        if (this.generatorsTouchingThisChunk == null) {
            return;
        }
        for (int i = 0; i < this.generatorsTouchingThisChunk.size(); ++i) {
            IsoGameCharacter.Location location = this.generatorsTouchingThisChunk.get(i);
            if (location.x != n || location.y != n2 || location.z != n3) continue;
            this.generatorsTouchingThisChunk.remove(i);
            --i;
        }
    }

    public boolean isGeneratorPoweringSquare(int n, int n2, int n3) {
        if (this.generatorsTouchingThisChunk == null) {
            return false;
        }
        for (int i = 0; i < this.generatorsTouchingThisChunk.size(); ++i) {
            IsoGameCharacter.Location location = this.generatorsTouchingThisChunk.get(i);
            if (!IsoGenerator.isPoweringSquare(location.x, location.y, location.z, n, n2, n3)) continue;
            return true;
        }
        return false;
    }

    public void checkForMissingGenerators() {
        if (this.generatorsTouchingThisChunk == null) {
            return;
        }
        for (int i = 0; i < this.generatorsTouchingThisChunk.size(); ++i) {
            IsoGenerator isoGenerator;
            IsoGameCharacter.Location location = this.generatorsTouchingThisChunk.get(i);
            IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(location.x, location.y, location.z);
            if (isoGridSquare == null || (isoGenerator = isoGridSquare.getGenerator()) != null && isoGenerator.isActivated()) continue;
            this.generatorsTouchingThisChunk.remove(i);
            --i;
        }
    }

    public boolean isNewChunk() {
        return this.addZombies;
    }

    public void addSpawnedRoom(int n) {
        if (!this.m_spawnedRooms.contains(n)) {
            this.m_spawnedRooms.add(n);
        }
    }

    public boolean isSpawnedRoom(int n) {
        return this.m_spawnedRooms.contains(n);
    }

    public IsoMetaGrid.Zone getScavengeZone() {
        int n;
        if (this.m_scavengeZone != null) {
            return this.m_scavengeZone;
        }
        IsoMetaChunk isoMetaChunk = IsoWorld.instance.getMetaGrid().getChunkData(this.wx, this.wy);
        if (isoMetaChunk != null && isoMetaChunk.numZones() > 0) {
            for (n = 0; n < isoMetaChunk.numZones(); ++n) {
                IsoMetaGrid.Zone zone = isoMetaChunk.getZone(n);
                if ("DeepForest".equals(zone.type) || "Forest".equals(zone.type)) {
                    this.m_scavengeZone = zone;
                    return zone;
                }
                if (!"Nav".equals(zone.type) && !"Town".equals(zone.type)) continue;
                return null;
            }
        }
        if (this.m_treeCount < (n = 5)) {
            return null;
        }
        int n2 = 0;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                IsoChunk isoChunk;
                if (j == 0 && i == 0) continue;
                IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(this.wx + j, this.wy + i) : IsoWorld.instance.CurrentCell.getChunk(this.wx + j, this.wy + i);
                if (isoChunk == null || isoChunk.m_treeCount < n || ++n2 != 8) continue;
                int n3 = 10;
                this.m_scavengeZone = new IsoMetaGrid.Zone("", "Forest", this.wx * n3, this.wy * n3, 0, n3, n3);
                return this.m_scavengeZone;
            }
        }
        return null;
    }

    public void resetForStore() {
        int n;
        this.randomID = 0;
        this.revision = 0L;
        this.nextSplatIndex = 0;
        this.FloorBloodSplats.clear();
        this.FloorBloodSplatsFade.clear();
        this.jobType = JobType.None;
        this.maxLevel = -1;
        this.bFixed2x = false;
        this.vehicles.clear();
        this.roomLights.clear();
        this.blam = false;
        this.lotheader = null;
        this.bLoaded = false;
        this.addZombies = false;
        this.physicsCheck = false;
        this.loadedPhysics = false;
        this.wx = 0;
        this.wy = 0;
        this.erosion = null;
        this.lootRespawnHour = -1;
        if (this.generatorsTouchingThisChunk != null) {
            this.generatorsTouchingThisChunk.clear();
        }
        this.m_treeCount = 0;
        this.m_scavengeZone = null;
        this.m_numberOfWaterTiles = 0;
        this.m_spawnedRooms.resetQuick();
        this.m_adjacentChunkLoadedCounter = 0;
        for (n = 0; n < this.squares.length; ++n) {
            for (int i = 0; i < this.squares[0].length; ++i) {
                this.squares[n][i] = null;
            }
        }
        for (n = 0; n < 4; ++n) {
            this.lightCheck[n] = true;
            this.bLightingNeverDone[n] = true;
        }
        this.refs.clear();
        this.m_vehicleStorySpawnData = null;
        this.m_loadVehiclesObject = null;
        this.m_objectEmitterData.reset();
        MPStatistics.increaseStoredChunk();
    }

    public int getNumberOfWaterTiles() {
        return this.m_numberOfWaterTiles;
    }

    public void setRandomVehicleStoryToSpawnLater(VehicleStorySpawnData vehicleStorySpawnData) {
        this.m_vehicleStorySpawnData = vehicleStorySpawnData;
    }

    public boolean hasObjectAmbientEmitter(IsoObject isoObject) {
        return this.m_objectEmitterData.hasObject(isoObject);
    }

    public void addObjectAmbientEmitter(IsoObject isoObject, ObjectAmbientEmitters.PerObjectLogic perObjectLogic) {
        this.m_objectEmitterData.addObject(isoObject, perObjectLogic);
    }

    public void removeObjectAmbientEmitter(IsoObject isoObject) {
        this.m_objectEmitterData.removeObject(isoObject);
    }

    public static enum JobType {
        None,
        Convert,
        SoftReset;

    }

    private static enum PhysicsShapes {
        Solid,
        WallN,
        WallW,
        WallS,
        WallE,
        Tree,
        Floor;

    }

    private static class ChunkGetter
    implements IsoGridSquare.GetSquare {
        IsoChunk chunk;

        private ChunkGetter() {
        }

        @Override
        public IsoGridSquare getGridSquare(int n, int n2, int n3) {
            if ((n -= this.chunk.wx * 10) >= 0 && n < 10 && (n2 -= this.chunk.wy * 10) >= 0 && n2 < 10 && n3 >= 0 && n3 < 8) {
                return this.chunk.getGridSquare(n, n2, n3);
            }
            return null;
        }
    }

    private static class SanityCheck {
        public IsoChunk saveChunk;
        public String saveThread;
        public IsoChunk loadChunk;
        public String loadThread;
        public final ArrayList<String> loadFile = new ArrayList();
        public String saveFile;

        private SanityCheck() {
        }

        public synchronized void beginSave(IsoChunk isoChunk) {
            if (this.saveChunk != null) {
                this.log("trying to save while already saving, wx,wy=" + isoChunk.wx + "," + isoChunk.wy);
            }
            if (this.loadChunk == isoChunk) {
                this.log("trying to save the same IsoChunk being loaded");
            }
            this.saveChunk = isoChunk;
            this.saveThread = Thread.currentThread().getName();
        }

        public synchronized void endSave(IsoChunk isoChunk) {
            this.saveChunk = null;
            this.saveThread = null;
        }

        public synchronized void beginLoad(IsoChunk isoChunk) {
            if (this.loadChunk != null) {
                this.log("trying to load while already loading, wx,wy=" + isoChunk.wx + "," + isoChunk.wy);
            }
            if (this.saveChunk == isoChunk) {
                this.log("trying to load the same IsoChunk being saved");
            }
            this.loadChunk = isoChunk;
            this.loadThread = Thread.currentThread().getName();
        }

        public synchronized void endLoad(IsoChunk isoChunk) {
            this.loadChunk = null;
            this.loadThread = null;
        }

        public synchronized void checkCRC(long l, long l2) {
            if (l != l2) {
                this.log("CRC mismatch save=" + l + " load=" + l2);
            }
        }

        public synchronized void checkLength(long l, long l2) {
            if (l != l2) {
                this.log("LENGTH mismatch save=" + l + " load=" + l2);
            }
        }

        public synchronized void beginLoadFile(String string) {
            if (string.equals(this.saveFile)) {
                this.log("attempted to load file being saved " + string);
            }
            this.loadFile.add(string);
        }

        public synchronized void endLoadFile(String string) {
            this.loadFile.remove(string);
        }

        public synchronized void beginSaveFile(String string) {
            if (this.loadFile.contains(string)) {
                this.log("attempted to save file being loaded " + string);
            }
            this.saveFile = string;
        }

        public synchronized void endSaveFile() {
            this.saveFile = null;
        }

        public synchronized void log(String string) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SANITY CHECK FAIL! thread=\"" + Thread.currentThread().getName() + "\"\n");
            if (string != null) {
                stringBuilder.append(string + "\n");
            }
            if (this.saveChunk != null && this.saveChunk == this.loadChunk) {
                stringBuilder.append("exact same IsoChunk being saved + loaded\n");
            }
            if (this.saveChunk != null) {
                stringBuilder.append("save wx,wy=" + this.saveChunk.wx + "," + this.saveChunk.wy + " thread=\"" + this.saveThread + "\"\n");
            } else {
                stringBuilder.append("save chunk=null\n");
            }
            if (this.loadChunk != null) {
                stringBuilder.append("load wx,wy=" + this.loadChunk.wx + "," + this.loadChunk.wy + " thread=\"" + this.loadThread + "\"\n");
            } else {
                stringBuilder.append("load chunk=null\n");
            }
            String string2 = stringBuilder.toString();
            throw new RuntimeException(string2);
        }
    }

    private static class ChunkLock {
        public int wx;
        public int wy;
        public int count;
        public ReentrantReadWriteLock rw = new ReentrantReadWriteLock(true);

        public ChunkLock(int n, int n2) {
            this.wx = n;
            this.wy = n2;
        }

        public ChunkLock set(int n, int n2) {
            assert (this.count == 0);
            this.wx = n;
            this.wy = n2;
            return this;
        }

        public ChunkLock ref() {
            ++this.count;
            return this;
        }

        public int deref() {
            assert (this.count > 0);
            return --this.count;
        }

        public void lockForReading() {
            this.rw.readLock().lock();
        }

        public void unlockForReading() {
            this.rw.readLock().unlock();
        }

        public void lockForWriting() {
            this.rw.writeLock().lock();
        }

        public void unlockForWriting() {
            this.rw.writeLock().unlock();
        }
    }
}

