/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import zombie.GameTime;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.iso.IsoGridSquare;
import zombie.iso.PlayerCamera;
import zombie.iso.Vector2;
import zombie.iso.areas.IsoRoom;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.ui.MoodlesUI;
import zombie.ui.UIManager;

public class IsoCamera {
    public static final PlayerCamera[] cameras = new PlayerCamera[4];
    public static IsoGameCharacter CamCharacter;
    public static Vector2 FakePos;
    public static Vector2 FakePosVec;
    public static int TargetTileX;
    public static int TargetTileY;
    public static int PLAYER_OFFSET_X;
    public static int PLAYER_OFFSET_Y;
    public static final FrameState frameState;

    public static void init() {
        PLAYER_OFFSET_Y = -56 / (2 / Core.TileScale);
    }

    public static void update() {
        int n = IsoPlayer.getPlayerIndex();
        cameras[n].update();
    }

    public static void updateAll() {
        for (int i = 0; i < 4; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null) continue;
            CamCharacter = isoPlayer;
            cameras[i].update();
        }
    }

    public static void SetCharacterToFollow(IsoGameCharacter isoGameCharacter) {
        if (!GameClient.bClient && !GameServer.bServer && (CamCharacter = isoGameCharacter) instanceof IsoPlayer && ((IsoPlayer)CamCharacter).isLocalPlayer() && UIManager.getMoodleUI(((IsoPlayer)CamCharacter).getPlayerNum()) != null) {
            int n = ((IsoPlayer)CamCharacter).getPlayerNum();
            UIManager.getUI().remove(UIManager.getMoodleUI(n));
            UIManager.setMoodleUI(n, new MoodlesUI());
            UIManager.getMoodleUI(n).setCharacter(CamCharacter);
            UIManager.getUI().add(UIManager.getMoodleUI(n));
        }
    }

    public static float getRightClickOffX() {
        return (int)IsoCamera.cameras[IsoPlayer.getPlayerIndex()].RightClickX;
    }

    public static float getRightClickOffY() {
        return (int)IsoCamera.cameras[IsoPlayer.getPlayerIndex()].RightClickY;
    }

    public static float getOffX() {
        return cameras[IsoPlayer.getPlayerIndex()].getOffX();
    }

    public static float getTOffX() {
        return cameras[IsoPlayer.getPlayerIndex()].getTOffX();
    }

    public static void setOffX(float f) {
        IsoCamera.cameras[IsoPlayer.getPlayerIndex()].OffX = f;
    }

    public static float getOffY() {
        return cameras[IsoPlayer.getPlayerIndex()].getOffY();
    }

    public static float getTOffY() {
        return cameras[IsoPlayer.getPlayerIndex()].getTOffY();
    }

    public static void setOffY(float f) {
        IsoCamera.cameras[IsoPlayer.getPlayerIndex()].OffY = f;
    }

    public static float getLastOffX() {
        return cameras[IsoPlayer.getPlayerIndex()].getLastOffX();
    }

    public static void setLastOffX(float f) {
        IsoCamera.cameras[IsoPlayer.getPlayerIndex()].lastOffX = f;
    }

    public static float getLastOffY() {
        return cameras[IsoPlayer.getPlayerIndex()].getLastOffY();
    }

    public static void setLastOffY(float f) {
        IsoCamera.cameras[IsoPlayer.getPlayerIndex()].lastOffY = f;
    }

    public static IsoGameCharacter getCamCharacter() {
        return CamCharacter;
    }

    public static void setCamCharacter(IsoGameCharacter isoGameCharacter) {
        CamCharacter = isoGameCharacter;
    }

    public static Vector2 getFakePos() {
        return FakePos;
    }

    public static void setFakePos(Vector2 vector22) {
        FakePos = vector22;
    }

    public static Vector2 getFakePosVec() {
        return FakePosVec;
    }

    public static void setFakePosVec(Vector2 vector22) {
        FakePosVec = vector22;
    }

    public static int getTargetTileX() {
        return TargetTileX;
    }

    public static void setTargetTileX(int n) {
        TargetTileX = n;
    }

    public static int getTargetTileY() {
        return TargetTileY;
    }

    public static void setTargetTileY(int n) {
        TargetTileY = n;
    }

    public static int getScreenLeft(int n) {
        if (n == 1 || n == 3) {
            return Core.getInstance().getScreenWidth() / 2;
        }
        return 0;
    }

    public static int getScreenWidth(int n) {
        if (IsoPlayer.numPlayers > 1) {
            return Core.getInstance().getScreenWidth() / 2;
        }
        return Core.getInstance().getScreenWidth();
    }

    public static int getScreenTop(int n) {
        if (n == 2 || n == 3) {
            return Core.getInstance().getScreenHeight() / 2;
        }
        return 0;
    }

    public static int getScreenHeight(int n) {
        if (IsoPlayer.numPlayers > 2) {
            return Core.getInstance().getScreenHeight() / 2;
        }
        return Core.getInstance().getScreenHeight();
    }

    public static int getOffscreenLeft(int n) {
        if (n == 1 || n == 3) {
            return Core.getInstance().getScreenWidth() / 2;
        }
        return 0;
    }

    public static int getOffscreenWidth(int n) {
        return Core.getInstance().getOffscreenWidth(n);
    }

    public static int getOffscreenTop(int n) {
        if (n >= 2) {
            return Core.getInstance().getScreenHeight() / 2;
        }
        return 0;
    }

    public static int getOffscreenHeight(int n) {
        return Core.getInstance().getOffscreenHeight(n);
    }

    static {
        for (int i = 0; i < cameras.length; ++i) {
            IsoCamera.cameras[i] = new PlayerCamera(i);
        }
        CamCharacter = null;
        FakePos = new Vector2();
        FakePosVec = new Vector2();
        TargetTileX = 0;
        TargetTileY = 0;
        PLAYER_OFFSET_X = 0;
        PLAYER_OFFSET_Y = -56 / (2 / Core.TileScale);
        frameState = new FrameState();
    }

    public static class FrameState {
        public int frameCount;
        public boolean Paused;
        public int playerIndex;
        public float CamCharacterX;
        public float CamCharacterY;
        public float CamCharacterZ;
        public IsoGameCharacter CamCharacter;
        public IsoGridSquare CamCharacterSquare;
        public IsoRoom CamCharacterRoom;
        public float OffX;
        public float OffY;
        public int OffscreenWidth;
        public int OffscreenHeight;

        public void set(int n) {
            this.Paused = GameTime.isGamePaused();
            this.playerIndex = n;
            this.CamCharacter = IsoPlayer.players[n];
            this.CamCharacterX = this.CamCharacter.getX();
            this.CamCharacterY = this.CamCharacter.getY();
            this.CamCharacterZ = this.CamCharacter.getZ();
            this.CamCharacterSquare = this.CamCharacter.getCurrentSquare();
            this.CamCharacterRoom = this.CamCharacterSquare == null ? null : this.CamCharacterSquare.getRoom();
            this.OffX = IsoCamera.getOffX();
            this.OffY = IsoCamera.getOffY();
            this.OffscreenWidth = IsoCamera.getOffscreenWidth(n);
            this.OffscreenHeight = IsoCamera.getOffscreenHeight(n);
        }
    }
}

