/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import org.joml.Vector2i;

public class DiamondMatrixIterator {
    private int size;
    private int lineSize;
    private int line;
    private int column;

    public DiamondMatrixIterator(int n) {
        this.size = n;
        this.lineSize = 1;
        this.line = 0;
        this.column = 0;
    }

    public DiamondMatrixIterator reset(int n) {
        this.size = n;
        this.lineSize = 1;
        this.line = 0;
        this.column = 0;
        return this;
    }

    public void reset() {
        this.lineSize = 1;
        this.line = 0;
        this.column = 0;
    }

    public boolean next(Vector2i vector2i) {
        if (this.lineSize == 0) {
            vector2i.x = 0;
            vector2i.y = 0;
            return false;
        }
        if (this.line == 0 && this.column == 0) {
            vector2i.set(0, 0);
            ++this.column;
            return true;
        }
        if (this.column < this.lineSize) {
            ++vector2i.x;
            --vector2i.y;
            ++this.column;
        } else {
            this.column = 1;
            ++this.line;
            if (this.line < this.size) {
                ++this.lineSize;
                vector2i.x = 0;
                vector2i.y = this.line;
            } else {
                --this.lineSize;
                vector2i.x = this.line - this.size + 1;
                vector2i.y = this.size - 1;
            }
        }
        if (this.lineSize == 0) {
            vector2i.x = 0;
            vector2i.y = 0;
            return false;
        }
        return true;
    }

    public Vector2i i2line(int n) {
        int n2;
        int n3 = 0;
        for (n2 = 1; n2 < this.size + 1; ++n2) {
            if (n + 1 > (n3 += n2)) continue;
            return new Vector2i(n - n3 + n2, n2 - 1);
        }
        for (n2 = this.size + 1; n2 < this.size * 2; ++n2) {
            if (n + 1 > (n3 += this.size * 2 - n2)) continue;
            return new Vector2i(n - n3 + this.size * 2 - n2, n2 - 1);
        }
        return null;
    }

    public Vector2i line2coord(Vector2i vector2i) {
        if (vector2i == null) {
            return null;
        }
        if (vector2i.y < this.size) {
            Vector2i vector2i2 = new Vector2i(0, vector2i.y);
            for (int i = 0; i < vector2i.x; ++i) {
                ++vector2i2.x;
                --vector2i2.y;
            }
            return vector2i2;
        }
        Vector2i vector2i3 = new Vector2i(vector2i.y - this.size + 1, this.size - 1);
        for (int i = 0; i < vector2i.x; ++i) {
            ++vector2i3.x;
            --vector2i3.y;
        }
        return vector2i3;
    }
}

