/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.core.textures.Texture;
import zombie.inventory.ItemContainer;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoStove;
import zombie.network.GameServer;
import zombie.util.LocationRNG;
import zombie.util.StringUtils;

public class ContainerOverlays {
    public static final ContainerOverlays instance = new ContainerOverlays();
    private static final ArrayList<ContainerOverlayEntry> tempEntries = new ArrayList();
    private final THashMap<String, ContainerOverlay> overlayMap = new THashMap();

    private void parseContainerOverlayMapV0(KahluaTableImpl kahluaTableImpl) {
        for (Map.Entry<Object, Object> entry : kahluaTableImpl.delegate.entrySet()) {
            String string = entry.getKey().toString();
            ContainerOverlay containerOverlay = new ContainerOverlay();
            containerOverlay.name = string;
            this.overlayMap.put((Object)containerOverlay.name, (Object)containerOverlay);
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)entry.getValue();
            for (Map.Entry<Object, Object> entry2 : kahluaTableImpl2.delegate.entrySet()) {
                String string2 = entry2.getKey().toString();
                KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)entry2.getValue();
                String string3 = null;
                if (kahluaTableImpl3.delegate.containsKey(1.0)) {
                    string3 = kahluaTableImpl3.rawget(1.0).toString();
                }
                String string4 = null;
                if (kahluaTableImpl3.delegate.containsKey(2.0)) {
                    string4 = kahluaTableImpl3.rawget(2.0).toString();
                }
                ContainerOverlayEntry containerOverlayEntry = new ContainerOverlayEntry();
                containerOverlayEntry.manyItems = string3;
                containerOverlayEntry.fewItems = string4;
                containerOverlayEntry.room = string2;
                containerOverlay.entries.add(containerOverlayEntry);
            }
        }
    }

    private void parseContainerOverlayMapV1(KahluaTableImpl kahluaTableImpl) {
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            String string = kahluaTableIterator.getKey().toString();
            if ("VERSION".equalsIgnoreCase(string)) continue;
            ContainerOverlay containerOverlay = new ContainerOverlay();
            containerOverlay.name = string;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
            KahluaTableIterator kahluaTableIterator2 = kahluaTableImpl2.iterator();
            while (kahluaTableIterator2.advance()) {
                KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)kahluaTableIterator2.getValue();
                String string2 = kahluaTableImpl3.rawgetStr("name");
                KahluaTableImpl kahluaTableImpl4 = (KahluaTableImpl)kahluaTableImpl3.rawget("tiles");
                ContainerOverlayEntry containerOverlayEntry = new ContainerOverlayEntry();
                containerOverlayEntry.manyItems = (String)kahluaTableImpl4.rawget(1);
                containerOverlayEntry.fewItems = (String)kahluaTableImpl4.rawget(2);
                if (StringUtils.isNullOrWhitespace(containerOverlayEntry.manyItems) || "none".equalsIgnoreCase(containerOverlayEntry.manyItems)) {
                    containerOverlayEntry.manyItems = null;
                }
                if (StringUtils.isNullOrWhitespace(containerOverlayEntry.fewItems) || "none".equalsIgnoreCase(containerOverlayEntry.fewItems)) {
                    containerOverlayEntry.fewItems = null;
                }
                containerOverlayEntry.room = string2;
                containerOverlay.entries.add(containerOverlayEntry);
            }
            this.overlayMap.put((Object)containerOverlay.name, (Object)containerOverlay);
        }
    }

    public void addOverlays(KahluaTableImpl kahluaTableImpl) {
        int n = kahluaTableImpl.rawgetInt("VERSION");
        if (n == -1) {
            this.parseContainerOverlayMapV0(kahluaTableImpl);
        } else if (n == 1) {
            this.parseContainerOverlayMapV1(kahluaTableImpl);
        } else {
            throw new RuntimeException("unknown overlayMap.VERSION " + n);
        }
    }

    public boolean hasOverlays(IsoObject isoObject) {
        return isoObject != null && isoObject.sprite != null && isoObject.sprite.name != null && this.overlayMap.containsKey((Object)isoObject.sprite.name);
    }

    public void updateContainerOverlaySprite(IsoObject isoObject) {
        ContainerOverlay containerOverlay;
        if (isoObject == null) {
            return;
        }
        if (isoObject instanceof IsoStove) {
            return;
        }
        IsoGridSquare isoGridSquare = isoObject.getSquare();
        if (isoGridSquare == null) {
            return;
        }
        String string = null;
        ItemContainer itemContainer = isoObject.getContainer();
        if (isoObject.sprite != null && isoObject.sprite.name != null && itemContainer != null && itemContainer.getItems() != null && !itemContainer.isEmpty() && (containerOverlay = (ContainerOverlay)this.overlayMap.get((Object)isoObject.sprite.name)) != null) {
            ContainerOverlayEntry containerOverlayEntry;
            String string2 = "other";
            if (isoGridSquare.getRoom() != null) {
                string2 = isoGridSquare.getRoom().getName();
            }
            if ((containerOverlayEntry = containerOverlay.pickRandom(string2, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z)) == null) {
                containerOverlayEntry = containerOverlay.pickRandom("other", isoGridSquare.x, isoGridSquare.y, isoGridSquare.z);
            }
            if (containerOverlayEntry != null) {
                string = containerOverlayEntry.manyItems;
                if (containerOverlayEntry.fewItems != null && itemContainer.getItems().size() < 7) {
                    string = containerOverlayEntry.fewItems;
                }
            }
        }
        if (!StringUtils.isNullOrWhitespace(string) && !GameServer.bServer && Texture.getSharedTexture(string) == null) {
            string = null;
        }
        isoObject.setOverlaySprite(string);
    }

    public void Reset() {
        this.overlayMap.clear();
    }

    private static final class ContainerOverlay {
        public String name;
        public final ArrayList<ContainerOverlayEntry> entries = new ArrayList();

        private ContainerOverlay() {
        }

        public void getEntries(String string, ArrayList<ContainerOverlayEntry> arrayList) {
            arrayList.clear();
            for (int i = 0; i < this.entries.size(); ++i) {
                ContainerOverlayEntry containerOverlayEntry = this.entries.get(i);
                if (!containerOverlayEntry.room.equalsIgnoreCase(string)) continue;
                arrayList.add(containerOverlayEntry);
            }
        }

        public ContainerOverlayEntry pickRandom(String string, int n, int n2, int n3) {
            this.getEntries(string, tempEntries);
            if (tempEntries.isEmpty()) {
                return null;
            }
            int n4 = LocationRNG.instance.nextInt(tempEntries.size(), n, n2, n3);
            return tempEntries.get(n4);
        }
    }

    private static final class ContainerOverlayEntry {
        public String room;
        public String manyItems;
        public String fewItems;

        private ContainerOverlayEntry() {
        }
    }
}

