/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import gnu.trove.list.array.TShortArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import org.joml.Vector2f;
import se.krka.kahlua.vm.KahluaTable;
import zombie.Lua.LuaManager;
import zombie.core.Rand;
import zombie.core.stash.StashSystem;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.Food;
import zombie.iso.IsoChunk;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoWorld;
import zombie.iso.RoomDef;
import zombie.iso.areas.IsoRoom;
import zombie.network.GameServer;
import zombie.network.ServerMap;

public final class BuildingDef {
    static final ArrayList<IsoGridSquare> squareChoices = new ArrayList();
    public final ArrayList<RoomDef> emptyoutside = new ArrayList();
    public KahluaTable table = null;
    public boolean seen = false;
    public boolean hasBeenVisited = false;
    public String stash = null;
    public int lootRespawnHour = -1;
    public TShortArrayList overlappedChunks;
    public boolean bAlarmed = false;
    public int x = 10000000;
    public int y = 10000000;
    public int x2 = -10000000;
    public int y2 = -10000000;
    public final ArrayList<RoomDef> rooms = new ArrayList();
    public IsoMetaGrid.Zone zone;
    public int food;
    public ArrayList<InventoryItem> items = new ArrayList();
    public HashSet<String> itemTypes = new HashSet();
    int ID = 0;
    private int keySpawned = 0;
    private int keyId = -1;
    public long metaID;

    public BuildingDef() {
        this.table = LuaManager.platform.newTable();
        this.setKeyId(Rand.Next(100000000));
    }

    public KahluaTable getTable() {
        return this.table;
    }

    public ArrayList<RoomDef> getRooms() {
        return this.rooms;
    }

    public RoomDef getRoom(String string) {
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            if (!roomDef.getName().equalsIgnoreCase(string)) continue;
            return roomDef;
        }
        return null;
    }

    public boolean isAllExplored() {
        for (int i = 0; i < this.rooms.size(); ++i) {
            if (this.rooms.get((int)i).bExplored) continue;
            return false;
        }
        return true;
    }

    public void setAllExplored(boolean bl) {
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            roomDef.setExplored(bl);
        }
    }

    public RoomDef getFirstRoom() {
        return this.rooms.get(0);
    }

    public int getChunkX() {
        return this.x / 10;
    }

    public int getChunkY() {
        return this.y / 10;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public int getW() {
        return this.x2 - this.x;
    }

    public int getH() {
        return this.y2 - this.y;
    }

    public int getID() {
        return this.ID;
    }

    public void refreshSquares() {
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            roomDef.refreshSquares();
        }
    }

    public void CalculateBounds(ArrayList<RoomDef> arrayList) {
        RoomDef.RoomRect roomRect;
        int n;
        RoomDef roomDef;
        int n2;
        for (n2 = 0; n2 < this.rooms.size(); ++n2) {
            roomDef = this.rooms.get(n2);
            for (n = 0; n < roomDef.rects.size(); ++n) {
                roomRect = roomDef.rects.get(n);
                if (roomRect.x < this.x) {
                    this.x = roomRect.x;
                }
                if (roomRect.y < this.y) {
                    this.y = roomRect.y;
                }
                if (roomRect.x + roomRect.w > this.x2) {
                    this.x2 = roomRect.x + roomRect.w;
                }
                if (roomRect.y + roomRect.h <= this.y2) continue;
                this.y2 = roomRect.y + roomRect.h;
            }
        }
        for (n2 = 0; n2 < this.emptyoutside.size(); ++n2) {
            roomDef = this.emptyoutside.get(n2);
            for (n = 0; n < roomDef.rects.size(); ++n) {
                roomRect = roomDef.rects.get(n);
                if (roomRect.x < this.x) {
                    this.x = roomRect.x;
                }
                if (roomRect.y < this.y) {
                    this.y = roomRect.y;
                }
                if (roomRect.x + roomRect.w > this.x2) {
                    this.x2 = roomRect.x + roomRect.w;
                }
                if (roomRect.y + roomRect.h <= this.y2) continue;
                this.y2 = roomRect.y + roomRect.h;
            }
        }
        n2 = this.x / 10;
        int n3 = this.y / 10;
        n = (this.x2 + 0) / 10;
        int n4 = (this.y2 + 0) / 10;
        this.overlappedChunks = new TShortArrayList((n - n2 + 1) * (n4 - n3 + 1) * 2);
        this.overlappedChunks.clear();
        arrayList.clear();
        arrayList.addAll(this.rooms);
        arrayList.addAll(this.emptyoutside);
        for (int i = 0; i < arrayList.size(); ++i) {
            RoomDef roomDef2 = arrayList.get(i);
            for (int j = 0; j < roomDef2.rects.size(); ++j) {
                RoomDef.RoomRect roomRect2 = roomDef2.rects.get(j);
                n2 = roomRect2.x / 10;
                n3 = roomRect2.y / 10;
                n = (roomRect2.x + roomRect2.w + 0) / 10;
                n4 = (roomRect2.y + roomRect2.h + 0) / 10;
                for (int k = n3; k <= n4; ++k) {
                    for (int i2 = n2; i2 <= n; ++i2) {
                        if (this.overlapsChunk(i2, k)) continue;
                        this.overlappedChunks.add((short)i2);
                        this.overlappedChunks.add((short)k);
                    }
                }
            }
        }
    }

    public long calculateMetaID(int n, int n2) {
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        ArrayList<RoomDef> arrayList = this.rooms.isEmpty() ? this.emptyoutside : this.rooms;
        for (int i = 0; i < arrayList.size(); ++i) {
            RoomDef roomDef = arrayList.get(i);
            if (roomDef.level > n5) continue;
            if (roomDef.level < n5) {
                n3 = Integer.MAX_VALUE;
                n4 = Integer.MAX_VALUE;
            }
            n5 = roomDef.level;
            for (int j = 0; j < roomDef.rects.size(); ++j) {
                RoomDef.RoomRect roomRect = roomDef.rects.get(j);
                if (roomRect.x > n3 || roomRect.y >= n4) continue;
                n3 = roomRect.x;
                n4 = roomRect.y;
            }
        }
        return (long)n5 << 32 | (long)(n4 -= n2 * 300) << 16 | (long)(n3 -= n * 300);
    }

    public void recalculate() {
        this.food = 0;
        this.items.clear();
        this.itemTypes.clear();
        for (int i = 0; i < this.rooms.size(); ++i) {
            IsoRoom isoRoom = this.rooms.get(i).getIsoRoom();
            for (int j = 0; j < isoRoom.Containers.size(); ++j) {
                ItemContainer itemContainer = isoRoom.Containers.get(j);
                for (int k = 0; k < itemContainer.Items.size(); ++k) {
                    InventoryItem inventoryItem = itemContainer.Items.get(k);
                    this.items.add(inventoryItem);
                    this.itemTypes.add(inventoryItem.getFullType());
                    if (!(inventoryItem instanceof Food)) continue;
                    ++this.food;
                }
            }
        }
    }

    public boolean overlapsChunk(int n, int n2) {
        for (int i = 0; i < this.overlappedChunks.size(); i += 2) {
            if (n != this.overlappedChunks.get(i) || n2 != this.overlappedChunks.get(i + 1)) continue;
            return true;
        }
        return false;
    }

    public IsoGridSquare getFreeSquareInRoom() {
        squareChoices.clear();
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            for (int j = 0; j < roomDef.rects.size(); ++j) {
                RoomDef.RoomRect roomRect = roomDef.rects.get(j);
                for (int k = roomRect.getX(); k < roomRect.getX2(); ++k) {
                    for (int i2 = roomRect.getY(); i2 < roomRect.getY2(); ++i2) {
                        IsoGridSquare isoGridSquare = IsoWorld.instance.CurrentCell.getGridSquare(k, i2, roomDef.getZ());
                        if (isoGridSquare == null || !isoGridSquare.isFree(false)) continue;
                        squareChoices.add(isoGridSquare);
                    }
                }
            }
        }
        if (!squareChoices.isEmpty()) {
            return squareChoices.get(Rand.Next(squareChoices.size()));
        }
        return null;
    }

    public boolean containsRoom(String string) {
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            if (!roomDef.name.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isFullyStreamedIn() {
        for (int i = 0; i < this.overlappedChunks.size(); i += 2) {
            IsoChunk isoChunk;
            short s = this.overlappedChunks.get(i);
            short s2 = this.overlappedChunks.get(i + 1);
            IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(s, s2) : IsoWorld.instance.CurrentCell.getChunk(s, s2);
            if (isoChunk != null) continue;
            return false;
        }
        return true;
    }

    public boolean isAnyChunkNewlyLoaded() {
        for (int i = 0; i < this.overlappedChunks.size(); i += 2) {
            IsoChunk isoChunk;
            short s = this.overlappedChunks.get(i);
            short s2 = this.overlappedChunks.get(i + 1);
            IsoChunk isoChunk2 = isoChunk = GameServer.bServer ? ServerMap.instance.getChunk(s, s2) : IsoWorld.instance.CurrentCell.getChunk(s, s2);
            if (isoChunk == null) {
                return false;
            }
            if (!isoChunk.isNewChunk()) continue;
            return true;
        }
        return false;
    }

    public IsoMetaGrid.Zone getZone() {
        return this.zone;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int n) {
        this.keyId = n;
    }

    public int getKeySpawned() {
        return this.keySpawned;
    }

    public void setKeySpawned(int n) {
        this.keySpawned = n;
    }

    public boolean isHasBeenVisited() {
        return this.hasBeenVisited;
    }

    public void setHasBeenVisited(boolean bl) {
        if (bl && !this.hasBeenVisited) {
            StashSystem.visitedBuilding(this);
        }
        this.hasBeenVisited = bl;
    }

    public boolean isAlarmed() {
        return this.bAlarmed;
    }

    public void setAlarmed(boolean bl) {
        this.bAlarmed = bl;
    }

    public RoomDef getRandomRoom(int n) {
        RoomDef roomDef = this.getRooms().get(Rand.Next(0, this.getRooms().size()));
        if (n > 0 && roomDef.area >= n) {
            return roomDef;
        }
        for (int i = 0; i <= 20; ++i) {
            roomDef = this.getRooms().get(Rand.Next(0, this.getRooms().size()));
            if (roomDef.area < n) continue;
            return roomDef;
        }
        return roomDef;
    }

    public float getClosestPoint(float f, float f2, Vector2f vector2f) {
        float f3 = Float.MAX_VALUE;
        Vector2f vector2f2 = new Vector2f();
        for (int i = 0; i < this.rooms.size(); ++i) {
            RoomDef roomDef = this.rooms.get(i);
            float f4 = roomDef.getClosestPoint(f, f2, vector2f2);
            if (!(f4 < f3)) continue;
            f3 = f4;
            vector2f.set(vector2f2);
        }
        return f3;
    }

    public void Dispose() {
        for (RoomDef roomDef : this.rooms) {
            roomDef.Dispose();
        }
        this.emptyoutside.clear();
        this.rooms.clear();
    }
}

