/*
 * Decompiled with CFR 0.152.
 */
package zombie.iso;

import java.util.ArrayList;
import java.util.HashMap;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.MapCollisionData;
import zombie.iso.IsoCell;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.areas.isoregion.IsoRegions;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.vehicles.PolygonalMap2;

public class BentFences {
    private static final BentFences instance = new BentFences();
    private final ArrayList<Entry> m_entries = new ArrayList();
    private final HashMap<String, ArrayList<Entry>> m_bentMap = new HashMap();
    private final HashMap<String, ArrayList<Entry>> m_unbentMap = new HashMap();

    public static BentFences getInstance() {
        return instance;
    }

    private void tableToTiles(KahluaTableImpl kahluaTableImpl, ArrayList<String> arrayList) {
        if (kahluaTableImpl == null) {
            return;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            arrayList.add(kahluaTableIterator.getValue().toString());
        }
    }

    private void tableToTiles(KahluaTable kahluaTable, ArrayList<String> arrayList, String string) {
        this.tableToTiles((KahluaTableImpl)kahluaTable.rawget(string), arrayList);
    }

    public void addFenceTiles(int n, KahluaTableImpl kahluaTableImpl) {
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl.iterator();
        while (kahluaTableIterator.advance()) {
            ArrayList<Entry> arrayList;
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableIterator.getValue();
            Entry entry = new Entry();
            entry.dir = IsoDirections.valueOf(kahluaTableImpl2.rawgetStr("dir"));
            this.tableToTiles(kahluaTableImpl2, entry.unbent, "unbent");
            this.tableToTiles(kahluaTableImpl2, entry.bent, "bent");
            if (entry.unbent.isEmpty() || entry.unbent.size() != entry.bent.size()) continue;
            this.m_entries.add(entry);
            for (String string : entry.unbent) {
                arrayList = this.m_unbentMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.m_unbentMap.put(string, arrayList);
                }
                arrayList.add(entry);
            }
            for (String string : entry.bent) {
                arrayList = this.m_bentMap.get(string);
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    this.m_bentMap.put(string, arrayList);
                }
                arrayList.add(entry);
            }
        }
    }

    public boolean isBentObject(IsoObject isoObject) {
        return this.getEntryForObject(isoObject, null) != null;
    }

    public boolean isUnbentObject(IsoObject isoObject) {
        return this.getEntryForObject(isoObject, IsoDirections.Max) != null;
    }

    private Entry getEntryForObject(IsoObject isoObject, IsoDirections isoDirections) {
        ArrayList<Entry> arrayList;
        if (isoObject == null || isoObject.sprite == null || isoObject.sprite.name == null) {
            return null;
        }
        boolean bl = isoDirections != null;
        ArrayList<Entry> arrayList2 = arrayList = bl ? this.m_unbentMap.get(isoObject.sprite.name) : this.m_bentMap.get(isoObject.sprite.name);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Entry entry = arrayList.get(i);
                if (bl && isoDirections != IsoDirections.Max && isoDirections != entry.dir || !this.isValidObject(isoObject, entry, bl)) continue;
                return entry;
            }
        }
        return null;
    }

    private boolean isValidObject(IsoObject isoObject, Entry entry, boolean bl) {
        int n;
        ArrayList<String> arrayList;
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        ArrayList<String> arrayList2 = arrayList = bl ? entry.unbent : entry.bent;
        int n2 = arrayList.get(2).equals(isoObject.sprite.name) ? 2 : (n = arrayList.get(3).equals(isoObject.sprite.name) ? 3 : -1);
        if (n == -1) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            int n3;
            int n4 = isoObject.square.x + (entry.isNorth() ? i - n : 0);
            IsoGridSquare isoGridSquare = isoCell.getGridSquare(n4, n3 = isoObject.square.y + (entry.isNorth() ? 0 : i - n), isoObject.square.z);
            if (isoGridSquare == null) {
                return false;
            }
            if (n == i || this.getObjectForEntry(isoGridSquare, arrayList, i) != null) continue;
            return false;
        }
        return true;
    }

    IsoObject getObjectForEntry(IsoGridSquare isoGridSquare, ArrayList<String> arrayList, int n) {
        for (int i = 0; i < isoGridSquare.getObjects().size(); ++i) {
            IsoObject isoObject = isoGridSquare.getObjects().get(i);
            if (isoObject.sprite == null || isoObject.sprite.name == null || !arrayList.get(n).equals(isoObject.sprite.name)) continue;
            return isoObject;
        }
        return null;
    }

    public void swapTiles(IsoObject isoObject, IsoDirections isoDirections) {
        ArrayList<String> arrayList;
        boolean bl = isoDirections != null;
        Entry entry = this.getEntryForObject(isoObject, isoDirections);
        if (entry == null) {
            return;
        }
        if (bl) {
            if (entry.isNorth() && isoDirections != IsoDirections.N && isoDirections != IsoDirections.S) {
                return;
            }
            if (!entry.isNorth() && isoDirections != IsoDirections.W && isoDirections != IsoDirections.E) {
                return;
            }
        }
        IsoCell isoCell = IsoWorld.instance.CurrentCell;
        ArrayList<String> arrayList2 = arrayList = bl ? entry.unbent : entry.bent;
        int n = arrayList.get(2).equals(isoObject.sprite.name) ? 2 : (arrayList.get(3).equals(isoObject.sprite.name) ? 3 : -1);
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoObject isoObject2;
            int n2;
            int n3 = isoObject.square.x + (entry.isNorth() ? i - n : 0);
            IsoGridSquare isoGridSquare = isoCell.getGridSquare(n3, n2 = isoObject.square.y + (entry.isNorth() ? 0 : i - n), isoObject.square.z);
            if (isoGridSquare == null || (isoObject2 = this.getObjectForEntry(isoGridSquare, arrayList, i)) == null) continue;
            String string = bl ? entry.bent.get(i) : entry.unbent.get(i);
            IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(string);
            isoSprite.name = string;
            isoObject2.setSprite(isoSprite);
            isoObject2.transmitUpdatedSprite();
            isoGridSquare.RecalcAllWithNeighbours(true);
            MapCollisionData.instance.squareChanged(isoGridSquare);
            PolygonalMap2.instance.squareChanged(isoGridSquare);
            IsoRegions.squareChanged(isoGridSquare);
        }
    }

    public void bendFence(IsoObject isoObject, IsoDirections isoDirections) {
        this.swapTiles(isoObject, isoDirections);
    }

    public void unbendFence(IsoObject isoObject) {
        this.swapTiles(isoObject, null);
    }

    public void Reset() {
        this.m_entries.clear();
        this.m_bentMap.clear();
        this.m_unbentMap.clear();
    }

    private static final class Entry {
        IsoDirections dir = IsoDirections.Max;
        final ArrayList<String> unbent = new ArrayList();
        final ArrayList<String> bent = new ArrayList();

        private Entry() {
        }

        boolean isNorth() {
            return this.dir == IsoDirections.N || this.dir == IsoDirections.S;
        }
    }
}

