/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import zombie.GameWindow;
import zombie.core.Color;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.properties.PropertyContainer;
import zombie.core.textures.Texture;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemType;
import zombie.inventory.types.Radio;
import zombie.iso.sprite.IsoSprite;
import zombie.iso.sprite.IsoSpriteGrid;
import zombie.iso.sprite.IsoSpriteManager;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public class Moveable
extends InventoryItem {
    protected String worldSprite = "";
    private boolean isLight = false;
    private boolean lightUseBattery = false;
    private boolean lightHasBattery = false;
    private String lightBulbItem = "Base.LightBulb";
    private float lightPower = 0.0f;
    private float lightDelta = 2.5E-4f;
    private float lightR = 1.0f;
    private float lightG = 1.0f;
    private float lightB = 1.0f;
    private boolean isMultiGridAnchor = false;
    private IsoSpriteGrid spriteGrid;
    private String customNameFull = "Moveable Object";
    private String movableFullName = "Moveable Object";
    protected boolean canBeDroppedOnFloor = false;
    private boolean hasReadWorldSprite = false;
    protected String customItem = null;

    public Moveable(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.cat = ItemType.Moveable;
    }

    public Moveable(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
        this.cat = ItemType.Moveable;
    }

    @Override
    public String getName() {
        if ("Moveable Object".equals(this.movableFullName)) {
            return this.name;
        }
        if (this.movableFullName.equals(this.name)) {
            return Translator.getMoveableDisplayName(this.customNameFull);
        }
        return Translator.getMoveableDisplayName(this.movableFullName) + this.customNameFull.substring(this.movableFullName.length());
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    public boolean CanBeDroppedOnFloor() {
        if (this.worldSprite != null && this.spriteGrid != null) {
            IsoSprite isoSprite = IsoSpriteManager.instance.getSprite(this.worldSprite);
            PropertyContainer propertyContainer = isoSprite.getProperties();
            return this.canBeDroppedOnFloor || !propertyContainer.Is("ForceSingleItem");
        }
        return this.canBeDroppedOnFloor;
    }

    public String getMovableFullName() {
        return this.movableFullName;
    }

    public String getCustomNameFull() {
        return this.customNameFull;
    }

    public boolean isMultiGridAnchor() {
        return this.isMultiGridAnchor;
    }

    public IsoSpriteGrid getSpriteGrid() {
        return this.spriteGrid;
    }

    public String getWorldSprite() {
        return this.worldSprite;
    }

    public boolean ReadFromWorldSprite(String string) {
        if (string == null) {
            return false;
        }
        if (this.hasReadWorldSprite && this.worldSprite != null && this.worldSprite.equalsIgnoreCase(string)) {
            return true;
        }
        this.customItem = null;
        try {
            PropertyContainer propertyContainer;
            IsoSprite isoSprite = IsoSpriteManager.instance.NamedMap.get(string);
            if (isoSprite != null && (propertyContainer = isoSprite.getProperties()).Is("IsMoveAble")) {
                if (propertyContainer.Is("CustomItem")) {
                    this.customItem = propertyContainer.Val("CustomItem");
                    Item item = ScriptManager.instance.FindItem(this.customItem);
                    if (item != null) {
                        this.Weight = this.ActualWeight = item.ActualWeight;
                    }
                    this.worldSprite = string;
                    if (isoSprite.getSpriteGrid() != null) {
                        this.spriteGrid = isoSprite.getSpriteGrid();
                        int n = isoSprite.getSpriteGrid().getSpriteIndex(isoSprite);
                        this.isMultiGridAnchor = n == 0;
                    }
                    return true;
                }
                this.isLight = propertyContainer.Is("lightR");
                this.worldSprite = string;
                float f = 1.0f;
                if (propertyContainer.Is("PickUpWeight")) {
                    f = Float.parseFloat(propertyContainer.Val("PickUpWeight")) / 10.0f;
                }
                this.Weight = f;
                this.ActualWeight = f;
                this.setCustomWeight(true);
                Object object = "Moveable Object";
                if (propertyContainer.Is("CustomName")) {
                    object = propertyContainer.Is("GroupName") ? propertyContainer.Val("GroupName") + " " + propertyContainer.Val("CustomName") : propertyContainer.Val("CustomName");
                }
                this.movableFullName = object;
                this.name = object;
                this.customNameFull = object;
                if (isoSprite.getSpriteGrid() != null) {
                    this.spriteGrid = isoSprite.getSpriteGrid();
                    int n = isoSprite.getSpriteGrid().getSpriteIndex(isoSprite);
                    int n2 = isoSprite.getSpriteGrid().getSpriteCount();
                    this.isMultiGridAnchor = n == 0;
                    this.name = !propertyContainer.Is("ForceSingleItem") ? this.name + " (" + (n + 1) + "/" + n2 + ")" : this.name + " (1/1)";
                    this.customNameFull = this.name;
                    Texture texture = null;
                    String string2 = "Item_Flatpack";
                    if (string2 != null) {
                        texture = Texture.getSharedTexture(string2);
                        this.setColor(new Color(Rand.Next(0.7f, 1.0f), Rand.Next(0.7f, 1.0f), Rand.Next(0.7f, 1.0f)));
                    }
                    if (texture == null) {
                        texture = Texture.getSharedTexture("media/inventory/Question_On.png");
                    }
                    this.setTexture(texture);
                    this.getModData().rawset("Flatpack", (Object)"true");
                } else if (this.texture == null || this.texture.getName() == null || this.texture.getName().equals("Item_Moveable_object") || this.texture.getName().equals("Question_On")) {
                    Texture texture = null;
                    String string3 = null;
                    string3 = string;
                    if (string3 != null && (texture = Texture.getSharedTexture(string3)) != null) {
                        texture = texture.splitIcon();
                    }
                    if (texture == null) {
                        if (!propertyContainer.Is("MoveType")) {
                            string3 = "Item_Moveable_object";
                        } else if (propertyContainer.Val("MoveType").equals("WallObject")) {
                            string3 = "Item_Moveable_wallobject";
                        } else if (propertyContainer.Val("MoveType").equals("WindowObject")) {
                            string3 = "Item_Moveable_windowobject";
                        } else if (propertyContainer.Val("MoveType").equals("Window")) {
                            string3 = "Item_Moveable_window";
                        } else if (propertyContainer.Val("MoveType").equals("FloorTile")) {
                            string3 = "Item_Moveable_floortile";
                        } else if (propertyContainer.Val("MoveType").equals("FloorRug")) {
                            string3 = "Item_Moveable_floorrug";
                        } else if (propertyContainer.Val("MoveType").equals("Vegitation")) {
                            string3 = "Item_Moveable_vegitation";
                        }
                        if (string3 != null) {
                            texture = Texture.getSharedTexture(string3);
                        }
                    }
                    if (texture == null) {
                        texture = Texture.getSharedTexture("media/inventory/Question_On.png");
                    }
                    this.setTexture(texture);
                }
                this.hasReadWorldSprite = true;
                return true;
            }
        }
        catch (Exception exception) {
            System.out.println("Error in Moveable item: " + exception.getMessage());
        }
        System.out.println("Warning: Moveable not valid");
        return false;
    }

    public boolean isLight() {
        return this.isLight;
    }

    public void setLight(boolean bl) {
        this.isLight = bl;
    }

    public boolean isLightUseBattery() {
        return this.lightUseBattery;
    }

    public void setLightUseBattery(boolean bl) {
        this.lightUseBattery = bl;
    }

    public boolean isLightHasBattery() {
        return this.lightHasBattery;
    }

    public void setLightHasBattery(boolean bl) {
        this.lightHasBattery = bl;
    }

    public String getLightBulbItem() {
        return this.lightBulbItem;
    }

    public void setLightBulbItem(String string) {
        this.lightBulbItem = string;
    }

    public float getLightPower() {
        return this.lightPower;
    }

    public void setLightPower(float f) {
        this.lightPower = f;
    }

    public float getLightDelta() {
        return this.lightDelta;
    }

    public void setLightDelta(float f) {
        this.lightDelta = f;
    }

    public float getLightR() {
        return this.lightR;
    }

    public void setLightR(float f) {
        this.lightR = f;
    }

    public float getLightG() {
        return this.lightG;
    }

    public void setLightG(float f) {
        this.lightG = f;
    }

    public float getLightB() {
        return this.lightB;
    }

    public void setLightB(float f) {
        this.lightB = f;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Moveable.ordinal();
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        GameWindow.WriteString(byteBuffer, this.worldSprite);
        byteBuffer.put(this.isLight ? (byte)1 : 0);
        if (this.isLight) {
            byteBuffer.put(this.lightUseBattery ? (byte)1 : 0);
            byteBuffer.put(this.lightHasBattery ? (byte)1 : 0);
            byteBuffer.put(this.lightBulbItem != null ? (byte)1 : 0);
            if (this.lightBulbItem != null) {
                GameWindow.WriteString(byteBuffer, this.lightBulbItem);
            }
            byteBuffer.putFloat(this.lightPower);
            byteBuffer.putFloat(this.lightDelta);
            byteBuffer.putFloat(this.lightR);
            byteBuffer.putFloat(this.lightG);
            byteBuffer.putFloat(this.lightB);
        }
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.worldSprite = GameWindow.ReadString(byteBuffer);
        if (!this.ReadFromWorldSprite(this.worldSprite) && this instanceof Radio && this.getScriptItem() != null && !StringUtils.isNullOrWhitespace(this.getScriptItem().worldObjectSprite)) {
            DebugLog.log("Moveable.load -> Radio item = " + (this.fullType != null ? this.fullType : "unknown"));
        }
        if (this.customItem == null && !StringUtils.isNullOrWhitespace(this.worldSprite) && !this.type.equalsIgnoreCase(this.worldSprite)) {
            this.type = this.worldSprite;
            this.fullType = this.module + "." + this.worldSprite;
        }
        boolean bl = this.isLight = byteBuffer.get() == 1;
        if (this.isLight) {
            this.lightUseBattery = byteBuffer.get() == 1;
            boolean bl2 = this.lightHasBattery = byteBuffer.get() == 1;
            if (byteBuffer.get() == 1) {
                this.lightBulbItem = GameWindow.ReadString(byteBuffer);
            }
            this.lightPower = byteBuffer.getFloat();
            this.lightDelta = byteBuffer.getFloat();
            this.lightR = byteBuffer.getFloat();
            this.lightG = byteBuffer.getFloat();
            this.lightB = byteBuffer.getFloat();
        }
    }

    public void setWorldSprite(String string) {
        this.worldSprite = string;
    }
}

