/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import zombie.GameWindow;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.inventory.InventoryItem;
import zombie.iso.SliceY;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.worldMap.symbols.WorldMapSymbols;

public class MapItem
extends InventoryItem {
    public static MapItem WORLD_MAP_INSTANCE;
    private static final byte[] FILE_MAGIC;
    private String m_mapID;
    private final WorldMapSymbols m_symbols = new WorldMapSymbols();

    public static MapItem getSingleton() {
        if (WORLD_MAP_INSTANCE == null) {
            Item item = ScriptManager.instance.FindItem("Base.Map");
            if (item == null) {
                return null;
            }
            WORLD_MAP_INSTANCE = new MapItem("Base", "World Map", "WorldMap", item);
        }
        return WORLD_MAP_INSTANCE;
    }

    public static void SaveWorldMap() {
        if (WORLD_MAP_INSTANCE == null) {
            return;
        }
        try {
            ByteBuffer byteBuffer = SliceY.SliceBuffer;
            byteBuffer.clear();
            byteBuffer.put(FILE_MAGIC);
            byteBuffer.putInt(195);
            WORLD_MAP_INSTANCE.getSymbols().save(byteBuffer);
            File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_symbols.bin"));
            try (FileOutputStream fileOutputStream = new FileOutputStream(file);
                 BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                bufferedOutputStream.write(byteBuffer.array(), 0, byteBuffer.position());
            }
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public static void LoadWorldMap() {
        if (MapItem.getSingleton() == null) {
            return;
        }
        File file = new File(ZomboidFileSystem.instance.getFileNameInCurrentSave("map_symbols.bin"));
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);){
            ByteBuffer byteBuffer = SliceY.SliceBuffer;
            byteBuffer.clear();
            int n = bufferedInputStream.read(byteBuffer.array());
            byteBuffer.limit(n);
            byte[] byArray = new byte[4];
            byteBuffer.get(byArray);
            if (!Arrays.equals(byArray, FILE_MAGIC)) {
                throw new IOException(file.getAbsolutePath() + " does not appear to be map_symbols.bin");
            }
            int n2 = byteBuffer.getInt();
            MapItem.getSingleton().getSymbols().load(byteBuffer, n2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception exception) {
            ExceptionLogger.logException(exception);
        }
    }

    public static void Reset() {
        if (WORLD_MAP_INSTANCE == null) {
            return;
        }
        WORLD_MAP_INSTANCE.getSymbols().clear();
        WORLD_MAP_INSTANCE = null;
    }

    public MapItem(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public MapItem(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
    }

    @Override
    public int getSaveType() {
        return Item.Type.Map.ordinal();
    }

    @Override
    public boolean IsMap() {
        return true;
    }

    public void setMapID(String string) {
        this.m_mapID = string;
    }

    public String getMapID() {
        return this.m_mapID;
    }

    public WorldMapSymbols getSymbols() {
        return this.m_symbols;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        GameWindow.WriteString(byteBuffer, this.m_mapID);
        this.m_symbols.save(byteBuffer);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.m_mapID = GameWindow.ReadString(byteBuffer);
        this.m_symbols.load(byteBuffer, n);
    }

    static {
        FILE_MAGIC = new byte[]{87, 77, 83, 89};
    }
}

