/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.IsoGameCharacter;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;

public final class InventoryContainer
extends InventoryItem {
    ItemContainer container = new ItemContainer();
    int capacity = 0;
    int weightReduction = 0;
    private String CanBeEquipped = "";

    public InventoryContainer(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.container.containingItem = this;
        this.container.type = string3;
        this.container.inventoryContainer = this;
    }

    @Override
    public boolean IsInventoryContainer() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Container.ordinal();
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Container";
    }

    public ItemContainer getInventory() {
        return this.container;
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putInt(this.container.ID);
        byteBuffer.putInt(this.weightReduction);
        this.container.save(byteBuffer);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        int n2 = byteBuffer.getInt();
        this.setWeightReduction(byteBuffer.getInt());
        if (this.container == null) {
            this.container = new ItemContainer();
        }
        this.container.clear();
        this.container.containingItem = this;
        this.container.setWeightReduction(this.weightReduction);
        this.container.Capacity = this.capacity;
        this.container.ID = n2;
        this.container.load(byteBuffer, n);
        this.synchWithVisual();
    }

    public int getCapacity() {
        return this.container.getCapacity();
    }

    public void setCapacity(int n) {
        this.capacity = n;
        if (this.container == null) {
            this.container = new ItemContainer();
        }
        this.container.Capacity = n;
    }

    public float getInventoryWeight() {
        if (this.getInventory() == null) {
            return 0.0f;
        }
        float f = 0.0f;
        ArrayList<InventoryItem> arrayList = this.getInventory().getItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            InventoryItem inventoryItem = arrayList.get(i);
            if (this.isEquipped()) {
                f += inventoryItem.getEquippedWeight();
                continue;
            }
            f += inventoryItem.getUnequippedWeight();
        }
        return f;
    }

    public int getEffectiveCapacity(IsoGameCharacter isoGameCharacter) {
        return this.container.getEffectiveCapacity(isoGameCharacter);
    }

    public int getWeightReduction() {
        return this.weightReduction;
    }

    public void setWeightReduction(int n) {
        n = Math.min(n, 100);
        this.weightReduction = n = Math.max(n, 0);
        this.container.setWeightReduction(n);
    }

    @Override
    public void updateAge() {
        ArrayList<InventoryItem> arrayList = this.getInventory().getItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            arrayList.get(i).updateAge();
        }
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip) {
        objectTooltip.render();
        super.DoTooltip(objectTooltip);
        int n = objectTooltip.getHeight().intValue();
        n -= objectTooltip.padBottom;
        if (objectTooltip.getWidth() < 160.0) {
            objectTooltip.setWidth(160.0);
        }
        if (!this.getItemContainer().getItems().isEmpty()) {
            int n2 = 5;
            n += 4;
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = this.getItemContainer().getItems().size() - 1; i >= 0; --i) {
                InventoryItem inventoryItem = this.getItemContainer().getItems().get(i);
                if (inventoryItem.getName() != null) {
                    if (hashSet.contains(inventoryItem.getName())) continue;
                    hashSet.add(inventoryItem.getName());
                }
                objectTooltip.DrawTextureScaledAspect(inventoryItem.getTex(), n2, n, 16.0, 16.0, 1.0, 1.0, 1.0, 1.0);
                if ((float)((n2 += 17) + 16) > objectTooltip.width - (float)objectTooltip.padRight) break;
            }
            n += 16;
        }
        objectTooltip.setHeight(n += objectTooltip.padBottom);
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        float f;
        ObjectTooltip.LayoutItem layoutItem;
        float f2 = 0.0f;
        float f3 = 0.6f;
        float f4 = 0.0f;
        float f5 = 0.7f;
        if (this.getEffectiveCapacity(objectTooltip.getCharacter()) != 0) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_container_Capacity") + ":", 1.0f, 1.0f, 1.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getEffectiveCapacity(objectTooltip.getCharacter()));
        }
        if (this.getWeightReduction() != 0) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_container_Weight_Reduction") + ":", 1.0f, 1.0f, 1.0f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getWeightReduction());
        }
        if (this.getBloodClothingType() != null && (f = this.getBloodLevel()) != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_clothing_bloody") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setProgress(f, f2, f3, f4, f5);
        }
    }

    public void setBloodLevel(float f) {
        ArrayList<BloodBodyPartType> arrayList = BloodClothingType.getCoveredParts(this.getBloodClothingType());
        for (int i = 0; i < arrayList.size(); ++i) {
            this.setBlood(arrayList.get(i), PZMath.clamp(f, 0.0f, 100.0f));
        }
    }

    public float getBloodLevel() {
        ArrayList<BloodBodyPartType> arrayList = BloodClothingType.getCoveredParts(this.getBloodClothingType());
        float f = 0.0f;
        for (int i = 0; i < arrayList.size(); ++i) {
            f += this.getBlood(arrayList.get(i));
        }
        return f;
    }

    public void setCanBeEquipped(String string) {
        this.CanBeEquipped = string == null ? "" : string;
    }

    public String canBeEquipped() {
        return this.CanBeEquipped;
    }

    public ItemContainer getItemContainer() {
        return this.container;
    }

    public void setItemContainer(ItemContainer itemContainer) {
        this.container = itemContainer;
    }

    @Override
    public float getContentsWeight() {
        return this.getInventory().getContentsWeight();
    }

    @Override
    public float getEquippedWeight() {
        float f = 1.0f;
        if (this.getWeightReduction() > 0) {
            f = 1.0f - (float)this.getWeightReduction() / 100.0f;
        }
        return this.getActualWeight() * 0.3f + this.getContentsWeight() * f;
    }

    public String getClothingExtraSubmenu() {
        return this.ScriptItem.clothingExtraSubmenu;
    }
}

