/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import zombie.GameWindow;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.characters.skills.PerkFactory;
import zombie.core.BoxedStaticValues;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.math.PZMath;
import zombie.core.textures.ColorInfo;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemType;
import zombie.inventory.types.WeaponPart;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.ModelWeaponPart;
import zombie.ui.ObjectTooltip;
import zombie.util.StringUtils;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;

public final class HandWeapon
extends InventoryItem {
    public float WeaponLength;
    public float SplatSize = 1.0f;
    private int ammoPerShoot = 1;
    private String magazineType = null;
    protected boolean angleFalloff = false;
    protected boolean bCanBarracade = false;
    protected float doSwingBeforeImpact = 0.0f;
    protected String impactSound = "BaseballBatHit";
    protected boolean knockBackOnNoDeath = true;
    protected float maxAngle = 1.0f;
    protected float maxDamage = 1.5f;
    protected int maxHitCount = 1000;
    protected float maxRange = 1.0f;
    protected boolean ranged = false;
    protected float minAngle = 0.5f;
    protected float minDamage = 0.4f;
    protected float minimumSwingTime = 0.5f;
    protected float minRange = 0.0f;
    protected float noiseFactor = 0.0f;
    protected String otherHandRequire = null;
    protected boolean otherHandUse = false;
    protected String physicsObject = null;
    protected float pushBackMod = 1.0f;
    protected boolean rangeFalloff = false;
    protected boolean shareDamage = true;
    protected int soundRadius = 0;
    protected int soundVolume = 0;
    protected boolean splatBloodOnNoDeath = false;
    protected int splatNumber = 2;
    protected String swingSound = "BaseballBatSwing";
    protected float swingTime = 1.0f;
    protected float toHitModifier = 1.0f;
    protected boolean useEndurance = true;
    protected boolean useSelf = false;
    protected String weaponSprite = null;
    private String originalWeaponSprite = null;
    protected float otherBoost = 1.0f;
    protected int DoorDamage = 1;
    protected String doorHitSound = "BaseballBatHit";
    protected int ConditionLowerChance = 10000;
    protected boolean MultipleHitConditionAffected = true;
    protected boolean shareEndurance = true;
    protected boolean AlwaysKnockdown = false;
    protected float EnduranceMod = 1.0f;
    protected float KnockdownMod = 1.0f;
    protected boolean CantAttackWithLowestEndurance = false;
    public boolean bIsAimedFirearm = false;
    public boolean bIsAimedHandWeapon = false;
    public String RunAnim = "Run";
    public String IdleAnim = "Idle";
    public float HitAngleMod = 0.0f;
    private String SubCategory = "";
    private ArrayList<String> Categories = null;
    private int AimingPerkCritModifier = 0;
    private float AimingPerkRangeModifier = 0.0f;
    private float AimingPerkHitChanceModifier = 0.0f;
    private int HitChance = 0;
    private float AimingPerkMinAngleModifier = 0.0f;
    private int RecoilDelay = 0;
    private boolean PiercingBullets = false;
    private float soundGain = 1.0f;
    private WeaponPart scope = null;
    private WeaponPart canon = null;
    private WeaponPart clip = null;
    private WeaponPart recoilpad = null;
    private WeaponPart sling = null;
    private WeaponPart stock = null;
    private int ClipSize = 0;
    private int reloadTime = 0;
    private int aimingTime = 0;
    private float minRangeRanged = 0.0f;
    private int treeDamage = 0;
    private String bulletOutSound = null;
    private String shellFallSound = null;
    private int triggerExplosionTimer = 0;
    private boolean canBePlaced = false;
    private int explosionRange = 0;
    private int explosionPower = 0;
    private int fireRange = 0;
    private int firePower = 0;
    private int smokeRange = 0;
    private int noiseRange = 0;
    private float extraDamage = 0.0f;
    private int explosionTimer = 0;
    private String placedSprite = null;
    private boolean canBeReused = false;
    private int sensorRange = 0;
    private float critDmgMultiplier = 2.0f;
    private float baseSpeed = 1.0f;
    private float bloodLevel = 0.0f;
    private String ammoBox = null;
    private String insertAmmoStartSound = null;
    private String insertAmmoSound = null;
    private String insertAmmoStopSound = null;
    private String ejectAmmoStartSound = null;
    private String ejectAmmoSound = null;
    private String ejectAmmoStopSound = null;
    private String rackSound = null;
    private String clickSound = "Stormy9mmClick";
    private boolean containsClip = false;
    private String weaponReloadType = "handgun";
    private boolean rackAfterShoot = false;
    private boolean roundChambered = false;
    private boolean bSpentRoundChambered = false;
    private int spentRoundCount = 0;
    private float jamGunChance = 5.0f;
    private boolean isJammed = false;
    private ArrayList<ModelWeaponPart> modelWeaponPart = null;
    private boolean haveChamber = true;
    private String bulletName = null;
    private String damageCategory = null;
    private boolean damageMakeHole = false;
    private String hitFloorSound = "BatOnFloor";
    private boolean insertAllBulletsReload = false;
    private String fireMode = null;
    private ArrayList<String> fireModePossibilities = null;
    public int ProjectileCount = 1;
    public float aimingMod = 1.0f;
    public float CriticalChance = 20.0f;
    private String hitSound = "BaseballBatHit";

    public float getSplatSize() {
        return this.SplatSize;
    }

    @Override
    public boolean CanStack(InventoryItem inventoryItem) {
        return false;
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Weapon";
    }

    public HandWeapon(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
        this.cat = ItemType.Weapon;
    }

    public HandWeapon(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
        this.cat = ItemType.Weapon;
    }

    @Override
    public boolean IsWeapon() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Weapon.ordinal();
    }

    @Override
    public float getScore(SurvivorDesc survivorDesc) {
        float f = 0.0f;
        if (this.getAmmoType() != null && !this.getAmmoType().equals("none") && !this.container.contains(this.getAmmoType())) {
            f -= 100000.0f;
        }
        if (this.Condition == 0) {
            f -= 100000.0f;
        }
        f += this.maxDamage * 10.0f;
        f += this.maxAngle * 5.0f;
        f -= this.minimumSwingTime * 0.1f;
        f -= this.swingTime;
        if (survivorDesc != null && survivorDesc.getInstance().getThreatLevel() <= 2 && this.soundRadius > 5) {
            if (f > 0.0f && (float)this.soundRadius > f) {
                f = 1.0f;
            }
            f -= (float)this.soundRadius;
        }
        return f;
    }

    @Override
    public float getActualWeight() {
        float f = this.getScriptItem().getActualWeight();
        f += this.getWeaponPartWeightModifier(this.canon);
        f += this.getWeaponPartWeightModifier(this.clip);
        f += this.getWeaponPartWeightModifier(this.recoilpad);
        f += this.getWeaponPartWeightModifier(this.scope);
        f += this.getWeaponPartWeightModifier(this.sling);
        return f += this.getWeaponPartWeightModifier(this.stock);
    }

    @Override
    public float getWeight() {
        return this.getActualWeight();
    }

    @Override
    public float getContentsWeight() {
        Item item;
        float f = 0.0f;
        if (this.haveChamber() && this.isRoundChambered() && !StringUtils.isNullOrWhitespace(this.getAmmoType()) && (item = ScriptManager.instance.FindItem(this.getAmmoType())) != null) {
            f += item.getActualWeight();
        }
        if (this.isContainsClip() && !StringUtils.isNullOrWhitespace(this.getMagazineType()) && (item = ScriptManager.instance.FindItem(this.getMagazineType())) != null) {
            f += item.getActualWeight();
        }
        return f + super.getContentsWeight();
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        float f;
        float f2;
        float f3 = 1.0f;
        float f4 = 1.0f;
        float f5 = 0.8f;
        float f6 = 1.0f;
        ColorInfo colorInfo = new ColorInfo();
        ObjectTooltip.LayoutItem layoutItem = layout.addItem();
        layoutItem.setLabel(Translator.getText("Tooltip_weapon_Condition") + ":", f3, f4, f5, f6);
        float f7 = (float)this.Condition / (float)this.ConditionMax;
        Core.getInstance().getBadHighlitedColor().interp(Core.getInstance().getGoodHighlitedColor(), f7, colorInfo);
        layoutItem.setProgress(f7, colorInfo.getR(), colorInfo.getG(), colorInfo.getB(), 1.0f);
        if (this.getMaxDamage() > 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Damage") + ":", f3, f4, f5, f6);
            f7 = this.getMaxDamage() + this.getMinDamage();
            f2 = 5.0f;
            f = f7 / f2;
            Core.getInstance().getBadHighlitedColor().interp(Core.getInstance().getGoodHighlitedColor(), f, colorInfo);
            layoutItem.setProgress(f, colorInfo.getR(), colorInfo.getG(), colorInfo.getB(), 1.0f);
        }
        if (this.isRanged()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Range") + ":", f3, f4, f5, 1.0f);
            f7 = this.getMaxRange(IsoPlayer.getInstance());
            f2 = 40.0f;
            f = f7 / f2;
            Core.getInstance().getBadHighlitedColor().interp(Core.getInstance().getGoodHighlitedColor(), f, colorInfo);
            layoutItem.setProgress(f, colorInfo.getR(), colorInfo.getG(), colorInfo.getB(), 1.0f);
        }
        if (this.isTwoHandWeapon() && !this.isRequiresEquippedBothHands()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_item_TwoHandWeapon"), f3, f4, f5, f6);
        }
        if (!StringUtils.isNullOrEmpty(this.getFireMode())) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_item_FireMode") + ":", f3, f4, f5, f6);
            layoutItem.setValue(Translator.getText("ContextMenu_FireMode_" + this.getFireMode()), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.CantAttackWithLowestEndurance) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Unusable_at_max_exertion"), Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
        }
        String string = this.getAmmoType();
        if (Core.getInstance().isNewReloading()) {
            if (this.getMaxAmmo() > 0) {
                Object object = String.valueOf(this.getCurrentAmmoCount());
                if (this.isRoundChambered()) {
                    object = (String)object + "+1";
                }
                layoutItem = layout.addItem();
                if (this.bulletName == null) {
                    this.bulletName = this.getMagazineType() != null ? InventoryItemFactory.CreateItem(this.getMagazineType()).getDisplayName() : InventoryItemFactory.CreateItem(this.getAmmoType()).getDisplayName();
                }
                layoutItem.setLabel(this.bulletName + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValue((String)object + " / " + this.getMaxAmmo(), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (this.isJammed()) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_weapon_Jammed"), Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
            } else if (this.haveChamber() && !this.isRoundChambered() && this.getCurrentAmmoCount() > 0) {
                layoutItem = layout.addItem();
                String string2 = this.isSpentRoundChambered() ? "Tooltip_weapon_SpentRoundChambered" : "Tooltip_weapon_NoRoundChambered";
                layoutItem.setLabel(Translator.getText(string2), Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
            } else if (this.getSpentRoundCount() > 0) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_weapon_SpentRounds") + ":", Core.getInstance().getBadHighlitedColor().getR(), Core.getInstance().getBadHighlitedColor().getG(), Core.getInstance().getBadHighlitedColor().getB(), 1.0f);
                layoutItem.setValue(this.getSpentRoundCount() + " / " + this.getMaxAmmo(), 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!StringUtils.isNullOrEmpty(this.getMagazineType())) {
                if (this.isContainsClip()) {
                    layoutItem = layout.addItem();
                    layoutItem.setLabel(Translator.getText("Tooltip_weapon_ContainsClip"), 1.0f, 1.0f, 0.8f, 1.0f);
                } else {
                    layoutItem = layout.addItem();
                    layoutItem.setLabel(Translator.getText("Tooltip_weapon_NoClip"), 1.0f, 1.0f, 0.8f, 1.0f);
                }
            }
        } else {
            Object object;
            if (string == null && this.hasModData() && (object = this.getModData().rawget("defaultAmmo")) instanceof String) {
                string = (String)object;
            }
            if (string != null) {
                Item item = ScriptManager.instance.FindItem(string);
                if (item == null) {
                    item = ScriptManager.instance.FindItem(this.getModule() + "." + string);
                }
                if (item != null) {
                    layoutItem = layout.addItem();
                    layoutItem.setLabel(Translator.getText("Tooltip_weapon_Ammo") + ":", f3, f4, f5, f6);
                    layoutItem.setValue(item.getDisplayName(), 1.0f, 1.0f, 1.0f, 1.0f);
                }
                Object object2 = this.getModData().rawget("currentCapacity");
                Object object3 = this.getModData().rawget("maxCapacity");
                if (object2 instanceof Double && object3 instanceof Double) {
                    String string3 = ((Double)object2).intValue() + " / " + ((Double)object3).intValue();
                    Object object4 = this.getModData().rawget("roundChambered");
                    if (object4 instanceof Double && ((Double)object4).intValue() == 1) {
                        string3 = ((Double)object2).intValue() + "+1 / " + ((Double)object3).intValue();
                    } else {
                        Object object5 = this.getModData().rawget("emptyShellChambered");
                        if (object5 instanceof Double && ((Double)object5).intValue() == 1) {
                            string3 = ((Double)object2).intValue() + "+x / " + ((Double)object3).intValue();
                        }
                    }
                    layoutItem = layout.addItem();
                    layoutItem.setLabel(Translator.getText("Tooltip_weapon_AmmoCount") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                    layoutItem.setValue(string3, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        ObjectTooltip.Layout layout2 = objectTooltip.beginLayout();
        if (this.getStock() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Stock") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getStock().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getSling() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Sling") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getSling().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getScope() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Scope") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getScope().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getCanon() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Canon") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getCanon().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getClip() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Clip") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getClip().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.getRecoilpad() != null) {
            layoutItem = layout2.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_RecoilPad") + ":", f3, f4, f5, f6);
            layoutItem.setValue(this.getRecoilpad().getName(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!layout2.items.isEmpty()) {
            layout.next = layout2;
            layout2.nextPadY = objectTooltip.getLineSpacing();
        } else {
            objectTooltip.endLayout(layout2);
        }
    }

    public float getDamageMod(IsoGameCharacter isoGameCharacter) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Blunt);
        if (this.ScriptItem.Categories.contains("Blunt")) {
            if (n >= 3 && n <= 6) {
                return 1.1f;
            }
            if (n >= 7) {
                return 1.2f;
            }
        }
        int n2 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
        if (this.ScriptItem.Categories.contains("Axe")) {
            if (n2 >= 3 && n2 <= 6) {
                return 1.1f;
            }
            if (n2 >= 7) {
                return 1.2f;
            }
        }
        int n3 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Spear);
        if (this.ScriptItem.Categories.contains("Spear")) {
            if (n3 >= 3 && n3 <= 6) {
                return 1.1f;
            }
            if (n3 >= 7) {
                return 1.2f;
            }
        }
        return 1.0f;
    }

    public float getRangeMod(IsoGameCharacter isoGameCharacter) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Blunt);
        if (this.ScriptItem.Categories.contains("Blunt") && n >= 7) {
            return 1.2f;
        }
        int n2 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
        if (this.ScriptItem.Categories.contains("Axe") && n2 >= 7) {
            return 1.2f;
        }
        int n3 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Spear);
        if (this.ScriptItem.Categories.contains("Spear") && n3 >= 7) {
            return 1.2f;
        }
        return 1.0f;
    }

    public float getFatigueMod(IsoGameCharacter isoGameCharacter) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Blunt);
        if (this.ScriptItem.Categories.contains("Blunt") && n >= 8) {
            return 0.8f;
        }
        int n2 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
        if (this.ScriptItem.Categories.contains("Axe") && n2 >= 8) {
            return 0.8f;
        }
        int n3 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Spear);
        if (this.ScriptItem.Categories.contains("Spear") && n3 >= 8) {
            return 0.8f;
        }
        return 1.0f;
    }

    public float getKnockbackMod(IsoGameCharacter isoGameCharacter) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
        if (this.ScriptItem.Categories.contains("Axe") && n >= 6) {
            return 2.0f;
        }
        return 1.0f;
    }

    public float getSpeedMod(IsoGameCharacter isoGameCharacter) {
        int n;
        if (this.ScriptItem.Categories.contains("Blunt")) {
            n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Blunt);
            if (n >= 10) {
                return 0.65f;
            }
            if (n >= 9) {
                return 0.68f;
            }
            if (n >= 8) {
                return 0.71f;
            }
            if (n >= 7) {
                return 0.74f;
            }
            if (n >= 6) {
                return 0.77f;
            }
            if (n >= 5) {
                return 0.8f;
            }
            if (n >= 4) {
                return 0.83f;
            }
            if (n >= 3) {
                return 0.86f;
            }
            if (n >= 2) {
                return 0.9f;
            }
            if (n >= 1) {
                return 0.95f;
            }
        }
        if (this.ScriptItem.Categories.contains("Axe")) {
            n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
            float f = 1.0f;
            if (isoGameCharacter.Traits.Axeman.isSet()) {
                f = 0.95f;
            }
            if (n >= 10) {
                return 0.65f * f;
            }
            if (n >= 9) {
                return 0.68f * f;
            }
            if (n >= 8) {
                return 0.71f * f;
            }
            if (n >= 7) {
                return 0.74f * f;
            }
            if (n >= 6) {
                return 0.77f * f;
            }
            if (n >= 5) {
                return 0.8f * f;
            }
            if (n >= 4) {
                return 0.83f * f;
            }
            if (n >= 3) {
                return 0.86f * f;
            }
            if (n >= 2) {
                return 0.9f * f;
            }
            if (n >= 1) {
                return 0.95f * f;
            }
            return 1.0f * f;
        }
        if (this.ScriptItem.Categories.contains("Spear")) {
            n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Spear);
            if (n >= 10) {
                return 0.65f;
            }
            if (n >= 9) {
                return 0.68f;
            }
            if (n >= 8) {
                return 0.71f;
            }
            if (n >= 7) {
                return 0.74f;
            }
            if (n >= 6) {
                return 0.77f;
            }
            if (n >= 5) {
                return 0.8f;
            }
            if (n >= 4) {
                return 0.83f;
            }
            if (n >= 3) {
                return 0.86f;
            }
            if (n >= 2) {
                return 0.9f;
            }
            if (n >= 1) {
                return 0.95f;
            }
        }
        return 1.0f;
    }

    public float getToHitMod(IsoGameCharacter isoGameCharacter) {
        int n = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Blunt);
        if (this.ScriptItem.Categories.contains("Blunt")) {
            if (n == 1) {
                return 1.2f;
            }
            if (n == 2) {
                return 1.3f;
            }
            if (n == 3) {
                return 1.4f;
            }
            if (n == 4) {
                return 1.5f;
            }
            if (n == 5) {
                return 1.6f;
            }
            if (n == 6) {
                return 1.7f;
            }
            if (n == 7) {
                return 1.8f;
            }
            if (n == 8) {
                return 1.9f;
            }
            if (n == 9) {
                return 2.0f;
            }
            if (n == 10) {
                return 100.0f;
            }
        }
        int n2 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Axe);
        if (this.ScriptItem.Categories.contains("Axe")) {
            if (n2 == 1) {
                return 1.2f;
            }
            if (n2 == 2) {
                return 1.3f;
            }
            if (n2 == 3) {
                return 1.4f;
            }
            if (n2 == 4) {
                return 1.5f;
            }
            if (n2 == 5) {
                return 1.6f;
            }
            if (n2 == 6) {
                return 1.7f;
            }
            if (n2 == 7) {
                return 1.8f;
            }
            if (n2 == 8) {
                return 1.9f;
            }
            if (n2 == 9) {
                return 2.0f;
            }
            if (n2 == 10) {
                return 100.0f;
            }
        }
        int n3 = isoGameCharacter.getPerkLevel(PerkFactory.Perks.Spear);
        if (this.ScriptItem.Categories.contains("Spear")) {
            if (n3 == 1) {
                return 1.2f;
            }
            if (n3 == 2) {
                return 1.3f;
            }
            if (n3 == 3) {
                return 1.4f;
            }
            if (n3 == 4) {
                return 1.5f;
            }
            if (n3 == 5) {
                return 1.6f;
            }
            if (n3 == 6) {
                return 1.7f;
            }
            if (n3 == 7) {
                return 1.8f;
            }
            if (n3 == 8) {
                return 1.9f;
            }
            if (n3 == 9) {
                return 2.0f;
            }
            if (n3 == 10) {
                return 100.0f;
            }
        }
        return 1.0f;
    }

    public boolean isAngleFalloff() {
        return this.angleFalloff;
    }

    public void setAngleFalloff(boolean bl) {
        this.angleFalloff = bl;
    }

    public boolean isCanBarracade() {
        return this.bCanBarracade;
    }

    public void setCanBarracade(boolean bl) {
        this.bCanBarracade = bl;
    }

    public float getDoSwingBeforeImpact() {
        return this.doSwingBeforeImpact;
    }

    public void setDoSwingBeforeImpact(float f) {
        this.doSwingBeforeImpact = f;
    }

    public String getImpactSound() {
        return this.impactSound;
    }

    public void setImpactSound(String string) {
        this.impactSound = string;
    }

    public boolean isKnockBackOnNoDeath() {
        return this.knockBackOnNoDeath;
    }

    public void setKnockBackOnNoDeath(boolean bl) {
        this.knockBackOnNoDeath = bl;
    }

    public float getMaxAngle() {
        return this.maxAngle;
    }

    public void setMaxAngle(float f) {
        this.maxAngle = f;
    }

    public float getMaxDamage() {
        return this.maxDamage;
    }

    public void setMaxDamage(float f) {
        this.maxDamage = f;
    }

    public int getMaxHitCount() {
        return this.maxHitCount;
    }

    public void setMaxHitCount(int n) {
        this.maxHitCount = n;
    }

    public float getMaxRange() {
        return this.maxRange;
    }

    public float getMaxRange(IsoGameCharacter isoGameCharacter) {
        if (this.isRanged()) {
            return this.maxRange + this.getAimingPerkRangeModifier() * ((float)isoGameCharacter.getPerkLevel(PerkFactory.Perks.Aiming) / 2.0f);
        }
        return this.maxRange;
    }

    public void setMaxRange(float f) {
        this.maxRange = f;
    }

    public boolean isRanged() {
        return this.ranged;
    }

    public void setRanged(boolean bl) {
        this.ranged = bl;
    }

    public float getMinAngle() {
        return this.minAngle;
    }

    public void setMinAngle(float f) {
        this.minAngle = f;
    }

    public float getMinDamage() {
        return this.minDamage;
    }

    public void setMinDamage(float f) {
        this.minDamage = f;
    }

    public float getMinimumSwingTime() {
        return this.minimumSwingTime;
    }

    public void setMinimumSwingTime(float f) {
        this.minimumSwingTime = f;
    }

    public float getMinRange() {
        return this.minRange;
    }

    public void setMinRange(float f) {
        this.minRange = f;
    }

    public float getNoiseFactor() {
        return this.noiseFactor;
    }

    public void setNoiseFactor(float f) {
        this.noiseFactor = f;
    }

    public String getOtherHandRequire() {
        return this.otherHandRequire;
    }

    public void setOtherHandRequire(String string) {
        this.otherHandRequire = string;
    }

    public boolean isOtherHandUse() {
        return this.otherHandUse;
    }

    public void setOtherHandUse(boolean bl) {
        this.otherHandUse = bl;
    }

    public String getPhysicsObject() {
        return this.physicsObject;
    }

    public void setPhysicsObject(String string) {
        this.physicsObject = string;
    }

    public float getPushBackMod() {
        return this.pushBackMod;
    }

    public void setPushBackMod(float f) {
        this.pushBackMod = f;
    }

    public boolean isRangeFalloff() {
        return this.rangeFalloff;
    }

    public void setRangeFalloff(boolean bl) {
        this.rangeFalloff = bl;
    }

    public boolean isShareDamage() {
        return this.shareDamage;
    }

    public void setShareDamage(boolean bl) {
        this.shareDamage = bl;
    }

    public int getSoundRadius() {
        return this.soundRadius;
    }

    public void setSoundRadius(int n) {
        this.soundRadius = n;
    }

    public int getSoundVolume() {
        return this.soundVolume;
    }

    public void setSoundVolume(int n) {
        this.soundVolume = n;
    }

    public boolean isSplatBloodOnNoDeath() {
        return this.splatBloodOnNoDeath;
    }

    public void setSplatBloodOnNoDeath(boolean bl) {
        this.splatBloodOnNoDeath = bl;
    }

    public int getSplatNumber() {
        return this.splatNumber;
    }

    public void setSplatNumber(int n) {
        this.splatNumber = n;
    }

    public String getSwingSound() {
        return this.swingSound;
    }

    public void setSwingSound(String string) {
        this.swingSound = string;
    }

    public float getSwingTime() {
        return this.swingTime;
    }

    public void setSwingTime(float f) {
        this.swingTime = f;
    }

    public float getToHitModifier() {
        return this.toHitModifier;
    }

    public void setToHitModifier(float f) {
        this.toHitModifier = f;
    }

    public boolean isUseEndurance() {
        return this.useEndurance;
    }

    public void setUseEndurance(boolean bl) {
        this.useEndurance = bl;
    }

    public boolean isUseSelf() {
        return this.useSelf;
    }

    public void setUseSelf(boolean bl) {
        this.useSelf = bl;
    }

    public String getWeaponSprite() {
        return this.weaponSprite;
    }

    public void setWeaponSprite(String string) {
        this.weaponSprite = string;
    }

    public float getOtherBoost() {
        return this.otherBoost;
    }

    public void setOtherBoost(float f) {
        this.otherBoost = f;
    }

    public int getDoorDamage() {
        return this.DoorDamage;
    }

    public void setDoorDamage(int n) {
        this.DoorDamage = n;
    }

    public String getDoorHitSound() {
        return this.doorHitSound;
    }

    public void setDoorHitSound(String string) {
        this.doorHitSound = string;
    }

    public int getConditionLowerChance() {
        return this.ConditionLowerChance;
    }

    public void setConditionLowerChance(int n) {
        this.ConditionLowerChance = n;
    }

    public boolean isMultipleHitConditionAffected() {
        return this.MultipleHitConditionAffected;
    }

    public void setMultipleHitConditionAffected(boolean bl) {
        this.MultipleHitConditionAffected = bl;
    }

    public boolean isShareEndurance() {
        return this.shareEndurance;
    }

    public void setShareEndurance(boolean bl) {
        this.shareEndurance = bl;
    }

    public boolean isAlwaysKnockdown() {
        return this.AlwaysKnockdown;
    }

    public void setAlwaysKnockdown(boolean bl) {
        this.AlwaysKnockdown = bl;
    }

    public float getEnduranceMod() {
        return this.EnduranceMod;
    }

    public void setEnduranceMod(float f) {
        this.EnduranceMod = f;
    }

    public float getKnockdownMod() {
        return this.KnockdownMod;
    }

    public void setKnockdownMod(float f) {
        this.KnockdownMod = f;
    }

    public boolean isCantAttackWithLowestEndurance() {
        return this.CantAttackWithLowestEndurance;
    }

    public void setCantAttackWithLowestEndurance(boolean bl) {
        this.CantAttackWithLowestEndurance = bl;
    }

    public boolean isAimedFirearm() {
        return this.bIsAimedFirearm;
    }

    public boolean isAimedHandWeapon() {
        return this.bIsAimedHandWeapon;
    }

    public int getProjectileCount() {
        return this.ProjectileCount;
    }

    public void setProjectileCount(int n) {
        this.ProjectileCount = n;
    }

    public float getAimingMod() {
        return this.aimingMod;
    }

    public boolean isAimed() {
        return this.bIsAimedFirearm || this.bIsAimedHandWeapon;
    }

    public void setCriticalChance(float f) {
        this.CriticalChance = f;
    }

    public float getCriticalChance() {
        return this.CriticalChance;
    }

    public void setSubCategory(String string) {
        this.SubCategory = string;
    }

    public String getSubCategory() {
        return this.SubCategory;
    }

    public void setZombieHitSound(String string) {
        this.hitSound = string;
    }

    public String getZombieHitSound() {
        return this.hitSound;
    }

    public ArrayList<String> getCategories() {
        return this.Categories;
    }

    public void setCategories(ArrayList<String> arrayList) {
        this.Categories = arrayList;
    }

    public int getAimingPerkCritModifier() {
        return this.AimingPerkCritModifier;
    }

    public void setAimingPerkCritModifier(int n) {
        this.AimingPerkCritModifier = n;
    }

    public float getAimingPerkRangeModifier() {
        return this.AimingPerkRangeModifier;
    }

    public void setAimingPerkRangeModifier(float f) {
        this.AimingPerkRangeModifier = f;
    }

    public int getHitChance() {
        return this.HitChance;
    }

    public void setHitChance(int n) {
        this.HitChance = n;
    }

    public float getAimingPerkHitChanceModifier() {
        return this.AimingPerkHitChanceModifier;
    }

    public void setAimingPerkHitChanceModifier(float f) {
        this.AimingPerkHitChanceModifier = f;
    }

    public float getAimingPerkMinAngleModifier() {
        return this.AimingPerkMinAngleModifier;
    }

    public void setAimingPerkMinAngleModifier(float f) {
        this.AimingPerkMinAngleModifier = f;
    }

    public int getRecoilDelay() {
        return this.RecoilDelay;
    }

    public void setRecoilDelay(int n) {
        this.RecoilDelay = n;
    }

    public boolean isPiercingBullets() {
        return this.PiercingBullets;
    }

    public void setPiercingBullets(boolean bl) {
        this.PiercingBullets = bl;
    }

    public float getSoundGain() {
        return this.soundGain;
    }

    public void setSoundGain(float f) {
        this.soundGain = f;
    }

    public WeaponPart getScope() {
        return this.scope;
    }

    public void setScope(WeaponPart weaponPart) {
        this.scope = weaponPart;
    }

    public WeaponPart getClip() {
        return this.clip;
    }

    public void setClip(WeaponPart weaponPart) {
        this.clip = weaponPart;
    }

    public WeaponPart getCanon() {
        return this.canon;
    }

    public void setCanon(WeaponPart weaponPart) {
        this.canon = weaponPart;
    }

    public WeaponPart getRecoilpad() {
        return this.recoilpad;
    }

    public void setRecoilpad(WeaponPart weaponPart) {
        this.recoilpad = weaponPart;
    }

    public int getClipSize() {
        return this.ClipSize;
    }

    public void setClipSize(int n) {
        this.ClipSize = n;
        this.getModData().rawset("maxCapacity", (Object)BoxedStaticValues.toDouble(n));
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Integer, byteBuffer);
        if (this.maxRange != 1.0f) {
            bitHeaderWrite.addFlags(1);
            byteBuffer.putFloat(this.maxRange);
        }
        if (this.minRangeRanged != 0.0f) {
            bitHeaderWrite.addFlags(2);
            byteBuffer.putFloat(this.minRangeRanged);
        }
        if (this.ClipSize != 0) {
            bitHeaderWrite.addFlags(4);
            byteBuffer.putInt(this.ClipSize);
        }
        if (this.minDamage != 0.4f) {
            bitHeaderWrite.addFlags(8);
            byteBuffer.putFloat(this.minDamage);
        }
        if (this.maxDamage != 1.5f) {
            bitHeaderWrite.addFlags(16);
            byteBuffer.putFloat(this.maxDamage);
        }
        if (this.RecoilDelay != 0) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.putInt(this.RecoilDelay);
        }
        if (this.aimingTime != 0) {
            bitHeaderWrite.addFlags(64);
            byteBuffer.putInt(this.aimingTime);
        }
        if (this.reloadTime != 0) {
            bitHeaderWrite.addFlags(128);
            byteBuffer.putInt(this.reloadTime);
        }
        if (this.HitChance != 0) {
            bitHeaderWrite.addFlags(256);
            byteBuffer.putInt(this.HitChance);
        }
        if (this.minAngle != 0.5f) {
            bitHeaderWrite.addFlags(512);
            byteBuffer.putFloat(this.minAngle);
        }
        if (this.getScope() != null) {
            bitHeaderWrite.addFlags(1024);
            byteBuffer.putShort(this.getScope().getRegistry_id());
        }
        if (this.getClip() != null) {
            bitHeaderWrite.addFlags(2048);
            byteBuffer.putShort(this.getClip().getRegistry_id());
        }
        if (this.getRecoilpad() != null) {
            bitHeaderWrite.addFlags(4096);
            byteBuffer.putShort(this.getRecoilpad().getRegistry_id());
        }
        if (this.getSling() != null) {
            bitHeaderWrite.addFlags(8192);
            byteBuffer.putShort(this.getSling().getRegistry_id());
        }
        if (this.getStock() != null) {
            bitHeaderWrite.addFlags(16384);
            byteBuffer.putShort(this.getStock().getRegistry_id());
        }
        if (this.getCanon() != null) {
            bitHeaderWrite.addFlags(32768);
            byteBuffer.putShort(this.getCanon().getRegistry_id());
        }
        if (this.getExplosionTimer() != 0) {
            bitHeaderWrite.addFlags(65536);
            byteBuffer.putInt(this.getExplosionTimer());
        }
        if (this.maxAngle != 1.0f) {
            bitHeaderWrite.addFlags(131072);
            byteBuffer.putFloat(this.maxAngle);
        }
        if (this.bloodLevel != 0.0f) {
            bitHeaderWrite.addFlags(262144);
            byteBuffer.putFloat(this.bloodLevel);
        }
        if (this.containsClip) {
            bitHeaderWrite.addFlags(524288);
        }
        if (this.roundChambered) {
            bitHeaderWrite.addFlags(0x100000);
        }
        if (this.isJammed) {
            bitHeaderWrite.addFlags(0x200000);
        }
        if (!StringUtils.equals(this.weaponSprite, this.getScriptItem().getWeaponSprite())) {
            bitHeaderWrite.addFlags(0x400000);
            GameWindow.WriteString(byteBuffer, this.weaponSprite);
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.maxRange = 1.0f;
        this.minRangeRanged = 0.0f;
        this.ClipSize = 0;
        this.minDamage = 0.4f;
        this.maxDamage = 1.5f;
        this.RecoilDelay = 0;
        this.aimingTime = 0;
        this.reloadTime = 0;
        this.HitChance = 0;
        this.minAngle = 0.5f;
        this.scope = null;
        this.clip = null;
        this.recoilpad = null;
        this.sling = null;
        this.stock = null;
        this.canon = null;
        this.explosionTimer = 0;
        this.maxAngle = 1.0f;
        this.bloodLevel = 0.0f;
        this.containsClip = false;
        this.roundChambered = false;
        this.isJammed = false;
        this.weaponSprite = this.getScriptItem().getWeaponSprite();
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Integer, byteBuffer);
        if (!bitHeaderRead.equals(0)) {
            InventoryItem inventoryItem;
            if (bitHeaderRead.hasFlags(1)) {
                this.setMaxRange(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(2)) {
                this.setMinRangeRanged(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(4)) {
                this.setClipSize(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(8)) {
                this.setMinDamage(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(16)) {
                this.setMaxDamage(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(32)) {
                this.setRecoilDelay(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(64)) {
                this.setAimingTime(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(128)) {
                this.setReloadTime(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(256)) {
                this.setHitChance(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(512)) {
                this.setMinAngle(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(1024) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(2048) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(4096) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(8192) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(16384) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(32768) && (inventoryItem = InventoryItemFactory.CreateItem(byteBuffer.getShort())) != null && inventoryItem instanceof WeaponPart) {
                this.attachWeaponPart((WeaponPart)inventoryItem, false);
            }
            if (bitHeaderRead.hasFlags(65536)) {
                this.setExplosionTimer(byteBuffer.getInt());
            }
            if (bitHeaderRead.hasFlags(131072)) {
                this.setMaxAngle(byteBuffer.getFloat());
            }
            if (bitHeaderRead.hasFlags(262144)) {
                this.setBloodLevel(byteBuffer.getFloat());
            }
            this.setContainsClip(bitHeaderRead.hasFlags(524288));
            if (StringUtils.isNullOrWhitespace(this.magazineType)) {
                this.setContainsClip(false);
            }
            this.setRoundChambered(bitHeaderRead.hasFlags(0x100000));
            this.setJammed(bitHeaderRead.hasFlags(0x200000));
            if (bitHeaderRead.hasFlags(0x400000)) {
                this.setWeaponSprite(GameWindow.ReadStringUTF(byteBuffer));
            }
        }
        bitHeaderRead.release();
    }

    public float getMinRangeRanged() {
        return this.minRangeRanged;
    }

    public void setMinRangeRanged(float f) {
        this.minRangeRanged = f;
    }

    public int getReloadTime() {
        return this.reloadTime;
    }

    public void setReloadTime(int n) {
        this.reloadTime = n;
    }

    public WeaponPart getSling() {
        return this.sling;
    }

    public void setSling(WeaponPart weaponPart) {
        this.sling = weaponPart;
    }

    public int getAimingTime() {
        return this.aimingTime;
    }

    public void setAimingTime(int n) {
        this.aimingTime = n;
    }

    public WeaponPart getStock() {
        return this.stock;
    }

    public void setStock(WeaponPart weaponPart) {
        this.stock = weaponPart;
    }

    public int getTreeDamage() {
        return this.treeDamage;
    }

    public void setTreeDamage(int n) {
        this.treeDamage = n;
    }

    public String getBulletOutSound() {
        return this.bulletOutSound;
    }

    public void setBulletOutSound(String string) {
        this.bulletOutSound = string;
    }

    public String getShellFallSound() {
        return this.shellFallSound;
    }

    public void setShellFallSound(String string) {
        this.shellFallSound = string;
    }

    private void addPartToList(String string, ArrayList<WeaponPart> arrayList) {
        WeaponPart weaponPart = this.getWeaponPart(string);
        if (weaponPart != null) {
            arrayList.add(weaponPart);
        }
    }

    public ArrayList<WeaponPart> getAllWeaponParts() {
        return this.getAllWeaponParts(new ArrayList<WeaponPart>());
    }

    public ArrayList<WeaponPart> getAllWeaponParts(ArrayList<WeaponPart> arrayList) {
        arrayList.clear();
        this.addPartToList("Scope", arrayList);
        this.addPartToList("Clip", arrayList);
        this.addPartToList("Sling", arrayList);
        this.addPartToList("Canon", arrayList);
        this.addPartToList("Stock", arrayList);
        this.addPartToList("RecoilPad", arrayList);
        return arrayList;
    }

    public void setWeaponPart(String string, WeaponPart weaponPart) {
        if (weaponPart != null && !string.equalsIgnoreCase(weaponPart.getPartType())) {
            return;
        }
        if ("Scope".equalsIgnoreCase(string)) {
            this.scope = weaponPart;
        } else if ("Clip".equalsIgnoreCase(string)) {
            this.clip = weaponPart;
        } else if ("Sling".equalsIgnoreCase(string)) {
            this.sling = weaponPart;
        } else if ("Canon".equalsIgnoreCase(string)) {
            this.canon = weaponPart;
        } else if ("Stock".equalsIgnoreCase(string)) {
            this.stock = weaponPart;
        } else if ("RecoilPad".equalsIgnoreCase(string)) {
            this.recoilpad = weaponPart;
        } else {
            DebugLog.log("ERROR: unknown WeaponPart type \"" + string + "\"");
        }
    }

    public WeaponPart getWeaponPart(String string) {
        if ("Scope".equalsIgnoreCase(string)) {
            return this.scope;
        }
        if ("Clip".equalsIgnoreCase(string)) {
            return this.clip;
        }
        if ("Sling".equalsIgnoreCase(string)) {
            return this.sling;
        }
        if ("Canon".equalsIgnoreCase(string)) {
            return this.canon;
        }
        if ("Stock".equalsIgnoreCase(string)) {
            return this.stock;
        }
        if ("RecoilPad".equalsIgnoreCase(string)) {
            return this.recoilpad;
        }
        DebugLog.log("ERROR: unknown WeaponPart type \"" + string + "\"");
        return null;
    }

    public float getWeaponPartWeightModifier(String string) {
        return this.getWeaponPartWeightModifier(this.getWeaponPart(string));
    }

    public float getWeaponPartWeightModifier(WeaponPart weaponPart) {
        return weaponPart == null ? 0.0f : weaponPart.getWeightModifier();
    }

    public void attachWeaponPart(WeaponPart weaponPart) {
        this.attachWeaponPart(weaponPart, true);
    }

    public void attachWeaponPart(WeaponPart weaponPart, boolean bl) {
        if (weaponPart == null) {
            return;
        }
        WeaponPart weaponPart2 = this.getWeaponPart(weaponPart.getPartType());
        if (weaponPart2 != null) {
            this.detachWeaponPart(weaponPart2);
        }
        this.setWeaponPart(weaponPart.getPartType(), weaponPart);
        if (bl) {
            this.setMaxRange(this.getMaxRange() + weaponPart.getMaxRange());
            this.setMinRangeRanged(this.getMinRangeRanged() + weaponPart.getMinRangeRanged());
            this.setClipSize(this.getClipSize() + weaponPart.getClipSize());
            this.setReloadTime(this.getReloadTime() + weaponPart.getReloadTime());
            this.setRecoilDelay((int)((float)this.getRecoilDelay() + weaponPart.getRecoilDelay()));
            this.setAimingTime(this.getAimingTime() + weaponPart.getAimingTime());
            this.setHitChance(this.getHitChance() + weaponPart.getHitChance());
            this.setMinAngle(this.getMinAngle() + weaponPart.getAngle());
            this.setMinDamage(this.getMinDamage() + weaponPart.getDamage());
            this.setMaxDamage(this.getMaxDamage() + weaponPart.getDamage());
        }
    }

    public void detachWeaponPart(WeaponPart weaponPart) {
        if (weaponPart == null) {
            return;
        }
        WeaponPart weaponPart2 = this.getWeaponPart(weaponPart.getPartType());
        if (weaponPart2 != weaponPart) {
            return;
        }
        this.setWeaponPart(weaponPart.getPartType(), null);
        this.setMaxRange(this.getMaxRange() - weaponPart.getMaxRange());
        this.setMinRangeRanged(this.getMinRangeRanged() - weaponPart.getMinRangeRanged());
        this.setClipSize(this.getClipSize() - weaponPart.getClipSize());
        this.setReloadTime(this.getReloadTime() - weaponPart.getReloadTime());
        this.setRecoilDelay((int)((float)this.getRecoilDelay() - weaponPart.getRecoilDelay()));
        this.setAimingTime(this.getAimingTime() - weaponPart.getAimingTime());
        this.setHitChance(this.getHitChance() - weaponPart.getHitChance());
        this.setMinAngle(this.getMinAngle() - weaponPart.getAngle());
        this.setMinDamage(this.getMinDamage() - weaponPart.getDamage());
        this.setMaxDamage(this.getMaxDamage() - weaponPart.getDamage());
    }

    public int getTriggerExplosionTimer() {
        return this.triggerExplosionTimer;
    }

    public void setTriggerExplosionTimer(int n) {
        this.triggerExplosionTimer = n;
    }

    public boolean canBePlaced() {
        return this.canBePlaced;
    }

    public void setCanBePlaced(boolean bl) {
        this.canBePlaced = bl;
    }

    public int getExplosionRange() {
        return this.explosionRange;
    }

    public void setExplosionRange(int n) {
        this.explosionRange = n;
    }

    public int getExplosionPower() {
        return this.explosionPower;
    }

    public void setExplosionPower(int n) {
        this.explosionPower = n;
    }

    public int getFireRange() {
        return this.fireRange;
    }

    public void setFireRange(int n) {
        this.fireRange = n;
    }

    public int getSmokeRange() {
        return this.smokeRange;
    }

    public void setSmokeRange(int n) {
        this.smokeRange = n;
    }

    public int getFirePower() {
        return this.firePower;
    }

    public void setFirePower(int n) {
        this.firePower = n;
    }

    public int getNoiseRange() {
        return this.noiseRange;
    }

    public void setNoiseRange(int n) {
        this.noiseRange = n;
    }

    public int getNoiseDuration() {
        return this.getScriptItem().getNoiseDuration();
    }

    public float getExtraDamage() {
        return this.extraDamage;
    }

    public void setExtraDamage(float f) {
        this.extraDamage = f;
    }

    public int getExplosionTimer() {
        return this.explosionTimer;
    }

    public void setExplosionTimer(int n) {
        this.explosionTimer = n;
    }

    public String getPlacedSprite() {
        return this.placedSprite;
    }

    public void setPlacedSprite(String string) {
        this.placedSprite = string;
    }

    public boolean canBeReused() {
        return this.canBeReused;
    }

    public void setCanBeReused(boolean bl) {
        this.canBeReused = bl;
    }

    public int getSensorRange() {
        return this.sensorRange;
    }

    public void setSensorRange(int n) {
        this.sensorRange = n;
    }

    public String getRunAnim() {
        return this.RunAnim;
    }

    public float getCritDmgMultiplier() {
        return this.critDmgMultiplier;
    }

    public void setCritDmgMultiplier(float f) {
        this.critDmgMultiplier = f;
    }

    @Override
    public String getStaticModel() {
        return this.staticModel != null ? this.staticModel : this.weaponSprite;
    }

    public float getBaseSpeed() {
        return this.baseSpeed;
    }

    public void setBaseSpeed(float f) {
        this.baseSpeed = f;
    }

    public float getBloodLevel() {
        return this.bloodLevel;
    }

    public void setBloodLevel(float f) {
        this.bloodLevel = Math.max(0.0f, Math.min(1.0f, f));
    }

    public void setWeaponLength(float f) {
        this.WeaponLength = f;
    }

    public String getAmmoBox() {
        return this.ammoBox;
    }

    public void setAmmoBox(String string) {
        this.ammoBox = string;
    }

    public String getMagazineType() {
        return this.magazineType;
    }

    public void setMagazineType(String string) {
        this.magazineType = string;
    }

    public String getEjectAmmoStartSound() {
        return this.getScriptItem().getEjectAmmoStartSound();
    }

    public String getEjectAmmoSound() {
        return this.getScriptItem().getEjectAmmoSound();
    }

    public String getEjectAmmoStopSound() {
        return this.getScriptItem().getEjectAmmoStopSound();
    }

    public String getInsertAmmoStartSound() {
        return this.getScriptItem().getInsertAmmoStartSound();
    }

    public String getInsertAmmoSound() {
        return this.getScriptItem().getInsertAmmoSound();
    }

    public String getInsertAmmoStopSound() {
        return this.getScriptItem().getInsertAmmoStopSound();
    }

    public String getRackSound() {
        return this.rackSound;
    }

    public void setRackSound(String string) {
        this.rackSound = string;
    }

    public boolean isReloadable(IsoGameCharacter isoGameCharacter) {
        return this.isRanged();
    }

    public boolean isContainsClip() {
        return this.containsClip;
    }

    public void setContainsClip(boolean bl) {
        this.containsClip = bl;
    }

    public InventoryItem getBestMagazine(IsoGameCharacter isoGameCharacter) {
        if (StringUtils.isNullOrEmpty(this.getMagazineType())) {
            return null;
        }
        InventoryItem inventoryItem3 = isoGameCharacter.getInventory().getBestTypeRecurse(this.getMagazineType(), (inventoryItem, inventoryItem2) -> inventoryItem.getCurrentAmmoCount() - inventoryItem2.getCurrentAmmoCount());
        if (inventoryItem3 == null || inventoryItem3.getCurrentAmmoCount() == 0) {
            return null;
        }
        return inventoryItem3;
    }

    public String getWeaponReloadType() {
        return this.weaponReloadType;
    }

    public void setWeaponReloadType(String string) {
        this.weaponReloadType = string;
    }

    public boolean isRackAfterShoot() {
        return this.rackAfterShoot;
    }

    public void setRackAfterShoot(boolean bl) {
        this.rackAfterShoot = bl;
    }

    public boolean isRoundChambered() {
        return this.roundChambered;
    }

    public void setRoundChambered(boolean bl) {
        this.roundChambered = bl;
    }

    public boolean isSpentRoundChambered() {
        return this.bSpentRoundChambered;
    }

    public void setSpentRoundChambered(boolean bl) {
        this.bSpentRoundChambered = bl;
    }

    public int getSpentRoundCount() {
        return this.spentRoundCount;
    }

    public void setSpentRoundCount(int n) {
        this.spentRoundCount = PZMath.clamp(n, 0, this.getMaxAmmo());
    }

    public boolean isManuallyRemoveSpentRounds() {
        return this.getScriptItem().isManuallyRemoveSpentRounds();
    }

    public int getAmmoPerShoot() {
        return this.ammoPerShoot;
    }

    public void setAmmoPerShoot(int n) {
        this.ammoPerShoot = n;
    }

    public float getJamGunChance() {
        return this.jamGunChance;
    }

    public void setJamGunChance(float f) {
        this.jamGunChance = f;
    }

    public boolean isJammed() {
        return this.isJammed;
    }

    public void setJammed(boolean bl) {
        this.isJammed = bl;
    }

    public String getClickSound() {
        return this.clickSound;
    }

    public void setClickSound(String string) {
        this.clickSound = string;
    }

    public ArrayList<ModelWeaponPart> getModelWeaponPart() {
        return this.modelWeaponPart;
    }

    public void setModelWeaponPart(ArrayList<ModelWeaponPart> arrayList) {
        this.modelWeaponPart = arrayList;
    }

    public String getOriginalWeaponSprite() {
        return this.originalWeaponSprite;
    }

    public void setOriginalWeaponSprite(String string) {
        this.originalWeaponSprite = string;
    }

    public boolean haveChamber() {
        return this.haveChamber;
    }

    public void setHaveChamber(boolean bl) {
        this.haveChamber = bl;
    }

    public String getDamageCategory() {
        return this.damageCategory;
    }

    public void setDamageCategory(String string) {
        this.damageCategory = string;
    }

    public boolean isDamageMakeHole() {
        return this.damageMakeHole;
    }

    public void setDamageMakeHole(boolean bl) {
        this.damageMakeHole = bl;
    }

    public String getHitFloorSound() {
        return this.hitFloorSound;
    }

    public void setHitFloorSound(String string) {
        this.hitFloorSound = string;
    }

    public boolean isInsertAllBulletsReload() {
        return this.insertAllBulletsReload;
    }

    public void setInsertAllBulletsReload(boolean bl) {
        this.insertAllBulletsReload = bl;
    }

    public String getFireMode() {
        return this.fireMode;
    }

    public void setFireMode(String string) {
        this.fireMode = string;
    }

    public ArrayList<String> getFireModePossibilities() {
        return this.fireModePossibilities;
    }

    public void setFireModePossibilities(ArrayList<String> arrayList) {
        this.fireModePossibilities = arrayList;
    }

    public void randomizeBullets() {
        if (!this.isRanged() || Rand.NextBool(4)) {
            return;
        }
        this.setCurrentAmmoCount(Rand.Next(this.getMaxAmmo() - 2, this.getMaxAmmo()));
        if (!StringUtils.isNullOrEmpty(this.getMagazineType())) {
            this.setContainsClip(true);
        }
        if (this.haveChamber()) {
            this.setRoundChambered(true);
        }
    }

    public float getStopPower() {
        return this.getScriptItem().stopPower;
    }

    public boolean isInstantExplosion() {
        return this.explosionTimer <= 0 && this.sensorRange <= 0 && this.getRemoteControlID() == -1;
    }
}

