/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.util.List;
import zombie.GameTime;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.math.PZMath;
import zombie.interfaces.IUpdater;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemUser;
import zombie.inventory.types.Drainable;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoWorld;
import zombie.iso.objects.RainManager;
import zombie.network.GameServer;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;

public final class DrainableComboItem
extends InventoryItem
implements Drainable,
IUpdater {
    protected boolean bUseWhileEquiped = true;
    protected boolean bUseWhileUnequiped = false;
    protected int ticksPerEquipUse = 30;
    protected float useDelta = 0.03125f;
    protected float delta = 1.0f;
    protected float ticks = 0.0f;
    protected String ReplaceOnDeplete = null;
    protected String ReplaceOnDepleteFullType = null;
    public List<String> ReplaceOnCooked = null;
    private String OnCooked = null;
    private float rainFactor = 0.0f;
    private boolean canConsolidate = true;
    private float WeightEmpty = 0.0f;
    private static final float MIN_HEAT = 0.2f;
    private static final float MAX_HEAT = 3.0f;
    protected float Heat = 1.0f;
    protected int LastCookMinute = 0;

    public DrainableComboItem(String string, String string2, String string3, String string4) {
        super(string, string2, string3, string4);
    }

    public DrainableComboItem(String string, String string2, String string3, Item item) {
        super(string, string2, string3, item);
    }

    @Override
    public boolean IsDrainable() {
        return true;
    }

    @Override
    public int getSaveType() {
        return Item.Type.Drainable.ordinal();
    }

    @Override
    public boolean CanStack(InventoryItem inventoryItem) {
        return false;
    }

    @Override
    public float getUsedDelta() {
        return this.delta;
    }

    public int getDrainableUsesInt() {
        return (int)Math.floor(((double)this.getUsedDelta() + 1.0E-4) / (double)this.getUseDelta());
    }

    public float getDrainableUsesFloat() {
        return this.getUsedDelta() / this.getUseDelta();
    }

    @Override
    public void render() {
    }

    @Override
    public void renderlast() {
    }

    @Override
    public void setUsedDelta(float f) {
        this.delta = PZMath.clamp(f, 0.0f, 1.0f);
        this.updateWeight();
    }

    @Override
    public boolean shouldUpdateInWorld() {
        if (!GameServer.bServer && this.Heat != 1.0f) {
            return true;
        }
        if (this.canStoreWater() && this.isWaterSource() && this.getUsedDelta() < 1.0f) {
            IsoGridSquare isoGridSquare = this.getWorldItem().getSquare();
            return isoGridSquare != null && isoGridSquare.isOutside();
        }
        return false;
    }

    @Override
    public void update() {
        IsoGridSquare isoGridSquare;
        int n;
        float f;
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer != null) {
            f = itemContainer.getTemprature();
            if (this.Heat > f) {
                this.Heat -= 0.001f * GameTime.instance.getMultiplier();
                if (this.Heat < Math.max(0.2f, f)) {
                    this.Heat = Math.max(0.2f, f);
                }
            }
            if (this.Heat < f) {
                this.Heat += f / 1000.0f * GameTime.instance.getMultiplier();
                if (this.Heat > Math.min(3.0f, f)) {
                    this.Heat = Math.min(3.0f, f);
                }
            }
            if (this.IsCookable) {
                if (this.Heat > 1.6f && (n = GameTime.getInstance().getMinutes()) != this.LastCookMinute) {
                    float f2;
                    this.LastCookMinute = n;
                    var4_6 = this.Heat / 1.5f;
                    if (itemContainer.getTemprature() <= 1.6f) {
                        var4_6 *= 0.05f;
                    }
                    if ((f2 = this.CookingTime) < 1.0f) {
                        f2 = 10.0f;
                    }
                    f2 += var4_6;
                    if (this.isTaintedWater() && f2 > Math.min(this.MinutesToCook, 10.0f)) {
                        this.setTaintedWater(false);
                    }
                    if (!this.isCooked() && f2 > this.MinutesToCook) {
                        this.setCooked(true);
                        if (this.getReplaceOnCooked() != null) {
                            for (int i = 0; i < this.getReplaceOnCooked().size(); ++i) {
                                InventoryItem inventoryItem = this.container.AddItem(this.getReplaceOnCooked().get(i));
                                if (inventoryItem == null) continue;
                                if (inventoryItem instanceof DrainableComboItem) {
                                    ((DrainableComboItem)inventoryItem).setUsedDelta(this.getUsedDelta());
                                }
                                inventoryItem.copyConditionModData(this);
                            }
                            this.container.Remove(this);
                            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
                            return;
                        }
                        if (this.getOnCooked() != null) {
                            LuaManager.caller.protectedCall(LuaManager.thread, LuaManager.env.rawget(this.getOnCooked()), this);
                            return;
                        }
                    }
                    if (this.CookingTime > this.MinutesToBurn) {
                        this.Burnt = true;
                        this.setCooked(false);
                    }
                }
            } else if (itemContainer != null && itemContainer.isMicrowave() && this.isTaintedWater() && this.Heat > 1.6f && (n = GameTime.getInstance().getMinutes()) != this.LastCookMinute) {
                this.LastCookMinute = n;
                var4_6 = 1.0f;
                if (itemContainer.getTemprature() <= 1.6f) {
                    var4_6 = (float)((double)var4_6 * 0.2);
                }
                this.CookingTime += var4_6;
                if (this.CookingTime > 10.0f) {
                    this.setTaintedWater(false);
                }
            }
        }
        if (this.container == null && this.Heat != 1.0f) {
            f = 1.0f;
            if (this.Heat > f) {
                this.Heat -= 0.001f * GameTime.instance.getMultiplier();
                if (this.Heat < f) {
                    this.Heat = f;
                }
            }
            if (this.Heat < f) {
                this.Heat += f / 1000.0f * GameTime.instance.getMultiplier();
                if (this.Heat > f) {
                    this.Heat = f;
                }
            }
        }
        if (this.bUseWhileEquiped && this.delta > 0.0f) {
            IsoGameCharacter isoGameCharacter = null;
            if (this.container != null && this.container.parent instanceof IsoPlayer) {
                for (n = 0; n < IsoPlayer.numPlayers; ++n) {
                    if (this.container.parent != IsoPlayer.players[n]) continue;
                    isoGameCharacter = IsoPlayer.players[n];
                }
            }
            if (isoGameCharacter != null && (this.canBeActivated() && this.isActivated() || !this.canBeActivated()) && (isoGameCharacter.isHandItem(this) || isoGameCharacter.isAttachedItem(this))) {
                this.ticks += GameTime.instance.getMultiplier();
                while (this.ticks >= (float)this.ticksPerEquipUse) {
                    this.ticks -= (float)this.ticksPerEquipUse;
                    if (!(this.delta > 0.0f)) continue;
                    this.Use();
                }
            }
        }
        if (this.bUseWhileUnequiped && this.delta > 0.0f && (this.canBeActivated() && this.isActivated() || !this.canBeActivated())) {
            this.ticks += GameTime.instance.getMultiplier();
            while (this.ticks >= (float)this.ticksPerEquipUse) {
                this.ticks -= (float)this.ticksPerEquipUse;
                if (!(this.delta > 0.0f)) continue;
                this.Use();
            }
        }
        if (this.getWorldItem() != null && this.canStoreWater() && this.isWaterSource() && RainManager.isRaining().booleanValue() && this.getRainFactor() > 0.0f && (isoGridSquare = this.getWorldItem().getSquare()) != null && isoGridSquare.isOutside()) {
            this.setUsedDelta(this.getUsedDelta() + 0.001f * RainManager.getRainIntensity() * GameTime.instance.getMultiplier() * this.getRainFactor());
            if (this.getUsedDelta() > 1.0f) {
                this.setUsedDelta(1.0f);
            }
            this.setTaintedWater(true);
            this.updateWeight();
        }
    }

    @Override
    public void Use() {
        InventoryItem inventoryItem;
        if (this.getWorldItem() != null) {
            ItemUser.UseItem(this);
            return;
        }
        this.delta -= this.useDelta;
        if (this.uses > 1) {
            int n = this.uses - 1;
            this.uses = 1;
            inventoryItem = InventoryItemFactory.CreateItem(this.getFullType());
            inventoryItem.setUses(n);
            this.container.AddItem(inventoryItem);
        }
        if (this.delta <= 1.0E-4f) {
            this.delta = 0.0f;
            if (this.getReplaceOnDeplete() != null) {
                String string = this.getReplaceOnDepleteFullType();
                if (this.container != null) {
                    inventoryItem = this.container.AddItem(string);
                    if (this.container.parent instanceof IsoGameCharacter) {
                        IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.container.parent;
                        if (isoGameCharacter.getPrimaryHandItem() == this) {
                            isoGameCharacter.setPrimaryHandItem(inventoryItem);
                        }
                        if (isoGameCharacter.getSecondaryHandItem() == this) {
                            isoGameCharacter.setSecondaryHandItem(inventoryItem);
                        }
                    }
                    inventoryItem.setCondition(this.getCondition());
                    inventoryItem.setFavorite(this.isFavorite());
                    this.container.Remove(this);
                }
            } else {
                super.Use();
            }
        }
        this.updateWeight();
    }

    public void updateWeight() {
        if (this.getReplaceOnDeplete() != null) {
            if (this.getUsedDelta() >= 1.0f) {
                this.setCustomWeight(true);
                this.setActualWeight(this.getScriptItem().getActualWeight());
                this.setWeight(this.getActualWeight());
                return;
            }
            Item item = ScriptManager.instance.getItem(this.ReplaceOnDepleteFullType);
            if (item != null) {
                this.setCustomWeight(true);
                this.setActualWeight((this.getScriptItem().getActualWeight() - item.getActualWeight()) * this.getUsedDelta() + item.getActualWeight());
                this.setWeight(this.getActualWeight());
            }
        }
        if (this.getWeightEmpty() != 0.0f) {
            this.setCustomWeight(true);
            this.setActualWeight((this.getScriptItem().getActualWeight() - this.WeightEmpty) * this.getUsedDelta() + this.WeightEmpty);
        }
    }

    public float getWeightEmpty() {
        return this.WeightEmpty;
    }

    public void setWeightEmpty(float f) {
        this.WeightEmpty = f;
    }

    public boolean isUseWhileEquiped() {
        return this.bUseWhileEquiped;
    }

    public void setUseWhileEquiped(boolean bl) {
        this.bUseWhileEquiped = bl;
    }

    public boolean isUseWhileUnequiped() {
        return this.bUseWhileUnequiped;
    }

    public void setUseWhileUnequiped(boolean bl) {
        this.bUseWhileUnequiped = bl;
    }

    public int getTicksPerEquipUse() {
        return this.ticksPerEquipUse;
    }

    public void setTicksPerEquipUse(int n) {
        this.ticksPerEquipUse = n;
    }

    public float getUseDelta() {
        return this.useDelta;
    }

    public void setUseDelta(float f) {
        this.useDelta = f;
    }

    public float getDelta() {
        return this.delta;
    }

    public void setDelta(float f) {
        this.delta = f;
    }

    public float getTicks() {
        return this.ticks;
    }

    public void setTicks(float f) {
        this.ticks = f;
    }

    public void setReplaceOnDeplete(String string) {
        this.ReplaceOnDeplete = string;
        this.ReplaceOnDepleteFullType = this.getReplaceOnDepleteFullType();
    }

    public String getReplaceOnDeplete() {
        return this.ReplaceOnDeplete;
    }

    public String getReplaceOnDepleteFullType() {
        return StringUtils.moduleDotType(this.getModule(), this.ReplaceOnDeplete);
    }

    public void setHeat(float f) {
        this.Heat = PZMath.clamp(f, 0.0f, 3.0f);
    }

    public float getHeat() {
        return this.Heat;
    }

    @Override
    public float getInvHeat() {
        return (1.0f - this.Heat) / 3.0f;
    }

    @Override
    public boolean finishupdate() {
        if (this.canStoreWater() && this.isWaterSource() && this.getWorldItem() != null && this.getWorldItem().getSquare() != null) {
            return this.getUsedDelta() >= 1.0f;
        }
        if (this.isTaintedWater()) {
            return false;
        }
        if (this.container != null) {
            if (this.Heat != this.container.getTemprature() || this.container.isTemperatureChanging()) {
                return false;
            }
            if (this.container.type.equals("campfire") || this.container.type.equals("barbecue")) {
                return false;
            }
        }
        return true;
    }

    public int getRemainingUses() {
        return Math.round(this.getUsedDelta() / this.getUseDelta());
    }

    public float getRainFactor() {
        return this.rainFactor;
    }

    public void setRainFactor(float f) {
        this.rainFactor = f;
    }

    public boolean canConsolidate() {
        return this.canConsolidate;
    }

    public void setCanConsolidate(boolean bl) {
        this.canConsolidate = bl;
    }

    public List<String> getReplaceOnCooked() {
        return this.ReplaceOnCooked;
    }

    public void setReplaceOnCooked(List<String> list) {
        this.ReplaceOnCooked = list;
    }

    public String getOnCooked() {
        return this.OnCooked;
    }

    public void setOnCooked(String string) {
        this.OnCooked = string;
    }
}

