/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory.types;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import zombie.GameTime;
import zombie.SoundManager;
import zombie.WorldSoundManager;
import zombie.ai.sadisticAIDirector.SleepingEvent;
import zombie.audio.BaseSoundEmitter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.Translator;
import zombie.core.network.ByteBufferWriter;
import zombie.core.utils.OnceEvery;
import zombie.inventory.InventoryItem;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemSoundManager;
import zombie.inventory.ItemType;
import zombie.inventory.types.Clothing;
import zombie.iso.IsoCell;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoUtils;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.network.PacketTypes;
import zombie.scripting.objects.Item;
import zombie.ui.ObjectTooltip;

public final class AlarmClockClothing
extends Clothing {
    private int alarmHour = -1;
    private int alarmMinutes = -1;
    private boolean alarmSet = false;
    private long ringSound;
    private double ringSince = -1.0;
    private int forceDontRing = -1;
    private String alarmSound = "AlarmClockLoop";
    private int soundRadius = 40;
    private boolean isDigital = true;
    public static short PacketPlayer = 1;
    public static short PacketWorld = (short)2;
    private static final OnceEvery sendEvery = new OnceEvery(2.0f);

    public AlarmClockClothing(String string, String string2, String string3, String string4, String string5, String string6) {
        super(string, string2, string3, string4, string5, string6);
        this.cat = ItemType.AlarmClockClothing;
        if (this.fullType.contains("Classic")) {
            this.isDigital = false;
        }
        this.randomizeAlarm();
    }

    public AlarmClockClothing(String string, String string2, String string3, Item item, String string4, String string5) {
        super(string, string2, string3, item, string4, string5);
        this.cat = ItemType.AlarmClockClothing;
        if (this.fullType.contains("Classic")) {
            this.isDigital = false;
        }
        this.randomizeAlarm();
    }

    private void randomizeAlarm() {
        if (Core.bLastStand) {
            return;
        }
        if (!this.isDigital()) {
            return;
        }
        this.alarmHour = Rand.Next(0, 23);
        this.alarmMinutes = (int)Math.floor(Rand.Next(0, 59) / 10) * 10;
        this.alarmSet = Rand.Next(15) == 1;
    }

    public IsoGridSquare getAlarmSquare() {
        IsoGridSquare isoGridSquare = null;
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer != null) {
            isoGridSquare = itemContainer.getSourceGrid();
            if (isoGridSquare == null && itemContainer.parent != null) {
                isoGridSquare = itemContainer.parent.square;
            }
            InventoryItem inventoryItem = itemContainer.containingItem;
            if (isoGridSquare == null && inventoryItem != null && inventoryItem.getWorldItem() != null) {
                isoGridSquare = inventoryItem.getWorldItem().getSquare();
            }
        }
        if (isoGridSquare == null && this.getWorldItem() != null && this.getWorldItem().getWorldObjectIndex() != -1) {
            isoGridSquare = this.getWorldItem().square;
        }
        return isoGridSquare;
    }

    @Override
    public boolean shouldUpdateInWorld() {
        return this.alarmSet;
    }

    @Override
    public void update() {
        if (this.alarmSet) {
            int n = GameTime.instance.getMinutes() / 10 * 10;
            if (!this.isRinging() && this.forceDontRing != n && this.alarmHour == GameTime.instance.getHour() && this.alarmMinutes == n) {
                this.ringSince = GameTime.getInstance().getWorldAgeHours();
            }
            if (this.isRinging()) {
                IsoGridSquare isoGridSquare;
                double d = GameTime.getInstance().getWorldAgeHours();
                if (this.ringSince > d) {
                    this.ringSince = d;
                }
                if ((isoGridSquare = this.getAlarmSquare()) == null || this.ringSince + 0.5 < d) {
                    this.stopRinging();
                } else if (!GameClient.bClient && isoGridSquare != null) {
                    WorldSoundManager.instance.addSoundRepeating(null, isoGridSquare.getX(), isoGridSquare.getY(), isoGridSquare.getZ(), this.getSoundRadius(), 3, false);
                }
                if (!GameServer.bServer && this.isRinging()) {
                    ItemSoundManager.addItem(this);
                }
            }
            if (this.forceDontRing != n) {
                this.forceDontRing = -1;
            }
        }
    }

    @Override
    public void updateSound(BaseSoundEmitter baseSoundEmitter) {
        assert (!GameServer.bServer);
        IsoGridSquare isoGridSquare = this.getAlarmSquare();
        if (isoGridSquare == null) {
            return;
        }
        baseSoundEmitter.setPos((float)isoGridSquare.x + 0.5f, (float)isoGridSquare.y + 0.5f, isoGridSquare.z);
        if (!baseSoundEmitter.isPlaying(this.ringSound)) {
            if (this.alarmSound == null || "".equals(this.alarmSound)) {
                this.alarmSound = "AlarmClockLoop";
            }
            this.ringSound = baseSoundEmitter.playSoundImpl(this.alarmSound, isoGridSquare);
        }
        if (GameClient.bClient && sendEvery.Check() && this.isInLocalPlayerInventory()) {
            GameClient.instance.sendWorldSound(null, isoGridSquare.x, isoGridSquare.y, isoGridSquare.z, this.getSoundRadius(), 3, false, 0.0f, 1.0f);
        }
        this.wakeUpPlayers(isoGridSquare);
    }

    private void wakeUpPlayers(IsoGridSquare isoGridSquare) {
        if (GameServer.bServer) {
            return;
        }
        int n = this.getSoundRadius();
        int n2 = Math.max(isoGridSquare.getZ() - 3, 0);
        int n3 = Math.min(isoGridSquare.getZ() + 3, 8);
        for (int i = 0; i < IsoPlayer.numPlayers; ++i) {
            IsoPlayer isoPlayer = IsoPlayer.players[i];
            if (isoPlayer == null || isoPlayer.isDead() || isoPlayer.getCurrentSquare() == null || isoPlayer.Traits.Deaf.isSet()) continue;
            IsoGridSquare isoGridSquare2 = isoPlayer.getCurrentSquare();
            if (isoGridSquare2.z < n2 || isoGridSquare2.z >= n3) continue;
            float f = IsoUtils.DistanceToSquared(isoGridSquare.x, isoGridSquare.y, isoGridSquare2.x, isoGridSquare2.y);
            if (isoPlayer.Traits.HardOfHearing.isSet()) {
                f *= 4.5f;
            }
            if (f > (float)(n * n)) continue;
            this.wakeUp(isoPlayer);
        }
    }

    private void wakeUp(IsoPlayer isoPlayer) {
        if (isoPlayer.Asleep) {
            SoundManager.instance.setMusicWakeState(isoPlayer, "WakeNormal");
            SleepingEvent.instance.wakeUp(isoPlayer);
        }
    }

    public boolean isRinging() {
        return this.ringSince >= 0.0;
    }

    @Override
    public boolean finishupdate() {
        return !this.alarmSet;
    }

    @Override
    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
        ObjectTooltip.LayoutItem layoutItem = layout.addItem();
        layoutItem.setLabel(Translator.getText("IGUI_CurrentTime"), 1.0f, 1.0f, 0.8f, 1.0f);
        int n = GameTime.instance.getMinutes() / 10 * 10;
        layoutItem.setValue(GameTime.getInstance().getHour() + ":" + (Serializable)(n == 0 ? "00" : Integer.valueOf(n)), 1.0f, 1.0f, 0.8f, 1.0f);
        if (this.alarmSet) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("IGUI_AlarmIsSetFor"), 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(this.alarmHour + ":" + (Serializable)(this.alarmMinutes == 0 ? "00" : Integer.valueOf(this.alarmMinutes)), 1.0f, 1.0f, 0.8f, 1.0f);
        }
    }

    @Override
    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        super.save(byteBuffer, bl);
        byteBuffer.putInt(this.alarmHour);
        byteBuffer.putInt(this.alarmMinutes);
        byteBuffer.put(this.alarmSet ? (byte)1 : 0);
        byteBuffer.putFloat((float)this.ringSince);
    }

    @Override
    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        super.load(byteBuffer, n);
        this.alarmHour = byteBuffer.getInt();
        this.alarmMinutes = byteBuffer.getInt();
        this.alarmSet = byteBuffer.get() == 1;
        this.ringSince = byteBuffer.getFloat();
        this.ringSound = -1L;
    }

    @Override
    public int getSaveType() {
        return Item.Type.AlarmClock.ordinal();
    }

    @Override
    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "AlarmClock";
    }

    public void setAlarmSet(boolean bl) {
        this.stopRinging();
        this.alarmSet = bl;
        this.ringSound = -1L;
        if (bl) {
            IsoCell isoCell;
            IsoWorld.instance.CurrentCell.addToProcessItems(this);
            IsoWorldInventoryObject isoWorldInventoryObject = this.getWorldItem();
            if (isoWorldInventoryObject != null && isoWorldInventoryObject.getSquare() != null && !(isoCell = IsoWorld.instance.getCell()).getProcessWorldItems().contains(isoWorldInventoryObject)) {
                isoCell.getProcessWorldItems().add(isoWorldInventoryObject);
            }
        } else {
            IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
        }
    }

    public boolean isAlarmSet() {
        return this.alarmSet;
    }

    public void setHour(int n) {
        this.alarmHour = n;
        this.forceDontRing = -1;
    }

    public void setMinute(int n) {
        this.alarmMinutes = n;
        this.forceDontRing = -1;
    }

    public int getHour() {
        return this.alarmHour;
    }

    public int getMinute() {
        return this.alarmMinutes;
    }

    public void syncAlarmClock() {
        IsoPlayer isoPlayer = this.getOwnerPlayer(this.container);
        if (isoPlayer != null) {
            this.syncAlarmClock_Player(isoPlayer);
        }
        if (this.worldItem != null) {
            this.syncAlarmClock_World();
        }
    }

    private IsoPlayer getOwnerPlayer(ItemContainer itemContainer) {
        if (itemContainer == null) {
            return null;
        }
        IsoObject isoObject = itemContainer.getParent();
        if (isoObject instanceof IsoPlayer) {
            return (IsoPlayer)isoObject;
        }
        return null;
    }

    public void syncAlarmClock_Player(IsoPlayer isoPlayer) {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncAlarmClock.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(PacketPlayer);
            byteBufferWriter.putShort((short)isoPlayer.getPlayerNum());
            byteBufferWriter.putInt(this.id);
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putInt(this.alarmHour);
            byteBufferWriter.putInt(this.alarmMinutes);
            byteBufferWriter.putByte(this.alarmSet ? (byte)1 : 0);
            PacketTypes.PacketType.SyncAlarmClock.send(GameClient.connection);
        }
    }

    public void syncAlarmClock_World() {
        if (GameClient.bClient) {
            ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
            PacketTypes.PacketType.SyncAlarmClock.doPacket(byteBufferWriter);
            byteBufferWriter.putShort(PacketWorld);
            byteBufferWriter.putInt(this.worldItem.square.getX());
            byteBufferWriter.putInt(this.worldItem.square.getY());
            byteBufferWriter.putInt(this.worldItem.square.getZ());
            byteBufferWriter.putInt(this.id);
            byteBufferWriter.putByte((byte)0);
            byteBufferWriter.putInt(this.alarmHour);
            byteBufferWriter.putInt(this.alarmMinutes);
            byteBufferWriter.putByte(this.alarmSet ? (byte)1 : 0);
            PacketTypes.PacketType.SyncAlarmClock.send(GameClient.connection);
        }
    }

    public void syncStopRinging() {
        if (!GameClient.bClient) {
            return;
        }
        ByteBufferWriter byteBufferWriter = GameClient.connection.startPacket();
        PacketTypes.PacketType.SyncAlarmClock.doPacket(byteBufferWriter);
        IsoPlayer isoPlayer = this.getOwnerPlayer(this.container);
        if (isoPlayer != null) {
            byteBufferWriter.putShort(PacketPlayer);
            byteBufferWriter.putShort((short)isoPlayer.getPlayerNum());
        } else if (this.getWorldItem() != null) {
            byteBufferWriter.putShort(PacketWorld);
            byteBufferWriter.putInt(this.worldItem.square.getX());
            byteBufferWriter.putInt(this.worldItem.square.getY());
            byteBufferWriter.putInt(this.worldItem.square.getZ());
        } else assert (false);
        byteBufferWriter.putInt(this.id);
        byteBufferWriter.putByte((byte)1);
        PacketTypes.PacketType.SyncAlarmClock.send(GameClient.connection);
    }

    public void stopRinging() {
        if (this.ringSound != -1L) {
            this.ringSound = -1L;
        }
        ItemSoundManager.removeItem(this);
        this.ringSince = -1.0;
        this.forceDontRing = GameTime.instance.getMinutes() / 10 * 10;
    }

    public String getAlarmSound() {
        return this.alarmSound;
    }

    public void setAlarmSound(String string) {
        this.alarmSound = string;
    }

    public int getSoundRadius() {
        return this.soundRadius;
    }

    public void setSoundRadius(int n) {
        this.soundRadius = n;
    }

    public boolean isDigital() {
        return this.isDigital;
    }
}

