/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.characters.IsoGameCharacter;
import zombie.characters.skills.PerkFactory;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemUser;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Drainable;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.Moveable;
import zombie.iso.IsoGridSquare;
import zombie.network.GameClient;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.EvolvedRecipe;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.MovableRecipe;
import zombie.scripting.objects.Recipe;
import zombie.scripting.objects.ScriptModule;
import zombie.util.StringUtils;
import zombie.util.Type;

public final class RecipeManager {
    private static final ArrayList<Recipe> RecipeList = new ArrayList();

    public static void Loaded() {
        ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < arrayList.size(); ++i) {
            Recipe recipe = arrayList.get(i);
            for (int j = 0; j < recipe.getSource().size(); ++j) {
                Recipe.Source source = recipe.getSource().get(j);
                for (int k = 0; k < source.getItems().size(); ++k) {
                    String string = source.getItems().get(k);
                    if ("Water".equals(string) || string.contains(".") || string.startsWith("[")) continue;
                    Item item = RecipeManager.resolveItemModuleDotType(recipe, string, hashSet, "recipe source");
                    if (item == null) {
                        source.getItems().set(k, "???." + string);
                        continue;
                    }
                    source.getItems().set(k, item.getFullName());
                }
            }
            if (recipe.getResult() == null || recipe.getResult().getModule() != null) continue;
            Item item = RecipeManager.resolveItemModuleDotType(recipe, recipe.getResult().getType(), hashSet, "recipe result");
            recipe.getResult().module = item == null ? "???" : item.getModule().getName();
        }
    }

    private static Item resolveItemModuleDotType(Recipe recipe, String string, Set<String> set, String string2) {
        ScriptModule scriptModule = recipe.getModule();
        Item item = scriptModule.getItem(string);
        if (item != null && !item.getObsolete()) {
            return item;
        }
        for (int i = 0; i < ScriptManager.instance.ModuleList.size(); ++i) {
            ScriptModule scriptModule2 = ScriptManager.instance.ModuleList.get(i);
            item = scriptModule2.getItem(string);
            if (item == null || item.getObsolete()) continue;
            String string3 = recipe.getModule().getName();
            if (!set.contains(string3)) {
                set.add(string3);
                DebugLog.Recipe.warn("WARNING: module \"%s\" may have forgot to import module Base", string3);
            }
            return item;
        }
        DebugLog.Recipe.warn("ERROR: can't find %s \"%s\" in recipe \"%s\"", string2, string, recipe.getOriginalname());
        return null;
    }

    public static void LoadedAfterLua() {
        ArrayList<Item> arrayList = new ArrayList<Item>();
        ArrayList<Recipe> arrayList2 = ScriptManager.instance.getAllRecipes();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Recipe recipe = arrayList2.get(i);
            RecipeManager.LoadedAfterLua(recipe, arrayList);
        }
        arrayList.clear();
    }

    private static void LoadedAfterLua(Recipe recipe, ArrayList<Item> arrayList) {
        RecipeManager.LoadedAfterLua(recipe, recipe.LuaCreate, "LuaCreate");
        RecipeManager.LoadedAfterLua(recipe, recipe.LuaGiveXP, "LuaGiveXP");
        RecipeManager.LoadedAfterLua(recipe, recipe.LuaTest, "LuaTest");
        for (int i = 0; i < recipe.getSource().size(); ++i) {
            Recipe.Source source = recipe.getSource().get(i);
            RecipeManager.LoadedAfterLua(source, arrayList);
        }
    }

    private static void LoadedAfterLua(Recipe recipe, String string, String string2) {
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        Object object = LuaManager.getFunctionObject(string);
        if (object == null) {
            DebugLog.General.error("no such function %s = \"%s\" in recipe \"%s\"", string2, string, recipe.name);
        }
    }

    private static void LoadedAfterLua(Recipe.Source source, ArrayList<Item> arrayList) {
        for (int i = source.getItems().size() - 1; i >= 0; --i) {
            String string = source.getItems().get(i);
            if (!string.startsWith("[")) continue;
            source.getItems().remove(i);
            String string2 = string.substring(1, string.indexOf("]"));
            Object object = LuaManager.getFunctionObject(string2);
            if (object == null) continue;
            arrayList.clear();
            LuaManager.caller.protectedCallVoid(LuaManager.thread, object, arrayList);
            for (int j = 0; j < arrayList.size(); ++j) {
                Item item = arrayList.get(j);
                source.getItems().add(i + j, item.getFullName());
            }
        }
    }

    public static boolean DoesWipeUseDelta(String string, String string2) {
        return true;
    }

    public static int getKnownRecipesNumber(IsoGameCharacter isoGameCharacter) {
        int n = 0;
        ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Recipe recipe = arrayList.get(i);
            if (!isoGameCharacter.isRecipeKnown(recipe)) continue;
            ++n;
        }
        return n;
    }

    public static boolean DoesUseItemUp(String string, Recipe recipe) {
        assert ("Water".equals(string) || string.contains("."));
        for (int i = 0; i < recipe.Source.size(); ++i) {
            if (!recipe.Source.get((int)i).keep) continue;
            ArrayList<String> arrayList = recipe.Source.get(i).getItems();
            for (int j = 0; j < arrayList.size(); ++j) {
                if (!string.equals(arrayList.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean IsItemDestroyed(String string, Recipe recipe) {
        assert ("Water".equals(string) || string.contains("."));
        for (int i = 0; i < recipe.Source.size(); ++i) {
            Recipe.Source source = recipe.getSource().get(i);
            if (!source.destroy) continue;
            for (int j = 0; j < source.getItems().size(); ++j) {
                if (!string.equals(source.getItems().get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public static float UseAmount(String string, Recipe recipe, IsoGameCharacter isoGameCharacter) {
        Recipe.Source source = recipe.findSource(string);
        return source.getCount();
    }

    public static ArrayList<Recipe> getUniqueRecipeItems(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList) {
        RecipeList.clear();
        ArrayList<Recipe> arrayList2 = ScriptManager.instance.getAllRecipes();
        for (int i = 0; i < arrayList2.size(); ++i) {
            Recipe recipe = arrayList2.get(i);
            if (!RecipeManager.IsRecipeValid(recipe, isoGameCharacter, inventoryItem, arrayList) || inventoryItem instanceof Clothing && inventoryItem.getCondition() <= 0 && recipe.getOriginalname().equalsIgnoreCase("rip clothing")) continue;
            RecipeList.add(recipe);
        }
        if (inventoryItem instanceof Moveable && RecipeList.size() == 0 && ((Moveable)inventoryItem).getWorldSprite() != null) {
            if (inventoryItem.type != null && inventoryItem.type.equalsIgnoreCase(((Moveable)inventoryItem).getWorldSprite())) {
                MovableRecipe movableRecipe = new MovableRecipe();
                LuaEventManager.triggerEvent("OnDynamicMovableRecipe", ((Moveable)inventoryItem).getWorldSprite(), movableRecipe, inventoryItem, isoGameCharacter);
                if (movableRecipe.isValid() && RecipeManager.IsRecipeValid(movableRecipe, isoGameCharacter, inventoryItem, arrayList)) {
                    RecipeList.add(movableRecipe);
                }
            } else {
                DebugLog.log("RecipeManager -> Cannot create recipe for this movable item: " + inventoryItem.getFullType());
            }
        }
        return RecipeList;
    }

    public static boolean IsRecipeValid(Recipe recipe, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ArrayList<ItemContainer> arrayList) {
        if (recipe.Result == null) {
            return false;
        }
        if (!isoGameCharacter.isRecipeKnown(recipe)) {
            return false;
        }
        if (inventoryItem != null && !RecipeManager.RecipeContainsItem(recipe, inventoryItem)) {
            return false;
        }
        if (!RecipeManager.HasAllRequiredItems(recipe, isoGameCharacter, inventoryItem, arrayList)) {
            return false;
        }
        if (!RecipeManager.isAllItemsUsableRotten(recipe, isoGameCharacter, inventoryItem, arrayList)) {
            return false;
        }
        if (!RecipeManager.HasRequiredSkill(recipe, isoGameCharacter)) {
            return false;
        }
        if (!RecipeManager.isNearItem(recipe, isoGameCharacter)) {
            return false;
        }
        if (!RecipeManager.hasHeat(recipe, inventoryItem, arrayList, isoGameCharacter)) {
            return false;
        }
        return RecipeManager.CanPerform(recipe, isoGameCharacter, inventoryItem);
    }

    private static boolean isNearItem(Recipe recipe, IsoGameCharacter isoGameCharacter) {
        if (recipe.getNearItem() == null || recipe.getNearItem().equals("")) {
            return true;
        }
        for (int i = isoGameCharacter.getSquare().getX() - 2; i < isoGameCharacter.getSquare().getX() + 2; ++i) {
            for (int j = isoGameCharacter.getSquare().getY() - 2; j < isoGameCharacter.getSquare().getY() + 2; ++j) {
                IsoGridSquare isoGridSquare = isoGameCharacter.getCell().getGridSquare(i, j, isoGameCharacter.getSquare().getZ());
                if (isoGridSquare == null) continue;
                for (int k = 0; k < isoGridSquare.getObjects().size(); ++k) {
                    if (!recipe.getNearItem().equals(isoGridSquare.getObjects().get(k).getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean CanPerform(Recipe recipe, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        if (StringUtils.isNullOrWhitespace(recipe.getCanPerform())) {
            return true;
        }
        Object object = LuaManager.getFunctionObject(recipe.getCanPerform());
        if (object == null) {
            return false;
        }
        Boolean bl = LuaManager.caller.protectedCallBoolean(LuaManager.thread, object, recipe, isoGameCharacter, inventoryItem);
        return bl == Boolean.TRUE;
    }

    private static boolean HasRequiredSkill(Recipe recipe, IsoGameCharacter isoGameCharacter) {
        if (recipe.getRequiredSkillCount() == 0) {
            return true;
        }
        for (int i = 0; i < recipe.getRequiredSkillCount(); ++i) {
            Recipe.RequiredSkill requiredSkill = recipe.getRequiredSkill(i);
            if (isoGameCharacter.getPerkLevel(requiredSkill.getPerk()) >= requiredSkill.getLevel()) continue;
            return false;
        }
        return true;
    }

    private static boolean RecipeContainsItem(Recipe recipe, InventoryItem inventoryItem) {
        for (int i = 0; i < recipe.Source.size(); ++i) {
            Recipe.Source source = recipe.getSource().get(i);
            for (int j = 0; j < source.getItems().size(); ++j) {
                String string = source.getItems().get(j);
                if ("Water".equals(string) && inventoryItem.isWaterSource()) {
                    return true;
                }
                if (!string.equals(inventoryItem.getFullType())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean HasAllRequiredItems(Recipe recipe, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ArrayList<ItemContainer> arrayList) {
        ArrayList<InventoryItem> arrayList2 = RecipeManager.getAvailableItemsNeeded(recipe, isoGameCharacter, arrayList, inventoryItem, null);
        return !arrayList2.isEmpty();
    }

    public static boolean isAllItemsUsableRotten(Recipe recipe, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ArrayList<ItemContainer> arrayList) {
        if (isoGameCharacter.getPerkLevel(PerkFactory.Perks.Cooking) >= 7) {
            return true;
        }
        if (recipe.isAllowRottenItem()) {
            return true;
        }
        ArrayList<InventoryItem> arrayList2 = RecipeManager.getAvailableItemsNeeded(recipe, isoGameCharacter, arrayList, inventoryItem, null);
        for (InventoryItem inventoryItem2 : arrayList2) {
            if (!(inventoryItem2 instanceof Food) || !((Food)inventoryItem2).isRotten()) continue;
            return false;
        }
        return true;
    }

    public static boolean hasHeat(Recipe recipe, InventoryItem inventoryItem, ArrayList<ItemContainer> arrayList, IsoGameCharacter isoGameCharacter) {
        if (recipe.getHeat() != 0.0f) {
            InventoryItem inventoryItem2 = null;
            for (InventoryItem object : RecipeManager.getAvailableItemsNeeded(recipe, isoGameCharacter, arrayList, inventoryItem, null)) {
                if (!(object instanceof DrainableComboItem)) continue;
                inventoryItem2 = object;
                break;
            }
            if (inventoryItem2 != null) {
                for (ItemContainer itemContainer : arrayList) {
                    for (InventoryItem inventoryItem3 : itemContainer.getItems()) {
                        if (!inventoryItem3.getName().equals(inventoryItem2.getName()) || !(recipe.getHeat() < 0.0f ? inventoryItem3.getInvHeat() <= recipe.getHeat() : recipe.getHeat() > 0.0f && inventoryItem3.getInvHeat() + 1.0f >= recipe.getHeat())) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static ArrayList<InventoryItem> getAvailableItemsAll(Recipe recipe, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList2) {
        return RecipeManager.getAvailableItems((Recipe)recipe, (IsoGameCharacter)isoGameCharacter, arrayList, (InventoryItem)inventoryItem, arrayList2, (boolean)true).allItems;
    }

    public static ArrayList<InventoryItem> getAvailableItemsNeeded(Recipe recipe, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList2) {
        return RecipeManager.getAvailableItems((Recipe)recipe, (IsoGameCharacter)isoGameCharacter, arrayList, (InventoryItem)inventoryItem, arrayList2, (boolean)false).allItems;
    }

    private static SourceItems getAvailableItems(Recipe recipe, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList2, boolean bl) {
        if (!(inventoryItem == null || inventoryItem.getContainer() != null && inventoryItem.getContainer().contains(inventoryItem))) {
            DebugLog.Recipe.warn("recipe: item appears to have been used already, ignoring " + inventoryItem.getFullType());
            inventoryItem = null;
        }
        SourceItems sourceItems = new SourceItems(recipe, isoGameCharacter, inventoryItem, arrayList2);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(isoGameCharacter.getInventory());
        }
        if (inventoryItem != null && !RecipeManager.RecipeContainsItem(recipe, inventoryItem)) {
            throw new RuntimeException("item " + inventoryItem.getFullType() + " isn't used in recipe " + recipe.getOriginalname());
        }
        RMRecipe rMRecipe = RMRecipe.alloc(recipe);
        rMRecipe.getItemsFromContainers(isoGameCharacter, arrayList, inventoryItem);
        if (bl || rMRecipe.hasItems()) {
            rMRecipe.getAvailableItems(sourceItems, bl);
        }
        RMRecipe.release(rMRecipe);
        return sourceItems;
    }

    public static ArrayList<InventoryItem> getSourceItemsAll(Recipe recipe, int n, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList2) {
        if (n < 0 || n >= recipe.getSource().size()) {
            return null;
        }
        SourceItems sourceItems = RecipeManager.getAvailableItems(recipe, isoGameCharacter, arrayList, inventoryItem, arrayList2, true);
        return sourceItems.itemsPerSource[n];
    }

    public static ArrayList<InventoryItem> getSourceItemsNeeded(Recipe recipe, int n, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList2) {
        if (n < 0 || n >= recipe.getSource().size()) {
            return null;
        }
        SourceItems sourceItems = RecipeManager.getAvailableItems(recipe, isoGameCharacter, arrayList, inventoryItem, arrayList2, false);
        return sourceItems.itemsPerSource[n];
    }

    public static int getNumberOfTimesRecipeCanBeDone(Recipe recipe, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem) {
        int n = 0;
        RMRecipe rMRecipe = RMRecipe.alloc(recipe);
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.add(isoGameCharacter.getInventory());
        }
        rMRecipe.getItemsFromContainers(isoGameCharacter, arrayList, inventoryItem);
        ArrayList<InventoryItem> arrayList2 = new ArrayList<InventoryItem>();
        ArrayList<InventoryItem> arrayList3 = new ArrayList<InventoryItem>();
        while (rMRecipe.hasItems()) {
            arrayList3.clear();
            rMRecipe.Use(arrayList3);
            if (arrayList2.containsAll(arrayList3)) {
                n = -1;
                break;
            }
            arrayList2.addAll(arrayList3);
            for (int i = 0; i < arrayList3.size(); ++i) {
                InventoryItem inventoryItem2 = arrayList3.get(i);
                if (!(inventoryItem2 instanceof Food) || !((Food)inventoryItem2).isFrozen() || rMRecipe.recipe.isAllowFrozenItem()) continue;
                --n;
                break;
            }
            ++n;
        }
        RMRecipe.release(rMRecipe);
        return n;
    }

    public static InventoryItem GetMovableRecipeTool(boolean bl, Recipe recipe, InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList) {
        Recipe.Source source;
        if (!(recipe instanceof MovableRecipe)) {
            return null;
        }
        MovableRecipe movableRecipe = (MovableRecipe)recipe;
        Recipe.Source source2 = source = bl ? movableRecipe.getPrimaryTools() : movableRecipe.getSecondaryTools();
        if (source == null || source.getItems() == null || source.getItems().size() == 0) {
            return null;
        }
        SourceItems sourceItems = RecipeManager.getAvailableItems(recipe, isoGameCharacter, arrayList, inventoryItem, null, false);
        if (sourceItems.allItems == null || sourceItems.allItems.size() == 0) {
            return null;
        }
        for (int i = 0; i < sourceItems.allItems.size(); ++i) {
            InventoryItem inventoryItem2 = sourceItems.allItems.get(i);
            for (int j = 0; j < source.getItems().size(); ++j) {
                if (!inventoryItem2.getFullType().equalsIgnoreCase(source.getItems().get(j))) continue;
                return inventoryItem2;
            }
        }
        return null;
    }

    public static InventoryItem PerformMakeItem(Recipe recipe, InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList) {
        Object object;
        Object object2;
        int n;
        boolean bl = isoGameCharacter.getPrimaryHandItem() == inventoryItem;
        boolean bl2 = isoGameCharacter.getSecondaryHandItem() == inventoryItem;
        SourceItems sourceItems = RecipeManager.getAvailableItems(recipe, isoGameCharacter, arrayList, inventoryItem, null, false);
        ArrayList<InventoryItem> arrayList2 = sourceItems.allItems;
        if (arrayList2.isEmpty()) {
            throw new RuntimeException("getAvailableItems() didn't return the required number of items");
        }
        isoGameCharacter.removeFromHands(inventoryItem);
        Recipe.Result result = recipe.getResult();
        InventoryItem inventoryItem2 = InventoryItemFactory.CreateItem(result.getFullType());
        boolean bl3 = false;
        boolean bl4 = false;
        int n2 = -1;
        int n3 = 0;
        boolean bl5 = false;
        boolean bl6 = false;
        float f = 0.0f;
        float f2 = 0.0f;
        int n4 = 0;
        int n5 = 0;
        block7: for (n = 0; n < recipe.getSource().size(); ++n) {
            object2 = recipe.getSource().get(n);
            if (((Recipe.Source)object2).isKeep()) continue;
            ArrayList<InventoryItem> arrayList3 = sourceItems.itemsPerSource[n];
            switch (sourceItems.typePerSource[n]) {
                case DRAINABLE: {
                    int n6;
                    int n7 = (int)((Recipe.Source)object2).getCount();
                    for (n6 = 0; n6 < arrayList3.size(); ++n6) {
                        InventoryItem inventoryItem3 = arrayList3.get(n6);
                        int n8 = RecipeManager.AvailableUses(inventoryItem3);
                        if (n8 >= n7) {
                            RecipeManager.ReduceUses(inventoryItem3, n7, isoGameCharacter);
                            n7 = 0;
                            continue;
                        }
                        RecipeManager.ReduceUses(inventoryItem3, n8, isoGameCharacter);
                        n7 -= n8;
                    }
                    if (n7 <= 0) continue block7;
                    throw new RuntimeException("required amount of " + ((Recipe.Source)object2).getItems() + " wasn't available");
                }
                case FOOD: {
                    int n9;
                    int n6 = (int)((Recipe.Source)object2).use;
                    for (n9 = 0; n9 < arrayList3.size(); ++n9) {
                        InventoryItem inventoryItem4 = arrayList3.get(n9);
                        int n10 = RecipeManager.AvailableUses(inventoryItem4);
                        if (n10 >= n6) {
                            RecipeManager.ReduceUses(inventoryItem4, n6, isoGameCharacter);
                            n6 = 0;
                            continue;
                        }
                        RecipeManager.ReduceUses(inventoryItem4, n10, isoGameCharacter);
                        n6 -= n10;
                    }
                    continue block7;
                }
                case DESTROY: {
                    int n9;
                    for (n9 = 0; n9 < arrayList3.size(); ++n9) {
                        InventoryItem inventoryItem5 = arrayList3.get(n9);
                        ItemUser.RemoveItem(inventoryItem5);
                    }
                    continue block7;
                }
                case OTHER: {
                    int n9;
                    for (n9 = 0; n9 < arrayList3.size(); ++n9) {
                        InventoryItem inventoryItem6 = arrayList3.get(n9);
                        ItemUser.UseItem(inventoryItem6, true, false);
                    }
                    continue block7;
                }
                case WATER: {
                    int n9 = recipe.getWaterAmountNeeded();
                    for (int i = 0; i < arrayList3.size(); ++i) {
                        InventoryItem inventoryItem7 = arrayList3.get(i);
                        int n11 = RecipeManager.AvailableUses(inventoryItem7);
                        if (n11 >= n9) {
                            RecipeManager.ReduceUses(inventoryItem7, n9, isoGameCharacter);
                            n9 = 0;
                            continue;
                        }
                        RecipeManager.ReduceUses(inventoryItem7, n11, isoGameCharacter);
                        n9 -= n11;
                    }
                    if (n9 <= 0) continue block7;
                    throw new RuntimeException("required amount of water wasn't available");
                }
            }
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            object2 = arrayList2.get(n);
            if (object2 instanceof Food) {
                if (((Food)object2).isCooked()) {
                    bl3 = true;
                }
                if (((Food)object2).isBurnt()) {
                    bl4 = true;
                }
                n2 = ((Food)object2).getPoisonDetectionLevel();
                n3 = ((Food)object2).getPoisonPower();
                ++n5;
                if (((InventoryItem)object2).getAge() > (float)((InventoryItem)object2).getOffAgeMax()) {
                    bl5 = true;
                } else if (!bl5 && ((InventoryItem)object2).getOffAgeMax() < 1000000000) {
                    if (((InventoryItem)object2).getAge() < (float)((InventoryItem)object2).getOffAge()) {
                        f2 += 0.5f * ((InventoryItem)object2).getAge() / (float)((InventoryItem)object2).getOffAge();
                    } else {
                        bl6 = true;
                        f2 += 0.5f + 0.5f * (((InventoryItem)object2).getAge() - (float)((InventoryItem)object2).getOffAge()) / (float)(((InventoryItem)object2).getOffAgeMax() - ((InventoryItem)object2).getOffAge());
                    }
                }
            }
            if (inventoryItem2 instanceof Food && ((InventoryItem)object2).isTaintedWater()) {
                inventoryItem2.setTaintedWater(true);
            }
            if (inventoryItem2.getScriptItem() == ((InventoryItem)object2).getScriptItem() && ((InventoryItem)object2).isFavorite()) {
                inventoryItem2.setFavorite(true);
            }
            f += (float)((InventoryItem)object2).getCondition() / (float)((InventoryItem)object2).getConditionMax();
            ++n4;
        }
        f2 /= (float)n5;
        if (inventoryItem2 instanceof Food && ((Food)inventoryItem2).IsCookable) {
            ((Food)inventoryItem2).setCooked(bl3);
            ((Food)inventoryItem2).setBurnt(bl4);
            ((Food)inventoryItem2).setPoisonDetectionLevel(n2);
            ((Food)inventoryItem2).setPoisonPower(n3);
        }
        if ((double)inventoryItem2.getOffAgeMax() != 1.0E9) {
            if (bl5) {
                inventoryItem2.setAge(inventoryItem2.getOffAgeMax());
            } else {
                if (bl6 && f2 < 0.5f) {
                    f2 = 0.5f;
                }
                if (f2 < 0.5f) {
                    inventoryItem2.setAge(2.0f * f2 * (float)inventoryItem2.getOffAge());
                } else {
                    inventoryItem2.setAge((float)inventoryItem2.getOffAge() + 2.0f * (f2 - 0.5f) * (float)(inventoryItem2.getOffAgeMax() - inventoryItem2.getOffAge()));
                }
            }
        }
        inventoryItem2.setCondition(Math.round((float)inventoryItem2.getConditionMax() * (f / (float)n4)));
        for (n = 0; n < arrayList2.size(); ++n) {
            object2 = arrayList2.get(n);
            inventoryItem2.setConditionFromModData((InventoryItem)object2);
        }
        RecipeManager.GivePlayerExperience(recipe, arrayList2, inventoryItem2, isoGameCharacter);
        if (recipe.LuaCreate != null && (object = LuaManager.getFunctionObject(recipe.LuaCreate)) != null) {
            LuaManager.caller.protectedCall(LuaManager.thread, object, arrayList2, inventoryItem2, isoGameCharacter, inventoryItem, bl, bl2);
        }
        if (!recipe.isRemoveResultItem()) {
            return inventoryItem2;
        }
        return null;
    }

    private static boolean ReduceUses(InventoryItem inventoryItem, float f, IsoGameCharacter isoGameCharacter) {
        float f2;
        InventoryItem inventoryItem2;
        if (inventoryItem instanceof DrainableComboItem) {
            inventoryItem2 = (DrainableComboItem)inventoryItem;
            f2 = ((DrainableComboItem)inventoryItem2).getUseDelta() * f;
            ((DrainableComboItem)inventoryItem2).setUsedDelta(((DrainableComboItem)inventoryItem2).getUsedDelta() - f2);
            if (RecipeManager.AvailableUses(inventoryItem) < 1) {
                ((DrainableComboItem)inventoryItem2).setUsedDelta(0.0f);
                ItemUser.UseItem(inventoryItem2);
                return true;
            }
            if (GameClient.bClient && !inventoryItem.isInPlayerInventory()) {
                GameClient.instance.sendItemStats(inventoryItem);
            }
        }
        if (inventoryItem instanceof Food && ((Food)(inventoryItem2 = (Food)inventoryItem)).getHungerChange() < 0.0f) {
            f2 = Math.min(-((Food)inventoryItem2).getHungerChange() * 100.0f, f);
            float f3 = f2 / (-((Food)inventoryItem2).getHungerChange() * 100.0f);
            if (f3 < 0.0f) {
                f3 = 0.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            ((Food)inventoryItem2).setHungChange(((Food)inventoryItem2).getHungChange() - ((Food)inventoryItem2).getHungChange() * f3);
            ((Food)inventoryItem2).setCalories(((Food)inventoryItem2).getCalories() - ((Food)inventoryItem2).getCalories() * f3);
            ((Food)inventoryItem2).setCarbohydrates(((Food)inventoryItem2).getCarbohydrates() - ((Food)inventoryItem2).getCarbohydrates() * f3);
            ((Food)inventoryItem2).setLipids(((Food)inventoryItem2).getLipids() - ((Food)inventoryItem2).getLipids() * f3);
            ((Food)inventoryItem2).setProteins(((Food)inventoryItem2).getProteins() - ((Food)inventoryItem2).getProteins() * f3);
            ((Food)inventoryItem2).setThirstChange(((Food)inventoryItem2).getThirstChangeUnmodified() - ((Food)inventoryItem2).getThirstChangeUnmodified() * f3);
            ((Food)inventoryItem2).setFluReduction(((Food)inventoryItem2).getFluReduction() - (int)((float)((Food)inventoryItem2).getFluReduction() * f3));
            ((Food)inventoryItem2).setPainReduction(((Food)inventoryItem2).getPainReduction() - ((Food)inventoryItem2).getPainReduction() * f3);
            ((Food)inventoryItem2).setEndChange(((Food)inventoryItem2).getEnduranceChangeUnmodified() - ((Food)inventoryItem2).getEnduranceChangeUnmodified() * f3);
            ((Food)inventoryItem2).setReduceFoodSickness(((Food)inventoryItem2).getReduceFoodSickness() - (int)((float)((Food)inventoryItem2).getReduceFoodSickness() * f3));
            inventoryItem2.setStressChange(((Food)inventoryItem2).getStressChangeUnmodified() - ((Food)inventoryItem2).getStressChangeUnmodified() * f3);
            inventoryItem2.setFatigueChange(inventoryItem2.getFatigueChange() - inventoryItem2.getFatigueChange() * f3);
            if ((double)((Food)inventoryItem2).getHungerChange() > -0.01) {
                ItemUser.UseItem(inventoryItem2);
                return true;
            }
            if (GameClient.bClient && !inventoryItem.isInPlayerInventory()) {
                GameClient.instance.sendItemStats(inventoryItem);
            }
        }
        return false;
    }

    private static int AvailableUses(InventoryItem inventoryItem) {
        if (inventoryItem instanceof DrainableComboItem) {
            DrainableComboItem drainableComboItem = (DrainableComboItem)inventoryItem;
            return drainableComboItem.getDrainableUsesInt();
        }
        if (inventoryItem instanceof Food) {
            Food food = (Food)inventoryItem;
            return (int)(-food.getHungerChange() * 100.0f);
        }
        return 0;
    }

    private static void GivePlayerExperience(Recipe recipe, ArrayList<InventoryItem> arrayList, InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter) {
        Object object;
        String string = recipe.LuaGiveXP;
        if (string == null) {
            string = "Recipe.OnGiveXP.Default";
        }
        if ((object = LuaManager.getFunctionObject(string)) == null) {
            DebugLog.Recipe.warn("ERROR: Lua method \"" + string + "\" not found (in RecipeManager.GivePlayerExperience())");
            return;
        }
        LuaManager.caller.protectedCall(LuaManager.thread, object, recipe, arrayList, inventoryItem, isoGameCharacter);
    }

    public static ArrayList<EvolvedRecipe> getAllEvolvedRecipes() {
        Stack<EvolvedRecipe> stack = ScriptManager.instance.getAllEvolvedRecipes();
        ArrayList<EvolvedRecipe> arrayList = new ArrayList<EvolvedRecipe>();
        for (int i = 0; i < stack.size(); ++i) {
            arrayList.add((EvolvedRecipe)stack.get(i));
        }
        return arrayList;
    }

    public static ArrayList<EvolvedRecipe> getEvolvedRecipe(InventoryItem inventoryItem, IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, boolean bl) {
        ArrayList<EvolvedRecipe> arrayList2 = new ArrayList<EvolvedRecipe>();
        if (inventoryItem instanceof Food && ((Food)inventoryItem).isRotten() && isoGameCharacter.getPerkLevel(PerkFactory.Perks.Cooking) < 7) {
            return arrayList2;
        }
        Stack<EvolvedRecipe> stack = ScriptManager.instance.getAllEvolvedRecipes();
        for (int i = 0; i < stack.size(); ++i) {
            EvolvedRecipe evolvedRecipe = (EvolvedRecipe)stack.get(i);
            if ((!inventoryItem.isCooked() || !evolvedRecipe.addIngredientIfCooked) && inventoryItem.isCooked() || !inventoryItem.getType().equals(evolvedRecipe.baseItem) && !inventoryItem.getType().equals(evolvedRecipe.getResultItem()) || inventoryItem.getType().equals("WaterPot") && (double)((Drainable)((Object)inventoryItem)).getUsedDelta() < 0.75) continue;
            if (bl) {
                ArrayList<InventoryItem> arrayList3 = evolvedRecipe.getItemsCanBeUse(isoGameCharacter, inventoryItem, arrayList);
                if (arrayList3.isEmpty()) continue;
                if (inventoryItem instanceof Food && ((Food)inventoryItem).isFrozen()) {
                    if (!evolvedRecipe.isAllowFrozenItem()) continue;
                    arrayList2.add(evolvedRecipe);
                    continue;
                }
                arrayList2.add(evolvedRecipe);
                continue;
            }
            arrayList2.add(evolvedRecipe);
        }
        return arrayList2;
    }

    private static void DebugPrintAllRecipes() {
        ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Recipe recipe = arrayList.get(i);
            if (recipe == null) {
                DebugLog.Recipe.println("Null recipe.");
                continue;
            }
            if (recipe.Result == null) {
                DebugLog.Recipe.println("Null result.");
                continue;
            }
            DebugLog.Recipe.println(recipe.Result.type);
            DebugLog.Recipe.println("-----");
            for (int j = 0; j < recipe.Source.size(); ++j) {
                if (recipe.Source.get(j) == null) {
                    DebugLog.Recipe.println("Null ingredient.");
                    continue;
                }
                if (!recipe.Source.get(j).getItems().isEmpty()) continue;
                DebugLog.Recipe.println(recipe.Source.get(j).getItems().toString());
            }
        }
    }

    public static Recipe getDismantleRecipeFor(String string) {
        RecipeList.clear();
        ArrayList<Recipe> arrayList = ScriptManager.instance.getAllRecipes();
        for (int i = 0; i < arrayList.size(); ++i) {
            Recipe recipe = arrayList.get(i);
            ArrayList<Recipe.Source> arrayList2 = recipe.getSource();
            if (arrayList2.size() <= 0) continue;
            for (int j = 0; j < arrayList2.size(); ++j) {
                Recipe.Source source = arrayList2.get(j);
                for (int k = 0; k < source.getItems().size(); ++k) {
                    if (!source.getItems().get(k).equalsIgnoreCase(string) || !recipe.name.toLowerCase().startsWith("dismantle ")) continue;
                    return recipe;
                }
            }
        }
        return null;
    }

    private static final class SourceItems {
        InventoryItem selectedItem;
        final ArrayList<InventoryItem> allItems = new ArrayList();
        final ArrayList<InventoryItem>[] itemsPerSource;
        final RMRecipeItemList.Type[] typePerSource;

        SourceItems(Recipe recipe, IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem, ArrayList<InventoryItem> arrayList) {
            this.itemsPerSource = new ArrayList[recipe.getSource().size()];
            for (int i = 0; i < this.itemsPerSource.length; ++i) {
                this.itemsPerSource[i] = new ArrayList();
            }
            this.typePerSource = new RMRecipeItemList.Type[recipe.getSource().size()];
            this.selectedItem = inventoryItem;
        }

        public ArrayList<InventoryItem> getItems() {
            return this.allItems;
        }
    }

    private static final class RMRecipe {
        Recipe recipe;
        final ArrayList<RMRecipeSource> sources = new ArrayList();
        final ArrayList<RMRecipeItem> allItems = new ArrayList();
        boolean usesWater;
        final HashSet<String> allSourceTypes = new HashSet();
        static ArrayDeque<RMRecipe> pool = new ArrayDeque();

        private RMRecipe() {
        }

        RMRecipe init(Recipe recipe) {
            assert (this.allItems.isEmpty());
            assert (this.sources.isEmpty());
            assert (this.allSourceTypes.isEmpty());
            this.recipe = recipe;
            this.usesWater = false;
            for (int i = 0; i < recipe.getSource().size(); ++i) {
                RMRecipeSource rMRecipeSource = RMRecipeSource.alloc(this, i);
                if (rMRecipeSource.usesWater) {
                    this.usesWater = true;
                }
                this.allSourceTypes.addAll(rMRecipeSource.source.getItems());
                this.sources.add(rMRecipeSource);
            }
            return this;
        }

        RMRecipe reset() {
            int n;
            this.recipe = null;
            for (n = 0; n < this.allItems.size(); ++n) {
                RMRecipeItem.release(this.allItems.get(n));
            }
            this.allItems.clear();
            for (n = 0; n < this.sources.size(); ++n) {
                RMRecipeSource.release(this.sources.get(n));
            }
            this.sources.clear();
            this.allSourceTypes.clear();
            return this;
        }

        void getItemsFromContainers(IsoGameCharacter isoGameCharacter, ArrayList<ItemContainer> arrayList, InventoryItem inventoryItem) {
            int n;
            for (n = 0; n < arrayList.size(); ++n) {
                this.getItemsFromContainer(isoGameCharacter, arrayList.get(n), inventoryItem);
            }
            if (!this.Test(inventoryItem)) {
                return;
            }
            for (n = 0; n < this.sources.size(); ++n) {
                RMRecipeSource rMRecipeSource = this.sources.get(n);
                rMRecipeSource.getItemsFrom(this.allItems, this);
            }
        }

        void getItemsFromContainer(IsoGameCharacter isoGameCharacter, ItemContainer itemContainer, InventoryItem inventoryItem) {
            for (int i = 0; i < itemContainer.getItems().size(); ++i) {
                InventoryItem inventoryItem2 = itemContainer.getItems().get(i);
                if ((inventoryItem == null || inventoryItem != inventoryItem2) && isoGameCharacter.isEquippedClothing(inventoryItem2) && !this.isKeep(inventoryItem2.getFullType()) || this.recipe.InSameInventory && !this.isKeep(inventoryItem2.getFullType()) && inventoryItem != null && itemContainer != inventoryItem.getContainer()) continue;
                if (this.usesWater && inventoryItem2 instanceof DrainableComboItem && inventoryItem2.isWaterSource()) {
                    this.allItems.add(RMRecipeItem.alloc(inventoryItem2));
                    continue;
                }
                if (!this.allSourceTypes.contains(inventoryItem2.getFullType())) continue;
                this.allItems.add(RMRecipeItem.alloc(inventoryItem2));
            }
        }

        boolean Test(InventoryItem inventoryItem) {
            if (inventoryItem == null || this.recipe.LuaTest == null) {
                return true;
            }
            Object object = LuaManager.getFunctionObject(this.recipe.LuaTest);
            if (object == null) {
                return false;
            }
            Boolean bl = LuaManager.caller.protectedCallBoolean(LuaManager.thread, object, inventoryItem, this.recipe.getResult());
            return bl == Boolean.TRUE;
        }

        boolean hasItems() {
            for (int i = 0; i < this.sources.size(); ++i) {
                RMRecipeSource rMRecipeSource = this.sources.get(i);
                if (rMRecipeSource.hasItems()) continue;
                return false;
            }
            return true;
        }

        boolean isKeep(String string) {
            for (int i = 0; i < this.sources.size(); ++i) {
                RMRecipeSource rMRecipeSource = this.sources.get(i);
                if (!rMRecipeSource.isKeep(string)) continue;
                return true;
            }
            return false;
        }

        void getAvailableItems(SourceItems sourceItems, boolean bl) {
            assert (bl || this.hasItems());
            for (int i = 0; i < this.sources.size(); ++i) {
                RMRecipeSource rMRecipeSource = this.sources.get(i);
                assert (bl || rMRecipeSource.hasItems());
                rMRecipeSource.getAvailableItems(sourceItems, bl);
            }
        }

        void Use(ArrayList<InventoryItem> arrayList) {
            assert (this.hasItems());
            for (int i = 0; i < this.sources.size(); ++i) {
                RMRecipeSource rMRecipeSource = this.sources.get(i);
                assert (rMRecipeSource.hasItems());
                rMRecipeSource.Use(arrayList);
            }
        }

        static RMRecipe alloc(Recipe recipe) {
            return pool.isEmpty() ? new RMRecipe().init(recipe) : pool.pop().init(recipe);
        }

        static void release(RMRecipe rMRecipe) {
            assert (!pool.contains(rMRecipe));
            pool.push(rMRecipe.reset());
        }
    }

    private static final class RMRecipeItemList {
        RMRecipeSource source;
        final ArrayList<RMRecipeItem> items = new ArrayList();
        int index;
        int usesNeeded;
        Type type = Type.NONE;
        static ArrayDeque<RMRecipeItemList> pool = new ArrayDeque();

        private RMRecipeItemList() {
        }

        RMRecipeItemList init(RMRecipeSource rMRecipeSource, int n) {
            assert (this.items.isEmpty());
            this.source = rMRecipeSource;
            this.index = n;
            String string = rMRecipeSource.source.getItems().get(n);
            this.usesNeeded = (int)rMRecipeSource.source.getCount();
            if ("Water".equals(string)) {
                this.type = Type.WATER;
            } else if (rMRecipeSource.source.isDestroy()) {
                this.type = Type.DESTROY;
            } else if (ScriptManager.instance.isDrainableItemType(string)) {
                this.type = Type.DRAINABLE;
            } else if (rMRecipeSource.source.use > 0.0f) {
                this.usesNeeded = (int)rMRecipeSource.source.use;
                this.type = Type.FOOD;
            } else {
                this.type = Type.OTHER;
            }
            return this;
        }

        RMRecipeItemList reset() {
            this.source = null;
            this.items.clear();
            return this;
        }

        void getItemsFrom(ArrayList<RMRecipeItem> arrayList, RMRecipe rMRecipe) {
            String string = this.source.source.getItems().get(this.index);
            for (int i = 0; i < arrayList.size(); ++i) {
                RMRecipeItem rMRecipeItem = arrayList.get(i);
                DrainableComboItem drainableComboItem = zombie.util.Type.tryCastTo(rMRecipeItem.item, DrainableComboItem.class);
                Food food = zombie.util.Type.tryCastTo(rMRecipeItem.item, Food.class);
                if ("Water".equals(string)) {
                    if (!rMRecipe.Test(rMRecipeItem.item) || !(rMRecipeItem.item instanceof DrainableComboItem) || !rMRecipeItem.item.isWaterSource()) continue;
                    rMRecipeItem.water = RecipeManager.AvailableUses(rMRecipeItem.item);
                    this.items.add(rMRecipeItem);
                    continue;
                }
                if (!string.equals(rMRecipeItem.item.getFullType()) || rMRecipe.recipe.getHeat() > 0.0f && drainableComboItem != null && rMRecipeItem.item.IsCookable && rMRecipeItem.item.getInvHeat() + 1.0f < rMRecipe.recipe.getHeat() || rMRecipe.recipe.getHeat() < 0.0f && drainableComboItem != null && rMRecipeItem.item.IsCookable && rMRecipeItem.item.getInvHeat() > rMRecipe.recipe.getHeat() || food != null && food.getFreezingTime() > 0.0f && !rMRecipe.recipe.isAllowFrozenItem() || rMRecipe.recipe.noBrokenItems() && rMRecipeItem.item.isBroken() || "Clothing".equals(rMRecipeItem.item.getCategory()) && rMRecipeItem.item.isFavorite() || !rMRecipe.Test(rMRecipeItem.item)) continue;
                if (this.source.source.isDestroy()) {
                    rMRecipeItem.uses = 1;
                    this.items.add(rMRecipeItem);
                    continue;
                }
                if (drainableComboItem != null) {
                    rMRecipeItem.uses = RecipeManager.AvailableUses(rMRecipeItem.item);
                    this.items.add(rMRecipeItem);
                    continue;
                }
                if (this.source.source.use > 0.0f) {
                    if (!(rMRecipeItem.item instanceof Food)) continue;
                    rMRecipeItem.uses = RecipeManager.AvailableUses(rMRecipeItem.item);
                    this.items.add(rMRecipeItem);
                    continue;
                }
                rMRecipeItem.uses = rMRecipeItem.item.getUses();
                this.items.add(rMRecipeItem);
            }
        }

        boolean hasItems() {
            String string = this.source.source.getItems().get(this.index);
            int n = 0;
            for (int i = 0; i < this.items.size(); ++i) {
                if ("Water".equals(string)) {
                    n += this.items.get((int)i).water;
                    continue;
                }
                n += this.items.get((int)i).uses;
            }
            return n >= this.usesNeeded;
        }

        int indexOf(InventoryItem inventoryItem) {
            for (int i = 0; i < this.items.size(); ++i) {
                RMRecipeItem rMRecipeItem = this.items.get(i);
                if (rMRecipeItem.item != inventoryItem) continue;
                return i;
            }
            return -1;
        }

        void getAvailableItems(SourceItems sourceItems, boolean bl) {
            int n;
            if (bl) {
                this.Use(sourceItems.itemsPerSource[this.source.index]);
                sourceItems.typePerSource[this.source.index] = this.type;
                sourceItems.allItems.addAll(sourceItems.itemsPerSource[this.source.index]);
                return;
            }
            assert (this.hasItems());
            if (sourceItems.selectedItem != null && (n = this.indexOf(sourceItems.selectedItem)) != -1) {
                RMRecipeItem rMRecipeItem = this.items.remove(n);
                this.items.add(0, rMRecipeItem);
            }
            this.Use(sourceItems.itemsPerSource[this.source.index]);
            sourceItems.typePerSource[this.source.index] = this.type;
            sourceItems.allItems.addAll(sourceItems.itemsPerSource[this.source.index]);
        }

        void Use(ArrayList<InventoryItem> arrayList) {
            String string = this.source.source.getItems().get(this.index);
            int n = this.usesNeeded;
            for (int i = 0; i < this.items.size(); ++i) {
                RMRecipeItem rMRecipeItem = this.items.get(i);
                if ("Water".equals(string) && rMRecipeItem.water > 0) {
                    n -= rMRecipeItem.UseWater(n);
                    arrayList.add(rMRecipeItem.item);
                } else if (this.source.source.isKeep() && rMRecipeItem.uses > 0) {
                    n -= Math.min(rMRecipeItem.uses, n);
                    arrayList.add(rMRecipeItem.item);
                } else if (rMRecipeItem.uses > 0) {
                    n -= rMRecipeItem.Use(n);
                    arrayList.add(rMRecipeItem.item);
                }
                if (n <= 0) break;
            }
        }

        static RMRecipeItemList alloc(RMRecipeSource rMRecipeSource, int n) {
            return pool.isEmpty() ? new RMRecipeItemList().init(rMRecipeSource, n) : pool.pop().init(rMRecipeSource, n);
        }

        static void release(RMRecipeItemList rMRecipeItemList) {
            assert (!pool.contains(rMRecipeItemList));
            pool.push(rMRecipeItemList.reset());
        }

        static enum Type {
            NONE,
            WATER,
            DRAINABLE,
            FOOD,
            OTHER,
            DESTROY;

        }
    }

    private static final class RMRecipeItem {
        InventoryItem item;
        int uses;
        int water;
        static ArrayDeque<RMRecipeItem> pool = new ArrayDeque();

        private RMRecipeItem() {
        }

        RMRecipeItem init(InventoryItem inventoryItem) {
            this.item = inventoryItem;
            return this;
        }

        RMRecipeItem reset() {
            this.item = null;
            this.uses = 0;
            this.water = 0;
            return this;
        }

        int Use(int n) {
            int n2 = Math.min(this.uses, n);
            this.uses -= n2;
            return n2;
        }

        int UseWater(int n) {
            int n2 = Math.min(this.water, n);
            this.water -= n2;
            return n2;
        }

        static RMRecipeItem alloc(InventoryItem inventoryItem) {
            return pool.isEmpty() ? new RMRecipeItem().init(inventoryItem) : pool.pop().init(inventoryItem);
        }

        static void release(RMRecipeItem rMRecipeItem) {
            assert (!pool.contains(rMRecipeItem));
            pool.push(rMRecipeItem.reset());
        }
    }

    private static final class RMRecipeSource {
        RMRecipe recipe;
        Recipe.Source source;
        int index;
        final ArrayList<RMRecipeItemList> itemLists = new ArrayList();
        boolean usesWater;
        static ArrayDeque<RMRecipeSource> pool = new ArrayDeque();

        private RMRecipeSource() {
        }

        RMRecipeSource init(RMRecipe rMRecipe, int n) {
            this.recipe = rMRecipe;
            this.source = rMRecipe.recipe.getSource().get(n);
            this.index = n;
            assert (this.itemLists.isEmpty());
            for (int i = 0; i < this.source.getItems().size(); ++i) {
                this.itemLists.add(RMRecipeItemList.alloc(this, i));
            }
            this.usesWater = this.source.getItems().contains("Water");
            return this;
        }

        RMRecipeSource reset() {
            for (int i = 0; i < this.itemLists.size(); ++i) {
                RMRecipeItemList.release(this.itemLists.get(i));
            }
            this.itemLists.clear();
            return this;
        }

        void getItemsFrom(ArrayList<RMRecipeItem> arrayList, RMRecipe rMRecipe) {
            for (int i = 0; i < this.itemLists.size(); ++i) {
                RMRecipeItemList rMRecipeItemList = this.itemLists.get(i);
                rMRecipeItemList.getItemsFrom(arrayList, rMRecipe);
            }
        }

        boolean hasItems() {
            for (int i = 0; i < this.itemLists.size(); ++i) {
                RMRecipeItemList rMRecipeItemList = this.itemLists.get(i);
                if (!rMRecipeItemList.hasItems()) continue;
                return true;
            }
            return false;
        }

        boolean isKeep(String string) {
            if (this.source.getItems().contains(string)) {
                return this.source.keep;
            }
            return false;
        }

        void getAvailableItems(SourceItems sourceItems, boolean bl) {
            if (bl) {
                for (int i = 0; i < this.itemLists.size(); ++i) {
                    RMRecipeItemList rMRecipeItemList = this.itemLists.get(i);
                    rMRecipeItemList.getAvailableItems(sourceItems, bl);
                }
                return;
            }
            int n = -1;
            for (int i = 0; i < this.itemLists.size(); ++i) {
                RMRecipeItemList rMRecipeItemList = this.itemLists.get(i);
                if (!rMRecipeItemList.hasItems()) continue;
                InventoryItem inventoryItem = rMRecipeItemList.items.get((int)0).item;
                if (sourceItems.selectedItem != null && rMRecipeItemList.indexOf(sourceItems.selectedItem) != -1) {
                    n = i;
                    break;
                }
                if (inventoryItem != null && inventoryItem instanceof HandWeapon && (inventoryItem.isEquipped() || inventoryItem.isInPlayerInventory())) {
                    n = i;
                    break;
                }
                if (n != -1) continue;
                n = i;
            }
            if (n == -1) {
                return;
            }
            this.itemLists.get(n).getAvailableItems(sourceItems, bl);
        }

        void Use(ArrayList<InventoryItem> arrayList) {
            assert (this.hasItems());
            for (int i = 0; i < this.itemLists.size(); ++i) {
                RMRecipeItemList rMRecipeItemList = this.itemLists.get(i);
                if (!rMRecipeItemList.hasItems()) continue;
                rMRecipeItemList.Use(arrayList);
                return;
            }
            assert (false);
        }

        static RMRecipeSource alloc(RMRecipe rMRecipe, int n) {
            return pool.isEmpty() ? new RMRecipeSource().init(rMRecipe, n) : pool.pop().init(rMRecipe, n);
        }

        static void release(RMRecipeSource rMRecipeSource) {
            assert (!pool.contains(rMRecipeSource));
            pool.push(rMRecipeSource.reset());
        }
    }
}

