/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.util.ArrayList;
import zombie.characters.IsoGameCharacter;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.DrainableComboItem;
import zombie.iso.IsoObject;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.Type;
import zombie.vehicles.VehiclePart;

public final class ItemUser {
    private static final ArrayList<InventoryItem> tempItems = new ArrayList();

    public static void UseItem(InventoryItem inventoryItem) {
        DrainableComboItem drainableComboItem = Type.tryCastTo(inventoryItem, DrainableComboItem.class);
        if (drainableComboItem != null) {
            InventoryItem inventoryItem2;
            int n;
            drainableComboItem.setDelta(drainableComboItem.getDelta() - drainableComboItem.getUseDelta());
            if (drainableComboItem.uses > 1) {
                int n2 = drainableComboItem.uses - 1;
                drainableComboItem.uses = 1;
                ItemUser.CreateItem(drainableComboItem.getFullType(), tempItems);
                n = 0;
                if (n < tempItems.size()) {
                    inventoryItem2 = tempItems.get(n);
                    inventoryItem2.setUses(n2);
                    ItemUser.AddItem(drainableComboItem, inventoryItem2);
                }
            }
            if (drainableComboItem.getDelta() <= 1.0E-4f) {
                drainableComboItem.setDelta(0.0f);
                if (drainableComboItem.getReplaceOnDeplete() != null) {
                    String string = drainableComboItem.getReplaceOnDepleteFullType();
                    ItemUser.CreateItem(string, tempItems);
                    for (n = 0; n < tempItems.size(); ++n) {
                        inventoryItem2 = tempItems.get(n);
                        inventoryItem2.setFavorite(drainableComboItem.isFavorite());
                        ItemUser.AddItem(drainableComboItem, inventoryItem2);
                    }
                    ItemUser.RemoveItem(drainableComboItem);
                } else {
                    ItemUser.UseItem(drainableComboItem, false, false);
                }
            }
            drainableComboItem.updateWeight();
        } else {
            ItemUser.UseItem(inventoryItem, false, false);
        }
    }

    public static void UseItem(InventoryItem inventoryItem, boolean bl, boolean bl2) {
        if (!inventoryItem.isDisappearOnUse() && !bl) {
            return;
        }
        --inventoryItem.uses;
        if (inventoryItem.replaceOnUse != null && !bl2 && !bl) {
            Object object = inventoryItem.replaceOnUse;
            if (!((String)object).contains(".")) {
                object = inventoryItem.module + "." + (String)object;
            }
            ItemUser.CreateItem((String)object, tempItems);
            for (int i = 0; i < tempItems.size(); ++i) {
                InventoryItem inventoryItem2 = tempItems.get(i);
                inventoryItem2.setConditionFromModData(inventoryItem);
                ItemUser.AddItem(inventoryItem, inventoryItem2);
                inventoryItem2.setFavorite(inventoryItem.isFavorite());
            }
        }
        if (inventoryItem.uses <= 0) {
            if (inventoryItem.keepOnDeplete) {
                return;
            }
            ItemUser.RemoveItem(inventoryItem);
        } else if (GameClient.bClient && !inventoryItem.isInPlayerInventory()) {
            GameClient.instance.sendItemStats(inventoryItem);
        }
    }

    public static void CreateItem(String string, ArrayList<InventoryItem> arrayList) {
        arrayList.clear();
        Item item = ScriptManager.instance.FindItem(string);
        if (item == null) {
            DebugLog.General.warn("ERROR: ItemUses.CreateItem: can't find " + string);
            return;
        }
        int n = item.getCount();
        for (int i = 0; i < n; ++i) {
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(string);
            if (inventoryItem == null) {
                return;
            }
            arrayList.add(inventoryItem);
        }
    }

    public static void AddItem(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
        IsoWorldInventoryObject isoWorldInventoryObject = inventoryItem.getWorldItem();
        if (isoWorldInventoryObject != null && isoWorldInventoryObject.getWorldObjectIndex() == -1) {
            isoWorldInventoryObject = null;
        }
        if (isoWorldInventoryObject != null) {
            isoWorldInventoryObject.getSquare().AddWorldInventoryItem(inventoryItem2, 0.0f, 0.0f, 0.0f, true);
            return;
        }
        if (inventoryItem.container != null) {
            VehiclePart vehiclePart = inventoryItem.container.vehiclePart;
            if (!inventoryItem.isInPlayerInventory() && GameClient.bClient) {
                inventoryItem.container.addItemOnServer(inventoryItem2);
            }
            inventoryItem.container.AddItem(inventoryItem2);
            if (vehiclePart != null) {
                vehiclePart.setContainerContentAmount(vehiclePart.getItemContainer().getCapacityWeight());
            }
        }
    }

    public static void RemoveItem(InventoryItem inventoryItem) {
        IsoWorldInventoryObject isoWorldInventoryObject = inventoryItem.getWorldItem();
        if (isoWorldInventoryObject != null && isoWorldInventoryObject.getWorldObjectIndex() == -1) {
            isoWorldInventoryObject = null;
        }
        if (isoWorldInventoryObject != null) {
            isoWorldInventoryObject.getSquare().transmitRemoveItemFromSquare(isoWorldInventoryObject);
            if (inventoryItem.container != null) {
                inventoryItem.container.Items.remove(inventoryItem);
                inventoryItem.container.setDirty(true);
                inventoryItem.container.setDrawDirty(true);
                inventoryItem.container = null;
            }
            return;
        }
        if (inventoryItem.container != null) {
            IsoObject isoObject = inventoryItem.container.parent;
            VehiclePart vehiclePart = inventoryItem.container.vehiclePart;
            if (isoObject instanceof IsoGameCharacter) {
                IsoGameCharacter isoGameCharacter = (IsoGameCharacter)isoObject;
                if (inventoryItem instanceof Clothing) {
                    ((Clothing)inventoryItem).Unwear();
                }
                isoGameCharacter.removeFromHands(inventoryItem);
                if (isoGameCharacter.getClothingItem_Back() == inventoryItem) {
                    isoGameCharacter.setClothingItem_Back(null);
                }
            } else if (!inventoryItem.isInPlayerInventory() && GameClient.bClient) {
                inventoryItem.container.removeItemOnServer(inventoryItem);
            }
            inventoryItem.container.Items.remove(inventoryItem);
            inventoryItem.container.setDirty(true);
            inventoryItem.container.setDrawDirty(true);
            inventoryItem.container = null;
            if (isoObject instanceof IsoDeadBody) {
                ((IsoDeadBody)isoObject).checkClothing(inventoryItem);
            }
            if (isoObject instanceof IsoMannequin) {
                ((IsoMannequin)isoObject).checkClothing(inventoryItem);
            }
            if (vehiclePart != null) {
                vehiclePart.setContainerContentAmount(vehiclePart.getItemContainer().getCapacityWeight());
            }
        }
    }
}

