/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.krka.kahlua.j2se.KahluaTableImpl;
import se.krka.kahlua.vm.KahluaTableIterator;
import se.krka.kahlua.vm.KahluaUtil;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.stash.StashSystem;
import zombie.debug.DebugLog;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Key;
import zombie.inventory.types.MapItem;
import zombie.inventory.types.WeaponPart;
import zombie.iso.ContainerOverlays;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoMetaChunk;
import zombie.iso.IsoMetaGrid;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.areas.IsoRoom;
import zombie.iso.objects.IsoDeadBody;
import zombie.network.GameClient;
import zombie.network.GameServer;
import zombie.radio.ZomboidRadio;
import zombie.radio.media.MediaData;
import zombie.radio.media.RecordedMedia;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.list.PZArrayList;
import zombie.util.list.PZArrayUtil;

public final class ItemPickerJava {
    private static IsoPlayer player;
    private static float OtherLootModifier;
    private static float FoodLootModifier;
    private static float CannedFoodLootModifier;
    private static float WeaponLootModifier;
    private static float RangedWeaponLootModifier;
    private static float AmmoLootModifier;
    private static float LiteratureLootModifier;
    private static float SurvivalGearsLootModifier;
    private static float MedicalLootModifier;
    private static float BagLootModifier;
    private static float MechanicsLootModifier;
    public static float zombieDensityCap;
    public static final ArrayList<String> NoContainerFillRooms;
    public static final ArrayList<ItemPickerUpgradeWeapons> WeaponUpgrades;
    public static final HashMap<String, ItemPickerUpgradeWeapons> WeaponUpgradeMap;
    public static final THashMap<String, ItemPickerRoom> rooms;
    public static final THashMap<String, ItemPickerContainer> containers;
    public static final THashMap<String, ItemPickerContainer> ProceduralDistributions;
    public static final THashMap<String, VehicleDistribution> VehicleDistributions;

    public static void Parse() {
        rooms.clear();
        NoContainerFillRooms.clear();
        WeaponUpgradeMap.clear();
        WeaponUpgrades.clear();
        containers.clear();
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget("NoContainerFillRooms");
        for (Map.Entry<Object, Object> object : kahluaTableImpl.delegate.entrySet()) {
            String string = object.getKey().toString();
            NoContainerFillRooms.add(string);
        }
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)LuaManager.env.rawget("WeaponUpgrades");
        for (Map.Entry<Object, Object> entry : kahluaTableImpl2.delegate.entrySet()) {
            String string = entry.getKey().toString();
            ItemPickerUpgradeWeapons itemPickerUpgradeWeapons = new ItemPickerUpgradeWeapons();
            itemPickerUpgradeWeapons.name = string;
            WeaponUpgrades.add(itemPickerUpgradeWeapons);
            WeaponUpgradeMap.put(string, itemPickerUpgradeWeapons);
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)entry.getValue();
            for (Map.Entry<Object, Object> entry2 : kahluaTableImpl3.delegate.entrySet()) {
                String string2 = entry2.getValue().toString();
                itemPickerUpgradeWeapons.Upgrades.add(string2);
            }
        }
        ItemPickerJava.ParseSuburbsDistributions();
        ItemPickerJava.ParseVehicleDistributions();
        ItemPickerJava.ParseProceduralDistributions();
    }

    private static void ParseSuburbsDistributions() {
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget("SuburbsDistributions");
        for (Map.Entry<Object, Object> entry : kahluaTableImpl.delegate.entrySet()) {
            Object object;
            String string = entry.getKey().toString();
            KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)entry.getValue();
            if (kahluaTableImpl2.delegate.containsKey("rolls")) {
                object = ItemPickerJava.ExtractContainersFromLua(kahluaTableImpl2);
                containers.put((Object)string, object);
                continue;
            }
            object = new ItemPickerRoom();
            rooms.put((Object)string, object);
            for (Map.Entry<Object, Object> entry2 : kahluaTableImpl2.delegate.entrySet()) {
                String string2 = entry2.getKey().toString();
                if (entry2.getValue() instanceof Double) {
                    ((ItemPickerRoom)object).fillRand = ((Double)entry2.getValue()).intValue();
                    continue;
                }
                if ("isShop".equals(string2)) {
                    ((ItemPickerRoom)object).isShop = (Boolean)entry2.getValue();
                    continue;
                }
                KahluaTableImpl kahluaTableImpl3 = null;
                try {
                    kahluaTableImpl3 = (KahluaTableImpl)entry2.getValue();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (!(kahluaTableImpl3.delegate.containsKey("procedural") || !string2.isEmpty() && kahluaTableImpl3.delegate.containsKey("rolls") && kahluaTableImpl3.delegate.containsKey("items"))) {
                    DebugLog.log("ERROR: SuburbsDistributions[\"" + string + "\"] is broken");
                    continue;
                }
                ItemPickerContainer itemPickerContainer = ItemPickerJava.ExtractContainersFromLua(kahluaTableImpl3);
                ((ItemPickerRoom)object).Containers.put((Object)string2, (Object)itemPickerContainer);
            }
        }
    }

    private static void ParseVehicleDistributions() {
        VehicleDistributions.clear();
        KahluaTableImpl kahluaTableImpl = (KahluaTableImpl)LuaManager.env.rawget("VehicleDistributions");
        if (kahluaTableImpl == null || !(kahluaTableImpl.rawget(1) instanceof KahluaTableImpl)) {
            return;
        }
        kahluaTableImpl = (KahluaTableImpl)kahluaTableImpl.rawget(1);
        for (Map.Entry<Object, Object> entry : kahluaTableImpl.delegate.entrySet()) {
            KahluaTableImpl kahluaTableImpl2;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof KahluaTableImpl)) continue;
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)entry.getValue();
            VehicleDistribution vehicleDistribution = new VehicleDistribution();
            if (kahluaTableImpl3.rawget("Normal") instanceof KahluaTableImpl) {
                kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl3.rawget("Normal");
                ItemPickerRoom itemPickerRoom = new ItemPickerRoom();
                for (Map.Entry<Object, Object> entry2 : kahluaTableImpl2.delegate.entrySet()) {
                    String string = entry2.getKey().toString();
                    itemPickerRoom.Containers.put((Object)string, (Object)ItemPickerJava.ExtractContainersFromLua((KahluaTableImpl)entry2.getValue()));
                }
                vehicleDistribution.Normal = itemPickerRoom;
            }
            if (kahluaTableImpl3.rawget("Specific") instanceof KahluaTableImpl) {
                kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl3.rawget("Specific");
                for (int i = 1; i <= kahluaTableImpl2.len(); ++i) {
                    KahluaTableImpl kahluaTableImpl4 = (KahluaTableImpl)kahluaTableImpl2.rawget(i);
                    ItemPickerRoom itemPickerRoom = new ItemPickerRoom();
                    for (Map.Entry entry3 : kahluaTableImpl4.delegate.entrySet()) {
                        String string = entry3.getKey().toString();
                        if (string.equals("specificId")) {
                            itemPickerRoom.specificId = (String)entry3.getValue();
                            continue;
                        }
                        itemPickerRoom.Containers.put((Object)string, (Object)ItemPickerJava.ExtractContainersFromLua((KahluaTableImpl)entry3.getValue()));
                    }
                    vehicleDistribution.Specific.add(itemPickerRoom);
                }
            }
            if (vehicleDistribution.Normal == null) continue;
            VehicleDistributions.put((Object)((String)entry.getKey()), (Object)vehicleDistribution);
        }
    }

    private static void ParseProceduralDistributions() {
        ProceduralDistributions.clear();
        KahluaTableImpl kahluaTableImpl = Type.tryCastTo(LuaManager.env.rawget("ProceduralDistributions"), KahluaTableImpl.class);
        if (kahluaTableImpl == null) {
            return;
        }
        KahluaTableImpl kahluaTableImpl2 = Type.tryCastTo(kahluaTableImpl.rawget("list"), KahluaTableImpl.class);
        if (kahluaTableImpl2 == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : kahluaTableImpl2.delegate.entrySet()) {
            String string = entry.getKey().toString();
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)entry.getValue();
            ItemPickerContainer itemPickerContainer = ItemPickerJava.ExtractContainersFromLua(kahluaTableImpl3);
            ProceduralDistributions.put((Object)string, (Object)itemPickerContainer);
        }
    }

    private static ItemPickerContainer ExtractContainersFromLua(KahluaTableImpl kahluaTableImpl) {
        ItemPickerContainer itemPickerContainer = new ItemPickerContainer();
        if (kahluaTableImpl.delegate.containsKey("procedural")) {
            itemPickerContainer.procedural = kahluaTableImpl.rawgetBool("procedural");
            itemPickerContainer.proceduralItems = ItemPickerJava.ExtractProcList(kahluaTableImpl);
            return itemPickerContainer;
        }
        if (kahluaTableImpl.delegate.containsKey("noAutoAge")) {
            itemPickerContainer.noAutoAge = kahluaTableImpl.rawgetBool("noAutoAge");
        }
        if (kahluaTableImpl.delegate.containsKey("fillRand")) {
            itemPickerContainer.fillRand = kahluaTableImpl.rawgetInt("fillRand");
        }
        if (kahluaTableImpl.delegate.containsKey("maxMap")) {
            itemPickerContainer.maxMap = kahluaTableImpl.rawgetInt("maxMap");
        }
        if (kahluaTableImpl.delegate.containsKey("stashChance")) {
            itemPickerContainer.stashChance = kahluaTableImpl.rawgetInt("stashChance");
        }
        if (kahluaTableImpl.delegate.containsKey("dontSpawnAmmo")) {
            itemPickerContainer.dontSpawnAmmo = kahluaTableImpl.rawgetBool("dontSpawnAmmo");
        }
        if (kahluaTableImpl.delegate.containsKey("ignoreZombieDensity")) {
            itemPickerContainer.ignoreZombieDensity = kahluaTableImpl.rawgetBool("ignoreZombieDensity");
        }
        double d = (Double)kahluaTableImpl.delegate.get("rolls");
        if (kahluaTableImpl.delegate.containsKey("junk")) {
            itemPickerContainer.junk = ItemPickerJava.ExtractContainersFromLua((KahluaTableImpl)kahluaTableImpl.rawget("junk"));
        }
        itemPickerContainer.rolls = (int)d;
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl.delegate.get("items");
        ArrayList<ItemPickerItem> arrayList = new ArrayList<ItemPickerItem>();
        int n = kahluaTableImpl2.len();
        for (int i = 0; i < n; i += 2) {
            String string = Type.tryCastTo(kahluaTableImpl2.delegate.get(KahluaUtil.toDouble(i + 1)), String.class);
            Double d2 = Type.tryCastTo(kahluaTableImpl2.delegate.get(KahluaUtil.toDouble(i + 2)), Double.class);
            if (string == null || d2 == null) continue;
            Item item = ScriptManager.instance.FindItem(string);
            if (item == null || item.OBSOLETE) {
                if (!Core.bDebug) continue;
                DebugLog.General.warn("ignoring invalid ItemPicker item type \"%s\"", string);
                continue;
            }
            ItemPickerItem itemPickerItem = new ItemPickerItem();
            itemPickerItem.itemName = string;
            itemPickerItem.chance = d2.floatValue();
            arrayList.add(itemPickerItem);
        }
        itemPickerContainer.Items = arrayList.toArray(itemPickerContainer.Items);
        return itemPickerContainer;
    }

    private static ArrayList<ProceduralItem> ExtractProcList(KahluaTableImpl kahluaTableImpl) {
        ArrayList<ProceduralItem> arrayList = new ArrayList<ProceduralItem>();
        KahluaTableImpl kahluaTableImpl2 = (KahluaTableImpl)kahluaTableImpl.rawget("procList");
        KahluaTableIterator kahluaTableIterator = kahluaTableImpl2.iterator();
        while (kahluaTableIterator.advance()) {
            KahluaTableImpl kahluaTableImpl3 = (KahluaTableImpl)kahluaTableIterator.getValue();
            ProceduralItem proceduralItem = new ProceduralItem();
            proceduralItem.name = kahluaTableImpl3.rawgetStr("name");
            proceduralItem.min = kahluaTableImpl3.rawgetInt("min");
            proceduralItem.max = kahluaTableImpl3.rawgetInt("max");
            proceduralItem.weightChance = kahluaTableImpl3.rawgetInt("weightChance");
            String string = kahluaTableImpl3.rawgetStr("forceForItems");
            String string2 = kahluaTableImpl3.rawgetStr("forceForZones");
            String string3 = kahluaTableImpl3.rawgetStr("forceForTiles");
            String string4 = kahluaTableImpl3.rawgetStr("forceForRooms");
            if (!StringUtils.isNullOrWhitespace(string)) {
                proceduralItem.forceForItems = Arrays.asList(string.split(";"));
            }
            if (!StringUtils.isNullOrWhitespace(string2)) {
                proceduralItem.forceForZones = Arrays.asList(string2.split(";"));
            }
            if (!StringUtils.isNullOrWhitespace(string3)) {
                proceduralItem.forceForTiles = Arrays.asList(string3.split(";"));
            }
            if (!StringUtils.isNullOrWhitespace(string4)) {
                proceduralItem.forceForRooms = Arrays.asList(string4.split(";"));
            }
            arrayList.add(proceduralItem);
        }
        return arrayList;
    }

    public static void InitSandboxLootSettings() {
        OtherLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().OtherLoot.getValue());
        FoodLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().FoodLoot.getValue());
        WeaponLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().WeaponLoot.getValue());
        RangedWeaponLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().RangedWeaponLoot.getValue());
        AmmoLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().AmmoLoot.getValue());
        CannedFoodLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().CannedFoodLoot.getValue());
        LiteratureLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().LiteratureLoot.getValue());
        SurvivalGearsLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().SurvivalGearsLoot.getValue());
        MedicalLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().MedicalLoot.getValue());
        MechanicsLootModifier = ItemPickerJava.doSandboxSettings(SandboxOptions.getInstance().MechanicsLoot.getValue());
    }

    private static float doSandboxSettings(int n) {
        switch (n) {
            case 1: {
                return 0.0f;
            }
            case 2: {
                return 0.05f;
            }
            case 3: {
                return 0.2f;
            }
            case 4: {
                return 0.6f;
            }
            case 5: {
                return 1.0f;
            }
            case 6: {
                return 2.0f;
            }
            case 7: {
                return 3.0f;
            }
        }
        return 0.6f;
    }

    public static void fillContainer(ItemContainer itemContainer, IsoPlayer isoPlayer) {
        if (GameClient.bClient || "Tutorial".equals(Core.GameMode)) {
            return;
        }
        if (itemContainer == null) {
            return;
        }
        IsoGridSquare isoGridSquare = itemContainer.getSourceGrid();
        IsoRoom isoRoom = null;
        if (isoGridSquare == null) {
            return;
        }
        isoRoom = isoGridSquare.getRoom();
        if (itemContainer.getType().equals("inventorymale") || itemContainer.getType().equals("inventoryfemale")) {
            String string = itemContainer.getType();
            if (itemContainer.getParent() != null && itemContainer.getParent() instanceof IsoDeadBody) {
                string = ((IsoDeadBody)itemContainer.getParent()).getOutfitName();
            }
            for (int i = 0; i < itemContainer.getItems().size(); ++i) {
                ItemPickerContainer itemPickerContainer;
                if (!(itemContainer.getItems().get(i) instanceof InventoryContainer) || (itemPickerContainer = (ItemPickerContainer)containers.get((Object)itemContainer.getItems().get(i).getType())) == null || Rand.Next(itemPickerContainer.fillRand) != 0) continue;
                ItemPickerJava.rollContainerItem((InventoryContainer)itemContainer.getItems().get(i), null, (ItemPickerContainer)containers.get((Object)itemContainer.getItems().get(i).getType()));
            }
            ItemPickerContainer itemPickerContainer = (ItemPickerContainer)((ItemPickerRoom)ItemPickerJava.rooms.get((Object)"all")).Containers.get((Object)("Outfit_" + string));
            if (itemPickerContainer == null) {
                itemPickerContainer = (ItemPickerContainer)((ItemPickerRoom)ItemPickerJava.rooms.get((Object)"all")).Containers.get((Object)itemContainer.getType());
            }
            ItemPickerJava.rollItem(itemPickerContainer, itemContainer, true, isoPlayer, null);
            return;
        }
        ItemPickerRoom itemPickerRoom = null;
        if (rooms.containsKey((Object)"all")) {
            itemPickerRoom = (ItemPickerRoom)rooms.get((Object)"all");
        }
        if (isoRoom != null && rooms.containsKey((Object)isoRoom.getName())) {
            String string = isoRoom.getName();
            ItemPickerRoom itemPickerRoom2 = (ItemPickerRoom)rooms.get((Object)string);
            ItemPickerContainer itemPickerContainer = null;
            if (itemPickerRoom2.Containers.containsKey((Object)itemContainer.getType())) {
                itemPickerContainer = (ItemPickerContainer)itemPickerRoom2.Containers.get((Object)itemContainer.getType());
            }
            if (itemPickerContainer == null && itemPickerRoom2.Containers.containsKey((Object)"other")) {
                itemPickerContainer = (ItemPickerContainer)itemPickerRoom2.Containers.get((Object)"other");
            }
            if (itemPickerContainer == null && itemPickerRoom2.Containers.containsKey((Object)"all")) {
                itemPickerContainer = (ItemPickerContainer)itemPickerRoom2.Containers.get((Object)"all");
                string = "all";
            }
            if (itemPickerContainer == null) {
                ItemPickerJava.fillContainerType(itemPickerRoom, itemContainer, string, isoPlayer);
                LuaEventManager.triggerEvent("OnFillContainer", string, itemContainer.getType(), itemContainer);
                return;
            }
        } else {
            String string = null;
            string = isoRoom != null ? isoRoom.getName() : "all";
            ItemPickerJava.fillContainerType(itemPickerRoom, itemContainer, string, isoPlayer);
            LuaEventManager.triggerEvent("OnFillContainer", string, itemContainer.getType(), itemContainer);
            return;
        }
        if (rooms.containsKey((Object)isoRoom.getName())) {
            itemPickerRoom = (ItemPickerRoom)rooms.get((Object)isoRoom.getName());
        }
        if (itemPickerRoom != null) {
            ItemPickerJava.fillContainerType(itemPickerRoom, itemContainer, isoRoom.getName(), isoPlayer);
            LuaEventManager.triggerEvent("OnFillContainer", isoRoom.getName(), itemContainer.getType(), itemContainer);
        }
    }

    public static void fillContainerType(ItemPickerRoom itemPickerRoom, ItemContainer itemContainer, String string, IsoGameCharacter isoGameCharacter) {
        boolean bl = true;
        if (NoContainerFillRooms.contains(string)) {
            bl = false;
        }
        ItemPickerContainer itemPickerContainer = null;
        if (itemPickerRoom.Containers.containsKey((Object)"all")) {
            itemPickerContainer = (ItemPickerContainer)itemPickerRoom.Containers.get((Object)"all");
            ItemPickerJava.rollItem(itemPickerContainer, itemContainer, bl, isoGameCharacter, itemPickerRoom);
        }
        if ((itemPickerContainer = (ItemPickerContainer)itemPickerRoom.Containers.get((Object)itemContainer.getType())) == null) {
            itemPickerContainer = (ItemPickerContainer)itemPickerRoom.Containers.get((Object)"other");
        }
        if (itemPickerContainer != null) {
            ItemPickerJava.rollItem(itemPickerContainer, itemContainer, bl, isoGameCharacter, itemPickerRoom);
        }
    }

    public static InventoryItem tryAddItemToContainer(ItemContainer itemContainer, String string, ItemPickerContainer itemPickerContainer) {
        ItemContainer itemContainer2;
        Item item = ScriptManager.instance.FindItem(string);
        if (item == null) {
            return null;
        }
        if (item.OBSOLETE) {
            return null;
        }
        float f = item.getActualWeight() * (float)item.getCount();
        if (!itemContainer.hasRoomFor(null, f)) {
            return null;
        }
        if (itemContainer.getContainingItem() instanceof InventoryContainer && (itemContainer2 = itemContainer.getContainingItem().getContainer()) != null && !itemContainer2.hasRoomFor(null, f)) {
            return null;
        }
        return itemContainer.AddItem(string);
    }

    private static void rollProceduralItem(ArrayList<ProceduralItem> arrayList, ItemContainer itemContainer, float f, IsoGameCharacter isoGameCharacter, ItemPickerRoom itemPickerRoom) {
        Object object;
        if (itemContainer.getSourceGrid() == null || itemContainer.getSourceGrid().getRoom() == null) {
            return;
        }
        HashMap<String, Integer> hashMap = itemContainer.getSourceGrid().getRoom().getRoomDef().getProceduralSpawnedContainer();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            IsoGridSquare isoGridSquare;
            object = arrayList.get(i);
            String string = ((ProceduralItem)object).name;
            int n = ((ProceduralItem)object).min;
            int n2 = ((ProceduralItem)object).max;
            int n3 = ((ProceduralItem)object).weightChance;
            List<String> list = ((ProceduralItem)object).forceForItems;
            List<String> list2 = ((ProceduralItem)object).forceForZones;
            List<String> list3 = ((ProceduralItem)object).forceForTiles;
            List<String> list4 = ((ProceduralItem)object).forceForRooms;
            if (hashMap.get(string) == null) {
                hashMap.put(string, 0);
            }
            if (list != null) {
                for (int j = itemContainer.getSourceGrid().getRoom().getRoomDef().x; j < itemContainer.getSourceGrid().getRoom().getRoomDef().x2; ++j) {
                    block2: for (var19_23 = itemContainer.getSourceGrid().getRoom().getRoomDef().y; var19_23 < itemContainer.getSourceGrid().getRoom().getRoomDef().y2; ++var19_23) {
                        var20_24 = itemContainer.getSourceGrid().getCell().getGridSquare(j, var19_23, itemContainer.getSourceGrid().z);
                        if (var20_24 == null) continue;
                        for (int k = 0; k < ((IsoGridSquare)var20_24).getObjects().size(); ++k) {
                            IsoObject isoObject = ((IsoGridSquare)var20_24).getObjects().get(k);
                            if (!list.contains(isoObject.getSprite().name)) continue;
                            hashMap2.clear();
                            hashMap2.put(string, -1);
                            continue block2;
                        }
                    }
                }
            } else if (list2 != null) {
                ArrayList<IsoMetaGrid.Zone> arrayList2 = IsoWorld.instance.MetaGrid.getZonesAt(itemContainer.getSourceGrid().x, itemContainer.getSourceGrid().y, 0);
                for (var19_23 = 0; var19_23 < arrayList2.size(); ++var19_23) {
                    if (hashMap.get(string) >= n2 || !list2.contains(arrayList2.get((int)var19_23).type) && !list2.contains(arrayList2.get((int)var19_23).name)) continue;
                    hashMap2.clear();
                    hashMap2.put(string, -1);
                    break;
                }
            } else if (list3 != null) {
                IsoGridSquare isoGridSquare2 = itemContainer.getSourceGrid();
                if (isoGridSquare2 != null) {
                    for (var19_23 = 0; var19_23 < isoGridSquare2.getObjects().size(); ++var19_23) {
                        var20_24 = isoGridSquare2.getObjects().get(var19_23);
                        if (((IsoObject)var20_24).getSprite() == null || !list3.contains(((IsoObject)var20_24).getSprite().getName())) continue;
                        hashMap2.clear();
                        hashMap2.put(string, -1);
                        break;
                    }
                }
            } else if (list4 != null && (isoGridSquare = itemContainer.getSourceGrid()) != null) {
                for (var19_23 = 0; var19_23 < list4.size(); ++var19_23) {
                    if (isoGridSquare.getBuilding().getRandomRoom(list4.get(var19_23)) == null) continue;
                    hashMap2.clear();
                    hashMap2.put(string, -1);
                    break;
                }
            }
            if (list != null || list2 != null || list3 != null || list4 != null) continue;
            if (n == 1 && hashMap.get(string) == 0) {
                hashMap2.put(string, n3);
                continue;
            }
            if (hashMap.get(string) >= n2) continue;
            hashMap3.put(string, n3);
        }
        String string = null;
        if (!hashMap2.isEmpty()) {
            string = ItemPickerJava.getDistribInHashMap(hashMap2);
        } else if (!hashMap3.isEmpty()) {
            string = ItemPickerJava.getDistribInHashMap(hashMap3);
        }
        if (string == null) {
            return;
        }
        object = (ItemPickerContainer)ProceduralDistributions.get((Object)string);
        if (object == null) {
            return;
        }
        if (((ItemPickerContainer)object).junk != null) {
            ItemPickerJava.doRollItem(((ItemPickerContainer)object).junk, itemContainer, f, isoGameCharacter, true, true, itemPickerRoom);
        }
        ItemPickerJava.doRollItem((ItemPickerContainer)object, itemContainer, f, isoGameCharacter, true, false, itemPickerRoom);
        hashMap.put(string, hashMap.get(string) + 1);
    }

    private static String getDistribInHashMap(HashMap<String, Integer> hashMap) {
        int n;
        int n2 = 0;
        int n3 = 0;
        for (String string : hashMap.keySet()) {
            n2 += hashMap.get(string).intValue();
        }
        if (n2 == -1) {
            n = Rand.Next(hashMap.size());
            Iterator<String> iterator = hashMap.keySet().iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                if (n4 == n) {
                    return iterator.next();
                }
                ++n4;
            }
        }
        n = Rand.Next(n2);
        for (String string : hashMap.keySet()) {
            int n5 = hashMap.get(string);
            if ((n3 += n5) < n) continue;
            return string;
        }
        return null;
    }

    public static void rollItem(ItemPickerContainer itemPickerContainer, ItemContainer itemContainer, boolean bl, IsoGameCharacter isoGameCharacter, ItemPickerRoom itemPickerRoom) {
        if (!GameClient.bClient && !GameServer.bServer) {
            player = IsoPlayer.getInstance();
        }
        if (itemPickerContainer != null && itemContainer != null) {
            float f = 0.0f;
            IsoMetaChunk isoMetaChunk = null;
            if (player != null && IsoWorld.instance != null) {
                isoMetaChunk = IsoWorld.instance.getMetaChunk((int)player.getX() / 10, (int)player.getY() / 10);
            } else if (itemContainer.getSourceGrid() != null) {
                isoMetaChunk = IsoWorld.instance.getMetaChunk(itemContainer.getSourceGrid().getX() / 10, itemContainer.getSourceGrid().getY() / 10);
            }
            if (isoMetaChunk != null) {
                f = isoMetaChunk.getLootZombieIntensity();
            }
            if (f > zombieDensityCap) {
                f = zombieDensityCap;
            }
            if (itemPickerContainer.ignoreZombieDensity) {
                f = 0.0f;
            }
            if (itemPickerContainer.procedural) {
                ItemPickerJava.rollProceduralItem(itemPickerContainer.proceduralItems, itemContainer, f, isoGameCharacter, itemPickerRoom);
            } else {
                if (itemPickerContainer.junk != null) {
                    ItemPickerJava.doRollItem(itemPickerContainer.junk, itemContainer, f, isoGameCharacter, bl, true, itemPickerRoom);
                }
                ItemPickerJava.doRollItem(itemPickerContainer, itemContainer, f, isoGameCharacter, bl, false, itemPickerRoom);
            }
        }
    }

    public static void doRollItem(ItemPickerContainer itemPickerContainer, ItemContainer itemContainer, float f, IsoGameCharacter isoGameCharacter, boolean bl, boolean bl2, ItemPickerRoom itemPickerRoom) {
        boolean bl3 = false;
        boolean bl4 = false;
        String string = "";
        if (player != null && isoGameCharacter != null) {
            bl3 = isoGameCharacter.Traits.Lucky.isSet();
            bl4 = isoGameCharacter.Traits.Unlucky.isSet();
        }
        int n = 0;
        while ((float)n < itemPickerContainer.rolls) {
            ItemPickerItem[] itemPickerItemArray = itemPickerContainer.Items;
            for (int i = 0; i < itemPickerItemArray.length; ++i) {
                Object object;
                int n2;
                Object object2;
                float f2;
                ItemPickerItem itemPickerItem = itemPickerItemArray[i];
                float f3 = itemPickerItem.chance;
                string = itemPickerItem.itemName;
                if (bl3) {
                    f3 *= 1.1f;
                }
                if (bl4) {
                    f3 *= 0.9f;
                }
                if ((f2 = ItemPickerJava.getLootModifier(string)) == 0.0f) {
                    return;
                }
                if (bl2) {
                    f = 0.0f;
                    f2 = 1.0f;
                    f3 = (float)((double)f3 * 1.4);
                }
                if (!((float)Rand.Next(10000) <= f3 * 100.0f * f2 + f * 10.0f)) continue;
                InventoryItem inventoryItem = ItemPickerJava.tryAddItemToContainer(itemContainer, string, itemPickerContainer);
                if (inventoryItem == null) {
                    return;
                }
                ItemPickerJava.checkStashItem(inventoryItem, itemPickerContainer);
                if (itemContainer.getType().equals("freezer") && inventoryItem instanceof Food && ((Food)inventoryItem).isFreezing()) {
                    ((Food)inventoryItem).freeze();
                }
                if (inventoryItem instanceof Key) {
                    object2 = (Key)inventoryItem;
                    ((Key)object2).takeKeyId();
                    if (itemContainer.getSourceGrid() != null && itemContainer.getSourceGrid().getBuilding() != null && itemContainer.getSourceGrid().getBuilding().getDef() != null) {
                        n2 = itemContainer.getSourceGrid().getBuilding().getDef().getKeySpawned();
                        if (n2 < 2) {
                            itemContainer.getSourceGrid().getBuilding().getDef().setKeySpawned(n2 + 1);
                        } else {
                            itemContainer.Remove(inventoryItem);
                        }
                    }
                }
                if ((object2 = inventoryItem.getScriptItem().getRecordedMediaCat()) != null) {
                    RecordedMedia recordedMedia = ZomboidRadio.getInstance().getRecordedMedia();
                    object = recordedMedia.getRandomFromCategory((String)object2);
                    if (object == null) {
                        itemContainer.Remove(inventoryItem);
                        if ("Home-VHS".equalsIgnoreCase((String)object2)) {
                            object = recordedMedia.getRandomFromCategory("Retail-VHS");
                            if (object == null) {
                                return;
                            }
                            inventoryItem = itemContainer.AddItem("Base.VHS_Retail");
                            if (inventoryItem == null) {
                                return;
                            }
                            inventoryItem.setRecordedMediaData((MediaData)object);
                        }
                        return;
                    }
                    inventoryItem.setRecordedMediaData((MediaData)object);
                }
                if (WeaponUpgradeMap.containsKey(inventoryItem.getType())) {
                    ItemPickerJava.DoWeaponUpgrade(inventoryItem);
                }
                if (!itemPickerContainer.noAutoAge) {
                    inventoryItem.setAutoAge();
                }
                n2 = 0;
                if (itemPickerRoom != null) {
                    n2 = itemPickerRoom.isShop;
                }
                if (n2 == 0 && Rand.Next(100) < 40 && inventoryItem instanceof DrainableComboItem) {
                    float f4 = 1.0f / ((DrainableComboItem)inventoryItem).getUseDelta();
                    ((DrainableComboItem)inventoryItem).setUsedDelta(Rand.Next(1.0f, f4 - 1.0f) * ((DrainableComboItem)inventoryItem).getUseDelta());
                }
                if (n2 == 0 && inventoryItem instanceof HandWeapon && Rand.Next(100) < 40) {
                    inventoryItem.setCondition(Rand.Next(1, inventoryItem.getConditionMax()));
                }
                if (inventoryItem instanceof HandWeapon && !itemPickerContainer.dontSpawnAmmo && Rand.Next(100) < 90) {
                    int n3 = 30;
                    HandWeapon handWeapon = (HandWeapon)inventoryItem;
                    if (Core.getInstance().getOptionReloadDifficulty() > 1 && !StringUtils.isNullOrEmpty(handWeapon.getMagazineType()) && Rand.Next(100) < 90) {
                        if (Rand.NextBool(3)) {
                            InventoryItem inventoryItem2 = itemContainer.AddItem(handWeapon.getMagazineType());
                            if (Rand.NextBool(5)) {
                                inventoryItem2.setCurrentAmmoCount(Rand.Next(1, inventoryItem2.getMaxAmmo()));
                            }
                            if (!Rand.NextBool(5)) {
                                inventoryItem2.setCurrentAmmoCount(inventoryItem2.getMaxAmmo());
                            }
                        } else {
                            if (!StringUtils.isNullOrWhitespace(handWeapon.getMagazineType())) {
                                handWeapon.setContainsClip(true);
                            }
                            if (Rand.NextBool(6)) {
                                handWeapon.setCurrentAmmoCount(Rand.Next(1, handWeapon.getMaxAmmo()));
                            } else {
                                n3 = Rand.Next(60, 100);
                            }
                        }
                        if (handWeapon.haveChamber()) {
                            handWeapon.setRoundChambered(true);
                        }
                    }
                    if (Core.getInstance().getOptionReloadDifficulty() == 1 || StringUtils.isNullOrEmpty(handWeapon.getMagazineType()) && Rand.Next(100) < 30) {
                        handWeapon.setCurrentAmmoCount(Rand.Next(1, handWeapon.getMaxAmmo()));
                        if (handWeapon.haveChamber()) {
                            handWeapon.setRoundChambered(true);
                        }
                    }
                    if (!StringUtils.isNullOrEmpty(handWeapon.getAmmoBox()) && Rand.Next(100) < n3) {
                        itemContainer.AddItem(handWeapon.getAmmoBox());
                    } else if (!StringUtils.isNullOrEmpty(handWeapon.getAmmoType()) && Rand.Next(100) < 50) {
                        itemContainer.AddItems(handWeapon.getAmmoType(), Rand.Next(1, 5));
                    }
                }
                if (!(inventoryItem instanceof InventoryContainer) || !containers.containsKey((Object)inventoryItem.getType())) continue;
                object = (ItemPickerContainer)containers.get((Object)inventoryItem.getType());
                if (!bl || Rand.Next(((ItemPickerContainer)object).fillRand) != 0) continue;
                ItemPickerJava.rollContainerItem((InventoryContainer)inventoryItem, isoGameCharacter, (ItemPickerContainer)containers.get((Object)inventoryItem.getType()));
            }
            ++n;
        }
    }

    private static void checkStashItem(InventoryItem inventoryItem, ItemPickerContainer itemPickerContainer) {
        if (itemPickerContainer.stashChance > 0 && inventoryItem instanceof MapItem && !StringUtils.isNullOrEmpty(((MapItem)inventoryItem).getMapID())) {
            inventoryItem.setStashChance(itemPickerContainer.stashChance);
        }
        StashSystem.checkStashItem(inventoryItem);
    }

    public static void rollContainerItem(InventoryContainer inventoryContainer, IsoGameCharacter isoGameCharacter, ItemPickerContainer itemPickerContainer) {
        if (itemPickerContainer != null) {
            ItemContainer itemContainer = inventoryContainer.getInventory();
            float f = 0.0f;
            IsoMetaChunk isoMetaChunk = null;
            if (player != null && IsoWorld.instance != null) {
                isoMetaChunk = IsoWorld.instance.getMetaChunk((int)player.getX() / 10, (int)player.getY() / 10);
            }
            if (isoMetaChunk != null) {
                f = isoMetaChunk.getLootZombieIntensity();
            }
            if (f > zombieDensityCap) {
                f = zombieDensityCap;
            }
            if (itemPickerContainer.ignoreZombieDensity) {
                f = 0.0f;
            }
            boolean bl = false;
            boolean bl2 = false;
            String string = "";
            if (player != null && isoGameCharacter != null) {
                bl = isoGameCharacter.Traits.Lucky.isSet();
                bl2 = isoGameCharacter.Traits.Unlucky.isSet();
            }
            int n = 0;
            while ((float)n < itemPickerContainer.rolls) {
                ItemPickerItem[] itemPickerItemArray = itemPickerContainer.Items;
                for (int i = 0; i < itemPickerItemArray.length; ++i) {
                    int n2;
                    ItemPickerItem itemPickerItem = itemPickerItemArray[i];
                    float f2 = itemPickerItem.chance;
                    string = itemPickerItem.itemName;
                    if (bl) {
                        f2 *= 1.1f;
                    }
                    if (bl2) {
                        f2 *= 0.9f;
                    }
                    float f3 = ItemPickerJava.getLootModifier(string);
                    if (!((float)Rand.Next(10000) <= f2 * 100.0f * f3 + f * 10.0f)) continue;
                    InventoryItem inventoryItem = ItemPickerJava.tryAddItemToContainer(itemContainer, string, itemPickerContainer);
                    if (inventoryItem == null) {
                        return;
                    }
                    MapItem mapItem = Type.tryCastTo(inventoryItem, MapItem.class);
                    if (mapItem != null && !StringUtils.isNullOrEmpty(mapItem.getMapID()) && itemPickerContainer.maxMap > 0) {
                        int n3 = 0;
                        for (n2 = 0; n2 < itemContainer.getItems().size(); ++n2) {
                            MapItem mapItem2 = Type.tryCastTo(itemContainer.getItems().get(n2), MapItem.class);
                            if (mapItem2 == null || StringUtils.isNullOrEmpty(mapItem2.getMapID())) continue;
                            ++n3;
                        }
                        if (n3 > itemPickerContainer.maxMap) {
                            itemContainer.Remove(inventoryItem);
                        }
                    }
                    ItemPickerJava.checkStashItem(inventoryItem, itemPickerContainer);
                    if (itemContainer.getType().equals("freezer") && inventoryItem instanceof Food && ((Food)inventoryItem).isFreezing()) {
                        ((Food)inventoryItem).freeze();
                    }
                    if (inventoryItem instanceof Key) {
                        Key key = (Key)inventoryItem;
                        key.takeKeyId();
                        if (itemContainer.getSourceGrid() != null && itemContainer.getSourceGrid().getBuilding() != null && itemContainer.getSourceGrid().getBuilding().getDef() != null) {
                            n2 = itemContainer.getSourceGrid().getBuilding().getDef().getKeySpawned();
                            if (n2 < 2) {
                                itemContainer.getSourceGrid().getBuilding().getDef().setKeySpawned(n2 + 1);
                            } else {
                                itemContainer.Remove(inventoryItem);
                            }
                        }
                    }
                    if (itemContainer.getType().equals("freezer")) continue;
                    inventoryItem.setAutoAge();
                }
                ++n;
            }
        }
    }

    private static void DoWeaponUpgrade(InventoryItem inventoryItem) {
        ItemPickerUpgradeWeapons itemPickerUpgradeWeapons = WeaponUpgradeMap.get(inventoryItem.getType());
        if (itemPickerUpgradeWeapons == null) {
            return;
        }
        if (itemPickerUpgradeWeapons.Upgrades.size() == 0) {
            return;
        }
        int n = Rand.Next(itemPickerUpgradeWeapons.Upgrades.size());
        for (int i = 0; i < n; ++i) {
            String string = PZArrayUtil.pickRandom(itemPickerUpgradeWeapons.Upgrades);
            InventoryItem inventoryItem2 = InventoryItemFactory.CreateItem(string);
            ((HandWeapon)inventoryItem).attachWeaponPart((WeaponPart)inventoryItem2);
        }
    }

    public static float getLootModifier(String string) {
        Item item = ScriptManager.instance.FindItem(string);
        if (item == null) {
            return 0.6f;
        }
        float f = OtherLootModifier;
        if (item.getType() == Item.Type.Food) {
            f = item.CannedFood ? CannedFoodLootModifier : FoodLootModifier;
        }
        if ("Ammo".equals(item.getDisplayCategory())) {
            f = AmmoLootModifier;
        }
        if (item.getType() == Item.Type.Weapon && !item.isRanged()) {
            f = WeaponLootModifier;
        }
        if (item.getType() == Item.Type.WeaponPart || item.getType() == Item.Type.Weapon && item.isRanged() || item.getType() == Item.Type.Normal && !StringUtils.isNullOrEmpty(item.getAmmoType())) {
            f = RangedWeaponLootModifier;
        }
        if (item.getType() == Item.Type.Literature) {
            f = LiteratureLootModifier;
        }
        if (item.Medical) {
            f = MedicalLootModifier;
        }
        if (item.SurvivalGear) {
            f = SurvivalGearsLootModifier;
        }
        if (item.MechanicsItem) {
            f = MechanicsLootModifier;
        }
        return f;
    }

    public static void updateOverlaySprite(IsoObject isoObject) {
        ContainerOverlays.instance.updateContainerOverlaySprite(isoObject);
    }

    public static void doOverlaySprite(IsoGridSquare isoGridSquare) {
        if (GameClient.bClient) {
            return;
        }
        if (isoGridSquare == null || isoGridSquare.getRoom() == null || isoGridSquare.isOverlayDone()) {
            return;
        }
        PZArrayList<IsoObject> pZArrayList = isoGridSquare.getObjects();
        for (int i = 0; i < pZArrayList.size(); ++i) {
            IsoObject isoObject = pZArrayList.get(i);
            if (isoObject != null && isoObject.getContainer() != null && !isoObject.getContainer().isExplored()) {
                ItemPickerJava.fillContainer(isoObject.getContainer(), IsoPlayer.getInstance());
                isoObject.getContainer().setExplored(true);
                if (GameServer.bServer) {
                    LuaManager.GlobalObject.sendItemsInContainer(isoObject, isoObject.getContainer());
                }
            }
            ItemPickerJava.updateOverlaySprite(isoObject);
        }
        isoGridSquare.setOverlayDone(true);
    }

    public static ItemPickerContainer getItemContainer(String string, String string2, String string3, boolean bl) {
        ItemPickerRoom itemPickerRoom = (ItemPickerRoom)rooms.get((Object)string);
        if (itemPickerRoom != null) {
            ItemPickerContainer itemPickerContainer = (ItemPickerContainer)itemPickerRoom.Containers.get((Object)string2);
            if (itemPickerContainer != null && itemPickerContainer.procedural) {
                ArrayList<ProceduralItem> arrayList = itemPickerContainer.proceduralItems;
                for (int i = 0; i < arrayList.size(); ++i) {
                    ProceduralItem proceduralItem = arrayList.get(i);
                    if (!string3.equals(proceduralItem.name)) continue;
                    ItemPickerContainer itemPickerContainer2 = (ItemPickerContainer)ProceduralDistributions.get((Object)string3);
                    if (itemPickerContainer2.junk != null && bl) {
                        return itemPickerContainer2.junk;
                    }
                    if (bl) continue;
                    return itemPickerContainer2;
                }
            }
            if (bl) {
                return itemPickerContainer.junk;
            }
            return itemPickerContainer;
        }
        return null;
    }

    static {
        zombieDensityCap = 8.0f;
        NoContainerFillRooms = new ArrayList();
        WeaponUpgrades = new ArrayList();
        WeaponUpgradeMap = new HashMap();
        rooms = new THashMap();
        containers = new THashMap();
        ProceduralDistributions = new THashMap();
        VehicleDistributions = new THashMap();
    }

    public static final class ItemPickerUpgradeWeapons {
        public String name;
        public ArrayList<String> Upgrades = new ArrayList();
    }

    public static final class ItemPickerContainer {
        public ItemPickerItem[] Items = new ItemPickerItem[0];
        public float rolls;
        public boolean noAutoAge;
        public int fillRand;
        public int maxMap;
        public int stashChance;
        public ItemPickerContainer junk;
        public boolean procedural;
        public boolean dontSpawnAmmo = false;
        public boolean ignoreZombieDensity = false;
        public ArrayList<ProceduralItem> proceduralItems;
    }

    public static final class ItemPickerRoom {
        public THashMap<String, ItemPickerContainer> Containers = new THashMap();
        public int fillRand;
        public boolean isShop;
        public String specificId = null;
    }

    public static final class VehicleDistribution {
        public ItemPickerRoom Normal;
        public final ArrayList<ItemPickerRoom> Specific = new ArrayList();
    }

    public static final class ItemPickerItem {
        public String itemName;
        public float chance;
    }

    public static final class ProceduralItem {
        public String name;
        public int min;
        public int max;
        public List<String> forceForItems;
        public List<String> forceForZones;
        public List<String> forceForTiles;
        public List<String> forceForRooms;
        public int weightChance;
    }
}

