/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.function.Predicate;
import se.krka.kahlua.integration.LuaReturn;
import se.krka.kahlua.vm.LuaClosure;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.SystemDisabler;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.core.Core;
import zombie.core.Rand;
import zombie.core.network.ByteBufferWriter;
import zombie.core.raknet.UdpConnection;
import zombie.debug.DebugLog;
import zombie.inventory.CompressIdenticalItems;
import zombie.inventory.InventoryItem;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemSoundManager;
import zombie.inventory.ItemType;
import zombie.inventory.types.AlarmClock;
import zombie.inventory.types.AlarmClockClothing;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Drainable;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Key;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoBarbecue;
import zombie.iso.objects.IsoCompost;
import zombie.iso.objects.IsoDeadBody;
import zombie.iso.objects.IsoFireplace;
import zombie.iso.objects.IsoMannequin;
import zombie.iso.objects.IsoStove;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.network.GameClient;
import zombie.network.PacketTypes;
import zombie.popman.ObjectPool;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.vehicles.BaseVehicle;
import zombie.vehicles.VehiclePart;

public final class ItemContainer {
    private static final ArrayList<InventoryItem> tempList = new ArrayList();
    private static final ArrayList<IsoObject> s_tempObjects = new ArrayList();
    public boolean active = false;
    private boolean dirty = true;
    public boolean IsDevice = false;
    public float ageFactor = 1.0f;
    public float CookingFactor = 1.0f;
    public int Capacity = 50;
    public InventoryItem containingItem = null;
    public ArrayList<InventoryItem> Items = new ArrayList();
    public ArrayList<InventoryItem> IncludingObsoleteItems = new ArrayList();
    public IsoObject parent = null;
    public IsoGridSquare SourceGrid = null;
    public VehiclePart vehiclePart = null;
    public InventoryContainer inventoryContainer = null;
    public boolean bExplored = false;
    public String type = "none";
    public int ID = 0;
    private boolean drawDirty = true;
    private float customTemperature = 0.0f;
    private boolean hasBeenLooted = false;
    private String openSound = null;
    private String closeSound = null;
    private String putSound = null;
    private String OnlyAcceptCategory = null;
    private String AcceptItemFunction = null;
    private int weightReduction = 0;
    private String containerPosition = null;
    private String freezerPosition = null;
    private static final ThreadLocal<Comparators> TL_comparators = ThreadLocal.withInitial(Comparators::new);
    private static final ThreadLocal<InventoryItemListPool> TL_itemListPool = ThreadLocal.withInitial(InventoryItemListPool::new);
    private static final ThreadLocal<Predicates> TL_predicates = ThreadLocal.withInitial(Predicates::new);

    public ItemContainer(int n, String string, IsoGridSquare isoGridSquare, IsoObject isoObject) {
        this.ID = n;
        this.parent = isoObject;
        this.type = string;
        this.SourceGrid = isoGridSquare;
        if (string.equals("fridge")) {
            this.ageFactor = 0.02f;
            this.CookingFactor = 0.0f;
        }
    }

    public ItemContainer(String string, IsoGridSquare isoGridSquare, IsoObject isoObject) {
        this.ID = -1;
        this.parent = isoObject;
        this.type = string;
        this.SourceGrid = isoGridSquare;
        if (string.equals("fridge")) {
            this.ageFactor = 0.02f;
            this.CookingFactor = 0.0f;
        }
    }

    public ItemContainer(int n) {
        this.ID = n;
    }

    public ItemContainer() {
        this.ID = -1;
    }

    public static float floatingPointCorrection(float f) {
        int n = 100;
        float f2 = f * (float)n;
        return (float)((int)(f2 - (float)((int)f2) >= 0.5f ? f2 + 1.0f : f2)) / (float)n;
    }

    public int getCapacity() {
        return this.Capacity;
    }

    public void setCapacity(int n) {
        this.Capacity = n;
    }

    public InventoryItem FindAndReturnWaterItem(int n) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            DrainableComboItem drainableComboItem;
            InventoryItem inventoryItem = this.getItems().get(i);
            if (!(inventoryItem instanceof DrainableComboItem) || !inventoryItem.isWaterSource() || (drainableComboItem = (DrainableComboItem)inventoryItem).getDrainableUsesInt() < n) continue;
            return inventoryItem;
        }
        return null;
    }

    public InventoryItem getItemFromTypeRecurse(String string) {
        return this.getFirstTypeRecurse(string);
    }

    public int getEffectiveCapacity(IsoGameCharacter isoGameCharacter) {
        if (!(isoGameCharacter == null || this.parent instanceof IsoGameCharacter || this.parent instanceof IsoDeadBody || "floor".equals(this.getType()))) {
            if (isoGameCharacter.Traits.Organized.isSet()) {
                return (int)Math.max((float)this.Capacity * 1.3f, (float)(this.Capacity + 1));
            }
            if (isoGameCharacter.Traits.Disorganized.isSet()) {
                return (int)Math.max((float)this.Capacity * 0.7f, 1.0f);
            }
        }
        return this.Capacity;
    }

    public boolean hasRoomFor(IsoGameCharacter isoGameCharacter, InventoryItem inventoryItem) {
        if (this.vehiclePart != null && this.vehiclePart.getId().contains("Seat") && this.Items.isEmpty() && inventoryItem.getUnequippedWeight() <= 50.0f) {
            return true;
        }
        if (ItemContainer.floatingPointCorrection(this.getCapacityWeight()) + inventoryItem.getUnequippedWeight() <= (float)this.getEffectiveCapacity(isoGameCharacter)) {
            if (this.getContainingItem() != null && this.getContainingItem().getEquipParent() != null && this.getContainingItem().getEquipParent().getInventory() != null && !this.getContainingItem().getEquipParent().getInventory().contains(inventoryItem)) {
                return ItemContainer.floatingPointCorrection(this.getContainingItem().getEquipParent().getInventory().getCapacityWeight()) + inventoryItem.getUnequippedWeight() <= (float)this.getContainingItem().getEquipParent().getInventory().getEffectiveCapacity(isoGameCharacter);
            }
            return true;
        }
        return false;
    }

    public boolean hasRoomFor(IsoGameCharacter isoGameCharacter, float f) {
        return ItemContainer.floatingPointCorrection(this.getCapacityWeight()) + f <= (float)this.getEffectiveCapacity(isoGameCharacter);
    }

    public boolean isItemAllowed(InventoryItem inventoryItem) {
        Boolean bl;
        Object object;
        if (inventoryItem == null) {
            return false;
        }
        String string = this.getOnlyAcceptCategory();
        if (string != null && !string.equalsIgnoreCase(inventoryItem.getCategory())) {
            return false;
        }
        String string2 = this.getAcceptItemFunction();
        if (string2 != null && (object = LuaManager.getFunctionObject(string2)) != null && (bl = LuaManager.caller.protectedCallBoolean(LuaManager.thread, object, this, inventoryItem)) != Boolean.TRUE) {
            return false;
        }
        if (this.parent != null && !this.parent.isItemAllowedInContainer(this, inventoryItem)) {
            return false;
        }
        if (this.getType().equals("clothingrack") && !(inventoryItem instanceof Clothing)) {
            return false;
        }
        if (this.getParent() != null && this.getParent().getProperties() != null && this.getParent().getProperties().Val("CustomName") != null && this.getParent().getProperties().Val("CustomName").equals("Toaster") && !inventoryItem.hasTag("FitsToaster")) {
            return false;
        }
        if (this.getParent() != null && this.getParent().getProperties() != null && this.getParent().getProperties().Val("GroupName") != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.getParent().getProperties().Val("GroupName").equals("Coffee") || this.getParent().getProperties().Val("GroupName").equals("Espresso");
            if (bl2 && !inventoryItem.hasTag("CoffeeMaker")) {
                return false;
            }
        }
        return true;
    }

    public boolean isRemoveItemAllowed(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return false;
        }
        return this.parent == null || this.parent.isRemoveItemAllowedFromContainer(this, inventoryItem);
    }

    public boolean isExplored() {
        return this.bExplored;
    }

    public void setExplored(boolean bl) {
        this.bExplored = bl;
    }

    public boolean isInCharacterInventory(IsoGameCharacter isoGameCharacter) {
        if (isoGameCharacter.getInventory() == this) {
            return true;
        }
        if (this.containingItem != null) {
            if (isoGameCharacter.getInventory().contains(this.containingItem, true)) {
                return true;
            }
            if (this.containingItem.getContainer() != null) {
                return this.containingItem.getContainer().isInCharacterInventory(isoGameCharacter);
            }
        }
        return false;
    }

    public boolean isInside(InventoryItem inventoryItem) {
        if (this.containingItem == null) {
            return false;
        }
        if (this.containingItem == inventoryItem) {
            return true;
        }
        return this.containingItem.getContainer() != null && this.containingItem.getContainer().isInside(inventoryItem);
    }

    public InventoryItem getContainingItem() {
        return this.containingItem;
    }

    public InventoryItem DoAddItem(InventoryItem inventoryItem) {
        return this.AddItem(inventoryItem);
    }

    public InventoryItem DoAddItemBlind(InventoryItem inventoryItem) {
        return this.AddItem(inventoryItem);
    }

    public ArrayList<InventoryItem> AddItems(String string, int n) {
        ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
        for (int i = 0; i < n; ++i) {
            InventoryItem inventoryItem = this.AddItem(string);
            if (inventoryItem == null) continue;
            arrayList.add(inventoryItem);
        }
        return arrayList;
    }

    public void AddItems(InventoryItem inventoryItem, int n) {
        for (int i = 0; i < n; ++i) {
            this.AddItem(inventoryItem.getFullType());
        }
    }

    public int getNumberOfItem(String string, boolean bl) {
        return this.getNumberOfItem(string, bl, false);
    }

    public int getNumberOfItem(String string) {
        return this.getNumberOfItem(string, false);
    }

    public int getNumberOfItem(String string, boolean bl, ArrayList<ItemContainer> arrayList) {
        int n = this.getNumberOfItem(string, bl);
        if (arrayList != null) {
            for (ItemContainer itemContainer : arrayList) {
                if (itemContainer == this) continue;
                n += itemContainer.getNumberOfItem(string, bl);
            }
        }
        return n;
    }

    public int getNumberOfItem(String string, boolean bl, boolean bl2) {
        int n = 0;
        for (int i = 0; i < this.Items.size(); ++i) {
            DrainableComboItem drainableComboItem;
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.getFullType().equals(string) || inventoryItem.getType().equals(string)) {
                ++n;
                continue;
            }
            if (bl2 && inventoryItem instanceof InventoryContainer) {
                n += ((InventoryContainer)inventoryItem).getItemContainer().getNumberOfItem(string);
                continue;
            }
            if (!bl || !(inventoryItem instanceof DrainableComboItem) || ((DrainableComboItem)inventoryItem).getReplaceOnDeplete() == null || !(drainableComboItem = (DrainableComboItem)inventoryItem).getReplaceOnDepleteFullType().equals(string) && !drainableComboItem.getReplaceOnDeplete().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public InventoryItem addItem(InventoryItem inventoryItem) {
        return this.AddItem(inventoryItem);
    }

    public InventoryItem AddItem(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return null;
        }
        if (this.containsID(inventoryItem.id)) {
            System.out.println("Error, container already has id");
            return this.getItemWithID(inventoryItem.id);
        }
        this.drawDirty = true;
        if (this.parent != null) {
            this.dirty = true;
        }
        if (this.parent != null && !(this.parent instanceof IsoGameCharacter)) {
            this.parent.DirtySlice();
        }
        if (inventoryItem.container != null) {
            inventoryItem.container.Remove(inventoryItem);
        }
        inventoryItem.container = this;
        this.Items.add(inventoryItem);
        if (IsoWorld.instance.CurrentCell != null) {
            IsoWorld.instance.CurrentCell.addToProcessItems(inventoryItem);
        }
        return inventoryItem;
    }

    public InventoryItem AddItemBlind(InventoryItem inventoryItem) {
        if (inventoryItem == null) {
            return null;
        }
        if (inventoryItem.getWeight() + this.getCapacityWeight() > (float)this.getCapacity()) {
            return null;
        }
        if (this.parent != null && !(this.parent instanceof IsoGameCharacter)) {
            this.parent.DirtySlice();
        }
        this.Items.add(inventoryItem);
        return inventoryItem;
    }

    public InventoryItem AddItem(String string) {
        Item item;
        this.drawDirty = true;
        if (this.parent != null && !(this.parent instanceof IsoGameCharacter)) {
            this.dirty = true;
        }
        if ((item = ScriptManager.instance.FindItem(string)) == null) {
            DebugLog.log("ERROR: ItemContainer.AddItem: can't find " + string);
            return null;
        }
        if (item.OBSOLETE) {
            return null;
        }
        InventoryItem inventoryItem = null;
        int n = item.getCount();
        for (int i = 0; i < n; ++i) {
            inventoryItem = InventoryItemFactory.CreateItem(string);
            if (inventoryItem == null) {
                return null;
            }
            inventoryItem.container = this;
            this.Items.add(inventoryItem);
            if (inventoryItem instanceof Food) {
                ((Food)inventoryItem).setHeat(this.getTemprature());
            }
            if (IsoWorld.instance.CurrentCell == null) continue;
            IsoWorld.instance.CurrentCell.addToProcessItems(inventoryItem);
        }
        return inventoryItem;
    }

    public boolean AddItem(String string, float f) {
        InventoryItem inventoryItem;
        this.drawDirty = true;
        if (this.parent != null && !(this.parent instanceof IsoGameCharacter)) {
            this.dirty = true;
        }
        if ((inventoryItem = InventoryItemFactory.CreateItem(string)) == null) {
            return false;
        }
        if (inventoryItem instanceof Drainable) {
            ((Drainable)((Object)inventoryItem)).setUsedDelta(f);
        }
        inventoryItem.container = this;
        this.Items.add(inventoryItem);
        return true;
    }

    public boolean contains(InventoryItem inventoryItem) {
        return this.Items.contains(inventoryItem);
    }

    public boolean containsWithModule(String string) {
        return this.containsWithModule(string, false);
    }

    public boolean containsWithModule(String string, boolean bl) {
        String string2 = string;
        String string3 = "Base";
        if (string.contains(".")) {
            string3 = string.split("\\.")[0];
            string2 = string.split("\\.")[1];
        }
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem == null) {
                this.Items.remove(i);
                --i;
                continue;
            }
            if (!inventoryItem.type.equals(string2.trim()) || !string3.equals(inventoryItem.getModule()) || bl && inventoryItem instanceof DrainableComboItem && ((DrainableComboItem)inventoryItem).getUsedDelta() <= 0.0f) continue;
            return true;
        }
        return false;
    }

    public void removeItemOnServer(InventoryItem inventoryItem) {
        if (GameClient.bClient) {
            if (this.containingItem != null && this.containingItem.getWorldItem() != null) {
                GameClient.instance.addToItemRemoveSendBuffer(this.containingItem.getWorldItem(), this, inventoryItem);
            } else {
                GameClient.instance.addToItemRemoveSendBuffer(this.parent, this, inventoryItem);
            }
        }
    }

    public void addItemOnServer(InventoryItem inventoryItem) {
        if (GameClient.bClient) {
            if (this.containingItem != null && this.containingItem.getWorldItem() != null) {
                GameClient.instance.addToItemSendBuffer(this.containingItem.getWorldItem(), this, inventoryItem);
            } else {
                GameClient.instance.addToItemSendBuffer(this.parent, this, inventoryItem);
            }
        }
    }

    public boolean contains(InventoryItem inventoryItem, boolean bl) {
        Object object;
        int n;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        for (n = 0; n < this.Items.size(); ++n) {
            object = this.Items.get(n);
            if (object == null) {
                this.Items.remove(n);
                --n;
                continue;
            }
            if (object == inventoryItem) {
                TL_itemListPool.get().release(inventoryItemList);
                return true;
            }
            if (!bl || !(object instanceof InventoryContainer) || ((InventoryContainer)object).getInventory() == null || inventoryItemList.contains(object)) continue;
            inventoryItemList.add(object);
        }
        for (n = 0; n < inventoryItemList.size(); ++n) {
            object = ((InventoryContainer)inventoryItemList.get(n)).getInventory();
            if (!((ItemContainer)object).contains(inventoryItem, bl)) continue;
            TL_itemListPool.get().release(inventoryItemList);
            return true;
        }
        TL_itemListPool.get().release(inventoryItemList);
        return false;
    }

    public boolean contains(String string, boolean bl) {
        return this.contains(string, bl, false);
    }

    public boolean containsType(String string) {
        return this.contains(string, false, false);
    }

    public boolean containsTypeRecurse(String string) {
        return this.contains(string, true, false);
    }

    private boolean testBroken(boolean bl, InventoryItem inventoryItem) {
        if (!bl) {
            return true;
        }
        return !inventoryItem.isBroken();
    }

    public boolean contains(String string, boolean bl, boolean bl2) {
        Object object;
        int n;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        if (string.contains("Type:")) {
            for (n = 0; n < this.Items.size(); ++n) {
                object = this.Items.get(n);
                if (string.contains("Food") && object instanceof Food) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return true;
                }
                if (string.contains("Weapon") && object instanceof HandWeapon && this.testBroken(bl2, (InventoryItem)object)) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return true;
                }
                if (string.contains("AlarmClock") && object instanceof AlarmClock) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return true;
                }
                if (string.contains("AlarmClockClothing") && object instanceof AlarmClockClothing) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return true;
                }
                if (!bl || !(object instanceof InventoryContainer) || ((InventoryContainer)object).getInventory() == null || inventoryItemList.contains(object)) continue;
                inventoryItemList.add(object);
            }
        } else if (string.contains("/")) {
            String[] stringArray = string.split("/");
            for (String string2 : stringArray) {
                for (int i = 0; i < this.Items.size(); ++i) {
                    InventoryItem inventoryItem = this.Items.get(i);
                    if (ItemContainer.compareType(string2.trim(), inventoryItem) && this.testBroken(bl2, inventoryItem)) {
                        TL_itemListPool.get().release(inventoryItemList);
                        return true;
                    }
                    if (!bl || !(inventoryItem instanceof InventoryContainer) || ((InventoryContainer)inventoryItem).getInventory() == null || inventoryItemList.contains(inventoryItem)) continue;
                    inventoryItemList.add(inventoryItem);
                }
            }
        } else {
            for (int i = 0; i < this.Items.size(); ++i) {
                object = this.Items.get(i);
                if (object == null) {
                    this.Items.remove(i);
                    --i;
                    continue;
                }
                if (ItemContainer.compareType(string.trim(), (InventoryItem)object) && this.testBroken(bl2, (InventoryItem)object)) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return true;
                }
                if (!bl || !(object instanceof InventoryContainer) || ((InventoryContainer)object).getInventory() == null || inventoryItemList.contains(object)) continue;
                inventoryItemList.add(object);
            }
        }
        for (n = 0; n < inventoryItemList.size(); ++n) {
            object = ((InventoryContainer)inventoryItemList.get(n)).getInventory();
            if (!((ItemContainer)object).contains(string, bl, bl2)) continue;
            TL_itemListPool.get().release(inventoryItemList);
            return true;
        }
        TL_itemListPool.get().release(inventoryItemList);
        return false;
    }

    public boolean contains(String string) {
        return this.contains(string, false);
    }

    private static InventoryItem getBestOf(InventoryItemList inventoryItemList, Comparator<InventoryItem> comparator) {
        if (inventoryItemList == null || inventoryItemList.isEmpty()) {
            return null;
        }
        InventoryItem inventoryItem = (InventoryItem)inventoryItemList.get(0);
        for (int i = 1; i < inventoryItemList.size(); ++i) {
            InventoryItem inventoryItem2 = (InventoryItem)inventoryItemList.get(i);
            if (comparator.compare(inventoryItem2, inventoryItem) <= 0) continue;
            inventoryItem = inventoryItem2;
        }
        return inventoryItem;
    }

    public InventoryItem getBest(Predicate<InventoryItem> predicate, Comparator<InventoryItem> comparator) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAll(predicate, inventoryItemList);
        InventoryItem inventoryItem = ItemContainer.getBestOf(inventoryItemList, comparator);
        TL_itemListPool.get().release(inventoryItemList);
        return inventoryItem;
    }

    public InventoryItem getBestRecurse(Predicate<InventoryItem> predicate, Comparator<InventoryItem> comparator) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAllRecurse(predicate, inventoryItemList);
        InventoryItem inventoryItem = ItemContainer.getBestOf(inventoryItemList, comparator);
        TL_itemListPool.get().release(inventoryItemList);
        return inventoryItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestType(String string, Comparator<InventoryItem> comparator) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        try {
            InventoryItem inventoryItem = this.getBest(typePredicate, comparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestTypeRecurse(String string, Comparator<InventoryItem> comparator) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        try {
            InventoryItem inventoryItem = this.getBestRecurse(typePredicate, comparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestEval(LuaClosure luaClosure, LuaClosure luaClosure2) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        EvalComparator evalComparator = ItemContainer.TL_comparators.get().eval.alloc().init(luaClosure2);
        try {
            InventoryItem inventoryItem = this.getBest(evalPredicate, evalComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().eval.release(evalPredicate);
            ItemContainer.TL_comparators.get().eval.release(evalComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestEvalRecurse(LuaClosure luaClosure, LuaClosure luaClosure2) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        EvalComparator evalComparator = ItemContainer.TL_comparators.get().eval.alloc().init(luaClosure2);
        try {
            InventoryItem inventoryItem = this.getBestRecurse(evalPredicate, evalComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().eval.release(evalPredicate);
            ItemContainer.TL_comparators.get().eval.release(evalComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestEvalArg(LuaClosure luaClosure, LuaClosure luaClosure2, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        EvalArgComparator evalArgComparator = ItemContainer.TL_comparators.get().evalArg.alloc().init(luaClosure2, object);
        try {
            InventoryItem inventoryItem = this.getBest(evalArgPredicate, evalArgComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
            ItemContainer.TL_comparators.get().evalArg.release(evalArgComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestEvalArgRecurse(LuaClosure luaClosure, LuaClosure luaClosure2, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        EvalArgComparator evalArgComparator = ItemContainer.TL_comparators.get().evalArg.alloc().init(luaClosure2, object);
        try {
            InventoryItem inventoryItem = this.getBestRecurse(evalArgPredicate, evalArgComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
            ItemContainer.TL_comparators.get().evalArg.release(evalArgComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestTypeEval(String string, LuaClosure luaClosure) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        EvalComparator evalComparator = ItemContainer.TL_comparators.get().eval.alloc().init(luaClosure);
        try {
            InventoryItem inventoryItem = this.getBest(typePredicate, evalComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
            ItemContainer.TL_comparators.get().eval.release(evalComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestTypeEvalRecurse(String string, LuaClosure luaClosure) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        EvalComparator evalComparator = ItemContainer.TL_comparators.get().eval.alloc().init(luaClosure);
        try {
            InventoryItem inventoryItem = this.getBestRecurse(typePredicate, evalComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
            ItemContainer.TL_comparators.get().eval.release(evalComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestTypeEvalArg(String string, LuaClosure luaClosure, Object object) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        EvalArgComparator evalArgComparator = ItemContainer.TL_comparators.get().evalArg.alloc().init(luaClosure, object);
        try {
            InventoryItem inventoryItem = this.getBest(typePredicate, evalArgComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
            ItemContainer.TL_comparators.get().evalArg.release(evalArgComparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InventoryItem getBestTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        EvalArgComparator evalArgComparator = ItemContainer.TL_comparators.get().evalArg.alloc().init(luaClosure, object);
        try {
            InventoryItem inventoryItem = this.getBestRecurse(typePredicate, evalArgComparator);
            return inventoryItem;
        }
        finally {
            ItemContainer.TL_predicates.get().type.release(typePredicate);
            ItemContainer.TL_comparators.get().evalArg.release(evalArgComparator);
        }
    }

    public InventoryItem getBestCondition(Predicate<InventoryItem> predicate) {
        ConditionComparator conditionComparator = ItemContainer.TL_comparators.get().condition.alloc();
        InventoryItem inventoryItem = this.getBest(predicate, conditionComparator);
        ItemContainer.TL_comparators.get().condition.release(conditionComparator);
        if (inventoryItem != null && inventoryItem.getCondition() <= 0) {
            inventoryItem = null;
        }
        return inventoryItem;
    }

    public InventoryItem getBestConditionRecurse(Predicate<InventoryItem> predicate) {
        ConditionComparator conditionComparator = ItemContainer.TL_comparators.get().condition.alloc();
        InventoryItem inventoryItem = this.getBestRecurse(predicate, conditionComparator);
        ItemContainer.TL_comparators.get().condition.release(conditionComparator);
        if (inventoryItem != null && inventoryItem.getCondition() <= 0) {
            inventoryItem = null;
        }
        return inventoryItem;
    }

    public InventoryItem getBestCondition(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        InventoryItem inventoryItem = this.getBestCondition(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return inventoryItem;
    }

    public InventoryItem getBestConditionRecurse(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        InventoryItem inventoryItem = this.getBestConditionRecurse(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return inventoryItem;
    }

    public InventoryItem getBestConditionEval(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        InventoryItem inventoryItem = this.getBestCondition(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return inventoryItem;
    }

    public InventoryItem getBestConditionEvalRecurse(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        InventoryItem inventoryItem = this.getBestConditionRecurse(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return inventoryItem;
    }

    public InventoryItem getBestConditionEvalArg(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        InventoryItem inventoryItem = this.getBestCondition(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return inventoryItem;
    }

    public InventoryItem getBestConditionEvalArgRecurse(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        InventoryItem inventoryItem = this.getBestConditionRecurse(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstEval(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        InventoryItem inventoryItem = this.getFirst(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstEvalArg(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        InventoryItem inventoryItem = this.getFirst(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return inventoryItem;
    }

    public boolean containsEval(LuaClosure luaClosure) {
        return this.getFirstEval(luaClosure) != null;
    }

    public boolean containsEvalArg(LuaClosure luaClosure, Object object) {
        return this.getFirstEvalArg(luaClosure, object) != null;
    }

    public boolean containsEvalRecurse(LuaClosure luaClosure) {
        return this.getFirstEvalRecurse(luaClosure) != null;
    }

    public boolean containsEvalArgRecurse(LuaClosure luaClosure, Object object) {
        return this.getFirstEvalArgRecurse(luaClosure, object) != null;
    }

    public boolean containsTag(String string) {
        return this.getFirstTag(string) != null;
    }

    public boolean containsTagEval(String string, LuaClosure luaClosure) {
        return this.getFirstTagEval(string, luaClosure) != null;
    }

    public boolean containsTagRecurse(String string) {
        return this.getFirstTagRecurse(string) != null;
    }

    public boolean containsTagEvalRecurse(String string, LuaClosure luaClosure) {
        return this.getFirstTagEvalRecurse(string, luaClosure) != null;
    }

    public boolean containsTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        return this.getFirstTagEvalArgRecurse(string, luaClosure, object) != null;
    }

    public boolean containsTypeEvalRecurse(String string, LuaClosure luaClosure) {
        return this.getFirstTypeEvalRecurse(string, luaClosure) != null;
    }

    public boolean containsTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        return this.getFirstTypeEvalArgRecurse(string, luaClosure, object) != null;
    }

    private static boolean compareType(String string, String string2) {
        if (string != null && string.contains("/")) {
            int n = string.indexOf(string2);
            if (n == -1) {
                return false;
            }
            char c = n > 0 ? string.charAt(n - 1) : (char)'\u0000';
            char c2 = n + string2.length() < string.length() ? string.charAt(n + string2.length()) : (char)'\u0000';
            return c == '\u0000' && c2 == '/' || c == '/' && c2 == '\u0000' || c == '/' && c2 == '/';
        }
        return string.equals(string2);
    }

    private static boolean compareType(String string, InventoryItem inventoryItem) {
        if (string != null && string.indexOf(46) == -1) {
            return ItemContainer.compareType(string, inventoryItem.getType());
        }
        return ItemContainer.compareType(string, inventoryItem.getFullType()) || ItemContainer.compareType(string, inventoryItem.getType());
    }

    public InventoryItem getFirst(Predicate<InventoryItem> predicate) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem == null) {
                this.Items.remove(i);
                --i;
                continue;
            }
            if (!predicate.test(inventoryItem)) continue;
            return inventoryItem;
        }
        return null;
    }

    public InventoryItem getFirstRecurse(Predicate<InventoryItem> predicate) {
        Object object;
        int n;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        for (n = 0; n < this.Items.size(); ++n) {
            object = this.Items.get(n);
            if (object == null) {
                this.Items.remove(n);
                --n;
                continue;
            }
            if (predicate.test((InventoryItem)object)) {
                TL_itemListPool.get().release(inventoryItemList);
                return object;
            }
            if (!(object instanceof InventoryContainer)) continue;
            inventoryItemList.add(object);
        }
        for (n = 0; n < inventoryItemList.size(); ++n) {
            object = ((InventoryContainer)inventoryItemList.get(n)).getInventory();
            InventoryItem inventoryItem = ((ItemContainer)object).getFirstRecurse(predicate);
            if (inventoryItem == null) continue;
            TL_itemListPool.get().release(inventoryItemList);
            return inventoryItem;
        }
        TL_itemListPool.get().release(inventoryItemList);
        return null;
    }

    public ArrayList<InventoryItem> getSome(Predicate<InventoryItem> predicate, int n, ArrayList<InventoryItem> arrayList) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem == null) {
                this.Items.remove(i);
                --i;
                continue;
            }
            if (!predicate.test(inventoryItem)) continue;
            arrayList.add(inventoryItem);
            if (arrayList.size() >= n) break;
        }
        return arrayList;
    }

    public ArrayList<InventoryItem> getSomeRecurse(Predicate<InventoryItem> predicate, int n, ArrayList<InventoryItem> arrayList) {
        Object object;
        int n2;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        for (n2 = 0; n2 < this.Items.size(); ++n2) {
            object = this.Items.get(n2);
            if (object == null) {
                this.Items.remove(n2);
                --n2;
                continue;
            }
            if (predicate.test((InventoryItem)object)) {
                arrayList.add((InventoryItem)object);
                if (arrayList.size() >= n) {
                    TL_itemListPool.get().release(inventoryItemList);
                    return arrayList;
                }
            }
            if (!(object instanceof InventoryContainer)) continue;
            inventoryItemList.add(object);
        }
        for (n2 = 0; n2 < inventoryItemList.size(); ++n2) {
            object = ((InventoryContainer)inventoryItemList.get(n2)).getInventory();
            ((ItemContainer)object).getSomeRecurse(predicate, n, arrayList);
            if (arrayList.size() >= n) break;
        }
        TL_itemListPool.get().release(inventoryItemList);
        return arrayList;
    }

    public ArrayList<InventoryItem> getAll(Predicate<InventoryItem> predicate, ArrayList<InventoryItem> arrayList) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem == null) {
                this.Items.remove(i);
                --i;
                continue;
            }
            if (!predicate.test(inventoryItem)) continue;
            arrayList.add(inventoryItem);
        }
        return arrayList;
    }

    public ArrayList<InventoryItem> getAllRecurse(Predicate<InventoryItem> predicate, ArrayList<InventoryItem> arrayList) {
        Object object;
        int n;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        for (n = 0; n < this.Items.size(); ++n) {
            object = this.Items.get(n);
            if (object == null) {
                this.Items.remove(n);
                --n;
                continue;
            }
            if (predicate.test((InventoryItem)object)) {
                arrayList.add((InventoryItem)object);
            }
            if (!(object instanceof InventoryContainer)) continue;
            inventoryItemList.add(object);
        }
        for (n = 0; n < inventoryItemList.size(); ++n) {
            object = ((InventoryContainer)inventoryItemList.get(n)).getInventory();
            ((ItemContainer)object).getAllRecurse(predicate, arrayList);
        }
        TL_itemListPool.get().release(inventoryItemList);
        return arrayList;
    }

    public int getCount(Predicate<InventoryItem> predicate) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAll(predicate, inventoryItemList);
        int n = inventoryItemList.size();
        TL_itemListPool.get().release(inventoryItemList);
        return n;
    }

    public int getCountRecurse(Predicate<InventoryItem> predicate) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAllRecurse(predicate, inventoryItemList);
        int n = inventoryItemList.size();
        TL_itemListPool.get().release(inventoryItemList);
        return n;
    }

    public int getCountTag(String string) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        int n = this.getCount(tagPredicate);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return n;
    }

    public int getCountTagEval(String string, LuaClosure luaClosure) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        int n = this.getCount(tagEvalPredicate);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return n;
    }

    public int getCountTagEvalArg(String string, LuaClosure luaClosure, Object object) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        int n = this.getCount(tagEvalArgPredicate);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return n;
    }

    public int getCountTagRecurse(String string) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        int n = this.getCountRecurse(tagPredicate);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return n;
    }

    public int getCountTagEvalRecurse(String string, LuaClosure luaClosure) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        int n = this.getCountRecurse(tagEvalPredicate);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return n;
    }

    public int getCountTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        int n = this.getCountRecurse(tagEvalArgPredicate);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return n;
    }

    public int getCountType(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        int n = this.getCount(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return n;
    }

    public int getCountTypeEval(String string, LuaClosure luaClosure) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        int n = this.getCount(typeEvalPredicate);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return n;
    }

    public int getCountTypeEvalArg(String string, LuaClosure luaClosure, Object object) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        int n = this.getCount(typeEvalArgPredicate);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return n;
    }

    public int getCountTypeRecurse(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        int n = this.getCountRecurse(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return n;
    }

    public int getCountTypeEvalRecurse(String string, LuaClosure luaClosure) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        int n = this.getCountRecurse(typeEvalPredicate);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return n;
    }

    public int getCountTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        int n = this.getCountRecurse(typeEvalArgPredicate);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return n;
    }

    public int getCountEval(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        int n = this.getCount(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return n;
    }

    public int getCountEvalArg(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        int n = this.getCount(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return n;
    }

    public int getCountEvalRecurse(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        int n = this.getCountRecurse(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return n;
    }

    public int getCountEvalArgRecurse(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        int n = this.getCountRecurse(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return n;
    }

    public InventoryItem getFirstCategory(String string) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        InventoryItem inventoryItem = this.getFirst(categoryPredicate);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstCategoryRecurse(String string) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        InventoryItem inventoryItem = this.getFirstRecurse(categoryPredicate);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstEvalRecurse(LuaClosure luaClosure) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        InventoryItem inventoryItem = this.getFirstRecurse(evalPredicate);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstEvalArgRecurse(LuaClosure luaClosure, Object object) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        InventoryItem inventoryItem = this.getFirstRecurse(evalArgPredicate);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTag(String string) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        InventoryItem inventoryItem = this.getFirst(tagPredicate);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTagRecurse(String string) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        InventoryItem inventoryItem = this.getFirstRecurse(tagPredicate);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTagEval(String string, LuaClosure luaClosure) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        InventoryItem inventoryItem = this.getFirstRecurse(tagEvalPredicate);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTagEvalRecurse(String string, LuaClosure luaClosure) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        InventoryItem inventoryItem = this.getFirstRecurse(tagEvalPredicate);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        InventoryItem inventoryItem = this.getFirstRecurse(tagEvalArgPredicate);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstType(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        InventoryItem inventoryItem = this.getFirst(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTypeRecurse(String string) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        InventoryItem inventoryItem = this.getFirstRecurse(typePredicate);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTypeEval(String string, LuaClosure luaClosure) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        InventoryItem inventoryItem = this.getFirstRecurse(typeEvalPredicate);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTypeEvalRecurse(String string, LuaClosure luaClosure) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        InventoryItem inventoryItem = this.getFirstRecurse(typeEvalPredicate);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return inventoryItem;
    }

    public InventoryItem getFirstTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        InventoryItem inventoryItem = this.getFirstRecurse(typeEvalArgPredicate);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return inventoryItem;
    }

    public ArrayList<InventoryItem> getSomeCategory(String string, int n, ArrayList<InventoryItem> arrayList) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSome(categoryPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeCategoryRecurse(String string, int n, ArrayList<InventoryItem> arrayList) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(categoryPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTag(String string, int n, ArrayList<InventoryItem> arrayList) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSome(tagPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTagEval(String string, LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSome(tagEvalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTagEvalArg(String string, LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSome(tagEvalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTagRecurse(String string, int n, ArrayList<InventoryItem> arrayList) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(tagPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTagEvalRecurse(String string, LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(tagEvalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(tagEvalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeType(String string, int n, ArrayList<InventoryItem> arrayList) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSome(typePredicate, n, arrayList);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTypeEval(String string, LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSome(typeEvalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTypeEvalArg(String string, LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSome(typeEvalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTypeRecurse(String string, int n, ArrayList<InventoryItem> arrayList) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(typePredicate, n, arrayList);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTypeEvalRecurse(String string, LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(typeEvalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(typeEvalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeEval(LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSome(evalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeEvalArg(LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSome(evalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeEvalRecurse(LuaClosure luaClosure, int n, ArrayList<InventoryItem> arrayList) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(evalPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeEvalArgRecurse(LuaClosure luaClosure, Object object, int n, ArrayList<InventoryItem> arrayList) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getSomeRecurse(evalArgPredicate, n, arrayList);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllCategory(String string, ArrayList<InventoryItem> arrayList) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAll(categoryPredicate, arrayList);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllCategoryRecurse(String string, ArrayList<InventoryItem> arrayList) {
        CategoryPredicate categoryPredicate = ItemContainer.TL_predicates.get().category.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(categoryPredicate, arrayList);
        ItemContainer.TL_predicates.get().category.release(categoryPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTag(String string, ArrayList<InventoryItem> arrayList) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAll(tagPredicate, arrayList);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTagEval(String string, LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAll(tagEvalPredicate, arrayList);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTagEvalArg(String string, LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAll(tagEvalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTagRecurse(String string, ArrayList<InventoryItem> arrayList) {
        TagPredicate tagPredicate = ItemContainer.TL_predicates.get().tag.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(tagPredicate, arrayList);
        ItemContainer.TL_predicates.get().tag.release(tagPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTagEvalRecurse(String string, LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        TagEvalPredicate tagEvalPredicate = ItemContainer.TL_predicates.get().tagEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(tagEvalPredicate, arrayList);
        ItemContainer.TL_predicates.get().tagEval.release(tagEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        TagEvalArgPredicate tagEvalArgPredicate = ItemContainer.TL_predicates.get().tagEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(tagEvalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().tagEvalArg.release(tagEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllType(String string, ArrayList<InventoryItem> arrayList) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAll(typePredicate, arrayList);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTypeEval(String string, LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAll(typeEvalPredicate, arrayList);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTypeEvalArg(String string, LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAll(typeEvalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTypeRecurse(String string, ArrayList<InventoryItem> arrayList) {
        TypePredicate typePredicate = ItemContainer.TL_predicates.get().type.alloc().init(string);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(typePredicate, arrayList);
        ItemContainer.TL_predicates.get().type.release(typePredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTypeEvalRecurse(String string, LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        TypeEvalPredicate typeEvalPredicate = ItemContainer.TL_predicates.get().typeEval.alloc().init(string, luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(typeEvalPredicate, arrayList);
        ItemContainer.TL_predicates.get().typeEval.release(typeEvalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        TypeEvalArgPredicate typeEvalArgPredicate = ItemContainer.TL_predicates.get().typeEvalArg.alloc().init(string, luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(typeEvalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().typeEvalArg.release(typeEvalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllEval(LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAll(evalPredicate, arrayList);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllEvalArg(LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAll(evalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllEvalRecurse(LuaClosure luaClosure, ArrayList<InventoryItem> arrayList) {
        EvalPredicate evalPredicate = ItemContainer.TL_predicates.get().eval.alloc().init(luaClosure);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(evalPredicate, arrayList);
        ItemContainer.TL_predicates.get().eval.release(evalPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getAllEvalArgRecurse(LuaClosure luaClosure, Object object, ArrayList<InventoryItem> arrayList) {
        EvalArgPredicate evalArgPredicate = ItemContainer.TL_predicates.get().evalArg.alloc().init(luaClosure, object);
        ArrayList<InventoryItem> arrayList2 = this.getAllRecurse(evalArgPredicate, arrayList);
        ItemContainer.TL_predicates.get().evalArg.release(evalArgPredicate);
        return arrayList2;
    }

    public ArrayList<InventoryItem> getSomeCategory(String string, int n) {
        return this.getSomeCategory(string, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeEval(LuaClosure luaClosure, int n) {
        return this.getSomeEval(luaClosure, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeEvalArg(LuaClosure luaClosure, Object object, int n) {
        return this.getSomeEvalArg(luaClosure, object, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTypeEval(String string, LuaClosure luaClosure, int n) {
        return this.getSomeTypeEval(string, luaClosure, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTypeEvalArg(String string, LuaClosure luaClosure, Object object, int n) {
        return this.getSomeTypeEvalArg(string, luaClosure, object, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeEvalRecurse(LuaClosure luaClosure, int n) {
        return this.getSomeEvalRecurse(luaClosure, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeEvalArgRecurse(LuaClosure luaClosure, Object object, int n) {
        return this.getSomeEvalArgRecurse(luaClosure, object, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTag(String string, int n) {
        return this.getSomeTag(string, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTagRecurse(String string, int n) {
        return this.getSomeTagRecurse(string, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTagEvalRecurse(String string, LuaClosure luaClosure, int n) {
        return this.getSomeTagEvalRecurse(string, luaClosure, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTagEvalArgRecurse(String string, LuaClosure luaClosure, Object object, int n) {
        return this.getSomeTagEvalArgRecurse(string, luaClosure, object, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeType(String string, int n) {
        return this.getSomeType(string, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTypeRecurse(String string, int n) {
        return this.getSomeTypeRecurse(string, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTypeEvalRecurse(String string, LuaClosure luaClosure, int n) {
        return this.getSomeTypeEvalRecurse(string, luaClosure, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getSomeTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object, int n) {
        return this.getSomeTypeEvalArgRecurse(string, luaClosure, object, n, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAll(Predicate<InventoryItem> predicate) {
        return this.getAll(predicate, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllCategory(String string) {
        return this.getAllCategory(string, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllEval(LuaClosure luaClosure) {
        return this.getAllEval(luaClosure, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllEvalArg(LuaClosure luaClosure, Object object) {
        return this.getAllEvalArg(luaClosure, object, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTagEval(String string, LuaClosure luaClosure) {
        return this.getAllTagEval(string, luaClosure, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTagEvalArg(String string, LuaClosure luaClosure, Object object) {
        return this.getAllTagEvalArg(string, luaClosure, object, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTypeEval(String string, LuaClosure luaClosure) {
        return this.getAllTypeEval(string, luaClosure, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTypeEvalArg(String string, LuaClosure luaClosure, Object object) {
        return this.getAllTypeEvalArg(string, luaClosure, object, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllEvalRecurse(LuaClosure luaClosure) {
        return this.getAllEvalRecurse(luaClosure, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllEvalArgRecurse(LuaClosure luaClosure, Object object) {
        return this.getAllEvalArgRecurse(luaClosure, object, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllType(String string) {
        return this.getAllType(string, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTypeRecurse(String string) {
        return this.getAllTypeRecurse(string, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTypeEvalRecurse(String string, LuaClosure luaClosure) {
        return this.getAllTypeEvalRecurse(string, luaClosure, new ArrayList<InventoryItem>());
    }

    public ArrayList<InventoryItem> getAllTypeEvalArgRecurse(String string, LuaClosure luaClosure, Object object) {
        return this.getAllTypeEvalArgRecurse(string, luaClosure, object, new ArrayList<InventoryItem>());
    }

    public InventoryItem FindAndReturnCategory(String string) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.getCategory().equals(string)) continue;
            return inventoryItem;
        }
        return null;
    }

    public ArrayList<InventoryItem> FindAndReturn(String string, int n) {
        return this.getSomeType(string, n);
    }

    public InventoryItem FindAndReturn(String string, ArrayList<InventoryItem> arrayList) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.type == null || !ItemContainer.compareType(string, inventoryItem) || arrayList.contains(inventoryItem)) continue;
            return inventoryItem;
        }
        return null;
    }

    public InventoryItem FindAndReturn(String string) {
        return this.getFirstType(string);
    }

    public ArrayList<InventoryItem> FindAll(String string) {
        return this.getAllType(string);
    }

    public InventoryItem FindAndReturnStack(String string) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem;
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!ItemContainer.compareType(string, inventoryItem2) || !inventoryItem2.CanStack(inventoryItem = InventoryItemFactory.CreateItem(inventoryItem2.module + "." + string))) continue;
            return inventoryItem2;
        }
        return null;
    }

    public InventoryItem FindAndReturnStack(InventoryItem inventoryItem) {
        String string = inventoryItem.type;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!(inventoryItem2.type == null ? string == null : inventoryItem2.type.equals(string)) || !inventoryItem2.CanStack(inventoryItem)) continue;
            return inventoryItem2;
        }
        return null;
    }

    public boolean HasType(ItemType itemType) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.cat != itemType) continue;
            return true;
        }
        return false;
    }

    public void Remove(InventoryItem inventoryItem) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (inventoryItem2 != inventoryItem) continue;
            if (inventoryItem.uses > 1) {
                --inventoryItem.uses;
            } else {
                this.Items.remove(inventoryItem);
            }
            inventoryItem.container = null;
            this.drawDirty = true;
            this.dirty = true;
            if (this.parent != null) {
                this.dirty = true;
            }
            if (this.parent instanceof IsoDeadBody) {
                ((IsoDeadBody)this.parent).checkClothing(inventoryItem);
            }
            if (this.parent instanceof IsoMannequin) {
                ((IsoMannequin)this.parent).checkClothing(inventoryItem);
            }
            return;
        }
    }

    public void DoRemoveItem(InventoryItem inventoryItem) {
        this.drawDirty = true;
        if (this.parent != null) {
            this.dirty = true;
        }
        this.Items.remove(inventoryItem);
        inventoryItem.container = null;
        if (this.parent instanceof IsoDeadBody) {
            ((IsoDeadBody)this.parent).checkClothing(inventoryItem);
        }
        if (this.parent instanceof IsoMannequin) {
            ((IsoMannequin)this.parent).checkClothing(inventoryItem);
        }
    }

    public void Remove(String string) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.type.equals(string)) continue;
            if (inventoryItem.uses > 1) {
                --inventoryItem.uses;
            } else {
                this.Items.remove(inventoryItem);
            }
            inventoryItem.container = null;
            this.drawDirty = true;
            this.dirty = true;
            if (this.parent != null) {
                this.dirty = true;
            }
            return;
        }
    }

    public InventoryItem Remove(ItemType itemType) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.cat != itemType) continue;
            this.Items.remove(inventoryItem);
            inventoryItem.container = null;
            this.drawDirty = true;
            this.dirty = true;
            if (this.parent != null) {
                this.dirty = true;
            }
            return inventoryItem;
        }
        return null;
    }

    public InventoryItem Find(ItemType itemType) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.cat != itemType) continue;
            return inventoryItem;
        }
        return null;
    }

    public void RemoveAll(String string) {
        this.drawDirty = true;
        if (this.parent != null) {
            this.dirty = true;
        }
        ArrayList<InventoryItem> arrayList = new ArrayList<InventoryItem>();
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.type.equals(string)) continue;
            inventoryItem.container = null;
            arrayList.add(inventoryItem);
            this.dirty = true;
        }
        for (InventoryItem inventoryItem : arrayList) {
            this.Items.remove(inventoryItem);
        }
    }

    public boolean RemoveOneOf(String string, boolean bl) {
        InventoryItem inventoryItem;
        int n;
        this.drawDirty = true;
        if (this.parent != null && !(this.parent instanceof IsoGameCharacter)) {
            this.dirty = true;
        }
        for (n = 0; n < this.Items.size(); ++n) {
            inventoryItem = this.Items.get(n);
            if (!inventoryItem.getFullType().equals(string) && !inventoryItem.type.equals(string)) continue;
            if (inventoryItem.uses > 1) {
                --inventoryItem.uses;
            } else {
                inventoryItem.container = null;
                this.Items.remove(inventoryItem);
            }
            this.dirty = true;
            return true;
        }
        if (bl) {
            for (n = 0; n < this.Items.size(); ++n) {
                inventoryItem = this.Items.get(n);
                if (!(inventoryItem instanceof InventoryContainer) || ((InventoryContainer)inventoryItem).getItemContainer() == null || !((InventoryContainer)inventoryItem).getItemContainer().RemoveOneOf(string, bl)) continue;
                return true;
            }
        }
        return false;
    }

    public void RemoveOneOf(String string) {
        this.RemoveOneOf(string, true);
    }

    public int getWeight() {
        if (this.parent instanceof IsoPlayer && ((IsoPlayer)this.parent).isGhostMode()) {
            return 0;
        }
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            f += inventoryItem.ActualWeight * (float)inventoryItem.uses;
        }
        return (int)(f * ((float)this.weightReduction / 0.01f));
    }

    public float getContentsWeight() {
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            f += inventoryItem.getUnequippedWeight();
        }
        return f;
    }

    public float getMaxWeight() {
        if (this.parent instanceof IsoGameCharacter) {
            return ((IsoGameCharacter)this.parent).getMaxWeight();
        }
        return this.Capacity;
    }

    public float getCapacityWeight() {
        if (this.parent instanceof IsoPlayer) {
            if (Core.bDebug && ((IsoPlayer)this.parent).isGhostMode() || !((IsoPlayer)this.parent).isAccessLevel("None") && ((IsoPlayer)this.parent).isUnlimitedCarry()) {
                return 0.0f;
            }
            if (((IsoPlayer)this.parent).isUnlimitedCarry()) {
                return 0.0f;
            }
        }
        if (this.parent instanceof IsoGameCharacter) {
            return ((IsoGameCharacter)this.parent).getInventoryWeight();
        }
        return this.getContentsWeight();
    }

    public boolean isEmpty() {
        return this.Items == null || this.Items.isEmpty();
    }

    public boolean isMicrowave() {
        return "microwave".equals(this.getType());
    }

    private boolean isSquareInRoom(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        return isoGridSquare.getRoom() != null;
    }

    private boolean isSquarePowered(IsoGridSquare isoGridSquare) {
        if (isoGridSquare == null) {
            return false;
        }
        boolean bl = IsoWorld.instance.isHydroPowerOn();
        if (bl && isoGridSquare.getRoom() != null) {
            return true;
        }
        if (isoGridSquare.haveElectricity()) {
            return true;
        }
        if (bl && isoGridSquare.getRoom() == null) {
            IsoGridSquare isoGridSquare2 = isoGridSquare.nav[IsoDirections.N.index()];
            IsoGridSquare isoGridSquare3 = isoGridSquare.nav[IsoDirections.S.index()];
            IsoGridSquare isoGridSquare4 = isoGridSquare.nav[IsoDirections.W.index()];
            IsoGridSquare isoGridSquare5 = isoGridSquare.nav[IsoDirections.E.index()];
            if (this.isSquareInRoom(isoGridSquare2) || this.isSquareInRoom(isoGridSquare3) || this.isSquareInRoom(isoGridSquare4) || this.isSquareInRoom(isoGridSquare5)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPowered() {
        if (this.parent == null || this.parent.getObjectIndex() == -1) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.parent.getSquare();
        if (this.isSquarePowered(isoGridSquare)) {
            return true;
        }
        this.parent.getSpriteGridObjects(s_tempObjects);
        for (int i = 0; i < s_tempObjects.size(); ++i) {
            IsoGridSquare isoGridSquare2;
            IsoObject isoObject = s_tempObjects.get(i);
            if (isoObject == this.parent || !this.isSquarePowered(isoGridSquare2 = isoObject.getSquare())) continue;
            return true;
        }
        return false;
    }

    public float getTemprature() {
        if (this.customTemperature != 0.0f) {
            return this.customTemperature;
        }
        boolean bl = false;
        if (this.getParent() != null && this.getParent().getSprite() != null) {
            bl = this.getParent().getSprite().getProperties().Is("IsFridge");
        }
        if (this.isPowered()) {
            if (this.type.equals("fridge") || this.type.equals("freezer") || bl) {
                return 0.2f;
            }
            if (("stove".equals(this.type) || "microwave".equals(this.type)) && this.parent instanceof IsoStove) {
                return ((IsoStove)this.parent).getCurrentTemperature() / 100.0f;
            }
        }
        if ("barbecue".equals(this.type) && this.parent instanceof IsoBarbecue) {
            return ((IsoBarbecue)this.parent).getTemperature();
        }
        if ("fireplace".equals(this.type) && this.parent instanceof IsoFireplace) {
            return ((IsoFireplace)this.parent).getTemperature();
        }
        if ("woodstove".equals(this.type) && this.parent instanceof IsoFireplace) {
            return ((IsoFireplace)this.parent).getTemperature();
        }
        if ((this.type.equals("fridge") || this.type.equals("freezer") || bl) && GameTime.instance.NightsSurvived == SandboxOptions.instance.getElecShutModifier() && GameTime.instance.getTimeOfDay() < 13.0f) {
            float f = (GameTime.instance.getTimeOfDay() - 7.0f) / 6.0f;
            return GameTime.instance.Lerp(0.2f, 1.0f, f);
        }
        return 1.0f;
    }

    public boolean isTemperatureChanging() {
        if (this.parent instanceof IsoStove) {
            return ((IsoStove)this.parent).isTemperatureChanging();
        }
        return false;
    }

    public ArrayList<InventoryItem> save(ByteBuffer byteBuffer, IsoGameCharacter isoGameCharacter) throws IOException {
        GameWindow.WriteString(byteBuffer, this.type);
        byteBuffer.put(this.bExplored ? (byte)1 : 0);
        ArrayList<InventoryItem> arrayList = CompressIdenticalItems.save(byteBuffer, this.Items, null);
        byteBuffer.put(this.isHasBeenLooted() ? (byte)1 : 0);
        byteBuffer.putInt(this.Capacity);
        return arrayList;
    }

    public ArrayList<InventoryItem> save(ByteBuffer byteBuffer) throws IOException {
        return this.save(byteBuffer, null);
    }

    public ArrayList<InventoryItem> load(ByteBuffer byteBuffer, int n) throws IOException {
        this.type = GameWindow.ReadString(byteBuffer);
        this.bExplored = byteBuffer.get() == 1;
        ArrayList<InventoryItem> arrayList = CompressIdenticalItems.load(byteBuffer, n, this.Items, this.IncludingObsoleteItems);
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            inventoryItem.container = this;
        }
        this.setHasBeenLooted(byteBuffer.get() == 1);
        this.Capacity = byteBuffer.getInt();
        this.dirty = false;
        return arrayList;
    }

    public boolean isDrawDirty() {
        return this.drawDirty;
    }

    public void setDrawDirty(boolean bl) {
        this.drawDirty = bl;
    }

    public InventoryItem getBestWeapon(SurvivorDesc survivorDesc) {
        InventoryItem inventoryItem = null;
        float f = -1.0E7f;
        for (int i = 0; i < this.Items.size(); ++i) {
            float f2;
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!(inventoryItem2 instanceof HandWeapon) || !((f2 = inventoryItem2.getScore(survivorDesc)) >= f)) continue;
            f = f2;
            inventoryItem = inventoryItem2;
        }
        return inventoryItem;
    }

    public InventoryItem getBestWeapon() {
        InventoryItem inventoryItem = null;
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            float f2;
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!(inventoryItem2 instanceof HandWeapon) || !((f2 = inventoryItem2.getScore(null)) >= f)) continue;
            f = f2;
            inventoryItem = inventoryItem2;
        }
        return inventoryItem;
    }

    public float getTotalFoodScore(SurvivorDesc survivorDesc) {
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!(inventoryItem instanceof Food)) continue;
            f += inventoryItem.getScore(survivorDesc);
        }
        return f;
    }

    public float getTotalWeaponScore(SurvivorDesc survivorDesc) {
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!(inventoryItem instanceof HandWeapon)) continue;
            f += inventoryItem.getScore(survivorDesc);
        }
        return f;
    }

    public InventoryItem getBestFood(SurvivorDesc survivorDesc) {
        InventoryItem inventoryItem = null;
        float f = 0.0f;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!(inventoryItem2 instanceof Food)) continue;
            float f2 = inventoryItem2.getScore(survivorDesc);
            if (((Food)inventoryItem2).isbDangerousUncooked() && !inventoryItem2.isCooked()) {
                f2 *= 0.2f;
            }
            if (((Food)inventoryItem2).Age > (float)inventoryItem2.OffAge) {
                f2 *= 0.2f;
            }
            if (!(f2 >= f)) continue;
            f = f2;
            inventoryItem = inventoryItem2;
        }
        return inventoryItem;
    }

    public InventoryItem getBestBandage(SurvivorDesc survivorDesc) {
        InventoryItem inventoryItem = null;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem2 = this.Items.get(i);
            if (!inventoryItem2.isCanBandage()) continue;
            inventoryItem = inventoryItem2;
            break;
        }
        return inventoryItem;
    }

    public int getNumItems(String string) {
        int n = 0;
        if (string.contains("Type:")) {
            for (int i = 0; i < this.Items.size(); ++i) {
                InventoryItem inventoryItem = this.Items.get(i);
                if (inventoryItem instanceof Food && string.contains("Food")) {
                    n += inventoryItem.uses;
                }
                if (!(inventoryItem instanceof HandWeapon) || !string.contains("Weapon")) continue;
                n += inventoryItem.uses;
            }
        } else {
            for (int i = 0; i < this.Items.size(); ++i) {
                InventoryItem inventoryItem = this.Items.get(i);
                if (!inventoryItem.type.equals(string)) continue;
                n += inventoryItem.uses;
            }
        }
        return n;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isIsDevice() {
        return this.IsDevice;
    }

    public void setIsDevice(boolean bl) {
        this.IsDevice = bl;
    }

    public float getAgeFactor() {
        return this.ageFactor;
    }

    public void setAgeFactor(float f) {
        this.ageFactor = f;
    }

    public float getCookingFactor() {
        return this.CookingFactor;
    }

    public void setCookingFactor(float f) {
        this.CookingFactor = f;
    }

    public ArrayList<InventoryItem> getItems() {
        return this.Items;
    }

    public void setItems(ArrayList<InventoryItem> arrayList) {
        this.Items = arrayList;
    }

    public IsoObject getParent() {
        return this.parent;
    }

    public void setParent(IsoObject isoObject) {
        this.parent = isoObject;
    }

    public IsoGridSquare getSourceGrid() {
        return this.SourceGrid;
    }

    public void setSourceGrid(IsoGridSquare isoGridSquare) {
        this.SourceGrid = isoGridSquare;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void clear() {
        this.Items.clear();
        this.dirty = true;
        this.drawDirty = true;
    }

    public int getWaterContainerCount() {
        int n = 0;
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.CanStoreWater) continue;
            ++n;
        }
        return n;
    }

    public InventoryItem FindWaterSource() {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.isWaterSource()) continue;
            if (inventoryItem instanceof Drainable) {
                if (!(((Drainable)((Object)inventoryItem)).getUsedDelta() > 0.0f)) continue;
                return inventoryItem;
            }
            return inventoryItem;
        }
        return null;
    }

    public ArrayList<InventoryItem> getAllWaterFillables() {
        tempList.clear();
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (!inventoryItem.CanStoreWater) continue;
            tempList.add(inventoryItem);
        }
        return tempList;
    }

    public int getItemCount(String string) {
        return this.getCountType(string);
    }

    public int getItemCountRecurse(String string) {
        return this.getCountTypeRecurse(string);
    }

    public int getItemCount(String string, boolean bl) {
        return bl ? this.getCountTypeRecurse(string) : this.getCountType(string);
    }

    private static int getUses(InventoryItemList inventoryItemList) {
        int n = 0;
        for (int i = 0; i < inventoryItemList.size(); ++i) {
            DrainableComboItem drainableComboItem = Type.tryCastTo((InventoryItem)inventoryItemList.get(i), DrainableComboItem.class);
            if (drainableComboItem != null) {
                n += drainableComboItem.getDrainableUsesInt();
                continue;
            }
            ++n;
        }
        return n;
    }

    public int getUsesRecurse(Predicate<InventoryItem> predicate) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAllRecurse(predicate, inventoryItemList);
        int n = ItemContainer.getUses(inventoryItemList);
        TL_itemListPool.get().release(inventoryItemList);
        return n;
    }

    public int getUsesType(String string) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAllType(string, inventoryItemList);
        int n = ItemContainer.getUses(inventoryItemList);
        TL_itemListPool.get().release(inventoryItemList);
        return n;
    }

    public int getUsesTypeRecurse(String string) {
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        this.getAllTypeRecurse(string, inventoryItemList);
        int n = ItemContainer.getUses(inventoryItemList);
        TL_itemListPool.get().release(inventoryItemList);
        return n;
    }

    public int getWeightReduction() {
        return this.weightReduction;
    }

    public void setWeightReduction(int n) {
        n = Math.min(n, 100);
        this.weightReduction = n = Math.max(n, 0);
    }

    public void removeAllItems() {
        this.drawDirty = true;
        if (this.parent != null) {
            this.dirty = true;
        }
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            inventoryItem.container = null;
        }
        this.Items.clear();
        if (this.parent instanceof IsoDeadBody) {
            ((IsoDeadBody)this.parent).checkClothing(null);
        }
        if (this.parent instanceof IsoMannequin) {
            ((IsoMannequin)this.parent).checkClothing(null);
        }
    }

    public boolean containsRecursive(InventoryItem inventoryItem) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem2 = this.getItems().get(i);
            if (inventoryItem2 == inventoryItem) {
                return true;
            }
            if (!(inventoryItem2 instanceof InventoryContainer) || !((InventoryContainer)inventoryItem2).getInventory().containsRecursive(inventoryItem)) continue;
            return true;
        }
        return false;
    }

    public int getItemCountFromTypeRecurse(String string) {
        int n = 0;
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.getItems().get(i);
            if (inventoryItem.getFullType().equals(string)) {
                ++n;
            }
            if (!(inventoryItem instanceof InventoryContainer)) continue;
            int n2 = ((InventoryContainer)inventoryItem).getInventory().getItemCountFromTypeRecurse(string);
            n += n2;
        }
        return n;
    }

    public float getCustomTemperature() {
        return this.customTemperature;
    }

    public void setCustomTemperature(float f) {
        this.customTemperature = f;
    }

    public InventoryItem getItemFromType(String string, IsoGameCharacter isoGameCharacter, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        int n;
        InventoryItemList inventoryItemList = (InventoryItemList)TL_itemListPool.get().alloc();
        if (string.contains(".")) {
            string = string.split("\\.")[1];
        }
        for (n = 0; n < this.getItems().size(); ++n) {
            object = this.getItems().get(n);
            if (((InventoryItem)object).getFullType().equals(string) || ((InventoryItem)object).getType().equals(string)) {
                if (bl && isoGameCharacter != null && isoGameCharacter.isEquippedClothing((InventoryItem)object) || !this.testBroken(bl2, (InventoryItem)object)) continue;
                TL_itemListPool.get().release(inventoryItemList);
                return object;
            }
            if (!bl3 || !(object instanceof InventoryContainer) || ((InventoryContainer)object).getInventory() == null || inventoryItemList.contains(object)) continue;
            inventoryItemList.add(object);
        }
        for (n = 0; n < inventoryItemList.size(); ++n) {
            object = ((InventoryContainer)inventoryItemList.get(n)).getInventory();
            InventoryItem inventoryItem = ((ItemContainer)object).getItemFromType(string, isoGameCharacter, bl, bl2, bl3);
            if (inventoryItem == null) continue;
            TL_itemListPool.get().release(inventoryItemList);
            return inventoryItem;
        }
        TL_itemListPool.get().release(inventoryItemList);
        return null;
    }

    public InventoryItem getItemFromType(String string, boolean bl, boolean bl2) {
        return this.getItemFromType(string, null, false, bl, bl2);
    }

    public InventoryItem getItemFromType(String string) {
        return this.getFirstType(string);
    }

    public ArrayList<InventoryItem> getItemsFromType(String string) {
        return this.getAllType(string);
    }

    public ArrayList<InventoryItem> getItemsFromFullType(String string) {
        if (string == null || !string.contains(".")) {
            return new ArrayList<InventoryItem>();
        }
        return this.getAllType(string);
    }

    public ArrayList<InventoryItem> getItemsFromFullType(String string, boolean bl) {
        if (string == null || !string.contains(".")) {
            return new ArrayList<InventoryItem>();
        }
        return bl ? this.getAllTypeRecurse(string) : this.getAllType(string);
    }

    public ArrayList<InventoryItem> getItemsFromType(String string, boolean bl) {
        return bl ? this.getAllTypeRecurse(string) : this.getAllType(string);
    }

    public ArrayList<InventoryItem> getItemsFromCategory(String string) {
        return this.getAllCategory(string);
    }

    public void sendContentsToRemoteContainer() {
        if (GameClient.bClient) {
            this.sendContentsToRemoteContainer(GameClient.connection);
        }
    }

    public void requestSync() {
        if (GameClient.bClient) {
            if (this.parent == null || this.parent.square == null || this.parent.square.chunk == null) {
                return;
            }
            GameClient.instance.worldObjectsSyncReq.putRequestSyncIsoChunk(this.parent.square.chunk);
        }
    }

    public void requestServerItemsForContainer() {
        if (this.parent == null || this.parent.square == null) {
            return;
        }
        UdpConnection udpConnection = GameClient.connection;
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.RequestItemsForContainer.doPacket(byteBufferWriter);
        byteBufferWriter.putShort(IsoPlayer.getInstance().OnlineID);
        byteBufferWriter.putUTF(this.type);
        if (this.parent.square.getRoom() != null) {
            byteBufferWriter.putUTF(this.parent.square.getRoom().getName());
        } else {
            byteBufferWriter.putUTF("all");
        }
        byteBufferWriter.putInt(this.parent.square.getX());
        byteBufferWriter.putInt(this.parent.square.getY());
        byteBufferWriter.putInt(this.parent.square.getZ());
        int n = this.parent.square.getObjects().indexOf(this.parent);
        if (n == -1 && this.parent.square.getStaticMovingObjects().indexOf(this.parent) != -1) {
            byteBufferWriter.putShort((short)0);
            n = this.parent.square.getStaticMovingObjects().indexOf(this.parent);
            byteBufferWriter.putByte((byte)n);
        } else if (this.parent instanceof IsoWorldInventoryObject) {
            byteBufferWriter.putShort((short)1);
            byteBufferWriter.putInt(((IsoWorldInventoryObject)this.parent).getItem().id);
        } else if (this.parent instanceof BaseVehicle) {
            byteBufferWriter.putShort((short)3);
            byteBufferWriter.putShort(((BaseVehicle)this.parent).VehicleID);
            byteBufferWriter.putByte((byte)this.vehiclePart.getIndex());
        } else {
            byteBufferWriter.putShort((short)2);
            byteBufferWriter.putByte((byte)n);
            byteBufferWriter.putByte((byte)this.parent.getContainerIndex(this));
        }
        PacketTypes.PacketType.RequestItemsForContainer.send(udpConnection);
    }

    @Deprecated
    public void sendContentsToRemoteContainer(UdpConnection udpConnection) {
        ByteBufferWriter byteBufferWriter = udpConnection.startPacket();
        PacketTypes.PacketType.AddInventoryItemToContainer.doPacket(byteBufferWriter);
        byteBufferWriter.putInt(0);
        boolean bl = false;
        byteBufferWriter.putInt(this.parent.square.getX());
        byteBufferWriter.putInt(this.parent.square.getY());
        byteBufferWriter.putInt(this.parent.square.getZ());
        byteBufferWriter.putByte((byte)this.parent.square.getObjects().indexOf(this.parent));
        try {
            CompressIdenticalItems.save(byteBufferWriter.bb, this.Items, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        PacketTypes.PacketType.AddInventoryItemToContainer.send(udpConnection);
    }

    public InventoryItem getItemWithIDRecursiv(int n) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.id == n) {
                return inventoryItem;
            }
            if (!(inventoryItem instanceof InventoryContainer) || ((InventoryContainer)inventoryItem).getItemContainer() == null || ((InventoryContainer)inventoryItem).getItemContainer().getItems().isEmpty() || (inventoryItem = ((InventoryContainer)inventoryItem).getItemContainer().getItemWithIDRecursiv(n)) == null) continue;
            return inventoryItem;
        }
        return null;
    }

    public InventoryItem getItemWithID(int n) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.id != n) continue;
            return inventoryItem;
        }
        return null;
    }

    public boolean removeItemWithID(int n) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.id != n) continue;
            this.Remove(inventoryItem);
            return true;
        }
        return false;
    }

    public boolean containsID(int n) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.id != n) continue;
            return true;
        }
        return false;
    }

    public boolean removeItemWithIDRecurse(int n) {
        for (int i = 0; i < this.Items.size(); ++i) {
            InventoryItem inventoryItem = this.Items.get(i);
            if (inventoryItem.id == n) {
                this.Remove(inventoryItem);
                return true;
            }
            if (!(inventoryItem instanceof InventoryContainer) || !((InventoryContainer)inventoryItem).getInventory().removeItemWithIDRecurse(n)) continue;
            return true;
        }
        return false;
    }

    public boolean isHasBeenLooted() {
        return this.hasBeenLooted;
    }

    public void setHasBeenLooted(boolean bl) {
        this.hasBeenLooted = bl;
    }

    public String getOpenSound() {
        return this.openSound;
    }

    public void setOpenSound(String string) {
        this.openSound = string;
    }

    public String getCloseSound() {
        return this.closeSound;
    }

    public void setCloseSound(String string) {
        this.closeSound = string;
    }

    public String getPutSound() {
        return this.putSound;
    }

    public void setPutSound(String string) {
        this.putSound = string;
    }

    public InventoryItem haveThisKeyId(int n) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.getItems().get(i);
            if (inventoryItem instanceof Key) {
                Key key = (Key)inventoryItem;
                if (key.getKeyId() != n) continue;
                return key;
            }
            if (!inventoryItem.getType().equals("KeyRing") || ((InventoryContainer)inventoryItem).getInventory().haveThisKeyId(n) == null) continue;
            return ((InventoryContainer)inventoryItem).getInventory().haveThisKeyId(n);
        }
        return null;
    }

    public String getOnlyAcceptCategory() {
        return this.OnlyAcceptCategory;
    }

    public void setOnlyAcceptCategory(String string) {
        this.OnlyAcceptCategory = StringUtils.discardNullOrWhitespace(string);
    }

    public String getAcceptItemFunction() {
        return this.AcceptItemFunction;
    }

    public void setAcceptItemFunction(String string) {
        this.AcceptItemFunction = StringUtils.discardNullOrWhitespace(string);
    }

    public IsoGameCharacter getCharacter() {
        if (this.getParent() instanceof IsoGameCharacter) {
            return (IsoGameCharacter)this.getParent();
        }
        if (this.containingItem != null && this.containingItem.getContainer() != null) {
            return this.containingItem.getContainer().getCharacter();
        }
        return null;
    }

    public void emptyIt() {
        this.Items = new ArrayList();
    }

    public LinkedHashMap<String, InventoryItem> getItems4Admin() {
        LinkedHashMap<String, InventoryItem> linkedHashMap = new LinkedHashMap<String, InventoryItem>();
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.getItems().get(i);
            inventoryItem.setCount(1);
            if (inventoryItem.getCat() != ItemType.Drainable && inventoryItem.getCat() != ItemType.Weapon && linkedHashMap.get(inventoryItem.getFullType()) != null && !(inventoryItem instanceof InventoryContainer)) {
                linkedHashMap.get(inventoryItem.getFullType()).setCount(linkedHashMap.get(inventoryItem.getFullType()).getCount() + 1);
                continue;
            }
            if (linkedHashMap.get(inventoryItem.getFullType()) != null) {
                linkedHashMap.put(inventoryItem.getFullType() + Rand.Next(100000), inventoryItem);
                continue;
            }
            linkedHashMap.put(inventoryItem.getFullType(), inventoryItem);
        }
        return linkedHashMap;
    }

    public LinkedHashMap<String, InventoryItem> getAllItems(LinkedHashMap<String, InventoryItem> linkedHashMap, boolean bl) {
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
        }
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.getItems().get(i);
            if (bl) {
                inventoryItem.setWorker("inInv");
            }
            inventoryItem.setCount(1);
            if (inventoryItem.getCat() != ItemType.Drainable && inventoryItem.getCat() != ItemType.Weapon && linkedHashMap.get(inventoryItem.getFullType()) != null) {
                linkedHashMap.get(inventoryItem.getFullType()).setCount(linkedHashMap.get(inventoryItem.getFullType()).getCount() + 1);
            } else if (linkedHashMap.get(inventoryItem.getFullType()) != null) {
                linkedHashMap.put(inventoryItem.getFullType() + Rand.Next(100000), inventoryItem);
            } else {
                linkedHashMap.put(inventoryItem.getFullType(), inventoryItem);
            }
            if (!(inventoryItem instanceof InventoryContainer) || ((InventoryContainer)inventoryItem).getItemContainer() == null || ((InventoryContainer)inventoryItem).getItemContainer().getItems().isEmpty()) continue;
            linkedHashMap = ((InventoryContainer)inventoryItem).getItemContainer().getAllItems(linkedHashMap, true);
        }
        return linkedHashMap;
    }

    public InventoryItem getItemById(long l) {
        for (int i = 0; i < this.getItems().size(); ++i) {
            InventoryItem inventoryItem = this.getItems().get(i);
            if ((long)inventoryItem.getID() == l) {
                return inventoryItem;
            }
            if (!(inventoryItem instanceof InventoryContainer) || ((InventoryContainer)inventoryItem).getItemContainer() == null || ((InventoryContainer)inventoryItem).getItemContainer().getItems().isEmpty() || (inventoryItem = ((InventoryContainer)inventoryItem).getItemContainer().getItemById(l)) == null) continue;
            return inventoryItem;
        }
        return null;
    }

    public void addItemsToProcessItems() {
        IsoWorld.instance.CurrentCell.addToProcessItems(this.Items);
    }

    public void removeItemsFromProcessItems() {
        IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this.Items);
        if (!"floor".equals(this.type)) {
            ItemSoundManager.removeItems(this.Items);
        }
    }

    public boolean isExistYet() {
        if (!SystemDisabler.doWorldSyncEnable) {
            return true;
        }
        if (this.getCharacter() != null) {
            return true;
        }
        if (this.getParent() instanceof BaseVehicle) {
            return true;
        }
        if (this.parent instanceof IsoDeadBody) {
            return this.parent.getStaticMovingObjectIndex() != -1;
        }
        if (this.parent instanceof IsoCompost) {
            return this.parent.getObjectIndex() != -1;
        }
        if (this.containingItem != null && this.containingItem.worldItem != null) {
            return this.containingItem.worldItem.getWorldObjectIndex() != -1;
        }
        if (this.getType().equals("floor")) {
            return true;
        }
        if (this.SourceGrid == null) {
            return false;
        }
        IsoGridSquare isoGridSquare = this.SourceGrid;
        if (!isoGridSquare.getObjects().contains(this.parent)) {
            return false;
        }
        return this.parent.getContainerIndex(this) != -1;
    }

    public String getContainerPosition() {
        return this.containerPosition;
    }

    public void setContainerPosition(String string) {
        this.containerPosition = string;
    }

    public String getFreezerPosition() {
        return this.freezerPosition;
    }

    public void setFreezerPosition(String string) {
        this.freezerPosition = string;
    }

    public VehiclePart getVehiclePart() {
        return this.vehiclePart;
    }

    private static final class InventoryItemListPool
    extends ObjectPool<InventoryItemList> {
        public InventoryItemListPool() {
            super(InventoryItemList::new);
        }

        @Override
        public void release(InventoryItemList inventoryItemList) {
            inventoryItemList.clear();
            super.release(inventoryItemList);
        }
    }

    private static final class InventoryItemList
    extends ArrayList<InventoryItem> {
        private InventoryItemList() {
        }

        @Override
        public boolean equals(Object object) {
            return this == object;
        }
    }

    private static final class Predicates {
        final ObjectPool<CategoryPredicate> category = new ObjectPool<CategoryPredicate>(CategoryPredicate::new);
        final ObjectPool<EvalPredicate> eval = new ObjectPool<EvalPredicate>(EvalPredicate::new);
        final ObjectPool<EvalArgPredicate> evalArg = new ObjectPool<EvalArgPredicate>(EvalArgPredicate::new);
        final ObjectPool<TagPredicate> tag = new ObjectPool<TagPredicate>(TagPredicate::new);
        final ObjectPool<TagEvalPredicate> tagEval = new ObjectPool<TagEvalPredicate>(TagEvalPredicate::new);
        final ObjectPool<TagEvalArgPredicate> tagEvalArg = new ObjectPool<TagEvalArgPredicate>(TagEvalArgPredicate::new);
        final ObjectPool<TypePredicate> type = new ObjectPool<TypePredicate>(TypePredicate::new);
        final ObjectPool<TypeEvalPredicate> typeEval = new ObjectPool<TypeEvalPredicate>(TypeEvalPredicate::new);
        final ObjectPool<TypeEvalArgPredicate> typeEvalArg = new ObjectPool<TypeEvalArgPredicate>(TypeEvalArgPredicate::new);

        private Predicates() {
        }
    }

    private static final class TypePredicate
    implements Predicate<InventoryItem> {
        String type;

        private TypePredicate() {
        }

        TypePredicate init(String string) {
            this.type = Objects.requireNonNull(string);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return ItemContainer.compareType(this.type, inventoryItem);
        }
    }

    private static final class EvalPredicate
    implements Predicate<InventoryItem> {
        LuaClosure functionObj;

        private EvalPredicate() {
        }

        EvalPredicate init(LuaClosure luaClosure) {
            this.functionObj = Objects.requireNonNull(luaClosure);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return LuaManager.caller.protectedCallBoolean(LuaManager.thread, (Object)this.functionObj, inventoryItem) == Boolean.TRUE;
        }
    }

    private static final class Comparators {
        ObjectPool<ConditionComparator> condition = new ObjectPool<ConditionComparator>(ConditionComparator::new);
        ObjectPool<EvalComparator> eval = new ObjectPool<EvalComparator>(EvalComparator::new);
        ObjectPool<EvalArgComparator> evalArg = new ObjectPool<EvalArgComparator>(EvalArgComparator::new);

        private Comparators() {
        }
    }

    private static final class EvalComparator
    implements Comparator<InventoryItem> {
        LuaClosure functionObj;

        private EvalComparator() {
        }

        EvalComparator init(LuaClosure luaClosure) {
            this.functionObj = Objects.requireNonNull(luaClosure);
            return this;
        }

        @Override
        public int compare(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
            LuaReturn luaReturn = LuaManager.caller.protectedCall(LuaManager.thread, this.functionObj, inventoryItem, inventoryItem2);
            if (luaReturn.isSuccess() && !luaReturn.isEmpty() && luaReturn.getFirst() instanceof Double) {
                double d = (Double)luaReturn.getFirst();
                return Double.compare(d, 0.0);
            }
            return 0;
        }
    }

    private static final class EvalArgPredicate
    implements Predicate<InventoryItem> {
        LuaClosure functionObj;
        Object arg;

        private EvalArgPredicate() {
        }

        EvalArgPredicate init(LuaClosure luaClosure, Object object) {
            this.functionObj = Objects.requireNonNull(luaClosure);
            this.arg = object;
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return LuaManager.caller.protectedCallBoolean(LuaManager.thread, this.functionObj, inventoryItem, this.arg) == Boolean.TRUE;
        }
    }

    private static final class EvalArgComparator
    implements Comparator<InventoryItem> {
        LuaClosure functionObj;
        Object arg;

        private EvalArgComparator() {
        }

        EvalArgComparator init(LuaClosure luaClosure, Object object) {
            this.functionObj = Objects.requireNonNull(luaClosure);
            this.arg = object;
            return this;
        }

        @Override
        public int compare(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
            LuaReturn luaReturn = LuaManager.caller.protectedCall(LuaManager.thread, this.functionObj, inventoryItem, inventoryItem2, this.arg);
            if (luaReturn.isSuccess() && !luaReturn.isEmpty() && luaReturn.getFirst() instanceof Double) {
                double d = (Double)luaReturn.getFirst();
                return Double.compare(d, 0.0);
            }
            return 0;
        }
    }

    private static final class ConditionComparator
    implements Comparator<InventoryItem> {
        private ConditionComparator() {
        }

        @Override
        public int compare(InventoryItem inventoryItem, InventoryItem inventoryItem2) {
            return inventoryItem.getCondition() - inventoryItem2.getCondition();
        }
    }

    private static final class TagPredicate
    implements Predicate<InventoryItem> {
        String tag;

        private TagPredicate() {
        }

        TagPredicate init(String string) {
            this.tag = Objects.requireNonNull(string);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return inventoryItem.hasTag(this.tag);
        }
    }

    private static final class TagEvalPredicate
    implements Predicate<InventoryItem> {
        String tag;
        LuaClosure functionObj;

        private TagEvalPredicate() {
        }

        TagEvalPredicate init(String string, LuaClosure luaClosure) {
            this.tag = string;
            this.functionObj = Objects.requireNonNull(luaClosure);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return inventoryItem.hasTag(this.tag) && LuaManager.caller.protectedCallBoolean(LuaManager.thread, (Object)this.functionObj, inventoryItem) == Boolean.TRUE;
        }
    }

    private static final class TagEvalArgPredicate
    implements Predicate<InventoryItem> {
        String tag;
        LuaClosure functionObj;
        Object arg;

        private TagEvalArgPredicate() {
        }

        TagEvalArgPredicate init(String string, LuaClosure luaClosure, Object object) {
            this.tag = string;
            this.functionObj = Objects.requireNonNull(luaClosure);
            this.arg = object;
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return inventoryItem.hasTag(this.tag) && LuaManager.caller.protectedCallBoolean(LuaManager.thread, this.functionObj, inventoryItem, this.arg) == Boolean.TRUE;
        }
    }

    private static final class TypeEvalPredicate
    implements Predicate<InventoryItem> {
        String type;
        LuaClosure functionObj;

        private TypeEvalPredicate() {
        }

        TypeEvalPredicate init(String string, LuaClosure luaClosure) {
            this.type = string;
            this.functionObj = Objects.requireNonNull(luaClosure);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return ItemContainer.compareType(this.type, inventoryItem) && LuaManager.caller.protectedCallBoolean(LuaManager.thread, (Object)this.functionObj, inventoryItem) == Boolean.TRUE;
        }
    }

    private static final class TypeEvalArgPredicate
    implements Predicate<InventoryItem> {
        String type;
        LuaClosure functionObj;
        Object arg;

        private TypeEvalArgPredicate() {
        }

        TypeEvalArgPredicate init(String string, LuaClosure luaClosure, Object object) {
            this.type = string;
            this.functionObj = Objects.requireNonNull(luaClosure);
            this.arg = object;
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return ItemContainer.compareType(this.type, inventoryItem) && LuaManager.caller.protectedCallBoolean(LuaManager.thread, this.functionObj, inventoryItem, this.arg) == Boolean.TRUE;
        }
    }

    private static final class CategoryPredicate
    implements Predicate<InventoryItem> {
        String category;

        private CategoryPredicate() {
        }

        CategoryPredicate init(String string) {
            this.category = Objects.requireNonNull(string);
            return this;
        }

        @Override
        public boolean test(InventoryItem inventoryItem) {
            return inventoryItem.getCategory().equals(this.category);
        }
    }
}

