/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import se.krka.kahlua.vm.KahluaTable;
import se.krka.kahlua.vm.KahluaTableIterator;
import zombie.GameTime;
import zombie.GameWindow;
import zombie.Lua.LuaEventManager;
import zombie.Lua.LuaManager;
import zombie.SandboxOptions;
import zombie.audio.BaseSoundEmitter;
import zombie.characterTextures.BloodBodyPartType;
import zombie.characterTextures.BloodClothingType;
import zombie.characters.IsoGameCharacter;
import zombie.characters.IsoPlayer;
import zombie.characters.SurvivorDesc;
import zombie.core.Color;
import zombie.core.Colors;
import zombie.core.Core;
import zombie.core.Translator;
import zombie.core.logger.ExceptionLogger;
import zombie.core.math.PZMath;
import zombie.core.skinnedmodel.model.WorldItemAtlas;
import zombie.core.skinnedmodel.population.ClothingItem;
import zombie.core.skinnedmodel.visual.ItemVisual;
import zombie.core.stash.StashSystem;
import zombie.core.textures.ColorInfo;
import zombie.core.textures.Texture;
import zombie.core.utils.Bits;
import zombie.debug.DebugLog;
import zombie.debug.DebugOptions;
import zombie.inventory.FixingManager;
import zombie.inventory.InventoryItemFactory;
import zombie.inventory.ItemContainer;
import zombie.inventory.ItemType;
import zombie.inventory.types.Clothing;
import zombie.inventory.types.Drainable;
import zombie.inventory.types.DrainableComboItem;
import zombie.inventory.types.Food;
import zombie.inventory.types.HandWeapon;
import zombie.inventory.types.InventoryContainer;
import zombie.inventory.types.Key;
import zombie.iso.IsoDirections;
import zombie.iso.IsoGridSquare;
import zombie.iso.IsoObject;
import zombie.iso.IsoWorld;
import zombie.iso.objects.IsoWorldInventoryObject;
import zombie.iso.objects.RainManager;
import zombie.network.GameClient;
import zombie.radio.ZomboidRadio;
import zombie.radio.media.MediaData;
import zombie.scripting.ScriptManager;
import zombie.scripting.objects.Item;
import zombie.scripting.objects.ItemReplacement;
import zombie.ui.ObjectTooltip;
import zombie.ui.TextManager;
import zombie.ui.UIFont;
import zombie.util.StringUtils;
import zombie.util.Type;
import zombie.util.io.BitHeader;
import zombie.util.io.BitHeaderRead;
import zombie.util.io.BitHeaderWrite;
import zombie.vehicles.VehiclePart;
import zombie.world.ItemInfo;
import zombie.world.WorldDictionary;

public class InventoryItem {
    protected IsoGameCharacter previousOwner = null;
    protected Item ScriptItem = null;
    protected ItemType cat = ItemType.None;
    protected ItemContainer container;
    protected int containerX = 0;
    protected int containerY = 0;
    protected String name;
    protected String replaceOnUse = null;
    protected String replaceOnUseFullType = null;
    protected int ConditionMax = 10;
    protected ItemContainer rightClickContainer = null;
    protected Texture texture;
    protected Texture texturerotten;
    protected Texture textureCooked;
    protected Texture textureBurnt;
    protected String type;
    protected String fullType;
    protected int uses = 1;
    protected float Age = 0.0f;
    protected float LastAged = -1.0f;
    protected boolean IsCookable = false;
    protected float CookingTime = 0.0f;
    protected float MinutesToCook = 60.0f;
    protected float MinutesToBurn = 120.0f;
    public boolean Cooked = false;
    protected boolean Burnt = false;
    protected int OffAge = 1000000000;
    protected int OffAgeMax = 1000000000;
    protected float Weight = 1.0f;
    protected float ActualWeight = 1.0f;
    protected String WorldTexture;
    protected String Description;
    protected int Condition = 10;
    protected String OffString = Translator.getText("Tooltip_food_Rotten");
    protected String FreshString = Translator.getText("Tooltip_food_Fresh");
    protected String StaleString = Translator.getText("Tooltip_food_Stale");
    protected String CookedString = Translator.getText("Tooltip_food_Cooked");
    protected String UnCookedString = Translator.getText("Tooltip_food_Uncooked");
    protected String FrozenString = Translator.getText("Tooltip_food_Frozen");
    protected String BurntString = Translator.getText("Tooltip_food_Burnt");
    private String brokenString = Translator.getText("Tooltip_broken");
    protected String module = "Base";
    protected float boredomChange = 0.0f;
    protected float unhappyChange = 0.0f;
    protected float stressChange = 0.0f;
    protected ArrayList<IsoObject> Taken = new ArrayList();
    protected IsoDirections placeDir = IsoDirections.Max;
    protected IsoDirections newPlaceDir = IsoDirections.Max;
    private KahluaTable table = null;
    public String ReplaceOnUseOn = null;
    public Color col = Color.white;
    public boolean IsWaterSource = false;
    public boolean CanStoreWater = false;
    public boolean CanStack = false;
    private boolean activated = false;
    private boolean isTorchCone = false;
    private int lightDistance = 0;
    private int Count = 1;
    public float fatigueChange = 0.0f;
    public IsoWorldInventoryObject worldItem = null;
    private String customMenuOption = null;
    private String tooltip = null;
    private String displayCategory = null;
    private int haveBeenRepaired = 1;
    private boolean broken = false;
    private String originalName = null;
    public int id = 0;
    public boolean RequiresEquippedBothHands;
    public ByteBuffer byteData;
    public ArrayList<String> extraItems = null;
    private boolean customName = false;
    private String breakSound = null;
    protected boolean alcoholic = false;
    private float alcoholPower = 0.0f;
    private float bandagePower = 0.0f;
    private float ReduceInfectionPower = 0.0f;
    private boolean customWeight = false;
    private boolean customColor = false;
    private int keyId = -1;
    private boolean taintedWater = false;
    private boolean remoteController = false;
    private boolean canBeRemote = false;
    private int remoteControlID = -1;
    private int remoteRange = 0;
    private float colorRed = 1.0f;
    private float colorGreen = 1.0f;
    private float colorBlue = 1.0f;
    private String countDownSound = null;
    private String explosionSound = null;
    private IsoGameCharacter equipParent = null;
    private String evolvedRecipeName = null;
    private float metalValue = 0.0f;
    private float itemHeat = 1.0f;
    private float meltingTime = 0.0f;
    private String worker;
    private boolean isWet = false;
    private float wetCooldown = -1.0f;
    private String itemWhenDry = null;
    private boolean favorite = false;
    protected ArrayList<String> requireInHandOrInventory = null;
    private String map = null;
    private String stashMap = null;
    public boolean keepOnDeplete = false;
    private boolean zombieInfected = false;
    private boolean rainFactorZero = false;
    private float itemCapacity = -1.0f;
    private int maxCapacity = -1;
    private float brakeForce = 0.0f;
    private int chanceToSpawnDamaged = 0;
    private float conditionLowerNormal = 0.0f;
    private float conditionLowerOffroad = 0.0f;
    private float wheelFriction = 0.0f;
    private float suspensionDamping = 0.0f;
    private float suspensionCompression = 0.0f;
    private float engineLoudness = 0.0f;
    protected ItemVisual visual = null;
    protected String staticModel = null;
    private ArrayList<String> iconsForTexture = null;
    private ArrayList<BloodClothingType> bloodClothingType = new ArrayList();
    private int stashChance = 80;
    private String ammoType = null;
    private int maxAmmo = 0;
    private int currentAmmoCount = 0;
    private String gunType = null;
    private String attachmentType = null;
    private ArrayList<String> attachmentsProvided = null;
    private int attachedSlot = -1;
    private String attachedSlotType = null;
    private String attachmentReplacement = null;
    private String attachedToModel = null;
    private String m_alternateModelName = null;
    private short registry_id = (short)-1;
    public int worldZRotation = -1;
    public float worldScale = 1.0f;
    private short recordedMediaIndex = (short)-1;
    private byte mediaType = (byte)-1;
    private boolean isInitialised = false;
    public WorldItemAtlas.ItemTexture atlasTexture = null;
    private final int maxTextLength = 256;
    public float jobDelta = 0.0f;
    public String jobType = null;
    static ByteBuffer tempBuffer = ByteBuffer.allocate(20000);
    public String mainCategory = null;
    private boolean canBeActivated;
    private float lightStrength;
    public String CloseKillMove = null;
    private boolean beingFilled = false;

    public int getSaveType() {
        throw new RuntimeException("InventoryItem.getSaveType() not implemented for " + this.getClass().getName());
    }

    public IsoWorldInventoryObject getWorldItem() {
        return this.worldItem;
    }

    public void setEquipParent(IsoGameCharacter isoGameCharacter) {
        this.equipParent = isoGameCharacter;
    }

    public IsoGameCharacter getEquipParent() {
        if (this.equipParent != null && (this.equipParent.getPrimaryHandItem() == this || this.equipParent.getSecondaryHandItem() == this)) {
            return this.equipParent;
        }
        return null;
    }

    public String getBringToBearSound() {
        return this.getScriptItem().getBringToBearSound();
    }

    public String getEquipSound() {
        return this.getScriptItem().getEquipSound();
    }

    public String getUnequipSound() {
        return this.getScriptItem().getUnequipSound();
    }

    public void setWorldItem(IsoWorldInventoryObject isoWorldInventoryObject) {
        this.worldItem = isoWorldInventoryObject;
    }

    public void setJobDelta(float f) {
        this.jobDelta = f;
    }

    public float getJobDelta() {
        return this.jobDelta;
    }

    public void setJobType(String string) {
        this.jobType = string;
    }

    public String getJobType() {
        return this.jobType;
    }

    public boolean hasModData() {
        return this.table != null && !this.table.isEmpty();
    }

    public KahluaTable getModData() {
        if (this.table == null) {
            this.table = LuaManager.platform.newTable();
        }
        return this.table;
    }

    public void storeInByteData(IsoObject isoObject) {
        tempBuffer.clear();
        try {
            isoObject.save(tempBuffer, false);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        tempBuffer.flip();
        if (this.byteData == null || this.byteData.capacity() < tempBuffer.limit() - 2 + 8) {
            this.byteData = ByteBuffer.allocate(tempBuffer.limit() - 2 + 8);
        }
        tempBuffer.get();
        tempBuffer.get();
        this.byteData.clear();
        this.byteData.put((byte)87);
        this.byteData.put((byte)86);
        this.byteData.put((byte)69);
        this.byteData.put((byte)82);
        this.byteData.putInt(195);
        this.byteData.put(tempBuffer);
        this.byteData.flip();
    }

    public ByteBuffer getByteData() {
        return this.byteData;
    }

    public boolean isRequiresEquippedBothHands() {
        return this.RequiresEquippedBothHands;
    }

    public float getA() {
        return this.col.a;
    }

    public float getR() {
        return this.col.r;
    }

    public float getG() {
        return this.col.g;
    }

    public float getB() {
        return this.col.b;
    }

    public InventoryItem(String string, String string2, String string3, String string4) {
        this.col = Color.white;
        this.texture = Texture.trygetTexture(string4);
        if (this.texture == null) {
            this.texture = Texture.getSharedTexture("media/inventory/Question_On.png");
        }
        this.module = string;
        this.name = string2;
        this.originalName = string2;
        this.type = string3;
        this.fullType = string + "." + string3;
        this.WorldTexture = string4.replace("Item_", "media/inventory/world/WItem_");
        this.WorldTexture = this.WorldTexture + ".png";
    }

    public InventoryItem(String string, String string2, String string3, Item item) {
        this.col = Color.white;
        this.texture = item.NormalTexture;
        this.module = string;
        this.name = string2;
        this.originalName = string2;
        this.type = string3;
        this.fullType = string + "." + string3;
        this.WorldTexture = item.WorldTextureName;
    }

    public String getType() {
        return this.type;
    }

    public Texture getTex() {
        return this.texture;
    }

    public String getCategory() {
        if (this.mainCategory != null) {
            return this.mainCategory;
        }
        return "Item";
    }

    public boolean IsRotten() {
        return this.Age > (float)this.OffAge;
    }

    public float HowRotten() {
        if (this.OffAgeMax - this.OffAge == 0) {
            return this.Age > (float)this.OffAge ? 1.0f : 0.0f;
        }
        float f = (this.Age - (float)this.OffAge) / (float)(this.OffAgeMax - this.OffAge);
        return f;
    }

    public boolean CanStack(InventoryItem inventoryItem) {
        return false;
    }

    public boolean ModDataMatches(InventoryItem inventoryItem) {
        KahluaTable kahluaTable = inventoryItem.getModData();
        KahluaTable kahluaTable2 = inventoryItem.getModData();
        if (kahluaTable == null && kahluaTable2 == null) {
            return true;
        }
        if (kahluaTable == null) {
            return false;
        }
        if (kahluaTable2 == null) {
            return false;
        }
        if (kahluaTable.len() != kahluaTable2.len()) {
            return false;
        }
        KahluaTableIterator kahluaTableIterator = kahluaTable.iterator();
        while (kahluaTableIterator.advance()) {
            Object object;
            Object object2 = kahluaTable2.rawget(kahluaTableIterator.getKey());
            if (object2.equals(object = kahluaTableIterator.getValue())) continue;
            return false;
        }
        return true;
    }

    public void DoTooltip(ObjectTooltip objectTooltip) {
        MediaData mediaData;
        Object object;
        InventoryItem inventoryItem;
        int n;
        int n2;
        int n3;
        String string;
        objectTooltip.render();
        UIFont uIFont = objectTooltip.getFont();
        int n4 = objectTooltip.getLineSpacing();
        int n5 = 5;
        Object object2 = "";
        if (this.Burnt) {
            object2 = (String)object2 + this.BurntString + " ";
        } else if (this.OffAge < 1000000000 && this.Age < (float)this.OffAge) {
            object2 = (String)object2 + this.FreshString + " ";
        } else if (this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAgeMax) {
            object2 = (String)object2 + this.OffString + " ";
        } else if (this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAge) {
            object2 = (String)object2 + this.StaleString + " ";
        }
        if (this.isCooked() && !this.Burnt && !this.hasTag("HideCooked")) {
            object2 = (String)object2 + this.CookedString + " ";
        } else if (this.IsCookable && !this.Burnt && !(this instanceof DrainableComboItem) && !this.hasTag("HideCooked")) {
            object2 = (String)object2 + this.UnCookedString + " ";
        }
        if (this instanceof Food && ((Food)this).isFrozen()) {
            object2 = (String)object2 + this.FrozenString + " ";
        }
        if (((String)(object2 = ((String)object2).trim())).isEmpty()) {
            string = this.getName();
            objectTooltip.DrawText(uIFont, string, 5.0, n5, 1.0, 1.0, 0.8f, 1.0);
        } else if (this.OffAgeMax < 1000000000 && this.Age >= (float)this.OffAgeMax) {
            string = Translator.getText("IGUI_FoodNaming", object2, this.name);
            objectTooltip.DrawText(uIFont, string, 5.0, n5, 1.0, 0.1f, 0.1f, 1.0);
        } else {
            string = Translator.getText("IGUI_FoodNaming", object2, this.name);
            objectTooltip.DrawText(uIFont, string, 5.0, n5, 1.0, 1.0, 0.8f, 1.0);
        }
        objectTooltip.adjustWidth(5, string);
        n5 += n4 + 5;
        if (this.extraItems != null) {
            objectTooltip.DrawText(uIFont, Translator.getText("Tooltip_item_Contains"), 5.0, n5, 1.0, 1.0, 0.8f, 1.0);
            n3 = 5 + TextManager.instance.MeasureStringX(uIFont, Translator.getText("Tooltip_item_Contains")) + 4;
            n2 = (n4 - 10) / 2;
            for (n = 0; n < this.extraItems.size(); ++n) {
                inventoryItem = InventoryItemFactory.CreateItem(this.extraItems.get(n));
                if (!this.IsCookable && inventoryItem.IsCookable) {
                    inventoryItem.setCooked(true);
                }
                if (this.isCooked() && inventoryItem.IsCookable) {
                    inventoryItem.setCooked(true);
                }
                objectTooltip.DrawTextureScaled(inventoryItem.getTex(), n3, n5 + n2, 10.0, 10.0, 1.0);
                n3 += 11;
            }
            n5 = n5 + n4 + 5;
        }
        if (this instanceof Food && ((Food)this).spices != null) {
            objectTooltip.DrawText(uIFont, Translator.getText("Tooltip_item_Spices"), 5.0, n5, 1.0, 1.0, 0.8f, 1.0);
            n3 = 5 + TextManager.instance.MeasureStringX(uIFont, Translator.getText("Tooltip_item_Spices")) + 4;
            n2 = (n4 - 10) / 2;
            for (n = 0; n < ((Food)this).spices.size(); ++n) {
                inventoryItem = InventoryItemFactory.CreateItem(((Food)this).spices.get(n));
                objectTooltip.DrawTextureScaled(inventoryItem.getTex(), n3, n5 + n2, 10.0, 10.0, 1.0);
                n3 += 11;
            }
            n5 = n5 + n4 + 5;
        }
        ObjectTooltip.Layout layout = objectTooltip.beginLayout();
        layout.setMinLabelWidth(80);
        ObjectTooltip.LayoutItem layoutItem = layout.addItem();
        layoutItem.setLabel(Translator.getText("Tooltip_item_Weight") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
        n = this.isEquipped();
        if (this instanceof HandWeapon || this instanceof Clothing || this instanceof DrainableComboItem || this.getFullType().contains("Walkie")) {
            if (n != 0) {
                layoutItem.setValue(this.getCleanString(this.getEquippedWeight()) + "    (" + this.getCleanString(this.getUnequippedWeight()) + " " + Translator.getText("Tooltip_item_Unequipped") + ")", 1.0f, 1.0f, 1.0f, 1.0f);
            } else if (this.getAttachedSlot() > -1) {
                layoutItem.setValue(this.getCleanString(this.getHotbarEquippedWeight()) + "    (" + this.getCleanString(this.getUnequippedWeight()) + " " + Translator.getText("Tooltip_item_Unequipped") + ")", 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                layoutItem.setValue(this.getCleanString(this.getUnequippedWeight()) + "    (" + this.getCleanString(this.getEquippedWeight()) + " " + Translator.getText("Tooltip_item_Equipped") + ")", 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            float f = this.getUnequippedWeight();
            if (f > 0.0f && f < 0.01f) {
                f = 0.01f;
            }
            layoutItem.setValueRightNoPlus(f);
        }
        if (objectTooltip.getWeightOfStack() > 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_item_StackWeight") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            float f = objectTooltip.getWeightOfStack();
            if (f > 0.0f && f < 0.01f) {
                f = 0.01f;
            }
            layoutItem.setValueRightNoPlus(f);
        }
        if (this.getMaxAmmo() > 0 && !(this instanceof HandWeapon)) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_AmmoCount") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(this.getCurrentAmmoCount() + " / " + this.getMaxAmmo(), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (!(this instanceof HandWeapon) && this.getAmmoType() != null) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("ContextMenu_AmmoType") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            String string2 = InventoryItemFactory.CreateItem(this.getAmmoType()).getDisplayName();
            layoutItem.setValue(Translator.getText(string2), 1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.gunType != null) {
            Item item = ScriptManager.instance.FindItem(this.getGunType());
            if (item == null) {
                item = ScriptManager.instance.FindItem(this.getModule() + "." + this.ammoType);
            }
            if (item != null) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("ContextMenu_GunType") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValue(item.getDisplayName(), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (Core.bDebug && DebugOptions.instance.TooltipInfo.getValue()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel("getActualWeight()", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getActualWeight());
            layoutItem = layout.addItem();
            layoutItem.setLabel("getWeight()", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getWeight());
            layoutItem = layout.addItem();
            layoutItem.setLabel("getEquippedWeight()", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getEquippedWeight());
            layoutItem = layout.addItem();
            layoutItem.setLabel("getUnequippedWeight()", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getUnequippedWeight());
            layoutItem = layout.addItem();
            layoutItem.setLabel("getContentsWeight()", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.getContentsWeight());
            if (this instanceof Key || "Doorknob".equals(this.type)) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("DBG: keyId", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValueRightNoPlus(this.getKeyId());
            }
            layoutItem = layout.addItem();
            layoutItem.setLabel("ID", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.id);
            layoutItem = layout.addItem();
            layoutItem.setLabel("DictionaryID", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRightNoPlus(this.registry_id);
            ClothingItem clothingItem = this.getClothingItem();
            if (clothingItem != null) {
                layoutItem = layout.addItem();
                layoutItem.setLabel("ClothingItem", 1.0f, 1.0f, 1.0f, 1.0f);
                layoutItem.setValue(this.getClothingItem().m_Name, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.getFatigueChange() != 0.0f) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_item_Fatigue") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValueRight((int)(this.getFatigueChange() * 100.0f), false);
        }
        if (this instanceof DrainableComboItem) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("IGUI_invpanel_Remaining") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
            float f = ((DrainableComboItem)this).getUsedDelta();
            object = new ColorInfo();
            Core.getInstance().getBadHighlitedColor().interp(Core.getInstance().getGoodHighlitedColor(), f, (ColorInfo)object);
            layoutItem.setProgress(f, ((ColorInfo)object).getR(), ((ColorInfo)object).getG(), ((ColorInfo)object).getB(), 1.0f);
        }
        if (this.isTaintedWater() && SandboxOptions.instance.EnableTaintedWaterText.getValue()) {
            layoutItem = layout.addItem();
            if (this.isCookable()) {
                layoutItem.setLabel(Translator.getText("Tooltip_item_TaintedWater"), 1.0f, 0.5f, 0.5f, 1.0f);
            } else {
                layoutItem.setLabel(Translator.getText("Tooltip_item_TaintedWater_Plastic"), 1.0f, 0.5f, 0.5f, 1.0f);
            }
        }
        this.DoTooltip(objectTooltip, layout);
        if (this.getRemoteControlID() != -1) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_TrapControllerID"), 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(Integer.toString(this.getRemoteControlID()), 1.0f, 1.0f, 0.8f, 1.0f);
        }
        if (!FixingManager.getFixes(this).isEmpty()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Repaired") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            if (this.getHaveBeenRepaired() == 1) {
                layoutItem.setValue(Translator.getText("Tooltip_never"), 1.0f, 1.0f, 1.0f, 1.0f);
            } else {
                layoutItem.setValue(this.getHaveBeenRepaired() - 1 + "x", 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (this.isEquippedNoSprint()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_CantSprintEquipped"), 1.0f, 0.1f, 0.1f, 1.0f);
        }
        if (this.isWet()) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_Wetness") + ": ", 1.0f, 1.0f, 0.8f, 1.0f);
            float f = this.getWetCooldown() / 10000.0f;
            object = new ColorInfo();
            Core.getInstance().getGoodHighlitedColor().interp(Core.getInstance().getBadHighlitedColor(), f, (ColorInfo)object);
            layoutItem.setProgress(f, ((ColorInfo)object).getR(), ((ColorInfo)object).getG(), ((ColorInfo)object).getB(), 1.0f);
        }
        if (this.getMaxCapacity() > 0) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_container_Capacity") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            float f = this.getMaxCapacity();
            if (this.isConditionAffectsCapacity()) {
                f = VehiclePart.getNumberByCondition(this.getMaxCapacity(), this.getCondition(), 5.0f);
            }
            if (this.getItemCapacity() > -1.0f) {
                layoutItem.setValue(this.getItemCapacity() + " / " + f, 1.0f, 1.0f, 0.8f, 1.0f);
            } else {
                layoutItem.setValue("0 / " + f, 1.0f, 1.0f, 0.8f, 1.0f);
            }
        }
        if (this.getConditionMax() > 0 && this.getMechanicType() > 0) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText("Tooltip_weapon_Condition") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
            layoutItem.setValue(this.getCondition() + " / " + this.getConditionMax(), 1.0f, 1.0f, 0.8f, 1.0f);
        }
        if (this.isRecordedMedia() && (mediaData = this.getMediaData()) != null) {
            if (mediaData.getTranslatedTitle() != null) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_media_title") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValue(mediaData.getTranslatedTitle(), 1.0f, 1.0f, 1.0f, 1.0f);
                if (mediaData.getTranslatedSubTitle() != null) {
                    layoutItem = layout.addItem();
                    layoutItem.setLabel("", 1.0f, 1.0f, 0.8f, 1.0f);
                    layoutItem.setValue(mediaData.getTranslatedSubTitle(), 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (mediaData.getTranslatedAuthor() != null) {
                layoutItem = layout.addItem();
                layoutItem.setLabel(Translator.getText("Tooltip_media_author") + ":", 1.0f, 1.0f, 0.8f, 1.0f);
                layoutItem.setValue(mediaData.getTranslatedAuthor(), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        if (Core.getInstance().getOptionShowItemModInfo() && !this.isVanilla()) {
            layoutItem = layout.addItem();
            Color color = Colors.CornFlowerBlue;
            layoutItem.setLabel("Mod: " + this.getModName(), color.r, color.g, color.b, 1.0f);
            object = WorldDictionary.getItemInfoFromID(this.registry_id);
            if (object != null && ((ItemInfo)object).getModOverrides() != null) {
                layoutItem = layout.addItem();
                float f = 0.5f;
                if (((ItemInfo)object).getModOverrides().size() == 1) {
                    layoutItem.setLabel("This item overrides: " + WorldDictionary.getModNameFromID(((ItemInfo)object).getModOverrides().get(0)), f, f, f, 1.0f);
                } else {
                    layoutItem.setLabel("This item overrides:", f, f, f, 1.0f);
                    for (int i = 0; i < ((ItemInfo)object).getModOverrides().size(); ++i) {
                        layoutItem = layout.addItem();
                        layoutItem.setLabel(" - " + WorldDictionary.getModNameFromID(((ItemInfo)object).getModOverrides().get(i)), f, f, f, 1.0f);
                    }
                }
            }
        }
        if (this.getTooltip() != null) {
            layoutItem = layout.addItem();
            layoutItem.setLabel(Translator.getText(this.tooltip), 1.0f, 1.0f, 0.8f, 1.0f);
        }
        n5 = layout.render(5, n5, objectTooltip);
        objectTooltip.endLayout(layout);
        objectTooltip.setHeight(n5 += objectTooltip.padBottom);
        if (objectTooltip.getWidth() < 150.0) {
            objectTooltip.setWidth(150.0);
        }
    }

    public String getCleanString(float f) {
        float f2 = (float)((int)(((double)f + 0.005) * 100.0)) / 100.0f;
        String string = Float.toString(f2);
        return string;
    }

    public void DoTooltip(ObjectTooltip objectTooltip, ObjectTooltip.Layout layout) {
    }

    public void SetContainerPosition(int n, int n2) {
        this.containerX = n;
        this.containerY = n2;
    }

    public void Use() {
        this.Use(false);
    }

    public void UseItem() {
        this.Use(false);
    }

    public void Use(boolean bl) {
        this.Use(bl, false);
    }

    public void Use(boolean bl, boolean bl2) {
        Object object;
        if (!this.isDisappearOnUse() && !bl) {
            return;
        }
        --this.uses;
        if (this.replaceOnUse != null && !bl2 && !bl && this.container != null) {
            InventoryItem inventoryItem;
            object = this.replaceOnUse;
            if (!this.replaceOnUse.contains(".")) {
                object = this.module + "." + (String)object;
            }
            if ((inventoryItem = this.container.AddItem((String)object)) != null) {
                inventoryItem.setConditionFromModData(this);
            }
            this.container.setDrawDirty(true);
            this.container.setDirty(true);
            inventoryItem.setFavorite(this.isFavorite());
        }
        if (this.uses <= 0) {
            if (this.keepOnDeplete) {
                return;
            }
            if (this.container != null) {
                if (this.container.parent instanceof IsoGameCharacter && !(this instanceof HandWeapon)) {
                    object = (IsoGameCharacter)this.container.parent;
                    ((IsoGameCharacter)object).removeFromHands(this);
                }
                this.container.Items.remove(this);
                this.container.setDirty(true);
                this.container.setDrawDirty(true);
                this.container = null;
            }
        }
    }

    public boolean shouldUpdateInWorld() {
        if (!GameClient.bClient && !this.rainFactorZero && this.canStoreWater() && this.hasReplaceType("WaterSource")) {
            IsoGridSquare isoGridSquare = this.getWorldItem().getSquare();
            return isoGridSquare != null && isoGridSquare.isOutside();
        }
        return false;
    }

    public void update() {
        Object object;
        Object object2;
        Object object3;
        if (this.isWet()) {
            this.wetCooldown -= 1.0f * GameTime.instance.getMultiplier();
            if (this.wetCooldown <= 0.0f) {
                object3 = InventoryItemFactory.CreateItem(this.itemWhenDry);
                if (this.isFavorite()) {
                    ((InventoryItem)object3).setFavorite(true);
                }
                if ((object2 = this.getWorldItem()) != null) {
                    object = ((IsoObject)object2).getSquare();
                    ((IsoGridSquare)object).AddWorldInventoryItem((InventoryItem)object3, ((IsoObject)object2).getX() % 1.0f, ((IsoObject)object2).getY() % 1.0f, ((IsoObject)object2).getZ() % 1.0f);
                    ((IsoGridSquare)object).transmitRemoveItemFromSquare((IsoObject)object2);
                    if (this.getContainer() != null) {
                        this.getContainer().setDirty(true);
                        this.getContainer().setDrawDirty(true);
                    }
                    ((IsoGridSquare)object).chunk.recalcHashCodeObjects();
                    this.setWorldItem(null);
                } else if (this.getContainer() != null) {
                    this.getContainer().addItem((InventoryItem)object3);
                    this.getContainer().Remove(this);
                }
                this.setWet(false);
                IsoWorld.instance.CurrentCell.addToProcessItemsRemove(this);
                LuaEventManager.triggerEvent("OnContainerUpdate");
            }
        }
        if (!GameClient.bClient && !this.rainFactorZero && this.getWorldItem() != null && this.canStoreWater() && this.hasReplaceType("WaterSource") && RainManager.isRaining().booleanValue() && (object2 = ((IsoObject)(object3 = this.getWorldItem())).getSquare()) != null && ((IsoGridSquare)object2).isOutside()) {
            object = InventoryItemFactory.CreateItem(this.getReplaceType("WaterSource"));
            if (object == null) {
                this.rainFactorZero = true;
                return;
            }
            ((InventoryItem)object).setCondition(this.getCondition());
            if (object instanceof DrainableComboItem && ((InventoryItem)object).canStoreWater()) {
                if (((DrainableComboItem)object).getRainFactor() == 0.0f) {
                    this.rainFactorZero = true;
                    return;
                }
                ((DrainableComboItem)object).setUsedDelta(0.0f);
                ((IsoWorldInventoryObject)object3).swapItem((InventoryItem)object);
            }
        }
    }

    public boolean finishupdate() {
        if (!GameClient.bClient && !this.rainFactorZero && this.canStoreWater() && this.hasReplaceType("WaterSource") && this.getWorldItem() != null && this.getWorldItem().getObjectIndex() != -1) {
            return false;
        }
        return !this.isWet();
    }

    public void updateSound(BaseSoundEmitter baseSoundEmitter) {
    }

    public String getFullType() {
        assert (this.fullType != null && this.fullType.equals(this.module + "." + this.type));
        return this.fullType;
    }

    public void save(ByteBuffer byteBuffer, boolean bl) throws IOException {
        int n;
        bl = false;
        if (GameWindow.DEBUG_SAVE) {
            DebugLog.log(this.getFullType());
        }
        byteBuffer.putShort(this.registry_id);
        byteBuffer.put((byte)this.getSaveType());
        byteBuffer.putInt(this.id);
        BitHeaderWrite bitHeaderWrite = BitHeader.allocWrite(BitHeader.HeaderSize.Byte, byteBuffer);
        if (this.uses != 1) {
            bitHeaderWrite.addFlags(1);
            if (this.uses > Short.MAX_VALUE) {
                byteBuffer.putShort((short)Short.MAX_VALUE);
            } else {
                byteBuffer.putShort((short)this.uses);
            }
        }
        if (this.IsDrainable() && ((DrainableComboItem)this).getUsedDelta() < 1.0f) {
            bitHeaderWrite.addFlags(2);
            float f = ((DrainableComboItem)this).getUsedDelta();
            n = (byte)(f * 255.0f) + -128;
            byteBuffer.put((byte)n);
        }
        if (this.Condition != this.ConditionMax) {
            bitHeaderWrite.addFlags(4);
            byteBuffer.put((byte)this.getCondition());
        }
        if (this.visual != null) {
            bitHeaderWrite.addFlags(8);
            this.visual.save(byteBuffer);
        }
        if (this.isCustomColor() && (this.col.r != 1.0f || this.col.g != 1.0f || this.col.b != 1.0f || this.col.a != 1.0f)) {
            bitHeaderWrite.addFlags(16);
            byteBuffer.put(Bits.packFloatUnitToByte(this.getColor().r));
            byteBuffer.put(Bits.packFloatUnitToByte(this.getColor().g));
            byteBuffer.put(Bits.packFloatUnitToByte(this.getColor().b));
            byteBuffer.put(Bits.packFloatUnitToByte(this.getColor().a));
        }
        if (this.itemCapacity != -1.0f) {
            bitHeaderWrite.addFlags(32);
            byteBuffer.putFloat(this.itemCapacity);
        }
        BitHeaderWrite bitHeaderWrite2 = BitHeader.allocWrite(BitHeader.HeaderSize.Integer, byteBuffer);
        if (this.table != null && !this.table.isEmpty()) {
            bitHeaderWrite2.addFlags(1);
            this.table.save(byteBuffer);
        }
        if (this.isActivated()) {
            bitHeaderWrite2.addFlags(2);
        }
        if (this.haveBeenRepaired != 1) {
            bitHeaderWrite2.addFlags(4);
            byteBuffer.putShort((short)this.getHaveBeenRepaired());
        }
        if (this.name != null && !this.name.equals(this.originalName)) {
            bitHeaderWrite2.addFlags(8);
            GameWindow.WriteString(byteBuffer, this.name);
        }
        if (this.byteData != null) {
            bitHeaderWrite2.addFlags(16);
            this.byteData.rewind();
            byteBuffer.putInt(this.byteData.limit());
            byteBuffer.put(this.byteData);
            this.byteData.flip();
        }
        if (this.extraItems != null && this.extraItems.size() > 0) {
            bitHeaderWrite2.addFlags(32);
            byteBuffer.putInt(this.extraItems.size());
            for (n = 0; n < this.extraItems.size(); ++n) {
                byteBuffer.putShort(WorldDictionary.getItemRegistryID(this.extraItems.get(n)));
            }
        }
        if (this.isCustomName()) {
            bitHeaderWrite2.addFlags(64);
        }
        if (this.isCustomWeight()) {
            bitHeaderWrite2.addFlags(128);
            byteBuffer.putFloat(this.isCustomWeight() ? this.getActualWeight() : -1.0f);
        }
        if (this.keyId != -1) {
            bitHeaderWrite2.addFlags(256);
            byteBuffer.putInt(this.getKeyId());
        }
        if (this.isTaintedWater()) {
            bitHeaderWrite2.addFlags(512);
        }
        if (this.remoteControlID != -1 || this.remoteRange != 0) {
            bitHeaderWrite2.addFlags(1024);
            byteBuffer.putInt(this.getRemoteControlID());
            byteBuffer.putInt(this.getRemoteRange());
        }
        if (this.colorRed != 1.0f || this.colorGreen != 1.0f || this.colorBlue != 1.0f) {
            bitHeaderWrite2.addFlags(2048);
            byteBuffer.put(Bits.packFloatUnitToByte(this.colorRed));
            byteBuffer.put(Bits.packFloatUnitToByte(this.colorGreen));
            byteBuffer.put(Bits.packFloatUnitToByte(this.colorBlue));
        }
        if (this.worker != null) {
            bitHeaderWrite2.addFlags(4096);
            GameWindow.WriteString(byteBuffer, this.getWorker());
        }
        if (this.wetCooldown != -1.0f) {
            bitHeaderWrite2.addFlags(8192);
            byteBuffer.putFloat(this.wetCooldown);
        }
        if (this.isFavorite()) {
            bitHeaderWrite2.addFlags(16384);
        }
        if (this.stashMap != null) {
            bitHeaderWrite2.addFlags(32768);
            GameWindow.WriteString(byteBuffer, this.stashMap);
        }
        if (this.isInfected()) {
            bitHeaderWrite2.addFlags(65536);
        }
        if (this.currentAmmoCount != 0) {
            bitHeaderWrite2.addFlags(131072);
            byteBuffer.putInt(this.currentAmmoCount);
        }
        if (this.attachedSlot != -1) {
            bitHeaderWrite2.addFlags(262144);
            byteBuffer.putInt(this.attachedSlot);
        }
        if (this.attachedSlotType != null) {
            bitHeaderWrite2.addFlags(524288);
            GameWindow.WriteString(byteBuffer, this.attachedSlotType);
        }
        if (this.attachedToModel != null) {
            bitHeaderWrite2.addFlags(0x100000);
            GameWindow.WriteString(byteBuffer, this.attachedToModel);
        }
        if (this.maxCapacity != -1) {
            bitHeaderWrite2.addFlags(0x200000);
            byteBuffer.putInt(this.maxCapacity);
        }
        if (this.isRecordedMedia()) {
            bitHeaderWrite2.addFlags(0x400000);
            byteBuffer.putShort(this.recordedMediaIndex);
        }
        if (this.worldZRotation > -1) {
            bitHeaderWrite2.addFlags(0x800000);
            byteBuffer.putInt(this.worldZRotation);
        }
        if (this.worldScale != 1.0f) {
            bitHeaderWrite2.addFlags(0x1000000);
            byteBuffer.putFloat(this.worldScale);
        }
        if (this.isInitialised) {
            bitHeaderWrite2.addFlags(0x2000000);
        }
        if (!bitHeaderWrite2.equals(0)) {
            bitHeaderWrite.addFlags(64);
            bitHeaderWrite2.write();
        } else {
            byteBuffer.position(bitHeaderWrite2.getStartPosition());
        }
        bitHeaderWrite.write();
        bitHeaderWrite.release();
        bitHeaderWrite2.release();
    }

    public static InventoryItem loadItem(ByteBuffer byteBuffer, int n) throws IOException {
        return InventoryItem.loadItem(byteBuffer, n, true);
    }

    public static InventoryItem loadItem(ByteBuffer byteBuffer, int n, boolean bl) throws IOException {
        int n2 = byteBuffer.getInt();
        if (n2 <= 0) {
            throw new IOException("InventoryItem.loadItem() invalid item data length: " + n2);
        }
        int n3 = byteBuffer.position();
        short s = byteBuffer.getShort();
        byte by = -1;
        if (n >= 70 && (by = (byte)byteBuffer.get()) < 0) {
            DebugLog.log("InventoryItem.loadItem() invalid item save-type " + by + ", itemtype: " + WorldDictionary.getItemTypeDebugString(s));
            return null;
        }
        InventoryItem inventoryItem = InventoryItemFactory.CreateItem(s);
        if (bl && by != -1 && inventoryItem != null && inventoryItem.getSaveType() != by) {
            DebugLog.log("InventoryItem.loadItem() ignoring \"" + inventoryItem.getFullType() + "\" because type changed from " + by + " to " + inventoryItem.getSaveType());
            inventoryItem = null;
        }
        if (inventoryItem != null) {
            try {
                inventoryItem.load(byteBuffer, n);
            }
            catch (Exception exception) {
                ExceptionLogger.logException(exception);
                inventoryItem = null;
            }
        }
        if (inventoryItem == null) {
            if (byteBuffer.position() < n3 + n2) {
                while (byteBuffer.position() < n3 + n2) {
                    byteBuffer.get();
                }
                DebugLog.log("InventoryItem.loadItem() item == null, skipped bytes. itemtype: " + WorldDictionary.getItemTypeDebugString(s));
            } else if (byteBuffer.position() >= n3 + n2) {
                byteBuffer.position(n3 + n2);
                DebugLog.log("InventoryItem.loadItem() item == null, resetting buffer position to '" + (n3 + n2) + "'. itemtype: " + WorldDictionary.getItemTypeDebugString(s));
            }
            return null;
        }
        if (n2 != -1 && byteBuffer.position() != n3 + n2) {
            byteBuffer.position(n3 + n2);
            DebugLog.log("InventoryItem.loadItem() data length not matching, resetting buffer position to '" + (n3 + n2) + "'. itemtype: " + WorldDictionary.getItemTypeDebugString(s));
            if (Core.bDebug) {
                throw new IOException("InventoryItem.loadItem() read more data than save() wrote (" + WorldDictionary.getItemTypeDebugString(s) + ")");
            }
        }
        return inventoryItem;
    }

    public void load(ByteBuffer byteBuffer, int n) throws IOException {
        this.id = byteBuffer.getInt();
        BitHeaderRead bitHeaderRead = BitHeader.allocRead(BitHeader.HeaderSize.Byte, byteBuffer);
        this.uses = 1;
        if (this.IsDrainable()) {
            ((DrainableComboItem)this).setUsedDelta(1.0f);
        }
        this.Condition = this.ConditionMax;
        this.customColor = false;
        this.col = Color.white;
        this.itemCapacity = -1.0f;
        this.activated = false;
        this.haveBeenRepaired = 1;
        this.customName = false;
        this.customWeight = false;
        this.keyId = -1;
        this.taintedWater = false;
        this.remoteControlID = -1;
        this.remoteRange = 0;
        this.colorBlue = 1.0f;
        this.colorGreen = 1.0f;
        this.colorRed = 1.0f;
        this.worker = null;
        this.wetCooldown = -1.0f;
        this.favorite = false;
        this.stashMap = null;
        this.zombieInfected = false;
        this.currentAmmoCount = 0;
        this.attachedSlot = -1;
        this.attachedSlotType = null;
        this.attachedToModel = null;
        this.maxCapacity = -1;
        this.recordedMediaIndex = (short)-1;
        this.worldZRotation = -1;
        this.worldScale = 1.0f;
        this.isInitialised = false;
        if (!bitHeaderRead.equals(0)) {
            float f;
            float f2;
            float f3;
            if (bitHeaderRead.hasFlags(1)) {
                this.uses = byteBuffer.getShort();
            }
            if (bitHeaderRead.hasFlags(2)) {
                byte by = byteBuffer.get();
                f3 = PZMath.clamp((float)(by - -128) / 255.0f, 0.0f, 1.0f);
                ((DrainableComboItem)this).setUsedDelta(f3);
            }
            if (bitHeaderRead.hasFlags(4)) {
                this.setCondition(byteBuffer.get(), false);
            }
            if (bitHeaderRead.hasFlags(8)) {
                this.visual = new ItemVisual();
                this.visual.load(byteBuffer, n);
            }
            if (bitHeaderRead.hasFlags(16)) {
                float f4 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                f3 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                f2 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                f = Bits.unpackByteToFloatUnit(byteBuffer.get());
                this.setColor(new Color(f4, f3, f2, f));
            }
            if (bitHeaderRead.hasFlags(32)) {
                this.itemCapacity = byteBuffer.getFloat();
            }
            if (bitHeaderRead.hasFlags(64)) {
                float f5;
                int n2;
                BitHeaderRead bitHeaderRead2 = BitHeader.allocRead(BitHeader.HeaderSize.Integer, byteBuffer);
                if (bitHeaderRead2.hasFlags(1)) {
                    if (this.table == null) {
                        this.table = LuaManager.platform.newTable();
                    }
                    this.table.load(byteBuffer, n);
                }
                this.activated = bitHeaderRead2.hasFlags(2);
                if (bitHeaderRead2.hasFlags(4)) {
                    this.setHaveBeenRepaired(byteBuffer.getShort());
                }
                if (bitHeaderRead2.hasFlags(8)) {
                    this.name = GameWindow.ReadString(byteBuffer);
                }
                if (bitHeaderRead2.hasFlags(16)) {
                    int n3 = byteBuffer.getInt();
                    this.byteData = ByteBuffer.allocate(n3);
                    for (int i = 0; i < n3; ++i) {
                        this.byteData.put(byteBuffer.get());
                    }
                    this.byteData.flip();
                }
                if (bitHeaderRead2.hasFlags(32) && (n2 = byteBuffer.getInt()) > 0) {
                    this.extraItems = new ArrayList();
                    for (int i = 0; i < n2; ++i) {
                        short s = byteBuffer.getShort();
                        String string = WorldDictionary.getItemTypeFromID(s);
                        this.extraItems.add(string);
                    }
                }
                this.setCustomName(bitHeaderRead2.hasFlags(64));
                if (bitHeaderRead2.hasFlags(128) && (f5 = byteBuffer.getFloat()) >= 0.0f) {
                    this.setActualWeight(f5);
                    this.setWeight(f5);
                    this.setCustomWeight(true);
                }
                if (bitHeaderRead2.hasFlags(256)) {
                    this.setKeyId(byteBuffer.getInt());
                }
                this.setTaintedWater(bitHeaderRead2.hasFlags(512));
                if (bitHeaderRead2.hasFlags(1024)) {
                    this.setRemoteControlID(byteBuffer.getInt());
                    this.setRemoteRange(byteBuffer.getInt());
                }
                if (bitHeaderRead2.hasFlags(2048)) {
                    float f6 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    f2 = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    f = Bits.unpackByteToFloatUnit(byteBuffer.get());
                    this.setColorRed(f6);
                    this.setColorGreen(f2);
                    this.setColorBlue(f);
                    this.setColor(new Color(this.colorRed, this.colorGreen, this.colorBlue));
                }
                if (bitHeaderRead2.hasFlags(4096)) {
                    this.setWorker(GameWindow.ReadString(byteBuffer));
                }
                if (bitHeaderRead2.hasFlags(8192)) {
                    this.setWetCooldown(byteBuffer.getFloat());
                }
                this.setFavorite(bitHeaderRead2.hasFlags(16384));
                if (bitHeaderRead2.hasFlags(32768)) {
                    this.stashMap = GameWindow.ReadString(byteBuffer);
                }
                this.setInfected(bitHeaderRead2.hasFlags(65536));
                if (bitHeaderRead2.hasFlags(131072)) {
                    this.setCurrentAmmoCount(byteBuffer.getInt());
                }
                if (bitHeaderRead2.hasFlags(262144)) {
                    this.attachedSlot = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(524288)) {
                    if (n < 179) {
                        short s = byteBuffer.getShort();
                        this.attachedSlotType = null;
                    } else {
                        this.attachedSlotType = GameWindow.ReadString(byteBuffer);
                    }
                }
                if (bitHeaderRead2.hasFlags(0x100000)) {
                    this.attachedToModel = GameWindow.ReadString(byteBuffer);
                }
                if (bitHeaderRead2.hasFlags(0x200000)) {
                    this.maxCapacity = byteBuffer.getInt();
                }
                if (bitHeaderRead2.hasFlags(0x400000)) {
                    this.setRecordedMediaIndex(byteBuffer.getShort());
                }
                if (bitHeaderRead2.hasFlags(0x800000)) {
                    this.setWorldZRotation(byteBuffer.getInt());
                }
                if (bitHeaderRead2.hasFlags(0x1000000)) {
                    this.worldScale = byteBuffer.getFloat();
                }
                this.setInitialised(bitHeaderRead2.hasFlags(0x2000000));
                bitHeaderRead2.release();
            }
        }
        bitHeaderRead.release();
    }

    public boolean IsFood() {
        return false;
    }

    public boolean IsWeapon() {
        return false;
    }

    public boolean IsDrainable() {
        return false;
    }

    public boolean IsLiterature() {
        return false;
    }

    public boolean IsClothing() {
        return false;
    }

    public boolean IsInventoryContainer() {
        return false;
    }

    public boolean IsMap() {
        return false;
    }

    static InventoryItem LoadFromFile(DataInputStream dataInputStream) throws IOException {
        GameWindow.ReadString(dataInputStream);
        return null;
    }

    public ItemContainer getOutermostContainer() {
        if (this.container == null || "floor".equals(this.container.type)) {
            return null;
        }
        ItemContainer itemContainer = this.container;
        while (itemContainer.getContainingItem() != null && itemContainer.getContainingItem().getContainer() != null && !"floor".equals(itemContainer.getContainingItem().getContainer().type)) {
            itemContainer = itemContainer.getContainingItem().getContainer();
        }
        return itemContainer;
    }

    public boolean isInLocalPlayerInventory() {
        if (!GameClient.bClient) {
            return false;
        }
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer == null) {
            return false;
        }
        if (itemContainer.getParent() instanceof IsoPlayer) {
            return ((IsoPlayer)itemContainer.getParent()).isLocalPlayer();
        }
        return false;
    }

    public boolean isInPlayerInventory() {
        ItemContainer itemContainer = this.getOutermostContainer();
        if (itemContainer == null) {
            return false;
        }
        return itemContainer.getParent() instanceof IsoPlayer;
    }

    public ItemReplacement getItemReplacementPrimaryHand() {
        return this.ScriptItem.replacePrimaryHand;
    }

    public ItemReplacement getItemReplacementSecondHand() {
        return this.ScriptItem.replaceSecondHand;
    }

    public ClothingItem getClothingItem() {
        if ("RightHand".equalsIgnoreCase(this.getAlternateModelName())) {
            return this.getItemReplacementPrimaryHand().clothingItem;
        }
        if ("LeftHand".equalsIgnoreCase(this.getAlternateModelName())) {
            return this.getItemReplacementSecondHand().clothingItem;
        }
        return this.ScriptItem.getClothingItemAsset();
    }

    public String getAlternateModelName() {
        if (this.getContainer() != null && this.getContainer().getParent() instanceof IsoGameCharacter) {
            IsoGameCharacter isoGameCharacter = (IsoGameCharacter)this.getContainer().getParent();
            if (isoGameCharacter.getPrimaryHandItem() == this && this.getItemReplacementPrimaryHand() != null) {
                return "RightHand";
            }
            if (isoGameCharacter.getSecondaryHandItem() == this && this.getItemReplacementSecondHand() != null) {
                return "LeftHand";
            }
        }
        return this.m_alternateModelName;
    }

    public ItemVisual getVisual() {
        ClothingItem clothingItem = this.getClothingItem();
        if (clothingItem == null || !clothingItem.isReady()) {
            this.visual = null;
            return null;
        }
        if (this.visual == null) {
            this.visual = new ItemVisual();
            this.visual.setItemType(this.getFullType());
            this.visual.pickUninitializedValues(clothingItem);
        }
        this.visual.setClothingItemName(clothingItem.m_Name);
        this.visual.setAlternateModelName(this.getAlternateModelName());
        return this.visual;
    }

    public boolean allowRandomTint() {
        ClothingItem clothingItem = this.getClothingItem();
        if (clothingItem != null) {
            return clothingItem.m_AllowRandomTint;
        }
        return false;
    }

    public void synchWithVisual() {
        if (!(this instanceof Clothing) && !(this instanceof InventoryContainer)) {
            return;
        }
        ItemVisual itemVisual = this.getVisual();
        if (itemVisual == null) {
            return;
        }
        if (this instanceof Clothing && this.getBloodClothingType() != null) {
            BloodClothingType.calcTotalBloodLevel((Clothing)this);
        }
        ClothingItem clothingItem = this.getClothingItem();
        if (clothingItem.m_AllowRandomTint) {
            this.setColor(new Color(itemVisual.m_Tint.r, itemVisual.m_Tint.g, itemVisual.m_Tint.b));
        } else {
            this.setColor(new Color(this.getColorRed(), this.getColorGreen(), this.getColorBlue()));
        }
        if (clothingItem.m_BaseTextures.size() <= 1 && itemVisual.m_TextureChoice <= -1 || this.getIconsForTexture() == null) {
            return;
        }
        String string = null;
        if (itemVisual.m_BaseTexture > -1 && this.getIconsForTexture().size() > itemVisual.m_BaseTexture) {
            string = this.getIconsForTexture().get(itemVisual.m_BaseTexture);
        } else if (itemVisual.m_TextureChoice > -1 && this.getIconsForTexture().size() > itemVisual.m_TextureChoice) {
            string = this.getIconsForTexture().get(itemVisual.m_TextureChoice);
        }
        if (StringUtils.isNullOrWhitespace(string)) {
            return;
        }
        this.texture = Texture.trygetTexture("Item_" + string);
        if (this.texture == null) {
            this.texture = Texture.getSharedTexture("media/inventory/Question_On.png");
        }
    }

    public int getContainerX() {
        return this.containerX;
    }

    public void setContainerX(int n) {
        this.containerX = n;
    }

    public int getContainerY() {
        return this.containerY;
    }

    public void setContainerY(int n) {
        this.containerY = n;
    }

    public boolean isDisappearOnUse() {
        return this.getScriptItem().isDisappearOnUse();
    }

    public String getName() {
        if (this.isBroken()) {
            return Translator.getText("IGUI_ItemNaming", this.brokenString, this.name);
        }
        if (this.isTaintedWater() && SandboxOptions.instance.EnableTaintedWaterText.getValue()) {
            return Translator.getText("IGUI_ItemNameTaintedWater", this.name);
        }
        if (this.getRemoteControlID() != -1) {
            return Translator.getText("IGUI_ItemNameControllerLinked", this.name);
        }
        if (this.getMechanicType() > 0) {
            return Translator.getText("IGUI_ItemNameMechanicalType", this.name, Translator.getText("IGUI_VehicleType_" + this.getMechanicType()));
        }
        return this.name;
    }

    public void setName(String string) {
        if (string.length() > 256) {
            string = string.substring(0, Math.min(string.length(), 256));
        }
        this.name = string;
    }

    public String getReplaceOnUse() {
        return this.replaceOnUse;
    }

    public void setReplaceOnUse(String string) {
        this.replaceOnUse = string;
        this.replaceOnUseFullType = StringUtils.moduleDotType(this.getModule(), string);
    }

    public String getReplaceOnUseFullType() {
        return this.replaceOnUseFullType;
    }

    public int getConditionMax() {
        return this.ConditionMax;
    }

    public void setConditionMax(int n) {
        this.ConditionMax = n;
    }

    public ItemContainer getRightClickContainer() {
        return this.rightClickContainer;
    }

    public void setRightClickContainer(ItemContainer itemContainer) {
        this.rightClickContainer = itemContainer;
    }

    public String getSwingAnim() {
        return this.getScriptItem().SwingAnim;
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture = texture;
    }

    public Texture getTexturerotten() {
        return this.texturerotten;
    }

    public void setTexturerotten(Texture texture) {
        this.texturerotten = texture;
    }

    public Texture getTextureCooked() {
        return this.textureCooked;
    }

    public void setTextureCooked(Texture texture) {
        this.textureCooked = texture;
    }

    public Texture getTextureBurnt() {
        return this.textureBurnt;
    }

    public void setTextureBurnt(Texture texture) {
        this.textureBurnt = texture;
    }

    public void setType(String string) {
        this.type = string;
        this.fullType = this.module + "." + string;
    }

    public int getCurrentUses() {
        return this.uses;
    }

    @Deprecated
    public int getUses() {
        return 1;
    }

    @Deprecated
    public void setUses(int n) {
    }

    public float getAge() {
        return this.Age;
    }

    public void setAge(float f) {
        this.Age = f;
    }

    public float getLastAged() {
        return this.LastAged;
    }

    public void setLastAged(float f) {
        this.LastAged = f;
    }

    public void updateAge() {
    }

    public void setAutoAge() {
    }

    public boolean isIsCookable() {
        return this.IsCookable;
    }

    public boolean isCookable() {
        return this.IsCookable;
    }

    public void setIsCookable(boolean bl) {
        this.IsCookable = bl;
    }

    public float getCookingTime() {
        return this.CookingTime;
    }

    public void setCookingTime(float f) {
        this.CookingTime = f;
    }

    public float getMinutesToCook() {
        return this.MinutesToCook;
    }

    public void setMinutesToCook(float f) {
        this.MinutesToCook = f;
    }

    public float getMinutesToBurn() {
        return this.MinutesToBurn;
    }

    public void setMinutesToBurn(float f) {
        this.MinutesToBurn = f;
    }

    public boolean isCooked() {
        return this.Cooked;
    }

    public void setCooked(boolean bl) {
        this.Cooked = bl;
    }

    public boolean isBurnt() {
        return this.Burnt;
    }

    public void setBurnt(boolean bl) {
        this.Burnt = bl;
    }

    public int getOffAge() {
        return this.OffAge;
    }

    public void setOffAge(int n) {
        this.OffAge = n;
    }

    public int getOffAgeMax() {
        return this.OffAgeMax;
    }

    public void setOffAgeMax(int n) {
        this.OffAgeMax = n;
    }

    public float getWeight() {
        return this.Weight;
    }

    public void setWeight(float f) {
        this.Weight = f;
    }

    public float getActualWeight() {
        if (this.getDisplayName().equals(this.getFullType())) {
            return 0.0f;
        }
        return this.ActualWeight;
    }

    public void setActualWeight(float f) {
        this.ActualWeight = f;
    }

    public String getWorldTexture() {
        return this.WorldTexture;
    }

    public void setWorldTexture(String string) {
        this.WorldTexture = string;
    }

    public String getDescription() {
        return this.Description;
    }

    public void setDescription(String string) {
        this.Description = string;
    }

    public int getCondition() {
        return this.Condition;
    }

    public void setCondition(int n, boolean bl) {
        n = Math.max(0, n);
        if (this.Condition > 0 && n <= 0 && bl && this.getBreakSound() != null && !this.getBreakSound().isEmpty() && IsoPlayer.getInstance() != null) {
            IsoPlayer.getInstance().playSound(this.getBreakSound());
        }
        this.Condition = n;
        this.setBroken(n <= 0);
    }

    public void setCondition(int n) {
        this.setCondition(n, true);
    }

    public String getOffString() {
        return this.OffString;
    }

    public void setOffString(String string) {
        this.OffString = string;
    }

    public String getCookedString() {
        return this.CookedString;
    }

    public void setCookedString(String string) {
        this.CookedString = string;
    }

    public String getUnCookedString() {
        return this.UnCookedString;
    }

    public void setUnCookedString(String string) {
        this.UnCookedString = string;
    }

    public String getBurntString() {
        return this.BurntString;
    }

    public void setBurntString(String string) {
        this.BurntString = string;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String string) {
        this.module = string;
        this.fullType = string + "." + this.type;
    }

    public boolean isAlwaysWelcomeGift() {
        return this.getScriptItem().isAlwaysWelcomeGift();
    }

    public boolean isCanBandage() {
        return this.getScriptItem().isCanBandage();
    }

    public float getBoredomChange() {
        return this.boredomChange;
    }

    public void setBoredomChange(float f) {
        this.boredomChange = f;
    }

    public float getUnhappyChange() {
        return this.unhappyChange;
    }

    public void setUnhappyChange(float f) {
        this.unhappyChange = f;
    }

    public float getStressChange() {
        return this.stressChange;
    }

    public void setStressChange(float f) {
        this.stressChange = f;
    }

    public ArrayList<String> getTags() {
        return this.ScriptItem.getTags();
    }

    public boolean hasTag(String string) {
        ArrayList<String> arrayList = this.getTags();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!arrayList.get(i).equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<IsoObject> getTaken() {
        return this.Taken;
    }

    public void setTaken(ArrayList<IsoObject> arrayList) {
        this.Taken = arrayList;
    }

    public IsoDirections getPlaceDir() {
        return this.placeDir;
    }

    public void setPlaceDir(IsoDirections isoDirections) {
        this.placeDir = isoDirections;
    }

    public IsoDirections getNewPlaceDir() {
        return this.newPlaceDir;
    }

    public void setNewPlaceDir(IsoDirections isoDirections) {
        this.newPlaceDir = isoDirections;
    }

    public void setReplaceOnUseOn(String string) {
        this.ReplaceOnUseOn = string;
    }

    public String getReplaceOnUseOn() {
        return this.ReplaceOnUseOn;
    }

    public String getReplaceOnUseOnString() {
        Object object = this.getReplaceOnUseOn();
        if (((String)object).split("-")[0].trim().contains("WaterSource")) {
            object = ((String)object).split("-")[1];
            String string = object;
            if (!((String)object).contains(".")) {
                object = this.getModule() + "." + string;
            }
        }
        return object;
    }

    public String getReplaceTypes() {
        return this.getScriptItem().getReplaceTypes();
    }

    public HashMap<String, String> getReplaceTypesMap() {
        return this.getScriptItem().getReplaceTypesMap();
    }

    public String getReplaceType(String string) {
        return this.getScriptItem().getReplaceType(string);
    }

    public boolean hasReplaceType(String string) {
        return this.getScriptItem().hasReplaceType(string);
    }

    public void setIsWaterSource(boolean bl) {
        this.IsWaterSource = bl;
    }

    public boolean isWaterSource() {
        return this.IsWaterSource;
    }

    boolean CanStackNoTemp(InventoryItem inventoryItem) {
        return false;
    }

    public void CopyModData(KahluaTable kahluaTable) {
        this.copyModData(kahluaTable);
    }

    public void copyModData(KahluaTable kahluaTable) {
        if (this.table != null) {
            this.table.wipe();
        }
        if (kahluaTable == null) {
            return;
        }
        LuaManager.copyTable(this.getModData(), kahluaTable);
    }

    public int getCount() {
        return this.Count;
    }

    public void setCount(int n) {
        this.Count = n;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated(boolean bl) {
        this.activated = bl;
        if (this.canEmitLight() && GameClient.bClient && this.getEquipParent() != null) {
            if (this.getEquipParent().getPrimaryHandItem() == this) {
                this.getEquipParent().reportEvent("EventSetActivatedPrimary");
            } else if (this.getEquipParent().getSecondaryHandItem() == this) {
                this.getEquipParent().reportEvent("EventSetActivatedSecondary");
            }
        }
    }

    public void setActivatedRemote(boolean bl) {
        this.activated = bl;
    }

    public void setCanBeActivated(boolean bl) {
        this.canBeActivated = bl;
    }

    public boolean canBeActivated() {
        return this.canBeActivated;
    }

    public void setLightStrength(float f) {
        this.lightStrength = f;
    }

    public float getLightStrength() {
        return this.lightStrength;
    }

    public boolean isTorchCone() {
        return this.isTorchCone;
    }

    public void setTorchCone(boolean bl) {
        this.isTorchCone = bl;
    }

    public float getTorchDot() {
        return this.getScriptItem().torchDot;
    }

    public int getLightDistance() {
        return this.lightDistance;
    }

    public void setLightDistance(int n) {
        this.lightDistance = n;
    }

    public boolean canEmitLight() {
        if (this.getLightStrength() <= 0.0f) {
            return false;
        }
        Drainable drainable = Type.tryCastTo(this, Drainable.class);
        return drainable == null || !(drainable.getUsedDelta() <= 0.0f);
    }

    public boolean isEmittingLight() {
        if (!this.canEmitLight()) {
            return false;
        }
        return !this.canBeActivated() || this.isActivated();
    }

    public boolean canStoreWater() {
        return this.CanStoreWater;
    }

    public float getFatigueChange() {
        return this.fatigueChange;
    }

    public void setFatigueChange(float f) {
        this.fatigueChange = f;
    }

    public float getCurrentCondition() {
        Float f = Float.valueOf((float)this.Condition / (float)this.ConditionMax);
        f = Float.valueOf(f.floatValue() * 100.0f);
        return f.floatValue();
    }

    public void setColor(Color color) {
        this.col = color;
    }

    public Color getColor() {
        return this.col;
    }

    public ColorInfo getColorInfo() {
        return new ColorInfo(this.col.getRedFloat(), this.col.getGreenFloat(), this.col.getBlueFloat(), this.col.getAlphaFloat());
    }

    public boolean isTwoHandWeapon() {
        return this.getScriptItem().TwoHandWeapon;
    }

    public String getCustomMenuOption() {
        return this.customMenuOption;
    }

    public void setCustomMenuOption(String string) {
        this.customMenuOption = string;
    }

    public void setTooltip(String string) {
        this.tooltip = string;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getDisplayCategory() {
        return this.displayCategory;
    }

    public void setDisplayCategory(String string) {
        this.displayCategory = string;
    }

    public int getHaveBeenRepaired() {
        return this.haveBeenRepaired;
    }

    public void setHaveBeenRepaired(int n) {
        this.haveBeenRepaired = n;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean bl) {
        this.broken = bl;
    }

    public String getDisplayName() {
        return this.name;
    }

    public boolean isTrap() {
        return this.getScriptItem().Trap;
    }

    public void addExtraItem(String string) {
        if (this.extraItems == null) {
            this.extraItems = new ArrayList();
        }
        this.extraItems.add(string);
    }

    public boolean haveExtraItems() {
        return this.extraItems != null;
    }

    public ArrayList<String> getExtraItems() {
        return this.extraItems;
    }

    public float getExtraItemsWeight() {
        if (!this.haveExtraItems()) {
            return 0.0f;
        }
        float f = 0.0f;
        for (int i = 0; i < this.extraItems.size(); ++i) {
            InventoryItem inventoryItem = InventoryItemFactory.CreateItem(this.extraItems.get(i));
            f += inventoryItem.getActualWeight();
        }
        return f *= 0.6f;
    }

    public boolean isCustomName() {
        return this.customName;
    }

    public void setCustomName(boolean bl) {
        this.customName = bl;
    }

    public boolean isFishingLure() {
        return this.getScriptItem().FishingLure;
    }

    public void copyConditionModData(InventoryItem inventoryItem) {
        if (inventoryItem.hasModData()) {
            KahluaTableIterator kahluaTableIterator = inventoryItem.getModData().iterator();
            while (kahluaTableIterator.advance()) {
                if (!(kahluaTableIterator.getKey() instanceof String) || !((String)kahluaTableIterator.getKey()).startsWith("condition:")) continue;
                this.getModData().rawset(kahluaTableIterator.getKey(), kahluaTableIterator.getValue());
            }
        }
    }

    public void setConditionFromModData(InventoryItem inventoryItem) {
        Object object;
        if (inventoryItem.hasModData() && (object = inventoryItem.getModData().rawget("condition:" + this.getType())) != null && object instanceof Double) {
            this.setCondition((int)Math.round((Double)object * (double)this.getConditionMax()));
        }
    }

    public String getBreakSound() {
        return this.breakSound;
    }

    public void setBreakSound(String string) {
        this.breakSound = string;
    }

    public String getPlaceOneSound() {
        return this.getScriptItem().getPlaceOneSound();
    }

    public String getPlaceMultipleSound() {
        return this.getScriptItem().getPlaceMultipleSound();
    }

    public String getSoundByID(String string) {
        return this.getScriptItem().getSoundByID(string);
    }

    public void setBeingFilled(boolean bl) {
        this.beingFilled = bl;
    }

    public boolean isBeingFilled() {
        return this.beingFilled;
    }

    public String getFillFromDispenserSound() {
        return this.getScriptItem().getFillFromDispenserSound();
    }

    public String getFillFromTapSound() {
        return this.getScriptItem().getFillFromTapSound();
    }

    public boolean isAlcoholic() {
        return this.alcoholic;
    }

    public void setAlcoholic(boolean bl) {
        this.alcoholic = bl;
    }

    public float getAlcoholPower() {
        return this.alcoholPower;
    }

    public void setAlcoholPower(float f) {
        this.alcoholPower = f;
    }

    public float getBandagePower() {
        return this.bandagePower;
    }

    public void setBandagePower(float f) {
        this.bandagePower = f;
    }

    public float getReduceInfectionPower() {
        return this.ReduceInfectionPower;
    }

    public void setReduceInfectionPower(float f) {
        this.ReduceInfectionPower = f;
    }

    public final void saveWithSize(ByteBuffer byteBuffer, boolean bl) throws IOException {
        int n = byteBuffer.position();
        byteBuffer.putInt(0);
        int n2 = byteBuffer.position();
        this.save(byteBuffer, bl);
        int n3 = byteBuffer.position();
        byteBuffer.position(n);
        byteBuffer.putInt(n3 - n2);
        byteBuffer.position(n3);
    }

    public boolean isCustomWeight() {
        return this.customWeight;
    }

    public void setCustomWeight(boolean bl) {
        this.customWeight = bl;
    }

    public float getContentsWeight() {
        Item item;
        if (!StringUtils.isNullOrEmpty(this.getAmmoType()) && (item = ScriptManager.instance.FindItem(this.getAmmoType())) != null) {
            return item.getActualWeight() * (float)this.getCurrentAmmoCount();
        }
        return 0.0f;
    }

    public float getHotbarEquippedWeight() {
        return (this.getActualWeight() + this.getContentsWeight()) * 0.7f;
    }

    public float getEquippedWeight() {
        return (this.getActualWeight() + this.getContentsWeight()) * 0.3f;
    }

    public float getUnequippedWeight() {
        return this.getActualWeight() + this.getContentsWeight();
    }

    public boolean isEquipped() {
        if (this.getContainer() != null && this.getContainer().getParent() instanceof IsoGameCharacter) {
            return ((IsoGameCharacter)this.getContainer().getParent()).isEquipped(this);
        }
        return false;
    }

    public int getKeyId() {
        return this.keyId;
    }

    public void setKeyId(int n) {
        this.keyId = n;
    }

    public boolean isTaintedWater() {
        return this.taintedWater;
    }

    public void setTaintedWater(boolean bl) {
        this.taintedWater = bl;
    }

    public boolean isRemoteController() {
        return this.remoteController;
    }

    public void setRemoteController(boolean bl) {
        this.remoteController = bl;
    }

    public boolean canBeRemote() {
        return this.canBeRemote;
    }

    public void setCanBeRemote(boolean bl) {
        this.canBeRemote = bl;
    }

    public int getRemoteControlID() {
        return this.remoteControlID;
    }

    public void setRemoteControlID(int n) {
        this.remoteControlID = n;
    }

    public int getRemoteRange() {
        return this.remoteRange;
    }

    public void setRemoteRange(int n) {
        this.remoteRange = n;
    }

    public String getExplosionSound() {
        return this.explosionSound;
    }

    public void setExplosionSound(String string) {
        this.explosionSound = string;
    }

    public String getCountDownSound() {
        return this.countDownSound;
    }

    public void setCountDownSound(String string) {
        this.countDownSound = string;
    }

    public float getColorRed() {
        return this.colorRed;
    }

    public void setColorRed(float f) {
        this.colorRed = f;
    }

    public float getColorGreen() {
        return this.colorGreen;
    }

    public void setColorGreen(float f) {
        this.colorGreen = f;
    }

    public float getColorBlue() {
        return this.colorBlue;
    }

    public void setColorBlue(float f) {
        this.colorBlue = f;
    }

    public String getEvolvedRecipeName() {
        return this.evolvedRecipeName;
    }

    public void setEvolvedRecipeName(String string) {
        this.evolvedRecipeName = string;
    }

    public float getMetalValue() {
        return this.metalValue;
    }

    public void setMetalValue(float f) {
        this.metalValue = f;
    }

    public float getItemHeat() {
        return this.itemHeat;
    }

    public void setItemHeat(float f) {
        if (f > 2.0f) {
            f = 2.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.itemHeat = f;
    }

    public float getInvHeat() {
        return 1.0f - this.itemHeat;
    }

    public float getMeltingTime() {
        return this.meltingTime;
    }

    public void setMeltingTime(float f) {
        if (f > 100.0f) {
            f = 100.0f;
        }
        if (f < 0.0f) {
            f = 0.0f;
        }
        this.meltingTime = f;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String string) {
        this.worker = string;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int n) {
        this.id = n;
    }

    public boolean isWet() {
        return this.isWet;
    }

    public void setWet(boolean bl) {
        this.isWet = bl;
    }

    public float getWetCooldown() {
        return this.wetCooldown;
    }

    public void setWetCooldown(float f) {
        this.wetCooldown = f;
    }

    public String getItemWhenDry() {
        return this.itemWhenDry;
    }

    public void setItemWhenDry(String string) {
        this.itemWhenDry = string;
    }

    public boolean isFavorite() {
        return this.favorite;
    }

    public void setFavorite(boolean bl) {
        this.favorite = bl;
    }

    public ArrayList<String> getRequireInHandOrInventory() {
        return this.requireInHandOrInventory;
    }

    public void setRequireInHandOrInventory(ArrayList<String> arrayList) {
        this.requireInHandOrInventory = arrayList;
    }

    public boolean isCustomColor() {
        return this.customColor;
    }

    public void setCustomColor(boolean bl) {
        this.customColor = bl;
    }

    public void doBuildingStash() {
        if (this.stashMap != null) {
            if (GameClient.bClient) {
                GameClient.sendBuildingStashToDo(this.stashMap);
            } else {
                StashSystem.prepareBuildingStash(this.stashMap);
            }
        }
    }

    public void setStashMap(String string) {
        this.stashMap = string;
    }

    public int getMechanicType() {
        return this.getScriptItem().vehicleType;
    }

    public float getItemCapacity() {
        return this.itemCapacity;
    }

    public void setItemCapacity(float f) {
        this.itemCapacity = f;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int n) {
        this.maxCapacity = n;
    }

    public boolean isConditionAffectsCapacity() {
        return this.ScriptItem != null && this.ScriptItem.isConditionAffectsCapacity();
    }

    public float getBrakeForce() {
        return this.brakeForce;
    }

    public void setBrakeForce(float f) {
        this.brakeForce = f;
    }

    public int getChanceToSpawnDamaged() {
        return this.chanceToSpawnDamaged;
    }

    public void setChanceToSpawnDamaged(int n) {
        this.chanceToSpawnDamaged = n;
    }

    public float getConditionLowerNormal() {
        return this.conditionLowerNormal;
    }

    public void setConditionLowerNormal(float f) {
        this.conditionLowerNormal = f;
    }

    public float getConditionLowerOffroad() {
        return this.conditionLowerOffroad;
    }

    public void setConditionLowerOffroad(float f) {
        this.conditionLowerOffroad = f;
    }

    public float getWheelFriction() {
        return this.wheelFriction;
    }

    public void setWheelFriction(float f) {
        this.wheelFriction = f;
    }

    public float getSuspensionDamping() {
        return this.suspensionDamping;
    }

    public void setSuspensionDamping(float f) {
        this.suspensionDamping = f;
    }

    public float getSuspensionCompression() {
        return this.suspensionCompression;
    }

    public void setSuspensionCompression(float f) {
        this.suspensionCompression = f;
    }

    public void setInfected(boolean bl) {
        this.zombieInfected = bl;
    }

    public boolean isInfected() {
        return this.zombieInfected;
    }

    public float getEngineLoudness() {
        return this.engineLoudness;
    }

    public void setEngineLoudness(float f) {
        this.engineLoudness = f;
    }

    public String getStaticModel() {
        return this.getScriptItem().getStaticModel();
    }

    public ArrayList<String> getIconsForTexture() {
        return this.iconsForTexture;
    }

    public void setIconsForTexture(ArrayList<String> arrayList) {
        this.iconsForTexture = arrayList;
    }

    public float getScore(SurvivorDesc survivorDesc) {
        return 0.0f;
    }

    public IsoGameCharacter getPreviousOwner() {
        return this.previousOwner;
    }

    public void setPreviousOwner(IsoGameCharacter isoGameCharacter) {
        this.previousOwner = isoGameCharacter;
    }

    public Item getScriptItem() {
        return this.ScriptItem;
    }

    public void setScriptItem(Item item) {
        this.ScriptItem = item;
    }

    public ItemType getCat() {
        return this.cat;
    }

    public void setCat(ItemType itemType) {
        this.cat = itemType;
    }

    public ItemContainer getContainer() {
        return this.container;
    }

    public void setContainer(ItemContainer itemContainer) {
        this.container = itemContainer;
    }

    public ArrayList<BloodClothingType> getBloodClothingType() {
        return this.bloodClothingType;
    }

    public void setBloodClothingType(ArrayList<BloodClothingType> arrayList) {
        this.bloodClothingType = arrayList;
    }

    public void setBlood(BloodBodyPartType bloodBodyPartType, float f) {
        ItemVisual itemVisual = this.getVisual();
        if (itemVisual != null) {
            itemVisual.setBlood(bloodBodyPartType, f);
        }
    }

    public float getBlood(BloodBodyPartType bloodBodyPartType) {
        ItemVisual itemVisual = this.getVisual();
        if (itemVisual != null) {
            return itemVisual.getBlood(bloodBodyPartType);
        }
        return 0.0f;
    }

    public void setDirt(BloodBodyPartType bloodBodyPartType, float f) {
        ItemVisual itemVisual = this.getVisual();
        if (itemVisual != null) {
            itemVisual.setDirt(bloodBodyPartType, f);
        }
    }

    public float getDirt(BloodBodyPartType bloodBodyPartType) {
        ItemVisual itemVisual = this.getVisual();
        if (itemVisual != null) {
            return itemVisual.getDirt(bloodBodyPartType);
        }
        return 0.0f;
    }

    public String getClothingItemName() {
        return this.getScriptItem().ClothingItem;
    }

    public int getStashChance() {
        return this.stashChance;
    }

    public void setStashChance(int n) {
        this.stashChance = n;
    }

    public String getEatType() {
        return this.getScriptItem().eatType;
    }

    public boolean isUseWorldItem() {
        return this.getScriptItem().UseWorldItem;
    }

    public boolean isHairDye() {
        return this.getScriptItem().hairDye;
    }

    public String getAmmoType() {
        return this.ammoType;
    }

    public void setAmmoType(String string) {
        this.ammoType = string;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public void setMaxAmmo(int n) {
        this.maxAmmo = n;
    }

    public int getCurrentAmmoCount() {
        return this.currentAmmoCount;
    }

    public void setCurrentAmmoCount(int n) {
        this.currentAmmoCount = n;
    }

    public String getGunType() {
        return this.gunType;
    }

    public void setGunType(String string) {
        this.gunType = string;
    }

    public boolean hasBlood() {
        if (this instanceof Clothing) {
            if (this.getBloodClothingType() == null || this.getBloodClothingType().isEmpty()) {
                return false;
            }
            ArrayList<BloodBodyPartType> arrayList = BloodClothingType.getCoveredParts(this.getBloodClothingType());
            if (arrayList == null) {
                return false;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(this.getBlood(arrayList.get(i)) > 0.0f)) continue;
                return true;
            }
        } else {
            if (this instanceof HandWeapon) {
                return ((HandWeapon)this).getBloodLevel() > 0.0f;
            }
            if (this instanceof InventoryContainer) {
                return ((InventoryContainer)this).getBloodLevel() > 0.0f;
            }
        }
        return false;
    }

    public boolean hasDirt() {
        if (this instanceof Clothing) {
            if (this.getBloodClothingType() == null || this.getBloodClothingType().isEmpty()) {
                return false;
            }
            ArrayList<BloodBodyPartType> arrayList = BloodClothingType.getCoveredParts(this.getBloodClothingType());
            if (arrayList == null) {
                return false;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                if (!(this.getDirt(arrayList.get(i)) > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(String string) {
        this.attachmentType = string;
    }

    public int getAttachedSlot() {
        return this.attachedSlot;
    }

    public void setAttachedSlot(int n) {
        this.attachedSlot = n;
    }

    public ArrayList<String> getAttachmentsProvided() {
        return this.attachmentsProvided;
    }

    public void setAttachmentsProvided(ArrayList<String> arrayList) {
        this.attachmentsProvided = arrayList;
    }

    public String getAttachedSlotType() {
        return this.attachedSlotType;
    }

    public void setAttachedSlotType(String string) {
        this.attachedSlotType = string;
    }

    public String getAttachmentReplacement() {
        return this.attachmentReplacement;
    }

    public void setAttachmentReplacement(String string) {
        this.attachmentReplacement = string;
    }

    public String getAttachedToModel() {
        return this.attachedToModel;
    }

    public void setAttachedToModel(String string) {
        this.attachedToModel = string;
    }

    public String getFabricType() {
        return this.getScriptItem().fabricType;
    }

    public String getStringItemType() {
        Item item = ScriptManager.instance.FindItem(this.getFullType());
        if (item == null || item.getType() == null) {
            return "Other";
        }
        if (item.getType() == Item.Type.Food) {
            if (item.CannedFood) {
                return "CannedFood";
            }
            return "Food";
        }
        if ("Ammo".equals(item.getDisplayCategory())) {
            return "Ammo";
        }
        if (item.getType() == Item.Type.Weapon && !item.isRanged()) {
            return "MeleeWeapon";
        }
        if (item.getType() == Item.Type.WeaponPart || item.getType() == Item.Type.Weapon && item.isRanged() || item.getType() == Item.Type.Normal && !StringUtils.isNullOrEmpty(item.getAmmoType())) {
            return "RangedWeapon";
        }
        if (item.getType() == Item.Type.Literature) {
            return "Literature";
        }
        if (item.Medical) {
            return "Medical";
        }
        if (item.SurvivalGear) {
            return "SurvivalGear";
        }
        if (item.MechanicsItem) {
            return "Mechanic";
        }
        return "Other";
    }

    public boolean isProtectFromRainWhileEquipped() {
        return this.getScriptItem().ProtectFromRainWhenEquipped;
    }

    public boolean isEquippedNoSprint() {
        return this.getScriptItem().equippedNoSprint;
    }

    public String getBodyLocation() {
        return this.getScriptItem().BodyLocation;
    }

    public String getMakeUpType() {
        return this.getScriptItem().makeUpType;
    }

    public boolean isHidden() {
        return this.getScriptItem().isHidden();
    }

    public String getConsolidateOption() {
        return this.getScriptItem().consolidateOption;
    }

    public ArrayList<String> getClothingItemExtra() {
        return this.getScriptItem().clothingItemExtra;
    }

    public ArrayList<String> getClothingItemExtraOption() {
        return this.getScriptItem().clothingItemExtraOption;
    }

    public String getWorldStaticItem() {
        if (this.getModData().rawget("Flatpack") == "true") {
            return "Flatpack";
        }
        return this.getScriptItem().worldStaticModel;
    }

    public void setRegistry_id(Item item) {
        if (item.getFullName().equals(this.getFullType())) {
            this.registry_id = item.getRegistry_id();
        } else if (Core.bDebug) {
            WorldDictionary.DebugPrintItem(item);
            throw new RuntimeException("These types should always match");
        }
    }

    public short getRegistry_id() {
        return this.registry_id;
    }

    public String getModID() {
        if (this.ScriptItem != null && this.ScriptItem.getModID() != null) {
            return this.ScriptItem.getModID();
        }
        return WorldDictionary.getItemModID(this.registry_id);
    }

    public String getModName() {
        return WorldDictionary.getModNameFromID(this.getModID());
    }

    public boolean isVanilla() {
        if (this.getModID() != null) {
            return this.getModID().equals("pz-vanilla");
        }
        if (Core.bDebug) {
            WorldDictionary.DebugPrintItem(this);
            throw new RuntimeException("Item has no modID?");
        }
        return true;
    }

    public short getRecordedMediaIndex() {
        return this.recordedMediaIndex;
    }

    public void setRecordedMediaIndex(short s) {
        this.recordedMediaIndex = s;
        if (this.recordedMediaIndex >= 0) {
            MediaData mediaData = ZomboidRadio.getInstance().getRecordedMedia().getMediaDataFromIndex(this.recordedMediaIndex);
            this.mediaType = (byte)-1;
            if (mediaData != null) {
                this.name = mediaData.getTranslatedItemDisplayName();
                this.mediaType = mediaData.getMediaType();
            } else {
                this.recordedMediaIndex = (short)-1;
            }
        } else {
            this.mediaType = (byte)-1;
            this.name = this.getScriptItem().getDisplayName();
        }
    }

    public void setRecordedMediaIndexInteger(int n) {
        this.setRecordedMediaIndex((short)n);
    }

    public boolean isRecordedMedia() {
        return this.recordedMediaIndex >= 0;
    }

    public MediaData getMediaData() {
        if (this.isRecordedMedia()) {
            return ZomboidRadio.getInstance().getRecordedMedia().getMediaDataFromIndex(this.recordedMediaIndex);
        }
        return null;
    }

    public byte getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(byte by) {
        this.mediaType = by;
    }

    public void setRecordedMediaData(MediaData mediaData) {
        if (mediaData != null && mediaData.getIndex() >= 0) {
            this.setRecordedMediaIndex(mediaData.getIndex());
        }
    }

    public void setWorldZRotation(int n) {
        this.worldZRotation = n;
    }

    public void setWorldScale(float f) {
        this.worldScale = f;
    }

    public String getLuaCreate() {
        return this.getScriptItem().getLuaCreate();
    }

    public boolean isInitialised() {
        return this.isInitialised;
    }

    public void setInitialised(boolean bl) {
        this.isInitialised = bl;
    }

    public void initialiseItem() {
        Object object;
        this.setInitialised(true);
        if (this.getLuaCreate() != null && (object = LuaManager.getFunctionObject(this.getLuaCreate())) != null) {
            LuaManager.caller.protectedCallVoid(LuaManager.thread, object, this);
        }
    }

    public String getSoundParameter(String string) {
        return this.getScriptItem().getSoundParameter(string);
    }
}

