/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import zombie.characters.IsoGameCharacter;
import zombie.inventory.InventoryItem;

public final class CompressIdenticalItems {
    private static final int BLOCK_SIZE = 1024;
    private static final ThreadLocal<PerThreadData> perThreadVars = new ThreadLocal<PerThreadData>(){

        @Override
        protected PerThreadData initialValue() {
            return new PerThreadData();
        }
    };

    private static int bufferSize(int n) {
        return (n + 1024 - 1) / 1024 * 1024;
    }

    private static ByteBuffer ensureCapacity(ByteBuffer byteBuffer, int n) {
        if (byteBuffer == null || byteBuffer.capacity() < n) {
            byteBuffer = ByteBuffer.allocate(CompressIdenticalItems.bufferSize(n));
        }
        return byteBuffer;
    }

    private static ByteBuffer ensureCapacity(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return ByteBuffer.allocate(1024);
        }
        if (byteBuffer.capacity() - byteBuffer.position() < 1024) {
            ByteBuffer byteBuffer2 = CompressIdenticalItems.ensureCapacity(null, byteBuffer.position() + 1024);
            return byteBuffer2.put(byteBuffer.array(), 0, byteBuffer.position());
        }
        ByteBuffer byteBuffer3 = CompressIdenticalItems.ensureCapacity(null, byteBuffer.capacity() + 1024);
        return byteBuffer3.put(byteBuffer.array(), 0, byteBuffer.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setCompareItem(PerThreadData perThreadData, InventoryItem inventoryItem) throws IOException {
        ByteBuffer byteBuffer = perThreadData.itemCompareBuffer;
        byteBuffer.clear();
        int n = inventoryItem.id;
        inventoryItem.id = 0;
        try {
            while (true) {
                try {
                    byteBuffer.putInt(0);
                    inventoryItem.save(byteBuffer, false);
                    int n2 = byteBuffer.position();
                    byteBuffer.position(0);
                    byteBuffer.putInt(n2);
                    byteBuffer.position(n2);
                }
                catch (BufferOverflowException bufferOverflowException) {
                    byteBuffer = CompressIdenticalItems.ensureCapacity(byteBuffer);
                    byteBuffer.clear();
                    perThreadData.itemCompareBuffer = byteBuffer;
                    continue;
                }
                break;
            }
        }
        finally {
            inventoryItem.id = n;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private static boolean areItemsIdentical(PerThreadData var0, InventoryItem var1_1, InventoryItem var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 7[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<InventoryItem> save(ByteBuffer byteBuffer, ArrayList<InventoryItem> arrayList, IsoGameCharacter isoGameCharacter) throws IOException {
        PerThreadData perThreadData = perThreadVars.get();
        PerCallData perCallData = perThreadData.allocSaveVars();
        HashMap<String, ArrayList<InventoryItem>> hashMap = perCallData.typeToItems;
        ArrayList<String> arrayList2 = perCallData.types;
        try {
            int n;
            int n2;
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                String string = arrayList.get(n2).getFullType();
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, perCallData.allocItemList());
                    arrayList2.add(string);
                }
                hashMap.get(string).add(arrayList.get(n2));
            }
            n2 = byteBuffer.position();
            byteBuffer.putShort((short)0);
            int n3 = 0;
            for (n = 0; n < arrayList2.size(); ++n) {
                ArrayList<InventoryItem> arrayList3 = hashMap.get(arrayList2.get(n));
                for (int i = 0; i < arrayList3.size(); ++i) {
                    InventoryItem inventoryItem = arrayList3.get(i);
                    perCallData.savedItems.add(inventoryItem);
                    int n4 = 1;
                    int n5 = i + 1;
                    if (isoGameCharacter == null || !isoGameCharacter.isEquipped(inventoryItem)) {
                        CompressIdenticalItems.setCompareItem(perThreadData, inventoryItem);
                        while (i + 1 < arrayList3.size() && CompressIdenticalItems.areItemsIdentical(perThreadData, inventoryItem, arrayList3.get(i + 1))) {
                            perCallData.savedItems.add(arrayList3.get(i + 1));
                            ++i;
                            ++n4;
                        }
                    }
                    byteBuffer.putInt(n4);
                    inventoryItem.saveWithSize(byteBuffer, false);
                    if (n4 > 1) {
                        for (int j = n5; j <= i; ++j) {
                            byteBuffer.putInt(arrayList3.get((int)j).id);
                        }
                    }
                    ++n3;
                }
            }
            n = byteBuffer.position();
            byteBuffer.position(n2);
            byteBuffer.putShort((short)n3);
            byteBuffer.position(n);
        }
        finally {
            perCallData.next = perThreadData.saveVars;
            perThreadData.saveVars = perCallData;
        }
        return perCallData.savedItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<InventoryItem> load(ByteBuffer byteBuffer, int n, ArrayList<InventoryItem> arrayList, ArrayList<InventoryItem> arrayList2) throws IOException {
        PerThreadData perThreadData = perThreadVars.get();
        PerCallData perCallData = perThreadData.allocSaveVars();
        if (arrayList != null) {
            arrayList.clear();
        }
        if (arrayList2 != null) {
            arrayList2.clear();
        }
        try {
            int n2 = byteBuffer.getShort();
            for (int i = 0; i < n2; ++i) {
                int n3;
                int n4;
                int n5 = 1;
                if (n >= 149) {
                    n5 = byteBuffer.getInt();
                } else if (n >= 128) {
                    n5 = byteBuffer.getShort();
                }
                int n6 = byteBuffer.position();
                InventoryItem inventoryItem = InventoryItem.loadItem(byteBuffer, n);
                if (inventoryItem == null) {
                    n4 = n5 > 1 ? (n5 - 1) * 4 : 0;
                    byteBuffer.position(byteBuffer.position() + n4);
                    for (n3 = 0; n3 < n5; ++n3) {
                        if (arrayList2 != null) {
                            arrayList2.add(null);
                        }
                        perCallData.savedItems.add(null);
                    }
                    continue;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    if (n4 > 0) {
                        byteBuffer.position(n6);
                        inventoryItem = InventoryItem.loadItem(byteBuffer, n);
                    }
                    if (arrayList != null) {
                        arrayList.add(inventoryItem);
                    }
                    if (arrayList2 != null) {
                        arrayList2.add(inventoryItem);
                    }
                    perCallData.savedItems.add(inventoryItem);
                }
                if (n < 128) continue;
                for (n4 = 1; n4 < n5; ++n4) {
                    n3 = byteBuffer.getInt();
                    inventoryItem = perCallData.savedItems.get(perCallData.savedItems.size() - n5 + n4);
                    if (inventoryItem == null) continue;
                    inventoryItem.id = n3;
                }
            }
        }
        finally {
            perCallData.next = perThreadData.saveVars;
            perThreadData.saveVars = perCallData;
        }
        return perCallData.savedItems;
    }

    public static void save(ByteBuffer byteBuffer, InventoryItem inventoryItem) throws IOException {
        byteBuffer.putShort((short)1);
        byteBuffer.putInt(1);
        inventoryItem.saveWithSize(byteBuffer, false);
    }

    private static class PerThreadData {
        PerCallData saveVars;
        ByteBuffer itemCompareBuffer = ByteBuffer.allocate(1024);

        private PerThreadData() {
        }

        PerCallData allocSaveVars() {
            if (this.saveVars == null) {
                return new PerCallData();
            }
            PerCallData perCallData = this.saveVars;
            perCallData.reset();
            this.saveVars = this.saveVars.next;
            return perCallData;
        }
    }

    private static class PerCallData {
        final ArrayList<String> types = new ArrayList();
        final HashMap<String, ArrayList<InventoryItem>> typeToItems = new HashMap();
        final ArrayDeque<ArrayList<InventoryItem>> itemLists = new ArrayDeque();
        final ArrayList<InventoryItem> savedItems = new ArrayList();
        PerCallData next;

        private PerCallData() {
        }

        void reset() {
            for (int i = 0; i < this.types.size(); ++i) {
                ArrayList<InventoryItem> arrayList = this.typeToItems.get(this.types.get(i));
                arrayList.clear();
                this.itemLists.push(arrayList);
            }
            this.types.clear();
            this.typeToItems.clear();
            this.savedItems.clear();
        }

        ArrayList<InventoryItem> allocItemList() {
            if (this.itemLists.isEmpty()) {
                return new ArrayList<InventoryItem>();
            }
            return this.itemLists.pop();
        }
    }
}

