/*
 * Decompiled with CFR 0.152.
 */
package zombie.inventory;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import zombie.ZomboidFileSystem;
import zombie.core.logger.ExceptionLogger;
import zombie.util.StringUtils;

public final class ClothingItemsDotTxt {
    public static final ClothingItemsDotTxt instance = new ClothingItemsDotTxt();
    private final StringBuilder buf = new StringBuilder();

    private int readBlock(String string, int n, Block block) {
        int n2;
        for (n2 = n; n2 < string.length(); ++n2) {
            Object object;
            Object object2;
            if (string.charAt(n2) == '{') {
                object2 = new Block();
                block.children.add((Block)object2);
                block.elements.add((BlockElement)object2);
                object = string.substring(n, n2).trim();
                int n3 = ((String)object).indexOf(32);
                int n4 = ((String)object).indexOf(9);
                int n5 = Math.max(n3, n4);
                if (n5 == -1) {
                    ((Block)object2).type = object;
                } else {
                    ((Block)object2).type = ((String)object).substring(0, n5);
                    ((Block)object2).id = ((String)object).substring(n5).trim();
                }
                n = n2 = this.readBlock(string, n2 + 1, (Block)object2);
                continue;
            }
            if (string.charAt(n2) == '}') {
                object2 = string.substring(n, n2).trim();
                if (!((String)object2).isEmpty()) {
                    object = new Value();
                    ((Value)object).string = string.substring(n, n2).trim();
                    block.values.add(((Value)object).string);
                    block.elements.add((BlockElement)object);
                }
                return n2 + 1;
            }
            if (string.charAt(n2) != ',') continue;
            object2 = new Value();
            ((Value)object2).string = string.substring(n, n2).trim();
            block.values.add(((Value)object2).string);
            block.elements.add((BlockElement)object2);
            n = n2 + 1;
        }
        return n2;
    }

    public void LoadFile() {
        Closeable closeable;
        Object object;
        int n;
        Object object2;
        String string = ZomboidFileSystem.instance.getString("media/scripts/clothingItems.txt");
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        try (FileReader fileReader = new FileReader(string);
             BufferedReader bufferedReader = new BufferedReader(fileReader);){
            this.buf.setLength(0);
            while ((object2 = bufferedReader.readLine()) != null) {
                this.buf.append((String)object2);
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
            return;
        }
        int n2 = this.buf.lastIndexOf("*/");
        while (n2 != -1 && (n = this.buf.lastIndexOf("/*", n2 - 1)) != -1) {
            int n3 = this.buf.lastIndexOf("*/", n2 - 1);
            while (n3 > n) {
                int n4 = n;
                object = this.buf.substring(n4, n3 + 2);
                if ((n = this.buf.lastIndexOf("/*", n - 2)) == -1) break;
                n3 = this.buf.lastIndexOf("*/", n4 - 2);
            }
            if (n == -1) break;
            String string2 = this.buf.substring(n, n2 + 2);
            this.buf.replace(n, n2 + 2, "");
            n2 = this.buf.lastIndexOf("*/", n);
        }
        Block block = new Block();
        this.readBlock(this.buf.toString(), 0, block);
        object2 = FileSystems.getDefault().getPath("media/clothing/clothingItems", new String[0]);
        try {
            closeable = Files.newDirectoryStream((Path)object2);
            try {
                object = closeable.iterator();
                while (object.hasNext()) {
                    String string3;
                    Path path = object.next();
                    if (Files.isDirectory(path, new LinkOption[0]) || !(string3 = path.getFileName().toString()).endsWith(".xml")) continue;
                    String string4 = StringUtils.trimSuffix(string3, ".xml");
                    System.out.println(string3 + " -> " + string4);
                    this.addClothingItem(string4, block.children.get(0));
                }
            }
            finally {
                if (closeable != null) {
                    closeable.close();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            closeable = new FileWriter(file);
            try {
                ((Writer)closeable).write(block.children.get(0).toString());
            }
            finally {
                ((OutputStreamWriter)closeable).close();
            }
        }
        catch (Throwable throwable) {
            ExceptionLogger.logException(throwable);
        }
        System.out.println(block.children.get(0));
    }

    private void addClothingItem(String string, Block block) {
        BlockElement blockElement2;
        if (string.startsWith("FemaleHair_")) {
            return;
        }
        if (string.startsWith("MaleBeard_")) {
            return;
        }
        if (string.startsWith("MaleHair_")) {
            return;
        }
        if (string.startsWith("ZedDmg_")) {
            return;
        }
        if (string.startsWith("Bandage_")) {
            return;
        }
        if (string.startsWith("Zed_Skin")) {
            return;
        }
        for (BlockElement blockElement2 : block.children) {
            if (!"item".equals(blockElement2.type) || !string.equals(blockElement2.id)) continue;
            return;
        }
        Block block2 = new Block();
        block2.type = "item";
        block2.id = string;
        blockElement2 = new Value();
        ((Value)blockElement2).string = "Type = Clothing";
        block2.elements.add(blockElement2);
        block2.values.add(((Value)blockElement2).string);
        blockElement2 = new Value();
        ((Value)blockElement2).string = "DisplayName = " + string;
        block2.elements.add(blockElement2);
        block2.values.add(((Value)blockElement2).string);
        blockElement2 = new Value();
        ((Value)blockElement2).string = "ClothingItem = " + string;
        block2.elements.add(blockElement2);
        block2.values.add(((Value)blockElement2).string);
        block.elements.add(block2);
        block.children.add(block2);
    }

    private static class Block
    implements BlockElement {
        public String type;
        public String id;
        public ArrayList<BlockElement> elements = new ArrayList();
        public ArrayList<String> values = new ArrayList();
        public ArrayList<Block> children = new ArrayList();

        private Block() {
        }

        @Override
        public Block asBlock() {
            return this;
        }

        @Override
        public Value asValue() {
            return null;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.type + (String)(this.id == null ? "" : " " + this.id) + "\n");
            stringBuilder.append("{\n");
            for (BlockElement blockElement : this.elements) {
                String string = blockElement.toString();
                for (String string2 : string.split("\n")) {
                    stringBuilder.append("\t" + string2 + "\n");
                }
            }
            stringBuilder.append("}\n");
            return stringBuilder.toString();
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<Block type=\"" + this.type + "\" id=\"" + this.id + "\">\n");
            for (BlockElement blockElement : this.elements) {
                String string = blockElement.toXML();
                for (String string2 : string.split("\n")) {
                    stringBuilder.append("    " + string2 + "\n");
                }
            }
            stringBuilder.append("</Block>\n");
            return stringBuilder.toString();
        }
    }

    private static class Value
    implements BlockElement {
        String string;

        private Value() {
        }

        @Override
        public Block asBlock() {
            return null;
        }

        @Override
        public Value asValue() {
            return this;
        }

        public String toString() {
            return this.string + ",\n";
        }

        @Override
        public String toXML() {
            return "<Value>" + this.string + "</Value>\n";
        }
    }

    private static interface BlockElement {
        public Block asBlock();

        public Value asValue();

        public String toXML();
    }
}

