/*
 * Decompiled with CFR 0.152.
 */
package zombie.input;

import org.lwjglx.input.Mouse;

public final class MouseState {
    private boolean m_isCreated = false;
    private boolean[] m_buttonDownStates = null;
    private int m_mouseX = -1;
    private int m_mouseY = -1;
    private int m_wheelDelta = 0;
    private boolean m_wasPolled = false;

    public void poll() {
        int n = !this.m_isCreated ? 1 : 0;
        boolean bl = this.m_isCreated = this.m_isCreated || Mouse.isCreated();
        if (!this.m_isCreated) {
            return;
        }
        if (n != 0) {
            this.m_buttonDownStates = new boolean[Mouse.getButtonCount()];
        }
        this.m_mouseX = Mouse.getX();
        this.m_mouseY = Mouse.getY();
        this.m_wheelDelta = Mouse.getDWheel();
        this.m_wasPolled = true;
        for (n = 0; n < this.m_buttonDownStates.length; ++n) {
            this.m_buttonDownStates[n] = Mouse.isButtonDown(n);
        }
    }

    public boolean wasPolled() {
        return this.m_wasPolled;
    }

    public void set(MouseState mouseState) {
        this.m_isCreated = mouseState.m_isCreated;
        if (mouseState.m_buttonDownStates != null) {
            if (this.m_buttonDownStates == null || this.m_buttonDownStates.length != mouseState.m_buttonDownStates.length) {
                this.m_buttonDownStates = new boolean[mouseState.m_buttonDownStates.length];
            }
            System.arraycopy(mouseState.m_buttonDownStates, 0, this.m_buttonDownStates, 0, this.m_buttonDownStates.length);
        } else {
            this.m_buttonDownStates = null;
        }
        this.m_mouseX = mouseState.m_mouseX;
        this.m_mouseY = mouseState.m_mouseY;
        this.m_wheelDelta = mouseState.m_wheelDelta;
        this.m_wasPolled = mouseState.m_wasPolled;
    }

    public void reset() {
        this.m_wasPolled = false;
    }

    public boolean isCreated() {
        return this.m_isCreated;
    }

    public int getX() {
        return this.m_mouseX;
    }

    public int getY() {
        return this.m_mouseY;
    }

    public int getDWheel() {
        return this.m_wheelDelta;
    }

    public void resetDWheel() {
        this.m_wheelDelta = 0;
    }

    public boolean isButtonDown(int n) {
        if (n >= this.m_buttonDownStates.length) {
            return false;
        }
        return this.m_buttonDownStates[n];
    }

    public int getButtonCount() {
        return this.isCreated() ? this.m_buttonDownStates.length : 0;
    }

    public void setCursorPosition(int n, int n2) {
        Mouse.setCursorPosition(n, n2);
    }
}

